---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Understand how to read the changes proposed in a merge request.
title: マージリクエストを変更する
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

[マージリクエスト](_index.md)は、リポジトリ内のブランチにあるファイルに対する一連の変更を提案します。GitLabはこれらの変更を、現在の状態と提案された変更との_差分_（差異）として表示します。デフォルトでは、差分は提案された変更（ソースブランチ）とターゲットブランチを比較します。デフォルトでは、GitLabはファイルの変更された部分のみを表示します。

この例は、テキストファイルへの変更を示しています。デフォルトのハイライトした構文のテーマでは、次の通りとなっています。

- _現在_のバージョンは赤で表示され、行の先頭にマイナス（`-`）記号が表示されます。
- _提案_されたバージョンは緑色で表示され、行の先頭にプラス（`+`）記号が表示されます。

![ソースコード差分の例のスクリーンショット](img/mr_diff_example_v16_9.png)

差分の各ファイルのヘッダーには、次のものが含まれています。

- **ファイルの内容を非表示にする**（{{< icon name="chevron-down" >}}）: このファイルに対するすべての変更を非表示にします。
- **パス**: このファイルへのフルパス。このパスをコピーするには、**ファイルパスをコピー**（{{< icon name="copy-to-clipboard" >}}）を選択します。
- **Lines changed（変更された行）**: このファイルで追加および削除された行数。`+2 -2`の形式で表示されます。
- **閲覧済み**: このチェックボックスをオンにすると、ファイルが再度変更されるまで[ファイルが表示済みに設定](#mark-files-as-viewed)されます。
- **このファイルにコメントする**（{{< icon name="comment" >}}）: 特定の行にコメントを固定せずに、ファイルに一般的なコメントを残します。
- **オプション**: （{{< icon name="ellipsis_v" >}}）を選択して、その他のファイル表示オプションを表示します。

差分には、ファイルの左側にあるナビゲーションとコメントの補助機能も含まれています（ガター内）。

- **コンテキストをさらに表示**: **前の20行**（{{< icon name="expand-up" >}}）を選択すると、前の20行の変更されていない行が表示されます。**次の20行**（{{< icon name="expand-down" >}}）を選択すると、次の20行の変更されていない行が表示されます。
- **行番号**は2つの列に表示されます。前の行番号は左側に、提案された行番号は右側に表示されます。行を操作するには、次の手順に従います。
  - [コメントオプション](#add-a-comment-to-a-merge-request-file)を表示するには、行番号にカーソルを置きます。
  - 行へのリンクをコピーするには、<kbd>Command</kbd>を押しながら行番号を選択（または右クリック）し、**リンクアドレスをコピー**を選択します。
  - 行をハイライト表示するには、行番号を選択します。

## 変更されたファイルの一覧を表示する

**ファイルブラウザ**を使用して、次の手順でマージリクエストで変更されたファイルの一覧を表示します。

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを見つけます。
1. **コード > マージリクエスト**を選択し、マージリクエストを検索します。
1. マージリクエストのタイトルの下にある**変更**を選択します。
1. **ファイルブラウザを表示**（{{< icon name="file-tree" >}}）を選択するか、<kbd>F</kbd>を押してファイルツリーを表示します。
   - ネストを示すツリー表示の場合は、**ツリービュー**（{{< icon name="file-tree" >}}）を選択します。
   - ネストなしのファイル一覧表示の場合は、**リスト表示**（{{< icon name="list-bulleted" >}}）を選択します。

## マージリクエスト内のすべての変更を表示する

マージリクエストに含まれる変更の差分を表示するには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを見つけます。
1. **コード > マージリクエスト**を選択し、マージリクエストを検索します。
1. マージリクエストのタイトルの下にある**変更**を選択します。
1. マージリクエストで多数のファイルが変更された場合は、特定のファイルに直接ジャンプできます。
   1. **ファイルブラウザを表示**（{{< icon name="file-tree" >}}）を選択するか、<kbd>F</kbd>を押してファイルツリーを表示します。
   1. 表示するファイルを選択します。
   1. ファイルブラウザを非表示にするには、**ファイルブラウザを表示**を選択するか、もう一度<kbd>F</kbd>を押します。

GitLabは、パフォーマンスを向上させるために、多くの変更を含むファイルを折りたたみ、次のメッセージを表示します。**一部の変更は表示されていません**。そのファイルの変更を表示するには、**ファイルを展開**を選択します。

### リンクされたファイルを最初に表示する

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com

{{< /details >}}

{{< history >}}

- GitLab 16.9で`pinned_file`[フラグ](../../../administration/feature_flags.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/387246)されました。デフォルトでは無効になっています。
- GitLab 17.4で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162503)になりました。機能フラグ`pinned_file`が削除されました。

{{< /history >}}

マージリクエストのリンクをチームメンバーと共有するときに、変更されたファイルの一覧で特定のファイルを最初に表示したい場合があります。目的のファイルを最初に表示するマージリクエストリンクをコピーするには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを見つけます。
1. **コード > マージリクエスト**を選択し、マージリクエストを検索します。
1. マージリクエストのタイトルの下にある**変更**を選択します。
1. 最初に表示するファイルを検索します。ファイル名を右クリックして、そのファイルへのリンクをコピーします。
1. そのリンクにアクセスすると、選択したファイルが一覧の一番上に表示されます。ファイルブラウザには、ファイル名の横にリンクアイコン（{{< icon name="link" >}}）が表示されます。

   ![リストの一番上に YAML ファイルを表示するマージリクエスト。](img/linked_file_v17_4.png)

## 生成されたファイルを折りたたむ

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 16.8で`collapse_generated_diff_files`[フラグ](../../../administration/feature_flags.md)とともに[導入されました](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/140180)。デフォルトでは無効になっています。
- GitLab 16.10の[GitLab.comおよびGitLab Self-Managedで有効化](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/145100)されました。
- GitLab 16.11で、`generated_file`が[一般提供](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/148478)になりました。機能フラグ`collapse_generated_diff_files`が削除されました。

{{< /history >}}

レビュー担当者がコードレビューの実行に必要なファイルに集中できるようにするため、GitLabはいくつかの一般的なタイプの生成済みファイルを折りたたみます。これらのファイルでコードレビューが必要となることはめったにありません。したがって、GitLabはデフォルトで折りたたんでいます。

1. `.nib`、`.xcworkspacedata`、または`.xcurserstate`の拡張子を持つファイル。
1. `package-lock.json`や`Gopkg.lock`などのパッケージロックファイル。
1. `node_modules`フォルダー内のファイル。
1. 縮小された`js`または`css`ファイル。
1. ソースマップ参照ファイル。
1. プロトコルバッファコンパイラによって生成されたファイルを含む、生成されたGoファイル。

ファイルまたはパスを生成されたものとしてマークするには、[`.gitattributes`ファイル](../repository/files/git_attributes.md)でその`gitlab-generated`属性を設定します。

### 折りたたまれたファイルを表示する

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを見つけます。
1. **コード > マージリクエスト**を選択し、マージリクエストを検索します。
1. マージリクエストのタイトルの下にある**変更**を選択します。
1. 表示するファイルを検索し、**ファイルを展開**を選択します。

### ファイルタイプの折りたたみ動作を設定する

ファイルタイプのデフォルトの折りたたみ動作を変更するには、次の手順に従います。

1. `.gitattributes`ファイルがプロジェクトのルートディレクトリに存在しない場合は、この名前で空のファイルを作成します。
1. 変更するファイルタイプごとに、ファイル拡張子と目的の動作を宣言する行を次のように`.gitattributes`ファイルに追加します。

   ```conf
   # Collapse all files with a .txt extension
   *.txt gitlab-generated

   # Collapse all files within the docs directory
   docs/** gitlab-generated

   # Do not collapse package-lock.json
   package-lock.json -gitlab-generated
   ```

1. 変更をコミット、プッシュ、マージしてデフォルトブランチに反映します。

変更が[デフォルトブランチ](../repository/branches/default.md)にマージされた後、プロジェクト内のこのタイプのすべてのファイルは、マージリクエストでこの動作を使用します。

GitLabが生成されたファイルを検出する方法に関する技術的な詳細については、[`go-enry`](https://github.com/go-enry/go-enry/blob/master/data/generated.go)リポジトリを参照してください。

## 一度に1つのファイルを表示する

大規模なマージリクエストの場合は、一度に1つのファイルを確認できます。この設定は、ユーザー設定で変更するか、マージリクエストを確認するときに変更できます。マージリクエストでこの設定を変更すると、ユーザー設定も更新されます。

{{< tabs >}}

{{< tab title="マージリクエスト内" >}}

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを見つけます。
1. **コード > マージリクエスト**を選択し、マージリクエストを検索します。
1. マージリクエストのタイトルの下にある**変更**を選択します。

1. **設定**（{{< icon name="preferences" >}}）を選択します。

1. **一度に1つのファイルを表示**を選択またはクリアします。

{{< /tab >}}

{{< tab title="ユーザー設定" >}}

1. 左側のサイドバーで、自分のアバターを選択します。
1. **設定**を選択します。
1. **動作**セクションまでスクロールし、**マージリクエストの変更タブに一度に1 つのファイルを表示する**チェックボックスをオンにします。
1. **変更を保存**を選択します。

{{< /tab >}}

{{< /tabs >}}

この設定が有効になっているときに表示する別のファイルを選択するには、次のいずれかを行います。

- ファイルの末尾までスクロールし、**前**または**次**のいずれかを選択します。
- [キーボードショートカットが有効になっている](../../shortcuts.md#enable-keyboard-shortcuts)場合は、<kbd></kbd>、<kbd></kbd>、<kbd>k</kbd>、または<kbd>j</kbd>を押します。
- **ファイルブラウザを表示**（{{< icon name="file-tree" >}}）を選択し、表示する別のファイルを選択します。

## 変更を比較する

マージリクエストの変更は、次のいずれかで表示できます。

- インライン： 変更が縦に表示されます。行の古いバージョンが最初に表示され、そのすぐ下に新しいバージョンが表示されます。インラインモードは、多くの場合で単一行の変更に適しています。
- 並べて表示： 行の古いバージョンと新しいバージョンが別々の列に表示されます。並べて表示モードは、多くの場合、多数の連続する行に対して影響のある変更に適しています。

マージリクエストで変更された行の表示方法を変更するには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを見つけます。
1. **コード > マージリクエスト**を選択し、マージリクエストを検索します。
1. タイトルの下にある**変更**を選択します。
1. **設定**（{{< icon name="preferences" >}}）を選択します。**並べて表示**または**インライン**のいずれかを選択します。この例は、GitLabが同じ変更をインラインモードと並べて表示モードの両方でどのようにレンダリングするかを示しています。

   {{< tabs >}}

   {{< tab title="インラインによる変更" >}}

   ![インラインによる変更](img/changes-inline_v17_10.png)

   {{< /tab >}}

   {{< tab title="並べて表示による変更" >}}

   ![並べて表示による変更](img/changes-sidebyside_v17_10.png)

   {{< /tab >}}

   {{< /tabs >}}

## マージリクエストでコードを説明する

{{< details >}}

- プラン: GitLab Duo Proを含む Premium、GitLab Duo Proを含むUltimate、またはEnterprise - [トライアルを開始](https://about.gitlab.com/solutions/gitlab-duo-pro/sales/?type=free-trial)
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated
- GitLab Self-Managed、GitLab DedicatedのLLM:Anthropic [Claude 3.5 Sonnet](https://console.cloud.google.com/vertex-ai/publishers/anthropic/model-garden/claude-3-5-sonnet)
- GitLab.comのLLM: Anthropic [Claude 3.7 Sonnet](https://console.cloud.google.com/vertex-ai/publishers/anthropic/model-garden/claude-3-7-sonnet)

{{< /details >}}

{{< history >}}

- GitLab.comで[実験的機能](../../../policy/development_stages_support.md#experiment)としてGitLab 15.11で導入されました。
- GitLab 16.8で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/429915)されました。
- GitLab 17.6以降では、GitLab Duoアドオンが必須となりました。

{{< /history >}}

他の人が作成したコードを理解するのに多くの時間を費やしている場合、またはなじみのない言語で書かれたコードを理解するのに苦労している場合は、GitLab Duoにコードの説明を依頼できます。

前提要件:

- [実験的機能とベータ機能の設定](../../gitlab_duo/turn_on_off.md#turn-on-beta-and-experimental-features)が有効になっているグループに少なくとも1つ所属している必要があります。
- プロジェクトを表示するためのアクセス権が必要です。

マージリクエストでコードを説明するには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを見つけます。
1. **コード > マージリクエスト**を選択し、マージリクエストを選択します。
1. **変更**を選択します。
1. 説明するファイルで、3 つのドット（{{< icon name="ellipsis_v" >}}）を選択し、**View File @ $SHA**を選択します。

   別のブラウザタブが開き、最新の変更を含むフルファイルが表示されます。

1. 新しいタブで、説明する行を選択します。
1. 左側で、疑問符（{{< icon name="question" >}}）を選択します。表示するには、選択した最初の行までスクロールする必要がある場合があります。

   ![マージリクエストでコードを説明する](../repository/img/explain_code_v17_1.png)

GitLab Duo Chatがコードを説明します。説明の生成には時間がかかる場合があります。

必要に応じて、説明の品質に関するフィードバックを提供できます。

大規模言語モデルが正しい結果を生成することを保証することはできません。説明は注意して使用してください。

次の場所でもコードを説明できます。

- [ファイル](../repository/code_explain.md)。
- [IDE](../../gitlab_duo_chat/examples.md#explain-selected-code)。

## コメントを展開または折りたたむ

コードの変更を確認するときに、インラインコメントを非表示にできます。

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを見つけます。
1. **コード > マージリクエスト**を選択し、マージリクエストを検索します。
1. タイトルの下にある**変更**を選択します。
1. 非表示にするコメントが含まれているファイルまでスクロールします。
1. コメントが添付されている行までスクロールします。ガターの余白で、**折りたたむ**（{{< icon name="collapse" >}}）を選択すると、![コメントが折りたたまれます。](img/collapse-comment_v17_1.png)

インラインコメントを展開して再度表示するには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを見つけます。
1. **コード > マージリクエスト**を選択し、マージリクエストを検索します。
1. タイトルの下にある**変更**を選択します。
1. 表示する折りたたまれたコメントが含まれているファイルまでスクロールします。
1. コメントが添付されている行までスクロールします。ガターの余白でユーザーアバターを選択しすると、![コメントが展開されます。](img/expand-comment_v17_10.png)

## 空白の変更を無視する

空白の変更により、マージリクエストの実質的な変更が見えにくくなる可能性があります。空白の変更を非表示または表示するように選択できます。

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを見つけます。
1. **コード > マージリクエスト**を選択し、マージリクエストを検索します。
1. タイトルの下にある**変更**を選択します。
1. 変更されたファイルの一覧の前に、**設定**（{{< icon name="preferences" >}}）を選択します。
1. **ホワイトスペースの変更を表示する**を選択またはクリアします。

   ![設定メニューが展開された状態でのマージリクエストの差分](img/merge_request_diff_v17_10.png)

## ファイルに閲覧済みマークを付ける

多数のファイルがあるマージリクエストを複数回レビューする際に、すでにレビュー済みのファイルは無視できます。最後のレビュー以降に変更されていないファイルを非表示にするには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを見つけます。
1. **コード > マージリクエスト**を選択し、マージリクエストを検索します。
1. タイトルの下にある**変更**を選択します。
1. ファイルのヘッダーで、**閲覧済み**チェックボックスを選択します。

閲覧済みとしてマークされたファイルは、以下の場合を除き、再度表示されることはありません。

- ファイルの内容が変更された場合。
- **閲覧済み**チェックボックスをオフにした場合。

## 差分にマージリクエストの競合を表示する

{{< history >}}

- GitLab 15.7で、[GitLab.comおよびGitLab Self-Managedで有効になりました](https://gitlab.com/gitlab-org/gitlab/-/issues/276918)。
- GitLab 15.8で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/276918)になりました。機能フラグ`display_merge_conflicts_in_diff`が削除されました。

{{< /history >}}

ターゲットブランチにすでにある変更を表示しないようにするため、マージリクエストのソースブランチとターゲットブランチの`HEAD`を比較します。

ソースブランチとターゲットブランチが競合する場合、マージリクエストの差分で競合するファイルごとにアラートを表示します。

![マージリクエストの差分に表示される競合アラートの例](img/conflict_ui_v15_6.png)

## 差分にスキャナーの発見を表示する

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

差分にスキャナーの発見を表示できます。詳細については、以下を参照してください。

- [コード品質の検出結果](../../../ci/testing/code_quality.md#merge-request-changes-view)
- [静的な解析の検出結果](../../application_security/sast/_index.md#merge-request-changes-view)

## マージリクエストファイルにコメントを追加する

{{< history >}}

- GitLab 16.1で`comment_on_files`[フラグ](../../../administration/feature_flags.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/123515)されました。デフォルトで有効になっています。
- GitLab 16.2で、[機能フラグが削除](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/125130)されました。

{{< /history >}}

マージリクエストの差分ファイルにコメントを追加できます。これらのコメントは、リベースやファイルの変更後も保持されます。

マージリクエストファイルにコメントを追加するには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを見つけます。
1. **コード > マージリクエスト**を選択し、マージリクエストを検索します。
1. **変更**を選択します。
1. コメントしたいファイルのヘッダーで、**コメント**（{{< icon name="comment" >}}）を選択します。

## 画像にコメントを追加する

マージリクエストとコミットの詳細表示では、画像にコメントを追加できます。このコメントはスレッドにもなります。

1. 画像の上にマウスを置きます。
1. コメントする場所を選択します。

GitLabは、画像にアイコンとコメントフィールドを表示します。

## リソース

- GitLabが2つのリビジョン間の差分を計算する方法に関する技術的な詳細については、[差分を操作する](../../../development/merge_request_concepts/diffs/_index.md)を参照してください。
