---
stage: Software Supply Chain Security
group: Authentication
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: エンタープライズユーザー
---

{{< details >}}

- プラン: Premium、Ultimate
- 提供: GitLab.com

{{< /details >}}

エンタープライズユーザーは、[Eメールのドメインを検証](#verified-domains-for-groups)し、[GitLabサブスクリプション](../../subscriptions/_index.md)を購入した組織によって管理されるユーザーアカウントを持っています。

エンタープライズユーザーは、[メンバーリスト](../group/_index.md#filter-and-sort-members-in-a-group)の名前の横にある**エンタープライズ**バッジで識別されます。

## エンタープライズユーザーの自動クレーム

ユーザーは、次の条件の**両方**が満たされると、グループのエンタープライズユーザーとして自動的にクレームされます。

1. ユーザーのプライマリEメールには、有料グループによって[検証](#verified-domains-for-groups)されたドメインがあります。
1. ユーザーアカウントは、次の条件の少なくとも**1つ**を満たしている必要があります。
   - 2021年2月1日以降に作成された。
   - 組織のグループに関連付けられたSAMLまたはSCIM IDがある。
   - 組織のグループのIDと同じ`provisioned_by_group_id`値がある。
   - サブスクリプションが2021年2月1日以降に購入または更新された組織のグループのメンバーである。

ユーザーがエンタープライズユーザーとしてクレームされた後は:

- ユーザーの`enterprise_group_id`属性が、組織のグループのIDに設定されます。
- ユーザーは[ウェルカムメール](https://gitlab.com/gitlab-org/gitlab/-/blob/master/ee/app/views/notify/user_associated_with_enterprise_group_email.html.haml)を受信します。

グループの購入済みサブスクリプションが期限切れになるか、キャンセルされた場合:

- エンタープライズユーザーとしてクレームされたユーザーは、そのグループのエンタープライズユーザーのままになります。
- グループは[エンタープライズユーザーを管理](#manage-enterprise-users-in-a-namespace)できません。
- [エンタープライズユーザーの制限](#enterprise-user-restrictions)は、それらのユーザーアカウントに適用されます。
- 有料サブスクリプションが更新されるまで、新しいユーザーを[グループに自動的に関連付ける](#automatic-claims-of-enterprise-users)ことはできません。

グループの検証済みドメインが削除された場合:

- エンタープライズユーザーとしてクレームされたユーザーは、そのグループのエンタープライズユーザーのままになります。
- [エンタープライズユーザーの制限](#enterprise-user-restrictions)は、それらのユーザーアカウントに適用されます。
- ドメインが検証されるまで、新しいユーザーを[グループに自動的に関連付ける](#automatic-claims-of-enterprise-users)ことはできません。

組織が検証済みのドメインを別の有料グループに移動すると、組織のエンタープライズユーザーは、そのグループのエンタープライズユーザーとして[自動的にクレーム](#automatic-claims-of-enterprise-users)されます。

### 未クレームユーザーの特定

ユーザーがエンタープライズユーザーとして自動的にクレームされない場合、既存のアクセス権が失効することはありません。ドメイン検証が有効になっているグループには、クレーム済みユーザーと未クレームユーザーの両方をメンバーとして含めることができます。

エンタープライズユーザーとしてクレームされたメンバーとそうでないメンバーの唯一の違いは、グループオーナーが[未クレームユーザーを管理](#manage-enterprise-users-in-a-namespace)できないことです。

### エンタープライズユーザーとしてクレームされていないグループメンバーの特定

ドメイン検証を有効にするグループは、クレーム済みユーザーと未クレームユーザーの両方をメンバーとすることができます。未クレームのユーザーは既存のアクセス権を保持しますが、グループオーナーによって管理されません。

[ネームスペースのエンタープライズユーザーの管理](#manage-enterprise-users-in-a-namespace)を参照してください。

次の場所で、請求対象ユーザーのリストにアクセスして分析することで、グループ内の未クレームユーザーを見つけることができます: `https://gitlab.com/groups/<group_id>/-/usage_quotas#seats-quota-tab`。

このリストにおいて、未クレームユーザーは次のいずれかの状態です。

- メールアドレスが表示されていない。
- メールアドレスが検証済みのドメインと一致しない。

これらのユーザーをクレームするには、検証済みのドメインと一致するように、プライマリメールアドレスを更新する必要があります。これらのユーザーは、次回のスケジュールされた作業者クレームの実行時に自動的にクレームされます。

## エンタープライズユーザーの制限

### プライマリメールの変更

エンタープライズユーザーがプライマリメールに変更できるメールは、組織が検証済みのドメインに従って所有するメールのみです。組織が検証済みのドメインをすべて削除すると、組織のエンタープライズユーザーはプライマリメールアドレスを変更できなくなります。

エンタープライズユーザーのプライマリメールアドレスを検証されていないドメインのメールに変更できるのは、GitLab管理者のみです。

グループオーナーがエンタープライズユーザーのプライマリメールを検証されていないドメインのメールに変更できるようにすることは、[イシュー412966](https://gitlab.com/gitlab-org/gitlab/-/issues/412966)で提案されています。

## グループの検証済みドメイン

次の自動プロセスは、検証済みのドメインを使用して実行されます。

- [エンタープライズユーザーの自動クレーム](#automatic-claims-of-enterprise-users)。
- [プロビジョニングされたユーザーのメール確認の回避](#bypass-email-confirmation-for-provisioned-users)。

### 検証済みドメインの設定

前提要件:

- カスタムドメイン名`example.com`またはサブドメイン`subdomain.example.com`。
- ドメインの所有権を検証することを目的とした、DNS `TXT`レコードを設定するためのドメインのサーバーコントロールパネルへのアクセス。
- グループ内のプロジェクト。このプロジェクトは検証済みのドメインにリンクされるため、削除しないでください。このプロジェクトでは、設定でPagesコンポーネントが有効になっている必要もあります（**一般**->**表示レベル、プロジェクトの機能、権限**->**Pages**）。設定でPagesコンポーネントが無効になっている場合、ドメイン検証中に`500`エラーが生成されます。
- プロジェクトに対して[GitLab Pages](../project/pages/_index.md)が有効になっていることを確認します。GitLab Pagesが無効になっている場合、ドメインを追加するとエラーが発生する可能性があります。
- トップレベルグループのオーナーの役割を持っている必要があります。

ドメイン検証は、トップレベルグループと、そのトップレベルの親グループの下にネストされたすべてのサブグループおよびプロジェクトに適用されます。

複数のグループに対してドメインを検証することはできません。たとえば、「group1」という名前のグループに「domain1」という名前の検証済みドメインがある場合、「group2」という名前の別のグループにも「domain1」を検証することはできません。

検証済みドメインの設定は、[GitLab Pagesでカスタムドメインを設定する](../project/pages/custom_domains_ssl_tls_certification/_index.md)のと似ています。ただし、次の点に注意してください。

- GitLab Pagesのウェブサイトを持っている必要はありません。
- ドメイン検証はトップレベルグループとネストされたすべてのサブグループとプロジェクトに適用されます。しかし、次の理由で、ドメインを単一のプロジェクトにリンクする必要があります。
  - ドメイン検証は選択したプロジェクトに関連付けられています。プロジェクトが削除されると、ドメイン検証が削除されます。
  - ドメイン検証はプロジェクトを必要とするGitLab Pagesカスタムドメイン検証機能を再利用します。
- ドメインの所有権を検証するには、DNSレコードでのみ`TXT`を設定する必要があります。

ドメインは、トップレベルグループのドメイン検証リストに表示されるだけでなく、選択したプロジェクトにも表示されます。このプロジェクトで[メンテナー以上の役割](../permissions.md#project-members-permissions)を持つメンバーは、ドメイン検証を変更または削除できます。

必要に応じて、新しいプロジェクトを作成して、トップレベルグループの直下にドメイン検証を設定できます。これにより、ドメインの検証を変更する権限がメンテナー以上の役割を持つメンバーに制限されます。これらのユーザーはドメインを設定できるため、グループのエンタープライズユーザーは、そのドメインと一致するようにメールを更新できます。

グループレベルのドメイン検証の詳細については、[エピック5299](https://gitlab.com/groups/gitlab-org/-/epics/5299)を参照してください。

#### 1\.一致するEメールのドメインにカスタムドメインを追加する

カスタムドメインは、Eメールのドメインと完全に一致する必要があります。たとえば、メールが`username@example.com`の場合、`example.com`ドメインを検証します。

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。このグループはトップレベルにある必要があります。
1. **設定>ドメイン検証**を選択します。
1. 右上隅で、**ドメインを追加**を選択します。
1. **ドメイン**に、ドメイン名を入力します。
1. **プロジェクト**で、プロジェクトにリンクします。
1. **証明書**を以下のように設定します。
   - SSL証明書を持っていない場合、またはSSL証明書を使用したくない場合は、**Let's Encryptを使用した自動証明書管理**を選択したままにします。
   - 任意。**証明書情報を手動で入力トグル**をオンにして、SSL/TLS証明書を追加します。証明書とキーは後で追加することもできます。
1. **ドメインを追加**を選択します。

{{< alert type="note" >}}

ドメインの検証に、有効な証明書は不要です。GitLab Pagesを使用していない場合は、証明書に関するエラーメッセージを無視できます。

{{< /alert >}}

#### 2\.検証コードを取得する

新しいドメインを作成すると、検証コードのプロンプトが表示されます。GitLabから値をコピーし、ドメインのコントロールパネルに`TXT`レコードとして貼り付けます。

![検証コードを取得する](../img/get_domain_verification_code_v16_0.png)

#### 3\.ドメインの所有権を確認する

すべてのDNSレコードを追加した後は:

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。
1. **設定>ドメイン検証**を選択します。
1. ドメインテーブルの行で、**検証を再試行する**（{{< icon name="retry" >}}）を選択します。

![ドメインを確認する](../img/retry_domain_verification_v16_0.png)

{{< alert type="warning" >}}

ドメイン検証が有効になっているGitLabインスタンスでは、ドメインを7日間検証できない場合、そのドメインがGitLabプロジェクトから削除されます。

{{< /alert >}}

{{< alert type="note" >}}

- **GitLab.comユーザーがエンタープライズユーザーとしてマークされるには、ドメイン検証が必須**です。
- [DNSの伝播には最大24時間かかる](https://www.inmotionhosting.com/support/domain-names/dns-nameserver-changes/complete-guide-to-dns-records/)場合がありますが、通常は数分で完了します。完了するまで、ドメインは未検証として表示されます。
- ドメインが検証されたら、検証レコードをそのままにしておきます。ドメインは定期的に再検証され、レコードが削除されると無効になる場合があります。
- ドメインの検証に、有効な証明書は不要です。

{{< /alert >}}

### グループ内のドメインを表示する

グループで設定されたすべてのドメインを表示するには:

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。このグループはトップレベルにある必要があります。
1. **設定>ドメイン検証**を選択します。

すると、次が表示されます:

- 追加されたドメインのリスト。
- ドメインの状態は、**検証済み**または**未検証**です。
- ドメインが構成されているプロジェクト。

### グループ内のドメインを管理する

ドメインを編集または削除するには:

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。このグループはトップレベルにある必要があります。
1. **設定>ドメイン検証**を選択します。
1. **ドメイン検証**を表示するときに、関連するドメインの横にリストされているプロジェクトを選択します。
1. 関連する[GitLab Pagesカスタムドメイン](../project/pages/custom_domains_ssl_tls_certification/_index.md)の手順に従って、ドメインを編集または削除します。

## ネームスペースのエンタープライズユーザーを管理する

有料プランのネームスペースのトップレベルオーナーは、そのネームスペースのエンタープライズユーザーアカウントに関する情報を取得し、管理できます。

これらのエンタープライズユーザー固有のアクションは、標準の[グループメンバー権限](../permissions.md#group-members-permissions)に加えて行えるものです。

### 2要素認証を無効にする

{{< history >}}

- GitLab 15.8で[導入](https://gitlab.com/groups/gitlab-org/-/epics/9484)されました。

{{< /history >}}

トップレベルグループのオーナーは、エンタープライズユーザーの2要素認証（2FA）を無効にできます。

2FAを無効にするには:

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。
1. **管理>メンバー**を選択します。
1. **エンタープライズ**バッジと**2FA**バッジが付いているユーザーを探します。
1. **その他のアクション**（{{< icon name="ellipsis_v" >}}）を選択し、**2要素認証を無効にする**を選択します。

### Web IDEとワークスペースの拡張機能マーケットプレースを有効にする

{{< details >}}

- 状態: ベータ

{{< /details >}}

{{< history >}}

- `web_ide_oauth`および`web_ide_extensions_marketplace`という名前の[フラグ](../../administration/feature_flags.md)として、GitLab 17.0で[ベータ](../../policy/development_stages_support.md#beta)として[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161819)されました。デフォルトで無効になっています。
- `web_ide_oauth`は、GitLab 17.4の[GitLab.com、GitLab Self-Managed、およびGitLab Dedicatedで有効になりました](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163181)。
- `web_ide_extensions_marketplace`は、GitLab 17.4の[GitLab.comで有効になりました](https://gitlab.com/gitlab-org/gitlab/-/issues/459028)。
- `web_ide_oauth`は、GitLab 17.5で[削除されました](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167464)。
- GitLab 17.10で`vscode_extension_marketplace_settings`[機能フラグ](../../administration/feature_flags.md)を[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/508996)しました。デフォルトで無効になっています。
- `web_ide_extensions_marketplace`と`vscode_extension_marketplace_settings`は、GitLab 17.11の[GitLab Self-Managedで有効になりました](https://gitlab.com/gitlab-org/gitlab/-/issues/459028)。

{{< /history >}}

{{< alert type="flag" >}}

この機能の利用可否は、機能フラグによって制御されます。詳細については履歴を参照してください。

{{< /alert >}}

前提要件:

- **管理者**エリアで、GitLab管理者が[拡張機能マーケットプレースを有効にする](../../administration/settings/vscode_extension_marketplace.md)必要があります。

トップレベルグループのオーナーの役割を持っている場合は、エンタープライズユーザーに対して[拡張機能マーケットプレース](../project/web_ide/_index.md#extension-marketplace)を有効にできます。

[Web IDE](../project/web_ide/_index.md)および[ワークスペース](../workspace/_index.md)の拡張機能マーケットプレースを有効にするには:

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。
1. **設定>一般**を選択します。
1. **権限とグループ機能**セクションを展開します。
1. **Web IDEとワークスペース**で、**拡張機能マーケットプレースを有効にする**チェックボックスを選択します。
1. **変更の保存**を選択します。

### エンタープライズユーザーが企業グループの外部でグループとプロジェクトを作成できないようにする

SAML ID管理者は、SAMLレスポンスを構成して、次を設定できます。

- エンタープライズユーザーが新しいトップレベルグループを作成できるかどうか。
- エンタープライズユーザーが作成できる個人プロジェクトの最大数。

詳細については、[SAMLレスポンスからエンタープライズユーザー設定を構成](../group/saml_sso/_index.md#configure-enterprise-user-settings-from-saml-response)する方法を参照してください。

### プロビジョニングされたユーザーのメール確認を回避する

トップレベルグループのオーナーは、[検証済みドメインを設定して確認メールを回避](../group/saml_sso/_index.md#bypass-user-email-confirmation-with-verified-domains)できます。

### ユーザーのメールアドレスを取得する

トップレベルグループのオーナーは、UIを使用してエンタープライズユーザーのメールアドレスにアクセスできます:

1. 左側のサイドバーで、**検索または移動**を選択して、プロジェクトまたはグループを見つけます。
1. **管理>メンバー**を選択します。
1. グループまたはプロジェクトのメンバーページで、エンタープライズユーザーの名前にカーソルをおくと、そのメールアドレスが表示されます。

グループオーナーは、[グループおよびプロジェクトメンバーAPI](../../api/members.md)を使用して、ユーザーの情報にアクセスすることもできます。グループのエンタープライズユーザーの場合、この情報にはユーザーのメールアドレスが含まれます。

### アカウントからエンタープライズ管理機能を削除する

エンタープライズユーザーのプライマリメールを検証されていないドメインからのメールに変更すると、アカウントからエンタープライズバッジが自動的に削除されます。これにより、ユーザーのアカウントの役割または権限が変更されることはありませんが、グループオーナーがこのアカウントを管理する機能が制限されます。

### エンタープライズユーザーのパスワード認証を無効にする

トップレベルグループのオーナーは、[エンタープライズユーザーのパスワード認証を無効にする](../group/saml_sso/_index.md#disable-password-authentication-for-enterprise-users)ことができます。

## 関連トピック

- [グループエンタープライズユーザーAPI](../../api/group_enterprise_users.md)

## トラブルシューティング

### エンタープライズユーザーの2要素認証を無効にできない

エンタープライズユーザーに**エンタープライズ**バッジがない場合、トップレベルグループのオーナーはそのユーザーの[2FAを無効化またはリセット](#disable-two-factor-authentication)できません。代わりに、オーナーはエンタープライズユーザーに、利用可能な[リカバリーオプション](../profile/account/two_factor_authentication_troubleshooting.md#recovery-options-and-2fa-reset)を検討するように指示する必要があります。
