---
stage: Monitor
group: Platform Insights
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Error Tracking
description: Error tracking, logging, debugging, and data retention.
---

Error Tracking helps developers to discover and view errors generated by their
application. Because error information is surfaced where the code is developed,
error tracking increases efficiency and awareness. Users can choose between
[GitLab Integrated error tracking](integrated_error_tracking.md) and
[Sentry-based](sentry_error_tracking.md) backends.

## Prerequisites

For error tracking to work, you need:

- **Your application configured with the Sentry SDK**: When the error happens, Sentry SDK captures information
  about it and sends it over the network to the backend. The backend stores information about all
  errors.
- **Error tracking backend**: The backend can be either GitLab itself or Sentry.
  - To use the GitLab backend, see [GitLab integrated error tracking](integrated_error_tracking.md).
    Integrated error tracking is available only on GitLab.com.
  - To use Sentry as the backend, see [Sentry error tracking](sentry_error_tracking.md).
    Sentry-based error tracking is available for GitLab.com, GitLab Dedicated, and GitLab Self-Managed.

## How error tracking works

The following table gives an overview of the capabilities for each GitLab offering:

| Feature | Availability | Data collection | Data storage | Data query |
| ----------- | ----------- | ----------- | ----------- | ----------- |
| [GitLab integrated Error Tracking](integrated_error_tracking.md) | GitLab.com | With [Sentry SDK](https://github.com/getsentry/sentry?tab=readme-ov-file#official-sentry-sdks) | On GitLab.com | With GitLab.com |
| [Sentry-based Error Tracking](sentry_error_tracking.md) | GitLab.com, GitLab Dedicated, GitLab Self-Managed | With [Sentry SDK](https://github.com/getsentry/sentry?tab=readme-ov-file#official-sentry-sdks) | On Sentry instance (Cloud Sentry.io or [self-hosted Sentry](https://develop.sentry.dev/self-hosted/)) | With GitLab.com or Sentry instance |
