---
stage: Tenant Scale
group: Cells Infrastructure
info: Analysis of Application Settings for Cells 1.0.
title: Application Settings analysis
---

<!--
  This documentation is auto generated by a Ruby script.

  Please do not edit this file directly. To update this file, run:
  scripts/cells/application-settings-analysis.rb
-->

## Statistics

- Number of attributes: 499
- Number of encrypted attributes: 42 (8.0%)
- Number of attributes documented: 294 (59.0%)
- Number of attributes on GitLab.com different from the defaults: 223 (45.0%)
- Number of attributes with `clusterwide` set: 499 (100.0%)
- Number of attributes with `clusterwide: true` set: 132 (26.0%)

## Individual columns

| Attribute name | Encrypted | DB Type | API Type | Not Null? | Default | GitLab.com != default | Cluster-wide? | Documented? |
| -------------- | ------------- | --------- | --------- | --------- | --------- | ------------- | ----------- | ----------- |
| `abuse_notification_email` | `false` | `character` | `string` | `false` | `null` | `true` | `true`| `true` |
| `admin_mode` | `false` | `boolean` | `boolean` | `true` | `false` | `false` | `false`| `true` |
| `after_sign_out_path` | `false` | `character` | `string` | `false` | `null` | `true` | `true`| `true` |
| `after_sign_up_text` | `false` | `text` | `string` | `false` | `null` | `true` | `true`| `true` |
| `ai_action_api_rate_limit` | `false` | `integer` | `` | `true` | `160` | `false` | `false`| `false` |
| `akismet_api_key` | `true` | `text` | `string` | `false` | `null` | `true` | `false`| `true` |
| `akismet_enabled` | `false` | `boolean` | `boolean` | `false` | `false` | `false` | `false`| `true` |
| `allow_account_deletion` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `allow_deploy_tokens_and_keys_with_external_authn` | `false` | `boolean` | `` | `true` | `false` | `false` | `false`| `false` |
| `allow_group_owners_to_manage_ldap` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `allow_local_requests_from_system_hooks` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `allow_local_requests_from_web_hooks_and_services` | `false` | `boolean` | `boolean` | `true` | `false` | `false` | `false`| `true` |
| `allow_possible_spam` | `false` | `boolean` | `` | `true` | `false` | `false` | `false`| `false` |
| `allow_project_creation_for_guest_and_below` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `allow_runner_registration_token` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `allow_top_level_group_owners_to_create_service_accounts` | `false` | `boolean` | `` | `true` | `false` | `true` | `false`| `false` |
| `anti_abuse_settings` | `false` | `jsonb` | `` | `true` | `'{}'::jsonb` | `false` | `true`| `false` |
| `archive_builds_in_seconds` | `false` | `integer` | `` | `false` | `null` | `false` | `false`| `false` |
| `arkose_labs_client_secret` | `true` | `bytea` | `` | `false` | `null` | `true` | `true`| `false` |
| `arkose_labs_client_xid` | `true` | `bytea` | `` | `false` | `null` | `true` | `true`| `false` |
| `arkose_labs_data_exchange_key` | `true` | `bytea` | `` | `false` | `null` | `true` | `true`| `false` |
| `arkose_labs_namespace` | `false` | `text` | `` | `true` | `'client'::text` | `true` | `true`| `false` |
| `arkose_labs_private_api_key` | `true` | `bytea` | `` | `false` | `null` | `true` | `true`| `false` |
| `arkose_labs_public_api_key` | `true` | `bytea` | `` | `false` | `null` | `true` | `true`| `false` |
| `asciidoc_max_includes` | `false` | `smallint` | `integer` | `true` | `32` | `false` | `false`| `true` |
| `asset_proxy_enabled` | `false` | `boolean` | `boolean` | `true` | `false` | `true` | `true`| `true` |
| `asset_proxy_secret_key` | `true` | `text` | `string` | `false` | `null` | `true` | `true`| `true` |
| `asset_proxy_url` | `false` | `character` | `string` | `false` | `null` | `true` | `true`| `true` |
| `asset_proxy_whitelist` | `false` | `text` | `string or array of strings` | `false` | `null` | `true` | `true`| `true` |
| `authorized_keys_enabled` | `false` | `boolean` | `boolean` | `true` | `true` | `true` | `true`| `true` |
| `auto_ban_user_on_excessive_projects_download` | `false` | `boolean` | `boolean` | `true` | `false` | `false` | `false`| `true` |
| `auto_devops_domain` | `false` | `character` | `string` | `false` | `null` | `true` | `true`| `true` |
| `auto_devops_enabled` | `false` | `boolean` | `boolean` | `true` | `true` | `true` | `true`| `true` |
| `automatic_purchased_storage_allocation` | `false` | `boolean` | `boolean` | `true` | `false` | `true` | `true`| `true` |
| `bulk_import_concurrent_pipeline_batch_limit` | `false` | `smallint` | `integer` | `true` | `25` | `false` | `false`| `true` |
| `bulk_import_enabled` | `false` | `boolean` | `boolean` | `true` | `false` | `true` | `false`| `true` |
| `bulk_import_max_download_file_size` | `false` | `bigint` | `integer` | `true` | `5120` | `false` | `false`| `true` |
| `cached_markdown_version` | `false` | `integer` | `` | `false` | `null` | `false` | `false`| `false` |
| `can_create_group` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `can_create_organization` | `false` | `boolean` | `` | `true` | `true` | `false` | `false`| `false` |
| `check_namespace_plan` | `false` | `boolean` | `boolean` | `true` | `false` | `true` | `true`| `true` |
| `ci_cd_settings` | `false` | `jsonb` | `` | `true` | `'{}'::jsonb` | `false` | `false`| `false` |
| `ci_job_token_signing_key` | `true` | `bytea` | `` | `false` | `null` | `true` | `true`| `false` |
| `ci_jwt_signing_key` | `true` | `text` | `` | `false` | `null` | `true` | `true`| `false` |
| `ci_max_includes` | `false` | `integer` | `integer` | `true` | `150` | `false` | `false`| `true` |
| `ci_max_total_yaml_size_bytes` | `false` | `integer` | `integer` | `true` | `314572800` | `false` | `false`| `true` |
| `clickhouse` | `false` | `jsonb` | `` | `true` | `'{}'::jsonb` | `true` | `true`| `false` |
| `cloud_license_auth_token` | `true` | `text` | `` | `false` | `null` | `false` | `false`| `false` |
| `cluster_agents` | `false` | `jsonb` | `` | `true` | `'{}'::jsonb` | `true` | `true`| `false` |
| `code_creation` | `false` | `jsonb` | `` | `true` | `'{}'::jsonb` | `true` | `true`| `false` |
| `code_suggestions_api_rate_limit` | `false` | `integer` | `` | `true` | `60` | `false` | `false`| `false` |
| `commit_email_hostname` | `false` | `character` | `string` | `false` | `null` | `true` | `true`| `true` |
| `compliance_frameworks` | `false` | `smallint[]` | `` | `true` | `'{}'::smallint[]` | `false` | `false`| `false` |
| `container_expiration_policies_enable_historic_entries` | `false` | `boolean` | `boolean` | `true` | `false` | `true` | `true`| `true` |
| `container_registry_cleanup_tags_service_max_list_size` | `false` | `integer` | `integer` | `true` | `200` | `false` | `false`| `true` |
| `container_registry_data_repair_detail_worker_max_concurrency` | `false` | `integer` | `` | `true` | `2` | `true` | `false`| `false` |
| `container_registry_db_enabled` | `false` | `boolean` | `` | `true` | `false` | `true` | `true`| `false` |
| `container_registry_delete_tags_service_timeout` | `false` | `integer` | `integer` | `true` | `250` | `false` | `false`| `true` |
| `container_registry_expiration_policies_caching` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `container_registry_expiration_policies_worker_capacity` | `false` | `integer` | `integer` | `true` | `4` | `true` | `false`| `true` |
| `container_registry_features` | `false` | `text[]` | `` | `true` | `'{}'::text[]` | `true` | `true`| `false` |
| `container_registry_token_expire_delay` | `false` | `integer` | `integer` | `false` | `5` | `true` | `false`| `true` |
| `container_registry_vendor` | `false` | `text` | `` | `true` | `''::text` | `true` | `true`| `false` |
| `container_registry_version` | `false` | `text` | `` | `true` | `''::text` | `true` | `true`| `false` |
| `content_validation_api_key` [JIHU] | `true` | `bytea` | `` | `false` | `null` | `false` | `false`| `false` |
| `content_validation_endpoint_enabled` [JIHU] | `false` | `boolean` | `` | `true` | `false` | `false` | `false`| `false` |
| `content_validation_endpoint_url` [JIHU] | `false` | `text` | `` | `false` | `null` | `false` | `false`| `false` |
| `created_at` | `false` | `timestamp` | `` | `false` | `null` | `true` | `false`| `false` |
| `cube_api_base_url` | `false` | `text` | `` | `false` | `null` | `true` | `true`| `false` |
| `cube_api_key` | `true` | `bytea` | `` | `false` | `null` | `true` | `true`| `false` |
| `custom_http_clone_url_root` | `false` | `character` | `string` | `false` | `null` | `true` | `true`| `true` |
| `custom_project_templates_group_id` | `false` | `bigint` | `` | `false` | `null` | `false` | `false`| `false` |
| `customers_dot_jwt_signing_key` | `true` | `bytea` | `` | `false` | `null` | `true` | `true`| `false` |
| `dashboard_limit` | `false` | `integer` | `` | `true` | `0` | `true` | `true`| `false` |
| `dashboard_limit_enabled` | `false` | `boolean` | `` | `true` | `false` | `true` | `true`| `false` |
| `database_grafana_api_key` | `true` | `bytea` | `` | `false` | `null` | `true` | `true`| `false` |
| `database_grafana_api_url` | `false` | `text` | `` | `false` | `null` | `true` | `true`| `false` |
| `database_grafana_tag` | `false` | `text` | `` | `false` | `null` | `true` | `true`| `false` |
| `database_max_running_batched_background_migrations` | `false` | `integer` | `` | `true` | `2` | `true` | `true`| `false` |
| `database_reindexing` | `false` | `jsonb` | `` | `true` | `'{}'::jsonb` | `false` | `true`| `false` |
| `deactivate_dormant_users` | `false` | `boolean` | `boolean` | `true` | `false` | `false` | `false`| `true` |
| `deactivate_dormant_users_period` | `false` | `integer` | `integer` | `true` | `90` | `false` | `false`| `true` |
| `deactivation_email_additional_text` | `false` | `text` | `` | `false` | `null` | `true` | `true`| `false` |
| `decompress_archive_file_timeout` | `false` | `integer` | `integer` | `true` | `210` | `false` | `false`| `true` |
| `default_artifacts_expire_in` | `false` | `character` | `string` | `true` | `'0'::character` | `true` | `true`| `true` |
| `default_branch_name` | `false` | `text` | `string` | `false` | `null` | `true` | `false`| `true` |
| `default_branch_protection` | `false` | `integer` | `integer` | `false` | `2` | `false` | `false`| `true` |
| `default_branch_protection_defaults` | `false` | `jsonb` | `hash` | `true` | `'{}'::jsonb` | `true` | `false`| `true` |
| `default_ci_config_path` | `false` | `character` | `string` | `false` | `null` | `true` | `false`| `true` |
| `default_group_visibility` | `false` | `integer` | `string` | `false` | `null` | `true` | `false`| `true` |
| `default_preferred_language` | `false` | `text` | `string` | `true` | `'en'::text` | `false` | `false`| `true` |
| `default_profile_preferences` | `false` | `jsonb` | `` | `true` | `'{}'::jsonb` | `false` | `true`| `false` |
| `default_project_creation` | `false` | `integer` | `integer` | `true` | `2` | `false` | `false`| `true` |
| `default_project_deletion_protection` | `false` | `boolean` | `boolean` | `true` | `false` | `false` | `false`| `true` |
| `default_project_visibility` | `false` | `integer` | `string` | `true` | `0` | `false` | `false`| `true` |
| `default_projects_limit` | `false` | `integer` | `integer` | `false` | `null` | `true` | `false`| `true` |
| `default_snippet_visibility` | `false` | `integer` | `string` | `true` | `0` | `false` | `false`| `true` |
| `default_syntax_highlighting_theme` | `false` | `integer` | `integer` | `true` | `1` | `false` | `false`| `true` |
| `delete_inactive_projects` | `false` | `boolean` | `` | `true` | `false` | `false` | `false`| `false` |
| `delete_unconfirmed_users` | `false` | `boolean` | `boolean` | `true` | `false` | `true` | `false`| `true` |
| `deletion_adjourned_period` | `false` | `integer` | `integer` | `true` | `30` | `false` | `false`| `true` |
| `deny_all_requests_except_allowed` | `false` | `boolean` | `` | `true` | `false` | `false` | `false`| `false` |
| `dependency_proxy_ttl_group_policy_worker_capacity` | `false` | `smallint` | `` | `true` | `2` | `false` | `false`| `false` |
| `diagramsnet_enabled` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `diagramsnet_url` | `false` | `text` | `string` | `false` | `'https://embed.diagrams.net'::text` | `false` | `false`| `true` |
| `diff_max_files` | `false` | `integer` | `integer` | `true` | `1000` | `true` | `true`| `true` |
| `diff_max_lines` | `false` | `integer` | `integer` | `true` | `50000` | `true` | `true`| `true` |
| `diff_max_patch_bytes` | `false` | `integer` | `integer` | `true` | `204800` | `false` | `true`| `true` |
| `dingtalk_app_key` [JIHU] | `true` | `bytea` | `` | `false` | `null` | `false` | `false`| `false` |
| `dingtalk_app_secret` [JIHU] | `true` | `bytea` | `` | `false` | `null` | `false` | `false`| `false` |
| `dingtalk_corpid` [JIHU] | `true` | `bytea` | `` | `false` | `null` | `false` | `false`| `false` |
| `dingtalk_integration_enabled` [JIHU] | `false` | `boolean` | `` | `true` | `false` | `false` | `false`| `false` |
| `disable_admin_oauth_scopes` | `false` | `boolean` | `boolean` | `true` | `false` | `false` | `false`| `true` |
| `disable_download_button` [JIHU] | `false` | `boolean` | `` | `true` | `false` | `false` | `false`| `false` |
| `disable_feed_token` | `false` | `boolean` | `boolean` | `true` | `false` | `false` | `false`| `true` |
| `disable_overriding_approvers_per_merge_request` | `false` | `boolean` | `boolean` | `true` | `false` | `false` | `false`| `true` |
| `disable_personal_access_tokens` | `false` | `boolean` | `boolean` | `true` | `false` | `false` | `false`| `true` |
| `disabled_oauth_sign_in_sources` | `false` | `text` | `array of strings` | `false` | `null` | `false` | `false`| `true` |
| `dns_rebinding_protection_enabled` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `domain_allowlist` | `false` | `text` | `array of strings` | `false` | `null` | `false` | `false`| `true` |
| `domain_denylist` | `false` | `text` | `array of strings` | `false` | `null` | `true` | `true`| `true` |
| `domain_denylist_enabled` | `false` | `boolean` | `boolean` | `false` | `false` | `true` | `true`| `true` |
| `dsa_key_restriction` | `false` | `integer` | `integer` | `true` | `'-1'::integer` | `false` | `false`| `true` |
| `duo_chat` | `false` | `jsonb` | `` | `true` | `'{}'::jsonb` | `false` | `true`| `false` |
| `duo_features_enabled` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `duo_workflow` | `false` | `jsonb` | `` | `false` | `'{}'::jsonb` | `true` | `true`| `false` |
| `ecdsa_key_restriction` | `false` | `integer` | `integer` | `true` | `0` | `false` | `false`| `true` |
| `ecdsa_sk_key_restriction` | `false` | `integer` | `integer` | `true` | `0` | `false` | `false`| `true` |
| `ed25519_key_restriction` | `false` | `integer` | `integer` | `true` | `0` | `false` | `false`| `true` |
| `ed25519_sk_key_restriction` | `false` | `integer` | `integer` | `true` | `0` | `false` | `false`| `true` |
| `editor_extensions` | `false` | `jsonb` | `` | `true` | `'{}'::jsonb` | `false` | `true`| `false` |
| `eks_access_key_id` | `false` | `character` | `string` | `false` | `null` | `true` | `true`| `true` |
| `eks_account_id` | `false` | `character` | `string` | `false` | `null` | `true` | `true`| `true` |
| `eks_integration_enabled` | `false` | `boolean` | `boolean` | `true` | `false` | `true` | `true`| `true` |
| `eks_secret_access_key` | `true` | `text` | `string` | `false` | `null` | `true` | `true`| `true` |
| `elasticsearch` | `false` | `jsonb` | `` | `true` | `'{}'::jsonb` | `true` | `false`| `false` |
| `elasticsearch_aws_secret_access_key` | `true` | `text` | `string` | `false` | `null` | `true` | `false`| `true` |
| `elasticsearch_password` | `true` | `bytea` | `string` | `false` | `null` | `true` | `false`| `true` |
| `elasticsearch_url` | `false` | `character` | `string` | `false` | `'http://localhost:9200'::character` | `true` | `false`| `true` |
| `email_additional_text` | `false` | `character` | `string` | `false` | `null` | `true` | `true`| `true` |
| `email_author_in_body` | `false` | `boolean` | `boolean` | `false` | `false` | `false` | `true`| `true` |
| `email_confirmation_setting` | `false` | `smallint` | `string` | `false` | `0` | `true` | `true`| `true` |
| `email_restrictions` | `false` | `text` | `string` | `false` | `null` | `true` | `true`| `true` |
| `email_restrictions_enabled` | `false` | `boolean` | `boolean` | `true` | `false` | `true` | `true`| `true` |
| `enable_artifact_external_redirect_warning_page` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `enable_member_promotion_management` | `false` | `boolean` | `` | `true` | `false` | `false` | `false`| `false` |
| `enabled_git_access_protocol` | `false` | `character` | `string` | `false` | `null` | `true` | `true`| `true` |
| `enforce_ci_inbound_job_token_scope_enabled` | `false` | `boolean` | `` | `true` | `true` | `false` | `false`| `false` |
| `enforce_namespace_storage_limit` | `false` | `boolean` | `boolean` | `true` | `false` | `false` | `false`| `true` |
| `enforce_terms` | `false` | `boolean` | `boolean` | `false` | `false` | `true` | `true`| `true` |
| `error_tracking_access_token` | `true` | `text` | `` | `false` | `null` | `true` | `true`| `false` |
| `error_tracking_api_url` | `false` | `text` | `` | `false` | `null` | `true` | `true`| `false` |
| `error_tracking_enabled` | `false` | `boolean` | `` | `true` | `false` | `true` | `true`| `false` |
| `external_auth_client_cert` | `false` | `text` | `string` | `false` | `null` | `false` | `false`| `true` |
| `external_auth_client_key` | `true` | `text` | `string` | `false` | `null` | `false` | `false`| `true` |
| `external_auth_client_key_pass` | `true` | `character` | `string` | `false` | `null` | `false` | `false`| `true` |
| `external_authorization_service_default_label` | `false` | `character` | `string` | `false` | `null` | `true` | `false`| `true` |
| `external_authorization_service_enabled` | `false` | `boolean` | `boolean` | `true` | `false` | `false` | `false`| `true` |
| `external_authorization_service_timeout` | `false` | `double` | `float` | `false` | `0.5` | `false` | `false`| `true` |
| `external_authorization_service_url` | `false` | `character` | `string` | `false` | `null` | `true` | `false`| `true` |
| `external_pipeline_validation_service_timeout` | `false` | `integer` | `integer` | `false` | `null` | `true` | `true`| `true` |
| `external_pipeline_validation_service_token` | `true` | `text` | `string` | `false` | `null` | `true` | `true`| `true` |
| `external_pipeline_validation_service_url` | `false` | `text` | `string` | `false` | `null` | `true` | `true`| `true` |
| `failed_login_attempts_unlock_period_in_minutes` | `false` | `integer` | `integer` | `false` | `null` | `false` | `false`| `true` |
| `feishu_app_key` [JIHU] | `true` | `bytea` | `` | `false` | `null` | `false` | `false`| `false` |
| `feishu_app_secret` [JIHU] | `true` | `bytea` | `` | `false` | `null` | `false` | `false`| `false` |
| `feishu_integration_enabled` [JIHU] | `false` | `boolean` | `` | `true` | `false` | `false` | `false`| `false` |
| `file_template_project_id` | `false` | `bigint` | `integer` | `false` | `null` | `false` | `false`| `true` |
| `first_day_of_week` | `false` | `integer` | `integer` | `true` | `0` | `false` | `false`| `true` |
| `floc_enabled` | `false` | `boolean` | `` | `true` | `false` | `false` | `false`| `false` |
| `force_pages_access_control` | `false` | `boolean` | `` | `true` | `false` | `false` | `false`| `false` |
| `future_subscriptions` | `false` | `jsonb` | `` | `true` | `'[]'::jsonb` | `false` | `false`| `false` |
| `geo_node_allowed_ips` | `false` | `character` | `string` | `false` | `'0.0.0.0/0` | `false` | `false`| `true` |
| `geo_status_timeout` | `false` | `integer` | `integer` | `false` | `10` | `true` | `false`| `true` |
| `git_rate_limit_users_alertlist` | `false` | `integer[]` | `array of integers` | `true` | `'{}'::integer[]` | `false` | `false`| `true` |
| `git_rate_limit_users_allowlist` | `false` | `text[]` | `array of strings` | `true` | `'{}'::text[]` | `false` | `false`| `true` |
| `git_two_factor_session_expiry` | `false` | `integer` | `integer` | `true` | `15` | `false` | `false`| `true` |
| `gitaly_timeout_default` | `false` | `integer` | `integer` | `true` | `55` | `false` | `false`| `true` |
| `gitaly_timeout_fast` | `false` | `integer` | `integer` | `true` | `10` | `false` | `false`| `true` |
| `gitaly_timeout_medium` | `false` | `integer` | `integer` | `true` | `30` | `false` | `false`| `true` |
| `gitlab_dedicated_instance` | `false` | `boolean` | `boolean` | `true` | `false` | `false` | `false`| `true` |
| `gitlab_shell_operation_limit` | `false` | `integer` | `integer` | `false` | `600` | `false` | `false`| `true` |
| `gitpod_enabled` | `false` | `boolean` | `boolean` | `true` | `false` | `true` | `false`| `true` |
| `gitpod_url` | `false` | `text` | `string` | `false` | `'https://gitpod.io/'::text` | `false` | `false`| `true` |
| `globally_allowed_ips` | `false` | `text` | `string` | `true` | `''::text` | `true` | `true`| `true` |
| `grafana_enabled` | `false` | `boolean` | `boolean` | `true` | `false` | `false` | `false`| `true` |
| `grafana_url` | `false` | `character` | `string` | `true` | `'/-/grafana'::character` | `false` | `false`| `true` |
| `gravatar_enabled` | `false` | `boolean` | `boolean` | `false` | `null` | `true` | `true`| `true` |
| `group_download_export_limit` | `false` | `integer` | `` | `true` | `1` | `false` | `false`| `false` |
| `group_export_limit` | `false` | `integer` | `` | `true` | `6` | `false` | `false`| `false` |
| `group_import_limit` | `false` | `integer` | `` | `true` | `6` | `false` | `false`| `false` |
| `group_owners_can_manage_default_branch_protection` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `group_runner_token_expiration_interval` | `false` | `integer` | `integer` | `false` | `null` | `false` | `false`| `true` |
| `group_settings` | `false` | `jsonb` | `` | `true` | `'{}'::jsonb` | `true` | `false`| `false` |
| `hashed_storage_enabled` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `health_check_access_token` | `false` | `character` | `` | `false` | `null` | `true` | `true`| `false` |
| `help_page_documentation_base_url` | `false` | `text` | `` | `false` | `null` | `true` | `true`| `false` |
| `help_page_hide_commercial_content` | `false` | `boolean` | `boolean` | `false` | `false` | `false` | `true`| `true` |
| `help_page_support_url` | `false` | `character` | `string` | `false` | `null` | `true` | `true`| `true` |
| `help_page_text` | `false` | `text` | `string` | `false` | `null` | `true` | `true`| `true` |
| `hide_third_party_offers` | `false` | `boolean` | `boolean` | `true` | `false` | `false` | `false`| `true` |
| `home_page_url` | `false` | `character` | `string` | `false` | `null` | `true` | `true`| `true` |
| `housekeeping_bitmaps_enabled` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `housekeeping_enabled` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `housekeeping_full_repack_period` | `false` | `integer` | `integer` | `true` | `50` | `false` | `false`| `true` |
| `housekeeping_gc_period` | `false` | `integer` | `integer` | `true` | `200` | `false` | `false`| `true` |
| `housekeeping_incremental_repack_period` | `false` | `integer` | `integer` | `true` | `10` | `false` | `false`| `true` |
| `html_emails_enabled` | `false` | `boolean` | `boolean` | `false` | `true` | `false` | `false`| `true` |
| `id` | `false` | `bigint` | `` | `true` | `???` | `false` | `false`| `false` |
| `identity_verification_settings` | `false` | `jsonb` | `` | `true` | `'{}'::jsonb` | `true` | `true`| `false` |
| `import_sources` | `false` | `text` | `array of strings` | `false` | `null` | `true` | `true`| `true` |
| `importers` | `false` | `jsonb` | `` | `true` | `'{}'::jsonb` | `true` | `true`| `false` |
| `inactive_projects_delete_after_months` | `false` | `integer` | `` | `true` | `2` | `false` | `false`| `false` |
| `inactive_projects_min_size_mb` | `false` | `integer` | `` | `true` | `0` | `false` | `false`| `false` |
| `inactive_projects_send_warning_email_after_months` | `false` | `integer` | `` | `true` | `1` | `false` | `false`| `false` |
| `include_optional_metrics_in_service_ping` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `instance_level_ai_beta_features_enabled` | `false` | `boolean` | `` | `true` | `false` | `false` | `false`| `false` |
| `integrations` | `false` | `jsonb` | `` | `true` | `'{}'::jsonb` | `true` | `true`| `false` |
| `invisible_captcha_enabled` | `false` | `boolean` | `boolean` | `true` | `false` | `true` | `true`| `true` |
| `invitation_flow_enforcement` | `false` | `boolean` | `` | `true` | `false` | `false` | `false`| `false` |
| `issues_create_limit` | `false` | `integer` | `integer` | `true` | `0` | `true` | `true`| `true` |
| `jira_connect_application_key` | `false` | `text` | `string` | `false` | `null` | `true` | `true`| `true` |
| `jira_connect_proxy_url` | `false` | `text` | `string` | `false` | `null` | `true` | `true`| `true` |
| `jira_connect_public_key_storage_enabled` | `false` | `boolean` | `boolean` | `true` | `false` | `true` | `true`| `true` |
| `jobs_per_stage_page_size` | `false` | `integer` | `` | `true` | `200` | `false` | `false`| `false` |
| `keep_latest_artifact` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `kroki_enabled` | `false` | `boolean` | `boolean` | `false` | `null` | `false` | `false`| `true` |
| `kroki_formats` | `false` | `jsonb` | `object` | `true` | `'{}'::jsonb` | `false` | `false`| `true` |
| `kroki_url` | `false` | `character` | `string` | `false` | `null` | `false` | `false`| `true` |
| `lets_encrypt_notification_email` | `false` | `character` | `` | `false` | `null` | `true` | `true`| `false` |
| `lets_encrypt_private_key` | `true` | `text` | `` | `false` | `null` | `true` | `true`| `false` |
| `lets_encrypt_terms_of_service_accepted` | `false` | `boolean` | `` | `true` | `false` | `true` | `true`| `false` |
| `license_trial_ends_on` | `false` | `date` | `` | `false` | `null` | `false` | `false`| `false` |
| `license_usage_data_exported` | `false` | `boolean` | `` | `true` | `false` | `false` | `false`| `false` |
| `local_markdown_version` | `false` | `integer` | `integer` | `true` | `0` | `true` | `false`| `true` |
| `lock_duo_features_enabled` | `false` | `boolean` | `boolean` | `true` | `false` | `false` | `false`| `true` |
| `lock_math_rendering_limits_enabled` | `false` | `boolean` | `` | `true` | `false` | `false` | `false`| `false` |
| `lock_memberships_to_ldap` | `false` | `boolean` | `` | `true` | `false` | `false` | `false`| `false` |
| `lock_memberships_to_saml` | `false` | `boolean` | `boolean` | `true` | `false` | `false` | `false`| `true` |
| `lock_model_prompt_cache_enabled` | `false` | `boolean` | `` | `true` | `false` | `false` | `false`| `false` |
| `lock_spp_repository_pipeline_access` | `false` | `boolean` | `` | `true` | `false` | `false` | `false`| `false` |
| `lock_web_based_commit_signing_enabled` | `false` | `boolean` | `` | `true` | `false` | `false` | `false`| `false` |
| `login_recaptcha_protection_enabled` | `false` | `boolean` | `boolean` | `true` | `false` | `false` | `false`| `true` |
| `mailgun_events_enabled` | `false` | `boolean` | `boolean` | `true` | `false` | `true` | `true`| `true` |
| `mailgun_signing_key` | `true` | `bytea` | `string` | `false` | `null` | `true` | `true`| `true` |
| `maintenance_mode` | `false` | `boolean` | `boolean` | `true` | `false` | `false` | `false`| `true` |
| `maintenance_mode_message` | `false` | `text` | `string` | `false` | `null` | `false` | `false`| `true` |
| `make_profile_private` | `false` | `boolean` | `` | `true` | `true` | `false` | `false`| `false` |
| `math_rendering_limits_enabled` | `false` | `boolean` | `` | `true` | `true` | `false` | `false`| `false` |
| `max_artifacts_content_include_size` | `false` | `integer` | `` | `true` | `5242880` | `false` | `false`| `false` |
| `max_artifacts_size` | `false` | `integer` | `integer` | `true` | `100` | `true` | `false`| `true` |
| `max_attachment_size` | `false` | `integer` | `integer` | `true` | `100` | `false` | `false`| `true` |
| `max_decompressed_archive_size` | `false` | `integer` | `integer` | `true` | `25600` | `false` | `false`| `true` |
| `max_export_size` | `false` | `integer` | `integer` | `false` | `0` | `true` | `true`| `true` |
| `max_import_remote_file_size` | `false` | `bigint` | `integer` | `true` | `10240` | `false` | `false`| `true` |
| `max_import_size` | `false` | `integer` | `integer` | `true` | `0` | `true` | `true`| `true` |
| `max_login_attempts` | `false` | `integer` | `integer` | `false` | `null` | `false` | `false`| `true` |
| `max_number_of_repository_downloads` | `false` | `smallint` | `integer` | `true` | `0` | `false` | `false`| `true` |
| `max_number_of_repository_downloads_within_time_period` | `false` | `integer` | `integer` | `true` | `0` | `false` | `false`| `true` |
| `max_number_of_vulnerabilities_per_project` | `false` | `integer` | `` | `false` | `null` | `false` | `false`| `false` |
| `max_pages_custom_domains_per_project` | `false` | `integer` | `` | `true` | `0` | `true` | `false`| `false` |
| `max_pages_size` | `false` | `integer` | `integer` | `true` | `100` | `true` | `false`| `true` |
| `max_personal_access_token_lifetime` | `false` | `integer` | `integer` | `false` | `null` | `false` | `false`| `true` |
| `max_ssh_key_lifetime` | `false` | `integer` | `integer` | `false` | `null` | `false` | `false`| `true` |
| `max_terraform_state_size_bytes` | `false` | `integer` | `integer` | `true` | `0` | `false` | `false`| `true` |
| `max_yaml_depth` | `false` | `integer` | `integer` | `true` | `100` | `false` | `false`| `true` |
| `max_yaml_size_bytes` | `false` | `bigint` | `integer` | `true` | `2097152` | `false` | `false`| `true` |
| `metrics_enabled` | `false` | `boolean` | `` | `false` | `false` | `true` | `true`| `false` |
| `metrics_host` | `false` | `character` | `` | `false` | `'localhost'::character` | `false` | `false`| `false` |
| `metrics_method_call_threshold` | `false` | `integer` | `integer` | `false` | `10` | `true` | `true`| `true` |
| `metrics_packet_size` | `false` | `integer` | `` | `false` | `1` | `true` | `true`| `false` |
| `metrics_pool_size` | `false` | `integer` | `` | `false` | `16` | `false` | `true`| `false` |
| `metrics_port` | `false` | `integer` | `` | `false` | `8089` | `true` | `true`| `false` |
| `metrics_sample_interval` | `false` | `integer` | `` | `false` | `15` | `false` | `true`| `false` |
| `metrics_timeout` | `false` | `integer` | `` | `false` | `10` | `false` | `true`| `false` |
| `minimum_password_length` | `false` | `integer` | `integer` | `true` | `8` | `false` | `false`| `true` |
| `mirror_available` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `mirror_capacity_threshold` | `false` | `integer` | `integer` | `true` | `50` | `true` | `false`| `true` |
| `mirror_max_capacity` | `false` | `integer` | `integer` | `true` | `100` | `true` | `false`| `true` |
| `mirror_max_delay` | `false` | `integer` | `integer` | `true` | `300` | `true` | `false`| `true` |
| `model_prompt_cache_enabled` | `false` | `boolean` | `` | `true` | `true` | `false` | `false`| `false` |
| `namespace_aggregation_schedule_lease_duration_in_seconds` | `false` | `integer` | `` | `true` | `300` | `false` | `false`| `false` |
| `namespace_storage_forks_cost_factor` | `false` | `double` | `` | `true` | `1.0` | `true` | `false`| `false` |
| `new_user_signups_cap` | `false` | `integer` | `` | `false` | `null` | `false` | `false`| `false` |
| `notes_create_limit` | `false` | `integer` | `` | `true` | `300` | `true` | `true`| `false` |
| `notes_create_limit_allowlist` | `false` | `text[]` | `` | `true` | `'{}'::text[]` | `true` | `true`| `false` |
| `notify_on_unknown_sign_in` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `oauth_provider` | `false` | `jsonb` | `` | `true` | `'{}'::jsonb` | `true` | `true`| `false` |
| `observability_backend_ssl_verification_enabled` | `false` | `boolean` | `` | `true` | `true` | `false` | `false`| `false` |
| `observability_settings` | `false` | `jsonb` | `` | `true` | `'{}'::jsonb` | `true` | `false`| `false` |
| `outbound_local_requests_whitelist` | `false` | `character` | `array of strings` | `true` | `'{}'::character` | `true` | `true`| `true` |
| `package_metadata_purl_types` | `false` | `smallint[]` | `array of integers` | `false` | `'{1` | `false` | `false`| `true` |
| `package_registry` | `false` | `jsonb` | `` | `true` | `'{}'::jsonb` | `true` | `false`| `false` |
| `pages` | `false` | `jsonb` | `` | `true` | `'{}'::jsonb` | `true` | `false`| `false` |
| `pages_domain_verification_enabled` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `password_authentication_enabled_for_git` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `password_authentication_enabled_for_web` | `false` | `boolean` | `boolean` | `false` | `null` | `true` | `false`| `true` |
| `password_expiration_enabled` [JIHU] | `false` | `boolean` | `` | `true` | `false` | `false` | `false`| `false` |
| `password_expires_in_days` [JIHU] | `false` | `integer` | `` | `true` | `90` | `false` | `false`| `false` |
| `password_expires_notice_before_days` [JIHU] | `false` | `integer` | `` | `true` | `7` | `false` | `false`| `false` |
| `password_lowercase_required` | `false` | `boolean` | `boolean` | `true` | `false` | `false` | `false`| `true` |
| `password_number_required` | `false` | `boolean` | `boolean` | `true` | `false` | `false` | `false`| `true` |
| `password_symbol_required` | `false` | `boolean` | `boolean` | `true` | `false` | `false` | `false`| `true` |
| `password_uppercase_required` | `false` | `boolean` | `boolean` | `true` | `false` | `false` | `false`| `true` |
| `performance_bar_allowed_group_id` | `false` | `bigint` | `string` | `false` | `null` | `true` | `false`| `true` |
| `personal_access_token_prefix` | `false` | `text` | `string` | `false` | `'glpat-'::text` | `false` | `false`| `true` |
| `phone_verification_code_enabled` [JIHU] | `false` | `boolean` | `` | `true` | `false` | `false` | `false`| `false` |
| `pipeline_limit_per_project_user_sha` | `false` | `integer` | `integer` | `true` | `0` | `true` | `false`| `true` |
| `plantuml_enabled` | `false` | `boolean` | `boolean` | `false` | `null` | `true` | `true`| `true` |
| `plantuml_url` | `false` | `character` | `string` | `false` | `null` | `true` | `true`| `true` |
| `polling_interval_multiplier` | `false` | `numeric` | `float` | `true` | `1.0` | `false` | `false`| `true` |
| `pre_receive_secret_detection_enabled` | `false` | `boolean` | `` | `true` | `false` | `false` | `true`| `false` |
| `prevent_merge_requests_author_approval` | `false` | `boolean` | `boolean` | `true` | `false` | `false` | `false`| `true` |
| `prevent_merge_requests_committers_approval` | `false` | `boolean` | `boolean` | `true` | `false` | `false` | `false`| `true` |
| `product_analytics_configurator_connection_string` | `true` | `bytea` | `` | `false` | `null` | `true` | `false`| `false` |
| `product_analytics_data_collector_host` | `false` | `text` | `` | `false` | `null` | `true` | `false`| `false` |
| `product_analytics_enabled` | `false` | `boolean` | `` | `true` | `false` | `true` | `false`| `false` |
| `productivity_analytics_start_date` | `false` | `timestamp` | `` | `false` | `null` | `true` | `false`| `false` |
| `project_download_export_limit` | `false` | `integer` | `` | `true` | `1` | `false` | `false`| `false` |
| `project_export_enabled` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `project_export_limit` | `false` | `integer` | `` | `true` | `6` | `false` | `false`| `false` |
| `project_import_limit` | `false` | `integer` | `` | `true` | `6` | `false` | `false`| `false` |
| `project_jobs_api_rate_limit` | `false` | `integer` | `integer` | `true` | `600` | `false` | `false`| `true` |
| `project_runner_token_expiration_interval` | `false` | `integer` | `integer` | `false` | `null` | `false` | `false`| `true` |
| `projects_api_rate_limit_unauthenticated` | `false` | `integer` | `integer` | `true` | `400` | `false` | `false`| `true` |
| `prometheus_alert_db_indicators_settings` | `false` | `jsonb` | `` | `false` | `null` | `true` | `false`| `false` |
| `prometheus_metrics_enabled` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `protected_ci_variables` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `protected_paths` | `false` | `character` | `` | `false` | `'{/users/password` | `false` | `false`| `false` |
| `protected_paths_for_get_request` | `false` | `text[]` | `` | `true` | `'{}'::text[]` | `false` | `false`| `false` |
| `pseudonymizer_enabled` | `false` | `boolean` | `` | `true` | `false` | `false` | `false`| `false` |
| `public_runner_releases_url` | `false` | `text` | `` | `true` | `'https://gitlab.com/api/v4/projects/gitlab-org%2Fgitlab-runner/releases'::text` | `false` | `false`| `false` |
| `push_event_activities_limit` | `false` | `integer` | `integer` | `true` | `3` | `false` | `false`| `true` |
| `push_event_hooks_limit` | `false` | `integer` | `integer` | `true` | `3` | `false` | `false`| `true` |
| `push_rule_id` | `false` | `bigint` | `` | `false` | `null` | `true` | `false`| `false` |
| `rate_limiting_response_text` | `false` | `text` | `string` | `false` | `null` | `true` | `true`| `true` |
| `rate_limits` | `false` | `jsonb` | `` | `true` | `'{}'::jsonb` | `true` | `true`| `false` |
| `rate_limits_unauthenticated_git_http` | `false` | `jsonb` | `` | `true` | `'{}'::jsonb` | `true` | `true`| `false` |
| `raw_blob_request_limit` | `false` | `integer` | `integer` | `true` | `300` | `false` | `false`| `true` |
| `recaptcha_enabled` | `false` | `boolean` | `boolean` | `false` | `false` | `true` | `true`| `true` |
| `recaptcha_private_key` | `true` | `text` | `string` | `false` | `null` | `true` | `true`| `true` |
| `recaptcha_site_key` | `true` | `text` | `string` | `false` | `null` | `true` | `true`| `true` |
| `receive_max_input_size` | `false` | `integer` | `integer` | `false` | `null` | `true` | `false`| `true` |
| `remember_me_enabled` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `repository_checks_enabled` | `false` | `boolean` | `boolean` | `false` | `false` | `false` | `false`| `true` |
| `repository_size_limit` | `false` | `bigint` | `integer` | `false` | `0` | `true` | `true`| `true` |
| `repository_storages` | `false` | `character` | `` | `false` | `'default'::character` | `true` | `false`| `false` |
| `repository_storages_weighted` | `false` | `jsonb` | `hash of strings to integers` | `true` | `'{}'::jsonb` | `true` | `true`| `true` |
| `require_admin_approval_after_user_signup` | `false` | `boolean` | `boolean` | `true` | `true` | `true` | `false`| `true` |
| `require_admin_two_factor_authentication` | `false` | `boolean` | `boolean` | `true` | `false` | `true` | `true`| `true` |
| `require_personal_access_token_expiry` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `require_two_factor_authentication` | `false` | `boolean` | `boolean` | `false` | `false` | `false` | `false`| `true` |
| `required_instance_ci_template` | `false` | `text` | `` | `false` | `null` | `false` | `false`| `false` |
| `resource_access_tokens_settings` | `false` | `jsonb` | `` | `true` | `'{}'::jsonb` | `false` | `true`| `false` |
| `resource_usage_limits` | `false` | `jsonb` | `hash` | `true` | `'{}'::jsonb` | `false` | `false`| `true` |
| `response_limits` | `false` | `jsonb` | `` | `true` | `'{}'::jsonb` | `true` | `true`| `false` |
| `restricted_visibility_levels` | `false` | `text` | `array of strings` | `false` | `null` | `true` | `false`| `true` |
| `rsa_key_restriction` | `false` | `integer` | `integer` | `true` | `0` | `false` | `false`| `true` |
| `runner_token_expiration_interval` | `false` | `integer` | `integer` | `false` | `null` | `false` | `false`| `true` |
| `runners_registration_token` | `true` | `character` | `` | `false` | `null` | `true` | `false`| `false` |
| `sdrs_enabled` | `false` | `boolean` | `` | `true` | `false` | `false` | `true`| `false` |
| `sdrs_jwt_signing_key` | `true` | `jsonb` | `` | `false` | `null` | `false` | `true`| `false` |
| `sdrs_url` | `false` | `text` | `` | `false` | `null` | `false` | `true`| `false` |
| `search` | `false` | `jsonb` | `` | `true` | `'{}'::jsonb` | `true` | `false`| `false` |
| `search_max_docs_denominator` | `false` | `integer` | `` | `true` | `5000000` | `false` | `false`| `false` |
| `search_max_shard_size_gb` | `false` | `integer` | `` | `true` | `50` | `false` | `false`| `false` |
| `search_min_docs_before_rollover` | `false` | `integer` | `` | `true` | `100000` | `false` | `false`| `false` |
| `search_rate_limit` | `false` | `integer` | `integer` | `true` | `300` | `true` | `false`| `true` |
| `search_rate_limit_allowlist` | `false` | `text[]` | `` | `true` | `'{}'::text[]` | `true` | `false`| `false` |
| `search_rate_limit_unauthenticated` | `false` | `integer` | `integer` | `true` | `100` | `false` | `false`| `true` |
| `secret_detection_revocation_token_types_url` | `false` | `text` | `` | `false` | `null` | `true` | `false`| `false` |
| `secret_detection_service_auth_token` | `true` | `bytea` | `` | `false` | `null` | `true` | `false`| `false` |
| `secret_detection_service_url` | `false` | `text` | `` | `true` | `''::text` | `true` | `false`| `false` |
| `secret_detection_token_revocation_enabled` | `false` | `boolean` | `` | `true` | `false` | `true` | `false`| `false` |
| `secret_detection_token_revocation_token` | `true` | `text` | `` | `false` | `null` | `true` | `false`| `false` |
| `secret_detection_token_revocation_url` | `false` | `text` | `` | `false` | `null` | `true` | `false`| `false` |
| `secret_push_protection_available` | `false` | `boolean` | `boolean` | `false` | `false` | `true` | `true`| `true` |
| `security_and_compliance_settings` | `false` | `jsonb` | `` | `true` | `'{}'::jsonb` | `false` | `false`| `false` |
| `security_approval_policies_limit` | `false` | `integer` | `integer` | `true` | `5` | `false` | `false`| `true` |
| `security_policies` | `false` | `jsonb` | `` | `true` | `'{}'::jsonb` | `true` | `false`| `false` |
| `security_policy_global_group_approvers_enabled` | `false` | `boolean` | `boolean` | `true` | `true` | `true` | `false`| `true` |
| `security_txt_content` | `false` | `text` | `string` | `false` | `null` | `true` | `true`| `true` |
| `sentry_clientside_dsn` | `false` | `text` | `` | `false` | `null` | `true` | `false`| `false` |
| `sentry_clientside_traces_sample_rate` | `false` | `double` | `` | `true` | `0.0` | `true` | `false`| `false` |
| `sentry_dsn` | `false` | `text` | `` | `false` | `null` | `true` | `false`| `false` |
| `sentry_enabled` | `false` | `boolean` | `` | `true` | `false` | `true` | `false`| `false` |
| `sentry_environment` | `false` | `text` | `` | `false` | `null` | `true` | `false`| `false` |
| `service_access_tokens_expiration_enforced` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `service_ping_settings` | `false` | `jsonb` | `` | `true` | `'{}'::jsonb` | `true` | `false`| `false` |
| `session_expire_delay` | `false` | `integer` | `integer` | `true` | `10080` | `false` | `false`| `true` |
| `shared_runners_enabled` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `shared_runners_minutes` | `false` | `integer` | `integer` | `true` | `0` | `true` | `false`| `true` |
| `shared_runners_text` | `false` | `text` | `string` | `false` | `null` | `true` | `false`| `true` |
| `show_migrate_from_jenkins_banner` | `false` | `boolean` | `` | `true` | `true` | `false` | `false`| `false` |
| `sidekiq_job_limiter_compression_threshold_bytes` | `false` | `integer` | `integer` | `true` | `100000` | `false` | `false`| `true` |
| `sidekiq_job_limiter_limit_bytes` | `false` | `integer` | `integer` | `true` | `0` | `true` | `false`| `true` |
| `sidekiq_job_limiter_mode` | `false` | `smallint` | `string` | `true` | `1` | `false` | `false`| `true` |
| `sign_in_restrictions` | `false` | `jsonb` | `hash` | `true` | `'{}'::jsonb` | `false` | `false`| `true` |
| `signup_enabled` | `false` | `boolean` | `boolean` | `false` | `null` | `true` | `false`| `true` |
| `silent_mode_enabled` | `false` | `boolean` | `boolean` | `true` | `false` | `false` | `false`| `true` |
| `slack_app_enabled` | `false` | `boolean` | `boolean` | `false` | `false` | `true` | `false`| `true` |
| `slack_app_id` | `false` | `character` | `string` | `false` | `null` | `true` | `false`| `true` |
| `slack_app_secret` | `true` | `text` | `string` | `false` | `null` | `true` | `false`| `true` |
| `slack_app_signing_secret` | `true` | `bytea` | `string` | `false` | `null` | `true` | `false`| `true` |
| `slack_app_verification_token` | `true` | `text` | `string` | `false` | `null` | `true` | `false`| `true` |
| `snippet_size_limit` | `false` | `bigint` | `integer` | `true` | `52428800` | `false` | `false`| `true` |
| `snowplow_app_id` | `false` | `character` | `string` | `false` | `null` | `true` | `false`| `true` |
| `snowplow_collector_hostname` | `false` | `character` | `string` | `false` | `null` | `true` | `false`| `true` |
| `snowplow_cookie_domain` | `false` | `character` | `string` | `false` | `null` | `true` | `false`| `true` |
| `snowplow_database_collector_hostname` | `false` | `text` | `string` | `false` | `null` | `false` | `false`| `true` |
| `snowplow_enabled` | `false` | `boolean` | `boolean` | `true` | `false` | `true` | `false`| `true` |
| `sourcegraph_enabled` | `false` | `boolean` | `boolean` | `true` | `false` | `true` | `false`| `true` |
| `sourcegraph_public_only` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `sourcegraph_url` | `false` | `character` | `string` | `false` | `null` | `true` | `false`| `true` |
| `spam_check_api_key` | `true` | `bytea` | `string` | `false` | `null` | `true` | `true`| `true` |
| `spam_check_endpoint_enabled` | `false` | `boolean` | `boolean` | `true` | `false` | `true` | `true`| `true` |
| `spam_check_endpoint_url` | `false` | `text` | `string` | `false` | `null` | `true` | `true`| `true` |
| `spp_repository_pipeline_access` | `false` | `boolean` | `` | `true` | `false` | `false` | `false`| `false` |
| `static_objects_external_storage_auth_token` | `true` | `text` | `string` | `false` | `null` | `true` | `false`| `true` |
| `static_objects_external_storage_url` | `false` | `character` | `string` | `false` | `null` | `true` | `false`| `true` |
| `suggest_pipeline_enabled` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `telesign_api_key` | `true` | `bytea` | `` | `false` | `null` | `true` | `true`| `false` |
| `telesign_customer_xid` | `true` | `bytea` | `` | `false` | `null` | `true` | `true`| `false` |
| `terminal_max_session_time` | `false` | `integer` | `integer` | `true` | `0` | `false` | `false`| `true` |
| `throttle_authenticated_api_enabled` | `false` | `boolean` | `boolean` | `true` | `false` | `true` | `false`| `true` |
| `throttle_authenticated_api_period_in_seconds` | `false` | `integer` | `integer` | `true` | `3600` | `true` | `false`| `true` |
| `throttle_authenticated_api_requests_per_period` | `false` | `integer` | `integer` | `true` | `7200` | `true` | `false`| `true` |
| `throttle_authenticated_deprecated_api_enabled` | `false` | `boolean` | `` | `true` | `false` | `false` | `false`| `false` |
| `throttle_authenticated_deprecated_api_period_in_seconds` | `false` | `integer` | `` | `true` | `3600` | `true` | `false`| `false` |
| `throttle_authenticated_deprecated_api_requests_per_period` | `false` | `integer` | `` | `true` | `3600` | `false` | `false`| `false` |
| `throttle_authenticated_files_api_enabled` | `false` | `boolean` | `` | `true` | `false` | `false` | `false`| `false` |
| `throttle_authenticated_files_api_period_in_seconds` | `false` | `integer` | `` | `true` | `15` | `false` | `false`| `false` |
| `throttle_authenticated_files_api_requests_per_period` | `false` | `integer` | `` | `true` | `500` | `false` | `false`| `false` |
| `throttle_authenticated_git_lfs_enabled` | `false` | `boolean` | `` | `true` | `false` | `false` | `false`| `false` |
| `throttle_authenticated_git_lfs_period_in_seconds` | `false` | `integer` | `` | `true` | `60` | `false` | `false`| `false` |
| `throttle_authenticated_git_lfs_requests_per_period` | `false` | `integer` | `` | `true` | `1000` | `false` | `false`| `false` |
| `throttle_authenticated_packages_api_enabled` | `false` | `boolean` | `boolean` | `true` | `false` | `false` | `false`| `true` |
| `throttle_authenticated_packages_api_period_in_seconds` | `false` | `integer` | `integer` | `true` | `15` | `false` | `false`| `true` |
| `throttle_authenticated_packages_api_requests_per_period` | `false` | `integer` | `integer` | `true` | `1000` | `false` | `false`| `true` |
| `throttle_authenticated_web_enabled` | `false` | `boolean` | `boolean` | `true` | `false` | `true` | `false`| `true` |
| `throttle_authenticated_web_period_in_seconds` | `false` | `integer` | `integer` | `true` | `3600` | `true` | `false`| `true` |
| `throttle_authenticated_web_requests_per_period` | `false` | `integer` | `integer` | `true` | `7200` | `true` | `false`| `true` |
| `throttle_incident_management_notification_enabled` | `false` | `boolean` | `` | `true` | `false` | `true` | `false`| `false` |
| `throttle_incident_management_notification_per_period` | `false` | `integer` | `` | `false` | `3600` | `false` | `false`| `false` |
| `throttle_incident_management_notification_period_in_seconds` | `false` | `integer` | `` | `false` | `3600` | `false` | `false`| `false` |
| `throttle_protected_paths_enabled` | `false` | `boolean` | `` | `true` | `false` | `true` | `false`| `false` |
| `throttle_protected_paths_period_in_seconds` | `false` | `integer` | `` | `true` | `60` | `false` | `false`| `false` |
| `throttle_protected_paths_requests_per_period` | `false` | `integer` | `` | `true` | `10` | `false` | `false`| `false` |
| `throttle_unauthenticated_api_enabled` | `false` | `boolean` | `boolean` | `true` | `false` | `true` | `false`| `true` |
| `throttle_unauthenticated_api_period_in_seconds` | `false` | `integer` | `integer` | `true` | `3600` | `true` | `false`| `true` |
| `throttle_unauthenticated_api_requests_per_period` | `false` | `integer` | `integer` | `true` | `3600` | `true` | `false`| `true` |
| `throttle_unauthenticated_deprecated_api_enabled` | `false` | `boolean` | `` | `true` | `false` | `false` | `false`| `false` |
| `throttle_unauthenticated_deprecated_api_period_in_seconds` | `false` | `integer` | `` | `true` | `3600` | `false` | `false`| `false` |
| `throttle_unauthenticated_deprecated_api_requests_per_period` | `false` | `integer` | `` | `true` | `1800` | `true` | `false`| `false` |
| `throttle_unauthenticated_enabled` | `false` | `boolean` | `boolean` | `true` | `false` | `true` | `false`| `true` |
| `throttle_unauthenticated_files_api_enabled` | `false` | `boolean` | `` | `true` | `false` | `false` | `false`| `false` |
| `throttle_unauthenticated_files_api_period_in_seconds` | `false` | `integer` | `` | `true` | `15` | `false` | `false`| `false` |
| `throttle_unauthenticated_files_api_requests_per_period` | `false` | `integer` | `` | `true` | `125` | `false` | `false`| `false` |
| `throttle_unauthenticated_packages_api_enabled` | `false` | `boolean` | `boolean` | `true` | `false` | `false` | `false`| `true` |
| `throttle_unauthenticated_packages_api_period_in_seconds` | `false` | `integer` | `integer` | `true` | `15` | `false` | `false`| `true` |
| `throttle_unauthenticated_packages_api_requests_per_period` | `false` | `integer` | `integer` | `true` | `800` | `false` | `false`| `true` |
| `throttle_unauthenticated_period_in_seconds` | `false` | `integer` | `integer` | `true` | `3600` | `true` | `false`| `true` |
| `throttle_unauthenticated_requests_per_period` | `false` | `integer` | `integer` | `true` | `3600` | `true` | `false`| `true` |
| `time_tracking_limit_to_hours` | `false` | `boolean` | `boolean` | `true` | `false` | `true` | `false`| `true` |
| `token_prefixes` | `false` | `jsonb` | `` | `true` | `'{}'::jsonb` | `false` | `true`| `false` |
| `transactional_emails` | `false` | `jsonb` | `` | `true` | `'{}'::jsonb` | `true` | `false`| `false` |
| `two_factor_grace_period` | `false` | `integer` | `integer` | `false` | `48` | `true` | `false`| `true` |
| `unconfirmed_users_delete_after_days` | `false` | `integer` | `integer` | `true` | `7` | `true` | `true`| `true` |
| `unique_ips_limit_enabled` | `false` | `boolean` | `boolean` | `true` | `false` | `false` | `false`| `true` |
| `unique_ips_limit_per_user` | `false` | `integer` | `integer` | `false` | `null` | `true` | `false`| `true` |
| `unique_ips_limit_time_window` | `false` | `integer` | `integer` | `false` | `null` | `true` | `false`| `true` |
| `update_namespace_name_rate_limit` | `false` | `smallint` | `` | `true` | `120` | `false` | `false`| `false` |
| `update_runner_versions_enabled` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `updated_at` | `false` | `timestamp` | `` | `false` | `null` | `true` | `false`| `false` |
| `updating_name_disabled_for_users` | `false` | `boolean` | `boolean` | `true` | `false` | `false` | `false`| `true` |
| `usage_ping_enabled` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `usage_ping_features_enabled` | `false` | `boolean` | `` | `true` | `false` | `false` | `false`| `false` |
| `usage_stats_set_by_user_id` | `false` | `bigint` | `` | `false` | `null` | `true` | `false`| `false` |
| `user_deactivation_emails_enabled` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `user_default_external` | `false` | `boolean` | `boolean` | `true` | `false` | `false` | `false`| `true` |
| `user_default_internal_regex` | `false` | `character` | `string` | `false` | `null` | `true` | `false`| `true` |
| `user_defaults_to_private_profile` | `false` | `boolean` | `boolean` | `true` | `false` | `false` | `false`| `true` |
| `user_oauth_applications` | `false` | `boolean` | `boolean` | `false` | `true` | `false` | `false`| `true` |
| `user_seat_management` | `false` | `jsonb` | `` | `true` | `'{}'::jsonb` | `false` | `true`| `false` |
| `user_show_add_ssh_key_message` | `false` | `boolean` | `boolean` | `true` | `true` | `false` | `false`| `true` |
| `users_get_by_id_limit` | `false` | `integer` | `` | `true` | `300` | `false` | `false`| `false` |
| `users_get_by_id_limit_allowlist` | `false` | `text[]` | `` | `true` | `'{}'::text[]` | `true` | `false`| `false` |
| `uuid` | `false` | `character` | `` | `false` | `null` | `true` | `true`| `false` |
| `valid_runner_registrars` | `false` | `character` | `array of strings` | `false` | `'{project` | `false` | `false`| `true` |
| `version_check_enabled` | `false` | `boolean` | `boolean` | `false` | `true` | `false` | `false`| `true` |
| `vertex_ai_host` | `false` | `text` | `` | `false` | `null` | `false` | `false`| `false` |
| `vertex_ai_project` | `false` | `text` | `` | `false` | `null` | `true` | `false`| `false` |
| `vscode_extension_marketplace` | `false` | `jsonb` | `hash` | `true` | `'{}'::jsonb` | `false` | `false`| `true` |
| `web_based_commit_signing_enabled` | `false` | `boolean` | `` | `true` | `false` | `false` | `false`| `false` |
| `web_ide_oauth_application_id` | `false` | `bigint` | `` | `false` | `null` | `true` | `false`| `false` |
| `whats_new_variant` | `false` | `smallint` | `string` | `false` | `0` | `false` | `false`| `true` |
| `wiki_asciidoc_allow_uri_includes` | `false` | `boolean` | `` | `true` | `false` | `false` | `false`| `false` |
| `wiki_page_max_content_bytes` | `false` | `bigint` | `integer` | `true` | `52428800` | `false` | `false`| `true` |
| `zoekt_settings` | `false` | `jsonb` | `` | `true` | `'{}'::jsonb` | `true` | `false`| `false` |
