---
stage: Software Supply Chain Security
group: Authorization
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Fine-grained permissions for CI/CD job tokens
---

<!--
  This documentation is auto-generated by a Rake task.

  Please do not edit this file directly. To update this file, run:
  `bundle exec rake ci:job_tokens:compile_docs`.

  To make changes to the output of the Rake task,
  edit `tooling/ci/job_tokens/docs/templates/fine_grained_permissions.md.erb`.
-->

{{< details >}}

- Tier: Free, Premium, Ultimate
- Offering: GitLab.com, GitLab Self-Managed, GitLab Dedicated
- Status: Beta

{{< /details >}}

{{< history >}}

- [Introduced](https://gitlab.com/groups/gitlab-org/-/epics/15234) as an [experiment](../../policy/development_stages_support.md#experiment) in GitLab 17.10.
- [Changed](https://gitlab.com/groups/gitlab-org/-/epics/16199) from experiment to beta in GitLab 18.0.

{{< /history >}}

You can use fine-grained permissions to explicitly allow access to a limited set of API endpoints.
These permissions are applied to the CI/CD job tokens in a specified project.

This feature is in [beta](../../policy/development_stages_support.md#beta).

## Add fine-grained permissions to the job token allowlist

Prerequisites:

- You must have at least the Maintainer role for the project.
- You must enable the use of fine-grained permissions for a project.

You can add fine-grained permissions to groups and projects on your job token allowlist. This allows
them to use job tokens to access specific project resources and more accurately control which
resources are available to these groups and projects.

To add fine-grained permissions to groups or projects on the job token allowlist:

1. On the left sidebar, select **Search or go to** and find your project.
1. Select **Settings > CI/CD**.
1. Expand **Job token permissions**.
1. In the **CI/CD job token allowlist** section, select **Add**.
1. From the dropdown list, select **Group or project**.
1. Enter the path to an existing group or project.
1. Select **Fine-grained permissions**.
1. Grant permissions to the [available API endpoints](#available-api-endpoints).
1. Select **Add**.

GitLab adds the group or project to the job token allowlist with the specified permissions. The group or project can now
access any allowed resources in the current project.

## Available API endpoints

The following endpoints are available for CI/CD job tokens.

`None` means fine-grained permissions cannot control access to this endpoint.

| Permissions | Permission Names | Path | Description |
| ----------- | ---------------- | ---- | ----------- |
| Deployments: Read and write | `ADMIN_DEPLOYMENTS` | `DELETE /projects/:id/deployments/:deployment_id` | Delete a specific deployment |
| Deployments: Read and write | `ADMIN_DEPLOYMENTS` | `POST /projects/:id/deployments/:deployment_id/approval` | Approve or reject a blocked deployment |
| Deployments: Read and write | `ADMIN_DEPLOYMENTS` | `PUT /projects/:id/deployments/:deployment_id` | Update a deployment |
| Deployments: Read and write, Environments: Read and write | `ADMIN_DEPLOYMENTS`, `ADMIN_ENVIRONMENTS` | `POST /projects/:id/deployments` | Create a deployment |
| Deployments: Read | `READ_DEPLOYMENTS` | `GET /projects/:id/deployments/:deployment_id/merge_requests` | List of merge requests associated with a deployment |
| Deployments: Read | `READ_DEPLOYMENTS` | `GET /projects/:id/deployments/:deployment_id` | Get a specific deployment |
| Deployments: Read | `READ_DEPLOYMENTS` | `GET /projects/:id/deployments` | List project deployments |
| Environments: Read and write | `ADMIN_ENVIRONMENTS` | `DELETE /projects/:id/environments/:environment_id` | Delete an environment |
| Environments: Read and write | `ADMIN_ENVIRONMENTS` | `DELETE /projects/:id/environments/review_apps` | Delete multiple stopped review apps |
| Environments: Read and write | `ADMIN_ENVIRONMENTS` | `POST /projects/:id/environments/:environment_id/stop` | Stop an environment |
| Environments: Read and write | `ADMIN_ENVIRONMENTS` | `POST /projects/:id/environments/stop_stale` | Stop stale environments |
| Environments: Read and write | `ADMIN_ENVIRONMENTS` | `POST /projects/:id/environments` | Create a new environment |
| Environments: Read and write | `ADMIN_ENVIRONMENTS` | `PUT /projects/:id/environments/:environment_id` | Update an existing environment |
| Environments: Read | `READ_ENVIRONMENTS` | `GET /projects/:id/environments/:environment_id` | Get a specific environment |
| Environments: Read | `READ_ENVIRONMENTS` | `GET /projects/:id/environments` | List environments |
| Jobs: Read | `READ_JOBS` | `GET /jobs/:id/artifacts` | Download the artifacts file for job |
| Jobs: Read | `READ_JOBS` | `GET /projects/:id/jobs/:job_id/artifacts/*artifact_path` | Download a specific file from artifacts archive |
| Jobs: Read | `READ_JOBS` | `GET /projects/:id/jobs/:job_id/artifacts` | Download the artifacts archive from a job |
| Jobs: Read | `READ_JOBS` | `GET /projects/:id/jobs/artifacts/:ref_name/download` | Download the artifacts archive from a job |
| Jobs: Read | `READ_JOBS` | `GET /projects/:id/jobs/artifacts/:ref_name/raw/*artifact_path` | Download a specific file from artifacts archive from a ref |
| Jobs: Read | `READ_JOBS` | `GET /projects/:id/jobs` | Get a projects jobs |
| Jobs: Read | `READ_JOBS` | `GET /projects/:id/pipelines/:pipeline_id/jobs` | Get pipeline jobs |
| None |  | `DELETE /projects/:id/registry/repositories/:repository_id/tags/:tag_name` | Delete repository tag |
| None |  | `DELETE /projects/:id/registry/repositories/:repository_id/tags` | Delete repository tags (in bulk) |
| None |  | `DELETE /projects/:id/registry/repositories/:repository_id` | Delete repository |
| None |  | `GET /group/:id/-/packages/composer/*package_name` | Composer packages endpoint at group level for package versions metadata |
| None |  | `GET /group/:id/-/packages/composer/p/:sha` | Composer packages endpoint at group level for packages list |
| None |  | `GET /group/:id/-/packages/composer/p2/*package_name` | Composer v2 packages p2 endpoint at group level for package versions metadata |
| None |  | `GET /group/:id/-/packages/composer/packages` | Composer packages endpoint at group level |
| None |  | `GET /groups/:id/-/packages/npm/*package_name` | NPM registry metadata endpoint |
| None |  | `GET /groups/:id/-/packages/pypi/files/:sha256/*file_identifier` | Download a package file from a group |
| None |  | `GET /groups/:id/-/packages/pypi/simple/*package_name` | The PyPi Simple Group Package Endpoint |
| None |  | `GET /groups/:id/-/packages/pypi/simple` | The PyPi Simple Group Index Endpoint |
| None |  | `GET /job/allowed_agents` | Get current agents |
| None |  | `GET /job` | Get current job using job token |
| None |  | `GET /packages/conan/v1/conans/search` | Search for packages |
| None |  | `GET /packages/conan/v1/ping` | Ping the Conan API |
| None |  | `GET /packages/conan/v1/users/authenticate` | Authenticate user against conan CLI |
| None |  | `GET /packages/conan/v1/users/check_credentials` | Check for valid user credentials per conan CLI |
| None |  | `GET /packages/npm/*package_name` | NPM registry metadata endpoint |
| None |  | `GET /projects/:id/packages/conan/v1/conans/search` | Search for packages |
| None |  | `GET /projects/:id/packages/conan/v1/ping` | Ping the Conan API |
| None |  | `GET /projects/:id/packages/conan/v1/users/authenticate` | Authenticate user against conan CLI |
| None |  | `GET /projects/:id/packages/conan/v1/users/check_credentials` | Check for valid user credentials per conan CLI |
| None |  | `GET /projects/:id/packages/conan/v2/conans/search` | Search for packages |
| None |  | `GET /projects/:id/packages/conan/v2/users/authenticate` | Authenticate user against conan CLI |
| None |  | `GET /projects/:id/packages/conan/v2/users/check_credentials` | Check for valid user credentials per conan CLI |
| None |  | `GET /projects/:id/registry/repositories/:repository_id/tags/:tag_name` | Get details about a repository tag |
| None |  | `GET /projects/:id/registry/repositories/:repository_id/tags` | List tags of a repository |
| None |  | `GET /projects/:id/registry/repositories` | List container repositories within a project |
| None |  | `POST /internal/dast/site_validations/:id/transition` | Transitions a DAST site validation to a new state. |
| Packages: Read and write | `ADMIN_PACKAGES` | `DELETE /groups/:id/-/packages/npm/-/package/*package_name/dist-tags/:tag` | Deletes the given tag |
| Packages: Read and write | `ADMIN_PACKAGES` | `DELETE /packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel` | Delete Package |
| Packages: Read and write | `ADMIN_PACKAGES` | `DELETE /packages/npm/-/package/*package_name/dist-tags/:tag` | Deletes the given tag |
| Packages: Read and write | `ADMIN_PACKAGES` | `DELETE /projects/:id/packages/:package_id/package_files/:package_file_id` | Delete a package file |
| Packages: Read and write | `ADMIN_PACKAGES` | `DELETE /projects/:id/packages/:package_id` | Delete a project package |
| Packages: Read and write | `ADMIN_PACKAGES` | `DELETE /projects/:id/packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel` | Delete Package |
| Packages: Read and write | `ADMIN_PACKAGES` | `DELETE /projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/revisions/:recipe_revision/packages/:conan_package_reference/revisions/:package_revision` | Delete package revision |
| Packages: Read and write | `ADMIN_PACKAGES` | `DELETE /projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/revisions/:recipe_revision` | Delete recipe revision |
| Packages: Read and write | `ADMIN_PACKAGES` | `DELETE /projects/:id/packages/npm/-/package/*package_name/dist-tags/:tag` | Deletes the given tag |
| Packages: Read and write | `ADMIN_PACKAGES` | `POST /projects/:id/packages/composer` | Composer packages endpoint for registering packages |
| Packages: Read and write | `ADMIN_PACKAGES` | `POST /projects/:id/packages/pypi/authorize` | Authorize the PyPi package upload from workhorse |
| Packages: Read and write | `ADMIN_PACKAGES` | `POST /projects/:id/packages/pypi` | The PyPi Package upload endpoint |
| Packages: Read and write | `ADMIN_PACKAGES` | `PUT /groups/:id/-/packages/npm/-/package/*package_name/dist-tags/:tag` | Create or Update the given tag for the given NPM package and version |
| Packages: Read and write | `ADMIN_PACKAGES` | `PUT /packages/conan/v1/files/:package_name/:package_version/:package_username/:package_channel/:recipe_revision/export/:file_name/authorize` | Workhorse authorize the conan recipe file |
| Packages: Read and write | `ADMIN_PACKAGES` | `PUT /packages/conan/v1/files/:package_name/:package_version/:package_username/:package_channel/:recipe_revision/export/:file_name` | Upload recipe package files |
| Packages: Read and write | `ADMIN_PACKAGES` | `PUT /packages/conan/v1/files/:package_name/:package_version/:package_username/:package_channel/:recipe_revision/package/:conan_package_reference/:package_revision/:file_name/authorize` | Workhorse authorize the conan package file |
| Packages: Read and write | `ADMIN_PACKAGES` | `PUT /packages/conan/v1/files/:package_name/:package_version/:package_username/:package_channel/:recipe_revision/package/:conan_package_reference/:package_revision/:file_name` | Upload package files |
| Packages: Read and write | `ADMIN_PACKAGES` | `PUT /packages/npm/-/package/*package_name/dist-tags/:tag` | Create or Update the given tag for the given NPM package and version |
| Packages: Read and write | `ADMIN_PACKAGES` | `PUT /projects/:id/packages/conan/v1/files/:package_name/:package_version/:package_username/:package_channel/:recipe_revision/export/:file_name/authorize` | Workhorse authorize the conan recipe file |
| Packages: Read and write | `ADMIN_PACKAGES` | `PUT /projects/:id/packages/conan/v1/files/:package_name/:package_version/:package_username/:package_channel/:recipe_revision/export/:file_name` | Upload recipe package files |
| Packages: Read and write | `ADMIN_PACKAGES` | `PUT /projects/:id/packages/conan/v1/files/:package_name/:package_version/:package_username/:package_channel/:recipe_revision/package/:conan_package_reference/:package_revision/:file_name/authorize` | Workhorse authorize the conan package file |
| Packages: Read and write | `ADMIN_PACKAGES` | `PUT /projects/:id/packages/conan/v1/files/:package_name/:package_version/:package_username/:package_channel/:recipe_revision/package/:conan_package_reference/:package_revision/:file_name` | Upload package files |
| Packages: Read and write | `ADMIN_PACKAGES` | `PUT /projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/revisions/:recipe_revision/files/:file_name/authorize` | Workhorse authorize the conan recipe file |
| Packages: Read and write | `ADMIN_PACKAGES` | `PUT /projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/revisions/:recipe_revision/files/:file_name` | Upload recipe package files |
| Packages: Read and write | `ADMIN_PACKAGES` | `PUT /projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/revisions/:recipe_revision/packages/:conan_package_reference/revisions/:package_revision/files/:file_name/authorize` | Workhorse authorize the conan package file |
| Packages: Read and write | `ADMIN_PACKAGES` | `PUT /projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/revisions/:recipe_revision/packages/:conan_package_reference/revisions/:package_revision/files/:file_name` | Upload package files |
| Packages: Read and write | `ADMIN_PACKAGES` | `PUT /projects/:id/packages/generic/:package_name/*package_version/(*path/):file_name/authorize` | Workhorse authorize generic package file |
| Packages: Read and write | `ADMIN_PACKAGES` | `PUT /projects/:id/packages/generic/:package_name/*package_version/(*path/):file_name` | Upload package file |
| Packages: Read and write | `ADMIN_PACKAGES` | `PUT /projects/:id/packages/maven/*path/:file_name/authorize` | Workhorse authorize the maven package file upload |
| Packages: Read and write | `ADMIN_PACKAGES` | `PUT /projects/:id/packages/maven/*path/:file_name` | Upload the maven package file |
| Packages: Read and write | `ADMIN_PACKAGES` | `PUT /projects/:id/packages/npm/-/package/*package_name/dist-tags/:tag` | Create or Update the given tag for the given NPM package and version |
| Packages: Read and write | `ADMIN_PACKAGES` | `PUT /projects/:id/packages/npm/:package_name` | Create or deprecate NPM package |
| Packages: Read | `READ_PACKAGES` | `GET /groups/:id/-/packages/maven/*path/:file_name` | Download the maven package file at a group level |
| Packages: Read | `READ_PACKAGES` | `GET /groups/:id/-/packages/npm/-/package/*package_name/dist-tags` | Get all tags for a given an NPM package |
| Packages: Read | `READ_PACKAGES` | `GET /packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/digest` | Recipe Digest |
| Packages: Read | `READ_PACKAGES` | `GET /packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/download_urls` | Recipe Download Urls |
| Packages: Read | `READ_PACKAGES` | `GET /packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/packages/:conan_package_reference/digest` | Package Digest |
| Packages: Read | `READ_PACKAGES` | `GET /packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/packages/:conan_package_reference/download_urls` | Package Download Urls |
| Packages: Read | `READ_PACKAGES` | `GET /packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/packages/:conan_package_reference` | Package Snapshot |
| Packages: Read | `READ_PACKAGES` | `GET /packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/search` | Get package references metadata |
| Packages: Read | `READ_PACKAGES` | `GET /packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel` | Recipe Snapshot |
| Packages: Read | `READ_PACKAGES` | `GET /packages/conan/v1/files/:package_name/:package_version/:package_username/:package_channel/:recipe_revision/export/:file_name` | Download recipe files |
| Packages: Read | `READ_PACKAGES` | `GET /packages/conan/v1/files/:package_name/:package_version/:package_username/:package_channel/:recipe_revision/package/:conan_package_reference/:package_revision/:file_name` | Download package files |
| Packages: Read | `READ_PACKAGES` | `GET /packages/maven/*path/:file_name` | Download the maven package file at instance level |
| Packages: Read | `READ_PACKAGES` | `GET /packages/npm/-/package/*package_name/dist-tags` | Get all tags for a given an NPM package |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/:package_id/package_files` | List package files |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/:package_id` | Get a single project package |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/composer/archives/*package_name` | Composer package endpoint to download a package archive |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/digest` | Recipe Digest |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/download_urls` | Recipe Download Urls |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/packages/:conan_package_reference/digest` | Package Digest |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/packages/:conan_package_reference/download_urls` | Package Download Urls |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/packages/:conan_package_reference` | Package Snapshot |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/search` | Get package references metadata |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel` | Recipe Snapshot |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/conan/v1/files/:package_name/:package_version/:package_username/:package_channel/:recipe_revision/export/:file_name` | Download recipe files |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/conan/v1/files/:package_name/:package_version/:package_username/:package_channel/:recipe_revision/package/:conan_package_reference/:package_revision/:file_name` | Download package files |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/latest` | Get the latest recipe revision |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/revisions/:recipe_revision/files/:file_name` | Download recipe files |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/revisions/:recipe_revision/files` | List recipe files |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/revisions/:recipe_revision/packages/:conan_package_reference/latest` | Get the latest package revision |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/revisions/:recipe_revision/packages/:conan_package_reference/revisions/:package_revision/files/:file_name` | Download package files |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/revisions/:recipe_revision/packages/:conan_package_reference/revisions/:package_revision/files` | List package files |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/revisions/:recipe_revision/packages/:conan_package_reference/revisions` | Get the list of package revisions |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/revisions/:recipe_revision/search` | Get package references metadata |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/revisions` | Get the list of revisions |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/conan/v2/conans/:package_name/:package_version/:package_username/:package_channel/search` | Get package references metadata |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/generic/:package_name/*package_version/(*path/):file_name` | Download package file |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/go/*module_name/@v/:module_version.info` | Version metadata |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/go/*module_name/@v/:module_version.mod` | Download module file |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/go/*module_name/@v/:module_version.zip` | Download module source |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/go/*module_name/@v/list` | List |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/maven/*path/:file_name` | Download the maven package file at a project level |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/npm/*package_name/-/*file_name` | Download the NPM tarball |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/npm/*package_name` | NPM registry metadata endpoint |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/npm/-/package/*package_name/dist-tags` | Get all tags for a given an NPM package |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/pypi/files/:sha256/*file_identifier` | The PyPi package download endpoint |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/pypi/simple/*package_name` | The PyPi Simple Project Package Endpoint |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages/pypi/simple` | The PyPi Simple Project Index Endpoint |
| Packages: Read | `READ_PACKAGES` | `GET /projects/:id/packages` | Get a list of project packages |
| Packages: Read | `READ_PACKAGES` | `POST /groups/:id/-/packages/npm/-/npm/v1/security/advisories/bulk` | NPM registry bulk advisory endpoint |
| Packages: Read | `READ_PACKAGES` | `POST /groups/:id/-/packages/npm/-/npm/v1/security/audits/quick` | NPM registry quick audit endpoint |
| Packages: Read | `READ_PACKAGES` | `POST /packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/packages/:conan_package_reference/upload_urls` | Package Upload Urls |
| Packages: Read | `READ_PACKAGES` | `POST /packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/upload_urls` | Recipe Upload Urls |
| Packages: Read | `READ_PACKAGES` | `POST /packages/npm/-/npm/v1/security/advisories/bulk` | NPM registry bulk advisory endpoint |
| Packages: Read | `READ_PACKAGES` | `POST /packages/npm/-/npm/v1/security/audits/quick` | NPM registry quick audit endpoint |
| Packages: Read | `READ_PACKAGES` | `POST /projects/:id/packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/packages/:conan_package_reference/upload_urls` | Package Upload Urls |
| Packages: Read | `READ_PACKAGES` | `POST /projects/:id/packages/conan/v1/conans/:package_name/:package_version/:package_username/:package_channel/upload_urls` | Recipe Upload Urls |
| Packages: Read | `READ_PACKAGES` | `POST /projects/:id/packages/npm/-/npm/v1/security/advisories/bulk` | NPM registry bulk advisory endpoint |
| Packages: Read | `READ_PACKAGES` | `POST /projects/:id/packages/npm/-/npm/v1/security/audits/quick` | NPM registry quick audit endpoint |
| Pipelines: Read and write | `ADMIN_PIPELINES` | `PUT /projects/:id/pipelines/:pipeline_id/metadata` | Updates pipeline metadata |
| Pipelines: Read | `READ_PIPELINES` | `GET /projects/:id/packages/:package_id/pipelines` | Get the pipelines for a single project package |
| Pipelines: Read | `READ_PIPELINES` | `GET /projects/:id/pipelines/:pipeline_id/bridges` | Get pipeline bridge jobs |
| Pipelines: Read | `READ_PIPELINES` | `GET /projects/:id/pipelines/:pipeline_id` | Gets a specific pipeline for the project |
| Pipelines: Read | `READ_PIPELINES` | `GET /projects/:id/pipelines` | Get all Pipelines of the project |
| Releases: Read and write | `ADMIN_RELEASES` | `DELETE /projects/:id/releases/:tag_name/assets/links/:link_id` | Delete a release link |
| Releases: Read and write | `ADMIN_RELEASES` | `DELETE /projects/:id/releases/:tag_name` | Delete a release |
| Releases: Read and write | `ADMIN_RELEASES` | `POST /projects/:id/catalog/publish` | Publish a new component project release as version to the CI/CD catalog |
| Releases: Read and write | `ADMIN_RELEASES` | `POST /projects/:id/releases/:tag_name/assets/links` | Create a release link |
| Releases: Read and write | `ADMIN_RELEASES` | `POST /projects/:id/releases/:tag_name/evidence` | Collect release evidence |
| Releases: Read and write | `ADMIN_RELEASES` | `POST /projects/:id/releases` | Create a release |
| Releases: Read and write | `ADMIN_RELEASES` | `PUT /projects/:id/releases/:tag_name/assets/links/:link_id` | Update a release link |
| Releases: Read and write | `ADMIN_RELEASES` | `PUT /projects/:id/releases/:tag_name` | Update a release |
| Releases: Read | `READ_RELEASES` | `GET /projects/:id/releases/:tag_name/assets/links/:link_id` | Get a release link |
| Releases: Read | `READ_RELEASES` | `GET /projects/:id/releases/:tag_name/assets/links` | List links of a release |
| Releases: Read | `READ_RELEASES` | `GET /projects/:id/releases/:tag_name/downloads/*direct_asset_path` | Download a project release asset file |
| Releases: Read | `READ_RELEASES` | `GET /projects/:id/releases/:tag_name` | Get a release by a tag name |
| Releases: Read | `READ_RELEASES` | `GET /projects/:id/releases/permalink/latest(/)(*suffix_path)` | Get the latest project release |
| Releases: Read | `READ_RELEASES` | `GET /projects/:id/releases` | List Releases |
| Releases: Read | `READ_RELEASES` | `GET /projects/:id/repository/changelog` | Generates a changelog section for a release and returns it |
| Secure files: Read and write | `ADMIN_SECURE_FILES` | `DELETE /projects/:id/secure_files/:secure_file_id` | Remove a secure file |
| Secure files: Read and write | `ADMIN_SECURE_FILES` | `POST /projects/:id/secure_files` | Create a secure file |
| Secure files: Read | `READ_SECURE_FILES` | `GET /projects/:id/secure_files/:secure_file_id/download` | Download secure file |
| Secure files: Read | `READ_SECURE_FILES` | `GET /projects/:id/secure_files/:secure_file_id` | Get the details of a specific secure file in a project |
| Secure files: Read | `READ_SECURE_FILES` | `GET /projects/:id/secure_files` | Get list of secure files in a project |
| Terraform state: Read and write | `ADMIN_TERRAFORM_STATE` | `DELETE /projects/:id/terraform/state/:name/lock` | Unlock a Terraform state of a certain name |
| Terraform state: Read and write | `ADMIN_TERRAFORM_STATE` | `DELETE /projects/:id/terraform/state/:name/versions/:serial` | Delete a Terraform state version |
| Terraform state: Read and write | `ADMIN_TERRAFORM_STATE` | `DELETE /projects/:id/terraform/state/:name` | Delete a Terraform state of a certain name |
| Terraform state: Read and write | `ADMIN_TERRAFORM_STATE` | `POST /projects/:id/terraform/state/:name/lock` | Lock a Terraform state of a certain name |
| Terraform state: Read and write | `ADMIN_TERRAFORM_STATE` | `POST /projects/:id/terraform/state/:name` | Add a new Terraform state or update an existing one |
| Terraform state: Read | `READ_TERRAFORM_STATE` | `GET /projects/:id/terraform/state/:name/versions/:serial` | Get a Terraform state version |
| Terraform state: Read | `READ_TERRAFORM_STATE` | `GET /projects/:id/terraform/state/:name` | Get a Terraform state by its name |
