---
stage: none
group: unassigned
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Administer GitLab users.
title: Administer users
---

{{< details >}}

- Tier: Free, Premium, Ultimate
- Offering: GitLab Self-Managed

{{< /details >}}

Administer and manage users in GitLab Self-Managed.

## User accounts

- [Create users](../user/profile/account/create_accounts.md)
- [Reset user passwords](../security/reset_user_password.md)
- [Locked user accounts](../security/unlock_user.md)
- [User file uploads](../security/user_file_uploads.md)
- [Delete users](../user/profile/account/delete_account.md)
- [Configure the Libravatar service](libravatar.md)

## User types

- [Auditor users](auditor_users.md)
- [External users](external_users.md)
- [Guest users](guest_users.md)
- [Internal users](internal_users.md)

## User management

- [Modify global user settings](user_settings.md)
- [Moderate users](moderate_users.md)
- [Review abuse reports](review_abuse_reports.md)
- [Review spam logs](review_spam_logs.md)
- [User cohorts](user_cohorts.md)
- [Broadcast messages](broadcast_messages.md)
- [Email from GitLab](email_from_gitlab.md)
- [User management Rake tasks](raketasks/user_management.md)

## Security and authentication

- [Password storage](../security/password_storage.md)
- [Credentials inventory](credentials_inventory.md)
- [Custom password length limits](../security/password_length_limits.md)
- [Generated passwords and integrated authentication](../security/passwords_for_integrated_authentication_methods.md)
