# frozen_string_literal: true

require 'spec_helper'

RSpec.describe Gitlab::BackgroundMigration::BackfillVulnerabilityExternalIssueLinksProjectId,
  feature_category: :vulnerability_management,
  schema: 20240624135059 do
  before do
    # This test shares the db connection to establish it's fixtures, resulting in
    # incorrect connection usage, so we're skipping it.
    # Consult https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180764 for more info.
    skip_if_multiple_databases_are_setup(:sec)
  end

  include_examples 'desired sharding key backfill job' do
    let(:batch_table) { :vulnerability_external_issue_links }
    let(:backfill_column) { :project_id }
    let(:backfill_via_table) { :vulnerabilities }
    let(:backfill_via_column) { :project_id }
    let(:backfill_via_foreign_key) { :vulnerability_id }
  end
end
