---
stage: Package
group: Package Registry
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Packages and Registries
---

{{< details >}}

- Tier: Free, Premium, Ultimate
- Offering: GitLab.com, GitLab Self-Managed, GitLab Dedicated

{{< /details >}}

The GitLab [package registry](package_registry/_index.md) acts as a private or public registry
for a variety of common package managers. You can publish and share
packages, which can be easily consumed as a dependency in downstream projects.

## Container registry

The GitLab [Container Registry](container_registry/_index.md) is a secure and private registry for container images. It's built on open source software and completely integrated within GitLab. Use GitLab CI/CD to create and publish images. Use the GitLab [API](../../api/container_registry.md) to manage the registry across groups and projects.

## Terraform Module Registry

The GitLab [Terraform Module Registry](terraform_module_registry/_index.md) is a secure and private registry for Terraform modules. You can use GitLab CI/CD to create and publish modules.

## Dependency Proxy

The [Dependency Proxy](dependency_proxy/_index.md) is a local proxy for frequently-used upstream images and packages.
