---
stage: Application Security Testing
group: Static Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: GitLab Advanced SAST CWE coverage
---

{{< details >}}

- Tier: Ultimate
- Offering: GitLab.com, GitLab Self-Managed, GitLab Dedicated

{{< /details >}}

[GitLab Advanced SAST](gitlab_advanced_sast.md) finds many types of potential security vulnerabilities in code written in [supported languages](gitlab_advanced_sast.md#supported-languages).

GitLab assigns a matching [Common Weakness Enumeration (CWE)](https://cwe.mitre.org) identifier to each potential vulnerability.
CWE identifiers are an industry-standard way to identify security weaknesses, but it's important to know:

- CWEs are arranged in a tree structure.
For example, [CWE-22: Path Traversal](https://cwe.mitre.org/data/definitions/22.html) is a parent of [CWE-23: Relative Path Traversal](https://cwe.mitre.org/data/definitions/23.html).
A scanner that specifically detects _relative_ path traversal weaknesses (CWE-23) by definition also detects a portion of the more general path traversal category (CWE-22).
- For clarity, this table identifies the exact CWE identifiers that are assigned to GitLab Advanced SAST rules.
It doesn't report parent identifiers.

To learn more about the rules used in GitLab Advanced SAST, see [SAST rules](rules.md#gitlab-advanced-sast).

## CWE coverage by language

GitLab Advanced SAST finds the following types of weaknesses in each programming language:

<!-- Table contents are automatically produced by a job in https://gitlab.com/gitlab-org/security-products/oxeye/product/oxeye-rulez. -->

| CWE                                                          | CWE Description                                                                                                        | C#                     | Go                     | Java                   | JavaScript, TypeScript | Python                 | Ruby                   |
|:-------------------------------------------------------------|:-----------------------------------------------------------------------------------------------------------------------|:-----------------------|:-----------------------|:-----------------------|:-----------------------|:-----------------------|:-----------------------|
| [CWE-15](https://cwe.mitre.org/data/definitions/15.html)     | External Control of System or Configuration Setting                                                                    | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-22](https://cwe.mitre.org/data/definitions/22.html)     | Improper Limitation of a Pathname to a Restricted Directory ('Path Traversal')                                         | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes |
| [CWE-23](https://cwe.mitre.org/data/definitions/23.html)     | Relative Path Traversal                                                                                                | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No |
| [CWE-73](https://cwe.mitre.org/data/definitions/73.html)     | External Control of File Name or Path                                                                                  | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes |
| [CWE-76](https://cwe.mitre.org/data/definitions/76.html)     | Improper Neutralization of Equivalent Special Elements                                                                 | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes |
| [CWE-77](https://cwe.mitre.org/data/definitions/77.html)     | Improper Neutralization of Special Elements used in a Command ('Command Injection')                                    | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-78](https://cwe.mitre.org/data/definitions/78.html)     | Improper Neutralization of Special Elements used in an OS Command ('OS Command Injection')                             | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes |
| [CWE-79](https://cwe.mitre.org/data/definitions/79.html)     | Improper Neutralization of Input During Web Page Generation ('Cross-site Scripting')                                   | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes |
| [CWE-80](https://cwe.mitre.org/data/definitions/80.html)     | Improper Neutralization of Script-Related HTML Tags in a Web Page (Basic XSS)                                          | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-88](https://cwe.mitre.org/data/definitions/88.html)     | Improper Neutralization of Argument Delimiters in a Command ('Argument Injection')                                     | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-89](https://cwe.mitre.org/data/definitions/89.html)     | Improper Neutralization of Special Elements used in an SQL Command ('SQL Injection')                                   | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes |
| [CWE-90](https://cwe.mitre.org/data/definitions/90.html)     | Improper Neutralization of Special Elements used in an LDAP Query ('LDAP Injection')                                   | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-91](https://cwe.mitre.org/data/definitions/91.html)     | XML Injection (aka Blind XPath Injection)                                                                              | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-94](https://cwe.mitre.org/data/definitions/94.html)     | Improper Control of Generation of Code ('Code Injection')                                                              | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes |
| [CWE-95](https://cwe.mitre.org/data/definitions/95.html)     | Improper Neutralization of Directives in Dynamically Evaluated Code ('Eval Injection')                                 | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes |
| [CWE-113](https://cwe.mitre.org/data/definitions/113.html)   | Improper Neutralization of CRLF Sequences in HTTP Headers ('HTTP Request/Response Splitting')                          | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-116](https://cwe.mitre.org/data/definitions/116.html)   | Improper Encoding or Escaping of Output                                                                                | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No |
| [CWE-117](https://cwe.mitre.org/data/definitions/117.html)   | Improper Output Neutralization for Logs                                                                                | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-118](https://cwe.mitre.org/data/definitions/118.html)   | Incorrect Access of Indexable Resource ('Range Error')                                                                 | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-125](https://cwe.mitre.org/data/definitions/125.html)   | Out-of-bounds Read                                                                                                     | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-134](https://cwe.mitre.org/data/definitions/134.html)   | Use of Externally-Controlled Format String                                                                             | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-155](https://cwe.mitre.org/data/definitions/155.html)   | Improper Neutralization of Wildcards or Matching Symbols                                                               | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No |
| [CWE-180](https://cwe.mitre.org/data/definitions/180.html)   | Incorrect Behavior Order: Validate Before Canonicalize                                                                 | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-182](https://cwe.mitre.org/data/definitions/182.html)   | Collapse of Data into Unsafe Value                                                                                     | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-185](https://cwe.mitre.org/data/definitions/185.html)   | Incorrect Regular Expression                                                                                           | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes |
| [CWE-190](https://cwe.mitre.org/data/definitions/190.html)   | Integer Overflow or Wraparound                                                                                         | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-208](https://cwe.mitre.org/data/definitions/208.html)   | Observable Timing Discrepancy                                                                                          | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-209](https://cwe.mitre.org/data/definitions/209.html)   | Generation of Error Message Containing Sensitive Information                                                           | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes |
| [CWE-242](https://cwe.mitre.org/data/definitions/242.html)   | Use of Inherently Dangerous Function                                                                                   | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-272](https://cwe.mitre.org/data/definitions/272.html)   | Least Privilege Violation                                                                                              | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-276](https://cwe.mitre.org/data/definitions/276.html)   | Incorrect Default Permissions                                                                                          | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes |
| [CWE-295](https://cwe.mitre.org/data/definitions/295.html)   | Improper Certificate Validation                                                                                        | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes |
| [CWE-297](https://cwe.mitre.org/data/definitions/297.html)   | Improper Validation of Certificate with Host Mismatch                                                                  | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-306](https://cwe.mitre.org/data/definitions/306.html)   | Missing Authentication for Critical Function                                                                           | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-311](https://cwe.mitre.org/data/definitions/311.html)   | Missing Encryption of Sensitive Data                                                                                   | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes |
| [CWE-319](https://cwe.mitre.org/data/definitions/319.html)   | Cleartext Transmission of Sensitive Information                                                                        | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No |
| [CWE-322](https://cwe.mitre.org/data/definitions/322.html)   | Key Exchange without Entity Authentication                                                                             | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No |
| [CWE-323](https://cwe.mitre.org/data/definitions/323.html)   | Reusing a Nonce, Key Pair in Encryption                                                                                | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-326](https://cwe.mitre.org/data/definitions/326.html)   | Inadequate Encryption Strength                                                                                         | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes |
| [CWE-327](https://cwe.mitre.org/data/definitions/327.html)   | Use of a Broken or Risky Cryptographic Algorithm                                                                       | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No |
| [CWE-328](https://cwe.mitre.org/data/definitions/328.html)   | Use of Weak Hash                                                                                                       | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes |
| [CWE-338](https://cwe.mitre.org/data/definitions/338.html)   | Use of Cryptographically Weak Pseudo-Random Number Generator (PRNG)                                                    | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No |
| [CWE-346](https://cwe.mitre.org/data/definitions/346.html)   | Origin Validation Error                                                                                                | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-347](https://cwe.mitre.org/data/definitions/347.html)   | Improper Verification of Cryptographic Signature                                                                       | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-348](https://cwe.mitre.org/data/definitions/348.html)   | Use of Less Trusted Source                                                                                             | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-352](https://cwe.mitre.org/data/definitions/352.html)   | Cross-Site Request Forgery (CSRF)                                                                                      | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes |
| [CWE-358](https://cwe.mitre.org/data/definitions/358.html)   | Improperly Implemented Security Check for Standard                                                                     | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-369](https://cwe.mitre.org/data/definitions/369.html)   | Divide By Zero                                                                                                         | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes |
| [CWE-377](https://cwe.mitre.org/data/definitions/377.html)   | Insecure Temporary File                                                                                                | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No |
| [CWE-409](https://cwe.mitre.org/data/definitions/409.html)   | Improper Handling of Highly Compressed Data (Data Amplification)                                                       | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-470](https://cwe.mitre.org/data/definitions/470.html)   | Use of Externally-Controlled Input to Select Classes or Code ('Unsafe Reflection')                                     | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-489](https://cwe.mitre.org/data/definitions/489.html)   | Active Debug Code                                                                                                      | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No |
| [CWE-502](https://cwe.mitre.org/data/definitions/502.html)   | Deserialization of Untrusted Data                                                                                      | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes |
| [CWE-521](https://cwe.mitre.org/data/definitions/521.html)   | Weak Password Requirements                                                                                             | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-522](https://cwe.mitre.org/data/definitions/522.html)   | Insufficiently Protected Credentials                                                                                   | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-552](https://cwe.mitre.org/data/definitions/552.html)   | Files or Directories Accessible to External Parties                                                                    | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-554](https://cwe.mitre.org/data/definitions/554.html)   | ASP.NET Misconfiguration: Not Using Input Validation Framework                                                         | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-599](https://cwe.mitre.org/data/definitions/599.html)   | Missing Validation of OpenSSL Certificate                                                                              | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-601](https://cwe.mitre.org/data/definitions/601.html)   | URL Redirection to Untrusted Site ('Open Redirect')                                                                    | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes |
| [CWE-606](https://cwe.mitre.org/data/definitions/606.html)   | Unchecked Input for Loop Condition                                                                                     | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-611](https://cwe.mitre.org/data/definitions/611.html)   | Improper Restriction of XML External Entity Reference                                                                  | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No |
| [CWE-613](https://cwe.mitre.org/data/definitions/613.html)   | Insufficient Session Expiration                                                                                        | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-614](https://cwe.mitre.org/data/definitions/614.html)   | Sensitive Cookie in HTTPS Session Without 'Secure' Attribute                                                           | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-639](https://cwe.mitre.org/data/definitions/639.html)   | Authorization Bypass Through User-Controlled Key                                                                       | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes |
| [CWE-643](https://cwe.mitre.org/data/definitions/643.html)   | Improper Neutralization of Data within XPath Expressions ('XPath Injection')                                           | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-704](https://cwe.mitre.org/data/definitions/704.html)   | Incorrect Type Conversion or Cast                                                                                      | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-732](https://cwe.mitre.org/data/definitions/732.html)   | Incorrect Permission Assignment for Critical Resource                                                                  | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No |
| [CWE-749](https://cwe.mitre.org/data/definitions/749.html)   | Exposed Dangerous Method or Function                                                                                   | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes |
| [CWE-754](https://cwe.mitre.org/data/definitions/754.html)   | Improper Check for Unusual or Exceptional Conditions                                                                   | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes |
| [CWE-757](https://cwe.mitre.org/data/definitions/757.html)   | Selection of Less-Secure Algorithm During Negotiation ('Algorithm Downgrade')                                          | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-770](https://cwe.mitre.org/data/definitions/770.html)   | Allocation of Resources Without Limits or Throttling                                                                   | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No |
| [CWE-776](https://cwe.mitre.org/data/definitions/776.html)   | Improper Restriction of Recursive Entity References in DTDs ('XML Entity Expansion')                                   | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-780](https://cwe.mitre.org/data/definitions/780.html)   | Use of RSA Algorithm without OAEP                                                                                      | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-787](https://cwe.mitre.org/data/definitions/787.html)   | Out-of-bounds Write                                                                                                    | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-798](https://cwe.mitre.org/data/definitions/798.html)   | Use of Hard-coded Credentials                                                                                          | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-913](https://cwe.mitre.org/data/definitions/913.html)   | Improper Control of Dynamically-Managed Code Resources                                                                 | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-915](https://cwe.mitre.org/data/definitions/915.html)   | Improperly Controlled Modification of Dynamically-Determined Object Attributes                                         | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes |
| [CWE-917](https://cwe.mitre.org/data/definitions/917.html)   | Improper Neutralization of Special Elements used in an Expression Language Statement ('Expression Language Injection') | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-918](https://cwe.mitre.org/data/definitions/918.html)   | Server-Side Request Forgery (SSRF)                                                                                     | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes |
| [CWE-942](https://cwe.mitre.org/data/definitions/942.html)   | Permissive Cross-domain Policy with Untrusted Domains                                                                  | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-943](https://cwe.mitre.org/data/definitions/943.html)   | Improper Neutralization of Special Elements in Data Query Logic                                                        | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-1004](https://cwe.mitre.org/data/definitions/1004.html) | Sensitive Cookie Without 'HttpOnly' Flag                                                                               | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes |
| [CWE-1104](https://cwe.mitre.org/data/definitions/1104.html) | Use of Unmaintained Third Party Components                                                                             | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No |
| [CWE-1204](https://cwe.mitre.org/data/definitions/1204.html) | Generation of Weak Initialization Vector (IV)                                                                          | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-1275](https://cwe.mitre.org/data/definitions/1275.html) | Sensitive Cookie with Improper SameSite Attribute                                                                      | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-1321](https://cwe.mitre.org/data/definitions/1321.html) | Improperly Controlled Modification of Object Prototype Attributes ('Prototype Pollution')                              | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |
| [CWE-1327](https://cwe.mitre.org/data/definitions/1327.html) | Binding to an Unrestricted IP Address                                                                                  | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No |
| [CWE-1390](https://cwe.mitre.org/data/definitions/1390.html) | Weak Authentication                                                                                                    | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="check-circle" >}} Yes | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No | {{< icon name="dotted-circle" >}} No |

{{< alert type="note" >}}

Did this page answer the question you had? If not, please comment on [epic 15343](https://gitlab.com/groups/gitlab-org/-/epics/15343) to share your use case.

{{< /alert >}}
