---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Exposure of information through directory listing
---

## Description

The target web server is configured to list the contents of directories that do not contain an index file
such as `index.html`. This could lead to accidental exposure of sensitive information, or give an attacker
details on how filenames and directories are structured and stored.

## Remediation

Directory indexing should be disabled.

Apache:
For Apache-based web sites, ensure all `<Directory>` definitions have `Options -Indexes` configured in the
`apache2.conf` or `httpd.conf` configuration file.

NGINX:
For NGINX-based websites, ensure all `location` definitions have the `autoindex off` directive set in the
`nginx.conf` file.

IIS:
For IIS-based websites version 7.0 and later, you can use the `<directoryBrowse enabled="false" />` element
in the `applicationHost.config` or `Web.config` files.

For all other server types, please consult your product's documentation on how to disable directory
indexing.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 548.1 | false | 548 | Passive | Low |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/548.html)
- [Apache Options](https://httpd.apache.org/docs/2.4/mod/core.html#options)
- [NGINX `autoindex`](https://nginx.org/en/docs/http/ngx_http_autoindex_module.html)
- [IIS `directoryBrowse` element](https://learn.microsoft.com/en-us/iis/configuration/system.webserver/directorybrowse)
