---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Server header exposes version information
---

## Description

The target website returns the `Server` header and version information of this website. By
exposing these values, attackers may attempt to identify if the target software is vulnerable to known
vulnerabilities, or catalog known sites running particular versions to exploit in the future when a
vulnerability is identified in the particular version.

## Remediation

We recommend that the version information be removed from the `Server` header.

Apache:
For Apache-based web sites, set the `ServerTokens` to `Prod` in the `httpd.conf` configuration file.

NGINX:
For NGINX-based websites, set the `server_tokens` configuration value to `off` in the `nginx.conf` file.

IIS:
For IIS-based websites version 10 and later, you can use the `removeServerHeader` element to the `requestFiltering`
section of the `Web.config` file.

For all other server types, please consult your product's documentation on how to redact the version information from
the `Server` header.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 16.2 | true | 16 | Passive | Low |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/16.html)
- [Apache ServerTokens](https://blog.mozilla.org/security/2016/08/26/mitigating-mime-confusion-attacks-in-firefox/)
- [NGINX `server_tokens`](https://nginx.org/en/docs/http/ngx_http_core_module.html#server_tokens)
- [IIS 10 Remove Server Header](https://learn.microsoft.com/en-us/iis/configuration/system.webserver/security/requestfiltering/#attributes)
