---
stage: none
group: unassigned
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Use GitLab
---

Get to know the GitLab end-to-end workflow. Configure permissions,
organize your work, create and secure your application, and analyze its performance. Report on team productivity throughout the process.

| | | |
|--|--|--|
| [**Manage your organization**](../topics/set_up_organization.md)<br>Users, groups, namespaces, SSH keys.| [**Organize work with projects**](project/organize_work_with_projects.md)<br>Project visibility, search, badges, layout.| [**Plan and track work**](../topics/plan_and_track.md)<br>Epics, issues, milestones, labels.|
| [**Use Git**](../topics/git/_index.md)<br>Common commands and workflows. | [**Manage your code**](../topics/manage_code.md)<br>Repositories, merge requests, remote development. | [**Use CI/CD to build your application**](../topics/build_your_application.md)<br>Runners, jobs, pipelines, variables. |
| [**Secure your application**](application_security/secure_your_application.md)<br>Container, dependency, and vulnerability scans. | [**Deploy and release your application**](../topics/release_your_application.md)<br>Environments, packages, review apps, GitLab Pages. | [**Manage your infrastructure**](infrastructure/_index.md)<br>Terraform and Kubernetes deployments. |
| [**Monitor your application**](../operations/_index.md)<br>Error tracking, incident management. | [**Analyze GitLab usage**](analytics/_index.md)<br>Instance, group, and project analytics. | |
