---
stage: Plan
group: Project Management
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Epics, issues, milestones, labels.
title: Plan and track work
---

Plan your work by creating requirements, issues, and epics. Schedule work
with milestones and track your team's time. Learn how to save time with
quick actions, see how GitLab renders Markdown text, and learn how to
use Git to interact with GitLab.

<!-- vale gitlab_base.Spelling = NO -->

<i class="fa fa-youtube-play youtube" aria-hidden="true"></i>
For a thorough demo of Plan features, see
[Multi-team planning with GitLab Ultimate](https://www.youtube.com/watch?v=KmASFwSap7c).
In this video, Gabe describes a use case of a multi-team organization that uses GitLab
with [Scaled Agile Framework (SAFe)](https://handbook.gitlab.com/handbook/marketing/brand-and-product-marketing/product-and-solution-marketing/demo/executive-demo/#scaled-agile-framework-safe).

<!-- vale gitlab_base.Spelling = YES -->

| | | |
|--|--|--|
| [**Getting started**](../user/get_started/get_started_planning_work.md)<br>Overview of how features fit together. | [**Tutorial: Use GitLab for scrum**](../tutorials/scrum_events/_index.md)<br>Sprints, backlog, user stories, scrum lifecycle. | [**Tutorial: Use GitLab for Kanban**](../tutorials/kanban/_index.md)<br>Work in progress, flow, distribution. |
| [**Labels**](../user/project/labels.md)<br>Project labels, group labels, nested scopes, filtering. | [**Iterations**](../user/group/iterations/_index.md)<br>Time-boxed workflow, program increments, cadence, sprints. | [**Milestones**](../user/project/milestones/_index.md)<br>Burndown charts, goals, progress tracking, releases. |
| [**Issues**](../user/project/issues/_index.md)<br>Tasks, bug reports, feature requests, tracking. | [**Issue boards**](../user/project/issue_board.md)<br>Visualization, workflow, Kanban, prioritization. | [**Comments and threads**](../user/discussions/_index.md)<br> Mentions, locked discussions, internal notes, thread resolution. |
| [**Tasks**](../user/tasks.md)<br>Task labels, confidential tasks, linked items, task weights. | [**Requirements**](../user/project/requirements/_index.md)<br>Acceptance criteria, requirements test reports, CSV import. | [**Time tracking**](../user/project/time_tracking.md)<br>Estimates, time spent, reporting. |
| [**CRM**](../user/crm/_index.md)<br>Customer management, organizations, contacts, permissions. | [**Wikis**](../user/project/wiki/_index.md)<br>Documentation, external wikis, wiki events, history. | [**Epics**](../user/group/epics/_index.md)<br>Roadmaps, hierarchies, planning, issue progress. |
| [**Roadmaps**](../user/group/roadmap/_index.md)<br>Epic progress, timelines, milestones, goals. | [**Objectives and key results**](../user/okrs.md)<br>Goal setting, performance tracking, child objectives, health status. | [**To-Do List**](../user/todos.md)<br>Task management, actions, access changes. |
| [**Keyboard shortcuts**](../user/shortcuts.md)<br>Global shortcuts, navigation, quick access. | [**Quick actions**](../user/project/quick_actions.md)<br>Commands, shortcuts, inline actions. | [**Markdown**](../user/markdown.md)<br>Formatting, inline HTML, GitLab-specific references, diagrams and flowcharts. |
