---
stage: none
group: unassigned
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Runners, jobs, pipelines, variables.
title: Use CI/CD to build your application
---

Use CI/CD to generate your application.

|                                                                                                                      |                                                                                                                                                    |                                                                                                                           |
|----------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------|
| [**Getting started**](../ci/_index.md)<br>Overview of how CI/CD features fit together.                               | [**CI/CD YAML syntax reference**](../ci/yaml/_index.md)<br>Pipeline configuration keywords, syntax, examples, inputs.                               | [**Runners**](../ci/runners/_index.md)<br>Configuration, job execution.                                                   |
| [**Pipelines**](../ci/pipelines/_index.md)<br>Configuration, automation, stages, schedules, efficiency.              | [**Jobs**](../ci/jobs/_index.md)<br>Configuration, rules, caching, artifacts, logs.                                                                | [**CI/CD components**](../ci/components/_index.md)<br>Reusable, versioned CI/CD components for pipelines.                  |
| [**CI/CD variables**](../ci/variables/_index.md)<br>Configuration, usage, security.                                   | [**Pipeline security**](../ci/pipelines/pipeline_security.md)<br>Secrets management, job tokens, secure files, cloud security.                     | [**Debugging**](../ci/debugging.md)<br>Configuration validation, warnings, errors, troubleshooting.                       |
| [**Auto DevOps**](autodevops/_index.md)<br>Automated DevOps, language detection, deployment, customization.           | [**Testing**](../ci/testing/_index.md)<br>Unit tests, integration tests, test reports, coverage, quality assurance.                                | [**Google cloud integration**](../ci/gitlab_google_cloud_integration/_index.md)<br>Cloud services, Kubernetes deployments. |
| [**Migrate to GitLab CI/CD**](../ci/migration/plan_a_migration.md)<br> Migrate from Jenkins, GitHub Actions, others. | [**External repository integrations**](../ci/ci_cd_for_external_repos/_index.md)<br>GitHub, Bitbucket, external sources, mirroring, cross-platform. |                                                                                                                           |
