---
stage: Software Supply Chain Security
group: Authentication
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: How we manage the TLS protocol CRIME vulnerability
---

{{< details >}}

- Tier: Free, Premium, Ultimate
- Offering: GitLab Self-Managed

{{< /details >}}

[CRIME](https://en.wikipedia.org/w/index.php?title=CRIME&oldid=692423806) is a security exploit against
secret web cookies over connections using the HTTPS and SPDY protocols that also
use data compression. When used to recover the content of secret
authentication cookies, it allows an attacker to perform session hijacking on an
authenticated web session, allowing the launching of further attacks.

## Description

The TLS Protocol CRIME Vulnerability affects systems that use data compression
over HTTPS. Your system might be vulnerable to the CRIME vulnerability if you use
SSL Compression (for example, Gzip) or SPDY (which optionally uses compression).

GitLab supports both Gzip and [SPDY](https://nginx.org/en/docs/http/ngx_http_spdy_module.html) and mitigates the CRIME
vulnerability by deactivating Gzip when HTTPS is enabled. The sources of the
files are here:

- [Self-compiled installation NGINX file](https://gitlab.com/gitlab-org/gitlab/-/blob/master/lib/support/nginx/gitlab-ssl)
- [Linux package installation NGINX file](https://gitlab.com/gitlab-org/omnibus-gitlab/blob/master/files/gitlab-cookbooks/gitlab/templates/default/nginx-gitlab-http.conf.erb)

Although SPDY is enabled in Linux package installations, CRIME relies on compression
(the 'C') and the default compression level in the NGINX SPDY module is 0
(no compression).

## Nessus

The Nessus scanner, [reports a possible CRIME vulnerability](https://www.tenable.com/plugins/nessus/62565) in GitLab
similar to the following format:

```plaintext
Description

This remote service has one of two configurations that are known to be required for the CRIME attack:
SSL/TLS compression is enabled.
TLS advertises the SPDY protocol earlier than version 4.

...

Output

The following configuration indicates that the remote service may be vulnerable to the CRIME attack:
SPDY support earlier than version 4 is advertised.
```

The report above indicates that Nessus is only checking if
TLS advertises the SPDY protocol earlier than version 4. It does not perform an
attack nor does it check if compression is enabled. The Nessus scanner alone
cannot tell that SPDY compression is disabled and not subject to the CRIME
vulnerability.

## References

- NGINX ["Module `ngx_http_spdy_module`"](https://nginx.org/en/docs/http/ngx_http_spdy_module.html)
- Tenable Network Security, Inc. ["Transport Layer Security (TLS) Protocol CRIME Vulnerability"](https://www.tenable.com/plugins/nessus/62565)
- Wikipedia contributors, ["CRIME"](https://en.wikipedia.org/wiki/CRIME) Wikipedia, The Free Encyclopedia

<!-- ## Troubleshooting

Include any troubleshooting steps that you can foresee. If you know beforehand what issues
one might have when setting this up, or when something is changed, or on upgrading, it's
important to describe those, too. Think of things that may go wrong and include them here.
This is important to minimize requests for support, and to avoid doc comments with
questions that you know someone might ask.

Each scenario can be a third-level heading, for example `### Getting error message X`.
If you have none to add when creating a doc, leave this section in place
but commented out to help encourage others to add to it in the future. -->
