---
stage: none
group: Contributor Success
info: Any user with at least the Maintainer role can merge updates to this content. For details, see https://docs.gitlab.com/ee/development/development_processes.html#development-guidelines-review.
title: GitLab Early Access Program
---

{{< alert type="note" >}}

Last status update 2024-10-02.

{{< /alert >}}

These features may not be ready for production use and follow the [Experimental or Beta policy](../development_stages_support.md) of GitLab.

## Features included in the GitLab Early Access Program

| Name                                                                                                                                        | Status                                                    | Included date | Provide feedback |
|---------------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------|---------------|------------------|
| [GitLab Duo Vulnerability Resolution](../../user/application_security/vulnerabilities/_index.md#vulnerability-resolution)                    | [Beta](../development_stages_support.md#beta)             | 2024-10-02    | [feedback issue](https://gitlab.com/gitlab-org/gitlab/-/issues/476553) |
| [GitLab Duo Issue Description Generation](../../user/project/issues/managing_issues.md#populate-an-issue-with-issue-description-generation) | [Experiment](../development_stages_support.md#experiment) | 2024-10-02    | [feedback issue](https://gitlab.com/gitlab-org/gitlab/-/issues/409844) |
| [GitLab Duo Product Analytics](../../user/analytics/analytics_dashboards.md#generate-a-custom-visualization-with-gitlab-duo)                | [Experiment](../development_stages_support.md#experiment) | 2024-10-02    | [feedback issue](https://gitlab.com/gitlab-org/gitlab/-/issues/455363) |
| [Gitaly on K8s](../../administration/gitaly/kubernetes.md)                                                                                  | [Beta](../development_stages_support.md#beta)             | 2025-02-25    | [feedback issue](https://gitlab.com/gitlab-org/gitlab/-/issues/520544) |

Would you like to use a paid feature but don't have a subscription?
You are more than welcome to [request a free trial](https://about.gitlab.com/free-trial/).

## Add a feature to the program

Create a merge request and add your feature to the [table above](#features-included-in-the-gitlab-early-access-program). Assign `@nick_vh` and `@knockfog-ext` as reviewers. In addition, post a message in the `#developer-relations-early-access-program` Slack channel for details.

<!--
## Features previously enrolled

| Name                                                                              | Status     | Enrolled at   | Removed at   |
|-----------------------------------------------------------------------------------|------------|---------------| -------------|
|                                                                                   |            |               |              |
-->
