---
stage: Systems
group: Distribution
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Read through the GitLab installation methods.
title: Install GitLab
---

You can install GitLab on most GNU/Linux distributions, on several
cloud providers, and in Kubernetes clusters.
To get the best experience, you should balance performance, reliability,
ease of administration (backups, upgrades, and troubleshooting) with the cost of hosting.

<!-- markdownlint-disable MD044 -->

| | | |
|--|--|--|
| [**Installation requirements**](requirements.md)<br>Prerequisites for installation. | [**Installation methods**](install_methods.md)<br>Linux, Helm, Docker, Operator, source, or scripts. | [**Install GitLab on a cloud provider**](cloud_providers.md)<br>AWS, Google Cloud Platform, Azure. |
| [**Offline GitLab**](../topics/offline/_index.md)<br>Isolated installation. | [**Reference architectures**](../administration/reference_architectures/_index.md)<br>Recommended deployments at scale. | [**Upgrade GitLab**](../update/_index.md)<br>Latest version instructions. |
| [**Install GitLab Runner**](https://docs.gitlab.com/runner/install/)<br>Software for CI/CD jobs. | [**Configure GitLab Runner**](https://docs.gitlab.com/runner/configuration/)<br>`Config.toml`, certificates, autoscaling, proxy setup. | [**Install GitLab AI gateway**](install_ai_gateway.md)<br>Using Docker image, using Helm chart. |

<!-- markdownlint-enable MD044 -->
