---
stage: Create
group: Editor Extensions
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Connect and use GitLab Duo in Eclipse.
title: GitLab for Eclipse
---

{{< details >}}

- Tier: Free, Premium, Ultimate
- Offering: GitLab.com, GitLab Self-Managed, GitLab Dedicated
- Status: Experiment

{{< /details >}}

{{< alert type="disclaimer" />}}

The GitLab for Eclipse plugin integrates with GitLab Duo.
This feature is an [experiment](../../policy/development_stages_support.md).

[Install and configure the extension](setup.md).

## Report issues with the plugin

You can report any issues, bugs, or feature requests in the
[`gitlab-eclipse-plugin` issue tracker](https://gitlab.com/gitlab-org/editor-extensions/gitlab-eclipse-plugin/-/issues).
Use the `Bug` or `Feature Proposal` template.

## Related topics

- [Code Suggestions](../../user/project/repository/code_suggestions/_index.md)
- [Eclipse troubleshooting](troubleshooting.md)
- [GitLab Language Server documentation](../language_server/_index.md)
- [About the Create:Editor Extensions Group](https://handbook.gitlab.com/handbook/engineering/development/dev/create/editor-extensions/)
- [Open issues for this plugin](https://gitlab.com/gitlab-org/editor-extensions/gitlab-eclipse-plugin/-/issues/)
- [View source code](https://gitlab.com/gitlab-org/editor-extensions/gitlab-eclipse-plugin)
