---
stage: Systems
group: Distribution
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Backup and restore, move repos, maintenance tasks.
title: Maintain GitLab
---

{{< details >}}

- Tier: Free, Premium, Ultimate
- Offering: GitLab Self-Managed

{{< /details >}}

Keep your GitLab instance up and running.

- [Housekeeping](../housekeeping.md)
- [Activate GitLab EE with license](../license_file.md)
- [Fast SSH key lookup](../operations/fast_ssh_key_lookup.md)
- [File system benchmarking](../operations/filesystem_benchmarking.md)
- [`gitlab-sshd`](../operations/gitlab_sshd.md)
- [Rails console](../operations/rails_console.md)
- [Use SSH certificates](../operations/ssh_certificates.md)
- [Enable encrypted configuration](../encrypted_configuration.md)
- [Rake tasks](../../raketasks/_index.md)
- [Backup and restore](../backup_restore/_index.md)
- [Inactive project deletion](../inactive_project_deletion.md)
- [Move repositories](../operations/moving_repositories.md)
- [Read-only state](../read_only_gitlab.md)
- [Restart GitLab](../restart_gitlab.md)
