---
stage: none
group: unassigned
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Learn how to use and administer GitLab, the most scalable Git-based fully integrated platform for software development.
title: GitLab Docs
---

<!-- markdownlint-disable MD041 MD044-->

<div class="d-none">
  <h3>Visit <a href="https://docs.gitlab.com/ee/">docs.gitlab.com</a> for the latest version
  of this help information with enhanced navigation, formatting, and search.</h3>
</div>
<!-- the div above will not display on the docs site but will display on /help -->

<!-- markdownlint-enable MD044 -->

Explore the different areas of the documentation:

|                         |                         |
|:------------------------|:------------------------|
| [**Use GitLab**](user/_index.md)<br>Get started with GitLab features and functionality. | [**Administer GitLab**](administration/_index.md)<br/>Administer GitLab Self-Managed. |
| [**New to Git and GitLab?**](tutorials/_index.md)<br/>Start learning about Git and GitLab. | [**Contribute to GitLab development**](#contribute-to-gitlab)<br/>Create new GitLab functionality and documentation. |
| [**Coming to GitLab from another platform?**](#coming-to-gitlab-from-another-platform)<br/>Learn how to move to GitLab. | [**Build an integration with GitLab**](#build-an-integration-with-gitlab)<br/>Integrate with Jira and other common applications. |
| [**Choose a subscription**](subscriptions/_index.md)<br/>Determine which subscription tier makes sense for you. | [**Install GitLab**](install/_index.md)<br/>Install GitLab on different platforms. |
| [**Reference architectures**](administration/reference_architectures/_index.md)<br/>View recommended deployments at scale. | [**Upgrade GitLab**](update/_index.md)<br/>Upgrade your GitLab Self-Managed instance to the latest version. |

## Popular topics

View some of the most popular topics:

| Popular topic                                                                  | Description |
|:-------------------------------------------------------------------------------|:------------|
| [CI/CD YAML syntax reference](ci/yaml/_index.md)                                | Available configuration options for `.gitlab-ci.yml` files. |
| [REST API](api/rest/_index.md)                                                  | Use the REST API to extend GitLab. |
| [Environments and deployments](ci/environments/_index.md)                       | Deploy your application to different environments. |
| [Configuring runners](ci/runners/configure_runners.md)                         | Get started using runners. |
| [Two-factor authentication](user/profile/account/two_factor_authentication.md) | Improve the security of your GitLab account. |
| [Back up and restore GitLab](administration/backup_restore/_index.md)           | Back up and restore a GitLab Self-Managed instance. |
| [GitLab release and maintenance policy](policy/maintenance.md)                 | Determine how and when to upgrade. |
| [SSH keys](user/ssh.md)                                                        | Use SSH keys to communicate with GitLab. |

## User accounts

Learn about GitLab account management:

| Topic                                                      | Description |
|:-----------------------------------------------------------|:------------|
| [User account](user/profile/_index.md)                      | Manage your account. |
| [Authentication](administration/auth/_index.md)           | Account security with two-factor authentication, set up your SSH keys, and deploy keys for secure access to your projects. |
| [User settings](user/profile/_index.md#access-your-user-settings) | Manage your user settings, two factor authentication, and more. |
| [User permissions](user/permissions.md)                    | Learn what each role in a project can do. |

## Coming to GitLab from another platform

If you are coming to GitLab from another platform:

| Topic                                                                                  | Description |
|:---------------------------------------------------------------------------------------|:------------|
| [Import to GitLab](user/project/import/_index.md)                                       | Import your projects from GitHub, Bitbucket, GitLab.com, FogBugz, and SVN into GitLab. |
| [Migrate from SVN](user/project/import/_index.md#import-repositories-from-subversion)   | Convert a SVN repository to Git and GitLab. |

## Build an integration with GitLab

To build integrations with GitLab:

| Topic                                       | Description |
|:--------------------------------------------|:------------|
| [GitLab REST API](api/rest/_index.md)       | Integrate with GitLab using our REST API. |
| [GitLab GraphQL API](api/graphql/_index.md) | Integrate with GitLab using our GraphQL API. |
| [Integrations](integration/_index.md)       | Integrations with third-party products. |

## Contribute to GitLab

To contribute to GitLab:

| Topic                                                       | Description |
|:------------------------------------------------------------|:------------|
| [Contribute to GitLab development](development/_index.md).  | Contribute to GitLab development. |
| [Contribute to the documentation](development/documentation/_index.md) | Contribute to GitLab documentation. |
