# frozen_string_literal: true

class FinalizeBackfillVulnerabilityMergeRequestLinksProjectId < Gitlab::Database::Migration[2.2]
  milestone '17.8'

  disable_ddl_transaction!

  restrict_gitlab_migration gitlab_schema: :gitlab_main_cell

  def up
    ensure_batched_background_migration_is_finished(
      job_class_name: 'BackfillVulnerabilityMergeRequestLinksProjectId',
      table_name: :vulnerability_merge_request_links,
      column_name: :id,
      job_arguments: [:project_id, :vulnerabilities, :project_id, :vulnerability_id],
      finalize: true
    )
  end

  def down; end
end
