**Note:** This file is automatically generated. Please see the [developer
documentation](doc/development/changelog.md) for instructions on adding your own
entry.

## 17.10.4 (2025-04-09)

### Fixed (2 changes)

- [Fix invalid pipelines for scan execution policies](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b27b9794e62f4e8ba33e2f56c1c7c64872b4e771) **GitLab Enterprise Edition**
- [Move group.cluster_agents field to CE](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d649d85eab978e106135cc03db4baf261d5d8cb3) **GitLab Enterprise Edition**

### Security (7 changes)

- [Bump workhorse golang-jwt/jwt to 5.2.2](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0ccf3be7475234aca2c54bd1b0283cd9efed6d87) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4912))
- [Global search count leak for confidential issues](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2a6b55c797818a232b0b6ca271f42f594f5a2eae) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4907))
- [Set the IP address state for Action Cable requests](https://gitlab.com/gitlab-org/security/gitlab/-/commit/eef77387081aaf590f13dcdbd7faa6cbadd26bb7) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4904))
- [Bump Golang Oauth2 >=0.27.0](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ee730000f88d319bbd70ce828a0b21118e30231b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4893))
- [Adding validation for Ci::Pipeline](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5d8162f4dfd64d817adef4b2bfd6ce174b66fa44) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4884))
- [Add delay to when pointer events are enabled for 0Auth authorize page](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d54f30acea881202ae0b225c20d306633d7708bf) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4888))
- [Do not enable pprof by default in Workhorse](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4e61600d751d0aba541d8019c9c6419762acc1b7) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4891))

## 17.10.3 (2025-04-02)

No changes.

## 17.10.2 (2025-04-02)

### Fixed (2 changes)

- [Fix free push limit on non-saas](https://gitlab.com/gitlab-org/gitlab/-/commit/41d60e463f147b2cc76889e0f97a3192a9654ec9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186166))
- [Ensure runner taggings are copied from taggings](https://gitlab.com/gitlab-org/gitlab/-/commit/225b22847600e53bcf83d26b85e0a5e80b38c470) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186279))

### Other (1 change)

- [No-op ci_runner_machines_687967fa8a table backfill migration](https://gitlab.com/gitlab-org/gitlab/-/commit/5e9c7c787a1fb500707fbbceea2dccd1fd86ab92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185304))

## 17.10.1 (2025-03-26)

### Security (7 changes)

- [Sync organization user access when admin status changes](https://gitlab.com/gitlab-org/security/gitlab/-/commit/49c7f443c828187785f8714509933a1228e00c89) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4882))
- [Prevent XSS via merge error on the merge request page](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8410e21aa289a55ce8e65258af5bcc2c3073e1f1) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4881))
- [Inherit current_user external status while rotating project/group token](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c9a33f8331d54a8925006c5dce8738203328e759) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4865))
- [Add validations for the project_name of Harbor integration](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8fdb151d20d24d9f51dac9efa0aba92d6a31ce97) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4864))
- [Sanitize returned input on asciidoc Timeout](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e32acea8a77d03b3403a097e2284e173885884b0) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4863))
- [Add CI/CD project setting `allow_composite_identities_to_run_pipelines`](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5cfde6ed6799bb16350aab55218b0904ccb7b053) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4876))
- [Add limit to resource counts in tfplan merge request report](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0ec13496f360b7d600cf604995d8f90276bef0c9) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4870))

## 17.10.0 (2025-03-19)

### Added (150 changes)

- [Add CI runner manager custom executor count to service ping](https://gitlab.com/gitlab-org/gitlab/-/commit/0ff760ca3f36016b6558c9d27e3b0cefeb1fe827) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184308))
- [Add compliance control: auth_sso_enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/e386ea2d8ebab9512a2552011da1e10520595ee8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183762)) **GitLab Enterprise Edition**
- [Protected containers: Integrate delete protection in REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/074e863f366b85096f8e59dd93ba046b30692de8) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183729))
- [Destroy compliance statuses when project is deleted](https://gitlab.com/gitlab-org/gitlab/-/commit/48105bbba27648d01879e9c72ab2f0538abec2b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183997)) **GitLab Enterprise Edition**
- [Add GraphQL query for organization cluster agents](https://gitlab.com/gitlab-org/gitlab/-/commit/0a58bad5b22f26825368ffbc1560b74c05637c5f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183728))
- [Export squash options](https://gitlab.com/gitlab-org/gitlab/-/commit/2219cde7bf1098f3f07d51a22d30d3d8c5ccb622) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175472)) **GitLab Enterprise Edition**
- [Add query to pipeline inputs form](https://gitlab.com/gitlab-org/gitlab/-/commit/10237c60e0680d7a219d504320a1b87205f4f7a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183587))
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/f90fc44e30f41f8a33d0ff8b8b79765d94189d76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184718))
- [Added graphql query for listing project compliance statuses](https://gitlab.com/gitlab-org/gitlab/-/commit/c1e2223ba7c2321445d6de70bacdf4df737ad830) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183640)) **GitLab Enterprise Edition**
- [Emit input data to pipeline new form](https://gitlab.com/gitlab-org/gitlab/-/commit/1e8c63a524d7c3a9c9fb1ff92a4bdaa2d11bcbeb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184375))
- [Add missing sorting options to access token APIs](https://gitlab.com/gitlab-org/gitlab/-/commit/fecf59b69b870f037442b5fea70d32b7d0c135a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184298))
- [Add work item view controls](https://gitlab.com/gitlab-org/gitlab/-/commit/663aecae54ae491c642bb5986bdb38983df8a880) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181184))
- [Backfill software_license_policies without spdx and custom_license](https://gitlab.com/gitlab-org/gitlab/-/commit/e8187711095b23e1dbefd31480512859d3daa9e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181736)) **GitLab Enterprise Edition**
- [Updating pipeline inputs form](https://gitlab.com/gitlab-org/gitlab/-/commit/9f133639227253535e7fbb30110d162abffa010b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184112))
- [Track credentials inventory page visits on SAAS, SM & Dedicated](https://gitlab.com/gitlab-org/gitlab/-/commit/c8ce6b9ae02e3f693c8986032b6c3a5cddc18c81) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184346)) **GitLab Enterprise Edition**
- [Add inputs to pipeline schedule endpoints](https://gitlab.com/gitlab-org/gitlab/-/commit/f08790547e5fa28746ae880788d96400fd0374ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184019))
- [Support filtering work items by timeframe](https://gitlab.com/gitlab-org/gitlab/-/commit/65916874d04584fa91188da709910dfd50d8f129) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181904))
- [Release GitLab Query Language (GLQL) Beta](https://gitlab.com/gitlab-org/gitlab/-/commit/bd5d4c6eaa885e0fd514e543d9d5bf1a38e00450) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184168))
- [Add createdAt field to source_user_type](https://gitlab.com/gitlab-org/gitlab/-/commit/b39d88016f4fb445487c2bac5cd944214cb6e50b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182177))
- [Automatically scan pubspec.lock files when new analyzer enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/706c6a20a3221223cb5c4877344914e0d39d23ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184379))
- [Add admin page for targeted messages basic upload](https://gitlab.com/gitlab-org/gitlab/-/commit/f08d3ffa800c991c7b22a8bd118fff0fe003e84b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183052)) **GitLab Enterprise Edition**
- [Implement vulnerability archive export API](https://gitlab.com/gitlab-org/gitlab/-/commit/ff0904799c49d21d5e82cee60ba034fd1f69d487) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183521)) **GitLab Enterprise Edition**
- [Create merge_request_approval_settings table](https://gitlab.com/gitlab-org/gitlab/-/commit/0b44f525835df85f0261eb0bc64daa3b84a26743) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183679)) **GitLab Enterprise Edition**
- [ActiveContext preprocessor for embeddings](https://gitlab.com/gitlab-org/gitlab/-/commit/5017fd3d05b4a2be28d424a2be78561b2a089809) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183693))
- [Respect tag protection rules when deleting tags](https://gitlab.com/gitlab-org/gitlab/-/commit/c99b88552ecf214475b5d6f13adebf710af57ba6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180661))
- [Show subgroup projects in the DORA projects comparison visualization](https://gitlab.com/gitlab-org/gitlab/-/commit/910ecaf74f432346fa7d420ee8a67521ad0d66f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184211)) **GitLab Enterprise Edition**
- [Enable importer_user_mapping_reassignment_csv flag by default](https://gitlab.com/gitlab-org/gitlab/-/commit/278aee25d619a71912eb645cb479020b39df64ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184169))
- [Add count of createdservice_accounts,28d](https://gitlab.com/gitlab-org/gitlab/-/commit/03dcd1495e212b94d580c6bf81bd18fd1f85a053) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183222)) **GitLab Enterprise Edition**
- [Add by_project_id scope to ProjectSettings](https://gitlab.com/gitlab-org/gitlab/-/commit/e5ad00c21571e79f1acd187b4c937588b2498858) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180296)) **GitLab Enterprise Edition**
- [Enable the `todos_bulk_actions` FF by default](https://gitlab.com/gitlab-org/gitlab/-/commit/40563c25b3cd9d3d1baf39fb38a87e1fbedd9497) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184151))
- [Add shortcut tooltips](https://gitlab.com/gitlab-org/gitlab/-/commit/f669b3a6963bbb161d35f36947da7ed698801171) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183757))
- [ActiveContext preprocessors for preload and bulk embeddings](https://gitlab.com/gitlab-org/gitlab/-/commit/dcdec6b4eea2f043aa32481a410ddaf2137d7f10) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183374))
- [Add the ability to search versions](https://gitlab.com/gitlab-org/gitlab/-/commit/c00d278bfa68375ebd0b7dcd287f2f2311e007c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183105)) **GitLab Enterprise Edition**
- [Add service account update endpoint for groups](https://gitlab.com/gitlab-org/gitlab/-/commit/5404b436347d7441bb5b0870ce1d3e3d56cb6113) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182607)) **GitLab Enterprise Edition**
- [Added code to auto approve pending promotions via ldap](https://gitlab.com/gitlab-org/gitlab/-/commit/f7d60b5b3f319ff31e884a7d796c294570ef86d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182423)) **GitLab Enterprise Edition**
- [Admin Token API: Revoke pipeline trigger tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/765c467ac4315c33ecf61e5ba0fe7f82b4572351) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181598))
- [Expose path_lock permissions in graphql endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/894e13e9c6753b396706170fc7ebadbf6b367862) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184242)) **GitLab Enterprise Edition**
- [Protected packages: Add minimum_access_level_for_delete to GRAPHQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/dd2c7c3ab12793bc8023de5bac784fb191fec601) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180260))
- [Add `usage_count` data source and visualizations](https://gitlab.com/gitlab-org/gitlab/-/commit/7b371873cfb3041ab919221d1c12529f36cd90a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183891)) **GitLab Enterprise Edition**
- [Add Duo with Amazon Q to Duo interface](https://gitlab.com/gitlab-org/gitlab/-/commit/11a972aa5d8cf7937e8810f5e2c1c0efc75c3873) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182120)) **GitLab Enterprise Edition**
- [Model experiments: Add artifacts list](https://gitlab.com/gitlab-org/gitlab/-/commit/c7cb2c8c359e8c3fb2c39782ef81c2e59360b479) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183678))
- [Add excluded_merge_requests table](https://gitlab.com/gitlab-org/gitlab/-/commit/09179454c488f3eb5601f5f9b362347fa7da61f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182488))
- [Add vulnerability_severity_overrides table](https://gitlab.com/gitlab-org/gitlab/-/commit/a985600fdcc410d872dea0f9a40bd9e347612a86) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176952)) **GitLab Enterprise Edition**
- [Introduce Ci::ProjectWithPipelineVariable model and migration](https://gitlab.com/gitlab-org/gitlab/-/commit/6197a60603908283344b91e0350fe0ca03e477f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176022))
- [Protected packages: Integrate delete protection](https://gitlab.com/gitlab-org/gitlab/-/commit/98b2aaeabd1eed7a2867f342bd9d2ba63ab595e2) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179931))
- [Add ci_pipeline_schedule_inputs table](https://gitlab.com/gitlab-org/gitlab/-/commit/378b5df8157a955108e45bbc8423b2dd647f5a48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182763))
- [Add duo_chat_troubleshoot_job to FLAGGED_FEATURES](https://gitlab.com/gitlab-org/gitlab/-/commit/317691ac2664f6ceb4a1ef9eec23abc0a530cf64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184134)) **GitLab Enterprise Edition**
- [Remove users_search_scoped_to_authorized_namespaces_advanced_search flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e951adcae07423cd2168fdfc53f5677d63e16fc5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184125)) **GitLab Enterprise Edition**
- [Add Authz::UserGroupMemberRole model](https://gitlab.com/gitlab-org/gitlab/-/commit/7c8eb82dc54b884203206bdffb598b03a9391260) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182980)) **GitLab Enterprise Edition**
- [Add `parent_path` argument to Groups GQL resolver](https://gitlab.com/gitlab-org/gitlab/-/commit/4a8aab2d65bcf3a3d0f9ee846f3bbacc25900d49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183012))
- [Added a new vulnerability_namespace_statistics table](https://gitlab.com/gitlab-org/gitlab/-/commit/6c5539a6df41b93423a715036ec17681821bdaf1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183138))
- [Support admin custom roles on SaaS](https://gitlab.com/gitlab-org/gitlab/-/commit/4117831792cc903acf9a9c62209dcf27fb441d83) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181559)) **GitLab Enterprise Edition**
- [Implement `GET /Groups/:id` SCIM endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/052e8d5b635a77ce8994ff05d395ecbdcd14ef38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181577)) **GitLab Enterprise Edition**
- [Add WorkItemWidgetVulnerabilities with related vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/7c6acbd08fbb273e5250f175ae7f747b6055b072) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183548)) **GitLab Enterprise Edition**
- [Prevent decremeting stars of project with zero star count](https://gitlab.com/gitlab-org/gitlab/-/commit/c9b3c9629ad2b537ae32104af0efc1766d09c0b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183481))
- [Added table and model for project requirement status](https://gitlab.com/gitlab-org/gitlab/-/commit/ae8b8a4fd10691298e4bd7470683bc7860c25f5f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183484)) **GitLab Enterprise Edition**
- [Enable Duo Code Review and change it to beta](https://gitlab.com/gitlab-org/gitlab/-/commit/60dc901bf62c1bce545668d6334d362a865a891d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183478)) **GitLab Enterprise Edition**
- [Add inputs adoption banner](https://gitlab.com/gitlab-org/gitlab/-/commit/e636f6533b62a10abe1729f01e97f3183f35eb0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183407))
- [Add dependency paths data to vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/98401d1dd27cfd7cd4d383448c6fa2ecb5950475) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183487)) **GitLab Enterprise Edition**
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/b2c8391c0fdab273c7a2e1d15a1a2272948f7f37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183856))
- [Show blame preferences when .git-blame-ignore-revs file exists](https://gitlab.com/gitlab-org/gitlab/-/commit/cee1cfacd22437ca8556977c93cd897011541327) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182827))
- [Bulk add controls while requirement creation](https://gitlab.com/gitlab-org/gitlab/-/commit/d883fe61541afa002f63e21202c18b53d66e5597) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181898)) **GitLab Enterprise Edition**
- [Add groups GQL query argument to only return groups with user membership](https://gitlab.com/gitlab-org/gitlab/-/commit/7fffc8b4136d61a113caa2831d697c882ed13408) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183161))
- [Add ability to force cancel jobs stuck in canceling status](https://gitlab.com/gitlab-org/gitlab/-/commit/1a70128e344b4ad63adc84134ba0207b031cba15) by @ajuckel ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179137))
- [Add put API endpoint to support uploading recipe package files](https://gitlab.com/gitlab-org/gitlab/-/commit/6eea3d1010efdcdc023e0f0d0a4c26d8867fd6d2) by @oceane_scania ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181393))
- [Add the `RecentlyViewedMergeRequestsResolver` class](https://gitlab.com/gitlab-org/gitlab/-/commit/8e4c6010d12f75cf730a2658a037b154a0698a2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183706))
- [Introduce GroupDora type with projects](https://gitlab.com/gitlab-org/gitlab/-/commit/d039f1486c4f93cc6d736d2a1e7858446039930d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181975)) **GitLab Enterprise Edition**
- [Introduce separate rate limiter for /autocomplete/users](https://gitlab.com/gitlab-org/gitlab/-/commit/c56892fd850d37dba6aaadd58bcd232d7b0bd1ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183244))
- [Track Cloud Connector token signing metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/91861f52d73a451a5d1d312878c3828aa9202e2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183676)) **GitLab Enterprise Edition**
- [Add vulnerability_severity_overrides table](https://gitlab.com/gitlab-org/gitlab/-/commit/bce60bb6a9bd6a2de27beff230ce3cebef9e420f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176952)) **GitLab Enterprise Edition**
- [Process security report observability events](https://gitlab.com/gitlab-org/gitlab/-/commit/c4be99cf6fd9777f8308aa2f093f3a70e05b229d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175612))
- [Capture job token policies for API endpoints](https://gitlab.com/gitlab-org/gitlab/-/commit/bc7f41bba693e4fb6afcec218ba2e6f7f781f371) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182582))
- [Update vulnerabilities ExternalIssueLink create service](https://gitlab.com/gitlab-org/gitlab/-/commit/a81fd7f5dfa68a8dd2d322952dec905178a5a35e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181950)) **GitLab Enterprise Edition**
- [Migrate table cell dropdown to a bubble menu](https://gitlab.com/gitlab-org/gitlab/-/commit/a3e34dfe4c15c3d865c8685b83190bce4d00b675) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182909))
- [Add Duo with Amazon Q support to SM/Dedicated provisioning](https://gitlab.com/gitlab-org/gitlab/-/commit/445de297eb3a4b2d226f60d6ed3354d8515c3d0c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183529)) **GitLab Enterprise Edition**
- [Add value renderer](https://gitlab.com/gitlab-org/gitlab/-/commit/4c119afc75d69056bab78c2b26e1ead1121fcc17) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182799))
- [Remove block_seat_overages feeature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/42db137830172086da6e0014f9fd30a1af196068) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181653)) **GitLab Enterprise Edition**
- [Add import history table and import source table components](https://gitlab.com/gitlab-org/gitlab/-/commit/d5e4d47d16a22c4034489c7e2f849dbf40d6b78f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180098))
- [Add namespace_metadata visualization and data source](https://gitlab.com/gitlab-org/gitlab/-/commit/1e0753a2b28826057b41e8b9419820df2e76c877) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183096)) **GitLab Enterprise Edition**
- [Add CSV format to group dependency export](https://gitlab.com/gitlab-org/gitlab/-/commit/78781796626b4dedb2597aaa8e4228a3b9015cff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183097)) **GitLab Enterprise Edition**
- [Restrict manual job variables](https://gitlab.com/gitlab-org/gitlab/-/commit/709a35fd11d4becb26763c2575e38d1610b28838) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183068))
- [Cloud Connector: add key rotation rake tasks](https://gitlab.com/gitlab-org/gitlab/-/commit/54a43ecebdea34e1667589302f9074212bace19a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182711)) **GitLab Enterprise Edition**
- [Create GraphQL endpoint to return pipeline inputs](https://gitlab.com/gitlab-org/gitlab/-/commit/be04d0ea0fff216ac93b64b8cddd2579574fc3ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182609))
- [Add Project.forkedFrom to graphql api](https://gitlab.com/gitlab-org/gitlab/-/commit/9ba1c9b57d20d61ff05e23204998c5b86d19aa05) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183115))
- [Add error tracking widget to work items](https://gitlab.com/gitlab-org/gitlab/-/commit/440bb7783d17ddb814e684d9ea04c0b554492817) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181983))
- [Enable cluster agents for groups](https://gitlab.com/gitlab-org/gitlab/-/commit/b8d6ec5cd500c71846ddf5891e725d3d0b470cb6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182628))
- [Apply GitHub markdown reformatting to more objects](https://gitlab.com/gitlab-org/gitlab/-/commit/16570e16526ead2673d16eda5e46dadbe102f92e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181297))
- [Improve pipeline execution policy documentation](https://gitlab.com/gitlab-org/gitlab/-/commit/4e6657b52057a2a53f8c20687e163c165a88e3b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182269))
- [Add GraphQL API for querying dedicated usage filters](https://gitlab.com/gitlab-org/gitlab/-/commit/747d7f9796b33e5af5b364a70ce9f4b7089774f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181383)) **GitLab Enterprise Edition**
- [Add namespace package setting for audit events](https://gitlab.com/gitlab-org/gitlab/-/commit/6e1017c7db9da4e696bb6fbd3203355deed9f1c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182310))
- [Adding the CI_PROJECT_NAMESPACE_SLUG variable](https://gitlab.com/gitlab-org/gitlab/-/commit/481185f5bfcb475d6ad8df8d7b66bd82a5f18168) by @tonton1728 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181988))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/d8222b92a2c63fb1fd44bd3511a01d173a26c1fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183193))
- [ActiveContext OpenSearch processor for queries](https://gitlab.com/gitlab-org/gitlab/-/commit/61448378d87d011d0ee462548111e50ce0cf47a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183192))
- [Add support for /epic on work_items](https://gitlab.com/gitlab-org/gitlab/-/commit/3e19a48db9e3043b8f7aef2a1567d973db1048b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181750)) **GitLab Enterprise Edition**
- [Add `organization_id` field to `fork_networks`](https://gitlab.com/gitlab-org/gitlab/-/commit/34c02117ed94dbb83d583852ec0ec30f67f55f88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182898))
- [Add vulnerability id for create work item](https://gitlab.com/gitlab-org/gitlab/-/commit/80a8757f432c2d2e464c5717d35cd3a49b6b9c3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181895))
- [Pre-select permissions when creating a custom role](https://gitlab.com/gitlab-org/gitlab/-/commit/080b2dac7f9dd28879dfb62d0114a609c9da903c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178060)) **GitLab Enterprise Edition**
- [Append any value defined in pages.publish to artifact paths](https://gitlab.com/gitlab-org/gitlab/-/commit/f4fe9adc6581fbebbdcb7a2b3bc4b405dbe714ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180239))
- [Add a limited count field to registries](https://gitlab.com/gitlab-org/gitlab/-/commit/2da96a9139f78087ec65db80dd997d863028202a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183189)) **GitLab Enterprise Edition**
- [Implement `POST /Groups` SCIM endpoint for self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/bda74db95a055eaa7720b22a00867f1b162235b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180831)) **GitLab Enterprise Edition**
- [GraphQL query for component dependency path](https://gitlab.com/gitlab-org/gitlab/-/commit/01b9e3dbb1e0a59c6f709e2cb79ffe21826cd101) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182289)) **GitLab Enterprise Edition**
- [Add pipeline inputs table](https://gitlab.com/gitlab-org/gitlab/-/commit/39762c32ec5147924304e1e4320686cf16bf36f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182676))
- [Add worker to assign security bot for namespaces](https://gitlab.com/gitlab-org/gitlab/-/commit/97a31e6586895bf2e461f577b15f86c597f8e483) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181182)) **GitLab Enterprise Edition**
- [Remove feature flag change_data_consistency_for_permissions_workers](https://gitlab.com/gitlab-org/gitlab/-/commit/fa64b4ffc6fee61e2591cd334bbe63e2c5952cde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182975))
- [Allow users to /q test in mr note](https://gitlab.com/gitlab-org/gitlab/-/commit/952392123f3c5764ec1b2d00c87e4732c76f3af7) by @jlosito ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182010)) **GitLab Enterprise Edition**
- [Add models for system defined status](https://gitlab.com/gitlab-org/gitlab/-/commit/91e8062dcf2ea2fba8f0e0b1ace91b6582542327) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181962))
- [Add default role to variables settings](https://gitlab.com/gitlab-org/gitlab/-/commit/a240e2b741a3f02975974ac408b4552a9226c8ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181272))
- [Add index on merge_request_diffs for id and project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/2b5e662ed26b2ff40cd6d677ea48371fa084bcd5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173929))
- [Support duo_chat_2 conversation type](https://gitlab.com/gitlab-org/gitlab/-/commit/dbaf33ea2547f3658fdb70bab1422bfa535ffd6f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181771)) **GitLab Enterprise Edition**
- [Expose CI_JOB_GROUP_NAME variable for builds](https://gitlab.com/gitlab-org/gitlab/-/commit/cd0ce46c878ad8c521e02d1d7ab3a56107700544) by @azinke ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179447))
- [Add find_or_initialize_project_control_status](https://gitlab.com/gitlab-org/gitlab/-/commit/6bb465ef64ab325605d62196a866207717ff444e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180107)) **GitLab Enterprise Edition**
- [Expose `blocked_work_items` feature availability in WI permissions](https://gitlab.com/gitlab-org/gitlab/-/commit/ac8edbb59ecc74d007303de508e3f3a72b71e7c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182158)) **GitLab Enterprise Edition**
- [Add GraphQL for WorkItems::UserPreference](https://gitlab.com/gitlab-org/gitlab/-/commit/e2d5263ee9f18ef213f41bd386fe42afb9a389f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176975))
- [Release PAT expiry notifications to inherited group and project members](https://gitlab.com/gitlab-org/gitlab/-/commit/1acddc4e2a70d9b52eeb0d83063b721ffa219377) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182055))
- [Promote model version through api](https://gitlab.com/gitlab-org/gitlab/-/commit/600cfc3169aef35e2ebce46dfe6bff9ead9f916e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182777))
- [Introduce a GraphQL mutation to archive vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/f1872a8335f6b88b1eea2da5fd39d4c6babf2539) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181986)) **GitLab Enterprise Edition**
- [Add user_discussions_count to WorkItem API](https://gitlab.com/gitlab-org/gitlab/-/commit/5d0a04b4dd55874cae26b4b393bd2048e9422446) by @vedant-jain03 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179164))
- [Add migration to create missing nuget symbols](https://gitlab.com/gitlab-org/gitlab/-/commit/2148e0dc8fc667635cbbb5fc8699250121e1fd2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173869))
- [Enable users to fetch all WorkItems they have access through GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/83be9dc0b25f78c83d8af5194ddd99e3ff14bdc2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177484))
- [Preload policies in contributed and starred projects resolvers](https://gitlab.com/gitlab-org/gitlab/-/commit/1bfafed705e6f6366429823d93c81ae9fbb0887e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182494))
- [Markdown: Select text and paste URL to create link](https://gitlab.com/gitlab-org/gitlab/-/commit/bcd2a3bcc3f4b91c4e5afc6828df8e1bbe03d083) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182471))
- [Add export dropdown to dependency list](https://gitlab.com/gitlab-org/gitlab/-/commit/f112339a2cf3853179fc89aeff5383a9b1260a97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180617)) **GitLab Enterprise Edition**
- [GraphQL: search by commit in the repository](https://gitlab.com/gitlab-org/gitlab/-/commit/013cd757b4e6441bf77b0948e22d8e7d7f3c967e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179542))
- [Add external control fields to GraphQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/7017d5d7f382e0f179282e9dfbcb7ee22aebaf31) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181318)) **GitLab Enterprise Edition**
- [Make Ci::Runner#token routable](https://gitlab.com/gitlab-org/gitlab/-/commit/82024706866a6ba3ce64ce25bfc9d22464bec059) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170634))
- [Removes limited_capacity_member_destruction FF](https://gitlab.com/gitlab-org/gitlab/-/commit/f636f1de5af54404ac76c4c6d3ebd7d8892c8198) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180185))
- [Add comment summarization to work items](https://gitlab.com/gitlab-org/gitlab/-/commit/f75414f0787901a7ca9565f8bf36d6ee34c7aaaa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181712)) **GitLab Enterprise Edition**
- [Removes billable_member_async_deletion FF](https://gitlab.com/gitlab-org/gitlab/-/commit/543a9f346f427743a7513e779b28d81f9e7f910a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180184)) **GitLab Enterprise Edition**
- [Show auto-resolve info banner on vulnerability report](https://gitlab.com/gitlab-org/gitlab/-/commit/741da3d24853da9e3084d8d9af116cdeaa9c879f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181967)) **GitLab Enterprise Edition**
- [Make Users API rate limits configurable](https://gitlab.com/gitlab-org/gitlab/-/commit/4ed1d53f75058b391a135323788383d22122feef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181054))
- [Add switch for CI/CD Job Token format](https://gitlab.com/gitlab-org/gitlab/-/commit/953335cecad9625afa08aa0f44a7ee99c119c5d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181293))
- [Show Start/Due date sort options in Work Item list](https://gitlab.com/gitlab-org/gitlab/-/commit/eb0f231b4b440d525960e7924aefc6cfca52ee7b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182173))
- [Remove feature flag pipeline_execution_policy_analyze_configs](https://gitlab.com/gitlab-org/gitlab/-/commit/d834b44e1ddc9133be84e4f4009f18d6b14bc50b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181963)) **GitLab Enterprise Edition**
- [Add import history stats and error components](https://gitlab.com/gitlab-org/gitlab/-/commit/81f0cc980422fdc96084ab00f1aae21f267a8c23) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181146))
- [Add runner ID filter for dedicated usage query](https://gitlab.com/gitlab-org/gitlab/-/commit/4d2b776c4b7d22ee1bc4fa09bf915851067326d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181916)) **GitLab Enterprise Edition**
- [ActiveContext OpenSearch executor for migrations](https://gitlab.com/gitlab-org/gitlab/-/commit/ef037daaf65a75748fba84d529c888f825af81c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181971))
- [ActiveContext Find partition by serializing collection](https://gitlab.com/gitlab-org/gitlab/-/commit/010dc11145cd18c3a4e9dc27503a57cfabefe72a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181525))
- [Mutation for destroying compliance control](https://gitlab.com/gitlab-org/gitlab/-/commit/f2c8c7c90b9b389026fa225f8952cbb64e850040) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177878)) **GitLab Enterprise Edition**
- [Add Support PIN UI functionality](https://gitlab.com/gitlab-org/gitlab/-/commit/3bf456b1fe8e3c31ed8793289fd58df46c81e8cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176922))
- [Add system note when submitted review is "comments only"](https://gitlab.com/gitlab-org/gitlab/-/commit/45c24bde9d692e042b86a9910829dd9e841eb767) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179149))
- [Enable work item description templates](https://gitlab.com/gitlab-org/gitlab/-/commit/a38540c58ed75d15cf8b9215286b6b4eeae41450) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181688))
- [Protected packages: Add basics for package delete protection](https://gitlab.com/gitlab-org/gitlab/-/commit/241a1dc3e3f74996f62aee1208a5db0db34d3046) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179739))
- [Display warning banner when LFS is misconfigured](https://gitlab.com/gitlab-org/gitlab/-/commit/05d5a2034f2b2e4ef97f3641d7d31be1cc30ca51) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181953))
- [Expose error tracking stack trace though GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/5d848cf139d116004f57e599925adcb9f264b46a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181520))
- [Adds project_id and namespace_id to JWT payload](https://gitlab.com/gitlab-org/gitlab/-/commit/df5a3ac35174b81aa16e90cdbe8d6b6879f0d7e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180975))
- [Add peek functionality for ResourceUsageLimiter](https://gitlab.com/gitlab-org/gitlab/-/commit/64a1d528b65f0afec148df972b4a92f935ccb4fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174808))
- [Add move button to work item Issue type actions menu](https://gitlab.com/gitlab-org/gitlab/-/commit/10e007178488cb7473d56da2417ed041c96859b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178799))
- [Add support for api site profiles in DAST Scan Execution Policies](https://gitlab.com/gitlab-org/gitlab/-/commit/5849f39b6cf27cdecaaeae4e45218b0b844e8b50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181411)) **GitLab Enterprise Edition**
- [Clean up display_password_requirements feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/55e94756c3d8337cc38b1a7914820584dfe3d4d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181446)) **GitLab Enterprise Edition**
- [Handle Silent Mode for Audit Events streaming](https://gitlab.com/gitlab-org/gitlab/-/commit/ff7b8d7fde8a37b37503636f65aa5c85d020b5db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181421)) **GitLab Enterprise Edition**

### Fixed (183 changes)

- [Detect JSON tables even with other lang params](https://gitlab.com/gitlab-org/gitlab/-/commit/292c8ffa2f3d7d8d0f47a9198538a2a0a31294c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184635))
- [Make sure a.anchor::after has position absolute all the time](https://gitlab.com/gitlab-org/gitlab/-/commit/c1dcb71b1bbc80e840ebbf08e779683c62998919) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184220))
- [Do not enforce job token permissions for public endpoints](https://gitlab.com/gitlab-org/gitlab/-/commit/e7c4bc1d5bdbd23fbef1a2e50a3fb78f0e4f95f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184087))
- [Fix URL escaping in badges API](https://gitlab.com/gitlab-org/gitlab/-/commit/a7329a7c08b2f1120e59266e7581f682beca441f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183543))
- [Add migration to delete zoekt_replicas with evicted zoekt_indices](https://gitlab.com/gitlab-org/gitlab/-/commit/52c2600fe5210921814c06eb32c884de09f89ff8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183685))
- [Fix group level auth for epics advanced search](https://gitlab.com/gitlab-org/gitlab/-/commit/4970eff19fff21b05b379820e8721044fe4678c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183748)) **GitLab Enterprise Edition**
- [Handle duplication error](https://gitlab.com/gitlab-org/gitlab/-/commit/331dad5654cc4f1a51f225fc05be8c717096a401) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184116))
- [Fix comment templates](https://gitlab.com/gitlab-org/gitlab/-/commit/4f47d3a1b79133d7e34ef10fa60fb7adb83a00ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181913))
- [Add conditional Flux reconciliation update](https://gitlab.com/gitlab-org/gitlab/-/commit/20c4a32f9d0f64f5c856a8be135f66b6aa6fb218) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184505))
- [Fix integrations table alignment](https://gitlab.com/gitlab-org/gitlab/-/commit/162506aa1f6c74ad4b3cbdf9cb1ecc803e524aae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184538))
- [Fix VSA filtered search bar overflow issue when many filters are applied](https://gitlab.com/gitlab-org/gitlab/-/commit/fc3e4fb731dfc097cb590f3902f49bed41887352) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184520))
- [Prevent new user registration when block seat overages is enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/4c35d12bb2ee647da185ba77d599e7a8a72c7f72) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183913)) **GitLab Enterprise Edition**
- [GLQL table: Fix inclusion of table in description field](https://gitlab.com/gitlab-org/gitlab/-/commit/f04c4eadd5785b631e5d8a53db025cd3a6db7b75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184435))
- [Rolled up dates only when rollUp is true](https://gitlab.com/gitlab-org/gitlab/-/commit/f70825f10d5b6f30a5dfd84c18a6173099665729) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183455))
- [Fix: Skip agent authorization check for environment creation in REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/2ea4c98270a76bcee6076e62e34cb848373397c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184403))
- [Stop scroll misbehavior when linking to comments](https://gitlab.com/gitlab-org/gitlab/-/commit/ee0d8c9c7bc426f9a0f3c8e5168e4e063440c32e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184009))
- [Prevent WI sticky header edit button from shrinking when title is long](https://gitlab.com/gitlab-org/gitlab/-/commit/4dc4486acc993895573c8f680b7795a3ae3a5aaf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184370))
- [Add additional checks for group projects](https://gitlab.com/gitlab-org/gitlab/-/commit/5ddc49644b4a823ee21c5beb75eda09f24d1ff4e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184350)) **GitLab Enterprise Edition**
- [Only load vulnerability related records when actually exporting](https://gitlab.com/gitlab-org/gitlab/-/commit/8129bf948471ba32e66c439c73311a77217b8f38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184195)) **GitLab Enterprise Edition**
- [Reorder runners backfill migrations](https://gitlab.com/gitlab-org/gitlab/-/commit/73f53b6c5b762686a30c74a95b9d70ebbb033cb1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184341))
- [Ignore math on spaced_link_filter](https://gitlab.com/gitlab-org/gitlab/-/commit/cd90ac39b4eda4d2c7407135923ce81370a850ab) by @Bubbis ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182626))
- [Fix read more button styling](https://gitlab.com/gitlab-org/gitlab/-/commit/d73c72a76e02169002b34ac4e230f76199513556) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184262))
- [Zoekt: Fix undefined feature flag handling in gitlab:zoekt:info](https://gitlab.com/gitlab-org/gitlab/-/commit/e256adfb3719ced95f2d3d65ecca40f2eafca1a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184315)) **GitLab Enterprise Edition**
- [Refactor rule_index while updating security policy](https://gitlab.com/gitlab-org/gitlab/-/commit/ab2cdaddfdc50e2c768223b26e374260f08d5567) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183117)) **GitLab Enterprise Edition**
- [Return an error if the parent DNE / Lacks permissions](https://gitlab.com/gitlab-org/gitlab/-/commit/c02e35aba467208a49f8a410ce7e30c0df87021c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183938))
- [Removes ordering requirement for funnel sync test](https://gitlab.com/gitlab-org/gitlab/-/commit/8c7211bcf6c6a626c70ef95c6221f528896ba204) by @max.woolf ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184167))
- [Add check for nullability for compliance framework](https://gitlab.com/gitlab-org/gitlab/-/commit/80dacf519c6c6cb8c7c2f9798104f9e83514a10f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183665)) **GitLab Enterprise Edition**
- [Fix sorting issue credential inventory](https://gitlab.com/gitlab-org/gitlab/-/commit/836b8d90e45b9e42deaf227336abd6e2271e93a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183076))
- [Add `description` param to the service access tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/5bda9dffa3bc75f3e365fbc27dcd2e1e00dd70f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184099))
- [Reduce redundant Redis parameter initialization](https://gitlab.com/gitlab-org/gitlab/-/commit/ba04c2c1baf5e337c26944628d5d685d1adc8be3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184218))
- [Fix gitlab:elastic:info rake task](https://gitlab.com/gitlab-org/gitlab/-/commit/4c602bd80431c20b978061327f516f55bdcd87b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184278)) **GitLab Enterprise Edition**
- [Fix work item draft and description with "\n\n"](https://gitlab.com/gitlab-org/gitlab/-/commit/87c3e20492c3bff884fb43115db95cf921052f8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184273))
- [Add fallback for yaml editor](https://gitlab.com/gitlab-org/gitlab/-/commit/12d75bbde14dfba0a7888d6b7c0837e49c42ba39) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183917))
- [Improve a11y of Integrations table](https://gitlab.com/gitlab-org/gitlab/-/commit/19760748a3040424f67095ca78c5584dcd001b06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183756))
- [Fix inconsistent state for project-level approval settings](https://gitlab.com/gitlab-org/gitlab/-/commit/14e9785890325f4793b24f5a387d3a49d0382210) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183677)) **GitLab Enterprise Edition**
- [Ensure "Edit release" links have accessible labels](https://gitlab.com/gitlab-org/gitlab/-/commit/8dc2fef337a0247cec4a2a361931901e11183ba5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183749))
- [Fix error when fetching custom roles when used in policies](https://gitlab.com/gitlab-org/gitlab/-/commit/e4c5855c011b493275b6d45b333436d18cde76c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183506)) **GitLab Enterprise Edition**
- [Add 99 to valid onboarding_status_role value](https://gitlab.com/gitlab-org/gitlab/-/commit/98e2a7d659dd64d0374990d0ad9412fa561bdee8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184159)) **GitLab Enterprise Edition**
- [Don't use DestroyExportWorker on successful export](https://gitlab.com/gitlab-org/gitlab/-/commit/4c895fd1c74ff725cc9efe68bad87f1f1d0635ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184175)) **GitLab Enterprise Edition**
- [Fix CI/CD variable settings with custom role](https://gitlab.com/gitlab-org/gitlab/-/commit/63e034a43296ac1fbd632ebd458e9167da693a41) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183448))
- [Fix merge request pipelines on ambiguous refs](https://gitlab.com/gitlab-org/gitlab/-/commit/9e126a06392558f8f4787cfd55c1bc0f34992c62) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158976))
- [Remove tsquery_deduplicate_search_terms feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/076fd9d3aa223ded31fb11a6c66c92950f01c9fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183538))
- [Handle undefined body and html for rte](https://gitlab.com/gitlab-org/gitlab/-/commit/0792e0e9f73c4e20c941543b707bc8eaae4195cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184140))
- [Use normalized package_name during](https://gitlab.com/gitlab-org/gitlab/-/commit/47a734bb9cfdbeb1728dddfe34e7d88fe5772f29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183995)) **GitLab Enterprise Edition**
- [Update pipeline variables polling](https://gitlab.com/gitlab-org/gitlab/-/commit/2ea276fb72ed30bb2ff890ab82d1fcd0c80eefcf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183881))
- [Fix rebase failure alert variant](https://gitlab.com/gitlab-org/gitlab/-/commit/d6a647ce6583c6e35b3b2f47f8d8c796c36c56c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184085))
- [Ensure "Edit release" links have accessible labels](https://gitlab.com/gitlab-org/gitlab/-/commit/58234022a177f8bba09ce7e7b459f3fb5d029f1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183747))
- [Adapt Duo Chat Slash commands for multi-threaded](https://gitlab.com/gitlab-org/gitlab/-/commit/435a8408c1dc0b4f0ec9be6d0222596f3ede3292) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183822)) **GitLab Enterprise Edition**
- [Passing color contrast for job log line numbers](https://gitlab.com/gitlab-org/gitlab/-/commit/f42daf67b72a3d3af7fc3db27fb7d1c3190e5f14) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179551))
- [Show full job sidebar when troubleshoot bar exists](https://gitlab.com/gitlab-org/gitlab/-/commit/c64143a64c44f534ddb72bb6aaf0e0c926c212e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184053))
- [fix: Use short ref name as fallback in pipeline UI](https://gitlab.com/gitlab-org/gitlab/-/commit/5ac5fc25933c71fda32a3e8ecc760b44e19210be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184052))
- [Add unverified_author_email to grahql endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/763dae9e6b0848fb2066f458c64905c6e374dfe7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181805))
- [Allow anonymous users to load pipeline analytics](https://gitlab.com/gitlab-org/gitlab/-/commit/60839c49f24800433380a6cf1724b3801a441e8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184032))
- [Fix WorkItemType for reference work items](https://gitlab.com/gitlab-org/gitlab/-/commit/8cf4e1496ac11e4df12491dbd75e0bfaaee5f7e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183647))
- [Stop redirection loop with welcome during onboarding](https://gitlab.com/gitlab-org/gitlab/-/commit/4cfcc6d997a75c36ffb1407ac7c057081c6f64d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183899)) **GitLab Enterprise Edition**
- [Capture model experiment creation RecordNotUnique error](https://gitlab.com/gitlab-org/gitlab/-/commit/8262f11a4e82b11183453beadc5fd33720845fdc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183515))
- [Fix frozen array error with custom analyzers](https://gitlab.com/gitlab-org/gitlab/-/commit/0337089fedacf862073554e7efb6002a222a36fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183879)) **GitLab Enterprise Edition**
- [Fix Rack Attack incorrectly rate limiting runner API](https://gitlab.com/gitlab-org/gitlab/-/commit/f3547556874377474cfe1f64ccbb22f83088a8e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183764))
- [Fix SHM health check not enabling properly](https://gitlab.com/gitlab-org/gitlab/-/commit/f15f2bb428b3b968f4e6f4c1bc8138bb5e2e0123) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183692)) **GitLab Enterprise Edition**
- [Use Redis pipeline creation for MR commit pushes](https://gitlab.com/gitlab-org/gitlab/-/commit/cd290ed3a3a5a6d95eb7682f819033d51a9fb5c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182449))
- [Use design tokens for diff file row and linked diff file](https://gitlab.com/gitlab-org/gitlab/-/commit/31c22efb66f6aa22e5873aa5e41da7e3abf2efdc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183456))
- [Convert DuoEnterprise trials lead form to view component](https://gitlab.com/gitlab-org/gitlab/-/commit/b798acf110292b70f58bfe4e7e74659db0e07716) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181874)) **GitLab Enterprise Edition**
- [Fix confidential filters for epics advanced search](https://gitlab.com/gitlab-org/gitlab/-/commit/f877c05292ba8dce79a21dca6c4b035b133218f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183437)) **GitLab Enterprise Edition**
- [Add all actions to sticky header](https://gitlab.com/gitlab-org/gitlab/-/commit/c0bcc11ee7c87b0929de3a4360543ba12a20228f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183547))
- [A11y improvements for user profile and admin user groups/projects page](https://gitlab.com/gitlab-org/gitlab/-/commit/d3c36d30eaabbcbb2269737dd784fefe8771d656) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183438))
- [Ensure revoke token buttons have unique link text](https://gitlab.com/gitlab-org/gitlab/-/commit/17eba2966bce266c1c53ee148a25ef2c48237876) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183265))
- [Fix path rejection for Dependency path](https://gitlab.com/gitlab-org/gitlab/-/commit/c619aed99d762435b976d2b952cb1bf5ed2260ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183682)) **GitLab Enterprise Edition**
- [Make sure aside has its implicit complementary role](https://gitlab.com/gitlab-org/gitlab/-/commit/8d26b5a8977a99875ad57990439c71ef8deb219c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163483))
- [Fix admin_display_duo_addon_settings? check](https://gitlab.com/gitlab-org/gitlab/-/commit/e430aa150ff69f89553f28d4c0eae7be55fd9266) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183507)) **GitLab Enterprise Edition**
- [Prevent invalidating remember tokens on logout](https://gitlab.com/gitlab-org/gitlab/-/commit/ce87820a7879854e1b4d891ec5e6cecdcdedad57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183471))
- [Fix checkbox toggling in work item notes](https://gitlab.com/gitlab-org/gitlab/-/commit/59fb1b71fde5b2baf98da1f049ee78d4dfe6fb36) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182771))
- [Fixes CE profile Usage Quotas rendering](https://gitlab.com/gitlab-org/gitlab/-/commit/26dda60685d6d6e6bc856e8e499337175f58f60f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183577))
- [Don't auto-resolve dismissed vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/0c393436c2bdca79b59eb9bed59204b0efadd139) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183430)) **GitLab Enterprise Edition**
- [Include before_sha in PEP pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/7ab7e8b5779495b84e9736a41cd56932e533af09) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182876)) **GitLab Enterprise Edition**
- [Added long line truncation for frontend highlighting](https://gitlab.com/gitlab-org/gitlab/-/commit/5331b6595deda1f9335dc159da3295a8b98782a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180761))
- [Requeue migration to resync policy project links](https://gitlab.com/gitlab-org/gitlab/-/commit/16e6f0d7d385b9a592954b5295fd9986f9d5c497) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183065)) **GitLab Enterprise Edition**
- [Capture model registry version creation PG errors](https://gitlab.com/gitlab-org/gitlab/-/commit/4983076ce1b477e1917477127dc664ce9bdef9a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183475))
- [Do not disable OAuth by "Disable personal access tokens" group setting](https://gitlab.com/gitlab-org/gitlab/-/commit/cc8aa847dc94ac1137e44b9756dbeede53b4e4aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183488)) **GitLab Enterprise Edition**
- [Stop user onboarding for group saml](https://gitlab.com/gitlab-org/gitlab/-/commit/7ac701f3ebf87cec739b6c73bbb1f60e2b68da52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183252)) **GitLab Enterprise Edition**
- [Update PruneProjectExportJobsWorker cronjob schedule](https://gitlab.com/gitlab-org/gitlab/-/commit/6c12d7f4e62e3e3cd022149a1fd8b352e6ccbf85) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182971))
- [Add optional chaining to ref response](https://gitlab.com/gitlab-org/gitlab/-/commit/6be2fb04c6d44f908c6bb353d9f73134bab43631) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183463))
- [Improve a11y of Help menu](https://gitlab.com/gitlab-org/gitlab/-/commit/9ee75f409cd732fac04028728e4f9adf6c4e66ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183443))
- [Ensure feature flag edit buttons have unique link text](https://gitlab.com/gitlab-org/gitlab/-/commit/ff5b26da8223f551d23727614b7f17548156acde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183262))
- [Remove filter_saml_enforced_resources_from_graphql feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3dfd246265acffb47d687e6ff570c7cd61effa88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183417))
- [Improve a11y of links in Whats New drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/6c972a1025f12977e675b8ab27effd38db834c7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183411))
- [Show copy to clipboard button on mermaid code block](https://gitlab.com/gitlab-org/gitlab/-/commit/51c99b275e8f029d45fc821544d3170c14681739) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183247))
- [Fix RTE loading indicator position](https://gitlab.com/gitlab-org/gitlab/-/commit/4ab6ae83369e6dc425b32069fe4feb841c5e03ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183358))
- [Ensure user edit links in admin have unique text](https://gitlab.com/gitlab-org/gitlab/-/commit/d3776f58bfee2dbd6317f0eacec18194a4d203f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183268))
- [Ensure docs and config links on admin dashboard are accessible](https://gitlab.com/gitlab-org/gitlab/-/commit/92bbbbe6d7716fb430a0b5613089348600818502) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183379))
- [Fix source and target branch in dev widget](https://gitlab.com/gitlab-org/gitlab/-/commit/f869a5f30ad71946f26f2fd38a4b044aa4cbc522) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182504))
- [Fix group filter on work items list](https://gitlab.com/gitlab-org/gitlab/-/commit/71ea84e06fa0f37ab7caa2ff259f87b81cb6934c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182163))
- [Fix custom_ability_ feature flag usage](https://gitlab.com/gitlab-org/gitlab/-/commit/e2a0044a21eb2f34421407c6330ddf7326eccca3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181738)) **GitLab Enterprise Edition**
- [Fix pipeline marked invalid when var is empty string](https://gitlab.com/gitlab-org/gitlab/-/commit/6f7428aa9d35043e547d8cd49af29f22a7e22441) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182993))
- [Add aria-desrcribedby for status links in admin jobs table](https://gitlab.com/gitlab-org/gitlab/-/commit/7f428f94f13e0d9bffb626206a17aacc457adcde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183271))
- [Fix open vsx resource url template](https://gitlab.com/gitlab-org/gitlab/-/commit/934cd0b99786c79f88cd85aee3eb0713c26f23d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183071))
- [Stream audit events only once using feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d25fe8a7bab78fe6a08add1d404c6ecc314ed9ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182587)) **GitLab Enterprise Edition**
- [Fix missing graphql field](https://gitlab.com/gitlab-org/gitlab/-/commit/04d9869db9c7a8ab420824a9097ca17c1b4fd279) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182755))
- [Skip entry owners check for exclusion pattern](https://gitlab.com/gitlab-org/gitlab/-/commit/d372d595a373019a8911fc4ebfc342dc5a305aa7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182403))
- [Fix invalid sort in placeholder users app](https://gitlab.com/gitlab-org/gitlab/-/commit/3e701946fbd9edf1701cd1af653cafab4aa8f8ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183210))
- [Fix emoji key in suggestions dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/e3c0846074f55ff1b8663a21e2e0a77ef7192a37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183206))
- [Abuse report: Fix a11y issues](https://gitlab.com/gitlab-org/gitlab/-/commit/8c0885c040e944e05f922d9c7a8170d86d09da59) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182237))
- [Process auto megre on page load if required](https://gitlab.com/gitlab-org/gitlab/-/commit/b4afe537d2771232a0925f1ea4fdf19d69d1aafb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182992))
- [Fix downloads failing due to duplicate SSRF filters](https://gitlab.com/gitlab-org/gitlab/-/commit/b42c01c7b2ae04d03f6404bba02c102d1a3621e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182493))
- [Implement repository archive cache cleaning inside Workhorse](https://gitlab.com/gitlab-org/gitlab/-/commit/6ba452632a17b32d4b33dab2bac117d0bf4388ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182796))
- [Split cyclonedx artifact into multiple reports](https://gitlab.com/gitlab-org/gitlab/-/commit/fca94833bb4694bc11989cf4694d7ce3184f950e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182324)) **GitLab Enterprise Edition**
- [Fix the pipe search for zoekt exact search mode](https://gitlab.com/gitlab-org/gitlab/-/commit/2efdc94d5f275b73561f5bc995ecbac8f227b48a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181424))
- [Fix workItem parent dropdown item click](https://gitlab.com/gitlab-org/gitlab/-/commit/55d5bbf5098b0addbe4d314b2029f47f59f27360) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183030))
- [Preserve selected items in dropdown text](https://gitlab.com/gitlab-org/gitlab/-/commit/f8380923b9cfa09edbbd71e966bcc8a3b2d9d7c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182644)) **GitLab Enterprise Edition**
- [Model runs: Handle not destroyed error](https://gitlab.com/gitlab-org/gitlab/-/commit/d6f6576effe05e5674fa201d9383520ba50fc4fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183004))
- [Return a bad request status if an environment fails to stop via API](https://gitlab.com/gitlab-org/gitlab/-/commit/c56d035749724865d7af64522cb9da6ca64e12b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181339))
- [Update typo](https://gitlab.com/gitlab-org/gitlab/-/commit/7150c42a347e74248764f5740c226ecb1ba26714) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182964))
- [Reset selected exceptions projects](https://gitlab.com/gitlab-org/gitlab/-/commit/90e389ee13fe424ac6ce75b9be5f6b54998c6693) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182951)) **GitLab Enterprise Edition**
- [Adjust help text for instance wide restricted access setting](https://gitlab.com/gitlab-org/gitlab/-/commit/35a26ea5a74820766963e95b25ece5faf19a160c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182942)) **GitLab Enterprise Edition**
- [Fixed missing regex and syntax options buttons in topbar](https://gitlab.com/gitlab-org/gitlab/-/commit/56e67fb1140ef5e8187a3c23be5459f56ec556c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182879))
- [Delete security_policies when policy.yml becomes invalid](https://gitlab.com/gitlab-org/gitlab/-/commit/97faf8265c2515d8be730d59347036c074d512d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181837)) **GitLab Enterprise Edition**
- [Show rebase button if user can push to source branch](https://gitlab.com/gitlab-org/gitlab/-/commit/b1ee4cb4ec7f2c3004fec739dc41b9a19779d055) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182793))
- [Fix emoji award button styling for selected state](https://gitlab.com/gitlab-org/gitlab/-/commit/55b0ea60941defa2f88173aef312090303122df4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182787))
- [Prevent CiIcon text color from being overridden](https://gitlab.com/gitlab-org/gitlab/-/commit/5b56510e4ed97325f49eb9446c1ac57de973061f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182780))
- [Ensure badge popover opens on click](https://gitlab.com/gitlab-org/gitlab/-/commit/564879f68bd353271e1f5127ff7f2623a0aa0a5d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182399))
- [Zoekt: Fix missing repo logic](https://gitlab.com/gitlab-org/gitlab/-/commit/4d58b55f51fd4bc248d4e107286654d0170815af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182585)) **GitLab Enterprise Edition**
- [Fix issuable filter focus shortcut](https://gitlab.com/gitlab-org/gitlab/-/commit/27ae7b1fefbe1f9d50f19d46cdcfb4300ef66af8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/152427))
- [Release status badge: Fix border not appearing render issue](https://gitlab.com/gitlab-org/gitlab/-/commit/f43308b6ee0cb1d6094231b475c25d13523f6d68) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182743))
- [Catch Key errors in Google Cloud audit event steaming](https://gitlab.com/gitlab-org/gitlab/-/commit/8e8deebfec32552d114fefabf6f4f8a805471ebb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182712))
- [Add background migration to resync policy project links](https://gitlab.com/gitlab-org/gitlab/-/commit/c95a6596ba20a6c3c93199c9aca0737443ed611a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181164)) **GitLab Enterprise Edition**
- [Use semantic H2 for "Related jobs" header](https://gitlab.com/gitlab-org/gitlab/-/commit/bcdd2db8fbfd8e52f17989c38ad1a9c4d0c5cbf9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182320))
- [Set default for pipeline dependency export](https://gitlab.com/gitlab-org/gitlab/-/commit/ad56573215a5f6efb5a71eeb025a9b1a548eace8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182634)) **GitLab Enterprise Edition**
- [Prevent deletion of project_bot users with non-expiring access tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/6937915aed1d3d2a8eb215b39d3f335cf41f9257) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182621))
- [Fix accessibility of Whats New drawer headers](https://gitlab.com/gitlab-org/gitlab/-/commit/07ab934351c9bc663873da6da25eda1a3e4cc6f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182625))
- [Fix skip to main content button UI](https://gitlab.com/gitlab-org/gitlab/-/commit/18ada5a052e02bd2286e21accd94b05203a4a36d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182614))
- [Fix indentation for default yaml file](https://gitlab.com/gitlab-org/gitlab/-/commit/31b54f898cff97841117b07a80d352766c47e881) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182572)) **GitLab Enterprise Edition**
- [Add validation styling for approver widget](https://gitlab.com/gitlab-org/gitlab/-/commit/1fafa422669bf6c9fe31a575047110c16d59ecc5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182482)) **GitLab Enterprise Edition**
- [Prevent double escaping forward slashes](https://gitlab.com/gitlab-org/gitlab/-/commit/ed79877215e03aac58ca4e741c2cf0f2c46940df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182548))
- [Fix badly formatted help link on some integrations](https://gitlab.com/gitlab-org/gitlab/-/commit/c6e860551a4f0d88169c4ec7d60af3235b681426) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181348))
- [Update truncato](https://gitlab.com/gitlab-org/gitlab/-/commit/8fa7d5929775e178722695e7a7f4809949219d7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182200))
- [Load missing from dropdown groups](https://gitlab.com/gitlab-org/gitlab/-/commit/18070d862a34930548be629b2fad9a4353b17a53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182333)) **GitLab Enterprise Edition**
- [Fix "code_owner_approval_required" override when the param is not set](https://gitlab.com/gitlab-org/gitlab/-/commit/a575c3c0fe86d5d5a5b91de4567d789f0e285f26) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181419)) **GitLab Enterprise Edition**
- [Fix pagination issue on empty To-Do dashboard pages](https://gitlab.com/gitlab-org/gitlab/-/commit/fe80749758601efb8e719213877b7d0ebba92396) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182434))
- [Fix policies for GitLab Duo code suggestions and glab ask](https://gitlab.com/gitlab-org/gitlab/-/commit/d088304f4783cb875f87b8e8112a73afd4dd302c) by @stepech ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182315)) **GitLab Enterprise Edition**
- [Issue boards: Add new item projects select a11y label fix](https://gitlab.com/gitlab-org/gitlab/-/commit/fc4e8458003d36bdbb833902bfd31323e9f94b97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182270))
- [Use semantic H3 for "Can't scan the code" section of 2FA setup](https://gitlab.com/gitlab-org/gitlab/-/commit/f03e5814e2c8017341b312bd226b4fde91636864) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182336))
- [Use semantic headers in SingleStatComponent in admin elasticsearch form](https://gitlab.com/gitlab-org/gitlab/-/commit/4cafbb359a0d98d0e7f1569a8247ff27f53f6355) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182335))
- [Use semantic headers for user stat cards in admin and unique links](https://gitlab.com/gitlab-org/gitlab/-/commit/9cb7f6973875f8c3c5461bc5c28ec850ac3353a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182332))
- [Correct acessibility header issues in admin dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/8bf74f71d69482dbd868642338c5d5088d69ddde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182329))
- [Use H2 for job empty state](https://gitlab.com/gitlab-org/gitlab/-/commit/789f9d20e05516ef6296b426c16478a840aee741) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182322))
- [Prevent Child item expand toggle from overlapping child item](https://gitlab.com/gitlab-org/gitlab/-/commit/40ab430c4e8b465551104a8a9aaffce4271d460c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182169))
- [Fix detection of empty merge request approval policy](https://gitlab.com/gitlab-org/gitlab/-/commit/8e0adb60fac29ec4b05a9662b708315915a46e8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179623)) **GitLab Enterprise Edition**
- [Fix MR approval policy evaluation for chained MRs](https://gitlab.com/gitlab-org/gitlab/-/commit/5295fe63551a4343e09864472de3bcf267511d22) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176630)) **GitLab Enterprise Edition**
- [Ensure Md header anchor shows even when description is collapsed](https://gitlab.com/gitlab-org/gitlab/-/commit/52774c106c5c541abc358589d3f543007fc880a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182182))
- [Fix previous/next commit buttons on merge requests](https://gitlab.com/gitlab-org/gitlab/-/commit/3a138546fef5a1091cc3a9cd0f42091d4fb64098) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182168))
- [Fix work item epic listing button](https://gitlab.com/gitlab-org/gitlab/-/commit/d4ad029021d68a70b49ad94181da77b59f2487fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182061))
- [Fixes deactive active deployment with same path](https://gitlab.com/gitlab-org/gitlab/-/commit/39c329746f7572ca18f9658182706d8778ea25bb) by @Rumple_17 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179100))
- [Load missing from dropdown frameworks](https://gitlab.com/gitlab-org/gitlab/-/commit/88eb6009e897872b69afcc1e79aed8bf7f480313) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182184)) **GitLab Enterprise Edition**
- [Load missing from dropdown projects](https://gitlab.com/gitlab-org/gitlab/-/commit/cee88f87f5fb2a76e0bf9b1e77a15b967273bd04) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182137)) **GitLab Enterprise Edition**
- [Add max length calculations and user indications to status form](https://gitlab.com/gitlab-org/gitlab/-/commit/feabf8d1b869709939c6842e98b7546b9f8ad1a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179618))
- [Resync security_policies with incorrect index](https://gitlab.com/gitlab-org/gitlab/-/commit/d4374e2a95a7c0d9cefb3cffad1f3ddd04fd8bd3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181303)) **GitLab Enterprise Edition**
- [Adjusts BSO logic for free groups](https://gitlab.com/gitlab-org/gitlab/-/commit/cf4d27e5b61cc2279c2269765a759dc2b4f76986) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181765)) **GitLab Enterprise Edition**
- [Dompurify: Allow background-color style attribute on GlLabel](https://gitlab.com/gitlab-org/gitlab/-/commit/68405c44650f7c8c07037d3d918bcdccb009e7e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180194))
- [Allow read access for admin job token permissions](https://gitlab.com/gitlab-org/gitlab/-/commit/cd925b93d1ac6fe05091e91794e5d7767b2c852b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181970))
- [Fix setting ci_id_token_sub_claim_components](https://gitlab.com/gitlab-org/gitlab/-/commit/82f296045e3c76fd8a23c9471cbd152769a5016a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181981)) **GitLab Enterprise Edition**
- [Fixes admin page CI minutes css class usage](https://gitlab.com/gitlab-org/gitlab/-/commit/27b10b521c2df4f4a053b98f0973f4569f4f58ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180797)) **GitLab Enterprise Edition**
- [Correct milestone in featue flag definition](https://gitlab.com/gitlab-org/gitlab/-/commit/043d54854c4503589331a2387f7a134ba97d052f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181991)) **GitLab Enterprise Edition**
- [Ignore policy schema validation for custom roles](https://gitlab.com/gitlab-org/gitlab/-/commit/ad4151cb5b83f3956cb66936fc3c4eb0af513cc8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182026)) **GitLab Enterprise Edition**
- [Keep value stream analytics active in sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/1f3d18edc4350f445e9b99fba1de6010dfa95fd8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181844))
- [Add queuing worker for broken adherences](https://gitlab.com/gitlab-org/gitlab/-/commit/c616ddd831d78a973f8dfe77de149ce9e809046c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179944)) **GitLab Enterprise Edition**
- [Fix severity filtering for severity overridden security findings](https://gitlab.com/gitlab-org/gitlab/-/commit/5044210769ef8ba1955b860bf6c11f3ae538a44b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181998)) **GitLab Enterprise Edition**
- [Skip processed members](https://gitlab.com/gitlab-org/gitlab/-/commit/0c7861ca1e89f61c7a9254cc6a744674f28d6d3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180935))
- [Fix DOMPurify validation for SVGs](https://gitlab.com/gitlab-org/gitlab/-/commit/9464f220997d8d4f5d7eea34cd00f0e18d4d0834) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181941))
- [Import GitHub collaborators consistently](https://gitlab.com/gitlab-org/gitlab/-/commit/4eefdb14c629edbad6a29a5c3eb8b0e55f08041a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180685))
- [Fix edit framework refresh bug](https://gitlab.com/gitlab-org/gitlab/-/commit/d3eb0a43790295bb3ac4dedd73f759089ce3bc29) by @nradina ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181290))
- [Add min size to confidential icon](https://gitlab.com/gitlab-org/gitlab/-/commit/42c1fb65dc6a85e5fe03a96fa3c1bdd36994d5a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181779))
- [Generate correct agent URL in managed resource annotations](https://gitlab.com/gitlab-org/gitlab/-/commit/75e8af59be806dfe396c3bcec421008d29351de1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181839))
- [Small alignment fixes in merge widget](https://gitlab.com/gitlab-org/gitlab/-/commit/ae895daf7a003acb4f0acdd8ce327cb318eaa180) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181834))
- [Change date toggle when updated via subscriptions](https://gitlab.com/gitlab-org/gitlab/-/commit/28e939251dc80c52283ef7d32b43c48f9b7c59ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181654)) **GitLab Enterprise Edition**
- [Hide markdown editor fullscreen button when work item is in drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/4c7a183471138021d80cae1ee691ac1f5ea7a77f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180626))
- [Fix release evidence tag name generation](https://gitlab.com/gitlab-org/gitlab/-/commit/d80669df6168f308e010f3f35baad2555045cb25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180772))
- [Fix ambiguous created_at column for pipeline_configuration_full_path](https://gitlab.com/gitlab-org/gitlab/-/commit/0e7ef108f246a1bef4a3765c3340875dbdd0a30f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181334)) **GitLab Enterprise Edition**
- [Fix audit event http streaming under feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/5fb51e7e0a621a1b8a2ffecb207996919bd91141) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181009)) **GitLab Enterprise Edition**
- [Update query for banned user project deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/637bbb91b0ee3b802d220cab2a5130d7042cdbc4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181592))
- [Safely handle when sanitized Elastic result is blank](https://gitlab.com/gitlab-org/gitlab/-/commit/ead89bd40ebcad3b7f88216d45fef06fad735781) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181760)) **GitLab Enterprise Edition**
- [Use correct project when fetching managed resources templates](https://gitlab.com/gitlab-org/gitlab/-/commit/da815aee5ea74e58c86b5020268e93277dde3972) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181749))
- [Fix 'Apply' button for WI dates widget](https://gitlab.com/gitlab-org/gitlab/-/commit/c94cca690189e346d7107c2e90067fe930777d01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181578))
- [Allow access to publicly accessible features from job tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/9d03265f820d7b92cb3b3a8fb1370fc92f503029) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179717))
- [Make multi-word label matching case-insensitive](https://gitlab.com/gitlab-org/gitlab/-/commit/3ceafd23802ab2a38b5ad60a85a7956270fe2281) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180823))

### Changed (189 changes)

- [Use epic creation adapter in more places](https://gitlab.com/gitlab-org/gitlab/-/commit/852f75d079c36a2ba3d0fcd5a4d3ce41c0da442c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181767)) **GitLab Enterprise Edition**
- [Add email delivery for vulnerabilities exports](https://gitlab.com/gitlab-org/gitlab/-/commit/360ecb7d206e7fce820c6b30c96e700d37e984ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183169)) **GitLab Enterprise Edition**
- [Update CI steps syntax specification](https://gitlab.com/gitlab-org/gitlab/-/commit/8fddc95cde27be66643f4bd1bc8a6a5b0384291b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184005))
- [Document how to use a custom PEP pre stage as non-blocking](https://gitlab.com/gitlab-org/gitlab/-/commit/e65edda1f9f55b42e59b31ce76a95a3b95707581) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184603))
- [Finalize delete_orphaned_stage_records](https://gitlab.com/gitlab-org/gitlab/-/commit/67ce59edcfe157444b31c6eafa012f0d70f02209) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178120))
- [Finalize backfill subscription_add_on_purchases](https://gitlab.com/gitlab-org/gitlab/-/commit/97916629289e446348c9d91768b908655c82f7ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184336))
- [Improve performance of CI/CD analytics page](https://gitlab.com/gitlab-org/gitlab/-/commit/98b0b808163da3e7f0e62140fa9c57f80b51bbf4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184328))
- [Update description for q test mr norm and diff](https://gitlab.com/gitlab-org/gitlab/-/commit/f34979a5d3829b18b4ab20b8e9e54be7dd49465a) by @jlosito ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183853)) **GitLab Enterprise Edition**
- [Changed text on the breadcrumbs for creating new entities in projects:](https://gitlab.com/gitlab-org/gitlab/-/commit/5aba39fe7e5fb5367df098e5dbc3e752c48f2ae5) by @illia_bakunovskyi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174315))
- [Crud, MR widget, settings block: Add preference for reduced motion](https://gitlab.com/gitlab-org/gitlab/-/commit/37ea97fceee67309f370a3ea9d36c4055c6dbe1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184434))
- [Remove feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/03b521aa7c270d000618343c536b315f06e20b76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184330)) **GitLab Enterprise Edition**
- [Refresh member authorized projects in background job](https://gitlab.com/gitlab-org/gitlab/-/commit/19b9a244692d21a6b6a4f3226f04df8074be4702) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183920))
- [Enable migrated prompts for summarize comments](https://gitlab.com/gitlab-org/gitlab/-/commit/256d33b1cc2c21f6243055db31847fde5a90c685) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184447))
- [Refactored util to fix sm billable logic](https://gitlab.com/gitlab-org/gitlab/-/commit/fc3ac3521061f789c0493e50eed38c52299e6163) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184305)) **GitLab Enterprise Edition**
- [Add header to project snippets page](https://gitlab.com/gitlab-org/gitlab/-/commit/8e3eed6da4d3e93746014d0638992a84b5c89222) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184201))
- [Enable configuration of Duo Chat sub-features](https://gitlab.com/gitlab-org/gitlab/-/commit/03a24fdcb780fa5d04b621b3b0a79f31d9f152de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175349)) **GitLab Enterprise Edition**
- [Show skipped rows in CSV reassignment email](https://gitlab.com/gitlab-org/gitlab/-/commit/98b291c2ac1fd9a921dee908078dc16ea74ffc9d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183449))
- [Expose correlation ID in overloaded message](https://gitlab.com/gitlab-org/gitlab/-/commit/d9fe2edb9e63f3b0c5131d6b541512c322ba6b15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182908))
- [Update dependency auto-deploy-image to v2.125.0](https://gitlab.com/gitlab-org/gitlab/-/commit/c091dd0c9f2725ec9c488d66bbe6f5fd130493c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184388))
- [Add group and project scope for basic users autocomplete](https://gitlab.com/gitlab-org/gitlab/-/commit/8217c1ac948c9022805f61d3fdd43ff2d527dd21) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182557))
- [RCA/Troubleshoot uses new Claude 3.7 model](https://gitlab.com/gitlab-org/gitlab/-/commit/50bac36c3516db7e8c7fa6a6b4d8e825040456a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184364)) **GitLab Enterprise Edition**
- [Release the Docker Hub credentials support in the Dependency Proxy](https://gitlab.com/gitlab-org/gitlab/-/commit/58d339780ba2cbe87e6a57ecfd3a89f1c71e901b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183020))
- [Update code creation slash commands to Claude 3.7 Sonnet](https://gitlab.com/gitlab-org/gitlab/-/commit/0f6788435f293cacf8eab113fbbf1da654293e3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184333)) **GitLab Enterprise Edition**
- [Remove deprecated remote_development_agent_config references](https://gitlab.com/gitlab-org/gitlab/-/commit/8ce5e46c151eb5a14c036b60b25f897a478cdcbf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183427)) **GitLab Enterprise Edition**
- [Release squash commits options for branch rules](https://gitlab.com/gitlab-org/gitlab/-/commit/236f5a3a9ddc7eaf9a3a1c29a4d3ba85985382c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184177))
- [GLQL: Add Crud to views](https://gitlab.com/gitlab-org/gitlab/-/commit/94e52b56a4fe7b079c802e90560bcc6ab29d8f11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183709))
- [Vulnerability finding: Update design of form](https://gitlab.com/gitlab-org/gitlab/-/commit/1566dddbcf26cb42ec43535df3e894b36c996815) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183668))
- [Move Seat Control > Restricted Access to paid plans only](https://gitlab.com/gitlab-org/gitlab/-/commit/5e9eff2ed6eb41e8aafd7ac78c018b12e2516800) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183983)) **GitLab Enterprise Edition**
- [Release ignore specific revisions in git blame](https://gitlab.com/gitlab-org/gitlab/-/commit/ba43eb5cce1014310146c73086781447bdba375b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184260))
- [Tables: Add scroll indicator](https://gitlab.com/gitlab-org/gitlab/-/commit/8c90370c3fdade51379b0406e52781fa98e2cf49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181650))
- [Update class for to-do item on hover](https://gitlab.com/gitlab-org/gitlab/-/commit/251652370cf6d24bba2fd4afe254ab706df4587e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184064))
- [Update page headings in the CI/CD analytics pages](https://gitlab.com/gitlab-org/gitlab/-/commit/aadca97beb43dc8b4499df58f41f6a2a487d0920) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184282))
- [Remove feature flag `dependency_scanning_using_sbom_reports`](https://gitlab.com/gitlab-org/gitlab/-/commit/11ffa7c2fcd06e030f29ffad39b7719f8339d55f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184295)) **GitLab Enterprise Edition**
- [Clean up labels UI](https://gitlab.com/gitlab-org/gitlab/-/commit/23eb196ed6bf89e45438ff66e3ad9acd5a502156) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183767))
- [Improve error message for webhook name description](https://gitlab.com/gitlab-org/gitlab/-/commit/1bfe6b2c061108c4f17b4d50b9b3ceb0ac35022d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184256))
- [Default enable duo_code_review_claude_3_7_sonnet](https://gitlab.com/gitlab-org/gitlab/-/commit/2f99149eb71a65eb7f60987c252d50928810beaa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184253)) **GitLab Enterprise Edition**
- [Default enable generate_commit_message_claude_3_7](https://gitlab.com/gitlab-org/gitlab/-/commit/d096074c61b313db95350670e709270db9668e6b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184255)) **GitLab Enterprise Edition**
- [SPP docs diff scan web requests feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b27eeb5198d9c9eb2b345012bef5a01b3b1d8e8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183741))
- [Make snippet list info focusable](https://gitlab.com/gitlab-org/gitlab/-/commit/f546698d83357dec5e75abb5fbc7122ee32ed96b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184209))
- [Add archived only project filter to project graphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/f286badda17c876009be947c1c100996dba4972f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182667))
- [Optimize file size check using quarantine dir and add EE-specific check](https://gitlab.com/gitlab-org/gitlab/-/commit/b13520eba56ce581ad58a54fdd422c082d4afd76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183600)) **GitLab Enterprise Edition**
- [Remove group_dependency_list_csv_export feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e44cee8234d6469a28d4ada3e3d5d551bafb36dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184206)) **GitLab Enterprise Edition**
- [Updating /troubleshoot or RCA AI Feature to pull prompt from AI Gateway](https://gitlab.com/gitlab-org/gitlab/-/commit/e0363d9d5d2c2a9a8b20bd47f027e1ceb2b7f6ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184198))
- [Rollout manual severity overrides feature](https://gitlab.com/gitlab-org/gitlab/-/commit/2bfe5a82b28c6912a0687dcfb614568cede38231) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183528)) **GitLab Enterprise Edition**
- [Move GLQL SLIs to its new controller](https://gitlab.com/gitlab-org/gitlab/-/commit/84e91e1952036022ae5a581852bc6b467a467022) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183842))
- [Bump PG default version for CI](https://gitlab.com/gitlab-org/gitlab/-/commit/18d719abee7707e3ba84a918475f840785823b65) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183537))
- [Update Sidekiq memory killer docs](https://gitlab.com/gitlab-org/gitlab/-/commit/d3b2009da3a40bcdd5f6bf273a4d02149196f602) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184130))
- [Remove `your_work_projects_vue` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/dfd2721c1deee154dafc60257ac142613c8fbda6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183429))
- [Move CI_PAGES_HOSTNAME from build.rb to project.rb](https://gitlab.com/gitlab-org/gitlab/-/commit/05346c2fe6c110cd90e642f9ecb336d0fb6818e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183671))
- [Rename Rack Attack log field: request_method -> method](https://gitlab.com/gitlab-org/gitlab/-/commit/c41459d2c6805f332fa1e2ea853890c0ec33ffcd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183888))
- [Add v2 approval rule associations to user and user group](https://gitlab.com/gitlab-org/gitlab/-/commit/6726d1dba0c7a6669a4c78577342161cb648cbeb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179877)) **GitLab Enterprise Edition**
- [Ingest and display direct dependencies](https://gitlab.com/gitlab-org/gitlab/-/commit/5ae47e2187a0e021a3c8932a9ff6d2526ca378be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183246)) **GitLab Enterprise Edition**
- [Add ReplicatorEvents module to seperate event logic from other files](https://gitlab.com/gitlab-org/gitlab/-/commit/93516f6be6ed412b9cd1b47f666cbb79db3fc090) by @bymayanksingh ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/126397)) **GitLab Enterprise Edition**
- [Add tooltip directive to remove snooze](https://gitlab.com/gitlab-org/gitlab/-/commit/8d83822cf76894f87fdff54a63dd97c2246a16a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184071))
- [Add policy type property to editors](https://gitlab.com/gitlab-org/gitlab/-/commit/ec785719c49eb7a49921972a54034f94c24d0bd9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183557)) **GitLab Enterprise Edition**
- [Mlflow get run to return less metrics data](https://gitlab.com/gitlab-org/gitlab/-/commit/9f0cea5f74bf821de69ee44a8ed1ca07df46f7f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183838))
- [Block local URLs for external controls on SaaS](https://gitlab.com/gitlab-org/gitlab/-/commit/012e0578b04d796232a52469232c9569eaff4ae0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182877)) **GitLab Enterprise Edition**
- [Simplify admin_display_duo_addon_settings? method](https://gitlab.com/gitlab-org/gitlab/-/commit/3b724ee7f410aab4a32731510e9dee2bb2d422b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183970)) **GitLab Enterprise Edition**
- [For autocomplete scoped search options, check greater than or equal](https://gitlab.com/gitlab-org/gitlab/-/commit/9c308bf7badb9d240fea90433f930e12248d39f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183972))
- [Enable unblock_rules_using_pipeline_execution_policies by default](https://gitlab.com/gitlab-org/gitlab/-/commit/7db3d37252923a5d16d94e74c8aa18a59f709acb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184023)) **GitLab Enterprise Edition**
- [Update policy_tuning wording to account for pipeline execution policies](https://gitlab.com/gitlab-org/gitlab/-/commit/1c2f01ab5263ce4e0e349b204f78d7741535e569) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183840)) **GitLab Enterprise Edition**
- [Use secure defaults for token storage in TokenAuthenticatable](https://gitlab.com/gitlab-org/gitlab/-/commit/4e111ec3a500290d450b27e501f373512a5338aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183341))
- [Update documentation of policy_tuning with pipeline execution policies](https://gitlab.com/gitlab-org/gitlab/-/commit/0a14ae58cf4fd2cef7614b3cde2278b47fa0190e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183839))
- [Update User Cap settings related error message](https://gitlab.com/gitlab-org/gitlab/-/commit/08b33b9bb09f471cf219ad41b88cfeb49b44c1c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183652)) **GitLab Enterprise Edition**
- [Sync FK `fk_rails_507416c33a_p`](https://gitlab.com/gitlab-org/gitlab/-/commit/01926187255bd87b75c823552f93eafa39cc76b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178117))
- [Add validation for approvals required](https://gitlab.com/gitlab-org/gitlab/-/commit/58c3a67bf114fab167e19a9aad984f7a5ae00071) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183835)) **GitLab Enterprise Edition**
- [Changed regex button colors to design tokem colors](https://gitlab.com/gitlab-org/gitlab/-/commit/3fe6e6583c8903b6638991eb4c4a17b37464b35d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183406))
- [Change text limit for duo workflow event message](https://gitlab.com/gitlab-org/gitlab/-/commit/7c73cc21d95567bbba3ca1226a6ff40d8095b7b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183885))
- [Use progress track when importing single relations](https://gitlab.com/gitlab-org/gitlab/-/commit/13db8ffb657c7b004278be14583f44b7d0c91404) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183862))
- [Use sentence case for package registry](https://gitlab.com/gitlab-org/gitlab/-/commit/a02a09e91f8e8048222ad82b182ba11240791ab7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183533))
- [Rename custom status widget to status widget](https://gitlab.com/gitlab-org/gitlab/-/commit/ef78e820ad7994c643871e83a7b22288fadfd61b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183026))
- [Use text.color.link for hover color in issuable sidebar controls](https://gitlab.com/gitlab-org/gitlab/-/commit/4aa2d94087a7cae2e018ffc0ecec152a8d3812a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183307))
- [Rename the status widget to the verification status widget](https://gitlab.com/gitlab-org/gitlab/-/commit/5c40e02e1b4ce0853c586d873b700a4a2ad86f5a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182520))
- [Making existing pipeline colours more vibrant and supporting additional pipeline statuses](https://gitlab.com/gitlab-org/gitlab/-/commit/951a8521a3c27b6a2021944a7c14255eea033b81) by @barton.tomas ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181091))
- [Display test duration time in 24hr format](https://gitlab.com/gitlab-org/gitlab/-/commit/1a5376274170ea5b8ae58a99515acef701f60be0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183705))
- [Add check to prevent banning paid users](https://gitlab.com/gitlab-org/gitlab/-/commit/a208f3fa4240018ed34c3a008c813c4f57bbf738) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183733)) **GitLab Enterprise Edition**
- [Exclude bot users from dormant removal](https://gitlab.com/gitlab-org/gitlab/-/commit/09382f5c28a1d59a3e995bd3db3a660b371ba05f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183489)) **GitLab Enterprise Edition**
- [System notes: Update icon design tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/f01f4bddd2a672e45ef721a9a7a32f76892849bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183228))
- [Fix auto-applying labels when creating a child issue](https://gitlab.com/gitlab-org/gitlab/-/commit/af0c49b0e31215cfae3f5e02f9627cd6242093df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181605))
- [Restrict new pipeline variables](https://gitlab.com/gitlab-org/gitlab/-/commit/19287da677c161a6e7704ef2cca4d3c2a36eefcb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183420))
- [Runner registration page should not be accessible if registered](https://gitlab.com/gitlab-org/gitlab/-/commit/5168e6cb936042bcbc95d4df8129b4f40a94933b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183178))
- [Add awareness banner for new adhernece report](https://gitlab.com/gitlab-org/gitlab/-/commit/4f005d444b3b24fb23ce3a0cf5308b1193bf8964) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182870)) **GitLab Enterprise Edition**
- [Raise runner token_encrypted length from 128 to 512 bytes](https://gitlab.com/gitlab-org/gitlab/-/commit/ae363528ed36452c7a666dafedf6f8cb5be2d5d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183454))
- [Update feature name to GitLab Duo Self-Hosted in the UI](https://gitlab.com/gitlab-org/gitlab/-/commit/f252a8e7e6504d8c5b47026dedcd6474ac24b24d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182672)) **GitLab Enterprise Edition**
- [Design item: Improve a11y label, contrast and alignment](https://gitlab.com/gitlab-org/gitlab/-/commit/81fceee656b91ecaf5d7c0ec8da2b3f856c0a2bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182722))
- [Remove `reject_security_policy_project_deletion_groups` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b561e72ddbe970548d29876625d3e06142d82f80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183334)) **GitLab Enterprise Edition**
- [Update Compliance Center Breadcrumbs](https://gitlab.com/gitlab-org/gitlab/-/commit/fad978ee4b44c2c246daaafdace629832e0f2d05) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182571)) **GitLab Enterprise Edition**
- [Allow requesting multiple embeddings from vertex](https://gitlab.com/gitlab-org/gitlab/-/commit/389f3afe454440fbe0d161936fc350fea871a0cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182989)) **GitLab Enterprise Edition**
- [Delete the `index_todos_on_author_id` index](https://gitlab.com/gitlab-org/gitlab/-/commit/abfdd0837dcd8e61bbe438c5b91760656448512a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183434))
- [Clean up validate_codeowner_users feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/ab9568cf9bde17ad4dabed53c80cca143c29b508) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182817))
- [Restrict pipeline schedule variables](https://gitlab.com/gitlab-org/gitlab/-/commit/03af63e9d24d362f6668c9f7d070348bdf1b1f8d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183370))
- [Prevent double policy update](https://gitlab.com/gitlab-org/gitlab/-/commit/18f34792108f9f55be10432dc94a071da5d4b309) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183387)) **GitLab Enterprise Edition**
- [Write multiple PEP schedules](https://gitlab.com/gitlab-org/gitlab/-/commit/fa43c2e4209548f1a1856759eb03d7870a02c64c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180714)) **GitLab Enterprise Edition**
- [Add PG 17 to nightly rspec builds](https://gitlab.com/gitlab-org/gitlab/-/commit/5667867f40e4e635d3e286a4db7bb64c47f43db3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182730))
- [Remove FF projectComponentFilter](https://gitlab.com/gitlab-org/gitlab/-/commit/200b808ee862447e97bf33ca2f2f5c6b7452320c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180350)) **GitLab Enterprise Edition**
- [Update seats related notifications](https://gitlab.com/gitlab-org/gitlab/-/commit/048f5998001dcda45b2629a5a800f63d8481ebd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181811)) **GitLab Enterprise Edition**
- [Backfill pipeline execution policy config links](https://gitlab.com/gitlab-org/gitlab/-/commit/d680bee9f4f8ac181b3a0a2f87a8d5cd8d4dd2b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181151)) **GitLab Enterprise Edition**
- [Update dependency auto-deploy-image to v2.124.0](https://gitlab.com/gitlab-org/gitlab/-/commit/c232855b436be8a2463481971f439df7456ca99b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179863))
- [Skip updated failed zoekt tasks to processing](https://gitlab.com/gitlab-org/gitlab/-/commit/f720c56ff067f6515520e5e3cbe51f1b6f865a6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183272)) **GitLab Enterprise Edition**
- [Add enterprise_user key to allowlist](https://gitlab.com/gitlab-org/gitlab/-/commit/90d8c668c96e0278c2aac8c77b8f439a52b51f90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183267))
- [Re-enable PG16 nightly integration jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/6650424340878d2dc84370530ac1ff3e2c7c5558) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182619))
- [Show type label for all pipeline types](https://gitlab.com/gitlab-org/gitlab/-/commit/ba2e11c9c4ef1aaf56c54d7cb8a1a16e2d0e49be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179760))
- [Update UX for dependency proxy for packages settings](https://gitlab.com/gitlab-org/gitlab/-/commit/c46a4336cb16690c4ce3eba3f38515118f0e52b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182818)) **GitLab Enterprise Edition**
- [Update Application Secrets developer docs](https://gitlab.com/gitlab-org/gitlab/-/commit/49221d20ce09b10ce64b59ea8adc5750d1a71ed8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181271))
- [Wiki notes: Update design tokens used, bugfixes](https://gitlab.com/gitlab-org/gitlab/-/commit/2d9703161a74b67714182a9e04d60abb8e6c9c75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183175))
- [Add learn more link to Disable PAT for enterprise users docs](https://gitlab.com/gitlab-org/gitlab/-/commit/99019772b511a6e7c381c600c5337455abb58771) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182965)) **GitLab Enterprise Edition**
- [Sync FK `fk_rails_494e57ee78_p`](https://gitlab.com/gitlab-org/gitlab/-/commit/0efb97716db5f501eecfd63ec807a3ea4231ae98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177980))
- [Align submit buttons for policy cards](https://gitlab.com/gitlab-org/gitlab/-/commit/f4de386d04494a3b7e51a5a40b79af4e7686b469) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183180)) **GitLab Enterprise Edition**
- [Remove feature flag separate_group_scim_table](https://gitlab.com/gitlab-org/gitlab/-/commit/15645449430e62f421a2d37ca7068d3fb5296f8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181148))
- [Improve development widget error message](https://gitlab.com/gitlab-org/gitlab/-/commit/47bf43d79cd6cd4d82863d3f4f5a59f59e350cce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182445))
- [Migrate web_ide_extensions_marketplace ff to data](https://gitlab.com/gitlab-org/gitlab/-/commit/838c777f1cb49ec2d8dcb48ccf8f479d6568c859) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181152))
- [Extends work item shortcut support](https://gitlab.com/gitlab-org/gitlab/-/commit/0f4e1426a03a2d5900dabb415af1490f288e9af9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182327))
- [Remove `reject_security_policy_project_deletion` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/6a75854eacda80e35f8e646d6a919d7f0a65aae3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182413))
- [Update icon in nav to use import](https://gitlab.com/gitlab-org/gitlab/-/commit/df1435f4c1a67aa8e7ebf9b7b0ab604285d58370) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182428))
- [Advanced Search user autocomplete scoped to auth namespaces](https://gitlab.com/gitlab-org/gitlab/-/commit/837a8bed6e3832eb3a0c5ebee069d24eaeb9899f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182277)) **GitLab Enterprise Edition**
- [Execute GitLabDocumentation tool via Agents](https://gitlab.com/gitlab-org/gitlab/-/commit/22446d49a5ccc1a83dda2f3c81f53e9e35020887) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180273)) **GitLab Enterprise Edition**
- [Remove id mapping from skip ci](https://gitlab.com/gitlab-org/gitlab/-/commit/d1987eab6331b866189362dc131309f67c80917c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183027)) **GitLab Enterprise Edition**
- [Remove two related Cloud Connector FFs](https://gitlab.com/gitlab-org/gitlab/-/commit/586288de96c39c5066639f3f4587cf6d82f716c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183010)) **GitLab Enterprise Edition**
- [Introduce new policy for deleting image tags](https://gitlab.com/gitlab-org/gitlab/-/commit/d8413839057daf0fb9b54cb6828c45717137354d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181857))
- [Replace feature flags for email restrictions with setting](https://gitlab.com/gitlab-org/gitlab/-/commit/a522fce6849ad6050e25019076bd5447eff587f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182601))
- [Persist analytics dashboards filter bar selections in the URL](https://gitlab.com/gitlab-org/gitlab/-/commit/a6e5427eb7185be432d8fc32f3ac929fceba488d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182465))
- [Stop logging Direct Transfer pipeline steps](https://gitlab.com/gitlab-org/gitlab/-/commit/52a86894e07455790c3486b5bbcf1547c64d4215) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182966))
- [Migrate restrict_user_defined_variables to `true`](https://gitlab.com/gitlab-org/gitlab/-/commit/998d84eeb4f49a9be9396f21ac8b2263f38ebee6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181856))
- [Fix Style/FormatString offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/7b948e371a1fd5fe9d0596c774c67ed0814064fd) by @JonstonChan ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180293))
- [Copying over the rest of the pipeline variables form code](https://gitlab.com/gitlab-org/gitlab/-/commit/d210d4b52efec681e99a34f717ee0b6e9d4916c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182455))
- [Add scheduling columns to PEP schedules](https://gitlab.com/gitlab-org/gitlab/-/commit/1fd72554464971cf1e05cf8f4d0b0be8cab24264) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180708)) **GitLab Enterprise Edition**
- [Shorten text when leaving comment as review](https://gitlab.com/gitlab-org/gitlab/-/commit/c85dffde22659b99c05637016af530dbb464ab15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182885))
- [Adjust texts for exclude license packages](https://gitlab.com/gitlab-org/gitlab/-/commit/92c1ac78928ed40614bc4c60c2a58960c9858d47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182740)) **GitLab Enterprise Edition**
- [Create new Geo verification state table for SnippetRepository](https://gitlab.com/gitlab-org/gitlab/-/commit/a7e7a8303af57ed28ca095719bfff1190693d30e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181255)) **GitLab Enterprise Edition**
- [Add ids argument for descendant groups](https://gitlab.com/gitlab-org/gitlab/-/commit/f846d2b6a971fca31ed76918aef7e6591eeb46ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182411))
- [Fetch details of banned and blocked users](https://gitlab.com/gitlab-org/gitlab/-/commit/59540294796a74d28a8e1ec9c8ae46d0ffa1c567) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182218))
- [Abstract pipeline_variables_form to its own component](https://gitlab.com/gitlab-org/gitlab/-/commit/c240c18d7349fbf8622d1a7efe071f7a913f86fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182376))
- [Document Workhorse repository archive cache](https://gitlab.com/gitlab-org/gitlab/-/commit/ce38353bf2ba67f4381632db12df95a0b006fab8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182810))
- [Improve dependency export API usability](https://gitlab.com/gitlab-org/gitlab/-/commit/c1c21fe6bf4c1f811db1b0e3453a69c316032136) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182814)) **GitLab Enterprise Edition**
- [Clean up auto_assign_duo_seat feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3a71ad12a8c1e888ed710ec55d08106078fd2707) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182638)) **GitLab Enterprise Edition**
- [Change strings to use consistant ellipses](https://gitlab.com/gitlab-org/gitlab/-/commit/aeb6a8a1dc3f4f7dae354b4d0402e7290f305531) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182709))
- [Add zoekt setting to control rollout batch size](https://gitlab.com/gitlab-org/gitlab/-/commit/2fdb68a4bcbdc18879e77f83384dc4ebec3d938b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182581)) **GitLab Enterprise Edition**
- [Added delete oauth connection on Amazon Q disconnect](https://gitlab.com/gitlab-org/gitlab/-/commit/a5c5d0ee36dbbd37e91fd1a8c66353d5eaaf3551) by @protsivd ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182043)) **GitLab Enterprise Edition**
- [Deprecate the `force_to_redownload` field in Types::Geo::RegistryType](https://gitlab.com/gitlab-org/gitlab/-/commit/651735dbe5dcbdbdbef42b0692584e7377c6b898) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182342)) **GitLab Enterprise Edition**
- [Add bulk dismissed event and subscriber](https://gitlab.com/gitlab-org/gitlab/-/commit/64799942060e65f084e8ef420bd046a5394b8abe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181239)) **GitLab Enterprise Edition**
- [Save licenses outside of the spdx catalog as custom licenses](https://gitlab.com/gitlab-org/gitlab/-/commit/fd33f8ca15745c0bb7e144ca5eef502274913e74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181454)) **GitLab Enterprise Edition**
- [Allow use to select a date range of Runner Usage](https://gitlab.com/gitlab-org/gitlab/-/commit/e6e9b74b758bf8c306c9d54dba7185e23fa77c86) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182095))
- [Allow dashboard panel to reload data with query overrides](https://gitlab.com/gitlab-org/gitlab/-/commit/7e05ab0554047785fae5929c90f0046d28487c00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181955))
- [Add ai context migration model](https://gitlab.com/gitlab-org/gitlab/-/commit/a4e9b17d25adcadb76b07afff4deb11042f741dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181238)) **GitLab Enterprise Edition**
- [Delete dropdown item in label list use danger variant](https://gitlab.com/gitlab-org/gitlab/-/commit/104f17a715665f916426eadc0bebb3c24d140673) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182301))
- [Use tertiary explore projects button](https://gitlab.com/gitlab-org/gitlab/-/commit/cc55c1746705eca56bd8e8f111d320a4688aa8f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182447))
- [Update active context Collections table](https://gitlab.com/gitlab-org/gitlab/-/commit/b02468dab2f8df0e8a08351bd184752b289d6d5b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181923))
- [Update bundler to v2.6.5](https://gitlab.com/gitlab-org/gitlab/-/commit/3e387d7f9a7d8802b371e17dbbf1d8741b698bd8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182381))
- [Extract fromYaml method shared method](https://gitlab.com/gitlab-org/gitlab/-/commit/8dc39af3ac2ca661a978c18823a92a55ddd783ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182288)) **GitLab Enterprise Edition**
- [Change markdown multiline quoting behaviour on already quoted lines](https://gitlab.com/gitlab-org/gitlab/-/commit/d31b9144e6eb513d9ff7dd9038ee4d0f6d1fabb8) by @Bubbis ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178744))
- [Update Pod counters to reflect search filter results on environment page](https://gitlab.com/gitlab-org/gitlab/-/commit/6879ae9e2912f0978fce5e0cfa0c675a07095024) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182283))
- [Remove action approvers from helper](https://gitlab.com/gitlab-org/gitlab/-/commit/c6121a53ee5e95730049ca81831127f70b31e328) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179138)) **GitLab Enterprise Edition**
- [Add UI for pipeline variables minimum role project setting](https://gitlab.com/gitlab-org/gitlab/-/commit/0fc948bdf08c32be1d91ad44229017355105bee4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172304))
- [Clarify tooltip message](https://gitlab.com/gitlab-org/gitlab/-/commit/52e8fec529460437601269b4800c3f34b7388ec6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181635)) **GitLab Enterprise Edition**
- [Avoid writing over the severity override](https://gitlab.com/gitlab-org/gitlab/-/commit/7c488d2191af61f37271003f047c69f8368bc4a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178804)) **GitLab Enterprise Edition**
- [Improve API error for invalid sub claim component](https://gitlab.com/gitlab-org/gitlab/-/commit/94a7572382c6fa633dad1906d0330acfa404bb70) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182257)) **GitLab Enterprise Edition**
- [Cleanup duo_chat_drop_redis_storage feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/a03300e094fd10129aba3a8cf89c629617084b1b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181908)) **GitLab Enterprise Edition**
- [Log Duo Chat M2000 Error Code](https://gitlab.com/gitlab-org/gitlab/-/commit/f180046f9efe4fd1927cbb91addfd32d69bca031) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181374)) **GitLab Enterprise Edition**
- [Support custom pipcompile lockfile in DS latest template](https://gitlab.com/gitlab-org/gitlab/-/commit/681405f7aee3b098a571904577567445b403bd01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182159)) **GitLab Enterprise Edition**
- [Change keyFields for ScanExecution type](https://gitlab.com/gitlab-org/gitlab/-/commit/4c3ee50cdbb218ca5c528c06d6f36ebec4b687fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181964)) **GitLab Enterprise Edition**
- [Remove work_items_alpha flag from Move button](https://gitlab.com/gitlab-org/gitlab/-/commit/0f978d4f7e339e41cb1a5879deecfb17febdb8ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182203))
- [Add minor UI changes for Severity Override](https://gitlab.com/gitlab-org/gitlab/-/commit/bfc92587714e9657eb40e056a4d3c6a7d6abbbfc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181504)) **GitLab Enterprise Edition**
- [Move Troubleshoot button inside the sticky footer](https://gitlab.com/gitlab-org/gitlab/-/commit/24712bb718b5662492fccf6055dcdeae545246c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182161))
- [Update allow/deny list payload](https://gitlab.com/gitlab-org/gitlab/-/commit/864f1a10c388122cf9216c1e4c665f2a41cfb3b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181803)) **GitLab Enterprise Edition**
- [Remove the `snoozed_todos_sort_order` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/ac94d0496961302f66f4ac54c68b2cc3b215d627) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181569))
- [Static reachability job process only DS artifacts](https://gitlab.com/gitlab-org/gitlab/-/commit/2e31ea086cfccd5821e4d2cf20b091e999c1e8c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182146))
- [Add minimum override role to CI/CD settings mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/6b5df91c72490ebf6e3ce8c0d81ed2b273a6b814) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174598))
- [Disable group ascendency validation on Direct Transfer](https://gitlab.com/gitlab-org/gitlab/-/commit/62406aa03a2a89cfbe737a02498172965919d65d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181804))
- [Redesign the action buttons for manual jobs to improve usability](https://gitlab.com/gitlab-org/gitlab/-/commit/8788ba4dd38f3b037f085ba665dca68da3f9e933) by @shakahwath.hussain ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176368))
- [Model registry: Clarify buttons and titles](https://gitlab.com/gitlab-org/gitlab/-/commit/abf269dfe1f4934159d30287d4c68ab2f08c6cdf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181667))
- [Update repository limit notifications](https://gitlab.com/gitlab-org/gitlab/-/commit/d616887c8433614bf46589297bd434844967a201) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180779)) **GitLab Enterprise Edition**
- [Enable `ensure_pipeline_policy_pre_stage_complete` by default](https://gitlab.com/gitlab-org/gitlab/-/commit/96a26299aedbeee75aa91a46d2a31714e4ad4dde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182081)) **GitLab Enterprise Edition**
- [Disable remove user button for last owners](https://gitlab.com/gitlab-org/gitlab/-/commit/bcc2a5de1434dc14af0666c8d16e277544c4ab7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181706))
- [Allow Duo Chat to be resizable on self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/4bc8783dfa525925fb4d02bfa59d4eb5aef8c03b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182008)) **GitLab Enterprise Edition**
- [DB migration to add Milestone widget to Epic work item type](https://gitlab.com/gitlab-org/gitlab/-/commit/6dc651b7964b668bab5bf802bfd2865eac6d0a60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180857))
- [Add zoekt index watermark level update callback](https://gitlab.com/gitlab-org/gitlab/-/commit/99e74190a8de611665e2bc53305717e09d31dc63) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181056)) **GitLab Enterprise Edition**
- [Remove the `pat_ip` derisk feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e5e5dc5a1a1df71e08f03eb15a874880f2a063a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178297))
- [Fix vulnerability autoresolve flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/8f104fb74fe0395c8f0bccdc9fd4fe73418e51c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181850)) **GitLab Enterprise Edition**
- [Fix: Enhance error handling for expired relation export keys](https://gitlab.com/gitlab-org/gitlab/-/commit/1f33e7ad1000bf370345ef452dcf89a4eb8e9e96) by @guptapratibha26 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180802))
- [Improve error handling when creating new directory](https://gitlab.com/gitlab-org/gitlab/-/commit/3a2dc8755ae5724af24ac3d5c08b137dd9077625) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181766))
- [Add ai active context connection model](https://gitlab.com/gitlab-org/gitlab/-/commit/20ffcf455d6416152dabc185a711c06bb1eb7985) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181400)) **GitLab Enterprise Edition**
- [Change project export download rate limit](https://gitlab.com/gitlab-org/gitlab/-/commit/111898b836da5fb2b11e5ad6d236f61e43d63983) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181822))
- [Update Duo Pro usage button to Purchase seats](https://gitlab.com/gitlab-org/gitlab/-/commit/96223f384f943cec325236044c52c31285530160) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181198))
- [Show badge for multiple licenses and tooltip for unknown licenses](https://gitlab.com/gitlab-org/gitlab/-/commit/bedc31cdda02002aa6b759a0b2f99be0603bcd3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181109)) **GitLab Enterprise Edition**
- [Add animation to a menu section chevron](https://gitlab.com/gitlab-org/gitlab/-/commit/559870d1035469987698b183812ee2f24b1b5c0c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174872))
- [Make the Troubleshoot button in the Job Log app sticky](https://gitlab.com/gitlab-org/gitlab/-/commit/8ab43ed407e9802f0b8782e48cf81819b9fb2225) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181565))
- [Set new host URL params when initializing Web IDE](https://gitlab.com/gitlab-org/gitlab/-/commit/4b0d2f3d5da8c26e5c0938cbab983e53a029b1bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180050))
- [Fix Style/FormatString offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/7794ffa690251e1693a8c274dd9e83c56fe160ba) by @JonstonChan ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178810))
- [Readd 422 error context to omniauth error page](https://gitlab.com/gitlab-org/gitlab/-/commit/4e5756c7c67cda1ddfbb9e671584a94a6d4754ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180272))

### Removed (28 changes)

- [Remove all *_tab ff and mark migration as noop](https://gitlab.com/gitlab-org/gitlab/-/commit/6d39c9ed199d759ee0bfeb47edff26ce7a6731f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184734)) **GitLab Enterprise Edition**
- [Removal of non Claude 3 Model](https://gitlab.com/gitlab-org/gitlab/-/commit/b54d187639389b1d5769f70f6275e0bd4ded1373) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184545)) **GitLab Enterprise Edition**
- [BBM for removing orphaned notes](https://gitlab.com/gitlab-org/gitlab/-/commit/765cbfc79aa7d02c6fc3119cf72fde4d7b713cec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180624))
- [Removed feature flag extended_expiry_webhook_execution_setting](https://gitlab.com/gitlab-org/gitlab/-/commit/969c5b6c9aad0481e0bc08ba98d43c572c90bbc6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184300))
- [Remove note on commit real-time update on MR](https://gitlab.com/gitlab-org/gitlab/-/commit/505145665f4d839c36ef697299217fc67816c6af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184138))
- [Clean up `blob_repository_vue_header_app` flag](https://gitlab.com/gitlab-org/gitlab/-/commit/ea324a8af683f6f7492beccfa5135a7e0b0b455a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183259))
- [Cleanup Claude 3.5 Haiku feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/8a0c9c47d30b2068b0939a2e6def188a19f934b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184065)) **GitLab Enterprise Edition**
- [Delete the `zoekt_cache_search_responses` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/daf7dbe21fd620026e52d1a2dcb7f3fa9db58e5d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183217))
- [Remove broken foreign key fk_a2141b1522_p](https://gitlab.com/gitlab-org/gitlab/-/commit/8f2a98491b3f40aaeb4a8dcc48c4a9cdcdc82064) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183638))
- [Remove unused feature flag and partially completed code](https://gitlab.com/gitlab-org/gitlab/-/commit/037bde32ecb4d09c468418843dcfd4bd983b2e20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182334))
- [Delete increased concurrency indexing ff](https://gitlab.com/gitlab-org/gitlab/-/commit/8b8835c716e3c8f2de08bdb58f218a9f55b3553a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183211))
- [Remove redundant code from new pipeline page](https://gitlab.com/gitlab-org/gitlab/-/commit/cc4d772df7ac3f066367698e2858ecf5c5f25983) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182475))
- [Remove unused feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/c2b836e7496cd44e46ee3fc6a0b681c8e1b89634) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183168))
- [Remove confidence columns from vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/1b5ca4b70ec67878056c4b6a20d6b9595b1d182e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182637))
- [Delete the `zoekt_reallocation_task` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/06a4e04e0766cc886bb2851880c5caf39850bdbc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182901))
- [Delete the `zoekt_scheduling_worker` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3e83080edc1d00ce4941bb5e7d99b0fba3f64801) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182854))
- [Delete the `zoekt_replica_state_updates` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/86666f9a3e92547cad804f9fd94b4d87343ca318) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182853))
- [Removing use_typhoeus_elasticsearch_adapter flag](https://gitlab.com/gitlab-org/gitlab/-/commit/de12601a214b480862d82a6551356dfaeae5df40) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182284)) **GitLab Enterprise Edition**
- [Delete the `zoekt_random_force_reindexing` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4bc693c8b00a5d1b2d2127dd644d12a81e9dd5f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182555))
- [Delete the `zoekt_internal_api_register_nodes` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/5acf245b53f22d6fbf7a2a3a48ffd9ab24621f37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182552))
- [Drop geo_event_log.repositories_changed_event_id column](https://gitlab.com/gitlab-org/gitlab/-/commit/076e72c9c49b1918944025dc56afdc0628e7e929) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182462))
- [Remove DB table system hooks and NoStiSystemHooks model](https://gitlab.com/gitlab-org/gitlab/-/commit/263172a41bb0e49daeea14c21e6dd0eae92e90c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182115))
- [Delete the `pipeline_stage_set_last_modified` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3a76d872b3704e8123980ee574148f7b7f7ff6ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182100))
- [Remove yaml format feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f093b1c6795693dd09713f75472b87cfd1ebc8bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181705)) **GitLab Enterprise Edition**
- [Remove ignored AI application settings columns](https://gitlab.com/gitlab-org/gitlab/-/commit/c223ba9a8a34fa163703c0fa00434f3dc6bf35cc) by @crenz ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179175))
- [Remove fetch-arkose-data-exchange-payload feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/2907cbaac718c92ecc5c4571b7c3766826c39868) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181670))
- [Remove custom_ability_read_admin_users feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/201a335f9b22c643bff7314c8effa2acefa874ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181571)) **GitLab Enterprise Edition**
- [Remove pass_add_on_name_for_trial_requests feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/1e2bccd193d6dcf06f863b74c3872f7ea3f08b07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179725))

### Security (18 changes)

- [Fix ruby-saml gemspec](https://gitlab.com/gitlab-org/gitlab/-/commit/c2c5be905c6c6989373e6c5d098293ee2c5f2811)
- [Mask unencoded userinfo in project mirror errors](https://gitlab.com/gitlab-org/gitlab/-/commit/08ae64432f8ea3a57d4f1f731fed435a34087f76)
- [approval_rules name is unbounded](https://gitlab.com/gitlab-org/gitlab/-/commit/57a03b551b4c1442a17368b0a99a6173fcec387e)
- [Vendor GraphQL gem](https://gitlab.com/gitlab-org/gitlab/-/commit/163192bd96554bfc1e57a87b722a13c936753357)
- [Ruby-SAML updates](https://gitlab.com/gitlab-org/gitlab/-/commit/4d45b6fa090a6d4a879eb04d9e156eaecddd26c0)
- [Limit preview size](https://gitlab.com/gitlab-org/gitlab/-/commit/10b827df7c47db18d805f361d82d78f570eb0898)
- [Prevent custom role to activate group members](https://gitlab.com/gitlab-org/gitlab/-/commit/6ee484f51bf9ca4b554fd996e808d9c0a1082e61)
- [Filter out internal notes if the recipient do not have access](https://gitlab.com/gitlab-org/gitlab/-/commit/1ccf3302c55f26b50772709588d1e37ddfb10438)
- [Maintainer can inject shell code in Google integration configurations that...](https://gitlab.com/gitlab-org/gitlab/-/commit/649d3dea98eb12d185791d022f04c39eb4ff4fd4)
- [Revert "Merge branch 'security-private-artifacts-jobs-api' into 'master'"](https://gitlab.com/gitlab-org/gitlab/-/commit/82064a60dccb41503704b7b103662fa47d9604b0)
- [Bump KAS version](https://gitlab.com/gitlab-org/gitlab/-/commit/f0c1092e0b6b76ac7305e872a706bff2b83bc27a)
- [Use stricter CSP values in the packages dependency proxy](https://gitlab.com/gitlab-org/gitlab/-/commit/1801feb9cee23ee0e40b4118f92b85c0a16ade78)
- [Escape work item dropdown items and restrict HTML tags](https://gitlab.com/gitlab-org/gitlab/-/commit/c8b9fff5b661fc66476d45a96372e7fd5477a000)
- [Fix access to read code review analytics in private projects](https://gitlab.com/gitlab-org/gitlab/-/commit/3e82c62c208678269aee11038662e8b4cbf70c54)
- [Increase minimum role in SPP to read policy yaml](https://gitlab.com/gitlab-org/gitlab/-/commit/8006df30b1661af00c010c7507962c72fcfcc3fa)
- [Check user access for artifacts in Jobs API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/ae8cd6c91e3e5c4fd2645182e902f4d7d9a059d8)
- [Resolve "Enterprise User with disabled PATs can still use PATs"](https://gitlab.com/gitlab-org/gitlab/-/commit/5567f530d5145142dcbd9eeafaa21ce8356ea5a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181669)) **GitLab Enterprise Edition**
- [Resolve "Enterprise User with disabled PATs can still create PATs"](https://gitlab.com/gitlab-org/gitlab/-/commit/a5484070e64511211bce9f6076635361938e2b03) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181661)) **GitLab Enterprise Edition**

### Performance (12 changes)

- [Improve User#verified_emails when emails are preloaded](https://gitlab.com/gitlab-org/gitlab/-/commit/21c9c55cba38e58d825ddb75277fe5efffcc191c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184663))
- [Set the patch_id outside of the DB TXN](https://gitlab.com/gitlab-org/gitlab/-/commit/2f4a3e2f5eebe23d6f277de789ffa0cdb5c41a1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179734))
- [Fix backend filtering in RTE autocomplete](https://gitlab.com/gitlab-org/gitlab/-/commit/c7b0872098ba9a3e3974ba913ed5f86e4df4c7d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183637))
- [Model: Improve performance of with_version_count scope](https://gitlab.com/gitlab-org/gitlab/-/commit/6a82a69352bc9f2079cc15ebadb200a6145307aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183031))
- [Update the authentication codeowners yml & script](https://gitlab.com/gitlab-org/gitlab/-/commit/ec85af3ebb68c73de6838e5e6881a67ce53f207e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178264))
- [Improve query performance for all_projects_pages_domains query](https://gitlab.com/gitlab-org/gitlab/-/commit/787589188a8a493cd15631cc21af9333c7663aef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182897)) **GitLab Enterprise Edition**
- [Enable ci_merge_request_variables_preload and remove the FF](https://gitlab.com/gitlab-org/gitlab/-/commit/803f8812bd94e381bc9703a4eaa7da628da6ee8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182252))
- [Prevent N+1 queries when fetching issue references](https://gitlab.com/gitlab-org/gitlab/-/commit/b8e8954f33d6e2bca470161a17a6574d80034ecb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182233))
- [Optimize build.execute_hooks when creating pipeline](https://gitlab.com/gitlab-org/gitlab/-/commit/3213e2e4bc384cbee052ecadfbeef5faaaed7e17) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182074))
- [Validate p_ci_pipeline_variables#project_id constraint](https://gitlab.com/gitlab-org/gitlab/-/commit/0337ecbd1e3ebaffa46d2a0c8755f0f479e29153) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180066))
- [Deliver reassignment mails later](https://gitlab.com/gitlab-org/gitlab/-/commit/84ed112184b3aa05897472f67f50e26ff9738fc9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181826))
- [Enable bitbucket_import_resumable_worker flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e91cf215414b44559710a9f473526650eda91679) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181647))

### Other (194 changes)

- [Add NOT NULL on ml_candidate_metrics.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/31aefa505b8e64330eb8db7119a7de5e5b90272e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184431))
- [Add NOT NULL on ml_candidate_params.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/3d32c3f1fbae958cdb56c3410fbb61d474f312b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184432))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/34e391840a30714cc639abac909d9ad79d58f09b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184766))
- [Add and backfill project_id for merge_request_context_commit_diff_files](https://gitlab.com/gitlab-org/gitlab/-/commit/49a59903299a998d3e3aa6fcc8f917516dcfa384) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183935))
- [Add compliance control status transition events and metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/1c3565339b78cff53f7cc40603dedec6f66b078e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183256)) **GitLab Enterprise Edition**
- [Add NOT NULL on ci_build_trace_chunks.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/719454739f9bd4be3b0a5f829cd848aab0c16f9a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183976))
- [Documenting Cells configuration for OmniBus and Helm Charts](https://gitlab.com/gitlab-org/gitlab/-/commit/98830eb3b96587647db39a0a48774e35c302767a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180957))
- [Improve documentation access token API](https://gitlab.com/gitlab-org/gitlab/-/commit/ab0baf261c3861b95ad53e8008ffa57cd08bdfde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184291))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/1513d44c30d0adefd16f414040b3aeb22df00f90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183188))
- [Model registry: Simplify table mechanism](https://gitlab.com/gitlab-org/gitlab/-/commit/83de5babd1f2280f6f9cacf7c36ffffb9e26a186) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184031))
- [Add and backfill project_id for packages_nuget_dependency_link_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/7ae94045c8f36be77c7199028df8a1b1ea53e5ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184610))
- [Add NOT NULL for sharding key on packages_package_files](https://gitlab.com/gitlab-org/gitlab/-/commit/12f461033ac48f9a51c124a2162aeb5327625b6e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184630))
- [Add NOT NULL for sharding key on incident_management_oncall_rotations](https://gitlab.com/gitlab-org/gitlab/-/commit/793d6b8f03b7b8be59f8619a18debdcd78b4cb88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184622))
- [Sync translations from crowdin (2025-03-14)](https://gitlab.com/gitlab-org/gitlab/-/commit/7e8edbc6510143d8a01eca2c05453283833f4315) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184615))
- [Add sequence to partitioned runner tables](https://gitlab.com/gitlab-org/gitlab/-/commit/3889fe2e32946d647fe721f2dd82aa67fdc5644f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183817))
- [Remove Gitlab::Redis::ClusterSessions post migration](https://gitlab.com/gitlab-org/gitlab/-/commit/dad64361c6b56ec1f4dd3ec2033f74b47ff5d3c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184562))
- [Add NOT NULL on ci_builds_runner_session.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/8ca1bd48a443e69bdb0f7d8e78d5c04df0f22ead) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183977))
- [Add NOT NULL constraint on ci_unit_test_failures.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/24cc5df25fb46d675a38c142efa631dae68453c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182507))
- [Add NOT NULL constraint on packages_dependency_links.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/41c3220cc4261eac7a1df63cd48ec6f562b5cbe1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182510))
- [Migrate HTTP instance audit event destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/7d19d209c72089be675034093286dd4e6f394163) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184035)) **GitLab Enterprise Edition**
- [Skip saving pipeline config when using inputs](https://gitlab.com/gitlab-org/gitlab/-/commit/e8af953ebc6ddedf3df806694625f5dcf31b447c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184318))
- [Add & backfill sharding keys for snippet_user_mentions](https://gitlab.com/gitlab-org/gitlab/-/commit/114308c19e8ebf0e6d6f97bfcb969701c6172707) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180836))
- [Add & backfill sharding keys for snippet_statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/4f30c94fba6bc2068ce33ad64dd6b90e17ad7bfa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183124))
- [Add & backfill sharding keys for snippet_repositories](https://gitlab.com/gitlab-org/gitlab/-/commit/bbcb0efba3bc4c7b6fa577fa14c6c89721255aef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175410))
- [No-op 20250307080100 migration and retry in 20250307080101](https://gitlab.com/gitlab-org/gitlab/-/commit/f60155196640decafdf40d185c2d4bb7a758cf52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184439))
- [Add ProjectsWithComplianceFrameworks metric](https://gitlab.com/gitlab-org/gitlab/-/commit/a056fce989d95e9c324c6fdd3a06b172a93bd01a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183422)) **GitLab Enterprise Edition**
- [Add compliance requirement metrics for controls and policies](https://gitlab.com/gitlab-org/gitlab/-/commit/f5dd408a36e4391b554c17382658f4d49131e014) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183382)) **GitLab Enterprise Edition**
- [Sync translations from crowdin (2025-03-13)](https://gitlab.com/gitlab-org/gitlab/-/commit/59d23b74f074baf95a4d64249a788c0674e41919) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184470))
- [Remove Gitlab::Sessions::RedisStore as session store](https://gitlab.com/gitlab-org/gitlab/-/commit/b9c288656b9e40f699462ced6a5225888ec2f087) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181637))
- [Remove update_merge_request_worker_sticky feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d48f58a5d02537aa44e2fa752c471ae15e10a98a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184411))
- [test: Add missing feature categories for tests related to system access](https://gitlab.com/gitlab-org/gitlab/-/commit/ec53d463bf176db2350a85713bd11e41ea87e4ce) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176700)) **GitLab Enterprise Edition**
- [Sync translations from crowdin (2025-03-12)](https://gitlab.com/gitlab-org/gitlab/-/commit/3fe80a44d1b019acea6600a575d2815522a65548) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184036))
- [Finalize migration BackfillMembersRequestAcceptedAt](https://gitlab.com/gitlab-org/gitlab/-/commit/0187d67271e58fd710180e5faaab1f9fb7531e37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184105))
- [Add internal event tracking to placeholder reassignment](https://gitlab.com/gitlab-org/gitlab/-/commit/0244f146f8fb5794a545685d391afc86ce68d59a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182679))
- [Enable reassignment throttling feature](https://gitlab.com/gitlab-org/gitlab/-/commit/cf25daf2d4444f1f0a621a48a53a95b99e004991) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184131))
- [Replace ci_runner_machines with partitioned table](https://gitlab.com/gitlab-org/gitlab/-/commit/5680b0559d160a214e72ad23dfb2c38e7a7a4706) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182859))
- [Finalize migration BackfillMilestoneReleasesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/9b0a98b5985cb66cab0ce731115b17a1ab6c3967) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184106))
- [Remove redundant validate in BulkImport::Entity](https://gitlab.com/gitlab-org/gitlab/-/commit/f9e4a8ae23165520a44882e17bdcbe1231ad2441) by @n.h.long.9697 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182760))
- [Improving Cells validation message](https://gitlab.com/gitlab-org/gitlab/-/commit/a7127cc046b94832eb4d835debf800c92e264d91) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184040))
- [Finalize migration BackfillIncidentManagementEscalationRulesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/cff739e1dfd123693cf7d18bb74484ad013b7dfb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183765))
- [Add and backfill project_id for deployment_merge_requests](https://gitlab.com/gitlab-org/gitlab/-/commit/577d1817d5424403700b709fb27d086153ba714f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183738))
- [Add and backfill wiki_page_slugs for namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/60acb9075de7b0101bfc4a89f0e0d7accbec26b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183332))
- [Remove Gitlab::Redis::ClusterSessions post migration](https://gitlab.com/gitlab-org/gitlab/-/commit/9d143551abc59e6a0b30d4af42af96c3e876dac5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181631))
- [Finalize BackfillIncMgmtTimelineEventTagLinksProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/61bed0e11899a199c01095e59046834b32260d92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183908))
- [Finalize migration RerunEpicDatesToWorkItemDatesSourcesSync](https://gitlab.com/gitlab-org/gitlab/-/commit/d55563e12754a5aa85eb18aa8cc6cc871fdb6342) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183282))
- [Remove bulk_create_scan_result_policies Feature Flag](https://gitlab.com/gitlab-org/gitlab/-/commit/6558e1637d19ab0bdee0b5c494e9acb56c37fb6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183509)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/60445f0f5ef1c52460e85dec9257113edd26badd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183923))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/f9e0c3fe1aa6e74eebbb473ab2cad86509065583) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184119))
- [Populate redirect_routes.namespace_id on save](https://gitlab.com/gitlab-org/gitlab/-/commit/b258d82c870660dbd251af5a5e7fc6e29eef722a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183974))
- [Add FK constraint and index on merge_request_user_mentions.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/21634826da4ff0ee4d3400ae6a519d5480257694) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183971))
- [Fix merged MRs that reverted to "closed" state](https://gitlab.com/gitlab-org/gitlab/-/commit/ea4ef3c3809ae45a71be0b8fd97f46b3ae0b789a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181021))
- [Remove existing users from onboarding if they have group saml](https://gitlab.com/gitlab-org/gitlab/-/commit/81605ddb9c114dba8a6030fa728cf06b6b0f8575) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183559))
- [Fix Style/SendWithLiteralMethodName offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/7a47fc425ded8d3f51274b0ff069710655b2e0ca) by @albertoroldanq ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179585)) **GitLab Enterprise Edition**
- [Remove the `mr_approvers_filter_hidden_users` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/275476b7757ed7665b6b5f8293773eb1d3142327) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183058))
- [Add and backfill project_id for approval_merge_request_rules_approved_ap](https://gitlab.com/gitlab-org/gitlab/-/commit/880a4f383dafaf9bf80088aa005e133f17657a5c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183352))
- [Replace ci_runners with partitioned table](https://gitlab.com/gitlab-org/gitlab/-/commit/21cbc3beac1b4c58eb47a0b2c2a791100f3ec124) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183508))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/8abda5c1de7f6556f0dd4c23a856a339fcea8f3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183628))
- [Add and backfill project_id for approval_merge_request_rules_users](https://gitlab.com/gitlab-org/gitlab/-/commit/f683b5501f484b294bc22fc8acb4d397312bbc48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183354))
- [refactor: Add oauth_login_counter before request phase middleware](https://gitlab.com/gitlab-org/gitlab/-/commit/9788d7d1f3502027cf474f697859ce1a38f774a9) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177720))
- [Finalize migration BackfillCiSecureFileStatesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/0f0499f55fb0dd86819daf179cc65ca5586f137e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181727))
- [Finalize migration BackfillIncidentManagementOncallRotationsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/9d8a6e53c97108433caf92fcdd93ad2427f2e8a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183766))
- [Finalize migration BackfillDastSiteProfilesBuildsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/49960c402969bd5aa2d56778e7d4ef11711631fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183452))
- [Finalize migration to backfill namespace_id in policy rule schedules](https://gitlab.com/gitlab-org/gitlab/-/commit/ccaffa6a8e7908f3ee13541b513acaf247a99961) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183280))
- [Finalize BackfillApprovalProjectRulesProtectedBranchesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/23b71c4faf18a88099a60620d1285c0b61876e91) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183451))
- [Add CountFrameworksWithRequirementsMetric](https://gitlab.com/gitlab-org/gitlab/-/commit/bbb8bb5eaac6575034ba865fbca77f0be0c5347c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183414)) **GitLab Enterprise Edition**
- [Add and backfill project_id for packages_debian_project_component_files](https://gitlab.com/gitlab-org/gitlab/-/commit/773bf078489ae099410dbe3e929bf2793a007746) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183806))
- [Rename remote development namespace cluster agent mapping table](https://gitlab.com/gitlab-org/gitlab/-/commit/b6c3b59f2a95317f93df1db680fbf065abeadb30) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181926)) **GitLab Enterprise Edition**
- [Add NOT NULL constraint on packages_debian_project_components.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/67e6453223fb1a1b6fbe9650c0ec05e54babb696) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182509))
- [Cleans up authentication_logs_migration_for_allowlist feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/5664ef2019c354fb2eaf15d9c3ff211258de39a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183773))
- [Create ClickHouse table to store group traversal namespaces paths](https://gitlab.com/gitlab-org/gitlab/-/commit/93eeeb09c78e953d3587f4577d2c6ada4d4caaf2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182164))
- [Add namespace_id column to redirect_routes](https://gitlab.com/gitlab-org/gitlab/-/commit/133f4815bcfd064c3d4ed34164d18b66744c2d15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183002))
- [Add performance bar to GraphQL explorer](https://gitlab.com/gitlab-org/gitlab/-/commit/57190ec595dcf60febe30b83deb8685c430adcae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171948))
- [Validate not null constraint on projects.project_namespace_id column](https://gitlab.com/gitlab-org/gitlab/-/commit/595684382c459d18bccd0f3444fd53a2065f4412) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183649))
- [Refactor Cells configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/1dd42ed25234e1be37273ad4399d5db4501bfda3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181708))
- [Add and backfill namespace_id for incident_management_pending_issue_esca](https://gitlab.com/gitlab-org/gitlab/-/commit/d7b8feaf1b544a8a342c9937189f74fbd7ddd4ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183047))
- [Remove shared_namespace_locks feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/79b86d8e467ac2a7292a7e0b484d1c76003f5abd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183624))
- [Use occurrence id to fetch dependency graph](https://gitlab.com/gitlab-org/gitlab/-/commit/4b42d50e7ad8b20fd974042949aabbca0797477b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183625)) **GitLab Enterprise Edition**
- [Finalize migration BackfillCiBuildTraceMetadataProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/2673238b6d419b4eba095409874c325011b4b23e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182192))
- [Backfill onboarding_status_setup_for_company from user_preferences](https://gitlab.com/gitlab-org/gitlab/-/commit/b071a20a528b307bc84905604c3de6e46029a99d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180602))
- [Add approval_policy_rule_id to scan_result_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/a79788d08fdc1f319da981a4dbf8a016044c2476) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182418)) **GitLab Enterprise Edition**
- [Remove broken FK between builds and pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/214d2295825675a79262f5c7e6aa42daa31d54ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174115))
- [Move Import file removal to a cron job](https://gitlab.com/gitlab-org/gitlab/-/commit/1d6c03f0b2047a6bb9f69035f68028911c549063) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182101))
- [Remove ci_runner_manager_runtime_features feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/2b5b8d8b5aa36ce8ae32381d5bca5afc5bb3db8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183500))
- [Finalize BackfillSecurityOrchestrationPolicyRuleSchedulesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/77d6f49595b87fcaf6534c741e1b04f735d80f84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183281))
- [Finalize Batched Background Migration](https://gitlab.com/gitlab-org/gitlab/-/commit/63460747ade74fac657a198f1ba118644daa6649) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182653))
- [Remove groups/discovers_helper.rb](https://gitlab.com/gitlab-org/gitlab/-/commit/0a893e67ca9a85f2dac582e86e16732ab2467e99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182779)) **GitLab Enterprise Edition**
- [Reindex work items to index notes data](https://gitlab.com/gitlab-org/gitlab/-/commit/c2cb179046c0fc700b9bd4e2d27fcd8824bb7ca2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182950)) **GitLab Enterprise Edition**
- [Replace ci_runners with partitioned table](https://gitlab.com/gitlab-org/gitlab/-/commit/93cf156a339a7e14815600a92d1329430842eb55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182549))
- [Add and ensure presence of resource_mileston_events.namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/f7a9511c8e3455e0b9c7219718d440f24ca5b82a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181868))
- [Add ability to manage experimental features for security policies](https://gitlab.com/gitlab-org/gitlab/-/commit/5b2f637b31e942f79731e5d5042265fa5d17bd0b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182484))
- [Add index on approvals.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/b1edb2fc3ba2a3d7a1ac4f1b4b572a941fb1876e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182066))
- [Add NOT NULL on ci_pipeline_schedule_variables.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/63c118d28f7d0c4653365219ed1ca1f175253121) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182681))
- [Add and backfill project_id for push_event_payloads](https://gitlab.com/gitlab-org/gitlab/-/commit/f03f3991fa283cdc1216032c028a2e9651503d46) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183123))
- [Finalize protected_environment_deploy_access_levels backfill](https://gitlab.com/gitlab-org/gitlab/-/commit/2d5e8328b7b7071b1781091af90d5e4bf6db9bda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183279))
- [Validate NOT NULL on approval_merge_request_rules sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/6e98f72a64120a0700df81b63bd8c3e569e19133) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180907))
- [Add and backfill project_id for scan_result_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/ecc5b7abfd71962f8e6d2ee4ea04d6714dda4f48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183125))
- [Minor improvements to the performance bar](https://gitlab.com/gitlab-org/gitlab/-/commit/a45c755ba147f735a076ec0e780ce5406bfefeb2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181397))
- [Finalize migration BackfillProtectedTagCreateAccessLevelsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/e7824f9ab214f3c7e6f840bceffc4bd83bb5eccd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181208))
- [Remove dead code around recaptcha_on_top_level_group_creation feature](https://gitlab.com/gitlab-org/gitlab/-/commit/64a32f0674c13f333c5cea96b1bb796efca850b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183174))
- [Finalize migration BackfillMlCandidateParamsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/f52900d7b38399494433fc148be672d576d1de1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183109))
- [Finalize migration MakeSecurityPolicyBotsPrivate](https://gitlab.com/gitlab-org/gitlab/-/commit/1d8014071f93ee3b942952b72dd7085d31f44f08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182962))
- [Finalize protected_environment_deploy_access_levels backfill](https://gitlab.com/gitlab-org/gitlab/-/commit/0242462664281a7470b6bd66e24aff5fbce9a6ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183110))
- [Move Import file removal to a cron job](https://gitlab.com/gitlab-org/gitlab/-/commit/e4a7ff58142e84458a3f18e838de333c2ab9891c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181784))
- [Finalize migration BackfillReservedStorageBytes](https://gitlab.com/gitlab-org/gitlab/-/commit/446f6068b41b0bc819f2a392931bec463912622c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182189))
- [Store project namespace traversal paths on ClickHouse](https://gitlab.com/gitlab-org/gitlab/-/commit/cfd2482073576de3332749d8effac5085491b59e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183053))
- [Introduce `Vulnerabilities::ArchiveExport` model](https://gitlab.com/gitlab-org/gitlab/-/commit/fa145e30591667582b14f1d1b32776aeaa89a3ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182290))
- [Reindex Elasticsearch merge request to update integer with long type](https://gitlab.com/gitlab-org/gitlab/-/commit/28c969e902362b492225b6f4dde9519febfbc10e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182255)) **GitLab Enterprise Edition**
- [Reindex Elasticsearch user index to update integer with long type](https://gitlab.com/gitlab-org/gitlab/-/commit/94eee10017dd8e418eb5c55eb393c481c570ead7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182733)) **GitLab Enterprise Edition**
- [Reindex Elasticsearch note index to update integer with long type](https://gitlab.com/gitlab-org/gitlab/-/commit/f1d971c86bbf29b1570f9053912495739cd01e53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182727)) **GitLab Enterprise Edition**
- [Finalize "generate commit message" migration to AI Gateway](https://gitlab.com/gitlab-org/gitlab/-/commit/a70658e227b2cca454cb26a1814d96bef4261414) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182969))
- [Finalize migration BackfillCiBuildsRunnerSessionProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/0b08c2dec0ebf6b469870b8991c0c50e73942d7a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181723))
- [Finalize migration BackfillMlCandidateMetricsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/f4c506f3a2dfb67fc8c07662cb3bcd3fc4a69e2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182963))
- [Finalize migration BackfillVulnerabilityOccurrenceIdentifiersProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/43ace000ca708a9a960ae988e141efe4e1fd7efd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182654))
- [fix(rubocop): Fix Performance/MapCompact offenses in app/models/ci](https://gitlab.com/gitlab-org/gitlab/-/commit/6d9cae74b9ed8e5624a7337140790548c246196f) by @thelooter ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182956))
- [Remove kubernetes_agent_protected_branches feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/2280141eebab910158a344951cda78586086c6e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182895))
- [Remove feature flag pat_organization_filter](https://gitlab.com/gitlab-org/gitlab/-/commit/f42e8601404015866abc046fa007213c0c65965d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182700))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/ae18647f643704cf2f6499f419657cd04c8e96e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182673))
- [Finalize migration BackfillEpicIssuesNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/2a1fbf479b636c5120a0dd5da996be85f3c6553d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181719))
- [Finalize migration FixNamespaceIdForWorkItemParentLinks](https://gitlab.com/gitlab-org/gitlab/-/commit/709b7692ef46039fcb7b070452e379b306fea145) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182656))
- [Fix any bad sharding_key_id values on project runners](https://gitlab.com/gitlab-org/gitlab/-/commit/b612a0ad4c82d5cea8c3150ff0e905b766dba52f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182527))
- [Update work_item_type_custom_fields FK](https://gitlab.com/gitlab-org/gitlab/-/commit/c0e5b9b6a88fe42dd340bf52f58f0aecff705618) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182051))
- [Fix Style/SymbolProc offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/9b31b6baeaaf314685c4db110d1fab87137d102d) by @barton.tomas ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181311))
- [Introduce data retention guidelines](https://gitlab.com/gitlab-org/gitlab/-/commit/23b9659db568b77e904904c2867678adbc485c97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178455))
- [Add NOT NULL on vulnerability_state_transitions.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/1342a12bf73ab1563caf9a50032445531dffcc46) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182698))
- [Finalize migration BackfillErrorTrackingErrorEventsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/5f59c6f57262511849ebe59ddf2c59d18ac8f383) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181720))
- [Save runner runtime features to runner manager](https://gitlab.com/gitlab-org/gitlab/-/commit/e6e0813759ff8742c2588d177b88234227643506) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181817))
- [Validate NOT NULL constraint on packages_build_infos.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/bef629ebe02c776886e60bc68c86e0c4945df568) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182526))
- [Validate NOT NULL constraint on merge_request_reviewers.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/37ccc8b5902a7eb24ab73f3f2566b93d1c1d4c16) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182524))
- [Add NOT NULL constraint on evidences.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/00b2cc0f4e3c24ba40dc42fb72ebd63424445982) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182508))
- [Add NOT NULL constraint on packages_maven_metadata.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/34ba8b3e62d8edbcd68e2feebef08835f2ba47b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182511))
- [Add and backfill namespace_id for issue_assignees](https://gitlab.com/gitlab-org/gitlab/-/commit/ef77f05e872bed20da94544321182e10886f0f0c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174106))
- [Finalize migration BackfillCiPipelineScheduleVariablesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/a42d96684acb006b4a063db76787b079ba3baab6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181725))
- [Remove correct_work_item_type_id from work item index](https://gitlab.com/gitlab-org/gitlab/-/commit/0a4d85e57d8a517352dc310766612f65d93e98d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182551)) **GitLab Enterprise Edition**
- [Replace client lib with pure HTTP implementation](https://gitlab.com/gitlab-org/gitlab/-/commit/e5bbaf93c43c83fafcda8c33f5ef36de46ff1759) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182567))
- [Add new Elastic commit indexer worker](https://gitlab.com/gitlab-org/gitlab/-/commit/7e93d41685abe15dee084588f2a0116e845a0c98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182114)) **GitLab Enterprise Edition**
- [Enable virtual_registry_maven_cleanup_new_worker_class by default](https://gitlab.com/gitlab-org/gitlab/-/commit/2bd137bcf385496fcecbda4eb5ca13192eab70ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182560))
- [Remove security widget findings FF](https://gitlab.com/gitlab-org/gitlab/-/commit/951b74877df8075bfb226d25fa6c59ddf331c9ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182541)) **GitLab Enterprise Edition**
- [Remove show_diff_if_head_sha_commit_is_missing flag](https://gitlab.com/gitlab-org/gitlab/-/commit/18512914ed74fce2ba2e2ec80a6117a2a4f0577b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182473))
- [Creates event trigger to alter range of new sequences](https://gitlab.com/gitlab-org/gitlab/-/commit/e51a48ba87ecbc70d2c65976e320773f78445045) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181115))
- [Add the new state deleted in Zoekt::Repository model](https://gitlab.com/gitlab-org/gitlab/-/commit/130f7b5e27c367a177c3e396e2c2bee1cc05557e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182402)) **GitLab Enterprise Edition**
- [Remove `global_file_size_check` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/fa8667b80dda3cb3ed44e755350f4ab041124783) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173546))
- [Remove reference to taggings table in deduplicate_tags rake task](https://gitlab.com/gitlab-org/gitlab/-/commit/9f0c508f50e4a1aef2f138bb54598f54e4d6b72f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182412))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/11ae1fa569bcd1fb28067bf7783c65395fe4e789) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182408))
- [Cleanup security_policy_custom_roles feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4a482bbc33a50ab16f01cb97fadc4fce861b533d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181530)) **GitLab Enterprise Edition**
- [Finalize migration BackfillMergeRequestUserMentionsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/7d9d3d2c63248e538d7b61887018f1d4a5964882) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181880))
- [Validate NOT NULL on merge_request_blocks sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/917a705a30218442626274a9a6357a5dadf3ca52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180913))
- [Remove feature flag `policies_always_override_project_ci`](https://gitlab.com/gitlab-org/gitlab/-/commit/e257a9ab9abbfb4c2d8063cb157a83f57083ae9e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182001)) **GitLab Enterprise Edition**
- [Finalize Batched Background Migration](https://gitlab.com/gitlab-org/gitlab/-/commit/44b224d018493b6edb7709829996f7fff6c34f97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182188))
- [Finalize migration BackfillEvidencesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/f7e005bbb6dae8a5a54952afa898255b5e1f8902) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181721))
- [Finalize migration BackfillCiBuildTraceChunksProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/4ebba95792c93a88c2e4a8272b3ed8e3595dd0e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182191))
- [Finalize migration BackfillCiBuildPendingStatesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/a078e50c90c13218f744954c02347f9efa9477cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182190))
- [Add tables/model for targeted messages](https://gitlab.com/gitlab-org/gitlab/-/commit/65a84e0299508cb21ae7b6e3005fbfadd92809d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179303))
- [Remove ai_commit_reader_for_chat flag](https://gitlab.com/gitlab-org/gitlab/-/commit/cb549de5bdda28c27cf091ee46e5671cf6c7c053) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181555)) **GitLab Enterprise Edition**
- [Add and backfill group_id for packages_debian_group_component_files](https://gitlab.com/gitlab-org/gitlab/-/commit/8831e8e773a144d62789c57b2214119aec2fed2c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182117))
- [Add and backfill project_id for project_relation_export_uploads](https://gitlab.com/gitlab-org/gitlab/-/commit/c5d70a305c577138d6d56302d60efc475a1c9ebe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182116))
- [Add NOT NULL constraint on packages_debian_group_components.group_id](https://gitlab.com/gitlab-org/gitlab/-/commit/41410bb73a81cd0eeac8015352e418174cd47247) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181064))
- [Release vulnerability report identifier filter for group level](https://gitlab.com/gitlab-org/gitlab/-/commit/022bbec4123ec5d75d52e6887c16c0e7b92078d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182084)) **GitLab Enterprise Edition**
- [Finalize migration FixSyncedEpicWorkItemParentLinks](https://gitlab.com/gitlab-org/gitlab/-/commit/ee62a87c75df8be99e1d0c39faccf55b3c7aae4c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181330))
- [Validate NOT NULL on project_relation_exports sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/83472208a7c3e9cead4fe9ad3bd3c7dcfe83130e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180914))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/65082c9a54186e0a4e93a9385c27bd14d5493221) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182057))
- [Validate NOT NULL on draft_notes sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/96c9c3d3b0804a90b8ac55aad7e6275f03d8491f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180909))
- [Finalize migration AlterWebhookDeletedAuditEvent](https://gitlab.com/gitlab-org/gitlab/-/commit/6adbc44d84adb7c1674107904bac2ce700fc524c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181480))
- [Finalize migration BackfillCiResourcesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/8dbde447f2810fc89d81bee928b15cead1e0d179) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181726))
- [Refactor approvals widget](https://gitlab.com/gitlab-org/gitlab/-/commit/f684e7be723f58344ff96249e5895083f5fb9d87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178957)) **GitLab Enterprise Edition**
- [Remove Elasticsearch settings from application settings](https://gitlab.com/gitlab-org/gitlab/-/commit/95418b5ea732f2a6231ea2247ba91cbd00b0d24e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181660))
- [Remove unused ClickHouse table ci_failed_pipelines_counts_by_namespace](https://gitlab.com/gitlab-org/gitlab/-/commit/1d308570d9f40b634931244284b5ed2afa6b0b9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182019))
- [Validate NOT NULL on status_check_responses sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/9ea39e80542b6b24e37beab0d116d2353013eb31) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180701))
- [Validate NOT NULL on vulnerability_finding_links sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/80472e5665b50192db1c2dd89142c959d3a35e40) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180689))
- [Finalize migration NullifyBuildsAutoCanceledById](https://gitlab.com/gitlab-org/gitlab/-/commit/e9e3a23bd6de3670ec2f89147a28d72c618301f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181732))
- [Finalize migration BackfillCiTriggerRequestsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/775a69f8fb60e26f6c223c2c29eaad35cafd25b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181729))
- [Finalize migration DeleteOrphanedPipelineVariableRecords](https://gitlab.com/gitlab-org/gitlab/-/commit/eb8c59eb0aca189f4c9ba30dca3804b2e2ea8769) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181730))
- [Finalize migration BackfillCiBuildNeedsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/ff678d0f38fe270d298d3e45ccf5250a947d68cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181722))
- [Reindex work items for type id alignment](https://gitlab.com/gitlab-org/gitlab/-/commit/5df7fbe7e36914f295983efabc7e42afd5ce7c63) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181790)) **GitLab Enterprise Edition**
- [Finalize migration BackfillCiUnitTestFailuresProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/928f7d0dfeeb581c6488838fedb5c34986ca10c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181728))
- [Finalize migration BackfillPackagesPackageFilesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/11ed1d8ac4ebe9ed6550e1277bebc25f57365a2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181882))
- [Finalize migration BackfillVulnerabilityStateTransitionsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/e578dec947e6092be8e3b8bfd2a2c8ddc885ac51) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181203))
- [Remove ElasticIndexingControlWorker job instances](https://gitlab.com/gitlab-org/gitlab/-/commit/e48ffffd972ca76c738cb7beb938c2ea8e34ab60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181668))
- [Change routes.namespace_id from LFK to regular foreign key](https://gitlab.com/gitlab-org/gitlab/-/commit/9a75bbf1cdd6eea1532e8deda641db683b59e531) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181772))
- [Finalize migration BackfillVulnerabilityExternalIssueLinksProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/84e34ecdf8fb4b7e174b59390dfdb5deae5ad338) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181209))
- [Remove concurrency_limit_process_commit_worker feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/0d19797675118823b66844c18a8939fbb8b3b39e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181758))
- [Add NOT NULL constraint on merge_request_reviewers.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/b8045ea96420397aeccc721315a9b74d7a0dea9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181081))
- [Use the pipeline creation meta data rather than project.ci?](https://gitlab.com/gitlab-org/gitlab/-/commit/a5cb7724df7dfb75862c248b314d269626c1b2e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181745))
- [Validate NOT NULL on merge_request_assignees sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/a517000bab7e91b063f7edd37609af4e17500d6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180912))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/0244921f55a133eb8dd57e17c212edb6e62cc2e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181491))
- [Update maven virtual registry cache entries table](https://gitlab.com/gitlab-org/gitlab/-/commit/fae2f9df5189040d8790d7c98c37c1dd21828d04) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181707))
- [Re-enqueue LimitNamespaceVisibilityByOrganizationVisibility migration](https://gitlab.com/gitlab-org/gitlab/-/commit/4f536c2bd45495263e6f5706117245307f58e148) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181640))
- [Add NOT NULL constraint on merge_requests_closing_issues.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/b61c2e1c39dec7a91d43f7ef2a12fdc769fee767) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181082))
- [Finalize migration BackfillPackagesMavenMetadataProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/d27b6ead984e72424569109176e998a5c7bdce5f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181207))
- [Add NOT NULL constraint on vulnerability_merge_request_links.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/ef7913273b9a45cce654fbadb46e06524c59550a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181080))
- [Add NOT NULL constraint on vulnerability_issue_links.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/c34add13294a3d6f1e22c9747685cb712da9b1c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181079))
- [Validate NOT NULL on epic_user_mentions sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/661448171c0c5f2ac9dd8984f406db19d7169ba1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180910))
- [Validate NOT NULL on issue_links sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/88d10656deca31b2af41b3fcb20f5c56aa88af7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180911))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/998d8028213da6bf0c3c1c08301797c8b3395c28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180234))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/8ae69a3765cfb7561db95e43faa30cc60fac6444) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177662))

## 17.9.2 (2025-03-11)

### Fixed (3 changes)

- [Fix the pipe search for zoekt exact search mode](https://gitlab.com/gitlab-org/security/gitlab/-/commit/22030051963d488575df6a2cca19e1d4e0d82a2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183373))
- [Prevent deletion of project_bot users with non-expiring access tokens](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0249d460f0f6b7f867e7a4171e0effae2e4e5135)
- [Use correct project when fetching managed resources templates](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9bac9ffcd01abff2bf0d4d38829655e394dea3b3)

### Security (8 changes)

- [Vendor GraphQL gem](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e78a52dcafa4c7316e01d4dcd35a33ab9623f532) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4841))
- [Ruby-SAML updates](https://gitlab.com/gitlab-org/security/gitlab/-/commit/780f136abbf4b27c18485e5c173aaa18acfcb644) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4828))
- [Prevent custom role to activate group members](https://gitlab.com/gitlab-org/security/gitlab/-/commit/efbd1afae3cce6bb4e03e91ed82b7af27671977f) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4833))
- [approval_rules name is unbounded](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9a4e857ea3223fe56536a81f3d1fdadb833eca8d) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4838))
- [Limit preview size](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b2ce61725c9946766a2a964377fc756d87e8234e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4821))
- [Maintainer can inject shell code in Google integration configurations that...](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7fd30226d79520b742abd9edc01055766f56c39b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4824))
- [Filter out internal notes if the recipient do not have access](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a55e5b359912daa90ef07c73ebd66b4bb9b0e2c3) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4815))
- [Mask unencoded userinfo in project mirror errors](https://gitlab.com/gitlab-org/security/gitlab/-/commit/af6f445b66c3353652c47ad36b1c700c2c0572a1) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4789))

## 17.9.1 (2025-02-26)

### Fixed (1 change)

- [Fix instance level dashboard by default severity override](https://gitlab.com/gitlab-org/security/gitlab/-/commit/56d2f940bb6e87b34e4f26ba9a298f28360dd23a) **GitLab Enterprise Edition**

### Security (4 changes)

- [Increase minimum role in SPP to read policy yaml](https://gitlab.com/gitlab-org/security/gitlab/-/commit/593c0a6f70564e9570fb16b25a37298eacf6c644) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4718))
- [Fix access to read code review analytics in private projects](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0faa526c76e3c523ff6486057c5b5b07e8e4e5d9) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4794))
- [Escape work item dropdown items and restrict HTML tags](https://gitlab.com/gitlab-org/security/gitlab/-/commit/fc777a98ebd45b30ab95bc0d94a418479d15f09c) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4788))
- [Use stricter CSP values in the packages dependency proxy](https://gitlab.com/gitlab-org/security/gitlab/-/commit/922d3ad17cf7493a10f8dbf90c0cae8d9d4b063d) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4787))

## 17.9.0 (2025-02-19)

### Added (202 changes)

- [Add GraphQL API for visualizing dedicated hosted runner compute usage](https://gitlab.com/gitlab-org/gitlab/-/commit/e10ed189e9751c952f151582bc252c6fe3facbaf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179854)) **GitLab Enterprise Edition**
- [Adds the `experiment` status for analytics dashboards](https://gitlab.com/gitlab-org/gitlab/-/commit/df3439845aa82540c67eec2d787da1727e246f7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180879)) **GitLab Enterprise Edition**
- [Allow adding comments on Wiki pages](https://gitlab.com/gitlab-org/gitlab/-/commit/962ae956d85337b4bd2b39f68ee090310018e6b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181518))
- [Add integrity verification for remote CI includes](https://gitlab.com/gitlab-org/gitlab/-/commit/5ba3eaea9ead230ac8b5e05db2aa52feed47afee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178593))
- [Set default_enabled to true for feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4527baca1d925264574ca6cbdee15c17c2567392) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181535)) **GitLab Enterprise Edition**
- [Set `default_enabled` to `true` for the feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4d09aa620d997d5c078a673b8491c363f1b97238) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181539)) **GitLab Enterprise Edition**
- [Remove maven_extract_package_model feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/73081481fc5d991f6f2b3a662d47a852156b214f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181366))
- [ActiveContext add preprocessors for references](https://gitlab.com/gitlab-org/gitlab/-/commit/d5d91112ad701855c64f1b9cfc63862fb05022dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181671))
- [Add worker to unassign security bot](https://gitlab.com/gitlab-org/gitlab/-/commit/d0c82d558321c289164d7ab25adb9a905064410c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180760)) **GitLab Enterprise Edition**
- [Introduce project.vulnerabilityArchives GraphQL field](https://gitlab.com/gitlab-org/gitlab/-/commit/28459e82005e6faa13074a0aa823852c53894bb5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181102)) **GitLab Enterprise Edition**
- [ActiveContext postgres indexer](https://gitlab.com/gitlab-org/gitlab/-/commit/8ae3016c1d25ee2be105f8fdb02c1890b3597387) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180719))
- [Add support for created_at on work_items create API](https://gitlab.com/gitlab-org/gitlab/-/commit/39079ed89c4d34f80c77436bd8a60aa55b045f18) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180903))
- [Add `Shared groups` tab to group overview](https://gitlab.com/gitlab-org/gitlab/-/commit/144b070b5c5975d6a8ce83700fdf7eeb748056f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181039))
- [Model registry: Support loading runs](https://gitlab.com/gitlab-org/gitlab/-/commit/57ffba14b4bf304308fc57f0eb1e2aeaef042333) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177136))
- [Add API endpoints for group level integrations](https://gitlab.com/gitlab-org/gitlab/-/commit/a884ebabbe7b41e2b50552673123c943a1a37654) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179694))
- [Admin Token API: Revoke Feature Flags Client token](https://gitlab.com/gitlab-org/gitlab/-/commit/23e99f5bdd2985517afb82dcad7560bec8d63a16) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181096))
- [Update flag for duo chat include file context](https://gitlab.com/gitlab-org/gitlab/-/commit/cd269a964d09827c44aa50d80f01d9e8870d943c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181305)) **GitLab Enterprise Edition**
- [Add pipeline analytics for groups on GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/226a0be9c4c8ec595b577aa4171c260d72af7a75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180579))
- [Add organization and job title to user synced attributes](https://gitlab.com/gitlab-org/gitlab/-/commit/5780048d27619f8fc59c74e4665a5f81d818ee6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175662))
- [Query evaluator for expression control](https://gitlab.com/gitlab-org/gitlab/-/commit/a56f18e9eee736b60e61d32825c52f8f3689f4aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177981)) **GitLab Enterprise Edition**
- [Add vulnerability_severity_overrides table](https://gitlab.com/gitlab-org/gitlab/-/commit/6e35bd6cc5dbaafe63083a659ab1f830dd31763e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176952)) **GitLab Enterprise Edition**
- [Display dropdown text explainer on component token](https://gitlab.com/gitlab-org/gitlab/-/commit/0db6b774e3c3a1d1472db258e761c03e80b163d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181132)) **GitLab Enterprise Edition**
- [feat: Protected packages: Maven package push protection](https://gitlab.com/gitlab-org/gitlab/-/commit/863e774de5e5cbb14abf0ee1b713e08532dd25f5) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/147055))
- [Show message when approaching Pages deployments limit](https://gitlab.com/gitlab-org/gitlab/-/commit/3ec667b154e067411adeab55d53024ae1d08c772) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181119)) **GitLab Enterprise Edition**
- [Add error tracking widget to work items](https://gitlab.com/gitlab-org/gitlab/-/commit/40be2a269d54672ad62d755dc727677ae76a04ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179719))
- [Added resources widget](https://gitlab.com/gitlab-org/gitlab/-/commit/508b5d8572aae2e046f422fddb90bacc287ed8eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174793))
- [Expose sign_in_restrictions from ApplicationSettings API](https://gitlab.com/gitlab-org/gitlab/-/commit/cfc21639522a54eadc08456e908596288942be43) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181247))
- [Add thread ID to AI completion response](https://gitlab.com/gitlab-org/gitlab/-/commit/f2d23a004c00bd0cdd596433ab46bb395aae2d07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181129)) **GitLab Enterprise Edition**
- [Add enforce_email_subaddress_restrictions application setting](https://gitlab.com/gitlab-org/gitlab/-/commit/f73c3599f23cfcd86d917cd3dff9e01af2c0b656) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180446))
- [Add support for severity overrides in pipeline security finding type](https://gitlab.com/gitlab-org/gitlab/-/commit/16d52222936a6b710336a5f169955a7b2d82c9f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180965)) **GitLab Enterprise Edition**
- [Add inject_policy_ci as default pipeline execution config strategy](https://gitlab.com/gitlab-org/gitlab/-/commit/b8dbacfaca8fa99b8c16820ca79f945028ba035f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178715)) **GitLab Enterprise Edition**
- [Add service class to trigger external control](https://gitlab.com/gitlab-org/gitlab/-/commit/916189504f2a02067a06124c512421d8f3a2fde8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180016)) **GitLab Enterprise Edition**
- [Implement revisions/:recipe_revision/:file_name endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/e8507d2207825d45595e17f9a19f02622bbf843d) by @oceane_scania ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176600))
- [Add `MALFORMED_ENTRY_OWNER` error for CODEOWNERS](https://gitlab.com/gitlab-org/gitlab/-/commit/8b3d59d5a60a99c87198e4483266bf1d5345ff79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180978)) **GitLab Enterprise Edition**
- [Reschedule backfill of vulnerabilities.detected_at](https://gitlab.com/gitlab-org/gitlab/-/commit/5853bb891dd91aa91a700d59d819b8c377f86266) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181192))
- [Add UI for subscribed filter](https://gitlab.com/gitlab-org/gitlab/-/commit/2fdefbe87845ff4ea239e57c96e149433422228b) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/136007))
- [Promote runs in standalone experiments to a model version](https://gitlab.com/gitlab-org/gitlab/-/commit/1a03c7d720859001ad67c39d91bbd649e2fc3f9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179228))
- [Add an option to specify language for file icon](https://gitlab.com/gitlab-org/gitlab/-/commit/27cedf7a09ed3f72ca178199de6a865cb34cb977) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178147))
- [Added ability to manage compliance frameworks at project level](https://gitlab.com/gitlab-org/gitlab/-/commit/289c328d971955585001bd98cd2995817fb63d5e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180103)) **GitLab Enterprise Edition**
- [Add swift to package_metadata_purl_types](https://gitlab.com/gitlab-org/gitlab/-/commit/b93db4245313e9124fa95feffcaab58d7c15643b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179539))
- [Pipeline mini graph downstream jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/8308e8c57f7f5c5a10ef475e7f457d5f52b94c6e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180464))
- [Expose lastDuoActivityOn user field in GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/b21ed8bec3f2759373364b71f0f4d1b6aba661f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179704)) **GitLab Enterprise Edition**
- [Load SoftwareLicenses names from catalogue](https://gitlab.com/gitlab-org/gitlab/-/commit/fc8c388dc89f6c2eccd1f4720d8dd3f1a6b44631) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179744)) **GitLab Enterprise Edition**
- [Add rebase button to MR widget if available](https://gitlab.com/gitlab-org/gitlab/-/commit/5c173ad53be80ad970925c3ca939f31d6e2ccac7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179906))
- [Adds root redirect feature](https://gitlab.com/gitlab-org/gitlab/-/commit/13e68cb8b4e5d3454d0ba8907adcac62d80ef920) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180352))
- [Add updatedAt ExperimentType graphql type](https://gitlab.com/gitlab-org/gitlab/-/commit/749226c85913910f03d9854f2a02481c28351fd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180789))
- [Document how to use Azure workload and managed identities](https://gitlab.com/gitlab-org/gitlab/-/commit/9e98e06cefcf376edc47f536db9c45d6d1ed6f9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180471))
- [Add missing json fields to WorkspacesAgentConfigType](https://gitlab.com/gitlab-org/gitlab/-/commit/1fdd573893efef6783ea5d7b2362c8315cb528a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180084)) **GitLab Enterprise Edition**
- [Add scim_group_uid to saml_group_links](https://gitlab.com/gitlab-org/gitlab/-/commit/96193ac9e8a1497bc0b0f226a93c6ed140c71b08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180288))
- [Add vulnerability_severity_overrides table](https://gitlab.com/gitlab-org/gitlab/-/commit/3e7c02d5ef712f639890c48653e8a641e127ae66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176952)) **GitLab Enterprise Edition**
- [Add model-level default for Vulnerability#detected_at](https://gitlab.com/gitlab-org/gitlab/-/commit/2bfab9155b623d325dfb03ac3cb8fda7f1562274) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180582)) **GitLab Enterprise Edition**
- [Browser history added](https://gitlab.com/gitlab-org/gitlab/-/commit/5317e50b07b3745e3d31720e19b94b7280b2226c) by @nraj0408 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178564))
- [Extend GraphQL dependency type](https://gitlab.com/gitlab-org/gitlab/-/commit/b37c46db2f05402dd5941c445a0241b8b69a0aa2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179062)) **GitLab Enterprise Edition**
- [Add the model record id to a replicable item in the Geo replicables list](https://gitlab.com/gitlab-org/gitlab/-/commit/7197613a81b99ffdeb89bb5fec63dd265129b971) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180713)) **GitLab Enterprise Edition**
- [Update Create Page with Default Devfile](https://gitlab.com/gitlab-org/gitlab/-/commit/3b67cd76913ddf43c0b48410a58ff581a425a255) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178554)) **GitLab Enterprise Edition**
- [Remove oauth2_device_grant_flow FF](https://gitlab.com/gitlab-org/gitlab/-/commit/090d9c7355a1bf61862de3694d4c2f37763464c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179941))
- [Add group-level pages access control setting](https://gitlab.com/gitlab-org/gitlab/-/commit/ac2862886d7a678a1f21da2e627934423b221edd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176757))
- [Add service class to trigger external control](https://gitlab.com/gitlab-org/gitlab/-/commit/abb0fe967bf6c3d289e890954c6f1fa6800e572b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180010)) **GitLab Enterprise Edition**
- [Remove async dependency export feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/d2031ca30cdba6259ff3d16d7f56f08f21510b0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180586)) **GitLab Enterprise Edition**
- [This commit adds support to delete Duo Chat threads through GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/2aa3b75f31561821bde25266c92a36d12a1e9d74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180286)) **GitLab Enterprise Edition**
- [Admin Token API: Identify Incoming Email Tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/b4191575ba438c80f7f3f0a764432a716ea0c100) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177077))
- [Add new sort option placeholders](https://gitlab.com/gitlab-org/gitlab/-/commit/eb347c4edb48578ceb3b69f1c795213a7bdc57a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180491))
- [Add clusters_managed_resources table](https://gitlab.com/gitlab-org/gitlab/-/commit/626d3c542ddc4a9c9917d427b424a9129d4b371a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177525))
- [Add support for unassigning user from an admin custom role in GraohQL](https://gitlab.com/gitlab-org/gitlab/-/commit/c54d6294d6b1358a456437a2e1c490c426ed12b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179975))
- [Remove the check_ip_address_for_email_verification FF](https://gitlab.com/gitlab-org/gitlab/-/commit/5da69994aaa49f17208fd4701ad6952ebc98da4a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180408))
- [Introduce CloudConnector::Keys model](https://gitlab.com/gitlab-org/gitlab/-/commit/ffe4c884044d57f4926a5debe4994507e1064498) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179559)) **GitLab Enterprise Edition**
- [Add parameter to toggle if email is sent on export completion](https://gitlab.com/gitlab-org/gitlab/-/commit/1142ccbb14db33ab82e1c1d4dff6291d004c46e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180065))
- [Add streaming to new audit event models](https://gitlab.com/gitlab-org/gitlab/-/commit/8adefcd95e0d123cbd80e84dee93b886f83493b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179746)) **GitLab Enterprise Edition**
- [Exempt specific files from Codeowners rules](https://gitlab.com/gitlab-org/gitlab/-/commit/80bf09e34d5098f3d7c2d3cbf21bb5203550952f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180162)) **GitLab Enterprise Edition**
- [Add popover support on milestone in WI Sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/a5f0988e8ee13108ecb743a4238dcdde39733d46) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179902))
- [Audit authorizing an OAuth application](https://gitlab.com/gitlab-org/gitlab/-/commit/d167cc1196a2e326da447f05ae0ff61d22071d8d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179187))
- [Allow read_admin_monitoring access to audit_logs](https://gitlab.com/gitlab-org/gitlab/-/commit/5643f57cdaf612d399a8d2ad15d417217ad268fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179894)) **GitLab Enterprise Edition**
- [Markdown: Select text and paste URL to create link](https://gitlab.com/gitlab-org/gitlab/-/commit/b4b4a68bbaf272c02861b80c9442b279868e49c8) by @ajuckel ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178942))
- [Prompt user to enter missing access token](https://gitlab.com/gitlab-org/gitlab/-/commit/aadc94754b88cfe47290093d948c296e90379fab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178471))
- [Adding correlation_id attribute to duo workflow message event api](https://gitlab.com/gitlab-org/gitlab/-/commit/8ab95fdce39a7cfb3d72a295c3e2a2413be56848) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179642)) **GitLab Enterprise Edition**
- [Feat(Blob): Add PlantUML render support for Blob Viewer](https://gitlab.com/gitlab-org/gitlab/-/commit/e7faf55c710462e5e8edfee38e59b591323f5a20) by @schurzi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179301))
- [Add ability to snooze to-dos until a custom time](https://gitlab.com/gitlab-org/gitlab/-/commit/547196b5992810f0dcfbcbdad83e28c7d45015fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178490))
- [Add queue_namespace as an attribute for Sidekiq routing rules](https://gitlab.com/gitlab-org/gitlab/-/commit/df657a65d9b0f6a69d851fb5074c2d4d44d2a858) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180136))
- [Enforce NOT NULL constraint on vulnerabilities.detected_at](https://gitlab.com/gitlab-org/gitlab/-/commit/6e83857ad3f0b32d6edf7b67baf7f157bd85284e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179644))
- [Admin Token API: Revoke Runner authentication token](https://gitlab.com/gitlab-org/gitlab/-/commit/af6882352654e8a3fb74680cc5e20ef830cb98e1) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179066))
- [Add indexes to web_hook_logs_daily](https://gitlab.com/gitlab-org/gitlab/-/commit/bc8f49c1002f35659dcccab9316af8a81e4eea5c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180155))
- [Add `read_admin_users` permission](https://gitlab.com/gitlab-org/gitlab/-/commit/f32d0556c5256aace13be5cf7c1bfd0bfaba9f76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177514)) **GitLab Enterprise Edition**
- [Introduce archival related entities](https://gitlab.com/gitlab-org/gitlab/-/commit/6112c120c21c17ad875a232aca7fe1314d2aec1f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179569))
- [Add a new 'Index version' to the elastic info rake task](https://gitlab.com/gitlab-org/gitlab/-/commit/4be6369d9033d165bff2648abd095e922b60a26f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179446/)) **GitLab Enterprise Edition**
- [Add license check to the fields allowedParentTypes and allowedChildTypes](https://gitlab.com/gitlab-org/gitlab/-/commit/7dfb4bdd52ea82069281a1b8f1ec6d99dd8fd0e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178863)) **GitLab Enterprise Edition**
- [Resolve MR issue with new work item](https://gitlab.com/gitlab-org/gitlab/-/commit/be4f7cb7df5fcd78b6fa636f2950ad118d39c3e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176703))
- [ActiveContext OpenSearch indexer](https://gitlab.com/gitlab-org/gitlab/-/commit/1f2fb3f07effb2a08ff178ed5b01238c9ef56eba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179662)) **GitLab Enterprise Edition**
- [Extend dashboard date range filter configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/f9bdf7f45ce982644a4e3bb822f8045bdba3937c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178999)) **GitLab Enterprise Edition**
- [Remove microsoft_azure_group_sync FF](https://gitlab.com/gitlab-org/gitlab/-/commit/48921fc8f38a8d3da5aeff0442bb950beeac4c2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179942))
- [Add `project_design_management_routes_view` database view](https://gitlab.com/gitlab-org/gitlab/-/commit/6c52398635b7ae345bc7ffdd6a16ba388597db9a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179449))
- [Add `project_routes_view` database view](https://gitlab.com/gitlab-org/gitlab/-/commit/dbb6013c0a22018fbda0adbd08f161bee01f25fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179443))
- [Add “Added from log” icon in job token allowlist UI](https://gitlab.com/gitlab-org/gitlab/-/commit/024a9f1f3e9b7558f011cdafbc55677a395d3400) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177785))
- [Add ActiveContext reference class](https://gitlab.com/gitlab-org/gitlab/-/commit/b18c45d566f9f9dc47299da9b6df071eef3394e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179362)) **GitLab Enterprise Edition**
- [Introduce a NamespaceSettingsUpdate mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/39eb31f777242fd317a60cb1a476a17930b16c33) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178328))
- [Enable ability to view IP addresses in access tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/c702d20887db4e8050af35dfeb59d07897cf8079) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179747))
- [Create work_item_user_preferences table](https://gitlab.com/gitlab-org/gitlab/-/commit/5eeed2127c1ed09460bb1ec344bf671bdd396017) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176869))
- [GraphQL: Populate `timeSeries.count` field in AnalyticsType](https://gitlab.com/gitlab-org/gitlab/-/commit/c76b632d494f9bd5cf8a07493705428be1129e1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179378))
- [Prevent unnecessary processing of AutoDevops with overriding PEP](https://gitlab.com/gitlab-org/gitlab/-/commit/3484e63a7a201a1e19dba5b3755bc303a3562dab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178581))
- [Allow SSH keys to be filtered by created at and expires at](https://gitlab.com/gitlab-org/gitlab/-/commit/8f13ba6e5e73e282ee7a04e34a4587c048d18ce0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177010))
- [Added severity override support in MR security widget](https://gitlab.com/gitlab-org/gitlab/-/commit/fc9784b8d0757ecc7727f886cd7bcf85ac6c92ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178862)) **GitLab Enterprise Edition**
- [Admin Token API: Identify GitLab sessions](https://gitlab.com/gitlab-org/gitlab/-/commit/e48740b4c37ff005f4d4838ea093517521ed6987) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178022))
- [Add Security Risk Management feature categories](https://gitlab.com/gitlab-org/gitlab/-/commit/4375b0f45d403676e4ad9687338e099fd8c12546) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179556))
- [Add external_url to compliance_requirements_control](https://gitlab.com/gitlab-org/gitlab/-/commit/ce08f6d06ef52b16bc94317f4996bdfd9ae9c4e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179256)) **GitLab Enterprise Edition**
- [Admin Token API: Add support for revocation of Cluster Agent Tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/5d772a541ab4ab2d8122e7d6174a17b3e7b692f4) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178211))
- [GraphQL: Add `timeSeries.durationStatistics` field to AnalyticsType](https://gitlab.com/gitlab-org/gitlab/-/commit/30a55af07876d9673e104d3710174f348da07972) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179006))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/c6ade453311f2cdf21092351d029fdc8f0831d38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179675))
- [Add Amazon Q role arn validation](https://gitlab.com/gitlab-org/gitlab/-/commit/e1289305102f93fe8e5567feed0a11755e70b448) by @protsivd ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176883))
- [Add read_admin_monitoring permission](https://gitlab.com/gitlab-org/gitlab/-/commit/9389c1b393661845a9aca3a0e5cc445ff83114a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179439)) **GitLab Enterprise Edition**
- [Add security findings severity override mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/6692d998f1ea68ead25ba0b3322ce7141bae3393) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178167)) **GitLab Enterprise Edition**
- [Add anti_abuse_settings column to application_settings table](https://gitlab.com/gitlab-org/gitlab/-/commit/e517c5475d7cd069757a09a22a25e8c8d0f1d905) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179596))
- [Prioritize vulnerability severity when resolving security findings](https://gitlab.com/gitlab-org/gitlab/-/commit/d4ea75f6b0576e591e54b73920515b46cf03b9c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179566)) **GitLab Enterprise Edition**
- [Backfill web_hook_logs_daily](https://gitlab.com/gitlab-org/gitlab/-/commit/26afa6c7fd59c118cfdb40fb1fa448203e8dda9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176714))
- [Enable Vulnerability Change Status modal by default](https://gitlab.com/gitlab-org/gitlab/-/commit/147651617959d746884a92d0938deb7a719626b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179346)) **GitLab Enterprise Edition**
- [Add more details for zoekt performance bar in multimatch](https://gitlab.com/gitlab-org/gitlab/-/commit/5fff92091005feabadff9f70fcd2826775de88ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178585)) **GitLab Enterprise Edition**
- [Release SAML Groups Duo Add On Assignment](https://gitlab.com/gitlab-org/gitlab/-/commit/b607682fe6cedf2b13f274c00fc83be8118ad7fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179575)) **GitLab Enterprise Edition**
- [ActiveContext indexer for elasticsearch](https://gitlab.com/gitlab-org/gitlab/-/commit/687828665b8b9ca9dd41f061f12467b499c00504) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178705)) **GitLab Enterprise Edition**
- [Add AI impact visualizations to the analytics dashboard designer](https://gitlab.com/gitlab-org/gitlab/-/commit/e20557c5803c7430e68d6f20684c1edfca964269) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179406)) **GitLab Enterprise Edition**
- [Add GraphQL fields for pipeline creation status](https://gitlab.com/gitlab-org/gitlab/-/commit/a0a443daa6f7aecd0c328fcaa2d9a8232a5b8557) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178558))
- [Allow to configure LFS link batch size via environment variable](https://gitlab.com/gitlab-org/gitlab/-/commit/1f94146a5dc045bd26abd8dd6e8384c8f61b4be7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179401))
- [Crud HAML component: Adds collapsible feature](https://gitlab.com/gitlab-org/gitlab/-/commit/cdc2fe0808f2690a8f52a44cd51bdaf37d5997fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178917))
- [Adding GraphQL mutations to trigger Allowlist Autopopulation processes](https://gitlab.com/gitlab-org/gitlab/-/commit/d85923693b43f15f3808e6bc72d2c44a5bfb1c84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177465))
- [Added update mutation for compliance requirement controls](https://gitlab.com/gitlab-org/gitlab/-/commit/0671b32c256d2a9c67b988e0f500a5ef8f307725) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178290)) **GitLab Enterprise Edition**
- [Block Seat Overage for SM](https://gitlab.com/gitlab-org/gitlab/-/commit/a3b64dcfa0002f10bffb5413a6ac43c6112cb2ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176655)) **GitLab Enterprise Edition**
- [Introduce endpoint to discover cert-based clusters](https://gitlab.com/gitlab-org/gitlab/-/commit/47309f441d5076ace208273fa1b5404afebc13fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178883))
- [Add clusters_managed_resources table](https://gitlab.com/gitlab-org/gitlab/-/commit/f2a0aa14f2d4388fb0a531ce45f03b6760324424) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178118))
- [Remove composite identity FF](https://gitlab.com/gitlab-org/gitlab/-/commit/3939f6cfbe12ea64c10f297cdab3b563e3da3a00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176977))
- [Admin Token API: Identify Feature Flags client token](https://gitlab.com/gitlab-org/gitlab/-/commit/8c52f104a381be850c7ecda66f540a8f98402854) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177431))
- [Add `raw_diff` endpoint to merge request API](https://gitlab.com/gitlab-org/gitlab/-/commit/0b917ddeab3856f35724b86110e50f99df1ce349) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178813))
- [Adds not-null migration for ComplianceViolation on target_project](https://gitlab.com/gitlab-org/gitlab/-/commit/b2d8389e9872fa4ed24a8464ff3a5e3272abef4e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173748)) **GitLab Enterprise Edition**
- [Add diff_lines endpoint to blobs controller](https://gitlab.com/gitlab-org/gitlab/-/commit/5c3299904e75137a37b48e00c8d2012b57137bb3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176274))
- [Throw error when incorrect scope is used in auditor](https://gitlab.com/gitlab-org/gitlab/-/commit/102678b9703be032c11bf8470b9eb57ec5639b2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178412)) **GitLab Enterprise Edition**
- [Add self_rotate scope for access token self rotate endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/e81424a4075c4f577bf6a18636abacb9c7be6c86) by @ajuckel ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178111))
- [Backfill archived and traversal_ids for vulnerability_statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/35210641f9eb708eb3b20828c927ae6ff9dd58ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177993))
- [Add manage protected tags custom permission](https://gitlab.com/gitlab-org/gitlab/-/commit/1bf44697e2df4796f6d6a9fe6b6e082002f2d4ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178059)) **GitLab Enterprise Edition**
- [ActiveContext processes refs from queues via cron worker](https://gitlab.com/gitlab-org/gitlab/-/commit/54a834f35fc46e2ece7688c0d5dacfdd7444cb4f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177732)) **GitLab Enterprise Edition**
- [Add cloud_connector_keys ApplicationSetting](https://gitlab.com/gitlab-org/gitlab/-/commit/ccd0fee30852d2495d8e5cf2ad6aac986811e842) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178857)) **GitLab Enterprise Edition**
- [Create AiUserMetrics table and model](https://gitlab.com/gitlab-org/gitlab/-/commit/d3085c206f130f3582eaa6b0520e1202a78a2a41) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178559)) **GitLab Enterprise Edition**
- [Expose linkType in field linkedWorkItems](https://gitlab.com/gitlab-org/gitlab/-/commit/663126084427a6eca2f869b295804c71ba95d1f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178569))
- [Use security_findings for security mr widget](https://gitlab.com/gitlab-org/gitlab/-/commit/861dcf7cda90c12b9e4c0a7fd53104b58247e8b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173949)) **GitLab Enterprise Edition**
- [Add protection rules to TagType](https://gitlab.com/gitlab-org/gitlab/-/commit/9b3842c5720bc748a767f64aeb9c651d2834cad4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177039))
- [Schedule web_hook_logs_daily indexes](https://gitlab.com/gitlab-org/gitlab/-/commit/ea98672ae62e65d55eaba035408ea17c726b69d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178413))
- [Add skip ci configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/1289cda2687208d5df9b56a6e28206986525b312) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178496)) **GitLab Enterprise Edition**
- [Changes to support group level report for severities count api](https://gitlab.com/gitlab-org/gitlab/-/commit/ea010ca8e2a39717ae846b1fc793194ecd6de314) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175913)) **GitLab Enterprise Edition**
- [Support expires_at param for group service account PAT rotation API](https://gitlab.com/gitlab-org/gitlab/-/commit/da24662ab3d9c45cadea88e9662652030bcbc2a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178608))
- [Add skip ci configuration to a policy drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/e992c73c7cb6d191d708b84f8edfb006dcfff4c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178497)) **GitLab Enterprise Edition**
- [Add instance setting to restrict private user profiles](https://gitlab.com/gitlab-org/gitlab/-/commit/1e554fccecaab8043e7917f4e3d655cda3979c11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178683)) **GitLab Enterprise Edition**
- [Add migration to enable read_compliance_dashboard in member roles](https://gitlab.com/gitlab-org/gitlab/-/commit/5b786f31332cc5eb9d78d578b3467a5596576ae0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176834))
- [Improve throttling during user record reassignment](https://gitlab.com/gitlab-org/gitlab/-/commit/e19d519b4aac0d2ed8b9b3a93a4fb6e75784d605) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175961))
- [List threads GraphQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/d6554b7ff2fdaac663b5170ca31ea1dcbf7c2d6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178268)) **GitLab Enterprise Edition**
- [Add Duo Chat usage rate to AI analytics dashboard metric table](https://gitlab.com/gitlab-org/gitlab/-/commit/b1f04b75f2e22a86b0dec9e06941767378490ad5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178622)) **GitLab Enterprise Edition**
- [Add worker architecture for scheduled PEP](https://gitlab.com/gitlab-org/gitlab/-/commit/90273ea98412565ec0976272596db620d996084e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175246))
- [Fix documentation for confidential incidents visibility](https://gitlab.com/gitlab-org/gitlab/-/commit/8cb53be2a5e4b439ed9ecd1ad0bb889d6c96c84e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178600))
- [Introduce codeSuggestionsContexts for CurrentUser](https://gitlab.com/gitlab-org/gitlab/-/commit/ea41fdb1c536f1c7cce1c4963b9f06370912732e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178402)) **GitLab Enterprise Edition**
- [GraphQL: add TagDelete mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/2595da6b07f1c560572bb51b9d9d76dee4f641ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176000))
- [Remove the `todos_snoozing` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/61007f1f42a7d22b987f8c6e771166023c5aba20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178205))
- [Use helper to update stream destinations from legacy API](https://gitlab.com/gitlab-org/gitlab/-/commit/846db30be279ba234c677fa6686ff8e5b07476f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177927)) **GitLab Enterprise Edition**
- [Expose cvss v3 in vulnerability details page](https://gitlab.com/gitlab-org/gitlab/-/commit/905b8c7ccc7e9c56fe4e06dad963a88864302171) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177071)) **GitLab Enterprise Edition**
- [Add "PATCH /groups/:id/enterprise_users/:user_id/disable_two_factor" API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/0eae379570a111e73967345bb7439c090ae7257c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177943)) **GitLab Enterprise Edition**
- [Support thread id in AiAction GraphQL mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/faafe1390e5f6dcea51394e4be8964e463a9293e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177053)) **GitLab Enterprise Edition**
- [Define sharding key for events](https://gitlab.com/gitlab-org/gitlab/-/commit/9ebccbfd61f9effd683eba842c981ad3c9611a80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177810))
- [Delete paired audit event destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/24bcc1c111e1abb2d89eb39098899f83a7933068) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175018)) **GitLab Enterprise Edition**
- [Add project topics to CI/CD Catalog](https://gitlab.com/gitlab-org/gitlab/-/commit/31a74b76e32e349600866ff681b3d90941383d1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177522))
- [Add Ci/CD job token policies static analysis](https://gitlab.com/gitlab-org/gitlab/-/commit/1b79cc3e031b305423b91344894da94e4ce2ad92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174474))
- [Adding mutation for creating compliance controls](https://gitlab.com/gitlab-org/gitlab/-/commit/039b1a25458fbff2c8047807291c8d8135946d4e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177557)) **GitLab Enterprise Edition**
- [Add AiDuoChatEvent model](https://gitlab.com/gitlab-org/gitlab/-/commit/f258d566bc8bfb576219cb8000c4edff7ca726c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177239)) **GitLab Enterprise Edition**
- [Defined event and metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/238fa7990ad7ff0d8f2f4bd694b0b1ed384c3abe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177663)) **GitLab Enterprise Edition**
- [Add last_approved_at event to VSA](https://gitlab.com/gitlab-org/gitlab/-/commit/5becf3114cfe34f9b83180ce9ded32cc62070d96) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175989))
- [Surface user.type to frontend](https://gitlab.com/gitlab-org/gitlab/-/commit/9e6ffe21b5e28a48bb9c99bf310a9104b38df744) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173343))
- [Improve UX of registering a GitLab agent](https://gitlab.com/gitlab-org/gitlab/-/commit/1944090910bdeb979966da792baccf6701de593e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177777))
- [Release DAST UI additional varibles feature](https://gitlab.com/gitlab-org/gitlab/-/commit/b88727b6f9fef1d7a883ba3cfadb3dc85bd13ddf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177703)) **GitLab Enterprise Edition**
- [Introduce write_virtual_registry scope](https://gitlab.com/gitlab-org/gitlab/-/commit/a9c6ad66a75f71de1541e0c4beabb4c03aeff770) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174496))
- [Add metrics for sep scheduled scans using time_window](https://gitlab.com/gitlab-org/gitlab/-/commit/ad6cb54f4ace2d66ccc7cf948e860e212d21a348) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176472)) **GitLab Enterprise Edition**
- [Add ability to add related item for work items](https://gitlab.com/gitlab-org/gitlab/-/commit/9393fb5dd0acc0c39a21417d1de6b6711e6edc79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178025))
- [Let ActiveContext add references to a queue](https://gitlab.com/gitlab-org/gitlab/-/commit/96a2f68a81d96b8957b9c8186a30f31d7ed086c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177232)) **GitLab Enterprise Edition**
- [Update vulnerability_statistic.archived when project is archived](https://gitlab.com/gitlab-org/gitlab/-/commit/ca3a10992082fe478f88e05450bf1625fbf5f4ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177990)) **GitLab Enterprise Edition**
- [Prepare not-null for ci_pipeline_messages.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/316cb408d16671ba65a06827fcb0156475471693) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173952))
- [Implement filtered search UI for credentials](https://gitlab.com/gitlab-org/gitlab/-/commit/6174fc9c2a5d7f6a5122bfd36f9ca14c6ba493ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176677))
- [Add Code Suggestions acceptance rate to AI usage metrics table](https://gitlab.com/gitlab-org/gitlab/-/commit/9e100fad76e1225ec1bc39c044d6824b8907131e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178063)) **GitLab Enterprise Edition**
- [Persist licenses column to support component filtering](https://gitlab.com/gitlab-org/gitlab/-/commit/cfff99a93f516acf8b31273689135e0a7ad6ff2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177297)) **GitLab Enterprise Edition**
- [Add feature flag for anthropic prompt caching](https://gitlab.com/gitlab-org/gitlab/-/commit/0b8a752d16de2d3c6e2fcd4367a734fe89f568d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177642)) **GitLab Enterprise Edition**
- [Update Report class to return new dependencies for licenses](https://gitlab.com/gitlab-org/gitlab/-/commit/c09fcb8a4b4a422ad9338472385110168b4dcfd0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177499)) **GitLab Enterprise Edition**
- [Admin Token API: Identify CI/CD Job Tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/a08cb8061ca3c0090e8c0a897203418f36c74e44) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175234))
- [Extend selective sync scope to the primary checksumming](https://gitlab.com/gitlab-org/gitlab/-/commit/f4077e068bf62a2a3056788c461dcfdf56285836) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174453)) **GitLab Enterprise Edition**
- [Add uri validation for licenses purl](https://gitlab.com/gitlab-org/gitlab/-/commit/51af1ab294bfb1e62072544a39d63afc70db0fd3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178048)) **GitLab Enterprise Edition**
- [Add `expires_at` column to `vulnerability_exports`](https://gitlab.com/gitlab-org/gitlab/-/commit/22470dafc1a3f1a648df9af09de3aa35f929b1cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178043))
- [Add `expires_at` column to `dependency_list_exports`](https://gitlab.com/gitlab-org/gitlab/-/commit/315d101e1d08e8b5fe2b36c79acfef308c7be636) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178042))
- [Add elastic client to active context gem](https://gitlab.com/gitlab-org/gitlab/-/commit/3eb2ecf09c2ada617a05ce7579188419da1eec67) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177093)) **GitLab Enterprise Edition**
- [GitLab storybook add missing features](https://gitlab.com/gitlab-org/gitlab/-/commit/8a53c4c86895574fa692f5e57b8840d26a640896) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178028))
- [Allow gem to register queues](https://gitlab.com/gitlab-org/gitlab/-/commit/45f08dd9d0231325d4b50c3cfe61c18208197669) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177086)) **GitLab Enterprise Edition**
- [Allow users to configure skip_ci behavior for scan execution policy](https://gitlab.com/gitlab-org/gitlab/-/commit/e55cd2e211a21c660485b2aa38fed932a5dcf4cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174975)) **GitLab Enterprise Edition**
- [Add "GET /groups/:id/enterprise_users/:user_id" API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/1bbd02c210c485836f06fac618308a71acc2ac50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176328)) **GitLab Enterprise Edition**
- [Remove Epics scope and replace it with work_item type epic](https://gitlab.com/gitlab-org/gitlab/-/commit/5923033037a48aec0e943a0e294e100eee0dea99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173915)) **GitLab Enterprise Edition**
- [Add vulnerability_severity_overrides table](https://gitlab.com/gitlab-org/gitlab/-/commit/6052e201a22a5a7703646627858bb407fc743bec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176952)) **GitLab Enterprise Edition**
- [Defined event and metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/03ddd6f4ad8778ed213eacbc018f9a3381fff6d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177315)) **GitLab Enterprise Edition**
- [Add traversal_ids to vulnerability_statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/5cf9d0e45242f7a015265f8542ab635c6484ca3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177591))
- [Add helper method to update legacy destination from stream destination](https://gitlab.com/gitlab-org/gitlab/-/commit/59a1c4f98b633c9a7f426e430082245ba27e1d6b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175892)) **GitLab Enterprise Edition**
- [Model Registry: Add ability to get Model Version by alias](https://gitlab.com/gitlab-org/gitlab/-/commit/89fc8baebe17ce2fb325be73e9646b9e81149d92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177715))
- [Fetch latest pipeline if no arguments are passed](https://gitlab.com/gitlab-org/gitlab/-/commit/f21c98cced9cd1d77ed613c8a83d300dfe0fc683) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172934))
- [Add /create_merge_request quickaction to work items](https://gitlab.com/gitlab-org/gitlab/-/commit/b6689979b26b6efb6ac0fa0eb6f3ea797307618e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177815))
- [Add reports identification](https://gitlab.com/gitlab-org/gitlab/-/commit/34ecaf8c1589b9555e03944c6e62ff2400d9db0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177764))
- [Run dependency scanning on uv.lock detection](https://gitlab.com/gitlab-org/gitlab/-/commit/56c2f10a0260df218c634e89a6f17370a5593529) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177637))
- [Release group credentials inventory feature](https://gitlab.com/gitlab-org/gitlab/-/commit/02765aaa84fce62deebbc78d95a43264fd596de1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177286))

### Fixed (242 changes)

- [Hide Edit button for work item metadata for Guest users](https://gitlab.com/gitlab-org/gitlab/-/commit/60a70a940b66ec9319b54b9e75ab81284008958e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180418))
- [Update net-imap gem](https://gitlab.com/gitlab-org/gitlab/-/commit/83853b3ce0f5a00859fd778ea8341b20e87c026b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181666))
- [Fix runner owner if necessary when runner assigned to a project](https://gitlab.com/gitlab-org/gitlab/-/commit/30df5eb287573c54549791d3194aebabf1759ba7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180417))
- [Fix vulnerability severify badge rendering](https://gitlab.com/gitlab-org/gitlab/-/commit/82f9dc41e51dbae899fb273fc85c7a8383ecdd3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181422)) **GitLab Enterprise Edition**
- [Fix incident layout when new issue look is turned on](https://gitlab.com/gitlab-org/gitlab/-/commit/6915eb6aa3713f3836b7121e2f2b74bddba90b47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181432))
- [Fix returning cached severity value after severity override](https://gitlab.com/gitlab-org/gitlab/-/commit/b009659d565b632cf6ab2bf297c5811ee7d6f368) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181078)) **GitLab Enterprise Edition**
- [Backfill default pages deployment limit](https://gitlab.com/gitlab-org/gitlab/-/commit/85c514c45b3f4e32349b3bdbb8579fc1a8f523ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180735))
- [Upgrade net-http-persistent gem to 4.0.2 to fix connection pool issues](https://gitlab.com/gitlab-org/gitlab/-/commit/bcd1e19c7a06956786723ddaac1a9dab7b0ab289) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181361))
- [Fix: Removing all domains does not reset primary domain](https://gitlab.com/gitlab-org/gitlab/-/commit/3ef229df51784a61d573255af21f9512bb4c99cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181150))
- [Add default value to plan deployment limits](https://gitlab.com/gitlab-org/gitlab/-/commit/249053e17e69b7fec91243a1e0c9476260a9beca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180538))
- [Render files based on the correct file sizes](https://gitlab.com/gitlab-org/gitlab/-/commit/17ed419dbb845db15b3f79034f8b625487220b01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180718))
- [Fix incorrect branch access check](https://gitlab.com/gitlab-org/gitlab/-/commit/82cf739d24cc489de8cc7d6d4b2e5a9ba468ea3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180225))
- [Fixed UX flow when when author filter dropdown opens](https://gitlab.com/gitlab-org/gitlab/-/commit/201f0d52e0237da2fb91b5b36ce745d662ce74e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180389))
- [Update getBlobSearchCountQuery variables](https://gitlab.com/gitlab-org/gitlab/-/commit/a685e3d0f90331c7490a6adc3ee2780a4206de0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181256)) **GitLab Enterprise Edition**
- [It is not necessary to set FK when moving issue under new parent](https://gitlab.com/gitlab-org/gitlab/-/commit/37dc9bb9b44ac780ac8b116ca2a75eec1c090748) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181244)) **GitLab Enterprise Edition**
- [Enforce SEP jobs when `pipeline_source` is a string](https://gitlab.com/gitlab-org/gitlab/-/commit/f1ff087c8ab29687a3bd454f1c5c417c2993901e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180977)) **GitLab Enterprise Edition**
- [Fix Ci::RunnerTagging sharding_key_id validation](https://gitlab.com/gitlab-org/gitlab/-/commit/7a1d48ed2ce01859821402ba06bb2c2927b6ea63) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181228))
- [Fix overflow issues on snippets page](https://gitlab.com/gitlab-org/gitlab/-/commit/3114caf280b0293acd3523926bb2dd3118571075) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181212))
- [Fix work item issues webhook event type and object kind](https://gitlab.com/gitlab-org/gitlab/-/commit/abebbb2372b6f2bdcea8cb339a1fb395ec65df8d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180959))
- [Add custom role preloader to projects resolver](https://gitlab.com/gitlab-org/gitlab/-/commit/c23b7647331216fd96fe93821627635f18f55cfe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179471)) **GitLab Enterprise Edition**
- [Fix CRM issue filters when contacts not sourced from root group](https://gitlab.com/gitlab-org/gitlab/-/commit/38e9186565f1ab07060fcf888256ac33b836679a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180290))
- [Add content_disposition to export downloads](https://gitlab.com/gitlab-org/gitlab/-/commit/efa9e8afe4b455acb16d5a57d86f451fe58f95e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181187)) **GitLab Enterprise Edition**
- [Strip trailing newline from rendered Kroki and PlantUML diagram source](https://gitlab.com/gitlab-org/gitlab/-/commit/23358b316db540b78c984112035fd34b163b68c8) by @puxlit ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180830))
- [Width correction](https://gitlab.com/gitlab-org/gitlab/-/commit/aa243cffc71fc0ab75087efa92cdce54d10a5152) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181140))
- [Remove `repo` if agent project is null](https://gitlab.com/gitlab-org/gitlab/-/commit/c666f122017f0f59b6862235ea3b2ff8f5307537) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181138))
- [Change Security Finding to reference project from scan](https://gitlab.com/gitlab-org/gitlab/-/commit/f5a5c721dd9472dc1ecc30bcbd6f41f7ff69e674) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180246)) **GitLab Enterprise Edition**
- [Fix overlap with description](https://gitlab.com/gitlab-org/gitlab/-/commit/164d7bdc2b259948e92eab397e4e28c7348d48fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181127))
- [Ensure issues has fixed dates](https://gitlab.com/gitlab-org/gitlab/-/commit/4d846bb333c5a45dc2d66545da4f95403af3248d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179882))
- [Make `any_merge_request` rules respect `branch_exceptions`](https://gitlab.com/gitlab-org/gitlab/-/commit/c78165cd5eccfb06346e869b811a18c8331907a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181121)) **GitLab Enterprise Edition**
- [Fix member guidelines resulting in overflow in group member view](https://gitlab.com/gitlab-org/gitlab/-/commit/e78c5e5dd1dd12ded84b1b46c0c85a27f8e28ff0) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181077))
- [Increase query limiting threshold](https://gitlab.com/gitlab-org/gitlab/-/commit/5ec65d649d8228bd363a3b1ef437ee5aff24d304) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181050))
- [Update stop environment API to use different policy](https://gitlab.com/gitlab-org/gitlab/-/commit/e06dfd496bb2fc113bf47ab2d31dadc50b134e4a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181042))
- [Clean up remote_mirror_retry_with_delay feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f95ad0f4fcbcb5997dd30135db1cb4a5c58ef0bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181016))
- [Fix linking of policy to the project](https://gitlab.com/gitlab-org/gitlab/-/commit/9f1b4be90a16318abd5afeff65494071c919baec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180615)) **GitLab Enterprise Edition**
- [Zoekt cache should invalidate if multi match chunk size changes](https://gitlab.com/gitlab-org/gitlab/-/commit/1ab722b63d5ccf3e969cdf1ff71a06d66fd35682) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180603)) **GitLab Enterprise Edition**
- [Fix broken vulnerability management save functionality](https://gitlab.com/gitlab-org/gitlab/-/commit/44c8f86c99914ad2fdc3a6f0b62bb05aceec95b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180979)) **GitLab Enterprise Edition**
- [Determine file id from hash](https://gitlab.com/gitlab-org/gitlab/-/commit/5869bcc04ab2e34fe4c62b6154998822933a749d) by @crenz ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179483))
- [Nav eval > Enable filters button](https://gitlab.com/gitlab-org/gitlab/-/commit/81fba6b66963d120752d3b7ee4a6725e4573ed54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180808))
- [Handle invalid repository names gracefully](https://gitlab.com/gitlab-org/gitlab/-/commit/1a05d7d47f51c6a4484ca461bad8ffb3b5109f07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180140))
- [Add group-level validation for audit events feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/cb09b1c52c96e1f9d84c24a69adbe739ded2a299) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180245)) **GitLab Enterprise Edition**
- [Dismiss alert upon toggling labels in Tasks by type chart in VSA](https://gitlab.com/gitlab-org/gitlab/-/commit/9bc1b0be53bbf1da81a0f0e709edccf0984d4b85) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180790)) **GitLab Enterprise Edition**
- [Support merge request variables in pipeline execution policies](https://gitlab.com/gitlab-org/gitlab/-/commit/7f717a84ab5162a36284ddfdc3ed1c61c565df16) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180945)) **GitLab Enterprise Edition**
- [Fix link rendering in GitHub integration](https://gitlab.com/gitlab-org/gitlab/-/commit/ec86a5937e20304eeb8efef5e0ba71f416970df2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180833)) **GitLab Enterprise Edition**
- [Fix AddOnPurchase API override trial attribute bug when deprovision](https://gitlab.com/gitlab-org/gitlab/-/commit/036af5fd756acba8a5c6ff3680f2ba5a88572210) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179989)) **GitLab Enterprise Edition**
- [Prevent Direct Transfer from re-enqueueing timed-out pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/d8d2eb0d6b9c4de34aa0501c7b115f3f16cdccde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179097))
- [Fix getExperiments Graphql Query](https://gitlab.com/gitlab-org/gitlab/-/commit/354973fc34402c2e40a61143c7cb78b9b7beb4d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180786))
- [Use common insertText in dropzone_input to preserve browser undo](https://gitlab.com/gitlab-org/gitlab/-/commit/232c934fff752dcfccc6af13d537da1512d65d08) by @Bubbis ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180255))
- [Fix: add name prop to instances of devops_adoption_table_cell_flag.vue](https://gitlab.com/gitlab-org/gitlab/-/commit/4c76cbaad6fbb013e5b21267d3cf5f05169a6ce7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180781))
- [Do not list pending migrations if search service unreachable](https://gitlab.com/gitlab-org/gitlab/-/commit/e2db31e58bcd175d11b9770a64b95cf2be908054) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179782)) **GitLab Enterprise Edition**
- [Do not allow assigning non-admin custom roles directly to users](https://gitlab.com/gitlab-org/gitlab/-/commit/1e2a91d337438c87e0634a49f18db284cb620a70) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180036))
- [Display download message conditionally](https://gitlab.com/gitlab-org/gitlab/-/commit/70073f093ae8b3a9b0c229c79500c4820075fb1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179872))
- [Fix issue work item spacing issue related to gutter classes](https://gitlab.com/gitlab-org/gitlab/-/commit/84315fa4292c4d2d0dc9b7e09e926d1976c447e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180444))
- [Update policy for stop environment REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/4d360debd97526343e9b73231f51475a1735878b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179955))
- [Fix console error during filter search](https://gitlab.com/gitlab-org/gitlab/-/commit/3e3871cf0c3939b40f30af010fc865c8f382edcc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180715)) **GitLab Enterprise Edition**
- [Fix remote response broadcast messages with target path](https://gitlab.com/gitlab-org/gitlab/-/commit/2a68bbbd72ca5a9b2e8d921da7d005116d43985c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180730))
- [Ensure correct header is present for work item detail](https://gitlab.com/gitlab-org/gitlab/-/commit/f43ddf9fe14017676c9561bd9f2d642844de4328) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179595))
- [Fix bug of missing groups in JobTokenAllowlist](https://gitlab.com/gitlab-org/gitlab/-/commit/77083af5168dbf0b9ccbee1cb2c3fe74270b7b3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180174))
- [Display the correct Direct Connections value in Duo admin page](https://gitlab.com/gitlab-org/gitlab/-/commit/c961b96c366156112dd94bfae75d5cd935a256ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180653)) **GitLab Enterprise Edition**
- [Add conditional operation for system note](https://gitlab.com/gitlab-org/gitlab/-/commit/bdbd6cd3ddb56e3891e928dbca5c459beb548533) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180652))
- [Exclude file upload trigger from closing drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/8df532e9399c7dfe16077bcd2da9f1bb02c8f343) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180614))
- [Send additional params to getBlobSearchCountQuery](https://gitlab.com/gitlab-org/gitlab/-/commit/77848b97386313e38c729856a98b44ec0396a2dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180584)) **GitLab Enterprise Edition**
- [Ignore database policies check for enforcing SEP](https://gitlab.com/gitlab-org/gitlab/-/commit/376afd4a9d416daf1e943ef3425f4fc0aeb61d3e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180572)) **GitLab Enterprise Edition**
- [Fix scrolling to clipped file browser items](https://gitlab.com/gitlab-org/gitlab/-/commit/b14e81b24cc5e08d75c017154f26afd475926f66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180501))
- [Fix dependency proxy with some object storage providers](https://gitlab.com/gitlab-org/gitlab/-/commit/722885885103561fc3f9ed21669cc3a8e1e4234c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180493))
- [Fix button name](https://gitlab.com/gitlab-org/gitlab/-/commit/f2f65baa33d80d2600e9810f20f53fa030c8e4d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180505))
- [Return false for pending_migrations? if indexing disabled](https://gitlab.com/gitlab-org/gitlab/-/commit/9f835ae08d0fe1b129ded874cb01d36468eb3676) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179873)) **GitLab Enterprise Edition**
- [Add aria-label to delete project modal](https://gitlab.com/gitlab-org/gitlab/-/commit/67a23dae4796fd0c0ef979becd946f05c43f221b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179904))
- [Capture enter & tab in related MR field](https://gitlab.com/gitlab-org/gitlab/-/commit/52462f83600ba15ad97682e9acf81421fc6ffef2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180069)) **GitLab Enterprise Edition**
- [Update topics path for badges](https://gitlab.com/gitlab-org/gitlab/-/commit/79df35daa739ed798bb28f65ebf0be5a25d6b5d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180439))
- [Add gitRef support for workspaces](https://gitlab.com/gitlab-org/gitlab/-/commit/b5aef619477f050e05e8a31bf7b64ee61a457f25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177680)) **GitLab Enterprise Edition**
- [Fix compare branches from the fork](https://gitlab.com/gitlab-org/gitlab/-/commit/725438556bfc2b93a119cdcc0ff31ecd391aeeb9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180377))
- [Add ids to a policy actions and rules](https://gitlab.com/gitlab-org/gitlab/-/commit/531d3772c95ebeb44fc1eab91e7cf3bd5559182b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180045)) **GitLab Enterprise Edition**
- [Persist payload attributes of code suggestion events](https://gitlab.com/gitlab-org/gitlab/-/commit/25ee8f327d081add325bd6ebe7a5022f956aa5ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179285)) **GitLab Enterprise Edition**
- [Fixes Restricted access  gitlab.com bugs](https://gitlab.com/gitlab-org/gitlab/-/commit/86a1ef6d14c2135c6ac5dcc39f6087eb9f5bacb7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180167)) **GitLab Enterprise Edition**
- [Improve error-handling when editing blobs](https://gitlab.com/gitlab-org/gitlab/-/commit/999e6f87acf97d6567285d765f3a100ed767883b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178994))
- [Fix epic creation when instance templates are set](https://gitlab.com/gitlab-org/gitlab/-/commit/51a9d63250077c5f189d8b4e904c5a6134aa1b9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179354)) **GitLab Enterprise Edition**
- [Fix Duo Chat getting slower by message increase](https://gitlab.com/gitlab-org/gitlab/-/commit/bce50800a52720cc322d08e896854813864d5e1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180157)) **GitLab Enterprise Edition**
- [Fix QueryCanceled error in PersistSecurityPoliciesWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/5848e6683ea05beb02d8da791722d7859132432b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179600)) **GitLab Enterprise Edition**
- [Fix SecurityPolicyDefault to work with mr pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/14b774ef3fc2606ed600362c128d7936a77f8c45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179614)) **GitLab Enterprise Edition**
- [Add aria-label to single file editor search input for accessible name](https://gitlab.com/gitlab-org/gitlab/-/commit/d502021f90d1cfedcd349c26aec527c1df240754) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179953))
- [Add comment to cache when submitting a comment on a work item](https://gitlab.com/gitlab-org/gitlab/-/commit/4700e414f53439e63021e20f6982609d3c02c01a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180268))
- [Improve Value Stream Analytics path navigation accessibility](https://gitlab.com/gitlab-org/gitlab/-/commit/c3f657d4fe802113161cb7ecaa166d02ed2c1f6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179110)) **GitLab Enterprise Edition**
- [Fix calculation of owner project when project runner is assigned](https://gitlab.com/gitlab-org/gitlab/-/commit/323f41d1f62523e294709183c300182de54d8613) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180264))
- [MLOps run with no metrics with step results in failed display](https://gitlab.com/gitlab-org/gitlab/-/commit/f8db332da32c570e417e1e1c836960a8dfd873f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180182))
- [Fix find file on blame page](https://gitlab.com/gitlab-org/gitlab/-/commit/895521414fdcdfa43685ffc4ce7ade171832e6fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180127))
- [Update pipeline graph](https://gitlab.com/gitlab-org/gitlab/-/commit/8a3be768ec8fa1efa32b1bc70e0fbf87ceb732cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178645))
- [Dismiss value stream created/updated success alert upon its deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/e218bee31df078c89f9bad81bc217deebb5310a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179770)) **GitLab Enterprise Edition**
- [Fix GQL Error on accessing Job Token Authentication log](https://gitlab.com/gitlab-org/gitlab/-/commit/f5fc5e8308972d365760722aa9d893269b6f4553) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178401))
- [Remove jobs_api_use_primary_to_authenticate feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/bc8add8c936aacb800a44f305d908923790da7d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179772))
- [Fix Ctrl+k command palette keyboard shortcut](https://gitlab.com/gitlab-org/gitlab/-/commit/34ebf56313da82656d958385dd3b60bcacac5714) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178451))
- [Add a way to present Epics using WorkItem new logic](https://gitlab.com/gitlab-org/gitlab/-/commit/3459be7cc8881451b1bca765954db0feede409ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178363)) **GitLab Enterprise Edition**
- [Use comma-separated IDs for skipping groups](https://gitlab.com/gitlab-org/gitlab/-/commit/3e46fe6938391839e9a173e87994b6f5515f0d3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179186))
- [Remove graphql_minimal_auth_methods FpF](https://gitlab.com/gitlab-org/gitlab/-/commit/3fcb284f6f9849bb57a9388f46295ef0a1929906) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179940))
- [Display custom permission title](https://gitlab.com/gitlab-org/gitlab/-/commit/feb64da636e12b96de7a4c67443b5790b9c8e9c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179597)) **GitLab Enterprise Edition**
- [Only check pending migrations if indexing enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/3a673a93e6ab45303b4378c93700cdf6d88fc95b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179300)) **GitLab Enterprise Edition**
- [Remove duplicated controls for narrow viewport](https://gitlab.com/gitlab-org/gitlab/-/commit/21efc44a289d4d5f82d0c587d21331f0bef27711) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179057))
- [Fix the exact code search](https://gitlab.com/gitlab-org/gitlab/-/commit/760f54ac4888e1cda8762392eb5e36914b072860) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179268)) **GitLab Enterprise Edition**
- [Fix "Edit single file" option for empty files](https://gitlab.com/gitlab-org/gitlab/-/commit/bc8e6917681da411b7cc28ac6af159b17008633a) by @sahilsarawagi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179370))
- [Redirect group searches when SSO enabled and expired](https://gitlab.com/gitlab-org/gitlab/-/commit/0f720784a9c55efaf42afebbb785a1d6fa0c738a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179104)) **GitLab Enterprise Edition**
- [Fix storing incorrect policy index in scan_result_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/77fc1e014a36df6e9507a4774ab5f7dc1d804513) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179860)) **GitLab Enterprise Edition**
- [MR actions: Fix alignment and responsive behavior](https://gitlab.com/gitlab-org/gitlab/-/commit/d572003c76781491dbdbcc683b4caa52cff7d3a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179828))
- [Include SEP jobs with overriding PEPs](https://gitlab.com/gitlab-org/gitlab/-/commit/f03326873cb7146be5ef43fe740ff5761d7ca04a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179366)) **GitLab Enterprise Edition**
- [Fix todos for user mentions in wiki page comments](https://gitlab.com/gitlab-org/gitlab/-/commit/6abf9064e91a59ad5ee0c029b469f70da648f4f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178583))
- [Add missing `hasParent` to Hierarchy widget definition](https://gitlab.com/gitlab-org/gitlab/-/commit/2949213c79e1ae6e1688823d02a1e0ff2eac0204) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178969)) **GitLab Enterprise Edition**
- [Ensure dropdown toggle has accessible text on work item create MR button](https://gitlab.com/gitlab-org/gitlab/-/commit/0f524345df92960b4e8d1ae34248a1b69907d3c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179756))
- [Decrease inline button min-height in merge conflict page](https://gitlab.com/gitlab-org/gitlab/-/commit/34ab1be28de3fef3c15d524bd60680fa3b740e8c) by @mschoenlaub ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178959))
- [Enable submit buttons](https://gitlab.com/gitlab-org/gitlab/-/commit/fca494462ff5d9a5fb1fee1d265215792aedfc88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179315)) **GitLab Enterprise Edition**
- [Fix MergeRequestsComplianceViolations not null migrations](https://gitlab.com/gitlab-org/gitlab/-/commit/8eed879311a068fb0cae5f9f3cc107c5aad454ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179567))
- [Allow user to have only 1 admin member role](https://gitlab.com/gitlab-org/gitlab/-/commit/d6de3ddd969b5162cd65bfc7a415c006f4b0664a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179528))
- [Removed coverage check learn more link](https://gitlab.com/gitlab-org/gitlab/-/commit/75404e5b7fee97a3488cd91c9d67d995bbfe1042) by @peterhdangg ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179162)) **GitLab Enterprise Edition**
- [Add a post deploment migration fixing the scim data](https://gitlab.com/gitlab-org/gitlab/-/commit/97afa60e8bc7854500ef48ded08131de13d9b244) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178326))
- [Update error message for validation errors of slugs](https://gitlab.com/gitlab-org/gitlab/-/commit/63911c2b00720f491628d3814083de3aac5f11e1) by @schurzi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179178))
- [Fix a11y issue for new todos dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/84b796a15b9c3f607c9b1cd8cd750e80e7cceca3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178737))
- [Model Registry: Fix default_experiment path](https://gitlab.com/gitlab-org/gitlab/-/commit/6d007a5a36b776d99a8809d4d38e468b1825b9e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179387))
- [Fix CI_RUNNER_TAGS regression](https://gitlab.com/gitlab-org/gitlab/-/commit/f39af4c70d1237010ccdee30b3612b938a27c002) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179671))
- [Fix API logging of JSON float/boolean param values](https://gitlab.com/gitlab-org/gitlab/-/commit/1c822c03a031bb907fed8fa5e8c924618c676ff5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179659))
- [Filter out SAML projects when SAML session has expired](https://gitlab.com/gitlab-org/gitlab/-/commit/f932a3506b2d2f37e1b71971a93f44f662c9d8fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179650)) **GitLab Enterprise Edition**
- [Filter out SAML projects when SAML session has expired](https://gitlab.com/gitlab-org/gitlab/-/commit/f8b50e46e824731a9c6b0357686026b49e31a9db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179651)) **GitLab Enterprise Edition**
- [Add alert when global search and logged out groups exist](https://gitlab.com/gitlab-org/gitlab/-/commit/87fd2d66256a6af49000577741ac3a08c19dabe8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179114)) **GitLab Enterprise Edition**
- [Filter out SAML projects when SAML session has expired](https://gitlab.com/gitlab-org/gitlab/-/commit/32f8e5f02f0cf7a22bbdd4ad551069e20d2a8f81) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179111)) **GitLab Enterprise Edition**
- [Ensure file tree table has row headers](https://gitlab.com/gitlab-org/gitlab/-/commit/d3503c72e32f2c1e756fe0a6d0e240aae3f8c770) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179123))
- [Fix commit length](https://gitlab.com/gitlab-org/gitlab/-/commit/b81d096e62410217aa467cae9414e75bfda05e12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179584))
- [Tags list: Fix alignment of actions](https://gitlab.com/gitlab-org/gitlab/-/commit/f0e0a46547ba87164966bf7bf23f881e1fe6cbdb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179357))
- [Add role to informative icons for monitor settings](https://gitlab.com/gitlab-org/gitlab/-/commit/588e89f28dd793a2a0242afd2aabd0b6caee2029) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179065))
- [Two-factor quth: Add title to QR Code SVG](https://gitlab.com/gitlab-org/gitlab/-/commit/e324552600a5da75cd35db6628f29c090288d1c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179030))
- [Add work item title and description in draft](https://gitlab.com/gitlab-org/gitlab/-/commit/f76b559e13432cb3910b1885e9208c05eb418d9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179475))
- [Fixed invalid states for custom stage fields in VSA settings form](https://gitlab.com/gitlab-org/gitlab/-/commit/2e9a48e1c74fec7056ae2bdf073c454613df3721) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178962)) **GitLab Enterprise Edition**
- [Use proper HTML semantics in shortcuts modal window](https://gitlab.com/gitlab-org/gitlab/-/commit/e68ba40da7823344d8b5d55a5c541f766aa64d6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179456))
- [Avoid hard-coding test integer](https://gitlab.com/gitlab-org/gitlab/-/commit/e35e7f95e3fedd188a07f9c4f8bdce3da7370636) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178820))
- [Only show re-request review button to users who have permission](https://gitlab.com/gitlab-org/gitlab/-/commit/86d8caf0c6d0404759f9e4b4fa251c7637562548) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179442)) **GitLab Enterprise Edition**
- [Wrap devops table help icon with `gl-button`](https://gitlab.com/gitlab-org/gitlab/-/commit/49fb985503a1cfc5fd314ecadf69f45fde479aac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178955)) **GitLab Enterprise Edition**
- [Fix loading pipeline execution policies with missing project](https://gitlab.com/gitlab-org/gitlab/-/commit/942db7605235f49ea5e83da7fd59051b19ee633b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177876)) **GitLab Enterprise Edition**
- [Fix bug with contacts autocomplete checking root group not CRM group](https://gitlab.com/gitlab-org/gitlab/-/commit/483e9b6ad3d82cd350f223ada99e980222b2e8b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179415))
- [Uses billable or nonbillable trait for  member roles](https://gitlab.com/gitlab-org/gitlab/-/commit/1cdc43bdbaa41c76abe9708c5cef2761d1fe2ce7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179400)) **GitLab Enterprise Edition**
- [Hide comment template button in work item description](https://gitlab.com/gitlab-org/gitlab/-/commit/089fc806c4d0d3e9ee889919bce411f7ccb0fd09) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178607))
- [Update to use `gl-button` instead of `gl-icon` in `visibility-icon`](https://gitlab.com/gitlab-org/gitlab/-/commit/5c8e79d601c8a3a7b1a3c8590ad17a1ca6602180) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179102)) **GitLab Enterprise Edition**
- [Remove exclude_child_pipelines_from_tag_branch_query feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/94cc6562bd9390fbb2eaaff72a4abf024580f6f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162308))
- [Fix category of collapsed issue sidebar notification button](https://gitlab.com/gitlab-org/gitlab/-/commit/a583d5b86c1c02f520a8a488d8928af162d9e331) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178907))
- [Rescue timeout errors in GeoNodeStatus metrics queries](https://gitlab.com/gitlab-org/gitlab/-/commit/76201b66b96956e90bbb4f09f477fb1c777a2776) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177100)) **GitLab Enterprise Edition**
- [Use primary DB when authenticating via job token in jobs API](https://gitlab.com/gitlab-org/gitlab/-/commit/61e5ce682e5d979d36d005663db20e81462771bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179189))
- [Skip scheduling service cache if no period is provided](https://gitlab.com/gitlab-org/gitlab/-/commit/99dea4b34308aab407a8216f84257d731fff0ddb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179259)) **GitLab Enterprise Edition**
- [Fix resource_tokens page in credentials](https://gitlab.com/gitlab-org/gitlab/-/commit/f3941e3293040803a426f4cb12d0db8c76551a57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177268)) **GitLab Enterprise Edition**
- [Fix pages multiple deployments limit for forgotten plans](https://gitlab.com/gitlab-org/gitlab/-/commit/e6313a1dac35c9c5d75c5139cdb96cd4e33cf87a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179280))
- [Take scrollbar width into account when calculating collapsed sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/c7870c67547251714c4d00ae32912554498bba8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178913))
- [Use `canUpdate` policy to control close button visibility](https://gitlab.com/gitlab-org/gitlab/-/commit/1283da06cc020728ba8f07a057a22abbf90bcb25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179113))
- [Work items design management: Fix alignment](https://gitlab.com/gitlab-org/gitlab/-/commit/10b01e7877c62bb3f787c9a1c9aeb0aca4148a81) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179245))
- [Update validations for pipeline removal](https://gitlab.com/gitlab-org/gitlab/-/commit/d52ae45616ba4c2a69039ac838deb805e9cf2061) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179241))
- [Localize type names in work item create form](https://gitlab.com/gitlab-org/gitlab/-/commit/c04746ccb148e134b9bb37c98173bdabd4d7f47e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178891))
- [Fix NoMethodError when quick action users are not set](https://gitlab.com/gitlab-org/gitlab/-/commit/9461e6e9c50336cb1b12d03b1174b6c841129985) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179208))
- [Fix routing for projects with dots in catalog](https://gitlab.com/gitlab-org/gitlab/-/commit/31c5b6f06a02c5570962a4bab92a3d6e6766232d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178420))
- [Update project settings approval widget](https://gitlab.com/gitlab-org/gitlab/-/commit/cfd0b0de1fbbf3c8ee0fefadb0ba005ed88e3014) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179161)) **GitLab Enterprise Edition**
- [Skip cyclonedx report when its type is set to](https://gitlab.com/gitlab-org/gitlab/-/commit/e487d0c107698b6ff89c8c4893d57a2448a5da00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179070)) **GitLab Enterprise Edition**
- [Ensure DevOps Reports tables have row headers](https://gitlab.com/gitlab-org/gitlab/-/commit/7efd4af79515d00adeebc47a5d578bbeb8aea5fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179126)) **GitLab Enterprise Edition**
- [Ensure admin subscripton page tables have row headers](https://gitlab.com/gitlab-org/gitlab/-/commit/9749ae55259c8bc771ecd76ee62b4443c9027884) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179116))
- [Ensure Admin users table has appropriate row headers](https://gitlab.com/gitlab-org/gitlab/-/commit/1db7b541f1761cd1baaa7efd32131abd37eafe30) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179118))
- [Ensure PAT table rows have a row header](https://gitlab.com/gitlab-org/gitlab/-/commit/17b50450c318748cf77f6b7c384c541924e9edf1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179121))
- [Add labels to color picker inputs in user preferences](https://gitlab.com/gitlab-org/gitlab/-/commit/1aa51c9d4ab40e0f7d6500dea050582378455e71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179134))
- [Ensure Kubernetes cluster table rows have row headers](https://gitlab.com/gitlab-org/gitlab/-/commit/b8bc8242dce645a4a49ed85224f58ae77656d4ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179127))
- [Ensure Job cell is the row header for Jobs table](https://gitlab.com/gitlab-org/gitlab/-/commit/a79966ace7f6aaf11a428f793d0487529d826064) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179120))
- [Ensure board move to top/bottom buttons have role](https://gitlab.com/gitlab-org/gitlab/-/commit/97f0dc0ff75b324d0238239630c9198a22a251d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179109))
- [Update to use `gl-button` for feature flag description info](https://gitlab.com/gitlab-org/gitlab/-/commit/f0ad03c6d1c15e56672f008f1a13680394ca80ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179108))
- [Fix review/draft notes using only quick actions](https://gitlab.com/gitlab-org/gitlab/-/commit/50d3453096d7b9ff3798a853ddd1f67964e94dcc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174028))
- [Fix alignment of user profile info](https://gitlab.com/gitlab-org/gitlab/-/commit/ce642707942e63e34e9500cc7cc76cddf4931fa1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178768))
- [Editor toolbar: Add role and aria-label](https://gitlab.com/gitlab-org/gitlab/-/commit/97ed86f942b66d26d42ccbc7d16b82f03b4b377d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179086))
- [Pass schedule param to execution policy pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/e24bc594a778e41c9e19897a3c97acfa4759eac2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179078)) **GitLab Enterprise Edition**
- [Verification: Add missing id for form label to work](https://gitlab.com/gitlab-org/gitlab/-/commit/2bfdbb9d563f819957a51cb272400ff5ddd4327e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179079))
- [Monitor settings: Fix a11y issue with labels](https://gitlab.com/gitlab-org/gitlab/-/commit/fcd92b637b7c6b69f79fef3772837e82727ed147) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179074))
- [Pages: Adds label to input fields on step 2](https://gitlab.com/gitlab-org/gitlab/-/commit/2b2b610c890da85c7570259f060c346bfd055389) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179064))
- [Design management (legacy): Add aria-label to checkbox](https://gitlab.com/gitlab-org/gitlab/-/commit/5a6e61aceccf862ecbf090d0d7fce70dbba1fb0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179061))
- [Project acess tokens: Fix select label for attribute value](https://gitlab.com/gitlab-org/gitlab/-/commit/fc43934a1f243811c8d15d5b60bb9637b12ae115) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179056))
- [Remove "project_templates_reporter_access" feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/8e3087647e35c1b6fcee99cba66bbeabb9e1e10c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178440))
- [Make sure badges visible for non-admins](https://gitlab.com/gitlab-org/gitlab/-/commit/3d11ac0b813b2011e8307522c26edf03c6cb13f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178615))
- [Content editor: Add missing aria-label](https://gitlab.com/gitlab-org/gitlab/-/commit/c827b0e6c425efb6b638ada70ecd4667de1984c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179013))
- [Add missing name for disclosure button on group list page](https://gitlab.com/gitlab-org/gitlab/-/commit/679183cb828b65f29464877b4f626b1c6e4a917c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179012))
- [Add missing name for disclosure button](https://gitlab.com/gitlab-org/gitlab/-/commit/980dbd41c9c46b303d07f1caeb9510dcf2e1ae3d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179009))
- [Instance overview: Fix link focus](https://gitlab.com/gitlab-org/gitlab/-/commit/85bf45195f110f7b86db35193982fb3659ad15e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179003))
- [Fix ActionView::MissingTemplate for CompareController](https://gitlab.com/gitlab-org/gitlab/-/commit/0c7a2daf5b5e17b46ab892876a2cd8e73bb11c1f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179000))
- [Commment user link: Add focus ring](https://gitlab.com/gitlab-org/gitlab/-/commit/e97970a3f48083defdfdafb8ed4f9cba2dc89ec5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178998))
- [Fix intermittent logouts even with remember me](https://gitlab.com/gitlab-org/gitlab/-/commit/7e603e1f1c361707030efbc983f26123c264b7e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178035))
- [Add missing names for buttons on policies, labels and clusters table](https://gitlab.com/gitlab-org/gitlab/-/commit/5e473df1776113475fbf7d717df7c3255f19f520) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178947))
- [Fix error for anonymous users on Projects::Ml::CandidatesController#show](https://gitlab.com/gitlab-org/gitlab/-/commit/c8386d5d25008c864cc77c87d4c320fd81a12f29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178127))
- [Finalize deduplication of issuable_resource_links](https://gitlab.com/gitlab-org/gitlab/-/commit/875082b5b5f157a748e1a34e755ffd85270f62cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173180))
- [Fix memory leak in DiffFile.vue](https://gitlab.com/gitlab-org/gitlab/-/commit/c69eee775a67f6bfdd3fb9d2aaa3a73b36fb673c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178719))
- [Upload large export files outside DB transaction](https://gitlab.com/gitlab-org/gitlab/-/commit/c5ae4fb2d8512a25076c75e204d73166f75be929) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178738)) **GitLab Enterprise Edition**
- [Fixes merge reports section in the widget not being fully hidden](https://gitlab.com/gitlab-org/gitlab/-/commit/2e0d65caf46e85c135bf9707678099fb1c6bbfd6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178704))
- [Add error handling to dependency export creation](https://gitlab.com/gitlab-org/gitlab/-/commit/cbbfccaae5bb063bcc5a696f3b4d01855a335edc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178784)) **GitLab Enterprise Edition**
- [Fixed layout issue on the invite member modal component](https://gitlab.com/gitlab-org/gitlab/-/commit/04c433bcab5a7e4e983434ff2dc01527ae7b3fed) by @zillemarco ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177866))
- [Wrap project card content on small screens](https://gitlab.com/gitlab-org/gitlab/-/commit/cece05e6a4b1a6882269b3f255c936d4f808cd4a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178772))
- [Fix projectAnalytics.aggregate.durationStatistics nil values](https://gitlab.com/gitlab-org/gitlab/-/commit/98796b1a1e88d04734fdadcac4041da31f63e8fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178623))
- [Fix 500 error when tag delete process fails](https://gitlab.com/gitlab-org/gitlab/-/commit/101a88eb94fa3abf19a42f97f8700cebedbb6e08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178305))
- [Remove useless validations for subgroup settings](https://gitlab.com/gitlab-org/gitlab/-/commit/b091d9c397ee39bff08ff264f6312115c664a5e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178724))
- [Add static analysis checks for job token policies](https://gitlab.com/gitlab-org/gitlab/-/commit/7671020a737ec7ea2f47315c151c4cd851ac886e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178731))
- [Fix DumpWriteBufferCronWorker with multiple attribute groups](https://gitlab.com/gitlab-org/gitlab/-/commit/948bf45a2f20de092899f94070acccb26d7df3a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178701)) **GitLab Enterprise Edition**
- [Fix permission issue for On-demand scans](https://gitlab.com/gitlab-org/gitlab/-/commit/407581b35997a9895c726c5c3e90e4ff792e91f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178546)) **GitLab Enterprise Edition**
- [Fix 500 error when `ciPipelineStage` query has an invalid id](https://gitlab.com/gitlab-org/gitlab/-/commit/3255d75107f3bbc69fabc6c47d3e41f70f6b5bb5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178708))
- [Add db trigger to fill wiki user mention sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/471bdaabf3fa7e61d44d10f53ab27eb1cd0c9c1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176220))
- [Fix 500 error on unauthenticated audit event](https://gitlab.com/gitlab-org/gitlab/-/commit/d560015f51a2051c97acbcca367c6afcb1dccf79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177631)) **GitLab Enterprise Edition**
- [Fix vulnerability details header alignment](https://gitlab.com/gitlab-org/gitlab/-/commit/5ecf5a8c43074ecdd2c489a82f678a6cde295a24) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178409)) **GitLab Enterprise Edition**
- [Fix Workhorse failing on 64-bit unaligned access on Raspberry Pi 32-bit](https://gitlab.com/gitlab-org/gitlab/-/commit/a01304965ae462ad33600aac4105d9858a5addd3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178476))
- [Support capitalized response for smart server reply](https://gitlab.com/gitlab-org/gitlab/-/commit/115f07789b4824688d8e8b21a8735f0a409dc75b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178443))
- [Fix nil input in causing SetGroupSecretPushProtectionService to fail](https://gitlab.com/gitlab-org/gitlab/-/commit/1027ae4430f17868ed1d278fc462bb225bcd9126) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178423)) **GitLab Enterprise Edition**
- [Ensure user external attribute is preserved and not null](https://gitlab.com/gitlab-org/gitlab/-/commit/9ed71364e017727777ed85dd6b73b5e5d8d32e1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177671))
- [Delete scan_result_policy_reads when deleting security policies](https://gitlab.com/gitlab-org/gitlab/-/commit/5cde89d6508d102898d72cd49118cb1e121ac2f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176183)) **GitLab Enterprise Edition**
- [Use `moveDesign` permission to control design reordering](https://gitlab.com/gitlab-org/gitlab/-/commit/4ce172136250cbaa767c0419750be32600756104) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176695))
- [Fix rescue statement by returning expected value](https://gitlab.com/gitlab-org/gitlab/-/commit/8e1d81a96d51cd13f4e8253ea137129b4f3b0203) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177736))
- [Fix descendant filter for security policies](https://gitlab.com/gitlab-org/gitlab/-/commit/49f21df654dc503b18f60632232688ad36d49cab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176840)) **GitLab Enterprise Edition**
- [Use naive component-based state approach for infinite list](https://gitlab.com/gitlab-org/gitlab/-/commit/0465cbbe0dd01bd394d11246032d9f10937d9587) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178309)) **GitLab Enterprise Edition**
- [Include support_bot comments in MRs to Duo Chat context](https://gitlab.com/gitlab-org/gitlab/-/commit/df7041245d088b35da2dc5d1674e1716567dc516) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178300)) **GitLab Enterprise Edition**
- [Fix weight attribute truncation on related items](https://gitlab.com/gitlab-org/gitlab/-/commit/bce0eb7f967ad2484a3831fe464867ec902dc285) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178289))
- [Fix shared agents list](https://gitlab.com/gitlab-org/gitlab/-/commit/d5c15f048fa79417ca7b3587cdbed141e9140f45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178220))
- [Fix member role preloaders when IDs are passed instead of objects](https://gitlab.com/gitlab-org/gitlab/-/commit/d809a0e6acff7065b1c48cb4dde4485b67074d6e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178260)) **GitLab Enterprise Edition**
- [Don't show incorrect median value for Overview tab of VSA](https://gitlab.com/gitlab-org/gitlab/-/commit/ccf0986782e1f34507575d8760efa29dc0846677) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177894))
- [Check for admin in remote_mirror_setting_enabled?](https://gitlab.com/gitlab-org/gitlab/-/commit/42070bf85628a37e9f18fe88c6af036662efd208) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177351)) **GitLab Enterprise Edition**
- [Fix commit tags badge link text color in dark mode](https://gitlab.com/gitlab-org/gitlab/-/commit/49aebe3a1ff1588476f70fc0b5559ed5c7f01d67) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178241))
- [Prevent guest users from locking issue discussion](https://gitlab.com/gitlab-org/gitlab/-/commit/19549b3273e56559b02afa98b7f63f0d45ec1344) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177498))
- [Fix work item parent reset error on create work item](https://gitlab.com/gitlab-org/gitlab/-/commit/a4911031f8418e9b04893d8c2bfbe929bde757fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178210))
- [Cloud Connector: Fix health check for dev use case](https://gitlab.com/gitlab-org/gitlab/-/commit/84cb865b890a703d49fe4bb921625078cbdf68e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178189)) **GitLab Enterprise Edition**
- [Redirect users not in onboarding to root_path](https://gitlab.com/gitlab-org/gitlab/-/commit/71e5567405f0d9fb9a27e4d1329f6351bf7d9943) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177926)) **GitLab Enterprise Edition**
- [Fix text color of rich text suggestion added line text](https://gitlab.com/gitlab-org/gitlab/-/commit/4f8f03971105ad3d05e07d1bbfc6b4d56c29322a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178077))
- [Remove limit of max 5 defined policies from json schema](https://gitlab.com/gitlab-org/gitlab/-/commit/2e98670af2bc0f7285e42770404252b5a434a9b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177849)) **GitLab Enterprise Edition**
- [Show diff when diff_refs.head_sha has been pruned](https://gitlab.com/gitlab-org/gitlab/-/commit/f5e992a71a1cc1e30f59444bd5923945476cd1ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178082))
- [Fix SCIM revoked identities](https://gitlab.com/gitlab-org/gitlab/-/commit/114a2889409845abf15d2b19d07468d176644d03) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177882)) **GitLab Enterprise Edition**
- [Fix console warning on work items new page](https://gitlab.com/gitlab-org/gitlab/-/commit/222b840246e11f721255aa1d3b5a5646940b853d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177985))
- [Move to-dos actions out of the main link](https://gitlab.com/gitlab-org/gitlab/-/commit/a030702d5e6d8ae2966f9564328b78add2b31706) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177906))
- [GitHub import handle requested_reviewer nil](https://gitlab.com/gitlab-org/gitlab/-/commit/2d9dc9bde00750b843c28fc814e1541460d2b7d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176929))
- [Fix console error on work item detail page](https://gitlab.com/gitlab-org/gitlab/-/commit/e4272d358a3ca4c000b42c28fcaa7316ce67ecf1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177989))
- [Use UTF-8 encoding for email notifications](https://gitlab.com/gitlab-org/gitlab/-/commit/8f3492a026c9e6bbbdba542ac4e0ab077a9ef7b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177979))
- [Show diff when diff_refs.head_sha has been pruned](https://gitlab.com/gitlab-org/gitlab/-/commit/556f98c6a0ecf6363f8e868c7971af674bc644b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177932))
- [Handle case when deployable is nil](https://gitlab.com/gitlab-org/gitlab/-/commit/a68a751a6f9076c5304a105660c3eaa7d130afa5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177862))
- [Apply all filters to flowMetricsQuery](https://gitlab.com/gitlab-org/gitlab/-/commit/0d23535ef9b32a21f012701fe1bddecd6d871b24) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173710))
- [Handle nil `#mapped_user_id` in `SourceUserMapper`](https://gitlab.com/gitlab-org/gitlab/-/commit/f60feb618c7cd230b6209c936ba377e689df2607) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167713))
- [Reset variable visibility on form reset](https://gitlab.com/gitlab-org/gitlab/-/commit/6f6dfcf13fed717c33e637a20c790276dfee3d91) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177925))
- [Fix issue template loading for templates with spaces in names](https://gitlab.com/gitlab-org/gitlab/-/commit/0a422abb7f8da911c0e3d9510c259c806ee3ee8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177819))
- [Fix merge_after moving on each edit if server timezone is not UTC](https://gitlab.com/gitlab-org/gitlab/-/commit/875e6080e7089e3ecee69a8ff562b9a842cf8f18) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177792))
- [Fix merge request list empty state](https://gitlab.com/gitlab-org/gitlab/-/commit/4717688f581d4e4ea96c06064c69e8be2b9801bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177790))
- [Resolve vulnerability modal error race condition](https://gitlab.com/gitlab-org/gitlab/-/commit/e5cd80a386b41168804e15c4f1a2d45e60901d4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177463)) **GitLab Enterprise Edition**
- [Fix error when deleting all optional variables](https://gitlab.com/gitlab-org/gitlab/-/commit/167e3fbf4f12f2751319ce1b1e77fc2ad92604cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177610)) **GitLab Enterprise Edition**
- [Render code line breaks in vulnerability](https://gitlab.com/gitlab-org/gitlab/-/commit/a1b941e99cda85f119c2d0160dac83d48b6c040b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177592)) **GitLab Enterprise Edition**
- [Fix scroll position while loading comments](https://gitlab.com/gitlab-org/gitlab/-/commit/51abef50387e258e03b17d03f1f0f9010862314b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177432))
- [Prevent guests from locking MR or assigning reviewers](https://gitlab.com/gitlab-org/gitlab/-/commit/837fc32ee2926203b9c95d026aabf1b392cb2b17) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177500))
- [Add H1 to legacy issue edit page for screen reader users](https://gitlab.com/gitlab-org/gitlab/-/commit/6e7c215d9bdb27243433c502c7d57dfa606af442) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177311))
- [Fix HAML rendering](https://gitlab.com/gitlab-org/gitlab/-/commit/d2edd404053b6242441cade901894c3be28d4bdc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174222))

### Changed (273 changes)

- [Adjust import history table row toggle](https://gitlab.com/gitlab-org/gitlab/-/commit/cdb0c96f4742e0a40c35c26590cc374b54a60503) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181324))
- [Add dropdown to load projects for multiple groups](https://gitlab.com/gitlab-org/gitlab/-/commit/4341efde8d8f3f485d0a8d003b577b8db9000b61) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179908)) **GitLab Enterprise Edition**
- [Add db migration for vscode_extension_marketplace](https://gitlab.com/gitlab-org/gitlab/-/commit/6261c4308ecadf59fa4f91b36b1def7318c9011f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181038))
- [Update the latest DS template to use the new DS analyzer](https://gitlab.com/gitlab-org/gitlab/-/commit/bb549cdcba3ad71177654dcb107c87132244ed73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181546)) **GitLab Enterprise Edition**
- [Remove mark_resolved_vulnerabilities_with_sbom_scans feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3bae81c1d43c4d7d5163589c2052c751e3662ac6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181556))
- [Apply gl-card styling to code suggestion blocks](https://gitlab.com/gitlab-org/gitlab/-/commit/336cf8f7e193b3924fe73d1b2f7fd5ce7ef08bcb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180032))
- [Move Add to tree control](https://gitlab.com/gitlab-org/gitlab/-/commit/d3cf7b34544d74e8bf25d99dd7a7fa3d5db4e548) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180951))
- [Improve accessibility for project and commit views](https://gitlab.com/gitlab-org/gitlab/-/commit/5e8351225e39788128f75adee48b4d9dd81a1eba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181287))
- [Pass interface and client information to AI Gateway](https://gitlab.com/gitlab-org/gitlab/-/commit/8b6277e4376b9565607a791371f38570eb8abade) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181351)) **GitLab Enterprise Edition**
- [Fix 500 error on IP restrictions when checking snippets](https://gitlab.com/gitlab-org/gitlab/-/commit/5ad5acc6cc64eead987a113d20265ca1f033caaf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180331)) **GitLab Enterprise Edition**
- [Update the CI templates for DS to use the new DS analyzer](https://gitlab.com/gitlab-org/gitlab/-/commit/b929fca32a1664abd50982bed666f9e816950081) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178065)) **GitLab Enterprise Edition**
- [Change new github project error message](https://gitlab.com/gitlab-org/gitlab/-/commit/4505a22a99cbc982e72d0d5e0a3e36ee1ba3dca7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180398)) **GitLab Enterprise Edition**
- [Migrate model experiments listing page to graphql](https://gitlab.com/gitlab-org/gitlab/-/commit/57fb55a1c6ec83c52fb854b173fd5d60a5baeff7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179227))
- [Improve invalid owners detection in CODEOWNERS](https://gitlab.com/gitlab-org/gitlab/-/commit/3232479ca81628d0b47c4a269516056d7207e329) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180936)) **GitLab Enterprise Edition**
- [Link custom software license to software license policies](https://gitlab.com/gitlab-org/gitlab/-/commit/2d76c9f19f4d98a388f1439d0413ae79f0026d14) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180958)) **GitLab Enterprise Edition**
- [Admin Token API: Revoke Incoming Email Tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/20b24a6b20c1efe70ef4d422facdc00916f313f6) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180763))
- [Call MarkAsResolvedService after an SBOM security scan](https://gitlab.com/gitlab-org/gitlab/-/commit/84f7e9b86d27ac44559a3dc88d8e79175c103ef7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179119)) **GitLab Enterprise Edition**
- [Show a visual when the environment is in the stopping state](https://gitlab.com/gitlab-org/gitlab/-/commit/2bea53abb3e7d23e8498dd48d377d96cd67d27b8) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179981))
- [Consider user permissions when validating Code Owners](https://gitlab.com/gitlab-org/gitlab/-/commit/cb8de9cab36618b63717d354d2e37379ace939a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179310)) **GitLab Enterprise Edition**
- [Add v2 approval rule table and model](https://gitlab.com/gitlab-org/gitlab/-/commit/ff11799500d08e8973f30cc1631747db6c85d11b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179839)) **GitLab Enterprise Edition**
- [Document inject_policy strategy for pipeline execution policies](https://gitlab.com/gitlab-org/gitlab/-/commit/b6df56a570ce5b9eb4bcb8f12721883dc84c6d37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180753))
- [Fix Pages CI Variables](https://gitlab.com/gitlab-org/gitlab/-/commit/7a921eed857f485162cd6963524c18c09a6541ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180697)) **GitLab Enterprise Edition**
- [Cloud Connector: Expose keys from database](https://gitlab.com/gitlab-org/gitlab/-/commit/ae993b45782688be5a1c7936caa3013ff33fb91d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180385)) **GitLab Enterprise Edition**
- [Prevent user from downloading empty CSV](https://gitlab.com/gitlab-org/gitlab/-/commit/f13ab0d87ebf9e40bcb7453547c6d97ed6122d9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178750))
- [Zoekt: Rollout the zoekt_reemit_events FF](https://gitlab.com/gitlab-org/gitlab/-/commit/83ba2346fa9bbf78443172a9f73363ad7802e5d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181236)) **GitLab Enterprise Edition**
- [Remove unnecessary codes](https://gitlab.com/gitlab-org/gitlab/-/commit/517c561f0d96265fe70aad4857329c0cadb863ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181235)) **GitLab Enterprise Edition**
- [Remove loose_foreign_keys_for_polymorphic_associations FF](https://gitlab.com/gitlab-org/gitlab/-/commit/2fcaa2f0ef87b9e4f037abc42012a5891b8b39f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181230)) **GitLab Enterprise Edition**
- [Removed feature flag search_mr_filter_source_branch](https://gitlab.com/gitlab-org/gitlab/-/commit/63085168dc34ddd2f7cb8e724882a5fce98ce37a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180254)) **GitLab Enterprise Edition**
- [Change label ID field type to Types::GlobalIDType[::Label]](https://gitlab.com/gitlab-org/gitlab/-/commit/58f9bf93f8a05212089952ec746c97125d4650e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180861))
- [Update squash options update mutation to support all branches rules](https://gitlab.com/gitlab-org/gitlab/-/commit/d032aa51232ea99473a39e618b67abe631f78cab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181197))
- [Remove claude_3_5_sonnet_20241022_for_code_gen feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/bb1c6002aa72b324611cd4c9fd8f4fb082a1c42e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181171))
- [Update links to full docs URLs to skip index](https://gitlab.com/gitlab-org/gitlab/-/commit/52ddf2df64cc7581fa8a512ca2c96e64135b079b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180890))
- [Update comment to be mandatory in bulk severity override mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/7940c4755222436ac92e381a7575d251a0f192f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180856)) **GitLab Enterprise Edition**
- [Update links to full docs URLs to skip index](https://gitlab.com/gitlab-org/gitlab/-/commit/8b443ae2b89990b015616a5715ede5ff2fc73ef6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180877))
- [Add import history table destination formatter](https://gitlab.com/gitlab-org/gitlab/-/commit/9fa2503be6091a70b6758b18c323a6f2deac6c11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181139))
- [Documentation changes for rename prsd to spp](https://gitlab.com/gitlab-org/gitlab/-/commit/900367780a0937cc867bd0495e4b00623114997c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179768))
- [Add import history table row and header container components](https://gitlab.com/gitlab-org/gitlab/-/commit/10c21c32bfb29140ba566300e4f7c4a2f3ea61d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181133))
- [Rename index files in application security docs](https://gitlab.com/gitlab-org/gitlab/-/commit/38ad6c3c83f6fe0ae5effda4705a80cea0a9be4f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180670))
- [Allow shortcuts to remove markdown](https://gitlab.com/gitlab-org/gitlab/-/commit/56a5da78b1e8a9d5d289bf8dbcba33190decbfd4) by @Bubbis ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178466))
- [Import group: Migrate components used](https://gitlab.com/gitlab-org/gitlab/-/commit/860d84886f5d409dcc451eaa43f8455f2a16ebf4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180376))
- [Import groups by direct transfer: Cleanup interface](https://gitlab.com/gitlab-org/gitlab/-/commit/5fa416018ba93d7fc1b322c3a46287c396046a63) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180534))
- [Use work item epic-issue adapter by default](https://gitlab.com/gitlab-org/gitlab/-/commit/18b013c0e78f38919145837ea1cac6748d44253c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179457)) **GitLab Enterprise Edition**
- [Automatically update subsequent ordered lines in plain markdown editor](https://gitlab.com/gitlab-org/gitlab/-/commit/840b52b736faf3d2057ce735d43a0a75ac5ebca7) by @Bubbis ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179924))
- [Disallow project runners from being unassigned from owner](https://gitlab.com/gitlab-org/gitlab/-/commit/7e12e9e35cc733f19219766b1f74593fbcced459) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180368))
- [Update links to full docs URLs to skip index](https://gitlab.com/gitlab-org/gitlab/-/commit/794d4d9acb46c5fc0e6bc822339f3fea9bb4da21) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180891))
- [Improve error messages for custom stage fields in VSA settings form](https://gitlab.com/gitlab-org/gitlab/-/commit/e06abb354bb3fe08b3e3af186e4ff79e4baf242c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180628)) **GitLab Enterprise Edition**
- [Change user ID field type to Types::GlobalIDType[::User]](https://gitlab.com/gitlab-org/gitlab/-/commit/09ef044849ab1b23292f9342f21c665df1e37b0b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180901))
- [Add an explanation why the CI variable value cannot be masked](https://gitlab.com/gitlab-org/gitlab/-/commit/1e5f1c32c0df6886828bdaab70fe6192f7862fb1) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180778))
- [Change repository controls into a dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/1fef76663f6fbeb3b7dbfb29c9434d6b50894bc4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179713))
- [Update error message for `needs` CI keyword](https://gitlab.com/gitlab-org/gitlab/-/commit/efafa546b5c3d30d67207dbc523e7bb696bb1088) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180411))
- [Move the troubleshoot button to a sticky footer](https://gitlab.com/gitlab-org/gitlab/-/commit/274323e5558ddbb6e1883c53785113ba1226e93e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179599))
- [Handle ghost users consistently](https://gitlab.com/gitlab-org/gitlab/-/commit/b4a2a3e4cd473e041a87d0de04cc20f32ef42b59) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179829))
- [Update sort labels to be consistent across groups and projects](https://gitlab.com/gitlab-org/gitlab/-/commit/96a6229dfe0fe860cfb0dc69b69a0288d057e855) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180971))
- [Store recently delete billable members to ease the sync up](https://gitlab.com/gitlab-org/gitlab/-/commit/6aedb357a5c9c5d7f4503023d6819ee1fe8d998e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179497)) **GitLab Enterprise Edition**
- [Cleanup left over cross-db suppressions](https://gitlab.com/gitlab-org/gitlab/-/commit/9400bef33e7a70fda7912415da62dd234a705336) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180156)) **GitLab Enterprise Edition**
- [Default-enable security policy project deletion prevention](https://gitlab.com/gitlab-org/gitlab/-/commit/acf2eda151ecc2440a89949068aff2e05cdaaa7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180919)) **GitLab Enterprise Edition**
- [Update links to full docs URLs to skip index](https://gitlab.com/gitlab-org/gitlab/-/commit/fbbd7ddb1ba1121ffbe6ebd9a20e9a492c5c19de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180872))
- [Rename index files for user/group clusters and contribution_analytics](https://gitlab.com/gitlab-org/gitlab/-/commit/c233d986b6ad614addd286880964c2d5592266df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180862))
- [Update CI_JOB_TOKEN JWT payload](https://gitlab.com/gitlab-org/gitlab/-/commit/7ff6775c4a8e75a2e82d1c71fb698e65c4cb99cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179710))
- [Add the ability to download compliance frameworks](https://gitlab.com/gitlab-org/gitlab/-/commit/5f1d1eeb548779a4c30e0512b8591c52e52c5762) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179588)) **GitLab Enterprise Edition**
- [Add GET /projects/:id/remote_mirrors/:mirror_id/public_key API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/b2e4e6ed8aba5cfd4daca37f66fc0630222cf43e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180291))
- [Enhance resilience of single relation import Sidekiq worker](https://gitlab.com/gitlab-org/gitlab/-/commit/c60a86b76da83ff94ea925dcb19299dd7189867a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180780))
- [Do not drill props to BlobButtonGroup](https://gitlab.com/gitlab-org/gitlab/-/commit/c5af509ef855a555c498795de49d4ddafd30503f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180228)) **GitLab Enterprise Edition**
- [Rename index files for Hugo migration](https://gitlab.com/gitlab-org/gitlab/-/commit/eb4ebf62e45b7032f2ca3cc781f0e94a24dc1bc7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180702))
- [Remove codeowner_role_approvers ff](https://gitlab.com/gitlab-org/gitlab/-/commit/5a184e9cab71b9718bd6ccde720bc793fc70baeb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180213)) **GitLab Enterprise Edition**
- [Advanced search: Cleanup sections](https://gitlab.com/gitlab-org/gitlab/-/commit/be83f3f4bb5eeb958ab81371b4bfda2bc9012312) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180528))
- [Zoekt: Update dot_com_rollout task](https://gitlab.com/gitlab-org/gitlab/-/commit/60badd1dabce96f76f3a8c6c888f29bb56b3c966) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180250)) **GitLab Enterprise Edition**
- [Rename index.md to _index.md for compatibility with docs-gitlab-com](https://gitlab.com/gitlab-org/gitlab/-/commit/2fbc794ac4b80280259083d17bff7a2ab44626af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180660))
- [Rename index.md to _index.md for compatibility with docs-gitlab-com](https://gitlab.com/gitlab-org/gitlab/-/commit/97ee7b1468c4efc6e3179bc1ed674cb1030195df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180656))
- [Rename index.md to _index.md for compatibility with docs-gitlab-com](https://gitlab.com/gitlab-org/gitlab/-/commit/67be33ed902a1b2bfcbff95ee900cd465b45967c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180636))
- [Restructures code coverage doc and incorporates test coverage viz doc](https://gitlab.com/gitlab-org/gitlab/-/commit/011ef1ecb20dab2361aed524fb79e97a1403636d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179914))
- [Rename index.md to _index.md for compatibility with docs-gitlab-com](https://gitlab.com/gitlab-org/gitlab/-/commit/54e5990d20fcd2f1794213957825bc6f0ae31887) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180633))
- [Rename from index.md to _index.md](https://gitlab.com/gitlab-org/gitlab/-/commit/3dac072e0ca276cc1140cffb4a14a0f64a4d9fbc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180591))
- [Update pages service](https://gitlab.com/gitlab-org/gitlab/-/commit/3d308fff32ac822da8a44ad2a54dc582d9e74052) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172950))
- [Update create pipeline mutation to use GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/dbee4e48eda3f5746bdcf2ed4aa9cdcb879ea332) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176728))
- [Add ComplianceFrameworksController for JSON export](https://gitlab.com/gitlab-org/gitlab/-/commit/61d2316255c27bb528552964cadb9a924a6693c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178817)) **GitLab Enterprise Edition**
- [Change UX flow of license exclude packages](https://gitlab.com/gitlab-org/gitlab/-/commit/29ada8d32f4f89eb4de812e792218dd60caa69f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180466)) **GitLab Enterprise Edition**
- [Include AllBranchesRules in non-EE branch rules responses](https://gitlab.com/gitlab-org/gitlab/-/commit/b5a86ce83fa7db401eaf7bd4dbdb46739b90ff51) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176815))
- [Remove $registryClass from replicableTypeUpdate mutation in Geo](https://gitlab.com/gitlab-org/gitlab/-/commit/e3c4ef64dfce174dabf7f3fd5368e4b654d95eed) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180635)) **GitLab Enterprise Edition**
- [Create downstream_pipeline_dropdown.vue](https://gitlab.com/gitlab-org/gitlab/-/commit/1a0ffa67bf38c1e924aa814a36b20f15d7bc64e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180277))
- [Add `cronjob_child` tag to Sidekiq cronjob workers](https://gitlab.com/gitlab-org/gitlab/-/commit/3639ca35760294f2bcbad0fa6e7a9ef6be88ec35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180595))
- [Add v2 approval rule table and model](https://gitlab.com/gitlab-org/gitlab/-/commit/96b1539ac6107076ee52980ac2f8d4d7a2330abb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179839)) **GitLab Enterprise Edition**
- [Remove fully rolled-out feature flag for Duo Chat conciseness](https://gitlab.com/gitlab-org/gitlab/-/commit/ba07a9681036dee959b796b6af4d98e54d743cc8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179910)) **GitLab Enterprise Edition**
- [Check root namespace for ci_jwt_groups_direct feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/1e0c8792b388dc9d8a7e97459e3cfe0e5bf056a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180588))
- [Set traversal_ids on vulnerability stat insert](https://gitlab.com/gitlab-org/gitlab/-/commit/3f8da50cd8f7fe0664a8a0947abb06d548ee2a83) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180343)) **GitLab Enterprise Edition**
- [Add more spacing to super-sidebar toggle button](https://gitlab.com/gitlab-org/gitlab/-/commit/c4621410ec633e8c60885164376125443c424f5a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180214))
- [Rename index.md to _index.md for compatibility with docs-gitlab-com](https://gitlab.com/gitlab-org/gitlab/-/commit/619b57d6eb323e9ead10b899a6c2ee837c858235) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180507))
- [Include users from custom roles as MR approvers](https://gitlab.com/gitlab-org/gitlab/-/commit/079feaf0edfce2c08aca2dd4238e5c6472ed736c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176698)) **GitLab Enterprise Edition**
- [Import status: Update component](https://gitlab.com/gitlab-org/gitlab/-/commit/d2b3e933a7b65158b335dcf5a53c2687c4f0e09d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180544))
- [Rename variable and environments index files](https://gitlab.com/gitlab-org/gitlab/-/commit/9ed0a4aa06ab2c5893414cd57055b0fcb1b5f44a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180510))
- [Remove without_archived_projects](https://gitlab.com/gitlab-org/gitlab/-/commit/738d71de0bbb789527037a37f063da00bdcbcb09) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179215)) **GitLab Enterprise Edition**
- [Rename CI YAML index file](https://gitlab.com/gitlab-org/gitlab/-/commit/49252fd68acee80049f32501f1bb79d30789fd92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180508))
- [Reflow work item buttons](https://gitlab.com/gitlab-org/gitlab/-/commit/8e47f923233534225fd4145d507d1e74b05620f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180486))
- [Cleanup pages_multiple_versions_setting feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/9a49142e6efc04704c09dc2109c87f985c0e880c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179678))
- [Remove cross-DB modification](https://gitlab.com/gitlab-org/gitlab/-/commit/b9c7c3cdc6496a0e7c08fad67b7b3bb50a134c54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179578)) **GitLab Enterprise Edition**
- [Expose squash options for all branches rules in free plan](https://gitlab.com/gitlab-org/gitlab/-/commit/9504920e53c7017b10e052b585d23e1583cbaa50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179248))
- [Topic badge tooltip enhancement](https://gitlab.com/gitlab-org/gitlab/-/commit/fd0523b2732c3b8d4a52e04d807b1e5f997dce91) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180442))
- [Ingest all licenses for components with at least one known license](https://gitlab.com/gitlab-org/gitlab/-/commit/7c8bade68600978bc78278081f0764aeef837776) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179373)) **GitLab Enterprise Edition**
- [Make project visibility icon keyboard focusable](https://gitlab.com/gitlab-org/gitlab/-/commit/6681acbbe2b88df6dd5e73735be4bdbeacf37f8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179099))
- [Model Experiments: Sort data descending](https://gitlab.com/gitlab-org/gitlab/-/commit/f669f1a1697a9c6638b68f0df9a9c4004b4fa103) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180219))
- [Visibility settings: Migrate to GlCard](https://gitlab.com/gitlab-org/gitlab/-/commit/de457211bac9841f963b860465a005f637f27126) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180168))
- [Remove callback for adding user to default organization](https://gitlab.com/gitlab-org/gitlab/-/commit/f0c081dec9b4cf9a36a95508ed36a26c081f4565) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175288))
- [Permanently enables duplicate exceptions for packages](https://gitlab.com/gitlab-org/gitlab/-/commit/8a2aca920d5d63c9fdc3f8aa67e5245d00ea2a09) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178828))
- [Admin Token API: Reset OAuth Application Secrets](https://gitlab.com/gitlab-org/gitlab/-/commit/6e4b9bb9bec1bf6d9f495f435b268c1bc1fa351a) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179035))
- [Remove feature-flag drop_lease_usage_project_recalculate_workers](https://gitlab.com/gitlab-org/gitlab/-/commit/15dd6082e96c318dfc33696bc401ce3fea137397) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179956))
- [Cleanup bigint conversion for geo_event_log.geo_event_id](https://gitlab.com/gitlab-org/gitlab/-/commit/1436e59b4e28de3251fb9420e32c05cd21c8fa9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180270))
- [Update text for license rule](https://gitlab.com/gitlab-org/gitlab/-/commit/25f841529e9e0a2db1acfe566ca20601d598743c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180298)) **GitLab Enterprise Edition**
- [Commit: Update page header to use PageHeading component](https://gitlab.com/gitlab-org/gitlab/-/commit/431f5c04379bbd74aac081c59f94b09760bd3321) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179843))
- [Add import history to your work nav bar](https://gitlab.com/gitlab-org/gitlab/-/commit/6a2b9bee919e0aa56968f5ccc771294a0cc2c604) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179752))
- [Fix duplicate emails sent for PrAT and GrAT expiring tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/7b5cfb0a0d985bf0911890ece03daf776158a11f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179774))
- [Enable FF by default for project dependency page](https://gitlab.com/gitlab-org/gitlab/-/commit/97fe90f0d76ad7cff66c2ea409e70c1e09676d4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180208))
- [Improve UI text for syntax theme selection](https://gitlab.com/gitlab-org/gitlab/-/commit/5c812d26c0299bae424df83656934b504db3bf8a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179316))
- [Move publish to pages.publish](https://gitlab.com/gitlab-org/gitlab/-/commit/e238b973efcd4c821e9e53869e4b68fc356fee55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178425))
- [Add discernible text to project notifications button](https://gitlab.com/gitlab-org/gitlab/-/commit/73104ef9dda7d199e4f1e6e3af9c5853609e0093) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179088))
- [Use background status warning on matched text](https://gitlab.com/gitlab-org/gitlab/-/commit/a422a79dd8112fd559ae22233c16a3fceac4fdfb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178551))
- [Improve seat controls copy](https://gitlab.com/gitlab-org/gitlab/-/commit/f8456f59de921d453bf27b2f0a3adca70094bf48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179341)) **GitLab Enterprise Edition**
- [Split microsoft_applications tables](https://gitlab.com/gitlab-org/gitlab/-/commit/c14c6677d9c79728fefcf4b8852070c97a8a5df5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177531)) **GitLab Enterprise Edition**
- [Improve to-do items' styling](https://gitlab.com/gitlab-org/gitlab/-/commit/2213208a98e1fc5e7e2c941dd8a0dd8b94f884d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179865))
- [Always allow pipeline variables in ondemand_dast_validation pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/4c44be2a1d3457d57f4d8a6f42c6451d1cc15c60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179903))
- [Increase fileSize threshold for Highlight.js](https://gitlab.com/gitlab-org/gitlab/-/commit/dd783497e650d3c1eee08f2665492e52fd89edc4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179687))
- [Add in-product announcement for legacy IDE removal](https://gitlab.com/gitlab-org/gitlab/-/commit/ae4259a13dc78ae4f591f288841621de4fa062d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179239))
- [Update gitlab-glfm-markdown and prometheus-client-mmap gems](https://gitlab.com/gitlab-org/gitlab/-/commit/8323a4ab49421030e921b2f65281eb03349609df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179987))
- [Update import page header](https://gitlab.com/gitlab-org/gitlab/-/commit/5f4f7c8f1abdb51cdcc595184c73c8cb67fc155f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178329))
- [Change group SPP feature category to security_testing_configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/51808306d0cf2786b0d8ca3a026421eb77c8cbd8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179800)) **GitLab Enterprise Edition**
- [Add table creator to plain markdown editor](https://gitlab.com/gitlab-org/gitlab/-/commit/411ed41ba97387b51d49dd996344b01b5023c2d6) by @Bubbis ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179150))
- [Load linked to SPP groups](https://gitlab.com/gitlab-org/gitlab/-/commit/9a96403384c04b7b6dcda5a5fa02fa7d12cd4ff4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176899)) **GitLab Enterprise Edition**
- [Remove feature-flag drop_lease_usage_authorized_projects_worker](https://gitlab.com/gitlab-org/gitlab/-/commit/ee9ded971cadb9269be7e07a1a91f080276bc8a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179957))
- [Add partially disabled mode](https://gitlab.com/gitlab-org/gitlab/-/commit/d6daad196893a5331743d34752b4cec77178c1f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179576)) **GitLab Enterprise Edition**
- [Refactor limit check](https://gitlab.com/gitlab-org/gitlab/-/commit/2ea8714a2b9157b6db96719090b5e42804a63aa8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179943))
- [Update breadcrumbs to match tabs and view in the Geo replication](https://gitlab.com/gitlab-org/gitlab/-/commit/094febba8a130c5956edc18954d3b755e6a3cd57) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179535)) **GitLab Enterprise Edition**
- [Truncate the project description when it is long in the CI/CD Catalog](https://gitlab.com/gitlab-org/gitlab/-/commit/2a960511fa6c68bdaf9801fe49d3f176f280017d) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179919))
- [Add ordering when updating used storage bytes for zoekt indices](https://gitlab.com/gitlab-org/gitlab/-/commit/24e39810f158f3fbe70aa06bf56ae26c083b563d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179589)) **GitLab Enterprise Edition**
- [Add number formatting to ci minutes limit banner](https://gitlab.com/gitlab-org/gitlab/-/commit/5cc5994a4be39a9562b32c875e92fb4629e99547) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178736)) **GitLab Enterprise Edition**
- [Add sast tooltip and download link](https://gitlab.com/gitlab-org/gitlab/-/commit/133da063848431b465e6aa26533d3c4d4d5219c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179587))
- [Allow MarkAsResolvedService to scope by report type](https://gitlab.com/gitlab-org/gitlab/-/commit/43f5960c0ffbcad3281ebac1e7374983664b7134) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179117)) **GitLab Enterprise Edition**
- [Update re2 to v2.15.0](https://gitlab.com/gitlab-org/gitlab/-/commit/f2ecf1dc9babfaa44d27846a3fe334bded2c70f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177830))
- [Make file tree and modified icon focusable](https://gitlab.com/gitlab-org/gitlab/-/commit/83147e205945f3a91d96c66ab1a4226c429196dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179125))
- [Rename seat controls section to singular](https://gitlab.com/gitlab-org/gitlab/-/commit/011daf9a0ec4ff662eae311e209f2ecee96d895e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179821)) **GitLab Enterprise Edition**
- [Rename Sign-up restrictions settings section](https://gitlab.com/gitlab-org/gitlab/-/commit/d6b27dbcbe55e8cbced28bcb619cedf3970518b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179806)) **GitLab Enterprise Edition**
- [Restrict tag rule ops  when Gitlab API is not supported](https://gitlab.com/gitlab-org/gitlab/-/commit/cca1e6f0a357f281772fb4bcd5c4865cd2d2c566) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178403))
- [Add project_id to DescriptionTemplates & split singular/bulk fields](https://gitlab.com/gitlab-org/gitlab/-/commit/88e566b2302b524f8c270614a67c040a743f81f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178968)) **GitLab Enterprise Edition**
- [Runner Authentication Tokens: Explain how a token can be resetted](https://gitlab.com/gitlab-org/gitlab/-/commit/68f9f89eda000b71f168f082b5329b3714dd409e) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179568))
- [Sync security policies when protected branch is modified](https://gitlab.com/gitlab-org/gitlab/-/commit/baa80b19ada0713f53ac8e309bb16176364d4c5c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172447)) **GitLab Enterprise Edition**
- [Add linked groups resolver](https://gitlab.com/gitlab-org/gitlab/-/commit/9e86e857c5c885615a54a62745fa8df0df1c1db9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176670)) **GitLab Enterprise Edition**
- [Resolve cross-join in security project statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/e216cf5b19d187d079682687ba7cdd2979615a00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178886)) **GitLab Enterprise Edition**
- [Update notification to Admin](https://gitlab.com/gitlab-org/gitlab/-/commit/2787651b9d8ec653d851c8cd8fdaa483db674c29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178135)) **GitLab Enterprise Edition**
- [Pipeline wizard placeholder use design tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/3159309971d08a5813282f315b5eb993363c9e9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179683))
- [Migrate authored todos to GhostUser](https://gitlab.com/gitlab-org/gitlab/-/commit/aa50e780315cccd9f161950b27f93b37de23f195) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179359))
- [Add discernible text to merge request overview activity sorting button](https://gitlab.com/gitlab-org/gitlab/-/commit/75bae30f1dc949835e03ca8bcda5c9a674929819) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179080))
- [Set vuln stat traversal_ids when setting pipeline](https://gitlab.com/gitlab-org/gitlab/-/commit/5c18882dc6f5796905975c403847eb35fcdc7d6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179663)) **GitLab Enterprise Edition**
- [Restrict creation of new rules if over maximum](https://gitlab.com/gitlab-org/gitlab/-/commit/66022d3d0e04b12548e3fc449eccd637402730c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178996))
- [Allow option to do multi node search on zoekt proxy](https://gitlab.com/gitlab-org/gitlab/-/commit/e283f8dc44801de6313792a9e3e1a181bd893937) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171867)) **GitLab Enterprise Edition**
- [Add partially disabled mode](https://gitlab.com/gitlab-org/gitlab/-/commit/a548e1d70447d29a8ede2bc35a68d3b85c0e95e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179312)) **GitLab Enterprise Edition**
- [Remove feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e250af6a857eddc16c04353ab4cd03d8203dc54f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178643)) **GitLab Enterprise Edition**
- [Papercuts 17.9](https://gitlab.com/gitlab-org/gitlab/-/commit/6b615d3a0d937b66f7b564cd687ad28c894de58b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178934))
- [Enhance CI/CD variable drawer UI with popovers for help content](https://gitlab.com/gitlab-org/gitlab/-/commit/7d02e593eb57110c7e0943daf1f207dcfb000096) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179531))
- [Enable specifying a semantic element for the CRUD component container](https://gitlab.com/gitlab-org/gitlab/-/commit/2fa74ffb9619bced6a949cd4ca3f5df40cc8731b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179072))
- [Return ids of created vulnerabilities with SBOM scanning](https://gitlab.com/gitlab-org/gitlab/-/commit/e279a1f8b0c53d6042ee2b8da45e35e661d2323f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179115)) **GitLab Enterprise Edition**
- [Add protected tag to the container registry](https://gitlab.com/gitlab-org/gitlab/-/commit/bbe6002d9fe79922bc36c3e526f2018d2aa8ebe4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179130))
- [Do not update target entities if todos change](https://gitlab.com/gitlab-org/gitlab/-/commit/10f68bba4f12ccc129d0e41af77fd2d50a923216) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179421))
- [Refactored non-billable check for Gitlab.com BSO](https://gitlab.com/gitlab-org/gitlab/-/commit/fcdf66930362ee1f3f7b71996dce5cd2c3447e87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179392)) **GitLab Enterprise Edition**
- [Reduce layout shifts in usage quotas > pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/8f93c9c6ed0319eda268ad04068b0afe968010eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178274)) **GitLab Enterprise Edition**
- [Integration: Item changes](https://gitlab.com/gitlab-org/gitlab/-/commit/cef357c32e2cdd6dcea082622e4ae0a052a1c8c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178155))
- [Single/Multiple choice component: Update selected and disabled](https://gitlab.com/gitlab-org/gitlab/-/commit/c0c5f54bdaca627985f77d880b4102ba39deb68d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179356))
- [Remove cross-join from namespace historical statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/7f71f082a03f41fd1b87646e63a8bd80f2a6a69d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178899)) **GitLab Enterprise Edition**
- [Fix some RSpec/BeEmpty offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/db5d60c9fa58ef3032ada69f5b6a100c46b08d31) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179355))
- [Use small text for description.](https://gitlab.com/gitlab-org/gitlab/-/commit/f0576eaadeb832d3bc21079023c0775b63adcea1) by @nomad_blaze ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179166))
- [Remove feature flag after globally enbaling](https://gitlab.com/gitlab-org/gitlab/-/commit/d8ac2e35ace131bdf620400bc5ca4547bb1db0ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178748)) **GitLab Enterprise Edition**
- [Update software license policies with custom licenses](https://gitlab.com/gitlab-org/gitlab/-/commit/16f859c9217d3742efdca2b12eccc8f9b16b734d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172406)) **GitLab Enterprise Edition**
- [Show commit SHA in target column of AuditEvents table](https://gitlab.com/gitlab-org/gitlab/-/commit/925d525e518e6f5491098441431b6b095ce3ccaa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175229)) **GitLab Enterprise Edition**
- [Admin Token API: Clarify historic prefixes are only excluded for PATs](https://gitlab.com/gitlab-org/gitlab/-/commit/8ab3749fece8c6341d474494c6c317f056b6d608) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179075))
- [Elaticsearch issue query boost iid by 50](https://gitlab.com/gitlab-org/gitlab/-/commit/9f956a664831cb50ffa79ae8a4c6fa9c5561c9a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179205)) **GitLab Enterprise Edition**
- [Validate not-null and update sharding key for ci_pipeline_messages](https://gitlab.com/gitlab-org/gitlab/-/commit/871d49f698be95c50a7ae646947ab362c92ad4cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178397))
- [Compliance framework dropdown order change & style update](https://gitlab.com/gitlab-org/gitlab/-/commit/82684c85088158fa9a3028ad979802749e9fc24f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179192)) **GitLab Enterprise Edition**
- [Finalize backfilling epic work item data](https://gitlab.com/gitlab-org/gitlab/-/commit/77186da82599ee2f9cdbc144682a8e8c1bf159f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177734))
- [Allow null access levels on rule creation](https://gitlab.com/gitlab-org/gitlab/-/commit/f83db7383cd91442c17b00b8ff05ea1764812744) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179176))
- [Execute pipelines for PEP project schedules](https://gitlab.com/gitlab-org/gitlab/-/commit/6b45bc4310e20b2cbaa3e6a85deb9b840af0d134) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176427)) **GitLab Enterprise Edition**
- [Work item note activity buttons enabled while loading](https://gitlab.com/gitlab-org/gitlab/-/commit/986fe3dccd4fa672d0baecbdba5e7d1a3c4b35e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178006))
- [Show timeago tooltip on tab](https://gitlab.com/gitlab-org/gitlab/-/commit/ac6f39d9f25b3ef51f56cda52fd9d32ab5e53920) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179105))
- [Add discernible text to network/repository graph search button](https://gitlab.com/gitlab-org/gitlab/-/commit/9efbb580a4c0d4b23fd3aebeb4e14cd4d734d55d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179055))
- [Add label to feature flag instance ID regeneration input](https://gitlab.com/gitlab-org/gitlab/-/commit/45495de42b6f08530d706fc655b4e368f0bab095) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179087))
- [Create and trigger the an event to update the](https://gitlab.com/gitlab-org/gitlab/-/commit/d3ecdaab0c07c47ebb7c057c578937fcc9002f41) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178456)) **GitLab Enterprise Edition**
- [Remove branch_names_sorting feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/a0568da1a4ac74540d4bf91694c6a5bc1d507f87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178930))
- [Specify username and password required](https://gitlab.com/gitlab-org/gitlab/-/commit/1ca91064941859b678653e7aba6e80be7470de8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179071))
- [Update dependency @gitlab/web-ide to ^0.0.1-dev-20250110172049](https://gitlab.com/gitlab-org/gitlab/-/commit/e4737b60741600ff4e19b5f71665906b2198b607) by @gitlab-dependency-update-bot ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177778))
- [Update traversal_ids for vulnerability statistic](https://gitlab.com/gitlab-org/gitlab/-/commit/001425af112c9c7d57f251e13b32bce5b6539fb3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178989)) **GitLab Enterprise Edition**
- [Only log elasticsearch metrics if the cluster is red](https://gitlab.com/gitlab-org/gitlab/-/commit/3db51e9ee9c516dfc6c470442ba8796a44937164) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178830)) **GitLab Enterprise Edition**
- [Release create NuGet packages on the fly feature](https://gitlab.com/gitlab-org/gitlab/-/commit/89800fbff272f77bd87bb37312b45671c2751c1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177868))
- [Allow `max_artifact_size` to be changed via the REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/ba543cede3416ec32aadf81c5c0ba7ea742e8ada) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178343))
- [Integrations detail page: Migrations and small visual fixes](https://gitlab.com/gitlab-org/gitlab/-/commit/7caa2a849c1847177e1cd2b0bbd981c67a65a7c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178141))
- [Clean up duo_chat_storage_postgresql feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/4bc93ba4d086fe23287f0cfb18a7b1d0d42964ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178985)) **GitLab Enterprise Edition**
- [fix: Move call to `AiRelatedSettingsChangedEvent`](https://gitlab.com/gitlab-org/gitlab/-/commit/be7dd579a02145148a45177fe00a37d96c3c8a71) by @yashikajotwani12 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178015)) **GitLab Enterprise Edition**
- [Make new header app default](https://gitlab.com/gitlab-org/gitlab/-/commit/f6524fdd92ad5f6780c47619ff83451ef7532b93) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176182))
- [Clean up PATs::ExpiringWorker extended logging](https://gitlab.com/gitlab-org/gitlab/-/commit/00f537820d5b6bce9a247dc6c9728e2739f9b048) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178918))
- [Clean up `rewrite_history_ui` flag](https://gitlab.com/gitlab-org/gitlab/-/commit/8fa34d7df6f796a5bca25abbef7de69082c26a69) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178746))
- [Add class level config for simple zoekt scheduling service tasks](https://gitlab.com/gitlab-org/gitlab/-/commit/6f70909303f32dbda6531c3921cc2772d2a5819b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178606)) **GitLab Enterprise Edition**
- [Allow access fields on Protection::TagRule to be null](https://gitlab.com/gitlab-org/gitlab/-/commit/9b50aa04af2a406da4dd84161a9a3712fc5a1d05) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178294))
- [Remove move_ai_tracking_to_instrumentation_layer feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/024aa1591ca793a598cdc445212601b5bef252f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176060))
- [Only claim human users as enterprise](https://gitlab.com/gitlab-org/gitlab/-/commit/1f70379bc5353f9f463ecdea9208d1e22e3c614d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178707)) **GitLab Enterprise Edition**
- [Update skip ci payload](https://gitlab.com/gitlab-org/gitlab/-/commit/f8936bf2a6f4f84adf05df98e3fb693074134ad5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178758)) **GitLab Enterprise Edition**
- [Improve heading hierarchy and accessibility on group import](https://gitlab.com/gitlab-org/gitlab/-/commit/77900b8c87a9e3683074d9de21f0d6112af51171) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178850))
- [Replace '.' character on organization path](https://gitlab.com/gitlab-org/gitlab/-/commit/7cc5261a6e01628c9792a30df292f013506d396f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176942))
- [Update SPDX to 3.26.0](https://gitlab.com/gitlab-org/gitlab/-/commit/1cb95e2b8f439ff2cea29a61d85a01b0a21420f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178747))
- [Show only folder name and a link to the folder in the environments list](https://gitlab.com/gitlab-org/gitlab/-/commit/6cee7a8a61f69c2afaab23421b0f5f6c24ada905) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178383))
- [Fix counter and remove first/last pages from applications](https://gitlab.com/gitlab-org/gitlab/-/commit/e48fc7cdbf3d2d0b5453e8b780b313217183ac3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178001))
- [Process repo_to_delete worker in a single batch](https://gitlab.com/gitlab-org/gitlab/-/commit/eed152dcdf7ebeb005a3fcb6be162bc0c60f3493) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177336)) **GitLab Enterprise Edition**
- [Resolve cross-joins from InstanceSecurityDashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/7435dd779418dfd1dcb896cbe25562e822079ca0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178422)) **GitLab Enterprise Edition**
- [Expand publish variables for pages deployment](https://gitlab.com/gitlab-org/gitlab/-/commit/31dde2b6f36abbd2ddbf4f8fd65f58e013459006) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176228))
- [Prevent creation of placeholder users for deleted users](https://gitlab.com/gitlab-org/gitlab/-/commit/64418acf386713ee42dcd80909f3ac4ae2bdab94) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177804))
- [Remove delete_inactive_project_bot_users FF](https://gitlab.com/gitlab-org/gitlab/-/commit/6dd16aa0bdb65169c4dc48059e140712e0a514d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178541))
- [Align deletion action between groups and projects in the settings page](https://gitlab.com/gitlab-org/gitlab/-/commit/a31c670604af833ccbae4110d6d6101f5cb326a6) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175873)) **GitLab Enterprise Edition**
- [Clean up duo_chat_storage_postgresql feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/e787c9b6a8e07ab27ee99390cfd205cabba70092) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178671)) **GitLab Enterprise Edition**
- [Update streaming filters docs links](https://gitlab.com/gitlab-org/gitlab/-/commit/c849b6b0240757405bb28719ce1258a61d0bd203) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178660)) **GitLab Enterprise Edition**
- [Add setup_for_company to onboarding status json](https://gitlab.com/gitlab-org/gitlab/-/commit/0fc8ade000f67e57aa7ab7210d7921cd225db94b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178655))
- [Show "delete model" and "version" links only with permission](https://gitlab.com/gitlab-org/gitlab/-/commit/85e3aa2e19c28f47bc28b9161f4f1576eec72677) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178161))
- [Add sast/dast identification on job](https://gitlab.com/gitlab-org/gitlab/-/commit/1eb05b445cfb495f034c7641a11f3b64ee33f9f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177924))
- [Remove retain_resource_access_token_user_after_revoke FF](https://gitlab.com/gitlab-org/gitlab/-/commit/80585cd90bf408e03754e4baef8a0ee049ccb66a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178587))
- [Remove policies check from pipeline tooling](https://gitlab.com/gitlab-org/gitlab/-/commit/bf8bb81136b2b203097e11de0066abffdc8f3465) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178612))
- [Add secret_token for compliance requirement controls](https://gitlab.com/gitlab-org/gitlab/-/commit/39260bb79457f5f001445e2119dc88849814cdda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178204)) **GitLab Enterprise Edition**
- [Hide "promote run" button when no permission exists](https://gitlab.com/gitlab-org/gitlab/-/commit/102e83ff3e9152ba30099f0ba70aa7b14d6dd64a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178400))
- [Extend DescriptionTemplate type to include category](https://gitlab.com/gitlab-org/gitlab/-/commit/5f94b1c8ff61b322ef701948601fa2a77e282533) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178340))
- [Add notes to mention permissions related to a DAST scan](https://gitlab.com/gitlab-org/gitlab/-/commit/ea911b3ab97698299402b5fe40b5e242e7e570d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178272)) **GitLab Enterprise Edition**
- [Add pending status for req. controls](https://gitlab.com/gitlab-org/gitlab/-/commit/ec958af6cdc47735f03bd3070215e0d033c85434) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178601)) **GitLab Enterprise Edition**
- [Remove search_mr_filter_author feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/a46a4e06faf26b03b43db37e0ea0210b525a86ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178418)) **GitLab Enterprise Edition**
- [Update license exceptions format](https://gitlab.com/gitlab-org/gitlab/-/commit/c1c32f2c964a8b47afe085b9804325c39666ecc8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178586)) **GitLab Enterprise Edition**
- [Remove enable_inactive_tokens_deletion_cron_worker FF](https://gitlab.com/gitlab-org/gitlab/-/commit/873b4572d3ab9df5db6deef806a8ac6e2414c9c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178548))
- [Fix jira api required field](https://gitlab.com/gitlab-org/gitlab/-/commit/a4d153e908a97d5ca7ac4023af2c9dbcff5d8cf1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178501))
- [Refactor where actions appear in the accessibility MR widget](https://gitlab.com/gitlab-org/gitlab/-/commit/ad3dd2e09eb185eb15f203d463fb471a4f499c4c) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178009))
- [Increase spacing between to-do link and actions](https://gitlab.com/gitlab-org/gitlab/-/commit/e3fa439c8486fb0a8d0e8c3248819063f370fc1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178469))
- [Hide "Delete experiment" for model experiment without permission](https://gitlab.com/gitlab-org/gitlab/-/commit/05cdd0ad6bd7ebc88bda38d23701f89c9a147f78) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178160))
- [Added ability to close the board modal with esc or background click](https://gitlab.com/gitlab-org/gitlab/-/commit/8ed48a58d373c44eaef3329f8b7053d28462648c) by @zillemarco ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177917))
- [Remove deprecated and disabled SAST jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/ac9163e7495bf9e97ee4fff3e47c7eef0d4668a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178093))
- [Bump nokogiri to v1.18](https://gitlab.com/gitlab-org/gitlab/-/commit/21767d759eee1bdd6b41cc0cd98283e302edd332) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177832))
- [Refactor scheduling service to use dispatch helper](https://gitlab.com/gitlab-org/gitlab/-/commit/20e9d30fe5a0e993a43d202fbe9ca3c82edcac2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178068)) **GitLab Enterprise Edition**
- [Update error message when password validation fails](https://gitlab.com/gitlab-org/gitlab/-/commit/9e218cb5eadce64dbe027819ee78326519b7d43c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178212)) **GitLab Enterprise Edition**
- [Remove cross-join from .grades_for with instance](https://gitlab.com/gitlab-org/gitlab/-/commit/eac5c394df278311f181d7ca4c191919c5790cb2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175602)) **GitLab Enterprise Edition**
- [Add new workspace_variables query API](https://gitlab.com/gitlab-org/gitlab/-/commit/68e5df4ce0ac7560b43df6fffe5ca15a70806ed9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176617)) **GitLab Enterprise Edition**
- [Return all validation errors when manual vulnerability creation fails](https://gitlab.com/gitlab-org/gitlab/-/commit/17e1fe4512a1493be6d433363467a946f4b8f7a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178321)) **GitLab Enterprise Edition**
- [Remove unused prop](https://gitlab.com/gitlab-org/gitlab/-/commit/4a7e36f410cc0a9466167b94dc76e7c92deddebe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175016))
- [Get group grades using vulnerability statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/a645327bd838f9ae5bb2c63ee396af69d875d071) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178024)) **GitLab Enterprise Edition**
- [Remove alert_message_faq from storage banners](https://gitlab.com/gitlab-org/gitlab/-/commit/a47d2a61ca95aa5119f4c07cdce7c0ae930c7936) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177548)) **GitLab Enterprise Edition**
- [Save the LDAP tab pressed in cookie](https://gitlab.com/gitlab-org/gitlab/-/commit/449e4329fe2f660aaec1d35cd421c3b6ea99a36b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178285))
- [Change registry protection rule admin text to Adminstrator](https://gitlab.com/gitlab-org/gitlab/-/commit/59039cb4f4b9f7281a703f2ac29bcb709fee7059) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177822))
- [Update spacing](https://gitlab.com/gitlab-org/gitlab/-/commit/7da90ebc36611dcde05db21466d3ee781f569e82) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177598))
- [Enable the highlighting and memoization of admin tabs](https://gitlab.com/gitlab-org/gitlab/-/commit/1afe3eb9faaf0f7d068492a54e2c20c8f81d8b19) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178227))
- [Update dependency auto-deploy-image to v2.118.0](https://gitlab.com/gitlab-org/gitlab/-/commit/6084fb4b6b4bf994dc0eecb305d7010e1230d278) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176171))
- [LicenseScanning Report refactoring](https://gitlab.com/gitlab-org/gitlab/-/commit/bc064752a7938f8ea54054007c83a24eb97274df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178236)) **GitLab Enterprise Edition**
- [Update pre-populated branch name when user can push to branch](https://gitlab.com/gitlab-org/gitlab/-/commit/f36ba81ab3ab83f80e0827a6751cffe52568b9ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177626))
- [Warn user if iteration has confidential issues they can't access](https://gitlab.com/gitlab-org/gitlab/-/commit/e02799bc74a642c5e11882cb9a8664b552b832fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177324)) **GitLab Enterprise Edition**
- [Replace paginator for keyset paginator admin applications](https://gitlab.com/gitlab-org/gitlab/-/commit/4480b38758533ee86872f536a2d4d812bcf6fe0c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178216))
- [Use page heading component in feature flags list view](https://gitlab.com/gitlab-org/gitlab/-/commit/1741fa717525979723f45e7c060c4f292c7aa15f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177606))
- [Model Registry: Rename candidate to run](https://gitlab.com/gitlab-org/gitlab/-/commit/c6ec750f706472d4e9e5d58414f67a4b7f7c9b2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178158))
- [Show agent version warnings from KAS](https://gitlab.com/gitlab-org/gitlab/-/commit/538d4f63763e401c19b3372c89b34de588a5d327) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175419))
- [Add separate tabs for project and shared agents](https://gitlab.com/gitlab-org/gitlab/-/commit/d367829d1a98b40bb1b6855941d2f13f9d05e9d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177776)) **GitLab Enterprise Edition**
- [Topics subpage: Cleanup and layout refinements](https://gitlab.com/gitlab-org/gitlab/-/commit/efc40d523b19e28b93af7ae7d997f4e037f7e622) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177735))
- [Add index to import_source_user_placeholder_references](https://gitlab.com/gitlab-org/gitlab/-/commit/a19d12399ebd716d8b30f8abd5369bd5da301437) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177908))
- [Set traversal_ids upon vuln statistics ingestion](https://gitlab.com/gitlab-org/gitlab/-/commit/58e79bd253cfe2617963562bee117b80a2e7b06d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178125)) **GitLab Enterprise Edition**
- [Move conan v1 search endpoint to conan shared endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/7491d190e84e98a474dd341866b634df85530b5e) by @oceane_scania ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177226))
- [Get group grades using vulnerability statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/06a459c696b129930da7bf0843a14ade7eb0b6c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177892)) **GitLab Enterprise Edition**
- [Support multiple oidc providers](https://gitlab.com/gitlab-org/gitlab/-/commit/96592394aac78974b53072c42dcc81d3f0806fdc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/138734)) **GitLab Enterprise Edition**
- [Process repo_to_index event with one batch at a time](https://gitlab.com/gitlab-org/gitlab/-/commit/67c1050899ebe1af8a49101dc35eff3dab890e3e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177337)) **GitLab Enterprise Edition**
- [Use page heading component in compliance center dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/0bd4f92a03a5a23e43183c101b9e2b745bfa1245) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177611)) **GitLab Enterprise Edition**
- [Replace VulnerabilitiesFinder with VulnerabilityReadsFinder](https://gitlab.com/gitlab-org/gitlab/-/commit/be1f80f0cb6062443d8c79453b3ebaf64d1fd3f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175947)) **GitLab Enterprise Edition**
- [Generalize relationship quick action copy](https://gitlab.com/gitlab-org/gitlab/-/commit/04ddcc20b3e2d130f089709e1c2d2ecd3a45d166) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177506))
- [Move full page tooltip to right](https://gitlab.com/gitlab-org/gitlab/-/commit/5278fc367f4c151ca1417c0d532a45f3026ba868) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177893))
- [Drop ipaddr as a dependency](https://gitlab.com/gitlab-org/gitlab/-/commit/c686572c634887d56b4fbe184ed5ca7fbb5f931c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177833))
- [Expose linked work item state on LinkedItemType](https://gitlab.com/gitlab-org/gitlab/-/commit/044545504eb79a71eb9e24a2c9cd44a731f3d106) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176449))
- [Move Seat Control to licensed feature](https://gitlab.com/gitlab-org/gitlab/-/commit/2d40d3354c03d374497912251012bc1cf63ae5da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177379)) **GitLab Enterprise Edition**
- [Add an icon to the bypassed reviews event in the MR timeline](https://gitlab.com/gitlab-org/gitlab/-/commit/005c78dc41ec6b497cd18d46a96958ea2b2c3f8e) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177675))
- [Change checkbox placement in Artifacts stacked view](https://gitlab.com/gitlab-org/gitlab/-/commit/0390aa87e42568e468c5ba9ac69780634176b2e8) by @Deepak18-06 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164674))
- [Remove job token auth feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4ef775a78dc64305987ec24f657df50f2d34db45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177796))
- [Unhide container repository protection rules API](https://gitlab.com/gitlab-org/gitlab/-/commit/9410666adc4dea3843e6f1c5a9adb8fab6246866) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177673))
- [Switch from delete_all to destroy_all for user add-on assignments](https://gitlab.com/gitlab-org/gitlab/-/commit/8454058ef90a9fd9e7250d79e15a119e70d2319f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177421)) **GitLab Enterprise Edition**

### Deprecated (5 changes)

- [Add deprecation announcements for DS build support and Gemnasium](https://gitlab.com/gitlab-org/gitlab/-/commit/6f47693b764200bb1e859cb965bee9427b11bead) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178084))
- [Geo GraphQL API: Deprecate keyword arg](https://gitlab.com/gitlab-org/gitlab/-/commit/08353244cd5218dbb453eb521bd945158e531ab6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180479)) **GitLab Enterprise Edition**
- [Fix deprecated field name](https://gitlab.com/gitlab-org/gitlab/-/commit/5bbb9b65c9ad7a73d73a88dd85cc2a0aa1150b6b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180181))
- [Redirect page visit on group projects page to the group overview](https://gitlab.com/gitlab-org/gitlab/-/commit/18f61d737d8e5f74efd5309403210cb58c6c2202) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179339))
- [Ignore confidence columns on Vulnerability model](https://gitlab.com/gitlab-org/gitlab/-/commit/517e0b69180edd7e2db985b6b38ee11798e6900b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169303)) **GitLab Enterprise Edition**

### Removed (24 changes)

- [Remove rake task to enable or disable work item epics](https://gitlab.com/gitlab-org/gitlab/-/commit/cddde54fef5a5b792b22f942730d1288565e3a5b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181641)) **GitLab Enterprise Edition**
- [Ignoring expression and type column from requirement](https://gitlab.com/gitlab-org/gitlab/-/commit/9da46e715aa37934639a417c4face156a573bf4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180549)) **GitLab Enterprise Edition**
- [Remove availableFromAccessLevel field](https://gitlab.com/gitlab-org/gitlab/-/commit/f85416708c4b520c109dc26d7eaaccaaedc7134f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181014)) **GitLab Enterprise Edition**
- [Remove buildForecast graphQL endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/e9686da31ae79747287f6a7c1a8762d8281b9850) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180932)) **GitLab Enterprise Edition**
- [Remove All tab from To-Do dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/0315ffeeb10a57b63ab83d1e4bce15716916bbb9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180589))
- [Removed feature flag by_pass_two_factor_for_current_session](https://gitlab.com/gitlab-org/gitlab/-/commit/669684f3bfbe765a99c80a5bec4cc8a3853e5323) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180968))
- [Remove richText from bloblSearch graphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/136ca3261f8adb8bb4125fc778c6e9f5ebc6f0a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180631)) **GitLab Enterprise Edition**
- [Remove epic_metrics table, models and associated references](https://gitlab.com/gitlab-org/gitlab/-/commit/35969dd2061ba03f983bfca23ae4bb538eebf2dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179477))
- [Remove web_ide_settings_context_hash feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/db6e46b374dcbcf1bdb8da4f294de3d20d368701) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180261))
- [Remove scan_execution_pipeline_concurrency_control ff](https://gitlab.com/gitlab-org/gitlab/-/commit/a789f0667984cb673f0a316a48dbaac80107ec71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180271))
- [Remove temporary indicies from packages_dependencies table](https://gitlab.com/gitlab-org/gitlab/-/commit/a2ab3d2934dbc512d4858df0b3507c0cca626221) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180068))
- [Revert "Merge branch 'autoflow/basic-workitems-events' into 'master'"](https://gitlab.com/gitlab-org/gitlab/-/commit/86932b640d5b66016fdd15a48bfabd84cf0de0f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179738))
- [Add post-deploy migration to drop unused column](https://gitlab.com/gitlab-org/gitlab/-/commit/a953059e6d1b315711ac315ba32acce3dfb9499d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179672))
- [Remove function-based namespace lookups](https://gitlab.com/gitlab-org/gitlab/-/commit/e2b24e2e22b9ca305c5394d0ed3b5b81ffefb03d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179582))
- [Ignore sep max_concurrency application setting](https://gitlab.com/gitlab-org/gitlab/-/commit/b6b93d1b7a6dfef41ade5087989c3c6a7398a0a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178926)) **GitLab Enterprise Edition**
- [Removed the ignore rule for dropped column](https://gitlab.com/gitlab-org/gitlab/-/commit/b6c24134e6027be0ff8a76bb1625c8577e7d1cda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178634)) **GitLab Enterprise Edition**
- [Remove todos_vue_application feature flag and all inactive code](https://gitlab.com/gitlab-org/gitlab/-/commit/693fdd971c102dbea090265330fc48b79c8463b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175863))
- [Remove `index_vulnerabilities_on_detected_at_and_id` synchronously](https://gitlab.com/gitlab-org/gitlab/-/commit/eafdd7f3a291b56b9d4d339d3db9e27262878d06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178444))
- [Remove license_scanning_with_sbom_licenses feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e86dfe29cafdabdc07ef379ea82ab2c5281a0dcb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172437))
- [Remove sep scheduled scans application settings unused view](https://gitlab.com/gitlab-org/gitlab/-/commit/41059c39126eb43c8178f44b7c99d8179b1ad6c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177502)) **GitLab Enterprise Edition**
- [Remove hybrid search](https://gitlab.com/gitlab-org/gitlab/-/commit/4427c4367181f3c87da434006cf08ddbfd1ad045) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178151)) **GitLab Enterprise Edition**
- [Drop advanced_scopes from personal_access_tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/9ccd253eb52146d0961e2fe71a71eb6ad31b139b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178110))
- [Remove failing merge request approval rules metric](https://gitlab.com/gitlab-org/gitlab/-/commit/03c4913f0fb7e4cc99c6e3fc17ed0531b897b614) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177494)) **GitLab Enterprise Edition**
- [Remove broken compliance_total_unique_counts weekly, monthly metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/fb1a1b8c60a7b6c7ff707eefab324b8ecb60ff79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175901)) **GitLab Enterprise Edition**

### Security (15 changes)

- [Revert "Update Kas version to the lastest sha"](https://gitlab.com/gitlab-org/gitlab/-/commit/c89db5ed4a62eb58c81030f453d25741a138dc03)
- [Do not allow Planner role to update or delete incidents](https://gitlab.com/gitlab-org/gitlab/-/commit/96c29d4cea022495546617429116226c65b6c779)
- [Reduce number of object allocations on PAT endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/6f4aea90bd0b6bfe61109173aaeb422d05e6f870)
- [Prevent SSRF attacks for Workspaces](https://gitlab.com/gitlab-org/gitlab/-/commit/277faf3747bcc4b6d4beb9d04548c1037ac28840)
- [Security Duo Chat Escape Unknown Domain Hyperlinks](https://gitlab.com/gitlab-org/gitlab/-/commit/babc054870124dc9faad58f9580ca5cd1d48d9c4)
- [Fixes XSS on the target branch in the merge request widget](https://gitlab.com/gitlab-org/gitlab/-/commit/e5f4d1cdbaf813741491013e4c2ab2a5ec758ba0)
- [Prevent read code access when repository is disabled](https://gitlab.com/gitlab-org/gitlab/-/commit/047963e52d1905b2c053c02e014f09c4150a7682)
- [Unsubscribe from actioncable channel when PAT is revoked](https://gitlab.com/gitlab-org/gitlab/-/commit/74adac8edd65cd3cb830e1674f540ee2566d749c)
- [Update Kas version to the lastest sha](https://gitlab.com/gitlab-org/gitlab/-/commit/55609a21ea82501fb0ec4ce8b33e318c764a9e6c)
- [Add offset optimization to audits event API](https://gitlab.com/gitlab-org/gitlab/-/commit/d6fa8fa871e821f805e55f65405ba23bb977d6eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178619)) **GitLab Enterprise Edition**
- [Fix protected variable exfiltration](https://gitlab.com/gitlab-org/gitlab/-/commit/cea3d30eca2ebb9aedd749a4f43f98e328eef350) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179611))
- [Avoid recursive sidekiq calls on cyclic work item hierarchies](https://gitlab.com/gitlab-org/gitlab/-/commit/9d135851bac232665aeadceba56c12104c9ea625) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179611))
- [Enhance rich viewer sanitization](https://gitlab.com/gitlab-org/gitlab/-/commit/2841af0777cef60413aae3ce6844871defa41a4d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179611))
- [Respect the private profile constraints](https://gitlab.com/gitlab-org/gitlab/-/commit/d589410f5a99fc6a5c0b6e524e7255f6f0b6a49b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179611))
- [Reduce REGEXP_TIMEOUT_SECONDS to 40 seconds](https://gitlab.com/gitlab-org/gitlab/-/commit/d2fc6336b69f407a85791ec3b7c5196e3102a31d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177104))

### Performance (11 changes)

- [Optimize build.execute_hooks when creating pipeline](https://gitlab.com/gitlab-org/gitlab/-/commit/45035a5245db22e4ed74e7fa7b8090e8e5881943) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180687))
- [Set idempotency_arguments to SyncProjectPolicyWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/85d166340df03146803e63c579121d34f69076c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180807)) **GitLab Enterprise Edition**
- [Fix cache of branch_requires_code_owner_approval?](https://gitlab.com/gitlab-org/gitlab/-/commit/7e5c090b672f377b3ce9dfdbdbd32f00b4a853c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179697)) **GitLab Enterprise Edition**
- [Reduce N+1 in project GraphQL project queries](https://gitlab.com/gitlab-org/gitlab/-/commit/e069f4f163556c196ebf480096a841a80b122a02) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179330))
- [Update import_failures sharding](https://gitlab.com/gitlab-org/gitlab/-/commit/e50235c033fb5f544fcdf765f0445c487b3bcf92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168393))
- [Share preloads across multiple GraphQL project resolvers](https://gitlab.com/gitlab-org/gitlab/-/commit/bf32e7ecdd878abc22d97ef8e30fa4ba51b9fe4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178978))
- [Remove auto_merge_process_worker_pipeline feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/12b04a6a1940e82c426de20582719ebfb5f052b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178960))
- [Replace check_rate_limit! with check_rate_limit_by_user_or_ip!](https://gitlab.com/gitlab-org/gitlab/-/commit/c0966deb97a024268264261b0c9e2c8b3c340688) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178698))
- [Remove check_oversized_blobs_without_blob_stitcher ff](https://gitlab.com/gitlab-org/gitlab/-/commit/d52e793e4dfc12ec4c3f6168e0e00e15171e7930) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178538))
- [Improve resolved vulnerabilities performance with SM-specific index](https://gitlab.com/gitlab-org/gitlab/-/commit/18fdf4440e5fb1bfaea76227f8846cd81ecde826) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176561))
- [Create system_hooks table](https://gitlab.com/gitlab-org/gitlab/-/commit/a458033864081335284f266a5e049eddb79df57a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175729))

### Other (283 changes)

- [Add Telegram instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/394bb24682fa2dfd0875e163d0e69d00fb51f65d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179361)) **GitLab Enterprise Edition**
- [Add sharding_key to board_labels table](https://gitlab.com/gitlab-org/gitlab/-/commit/d4a3c5c55e2ff2cc65aca58cf074d3f1534dc915) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180642))
- [Validate not null on vulnerability_finding_evidences sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/92a224568bf154feddd978c563e9131fbcaaf520) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179802))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/e9c7395aad1295c8273e514e0750a6c671e73890) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181656))
- [Finalize migration BackfillIssuesDatesWithWorkItemDatesSources](https://gitlab.com/gitlab-org/gitlab/-/commit/229253de212912cf19b21496656abbbca3bf5f8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177108))
- [Remove deprecation notice for runner fields in REST entity](https://gitlab.com/gitlab-org/gitlab/-/commit/ccf62b7e357cfb0fb49dd00b68d38d79a8ffb2cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181507))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/07a2e9f9868318eb77e68dffdb6d6ae43a18466a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181345))
- [Finalize migration BackfillWikiPageSlugsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/30e55f7585b0c1105a1bf5feb57ff991d6dd0975) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177106))
- [Set pipl user soft deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/5f42e8b268021dc7af1d6b5acb4e4911a7efab11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181112)) **GitLab Enterprise Edition**
- [Add MicrosoftTeams instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/a401d57449e004f0cee509d2af57086d105236e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179510))
- [Address non-blocking comments](https://gitlab.com/gitlab-org/gitlab/-/commit/dafba28a6d912b7ecc37a39af14bb43924cb1f6e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181409)) **GitLab Enterprise Edition**
- [Add new CDot internal endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/0a9a74fad8114a606d8cb44788124604881b33e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180980)) **GitLab Enterprise Edition**
- [Sync setup_for_company in user_preferences and onboarding_status](https://gitlab.com/gitlab-org/gitlab/-/commit/a1d6499bd848592ea04ff15e4680853b34c40a5c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179314)) **GitLab Enterprise Edition**
- [Fix rubocop offenses for conan package tests](https://gitlab.com/gitlab-org/gitlab/-/commit/e79b188473dd83e0a726099e92f6564fe7b83c8f) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181117))
- [Expose project/root_namespace ids for Workhorse requests](https://gitlab.com/gitlab-org/gitlab/-/commit/530bd18faf94c7f585559148f5ecd53b87274b19) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/150337))
- [Remove numbers from alerts integration settings](https://gitlab.com/gitlab-org/gitlab/-/commit/4f06441cf93e2e38da882e554ea930f2cbc4a179) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181291))
- [Remove current_page_context_prompt_in_aigw feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/dc3a89a7d919493b03a447ab7e251a265ca9af56) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181273)) **GitLab Enterprise Edition**
- [Remove Search::Zoekt::IndexOverWatermarkEventWorker job instances](https://gitlab.com/gitlab-org/gitlab/-/commit/107a89f2c3e325c454c403eb5eae620d3fe4a0d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181258))
- [Reject API calls from orphaned project runners with HTTP 403](https://gitlab.com/gitlab-org/gitlab/-/commit/63cdafa71506f3010c1be6d99fc2203f5b4570c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180918))
- [Add and backfill namespace_id for design_management_repository_states](https://gitlab.com/gitlab-org/gitlab/-/commit/f6a78a4b95a83d584139f002fd5fc4bfc909d502) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180426))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/84c56408940e120d1a36f694c4e444d14e66b8a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181051))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/bcb0f3b6cfb3c1c0157cb4f6fcf96bddbefd0ad9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180233))
- [Finalize migration BackfillZoektReplicas](https://gitlab.com/gitlab-org/gitlab/-/commit/30f834fda8794352de8512f2648f98b31b99700f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181210))
- [Finalize migration BackfillPackagesDependencyLinksProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/53b57c46287fc7b5b03d01cc6a56e061d69167e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181206))
- [Finalize migration BackfillPackagesDebianProjectComponentsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/7c6407a123064ebac47b60f8422c60d624d5a15a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181205))
- [Add & backfill sharding keys for bulk_import_failures](https://gitlab.com/gitlab-org/gitlab/-/commit/789f0f980e19aeb99c88a5187d91d86e0114c0b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180435))
- [Model registry: Remove unused components](https://gitlab.com/gitlab-org/gitlab/-/commit/9593840707a61ddb268b8f1c95d67273a77753b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181131))
- [Add Teamcity instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/aa871b2d7f83f8d169778d27d9733a2a7f4e2f40) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178920))
- [Add a migration to limit group visibility by organization visibility](https://gitlab.com/gitlab-org/gitlab/-/commit/497bbcc6412f73b3e6b608bbae088a0aa4a559ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179827))
- [Set packages_debian_project_architectures.project_id as NOT NULL](https://gitlab.com/gitlab-org/gitlab/-/commit/ecc1c3d91e975b21ae64b47ba3c71d1581ee4dd1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181065))
- [Add NOT NULL constraint on packages_debian_group_architectures.group_id](https://gitlab.com/gitlab-org/gitlab/-/commit/0e06b4b843c79e0b43b1a5785666d4cee8dc4103) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181062))
- [Add NOT NULL constraint on packages_conan_metadata.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/8d43a17278c06e3cc7ba5460c3a89b20994e3ac6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181061))
- [Set external_status_checks_protected_branches.project_id as NOT NULL](https://gitlab.com/gitlab-org/gitlab/-/commit/d83381aeddbd4469836cf661140b4a0c151346a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181060))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/07f6c6500aeeeeb4eca90b5991f2772c3c329bd5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180874))
- [Validate NOT NULL on vulnerability_findings_remediations sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/0188d5ba1b557073f6fe5238c9648d8fa38cc401) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180698))
- [Validate NOT NULL on terraform_state_versions sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/f73aab982ab39bbf8dcb71c7f08ab232f550512d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180699))
- [Add unique constraints on ci_runners_e59bb2812d partitions](https://gitlab.com/gitlab-org/gitlab/-/commit/6f943a68c4741d1cc740c16dcee009deac683f21) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180721))
- [Add ExternalWiki instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/b27aed0b35963486f037325e8b5535508511cdd3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178723))
- [Remove search_group_sso_redirect feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/58430e78b8944270332bdd6056888b412f679a12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180750)) **GitLab Enterprise Edition**
- [Remove search_global_sso_redirect feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/fa4b9a22532a728d7754577b7f20f37c23616cb4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180748))
- [Add Harbor instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/e37a19936a5657f9d61b9ba8dee12c97b3cf8b5e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178895))
- [Use ResetAuthenticationTokenService in Runner API](https://gitlab.com/gitlab-org/gitlab/-/commit/4b5b546b2baa3856ccc8d860bc45e18d29370022) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180365))
- [Validate NOT NULL on wiki_repository_states sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/ce1f4c9abd2ce52a504394c3b63644461f2e4fd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180700))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/f7c59ccd03152e00a5f9a1e6754b318b7bb4ad32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180943))
- [Cleanup feature flag ff_pages_use_open_file](https://gitlab.com/gitlab-org/gitlab/-/commit/dc2dfcd69c62d2399e579006e7bce37951bb4be5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180926))
- [Validate NOT NULL on work_item_parent_links sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/20ca5bb3701f21a33bb27ae7cfe8c3e98af89427) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180915))
- [Validate NOT NULL on approval_project_rules_users sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/2dd29ce8a65960b4877de8eb788823fd6a2ce2e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180908))
- [Validate NOT NULL on approval_merge_request_rule_sources sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/80f92b08ae80023a4c78fc144163949133b685c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180906))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/643b4f09e052b89fab01e3f60734ebe9a014882e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180820))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/6dd1c1fe592cce48d1871406775ec91829cc7ff3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180819))
- [Add EmailsOnPush instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/f4a911f73c5d7808a3b7f9e87d30a5f677ff4b8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178460))
- [Add and backfill project_id for merge_request_cleanup_schedules](https://gitlab.com/gitlab-org/gitlab/-/commit/d97485474fe4af3423543a3c3d399f2d3360534a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180840))
- [Add & backfill sharding keys for bulk_import_trackers](https://gitlab.com/gitlab-org/gitlab/-/commit/eb3e6e26d792e2b39b72e9e1af5f648b8d571f31) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180437))
- [Add and backfill project_id for merge_request_predictions](https://gitlab.com/gitlab-org/gitlab/-/commit/5bde5a0fd8b82d288e0fe50d8bc9f340f9766ef7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180839))
- [Add and backfill project_id for requirements_management_test_reports](https://gitlab.com/gitlab-org/gitlab/-/commit/f1f90901e1dcd89ca06891f0e1cb51c84a63e9b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180838))
- [Add and backfill namespace_id for design_user_mentions](https://gitlab.com/gitlab-org/gitlab/-/commit/f161cf269bdf41d631b7179505dfbc0269d3c6aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180837))
- [Admin Token API: Revoke Impersonation tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/fa3555c11e65fffddf58cf85373ac2c714c0c1ee) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180745))
- [Add NOT NULL constraint on approvals sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/68aec3940a1095753619849f9fa543b2c702c677) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177402))
- [Validate NOT NULL on vulnerability_finding_signatures sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/20e396173dff1fa1b7a404781832980d0b7ad4e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180692))
- [Add NOT NULL constraint on ml_model_metadata.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/6ef1b13948de9c0e6211d7e28bf84998e9da70d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179816))
- [Requeue backfill for target_project_id on ComplianceViolations table](https://gitlab.com/gitlab-org/gitlab/-/commit/30c2d30f5f525aad5deccd11d7297ac80dd7a9b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180053))
- [Refactor NuGet package enqueuing](https://gitlab.com/gitlab-org/gitlab/-/commit/60c426dc2182e4d3027362f1834d62c30c8ba772) by @holtvogt ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170649))
- [Add Discord instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/a35e764f30106abd9a7dfbbea6b1cfd33f7653f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178313))
- [Add and backfill project_id for operations_scopes](https://gitlab.com/gitlab-org/gitlab/-/commit/2be897fcaa970746cf359680b854e96f1963726a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180223))
- [Add and backfill project_id for merge_request_diff_details](https://gitlab.com/gitlab-org/gitlab/-/commit/d22e78e61eb5a1cb193a82a794c32379b07aa464) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180428))
- [Add & backfill sharding keys for bulk_import_export_batches](https://gitlab.com/gitlab-org/gitlab/-/commit/9aea28f1fb2110b01a83245ce53a398f280620fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180432))
- [Add & backfill sharding keys for required_code_owners_sections](https://gitlab.com/gitlab-org/gitlab/-/commit/680051f9862194503da017d2217933308fefaba3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180440))
- [Mark 20241025160103 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/eb9e5c0e091fd29a8a4297f55f7050fb88ca74c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180209)) **GitLab Enterprise Edition**
- [Mark 20241106201829 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/ce8b72a008b8cf757134f8218a2e25cab35d1c6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180211)) **GitLab Enterprise Edition**
- [Add and backfill namespace_id for design_management_designs_versions](https://gitlab.com/gitlab-org/gitlab/-/commit/63c5d772706cae84776db17804c4dc51febe6872) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180220))
- [Validate not null on sbom_occurrences_vulnerabilities sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/68265ff0d5d16c5db5b218d4dd1711780b9c8c58) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179798))
- [Add & backfill sharding keys for snippet_repository_storage_moves](https://gitlab.com/gitlab-org/gitlab/-/commit/d2195c80d81f5e0cb3ca8f300734874bdff1558d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180441))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/1c533c6f6163dc4e56e4d8eb9388b69839557ce5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180489))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/f9d94114531036aa118c1c25ed369de95b05a545) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180232))
- [Remove vulnerability_report_security_scores feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/1e1624fc4c949e5a3ce3a12482787a1fcace1c68) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180447)) **GitLab Enterprise Edition**
- [Reindex Elasticsearch projects index to update integer with long type](https://gitlab.com/gitlab-org/gitlab/-/commit/22f8a5431d535c677c13461ec4c5715316e252e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180165)) **GitLab Enterprise Edition**
- [Reindex Elasticsearch users index to update integer with long type](https://gitlab.com/gitlab-org/gitlab/-/commit/5da816f4ab67fb65a537330b488348782db62db0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180178)) **GitLab Enterprise Edition**
- [Remove `sourcegraph` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/8c9cdd9df086c6191643b3c1d2933aa63ca90432) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173712))
- [refactor: Use BaseProjectService for container protection services](https://gitlab.com/gitlab-org/gitlab/-/commit/e9694d06c385b843d892c214f7f70f553783a4d1) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180386))
- [Protected packages: Remove deprecation warnings in GRAPHQL](https://gitlab.com/gitlab-org/gitlab/-/commit/0e59997cd265ff15b22114345812ffc6675a34b2) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180372))
- [Change FF ownership](https://gitlab.com/gitlab-org/gitlab/-/commit/e5a43acd604fcb754e683cd3f56ccc80297c6eea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180355)) **GitLab Enterprise Edition**
- [Delete track_user_access_from_pipl_countries FF](https://gitlab.com/gitlab-org/gitlab/-/commit/28f1bb7b79df3d64d1065f213e7b8129a7b147c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180358)) **GitLab Enterprise Edition**
- [Mark 20241105111645 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/ca4b2f9c98b12817819c4449430e2408b4c8a560) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180210)) **GitLab Enterprise Edition**
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/5d14d1300261e6678e521a3c345acd4608c5ea64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175841))
- [Add milestones not null sharding key constraint](https://gitlab.com/gitlab-org/gitlab/-/commit/e5cbda153f88c9ef8ba14d57cbf306f15e866fac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179791))
- [Instrument the creation of CI runners](https://gitlab.com/gitlab-org/gitlab/-/commit/e5215d8d81f110be7061f7ddc40a3729a00cf3a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179876))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/683257901596c5866198a209b94208ce2019b273) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180248))
- [Add and backfill group_id for boards_epic_list_user_preferences](https://gitlab.com/gitlab-org/gitlab/-/commit/98722aad8dc8e147fcdb3a22d217379e5044514f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180037))
- [Extend SyncNamespaceService for add-on purchases](https://gitlab.com/gitlab-org/gitlab/-/commit/513b625b2a90d06053c13e417878404bfb26787e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179667)) **GitLab Enterprise Edition**
- [Add and backfill project_id for dast_pre_scan_verification_steps](https://gitlab.com/gitlab-org/gitlab/-/commit/01061bad39fb4cefa39d91730b6865cd7e73a2de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180046))
- [Reindex Elasticsearch wiki index to update integer with long type](https://gitlab.com/gitlab-org/gitlab/-/commit/689152bcf724fd6d938f2a319bfbf85f28f1e4de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180023)) **GitLab Enterprise Edition**
- [Add Confluence instance integraiton model](https://gitlab.com/gitlab-org/gitlab/-/commit/efe3bc858502348b5ccbe17abd43b874d01def71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179500))
- [Add sharding key to board_assignees](https://gitlab.com/gitlab-org/gitlab/-/commit/c9773b4e168cd0cba3c6eefb7463b857776f9a11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178949))
- [Set sharding key for merge_requests_compliance_violations](https://gitlab.com/gitlab-org/gitlab/-/commit/0a6a1d20a7973dbcdffba4b2a66564685e256cf2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178769))
- [Fix Layout/LineLength offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/b83474fe688ca025b63538bdb7eaa721ab61eef3) by @ikelax ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169988))
- [Add new provision service](https://gitlab.com/gitlab-org/gitlab/-/commit/10484bec1461437e282be0cfd0f4864b65d07537) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178532)) **GitLab Enterprise Edition**
- [test: Improve readability of test by applying table syntax](https://gitlab.com/gitlab-org/gitlab/-/commit/9d150b29950176b9a19c61e462a610f8a3fb1bd1) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179518))
- [Remove start and due date widget from incident WIT](https://gitlab.com/gitlab-org/gitlab/-/commit/d40b31788b76d44efcd72cd1acd4e362760d7192) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180002))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/121897473d6152994d061ff201cd4d3eb66d5929) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180003))
- [Add NOT NULL constraint to release_links.project_id column](https://gitlab.com/gitlab-org/gitlab/-/commit/b67da92b8fbdef3b44485fb94c8bd248f99f4fe2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177235))
- [Add NOT NULL constraint on draft_notes.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/0b4bb46dd01704ec5753f334ffd72711f1673664) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177403))
- [Fix 20 rubocop violations for Layout/ArrayAlignment](https://gitlab.com/gitlab-org/gitlab/-/commit/297c8179c1eea1683a0990c07c53d777d7a6981e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179945))
- [Add project_namespace_id_from and project_namespace_id_to](https://gitlab.com/gitlab-org/gitlab/-/commit/34844d1c7dfe1d9512fac9b6eae9f74ab5eafaa8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179558)) **GitLab Enterprise Edition**
- [Extend documentation for includes in code blocks](https://gitlab.com/gitlab-org/gitlab/-/commit/e3bfef24e98b0b29236f5facfe5a0eeeac23d478) by @schurzi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179571))
- [Mark 20240814223217 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/24930e28bff39fbd2aba3f228efc3257a9f8be6b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178353)) **GitLab Enterprise Edition**
- [Add NOT NULL constraint on ml_candidate_metadata.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/e9a445a37ec0f40913c1ea37f9ec1daa0353b869) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179814))
- [Add FK back to issues.work_item_type_id](https://gitlab.com/gitlab-org/gitlab/-/commit/ff2878f48c843cd7fc38a89505a9b8c15734b856) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178495))
- [Add NOT NULL constraint on merge_request_blocks.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/275fadb87a1d3a5d05a30d5c9068aeb9d48b45bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177399))
- [Create siphon tables for namespace details and bulk imports](https://gitlab.com/gitlab-org/gitlab/-/commit/d255645902f3cf5ace52846b086005f4de3cb06a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179726))
- [Add NOT NULL constraint to boards sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/ec3e6f8822bcdbdc7c86cb28601fee40dcb6499d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179112))
- [Remove vulnerability_filtering_by_identifier feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/1761599e30a460a805893129ed9de76985ec5393) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179525)) **GitLab Enterprise Edition**
- [Add custom fields widget to all work item types](https://gitlab.com/gitlab-org/gitlab/-/commit/d7f5cfcaffdb7f542010866cb1da4f8c7b832899) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176206))
- [Partition Manager to automatically attack LFK trigger to new partitions](https://gitlab.com/gitlab-org/gitlab/-/commit/b5f7e144a29f359100daff4bf7d5a7f66dcce912) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175310))
- [Remove duplicate shared spec](https://gitlab.com/gitlab-org/gitlab/-/commit/237d7898012050db19cde69a880fef54489bdd8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179705))
- [Finalize migration BackfillPackagesDebianProjectArchitecturesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/f3aea4ac41401beff21677a7c0179a48983ffa79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178652))
- [Add trigger token expiration](https://gitlab.com/gitlab-org/gitlab/-/commit/e6e7076f775930c802ffcbbede986aef28e102c9) by @william.allen1 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/146912))
- [Add not null constraint on vulnerability_finding_signatures.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/2df4fea30d70ffc96ffa8eeac059b603867820f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177376))
- [Add NOT NULL constraint on approval_merge_request_rules.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/827d3f28a4db1be0c2c5c95ff70b4614bc609524) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177401))
- [Add NOT NULL constraint on work_item_parent_links.namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/14cc21b8f98649f73107a253fb12af499eee69f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177413))
- [Add NOT NULL constraint on merge_request_context_commits.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/6eb1beca38bbc762fbc754b73930dba146f2bd66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177405))
- [Add not null constraint on dast_scanner_profiles_builds.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/4be2a19dae1488eea1bbe04efa3a9cf27ec4e85e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177358))
- [Add NOT NULL constraint on epic_user_mentions.group_id](https://gitlab.com/gitlab-org/gitlab/-/commit/bef15865d7805fcaf247c7f23c3b922df99983c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177411))
- [Add NOT NULL constraint on status_check_responses.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/775015ad54377942c8a706663292252c7496058d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177392))
- [Cleanup throttle_with_process_commit_worker_pool feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b3cfec256f9a7cc89c748c7d3e361177bf4f8db6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179619))
- [Create cluster_agent_migrations table](https://gitlab.com/gitlab-org/gitlab/-/commit/523f4fe602825c8f366b8aa9fc44e01c48f924ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179324))
- [test: Fix typo in test](https://gitlab.com/gitlab-org/gitlab/-/commit/4d18974c58a6c66e1c441499917d85ffd82b4979) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179533))
- [Create ClickHouse siphon tables for milestones and events](https://gitlab.com/gitlab-org/gitlab/-/commit/b3a838ed16e81b83c004a188e02efa9d42449063) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179573))
- [Rename feature flag for enhanced vulnerability bulk actions](https://gitlab.com/gitlab-org/gitlab/-/commit/cdb6a2d0505da67f6c8878cb4380cb5ee723add0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179488)) **GitLab Enterprise Edition**
- [Add MattermostSlashCommands instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/fde3040722cb2adae6cda19cd14e8b6df69467a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179534))
- [Add MockCi instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/413881770e1b1e90e53ba62d05e5a4ab57ac4ed0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179505))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/fca2ade31a2c0214b55defe6f5e328f400fdc01e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178459))
- [Remove the index_curation feature](https://gitlab.com/gitlab-org/gitlab/-/commit/fd013ff12c41c351fef7b5c216e157ea02e2f2e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179017))
- [Fix pngquant script by requiring logger](https://gitlab.com/gitlab-org/gitlab/-/commit/9646145ce34962ece56921e02d76ac35893f4ca6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179424))
- [Add MockMonitoring instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/f4ee73047604c86392b2a2bf09d589f93cdae026) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179423))
- [Add Phorge instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/38a55b6af6476d2d199c3293c19ebccbf9b7b37d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179422))
- [Add PipelinesEmail instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/f24fbc7f28c4d09fd987de4d1dc3f2e0ebea7206) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179419))
- [Add Pivotaltracker instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/e986da76167b91bbca8654c4886d30c3a29a097d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179413))
- [Fix Usernamespace Audit events](https://gitlab.com/gitlab-org/gitlab/-/commit/e49d9dedfee119b3adbe2791155efc6b633cfe4c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177095))
- [Add Pumble instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/a29d262ad54d8eaa17315cd5048fa90a8e312af0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179393))
- [Add Pushover instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/dba353e2d84e7167ed4ac2114a126f0820610a3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179388))
- [Remove Ci::Tagging model](https://gitlab.com/gitlab-org/gitlab/-/commit/c8b209b006180066151afc5d52a69a1c67352313) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179384))
- [Add Redmine instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/4622b0480e80a9f76569b210d866259b1b139189) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179377))
- [Remove enforce_global_file_size_limit feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/2b7fea4f1c1e0b35475731944ba6dfa1efa91ade) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179347))
- [Handle case where pipeline can be nil in FindingsFinder](https://gitlab.com/gitlab-org/gitlab/-/commit/f67428c81caaadacecad9efec81db70338453877) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178545)) **GitLab Enterprise Edition**
- [Add NOT NULL constraint on project_relation_exports.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/94410f407af125bacf3762f5a892031d135a4c56) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177407))
- [Add NOT NULL constraint on merge_request_assignees.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/6f1c17c72025e21e0d55749196df912155cb9ce0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177404))
- [Add NOT NULL constraint on vulnerability_finding_links.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/7fe709c43216f6e52d7d0b1da322cd1b8cdde387) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177375))
- [Mark 20241003142503 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/f23b78db89f7e6435adf24047f3288d911153f62) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178357)) **GitLab Enterprise Edition**
- [Add UnifyCircuit instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/0cfe9941b377efd1c9cc250f47bd7685c991908f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179265))
- [Remove Ci::Tagging association](https://gitlab.com/gitlab-org/gitlab/-/commit/5d65b36c743da8bc7716a27dcc080c8450b0d4e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178462))
- [Finalize migration BackfillMergeRequestReviewersProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/3fdb4a69858d56908582e7fffe7205d938020eef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177331))
- [Add WebexTeams instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/2e090ba15e11d278c273819ee727033608e8bb39) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179264))
- [Finalize migration for backfilling security policies](https://gitlab.com/gitlab-org/gitlab/-/commit/cef94778b25b23517145dcc44a9b01b7b5996471) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175231))
- [Backfill p_ci_pipeline_variables from ci_trigger_requests](https://gitlab.com/gitlab-org/gitlab/-/commit/a89820fc031f68e3022749be9c32039800e8bc06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175399))
- [Add Youtrack instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/b45096f739d95719a7c40c5eb2536da4faf99991) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179251))
- [Add warning to DT docs](https://gitlab.com/gitlab-org/gitlab/-/commit/3bd54863ac7934bffef246c53fe2d296a2c558f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179223))
- [Move registration_objective to onboarding_status column](https://gitlab.com/gitlab-org/gitlab/-/commit/3aa1fb5916b699b26fbdb14937728a52b613b2ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176428)) **GitLab Enterprise Edition**
- [Validate not null constraint on projects.project_namespace_id column](https://gitlab.com/gitlab-org/gitlab/-/commit/1f98c0759263f01d803fa2d3bc9ed3e05bea1be8) by @c0rydoras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178729))
- [Refactor Cell Configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/9aed1004d100d4afcb9357b8c8e2fac2fecca9c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177988))
- [Mark 20241017094601 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/ce85551f2ff50e33975c5c31b8290e6cddd47bd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178359)) **GitLab Enterprise Edition**
- [Remove multiple_todos feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/a5d66c1fe59147287de1a64d2f14b92f35b9c47a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178897))
- [Add CustomIssueTracker instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/7f8c2e5fc6dabef6650edfd56355de67c9009969) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178019))
- [Add DiffblueCover instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/a7d4bc9db454f1e357e62e45129948ee5b3d4d7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178027))
- [Add Ewm instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/bc747914b77a5fe0630fae8acc343002746b14b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178721))
- [Finalize 20250109133913 batched migration](https://gitlab.com/gitlab-org/gitlab/-/commit/06f17ea420b60a57f7ff94a23468d4d46e8b74fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179042))
- [Finalize 20250108170045 batched migration](https://gitlab.com/gitlab-org/gitlab/-/commit/f1d718bd046922ccf1f20e30a602a9e6ae76c382) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179039))
- [Finalize RecalculateShardingKeyIdForOrphanedProjectRunners](https://gitlab.com/gitlab-org/gitlab/-/commit/9f1efb3c43b7405817c0bc1b85597f59e9be1c29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179036))
- [Remove `merge_request_dashboard_new_lists` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4b64fdf95f5811fb4a41b67e513d5030bb86d6af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179020))
- [Set vulnerability_findings_remediations.project_id as NOT NULL](https://gitlab.com/gitlab-org/gitlab/-/commit/8fbd1ab0bc5c0ef21962e0359caf85efba5408b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177377))
- [Add NOT NULL constraint on issue_links.namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/ea831ddb2c5fb9ac74967c13093e029b0ed7e901) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177412))
- [Consolidate secure tokens feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/3759f68a47d2d136f8643312ff21d2a399531e51) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178404))
- [Add not null constraint on packages_build_infos.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/ad2fa4c965ea6c090d271f65eb45ff4c0f4f5d01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177362))
- [Remove feature flag for pipeline cleanup](https://gitlab.com/gitlab-org/gitlab/-/commit/7477598a4ac0e5e3eb1c01505f43cbe6d9b1fc70) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178754))
- [Add Irker instance intergration](https://gitlab.com/gitlab-org/gitlab/-/commit/4627b5f5f4f339b94746be4a0a61b6da843d34fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178903))
- [Finalize migration BackfillResourceLinkEvents](https://gitlab.com/gitlab-org/gitlab/-/commit/0a89eccff629ad5f2c4ff43867905e3460f68dd1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178649))
- [Create ClickHouse siphon table for notes](https://gitlab.com/gitlab-org/gitlab/-/commit/6f316a39360b0e002b08cc583446f5aa81ba7514) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178914))
- [Remove toggle_redis_6_0_compatibility FF](https://gitlab.com/gitlab-org/gitlab/-/commit/7b5ceece82f6dbaafb85c9922fcaafe21e66712b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178908))
- [Finalize migration BackfillPackagesConanMetadataProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/506d8e4b73f25ac9b912ad6f4b623fc099b052d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178097))
- [Store failed pipeline counts on ClickHouse](https://gitlab.com/gitlab-org/gitlab/-/commit/44e1c4298a4ce3f7c7729d6a59143a3606bf0c28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178621))
- [Finalize migration BackfillDetectedAtFromCreatedAtColumn](https://gitlab.com/gitlab-org/gitlab/-/commit/b39e2b7a1e9b1ced2f35eaa2f9bb1bed6a56903e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178847))
- [Creating table for scheduling user deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/9e7fb70e48bd79bd5487da1f78bfdd2596516b73) by @Anzala09 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167520))
- [Remove Gitlab::Redis::ClusterDbLoadBalancing store post migration](https://gitlab.com/gitlab-org/gitlab/-/commit/04a4ee4a34370aeaebf8d32af3b952591a7ffc56) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178566))
- [Add not null constraint on dast_profiles_pipelines.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/0e9503bbd0cfcf490be1423fbee222e826003abc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177355))
- [Add not null constraint on vulnerability_finding_evidences.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/ed54de0b63934d399fd35aea64f5dacb15ba0970) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177374))
- [Finalize SkipCompanyOnboardingStep batched migration](https://gitlab.com/gitlab-org/gitlab/-/commit/2c6a8df111776ef4eabb2882a948f475f61e2af2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178780))
- [Finalize migration ResyncHasVulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/bfaeda1c54fdc6c67c27fa96d1ee2ec970a53caa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177797))
- [Mark 20240716141532 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/99c4346ef6dd695dd0dc27f067df221298cadec3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178351)) **GitLab Enterprise Edition**
- [Clean up dora_charts_forecast feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f44868e274be3d757399e5f9beac44e3833096bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178325)) **GitLab Enterprise Edition**
- [Add HangoutsChat instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/5377683a83230ac7eaed011c2f51b253bfa1de20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178755))
- [Mark 20240807160655 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/4c7a55e2e3cf6cd793d495489e9e4322f1d31e80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178352)) **GitLab Enterprise Edition**
- [Mark 20241003151804 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/d53bcbfd72a0f93c5104aa133bf16308fed1d0fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178358)) **GitLab Enterprise Edition**
- [Add Clickup instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/332ae9e0bdce77ab46d7aef04f2a3839cbbd0360) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178007))
- [Optimize the update_index_used_bytes](https://gitlab.com/gitlab-org/gitlab/-/commit/5afc226f5f528ff1c3f1f53f866f1664e8c87289) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177575)) **GitLab Enterprise Edition**
- [Mark 20240704125425 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/1a05b4fda57d46ff60cdebd460de530d1340bd03) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178350)) **GitLab Enterprise Edition**
- [Validate `namespaces.organization_id` foreign key](https://gitlab.com/gitlab-org/gitlab/-/commit/b7fbfad1ef11b307c37d77da03bf14e21f9d12ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178298))
- [feat: Abstracting SLIs' initialization step](https://gitlab.com/gitlab-org/gitlab/-/commit/b92bfebff3b12857cb1bdf83fd3eed8a29e0ca7a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177479)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/45a64269430845d5a6c27f92a0761a385120227e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178510))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/63d80b63c5d2014223583d86386d4f700a646331) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178667))
- [Finalize migration BackfillPackagesDebianGroupComponentsGroupId](https://gitlab.com/gitlab-org/gitlab/-/commit/6c7071415fba1263db6e69e772bb73ccde4d7a17) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178651))
- [Use project_id as sharding key for packages_nuget_symbols](https://gitlab.com/gitlab-org/gitlab/-/commit/79c8b82aff8db388a53d9951d05c2acfad25680b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178008))
- [Add placeholder instance integration models](https://gitlab.com/gitlab-org/gitlab/-/commit/b00d879b2f4dc49cac464dba2ba93578621fc2b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178597))
- [Guard against status changes](https://gitlab.com/gitlab-org/gitlab/-/commit/17f4c3a8cb8b1f1d59a8fc4cf80b65d32fe9604e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176574)) **GitLab Enterprise Edition**
- [Mark 20240826172514 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/07547820125a3bb78b248ea7d1f9542a4d3e54eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178355)) **GitLab Enterprise Edition**
- [Remove the FF zoekt_index_marked_as_ready_event](https://gitlab.com/gitlab-org/gitlab/-/commit/340e3e57c64dcb360ef1ee88f7aae9918569f743) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178530))
- [Set approval_merge_request_rule_sources.project_id as NOT NULL](https://gitlab.com/gitlab-org/gitlab/-/commit/3d67ad91e0d07b33eb5da41f3669ba482620c4c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177400))
- [Add NOT NULL constraint on approval_project_rules_users.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/e48a273237e6cda508751a2e730ac1d6d8a0d3ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177398))
- [Add NOT NULL constraint on terraform_state_versions.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/c228b5eee9c04c97ae1e0b59f44c470d69fc556e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177390))
- [Add NOT NULL constraint on terraform_state_versions.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/b8462258d998704242dba202ade83b838874a38c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177384))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/ac61e8330405e99ee23de2a6c0e306113e40dc87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178509))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/7b244ddab79133161057c438b343031dffcf422c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177659))
- [Finalize migration RestoreOptInToGitlabCom](https://gitlab.com/gitlab-org/gitlab/-/commit/458f932198ca25205b3754c52678e1bc7560b2b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177594))
- [Drop the virtual_registries_packages_maven_cached_responses table](https://gitlab.com/gitlab-org/gitlab/-/commit/e606f1e5d8e74f97982f31ae952a372a76e21b15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178004))
- [Mark 20241002103536 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/8471665bc4b95d575d1ba743a285b889b630fa90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178356)) **GitLab Enterprise Edition**
- [Mark 20240814231502 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/96b5af9e557110847b215998d7f014852354bbe0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178354)) **GitLab Enterprise Edition**
- [Remove feature flag new_pages_ui](https://gitlab.com/gitlab-org/gitlab/-/commit/c815f2aa35a1df6b8054510d1b910cd5f2f52f0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178299))
- [Add alert_management_alert_user_mentions.project_id NOT NULL constraint](https://gitlab.com/gitlab-org/gitlab/-/commit/604fe630cc72a36deca1cea2eb905172cc23977f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177258))
- [feat: Record error rate on security scan reports](https://gitlab.com/gitlab-org/gitlab/-/commit/1eb4a3a7ddf52c49ab854b2cdc64d181852ab011) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170983)) **GitLab Enterprise Edition**
- [Remove project and group vulnerability management feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/9549996c4ebb9a2d139ede72019e377a062fd573) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178031)) **GitLab Enterprise Edition**
- [Create ClickHouse table siphon_merge_requests](https://gitlab.com/gitlab-org/gitlab/-/commit/cbb9f99a477ea2bb5170d9fb8f0738b960c9093a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178318))
- [Removing cascading-duo-features-for-instance FF](https://gitlab.com/gitlab-org/gitlab/-/commit/2a7611fe6975ca2362ba349ee52dd54f1f4849fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178176)) **GitLab Enterprise Edition**
- [Validate the not null constraint on `projects.organization_id`](https://gitlab.com/gitlab-org/gitlab/-/commit/717f5c047622ebbd4d1813963683959dbabef039) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177722))
- [Add NOT NULL constraint on design_management_designs.namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/dd3345a946ba3b08878fb4e4f85ede1b19404629) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177367))
- [Finalize copy runner taggings migrations](https://gitlab.com/gitlab-org/gitlab/-/commit/85a44bfdcc9c0faa52d9a5dd880aba62ac6c48da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177881))
- [Add not null constraint on sbom_occurrences_vulnerabilities.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/1feb0a75c38ea67cb8240d45f3fd3cdbedab1325) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177361))
- [Add NOT NULL constraint on operations_strategies_user_lists.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/9c3671a630fb42b2a1328e545231732c5f1a4fde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177372))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/e92a644cb1ca25bd91a2a190e73fdeae7bbacacd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178259))
- [Create ClickHouse siphon for issues](https://gitlab.com/gitlab-org/gitlab/-/commit/79ad43d04c904d7706c11da61efa240b26bc2435) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178218))
- [docs: Extend docs that delete protection is not yet implemented](https://gitlab.com/gitlab-org/gitlab/-/commit/987155062f2ba16b31ab410d2bdd2aa5c9ee0be8) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168822))
- [Add Bugzilla instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/6fe0086518345305014cacb8afd0ae7c1f42c756) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177441))
- [Drop table subscription_provision_syncs](https://gitlab.com/gitlab-org/gitlab/-/commit/55a78b4bbfd1d1114815d4113f76f03ab1e57101) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178183)) **GitLab Enterprise Edition**
- [Finalize BackfillCiRunnerMachinesPartitionedTable](https://gitlab.com/gitlab-org/gitlab/-/commit/742a13ca537d4bf69017ce3d8bb5bcbb1f7679c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177745))
- [Finalize migration BackfillPackagesDebianGroupArchitecturesGroupId](https://gitlab.com/gitlab-org/gitlab/-/commit/8af649161419c15e0e24e4e25f6409606e84a38b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178098))
- [[Feature flag] Cleanup mr_vulnerability_code_flow](https://gitlab.com/gitlab-org/gitlab/-/commit/abf9ea9e764390321623cc532403d79f0b809404) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177843))
- [Remove advanced_search_multi_project_select feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e92628aa11393aa7f8058f25096b0eeae4428572) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178134)) **GitLab Enterprise Edition**
- [Add NOT NULL constraint on design_management_repositories.namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/647f133eebaa73137b4bd3874af7ca9d0b84afdf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177368))
- [Update sharding_key_id for project runners if project is deleted](https://gitlab.com/gitlab-org/gitlab/-/commit/ede152ec014e694fc39c66a78507073870d3ed3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178130))
- [Add NOT NULL constraint to cluster_agent_tokens.project_id column](https://gitlab.com/gitlab-org/gitlab/-/commit/17f2361b075b6a1a027cba02e57e6668995ab7d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177246))
- [Add not null constraint on related_epic_links.group_id](https://gitlab.com/gitlab-org/gitlab/-/commit/09ed995cc33788a4c4f2e950d480b444b2a68c76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177352))
- [Add NOT NULL constraint on packages_debian_publications.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/6fc7c1c847852f68a11b62692cb6deaffacccb63) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177366))
- [Add schema for work item custom field values](https://gitlab.com/gitlab-org/gitlab/-/commit/4a6c7745042caa5c8a123052fc9766887ac0df9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175312))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/806c24e496d81d21dba8f92de88c1a367e013720) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178112))
- [Direct code generation requests to v4 when client supports sse](https://gitlab.com/gitlab-org/gitlab/-/commit/68e34bab9e8dc51d3e1fccd8f850c5bce4ab4d7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178094))
- [Add NOT NULL constraint on operations_strategies.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/767c776b85c16b02d4b1a4d5dfe2ecc24eea50d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177371))
- [Finalize backfill_onboarding_status_role migration](https://gitlab.com/gitlab-org/gitlab/-/commit/f8ba8ce5ffa2105ca4e63fffae9ebec68616752a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177782))
- [Finalize migration for backfilling status checks project ID](https://gitlab.com/gitlab-org/gitlab/-/commit/93a0ec788f30f0d0c71aca6f6c50dd0d4ba79935) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177107))
- [Remove ApplicationSetting legacy AI columns](https://gitlab.com/gitlab-org/gitlab/-/commit/41b6bbe518711e6186f5de309012797336686785) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177600))
- [Finalize QueueBackfillComplianceViolationNullTargetProjectIds migration](https://gitlab.com/gitlab-org/gitlab/-/commit/1e6206fbba7f8f8b4740af4f0f546f284d347d0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175905))
- [Remove orphaned managers from .com ci_runner_machines_687967fa8a](https://gitlab.com/gitlab-org/gitlab/-/commit/3b24c40f3c356c604ad2d3b4e34dc6aed856bee8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177774))
- [Fix backfill_p_ci_pipelines_trigger_id](https://gitlab.com/gitlab-org/gitlab/-/commit/83abdb491ce63e387756feaac3f3803d2ac0c99a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176645))
- [Add not null constraint on dast_pre_scan_verifications.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/3b9295e13abc9c136a6cfa028bd1861809247f0b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177354))
- [Validate fk_0e743433ff foreign key](https://gitlab.com/gitlab-org/gitlab/-/commit/b95d99a9a2e3b44c297935fecc217a2dc9c04075) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177757))
- [Finalize the DeleteOrphanedCiRunnerProjects migration](https://gitlab.com/gitlab-org/gitlab/-/commit/ce11d1a372d28dc8ff1a932f4e0a89f11f142445) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177757))
- [Finalize BackfillCiRunnersPartitionedTable](https://gitlab.com/gitlab-org/gitlab/-/commit/afb5cf865f93f20c29d0ddbf306df4f92d5d3a49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177750))
- [Model Registry: Add metrics for users](https://gitlab.com/gitlab-org/gitlab/-/commit/373f4d641c51384be2bc7b748045180aafb253db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177854))
- [Schedule the `namespaces.organization_id` foreign key to be validated](https://gitlab.com/gitlab-org/gitlab/-/commit/523cb12a667524e0e733f1be6cc5ca5d2c46b987) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177991))
- [Add not null constraint on dast_profiles_tags.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/205049d7b7120f6ec971e8189da90437f2ce1947) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177357))
- [Set compliance_framework_security_policies sharding keys as NOT NULL](https://gitlab.com/gitlab-org/gitlab/-/commit/5064d9c8143ee1df937d587387214fa62be7f508) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177388))
- [Add not null constraint on boards_epic_user_preferences.group_id](https://gitlab.com/gitlab-org/gitlab/-/commit/93900dfae9fb7f3670ce7fbc8b92b42f66dca0f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177349))
- [Finalize migration BackfillMlModelMetadataProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/fbddc9f0f7ba64e94d677416b8a66e07e97869fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177939))
- [Finalize migration for Software Licenses without spdx](https://gitlab.com/gitlab-org/gitlab/-/commit/3702648dbd5a27e30c5f7c04661bc6960e77840b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175164))
- [Remove DeleteProjectWorker and feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/5892e0521f1f18508774c7dd66dbffa4de5e0b56) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177863)) **GitLab Enterprise Edition**
- [Finalize migration BackfillMergeRequestsClosingIssuesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/d58a2983e62e81593e0447fb5221f9cfbb298c20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177644))
- [Add Bamboo instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/e1b01fe45e380380dc009c1d48c495bf766e9b93) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177145))
- [Set approval_group_rules_protected_branches.group_id as NOT NULL](https://gitlab.com/gitlab-org/gitlab/-/commit/d82b4950188c760030aa89963ee77187fd97a2dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177396))
- [Add NOT NULL constraint on user_achievements.namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/974870a1b5f07010443404e227bba25aecadd19c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177391))
- [Add NOT NULL constraint on audit_events_streaming_headers.group_id](https://gitlab.com/gitlab-org/gitlab/-/commit/916a274b615b9cca5826ed05d794bcbf4e306241) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177386))
- [Set audit_events_streaming_event_type_filters.group_id as NOT NULL](https://gitlab.com/gitlab-org/gitlab/-/commit/8e9aa5a91dccb90b5299a44e8903d3151ccf78c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177385))
- [Add NOT NULL constraint on workspace_variables.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/96a8c8685ceaa19dea59e1efd3a0a5ea7665401a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177383))
- [Add NOT NULL constraint on vulnerability_user_mentions.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/f2cbbc6568eba48be6f184875810100dd014a6b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177381))
- [Add NOT NULL constraint on vulnerability_flags.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/722b67ecda2c30258e4ccf26309879388013b1cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177380))
- [Add NOT NULL constraint on operations_feature_flags_issues.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/01ff8297ced0afbf06fcd4632e6fd32205504147) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177370))
- [Set packages_debian_project_distribution_keys.project_id as NOT NULL](https://gitlab.com/gitlab-org/gitlab/-/commit/b465a351cf71a53ec884ad9d9c3a086703639199) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177365))
- [Set packages_debian_group_distribution_keys.group_id as NOT NULL](https://gitlab.com/gitlab-org/gitlab/-/commit/d219be05e558234ff9ff47ee4ffeab298f468f65) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177363))
- [Add not null constraint on dast_site_validations.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/85eb588c6fe40cd7c53d935697e03779c5f395ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177360))
- [Add not null constraint on dast_site_profile_secret_variables.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/389c9d41dbe6c1dfd0180869c24f9b6f7af4aeaa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177359))
- [Add not null constraint on dora_daily_metrics.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/58b5ad11bcceb415fecb9c753154387eea0ff32c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177353))
- [Add not null constraint on boards_epic_board_positions.group_id](https://gitlab.com/gitlab-org/gitlab/-/commit/6a6d2ca461d278f31d8ca6056b3721be9dce1de2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177347))
- [Add not null constraint on boards_epic_board_labels.group_id](https://gitlab.com/gitlab-org/gitlab/-/commit/8a6f2a76f10ed888a62e548a5b0316b0bf1ababf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177343))
- [Add alert_management_alert_metric_images.project_id NOT NULL constraint](https://gitlab.com/gitlab-org/gitlab/-/commit/8c724247b9f6ada6c9280746f93b680bcbb70de3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177257))
- [Add NOT NULL constraint to alert_management_alert_assignees.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/717adc3ec7397658d12beb18421159e352e0ec54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177252))
- [Add NOT NULL constraint to ml_experiment_metadata.project_id column](https://gitlab.com/gitlab-org/gitlab/-/commit/d0200b5b317b842f7bc2308a20760f8682bff3ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177249))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/c932e35efdc0e3c6f316a3c2d37045e115ce8cd5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176452))
- [Finalize migration BackfillRemoteDevelopmentAgentConfigsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/da4c63d7aab3685c3fbe9d1e48f68ba2162a0b5e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172769))

## 17.8.5 (2025-03-11)

### Security (8 changes)

- [Vendor GraphQL gem](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1d1019ef7f1f447b9438221ff734f07cb8cfc6f7) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4840))
- [Ruby-SAML updates](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f68b16e4319f01144c90b725e6ec62b3c2ca42bd) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4829))
- [Prevent custom role to activate group members](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a1d818293e11796c71553e2c5eaba4e2f358db79) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4834))
- [approval_rules name is unbounded](https://gitlab.com/gitlab-org/security/gitlab/-/commit/89018f0df2df5c9b3c656a0981384ee3872a54e1) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4837))
- [Limit preview size](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9824f5746a38e95dbfa5d991b69c18ec3e5c1194) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4822))
- [Maintainer can inject shell code in Google integration configurations that...](https://gitlab.com/gitlab-org/security/gitlab/-/commit/688e445b811a4ffa2e2a175effe4f211af57afe8) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4825))
- [Filter out internal notes if the recipient do not have access](https://gitlab.com/gitlab-org/security/gitlab/-/commit/117de613cd4025a41c93a25809dd4c5bd47df7b4) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4814))
- [Mask unencoded userinfo in project mirror errors](https://gitlab.com/gitlab-org/security/gitlab/-/commit/73a0c85541ef22125c52be1b4980ced1bfbc1dba) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4777))

## 17.8.4 (2025-02-26)

### Security (4 changes)

- [Increase minimum role in SPP to read policy yaml](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9bfcf4a596b965ce73426d68861cec83ee70f19e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4716))
- [Fix access to read code review analytics in private projects](https://gitlab.com/gitlab-org/security/gitlab/-/commit/537159f505cad7d23cded01140fbdfd84e9cdfa2) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4758))
- [Escape work item dropdown items and restrict HTML tags](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5548168c3d4e0ba660ed934f23c332045a640799) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4784))
- [Use stricter CSP values in the packages dependency proxy](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d491abd511c9c1cb00c928e28dc84cb7ef8e4cd3) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4764))

## 17.8.3 (2025-02-21)

### Fixed (2 changes)

- [Use primary DB when authenticating via job token in jobs API](https://gitlab.com/gitlab-org/gitlab/-/commit/6eee5c6811cac82981252280f1b08316ae8c1fd5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181872))
- [Revert stricter workhorse route regexes](https://gitlab.com/gitlab-org/gitlab/-/commit/aba07e94e0587dd378dccbdf18dfe839f09078bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181358))

## 17.8.2 (2025-02-11)

### Fixed (3 changes)

- [Fix storing incorrect policy index in scan_result_policies](https://gitlab.com/gitlab-org/security/gitlab/-/commit/49e2809628b91b4200b62faf512ae73ba4bfaa27) **GitLab Enterprise Edition**
- [Enable ai tracking even with feature flag disabled](https://gitlab.com/gitlab-org/security/gitlab/-/commit/27526bdc24302c80940356e93928956ea6cb21d3) **GitLab Enterprise Edition**
- [Fix Workhorse failing on 64-bit unaligned access on Raspberry Pi 32-bit](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a026bcb6a7a0a69329ab6cc63cfe2ef51a7d2d83)

### Security (8 changes)

- [Security Duo Chat Escape Unknown Domain Hyperlinks](https://gitlab.com/gitlab-org/security/gitlab/-/commit/44436a9c648b077a89efb5d2b394f36702f0e315) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4706))
- [Hide sensitive workhorse headers and fix route confusion between web and workhorse routes](https://gitlab.com/gitlab-org/security/gitlab/-/commit/80e0601861d797ed6126b999c5830409ee5e8abf) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4760))
- [Do not allow Planner role to update or delete incidents](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3c76c42d1451fea9f74aec4ff31d17483f8c2d14) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4746))
- [Reduce memory allocations on create PAT endpoint](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3183ac5d359b349b248dfb6d094e6791b2cf716a) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4750))
- [Prevent SSRF attacks for Workspaces](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ad1ddf3353d1817d3b7eb583ea333dab0dd3f6a2) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4729))
- [Prevent read code access when repository is disabled](https://gitlab.com/gitlab-org/security/gitlab/-/commit/be2a9c24d18e2735f4d8e640bfd61633851da60e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4705))
- [Fixes XSS on the target branch in the merge request widget](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3de176b1ee5c0df452d265a9ca39ae950c9553aa) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4735))
- [Unsubscribe from actioncable channel when PAT is revoked](https://gitlab.com/gitlab-org/security/gitlab/-/commit/85760efaf82d85241732360045a1763095740049) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4725))

## 17.8.1 (2025-01-22)

### Security (4 changes)

- [Fix protected variable exfiltration](https://gitlab.com/gitlab-org/security/gitlab/-/commit/998874eb0ed029872a47991788565213aa6707b8) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4713))
- [Enhance rich viewer sanitization](https://gitlab.com/gitlab-org/security/gitlab/-/commit/895088208f7a39aad0bd9cd8dbec8cf6b8f8f1f3) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4708))
- [Avoid recursive sidekiq calls on cyclic work item hierarchies](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1872a670e73e294db21773d8289bc51c6b9ec9aa) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4711))
- [Respect the private profile constraints](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f434b2e5d6542b3d762852a725a19780d6966db1) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4704))

## 17.8.0 (2025-01-15)

### Added (127 changes)

- [Add more specs for most_recent_commit_sha method](https://gitlab.com/gitlab-org/gitlab/-/commit/12172c6fcc8ca1b7b77acaab3d0d3ce508a8a1f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176467)) **GitLab Enterprise Edition**
- [Update runners owned by non-existent projects](https://gitlab.com/gitlab-org/gitlab/-/commit/804d81dc1ab1d576b6c27168a1e0d7c82fddfcd0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177271))
- [Delete orphaned project runners when project is deleted](https://gitlab.com/gitlab-org/gitlab/-/commit/a78c44336335a6f7e3f156bbda44bbee6f06739e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176879))
- [Allow configuring "auto_stop_setting" through graphql](https://gitlab.com/gitlab-org/gitlab/-/commit/369ad4b24d91cb8a4eaf613a53e44f01fe7c42c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176083))
- [Create GraphQL query for the pages settings](https://gitlab.com/gitlab-org/gitlab/-/commit/2d64cec39dccdd31ceb3d78409b6d76bcaccba36) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169835))
- [Add elastic client to active context gem](https://gitlab.com/gitlab-org/gitlab/-/commit/8cb64dfa3f2a6dd172b6cbd92a1d22f6a70c038d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176973)) **GitLab Enterprise Edition**
- [Save branch name of code suggestion events](https://gitlab.com/gitlab-org/gitlab/-/commit/a24f245be6492d3fb3ca153b571d4a193035983f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176389)) **GitLab Enterprise Edition**
- [Release protected pypi packages feature](https://gitlab.com/gitlab-org/gitlab/-/commit/ce95ef89875fbd7b4ee54a7b0ad7ad14e64a5e98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177096))
- [Model experiments: Add href to CI Job](https://gitlab.com/gitlab-org/gitlab/-/commit/59fc8c9973c5ede619bf2c3a7b5788585d10e388) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177710))
- [Add graphql field ai_xray_reports to ProjectType](https://gitlab.com/gitlab-org/gitlab/-/commit/1a563af4a1ca22fa4cef9f54e0e7590bc33167f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176901))
- [Add LinkedResources work item widget placeholder](https://gitlab.com/gitlab-org/gitlab/-/commit/03da3ff54eec1262503bfd43c2f8504ec9b714c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177508))
- [Add ability to add related item for work items](https://gitlab.com/gitlab-org/gitlab/-/commit/68147984bf315d22883e61fdec6b0c7dde9876ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176169))
- [Create siphon ClickHouse table for projects](https://gitlab.com/gitlab-org/gitlab/-/commit/cb4845306917c82ca1d2dcca50863a149dbe2cae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177486))
- [Add Rest and GraphQL API to configure scheduled merge](https://gitlab.com/gitlab-org/gitlab/-/commit/7cfd279b88758ae09abd783e473feb229ec01693) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177300))
- [Promote runs in a model's experiments to a model version](https://gitlab.com/gitlab-org/gitlab/-/commit/ba293bdcd29f6be9b4cd70e934adc30db76269f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177110))
- [Allow users to configure skip_ci for pipeline execution policies](https://gitlab.com/gitlab-org/gitlab/-/commit/e1da67076029b7bce6e06099da80bdd9c9f0085d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177394)) **GitLab Enterprise Edition**
- [Add indices for sharding_key_id for runners and runner managers](https://gitlab.com/gitlab-org/gitlab/-/commit/4ae5548552345ef788ad95bce89037f89816c39f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176865))
- [Release protected container repositories feature](https://gitlab.com/gitlab-org/gitlab/-/commit/794937eea2cc3e9bea794d7edde61e1c0c8fdcaa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173811))
- [Add resolve MR discussion arguments to create work item mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/20d3bf017c1af78bdb40b98dfbcb2786502d189a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177211))
- [Add directory or file name with icon](https://gitlab.com/gitlab-org/gitlab/-/commit/916cf3e2856bc818e15482bb1fb351c014cac568) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177261))
- [Adds workflows_definition to Duo Workflow](https://gitlab.com/gitlab-org/gitlab/-/commit/651b3faceb9296c49c0787b38ae03561b7dba05a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176266)) **GitLab Enterprise Edition**
- [Allow filtering tokens by before and after expires at](https://gitlab.com/gitlab-org/gitlab/-/commit/284d6005e973048ce2b1577ad1c6eb9b192dc1b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176996))
- [Adds bso instrumentation metric](https://gitlab.com/gitlab-org/gitlab/-/commit/1ab0ff584629d2c39c169e607fb769c3248cf62a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177262)) **GitLab Enterprise Edition**
- [Update runner taggings owned by non-existing projects](https://gitlab.com/gitlab-org/gitlab/-/commit/f9e9740a37ec25fdd28f6aaa2a0a0424b579f903) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177453))
- [Update runner managers owned by non-existing projects](https://gitlab.com/gitlab-org/gitlab/-/commit/5240af72f0d253320dad4de85f8b1820786d0562) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177423))
- [Mock Api for custom statuses](https://gitlab.com/gitlab-org/gitlab/-/commit/1ec52b6baacd07710423764949e8c240f6be547a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176843)) **GitLab Enterprise Edition**
- [Surface user.type to frontend](https://gitlab.com/gitlab-org/gitlab/-/commit/054cb968685487f728481e995e00871ef9672432) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175972))
- [Remove use_list_commits_rpc_network_graph feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4a638bc7cfab46736cad21ccf8b6494f55bda109) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177373))
- [Add support in UI to select Pages primary domain](https://gitlab.com/gitlab-org/gitlab/-/commit/b8eba5f91ab2cfa56f0aa39a00e0484485fa126d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176699))
- [Model experiments: Improve candidate table](https://gitlab.com/gitlab-org/gitlab/-/commit/dd5da6033c717c8f8fa1abc874eca7ac73bddac4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176099))
- [Add Restricted Access option to Seat Controls](https://gitlab.com/gitlab-org/gitlab/-/commit/c784016c9f1d2924ccc8536b5868882e05c81d89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175705)) **GitLab Enterprise Edition**
- [Add linkedWorkItems field to EpicType](https://gitlab.com/gitlab-org/gitlab/-/commit/36b8d5bf970e0c4805b25b12e3f95cdc1b1e1a20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177097)) **GitLab Enterprise Edition**
- [Use legacy destination helper in legacy destination create APIs](https://gitlab.com/gitlab-org/gitlab/-/commit/e41835e675afad567a6c7cff57d12c93e33bff15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175753)) **GitLab Enterprise Edition**
- [Add xray context to /refactor](https://gitlab.com/gitlab-org/gitlab/-/commit/f1d5eda1204b3402757964fd9cb50e50934b5bd1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173750)) **GitLab Enterprise Edition**
- [Add optional variables for passing on to CI](https://gitlab.com/gitlab-org/gitlab/-/commit/43302ca2aea99ba03e1f501ee78f121c05b609cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177026)) **GitLab Enterprise Edition**
- [Group level support for dropdown API](https://gitlab.com/gitlab-org/gitlab/-/commit/b9e8335618948f9e471650f4857380b1c7ff9e64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175902)) **GitLab Enterprise Edition**
- [Enable group-level vulnerability management policies by default](https://gitlab.com/gitlab-org/gitlab/-/commit/5857afaaf061217e83648bb2f220cdc6a46f0049) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177228)) **GitLab Enterprise Edition**
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/3278b6c4e7ee89f1ab64c1a76e0c8411aacdd249) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177213))
- [Full support for Vulnerability Webhook events](https://gitlab.com/gitlab-org/gitlab/-/commit/1a36642693f7abedf61e1a1b082a708e6faaa6be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176064)) **GitLab Enterprise Edition**
- [Remove amazon_q_integration feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/effde0dc90e9accf7fbcee6d25fa75773bfa0791) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177196))
- [Search in accessible deploy keys](https://gitlab.com/gitlab-org/gitlab/-/commit/2a24e17deec63d2d9f9f2fd149241e99f262a0c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176538))
- [Model experiments: Add copy button to MLflow usage](https://gitlab.com/gitlab-org/gitlab/-/commit/9cc8565d80140f4ba12d716b3d5950be320b9be1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176037))
- [Model experiments: Add experiment id](https://gitlab.com/gitlab-org/gitlab/-/commit/998afb6a4e142ec30c394237103fe61029c8fed2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177119))
- [Add linkedWorkItems field to EpicType](https://gitlab.com/gitlab-org/gitlab/-/commit/ebec8b8de0790492679ae32695e694ecaefa1bcd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177116)) **GitLab Enterprise Edition**
- [Model experiments: Add creator to candidates table](https://gitlab.com/gitlab-org/gitlab/-/commit/2631c30f7244a381b39356c2f7b39280ef06090f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176121))
- [Adding project control status table](https://gitlab.com/gitlab-org/gitlab/-/commit/ef78b3c2d2c6a19d95828ad83ba64ba7c32c0264) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176581)) **GitLab Enterprise Edition**
- [Model experiments: Add creator field to candidates type](https://gitlab.com/gitlab-org/gitlab/-/commit/f347666c05b01d650172c031e55459060b0ab192) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177073))
- [Add retry_duo_workflow_execution event](https://gitlab.com/gitlab-org/gitlab/-/commit/37e847fa45ba298059a97a46df58a588741cb895) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177070)) **GitLab Enterprise Edition**
- [Model experiments: Add Experiments to GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/bb25ee1fcc2a5ada1e018f4746576128b92521d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175815))
- [Added destroy requested changes GraphQL mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/f8b808fc0a86354d7f059ac7aa5a76741f95145f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176363)) **GitLab Enterprise Edition**
- [Sync index for p_ci_pipelines.trigger_id](https://gitlab.com/gitlab-org/gitlab/-/commit/a3ab66164f942f5b75b7488a9970ab74d0260d6b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175213))
- [Add CUD endpoints for tag protection rule](https://gitlab.com/gitlab-org/gitlab/-/commit/492be0979e6ebdea14e83391e6a6b00aefba9f4e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175736))
- [Introduce lazy loading of projects list in framework drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/277ec524094270497316264c03f7c1ca1bfe547d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175197)) **GitLab Enterprise Edition**
- [Add skip ci configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/a3872d7eae9bea5728f798676d810e5688852f16) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176523)) **GitLab Enterprise Edition**
- [Add optional variables to dast_site_profiles table](https://gitlab.com/gitlab-org/gitlab/-/commit/2d60326719cf0cfe87242b41ee384f066ad9a846) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175476)) **GitLab Enterprise Edition**
- [Helper method for legacy audit event destinations graphql create](https://gitlab.com/gitlab-org/gitlab/-/commit/30c134a30592562a655dfa0d2851e20033125c49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175628)) **GitLab Enterprise Edition**
- [Helper method for audit event destinations graphql create](https://gitlab.com/gitlab-org/gitlab/-/commit/91bade77a232e4a7e25ceec894054995b7a95c6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173752)) **GitLab Enterprise Edition**
- [Create v2 enpoints and add feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/dabbf89307bc51bfc77cd851e263ade3f88e4e2b) by @ScanianJP ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165034))
- [Link user_destroyed event for user provisioned by group to the group](https://gitlab.com/gitlab-org/gitlab/-/commit/7ca8e4bfed2efc57a262c8ad19e8926c174b55ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176405)) **GitLab Enterprise Edition**
- [Remove log_advanced_search_cluster_health_elastic flag](https://gitlab.com/gitlab-org/gitlab/-/commit/79590ee3215f2def69bf1d6e52999aaae2873f3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177076)) **GitLab Enterprise Edition**
- [Add skip ci configuration to a policy drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/a09baa682f840942f6753c3c950f15697739f00e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176616)) **GitLab Enterprise Edition**
- [Add licenses to scan_result_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/3d533069346897fd4d4c6488f4e1ab02e6fda3a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176715)) **GitLab Enterprise Edition**
- [GraphQL: add TagCreate mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/9f592e98a4c9c47105273c43009ac469391446a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175833))
- [Update policy schema to support package exclusion](https://gitlab.com/gitlab-org/gitlab/-/commit/7038d8b9d88afa2e61cf7178a52f27012337f00c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176433)) **GitLab Enterprise Edition**
- [Delete orphaned ci_runner_projects records](https://gitlab.com/gitlab-org/gitlab/-/commit/d319bae2246e991c0c7abcca80c46120c90f5b09) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176676))
- [Add an audit event for user provisioning by group SCIM](https://gitlab.com/gitlab-org/gitlab/-/commit/b224928751954887e24552dea819c3a62b7ca169) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174040)) **GitLab Enterprise Edition**
- [Reorganise project-level packages and registries settings](https://gitlab.com/gitlab-org/gitlab/-/commit/cb82e5ebef1d1e4f2bb1605a703accb32fe30841) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176343))
- [Added merge request requested changes to the merge request GraphQL type](https://gitlab.com/gitlab-org/gitlab/-/commit/f79b3606d62680ab7d7ef9608e4c30591d764ed3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176300))
- [Enable third-party UCM flags by default](https://gitlab.com/gitlab-org/gitlab/-/commit/b381a70264f81842fa48112e540c5289e490fad4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176675))
- [Set gh user mapping ff to true](https://gitlab.com/gitlab-org/gitlab/-/commit/c52246f6f097060bf2fdc5c52378958a2a5cfdb1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176633))
- [Update loading state of create merge request button](https://gitlab.com/gitlab-org/gitlab/-/commit/e89f8643e23c4bfcf0bd1be7e28f000d77d66501) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176481))
- [Show title suggestions to project work items](https://gitlab.com/gitlab-org/gitlab/-/commit/5cc74f8a8e52f8281e430621451aaefff290398a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176455))
- [Add new table subcsrption_provision_syncs](https://gitlab.com/gitlab-org/gitlab/-/commit/dcb7051432bfa43cae676a76f8c04dda739bc586) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176606)) **GitLab Enterprise Edition**
- [Automatically enable group hierarchy optimization](https://gitlab.com/gitlab-org/gitlab/-/commit/25d6eb5f54ef2cbf2b83c900ea42a7e0de852221) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176648))
- [Fix policies update MR blocked](https://gitlab.com/gitlab-org/gitlab/-/commit/dc144264209fbc0422a9a2d41613145ef1a4a319) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176608)) **GitLab Enterprise Edition**
- [Expose `move_design` policy in GraphQL permission type](https://gitlab.com/gitlab-org/gitlab/-/commit/fc4abdf1ccadc41a9286422966126a3aaef2780f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176542))
- [Adding tables and models for requirement controls](https://gitlab.com/gitlab-org/gitlab/-/commit/5ede88ea8d4a6299ab0a6debd2521a5e9e2290e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175812)) **GitLab Enterprise Edition**
- [Log all AI Gateway responses related to Amazon Q](https://gitlab.com/gitlab-org/gitlab/-/commit/90c36b09f7f143abf7b0d840136c7e14d93d879a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176548))
- [Expose EPSS and KEV in finding entity](https://gitlab.com/gitlab-org/gitlab/-/commit/585fa176ec99ccaccd94de6e8975dd99a539a59e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175792)) **GitLab Enterprise Edition**
- [Remove track_member_activity feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/314c13081b1c421eed21b4f168503d04b364d1bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176480))
- [Remove epic_and_work_item_associations_unification ff](https://gitlab.com/gitlab-org/gitlab/-/commit/6d915390b0b9e1842d7ceba97af2db1ac7f76f65) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170264)) **GitLab Enterprise Edition**
- [Show modal when updating with pipeline](https://gitlab.com/gitlab-org/gitlab/-/commit/18651dfefffe31a7855deb28dc5774361c2ab13c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173584)) **GitLab Enterprise Edition**
- [Add API endpoints and services for Account Ownership Verification PIN](https://gitlab.com/gitlab-org/gitlab/-/commit/1f436f665766f88e87ebf24893cc5000cf16ac4a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175040))
- [Add read compliance dashboard as a custom ability](https://gitlab.com/gitlab-org/gitlab/-/commit/5c754f867624f9629735a9af190de40a287e7d49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175066)) **GitLab Enterprise Edition**
- [Add Amazon Q system note support](https://gitlab.com/gitlab-org/gitlab/-/commit/72e510361ea5f54702be76e4bdf087bb3c0555ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176413))
- [Add `async` arg to `PipelineCreate` mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/e608229d005ddc6bc8011fe2a6c780c89c50bf7c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174577))
- [Add quick actions messages to work items](https://gitlab.com/gitlab-org/gitlab/-/commit/f5e9f208c99488c49613021cd141f7a1a143696b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175449))
- [Add topic to catalog resources](https://gitlab.com/gitlab-org/gitlab/-/commit/f85f2927590e6f8ffc5580bb090313c731e9ce1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176257))
- [Add a confirmation alert when an environment is protected/unprotected](https://gitlab.com/gitlab-org/gitlab/-/commit/4740c742ece1da0cd5c7c9414861b3ea6dc8640d) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176103)) **GitLab Enterprise Edition**
- [Implement project secrets graphql query](https://gitlab.com/gitlab-org/gitlab/-/commit/21e07e933143d1a1db5eef0a0f38e4688ba95866) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175603))
- [Show Closed MRs deprecated in the list](https://gitlab.com/gitlab-org/gitlab/-/commit/caae8a052e8ab01c57213fb25c3dcceb7cbdb2c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176087))
- [Defined event and metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/35b2c20ddcbe1f307b138ac577e26506b5e66e80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175762)) **GitLab Enterprise Edition**
- [Remove create branch and merge request from behind FF](https://gitlab.com/gitlab-org/gitlab/-/commit/5556cb570226109a78a012fbfdbc5d21d1b06de9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176218))
- [Show warning when approval settings are overridden for MR](https://gitlab.com/gitlab-org/gitlab/-/commit/f901f9cbc8717ef2e00e6378ccde48bf4e1ae7be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175674)) **GitLab Enterprise Edition**
- [Make composite_identity FF default enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/e8cec24fb2ff7ab6dbb77ae1e69a469e217851ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176301))
- [Model registry: Add empty state to candidate list](https://gitlab.com/gitlab-org/gitlab/-/commit/65c7d3da7f372c08617dd02e68ab19f95920d601) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176122))
- [Implement delete pipl users](https://gitlab.com/gitlab-org/gitlab/-/commit/cb5dfce0419853bd2be312d2cb2177832db76d39) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175861)) **GitLab Enterprise Edition**
- [Add arkose_labs_data_exchange_enabled setting](https://gitlab.com/gitlab-org/gitlab/-/commit/1b5f4168d0c7bcfa45354b647a9e7840fd62bedb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176034)) **GitLab Enterprise Edition**
- [Model experiments: Split Experiment card into tabs](https://gitlab.com/gitlab-org/gitlab/-/commit/fc03c89d7d8e3bd6d40f1bd6d1f2e06bd95f6600) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174686))
- [Allow configuring "auto_stop_setting" through Environments API](https://gitlab.com/gitlab-org/gitlab/-/commit/88f28e81ec895d8c5c96a0ae469e8a405d4696ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175940))
- [Connect Amazon Q trigger service to issuable create/update](https://gitlab.com/gitlab-org/gitlab/-/commit/ad22de2e58d32d25b4e7fd2edef88778a7eee6d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176221)) **GitLab Enterprise Edition**
- [Connect Amazon Q trigger service to quick actions](https://gitlab.com/gitlab-org/gitlab/-/commit/9f4f0eced50aa434eee04aa73415f1c91a606e1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176217)) **GitLab Enterprise Edition**
- [Add `inputs` key to trigger include objects CI schema](https://gitlab.com/gitlab-org/gitlab/-/commit/c5727f72a70cb9f8d91967c69b097957f9ad8bf7) by @Ben.Leith ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173216))
- [Add 'Start review' button to MR Overview](https://gitlab.com/gitlab-org/gitlab/-/commit/9138d1311b749b3c0cc4c9c80782537b15923598) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169815))
- [Add `group_analytics_dashboard_editor` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/016034f278e3727cf548499607c5c1fd4d475bda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175604)) **GitLab Enterprise Edition**
- [Add base support for Amazon Q quick actions service](https://gitlab.com/gitlab-org/gitlab/-/commit/7f0d00e0c7eba45f88869e46621240d9860d1b8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175919))
- [Add duo_add_on_groups config for LDAP](https://gitlab.com/gitlab-org/gitlab/-/commit/58cab9d68b3cbaddda171bbe6cd7f4fbcd727d32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175101)) **GitLab Enterprise Edition**
- [Model registry: Add link to candidate](https://gitlab.com/gitlab-org/gitlab/-/commit/f0b433de5bd79fe2347a34bc5393b2ef5403c81b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176149))
- [Add audit event to CreateRunnerService](https://gitlab.com/gitlab-org/gitlab/-/commit/dfaa9d256941e78e614e5d276a1dfa9a82f627b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175447)) **GitLab Enterprise Edition**
- [Model experiments: Enhance experiment card title](https://gitlab.com/gitlab-org/gitlab/-/commit/66eb033cb2d8b0da8423f648de5e8352d1ceea98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175700))
- [Show Related MR's in dev widget with deduplication](https://gitlab.com/gitlab-org/gitlab/-/commit/6f65f199034936fbf8385593dfd27a06fcca42bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174812))
- [Add iteration support to content editor](https://gitlab.com/gitlab-org/gitlab/-/commit/c842a08facaeb9ba6945d7a9e67f4c8710a36bc8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175981))
- [Adds scheduled workers for dormant member removal](https://gitlab.com/gitlab-org/gitlab/-/commit/1921d01eb14fd691ed3f9a8a7138bcb9ab3cb35f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157930))
- [Add web_hook_logs_daily table](https://gitlab.com/gitlab-org/gitlab/-/commit/8bb2d8c31fdddd7a8c5f2369bfc52503cdf4c516) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175379))
- [Update semver_dialects to 3.4.5](https://gitlab.com/gitlab-org/gitlab/-/commit/ac417ebfca206d21d557bda4a21cc8d3f54d0837) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175297))
- [Add status deprecated to the packages statuses](https://gitlab.com/gitlab-org/gitlab/-/commit/a66644a0a15aad39b43384e447ce3184de92f900) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174312))
- [Add ability to assign GitLab Duo seats based on SAML groups](https://gitlab.com/gitlab-org/gitlab/-/commit/2e5ea3cb9cb2db172f80479e5ffcbd3d16af6e6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170502)) **GitLab Enterprise Edition**
- [Extend GraphQL with  policies overriding project approval settings in MR](https://gitlab.com/gitlab-org/gitlab/-/commit/4cd2fe2da596e9c3a560ca4d149bcff100ad0683) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175614)) **GitLab Enterprise Edition**
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/bbafba73fd3eeb17747eb5ae6526b1a022134f2c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176014))
- [Add container tag protection rules to project](https://gitlab.com/gitlab-org/gitlab/-/commit/b18810e676c3ea3f84dd60bd8c0ff6a79196ed7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174954))
- [Model registry: Add Experiment to model card](https://gitlab.com/gitlab-org/gitlab/-/commit/cf4046fa83d03710c65263f0b482ec4c565a0c9d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174378))
- [Add unique domain regenerate button](https://gitlab.com/gitlab-org/gitlab/-/commit/3268fba94e3c77b896008db3cc6d5da5b1dc7a8a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172479))
- [Add warning modal when creating work item](https://gitlab.com/gitlab-org/gitlab/-/commit/da38beec44ec6f3cd4505b0264409b0dfac72b79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170657))
- [Add arkose_labs_enabled application setting](https://gitlab.com/gitlab-org/gitlab/-/commit/4c5867249aabba2a2403888b11e3ddc5a5171a81) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175748)) **GitLab Enterprise Edition**
- [Remove feature flag custom_ability_admin_push_rules & keep new code](https://gitlab.com/gitlab-org/gitlab/-/commit/a720e9f423f13723160a3659b97928433b30e998) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175807))
- [Adding Service Ping metric for dependency api](https://gitlab.com/gitlab-org/gitlab/-/commit/73a7f22b0ad0f3b4238f2bd7e0e95b1331f4bb51) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175725)) **GitLab Enterprise Edition**
- [Add support for using ActiveRecord::Encryption](https://gitlab.com/gitlab-org/gitlab/-/commit/df74fa198c25095508b54e765d4629959b1e44ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175154))

### Fixed (88 changes)

- [Prevent Direct Transfer from incorrectly marking entities as stale](https://gitlab.com/gitlab-org/gitlab/-/commit/9815b2ccb4b9a4fffec75884b8aa34cb2604e73c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177587))
- [Reassign runner's owner when owning project is deleted](https://gitlab.com/gitlab-org/gitlab/-/commit/0a8f791205092ca19ea34d7623eb463237627e3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176879))
- [Fix visitor location country localization](https://gitlab.com/gitlab-org/gitlab/-/commit/ce7e367a04bfbc5f8fd863b83030c6ad0beacb38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177761))
- [Reset `resolved_at` attribute vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/ec370e873dd44e6fc76d4fb6ad394a94176e663e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177713)) **GitLab Enterprise Edition**
- [Fix `/unlink` quick command to work with epic work items](https://gitlab.com/gitlab-org/gitlab/-/commit/538cbb0d79866ef533aa458bca7fc530076c4028) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177763)) **GitLab Enterprise Edition**
- [Use NamespaceProjectIdsEachBatch instead of for_group_and_its_subgroups](https://gitlab.com/gitlab-org/gitlab/-/commit/144b66e5dce6ece67e746aa2bec0a5dd8af858fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177091))
- [Add resource context to Duo Chat history](https://gitlab.com/gitlab-org/gitlab/-/commit/68c5d5b33f87810c8071a4c6c79632bc368232c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174881)) **GitLab Enterprise Edition**
- [Protected Container Repositories: Fix link in documentation](https://gitlab.com/gitlab-org/gitlab/-/commit/ad0cab62b9755d3eabb0af2faa8f17d6521cf44d) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177672))
- [Fix UI text in lock and unlock file modal](https://gitlab.com/gitlab-org/gitlab/-/commit/5e8244ddb76abf11b548ba24a4623bdd9e37823e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177601)) **GitLab Enterprise Edition**
- [BBS handle missing users when user mapping](https://gitlab.com/gitlab-org/gitlab/-/commit/28ac706e06c66f8ea9f8b2d68d34211e12a6dea1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177321))
- [Documentation and refactor for Duo group/subgroups bug fix](https://gitlab.com/gitlab-org/gitlab/-/commit/2d69d67ca8be67bd0d8a4e661756107ecbd3d6c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177340)) **GitLab Enterprise Edition**
- [Make ClickHouse write buffer workers compatible with Redis 6.0](https://gitlab.com/gitlab-org/gitlab/-/commit/cab74b70535f6d1b7bc5e9596875e20469d15b7c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176184))
- [Update FinishBatchedRelationExportWorker to fail export on timeout](https://gitlab.com/gitlab-org/gitlab/-/commit/55b1e3c03a894aca2ae15a63c726899a9fb7dd67) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177559))
- [Last commit: Fix alignemnt of right content](https://gitlab.com/gitlab-org/gitlab/-/commit/270547c59af84924adfde92cf61fa39d18f97895) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177543))
- [Fix circular reference with pipeline execution policy variables](https://gitlab.com/gitlab-org/gitlab/-/commit/be4dfeff61d610be9801a27cf64269b05c9cec37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176152)) **GitLab Enterprise Edition**
- [Update Secure sub-section of the sidebar to show only permitted items](https://gitlab.com/gitlab-org/gitlab/-/commit/28e52591b2c2d87e1288e43f7792f060093ec547) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175865)) **GitLab Enterprise Edition**
- [Fix Pages primary domain not getting saved](https://gitlab.com/gitlab-org/gitlab/-/commit/0e9055eb18a8187cb201c9500b0a33d76bd33f1b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177424))
- [Set the used_storage_bytes to default when it is 0](https://gitlab.com/gitlab-org/gitlab/-/commit/a06f86d21e04f401843f8aa667efe134363e8ed4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177419)) **GitLab Enterprise Edition**
- [Lazily initiate a Redis publish/subscribe channel](https://gitlab.com/gitlab-org/gitlab/-/commit/e8deefcce4bba742843c6958eb58ff1f8a80630a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177057))
- [Fix handling of short gzip metadata files](https://gitlab.com/gitlab-org/gitlab/-/commit/978fa9a5fee79895a493d63b32c9ea08e73c8c49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177221))
- [Apply all filters to flowMetricsQuery](https://gitlab.com/gitlab-org/gitlab/-/commit/dfd1585cbe3c4074a43841bdfad1ef6882bd4175) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176346))
- [Update the default API value for environment auto stop setting](https://gitlab.com/gitlab-org/gitlab/-/commit/8bd0140346bd7061b8ac642470f434569fb15895) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177328))
- [Make sure MR sticky header is accessible when browser font size=large](https://gitlab.com/gitlab-org/gitlab/-/commit/2a2206fde85af31147c759e564d3658c0281a2a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177310))
- [Fix mobile layout for requirements list page](https://gitlab.com/gitlab-org/gitlab/-/commit/654b0054eff607c3e0101cf6807dd24f27f458d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177170)) **GitLab Enterprise Edition**
- [Show Iteration field on items within the work items Child widget](https://gitlab.com/gitlab-org/gitlab/-/commit/ca3c94c06e0ef1787ce6174c02f67f5bf37d9047) by @vedant-jain03 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176306))
- [Fix pipeline execution policies skipping when allowed](https://gitlab.com/gitlab-org/gitlab/-/commit/3263e938b0cc96bd57927d9706d87f04aa86bbe5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177266)) **GitLab Enterprise Edition**
- [Reverse toggle to enable skip ci behavior for policy](https://gitlab.com/gitlab-org/gitlab/-/commit/9faa0041eac38656236cf156897cac01af42419b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177169)) **GitLab Enterprise Edition**
- [Fix sizing of done/redo button on mobile todo page](https://gitlab.com/gitlab-org/gitlab/-/commit/ec3cc5e09ae15e7cac653206ae367b843458e3d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177168))
- [Show milestone popover for GFM references to group milestones](https://gitlab.com/gitlab-org/gitlab/-/commit/3ca6538bfe7d17eb638cafea58a94f38e4df3e9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177186))
- [Use data from current tab of Vue MR list page for export to CSV](https://gitlab.com/gitlab-org/gitlab/-/commit/40665a30700c21752cfa516905f800bf4be51752) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176196))
- [Geo Replication - Fix incorrect breadcrumbs](https://gitlab.com/gitlab-org/gitlab/-/commit/452a5985a13d7d2e905ce8e4276e12ccdc1f13bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177148)) **GitLab Enterprise Edition**
- [Ensure REST API handles SSH key expiry todos](https://gitlab.com/gitlab-org/gitlab/-/commit/99cfae558b38464fe3e52931d6e4a790bf3180f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177144))
- [Ensure users can receive notifications before verifying email](https://gitlab.com/gitlab-org/gitlab/-/commit/28eafda13a1d73f3476fe279df950e1cd9a44fbe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176818))
- [Fix typo in policy UI editor for skip ci allowlist](https://gitlab.com/gitlab-org/gitlab/-/commit/afa464ecc77b153b66b3782194a69af2b811b481) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177081)) **GitLab Enterprise Edition**
- [Fix undefined method error for `remaining_pipl_access_days`](https://gitlab.com/gitlab-org/gitlab/-/commit/fe9f38d8e08b73995298501aa0bde8b42c720ea5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176851)) **GitLab Enterprise Edition**
- [Fix missing variables for DAST scans](https://gitlab.com/gitlab-org/gitlab/-/commit/b88d72b08b43ba9d6651d93e1dd6e3f7ac49b63d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176882)) **GitLab Enterprise Edition**
- [Fix resource access token bot namespace bug for admin users](https://gitlab.com/gitlab-org/gitlab/-/commit/23276cf43c0e7948925d52829edfa825a1d67151) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177018))
- [Remove unnecessary padding for policy warning icon](https://gitlab.com/gitlab-org/gitlab/-/commit/58da79a17c9df4c8b132a7c93673c5f0ac5e7782) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176974))
- [Remove "go_get_handle_relative_url" feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/911c3b164305c9eeebf6d4418a66d29c7897272e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176972))
- [Use add on trial dates for combined trial on premium](https://gitlab.com/gitlab-org/gitlab/-/commit/26abffe3593b3156f0d8e36ec8c022fbf29d5d24) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176780)) **GitLab Enterprise Edition**
- [Fix policy name in MR with trailing numbers](https://gitlab.com/gitlab-org/gitlab/-/commit/fcc13de079cf1575607f649cac36f82bdb85e2be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176629)) **GitLab Enterprise Edition**
- [Move User namespace audit events to instance scope](https://gitlab.com/gitlab-org/gitlab/-/commit/0ef9e46a77413ac93de17611bf108a7ce696e0ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176943)) **GitLab Enterprise Edition**
- [Don't post policy bot comments in MRs of archived projects](https://gitlab.com/gitlab-org/gitlab/-/commit/0cff41469d3e0b62481ee9aea0c8cd11786cf66d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176870)) **GitLab Enterprise Edition**
- [Fixing audit event group path failure](https://gitlab.com/gitlab-org/gitlab/-/commit/649066800d572f51305408994c83f0e5d686d8bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176855))
- [Add BoardEpicConnection type policy for pagination](https://gitlab.com/gitlab-org/gitlab/-/commit/a70ec596c2f07f9a05289994bd2af8baedcb3bd1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176803)) **GitLab Enterprise Edition**
- [Fix 500 error when banzai commit filter incorrectly captures a group](https://gitlab.com/gitlab-org/gitlab/-/commit/40588193b6092caefd20babecfe3ba8aadb457d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176770))
- [Add reference permission check for group level items](https://gitlab.com/gitlab-org/gitlab/-/commit/38a0a03077346fa5824a519430e4c38efde57a6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176500))
- [Merge branch...](https://gitlab.com/gitlab-org/gitlab/-/commit/af768407f2bbb1b2fbdf707dde684ae87f2aed5a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176552))
- [Update acme-client to v2.0.19](https://gitlab.com/gitlab-org/gitlab/-/commit/6371ad0e9f88a691291dbc19b5afbeffb179e154) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176465))
- [Fix failed jobs widget polling issue](https://gitlab.com/gitlab-org/gitlab/-/commit/6f61aaa0b4127f4dd9a456ea672575a428655f3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176402))
- [Restore diff file draft note editing state](https://gitlab.com/gitlab-org/gitlab/-/commit/c65ad27d08fb29605d1c3af8fcb7693174c9e695) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176559))
- [Add a migration to regenerate CI job token signing key](https://gitlab.com/gitlab-org/gitlab/-/commit/192b99d50c6349f64f2a2bc727c6d532903c8311) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176483))
- [Fix CI job token signing key not always generated](https://gitlab.com/gitlab-org/gitlab/-/commit/72a4f3c0bc3f4af6e7eb7fa7fb1d83f1303f0c52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176483))
- [Fix issues boards unable to fetch issues for anonymous users](https://gitlab.com/gitlab-org/gitlab/-/commit/0b97b746eb70d1d3010af5ea8282f80d9465da74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176482))
- [bug: Fix appearance of protected badge in group package overview](https://gitlab.com/gitlab-org/gitlab/-/commit/1de4111988e5ab69f2c805615e4d1fb6dc81060d) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174243))
- [Fix NoMethodError on most_recent_commit_sha method](https://gitlab.com/gitlab-org/gitlab/-/commit/d11b82291734d08ad790d00284f592cdd1ac466e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176308)) **GitLab Enterprise Edition**
- [Only create Geo verification records if primary checksumming enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/7dce11060c4fe1a67f5989f6c902f3e3629f6209) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173901)) **GitLab Enterprise Edition**
- [Update subscription check for hide duo section](https://gitlab.com/gitlab-org/gitlab/-/commit/f2c6c3e66d570d99e4cd0bffc8c81ee47f610f7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175625)) **GitLab Enterprise Edition**
- [Provide a workaround for users that do not have a registration_type](https://gitlab.com/gitlab-org/gitlab/-/commit/7ba2277afb48ac878c4a189bc068e442b127f93c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176195)) **GitLab Enterprise Edition**
- [Only show repo file tooltip when truncated](https://gitlab.com/gitlab-org/gitlab/-/commit/b494fcb7864aa887e517e2b4103f66d90481ab28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158252))
- [Make ClickHouse exclusive lock compatilble with Redis 6](https://gitlab.com/gitlab-org/gitlab/-/commit/12339e03f48dc5044ce6c1a875b74bc647513543) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176041))
- [Fix Analytics dashboards description `Show more` toggle button](https://gitlab.com/gitlab-org/gitlab/-/commit/6ce5d5ec2d8dc14537998d622a39d05fc48bebbf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176395)) **GitLab Enterprise Edition**
- [Use the project_id_from and project_id_to in InitialIndexingEventWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/af38e768f23d31c881036b90fdef206698508bc8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176224)) **GitLab Enterprise Edition**
- [Fix resetting timer on ChunkWriter](https://gitlab.com/gitlab-org/gitlab/-/commit/04f347b3306fc6fa508e1dc18c675b869d656df9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176348))
- [Fix last commit styling when description is expanded](https://gitlab.com/gitlab-org/gitlab/-/commit/0175a0467051995a13b723a749650bbd817ec4a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175764))
- [Preserve saved access levels when re-enabling project features](https://gitlab.com/gitlab-org/gitlab/-/commit/d234c0c342f5718aa13cb9eda02d60ea7757edcb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174114))
- [Handle SSO redirect during authorization](https://gitlab.com/gitlab-org/gitlab/-/commit/cf9fcdbb7c07b09cbaf83f4eb6828972a41c165c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175618)) **GitLab Enterprise Edition**
- [Fix Gitlab::Audit::NullAuthor string keyword splat](https://gitlab.com/gitlab-org/gitlab/-/commit/e218991b2b346967dcbc6ab95e9af8a4057ab9fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176327))
- [Protected containers: Show protected badge in group container overview](https://gitlab.com/gitlab-org/gitlab/-/commit/a58934bb2b29f4cb408f47f7cda589fd0dda5ea9) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174033))
- [Fix index to evict event worker](https://gitlab.com/gitlab-org/gitlab/-/commit/76d9174c509963a41205f89e61866a87d50ae847) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176246)) **GitLab Enterprise Edition**
- [Fix foreign key error while backfilling](https://gitlab.com/gitlab-org/gitlab/-/commit/499fd72f4ebd426777426db19a036330cea2731b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174545)) **GitLab Enterprise Edition**
- [Fix appearance of merge split button](https://gitlab.com/gitlab-org/gitlab/-/commit/9197848c24b2c9dfd64ea6543442654bb2582c08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175315))
- [Fix infinite scroll when inviting a group to a project](https://gitlab.com/gitlab-org/gitlab/-/commit/440b8c1dfe11158e9575920087e66987d8b17862) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176194))
- [Pipeline stage job polling fix](https://gitlab.com/gitlab-org/gitlab/-/commit/580f444d8875b5e7bdefb2fd3b07eb70f264893c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175926))
- [Fix backoff of disabled webhooks ramp up too fast](https://gitlab.com/gitlab-org/gitlab/-/commit/1715a8d64a9a4ae5325d9f1673467f14b7c68beb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172449))
- [Fix audit events destination_url to be public](https://gitlab.com/gitlab-org/gitlab/-/commit/601539bb03afb4ebf23b801da9c9658151cf3910) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175903)) **GitLab Enterprise Edition**
- [MR widget alert warning: border bottom and fix border-radius](https://gitlab.com/gitlab-org/gitlab/-/commit/959c1c16afb1a85186a56a7d3311f21459d46fc2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176094))
- [Zoekt: Fix negative unclaimed storage bytes](https://gitlab.com/gitlab-org/gitlab/-/commit/0826899d3b854628dc11af54174d4d4e5ace93b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175561)) **GitLab Enterprise Edition**
- [Replace DB unique index with model validator](https://gitlab.com/gitlab-org/gitlab/-/commit/692b65dcc9aedbedb07c5cb13d39314b3186da94) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175167))
- [Fix edge case when trying to access policy approval_settings](https://gitlab.com/gitlab-org/gitlab/-/commit/cf065a5eb1938189fcebbc50020ac887e48dbf38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176098)) **GitLab Enterprise Edition**
- [Fix issue in RTE with image resize](https://gitlab.com/gitlab-org/gitlab/-/commit/2e79df1681b805fbb72c490b56c94615a5f508b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176017))
- [Fix issue with preserving checkboxes whitespace](https://gitlab.com/gitlab-org/gitlab/-/commit/39128a438791f7f7634ce3224691ee69470b9bce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175991))
- [Use correct height value for emoji picker rows](https://gitlab.com/gitlab-org/gitlab/-/commit/5cd2cf85460841d5a336c088584944345911e106) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176045))
- [Fix a case-sensitivity issue in the application rate limiter](https://gitlab.com/gitlab-org/gitlab/-/commit/ac404842d0b44168cb3275580a0d12b943929b54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175930))
- [Skip copying over custom award emoji that do not exist](https://gitlab.com/gitlab-org/gitlab/-/commit/1c15f2091557a0cab04ec22b7e45fc6e13ea6b43) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175712))
- [Fix Random.rand for zero values in RuleScheduleService](https://gitlab.com/gitlab-org/gitlab/-/commit/d138c824fffd8344123d8cbf06f0548c16028d7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175838)) **GitLab Enterprise Edition**
- [Ignore system notes when indexing notes on work items](https://gitlab.com/gitlab-org/gitlab/-/commit/c102c108431418d9f57f32f46e1364b9a18f7417) by @joe-snyder ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175632)) **GitLab Enterprise Edition**
- [Restrict PAT informaton endpoint to PAT authentication](https://gitlab.com/gitlab-org/gitlab/-/commit/8e93cea85b1834b7187ac67304107223435673ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175820))

### Changed (102 changes)

- [Fix layout of requirements](https://gitlab.com/gitlab-org/gitlab/-/commit/4844cfe12d7f1419f82c065087d6157339531848) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177179))
- [Abstract project topics to reusable component](https://gitlab.com/gitlab-org/gitlab/-/commit/84cd634b90287153e2999ff9316ebb74cb281375) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177496))
- [Change language filter icon to "code"](https://gitlab.com/gitlab-org/gitlab/-/commit/fbec86ddb305a7cff59cbebe6bf0ed7653c61924) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177789))
- [Update environments list page](https://gitlab.com/gitlab-org/gitlab/-/commit/d5ec48b57977d027eb4184a6d2c0fc1a00424196) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176595)) **GitLab Enterprise Edition**
- [Modify gl-icon in email_verification.vue to use info variant and size 16](https://gitlab.com/gitlab-org/gitlab/-/commit/faf36fd1f8d6f27b51283f3fca8173d2e97bceb9) by @alvinowyong ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177295))
- [Update operational vulnerabilities info](https://gitlab.com/gitlab-org/gitlab/-/commit/f563283112e558e415157828accf4dce9bd8e69e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177618))
- [Fix AdjustmentService to use SEC DB connection](https://gitlab.com/gitlab-org/gitlab/-/commit/60a263669aeb2bd2770ad35ae6b256dbf7bb285e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177731)) **GitLab Enterprise Edition**
- [Split SCIM tables](https://gitlab.com/gitlab-org/gitlab/-/commit/fa66c7e206bc167529aea6fbe64865b11dc95df9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170565))
- [Reject soft-deletion of groups containing security policy projects](https://gitlab.com/gitlab-org/gitlab/-/commit/6525f1ba7459c1aae178113c8f5b88a011713f5a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176602)) **GitLab Enterprise Edition**
- [Specify SCIM as reason for DestroyService audit event](https://gitlab.com/gitlab-org/gitlab/-/commit/5db084a9c7494dcb6dad3f54a757fe0d432d8858) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177629)) **GitLab Enterprise Edition**
- [Set Amazon Q service account username](https://gitlab.com/gitlab-org/gitlab/-/commit/e9936ea7e50c56b48996dfcef31652b37c1f254e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177521)) **GitLab Enterprise Edition**
- [Adjust hidden variables error messages](https://gitlab.com/gitlab-org/gitlab/-/commit/fe15ba4ead868f0e04b11ec1ec3d5d40d60dcf77) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166286))
- [Set codeowner_role_approvers to default enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/a37075c4582c33a5907909918fa99f471c22363d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177410))
- [Added project id to the internal workflow API get method](https://gitlab.com/gitlab-org/gitlab/-/commit/5ae03db3dac22cb6279a6f7466c6efd252799674) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177565)) **GitLab Enterprise Edition**
- [Remove flag gitaly_pack_objects_hook_with_sidechannel](https://gitlab.com/gitlab-org/gitlab/-/commit/39f51b573d9370f9a8f2fb8020c0e1cc513f5c77) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176393))
- [Update edit blob to use commit change modal](https://gitlab.com/gitlab-org/gitlab/-/commit/94cb69d12af14f89e59726e17ea2ba68765cb542) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174936))
- [Amazon Q service account has private profile](https://gitlab.com/gitlab-org/gitlab/-/commit/7732f2cb6d0f9602153b5c5c004d432612315f99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177513)) **GitLab Enterprise Edition**
- [Easily copy link to current issue template from URL](https://gitlab.com/gitlab-org/gitlab/-/commit/07d9b1f36c766c374716efec5bcf0a2ef4389bb1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177215))
- [Remove `auto_resolve_vulnerabilities` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/c20e9d5ab184c1329cbf1262513f76755329f4b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177487)) **GitLab Enterprise Edition**
- [Support enablement of Fireworks/Qwen model by top-level group](https://gitlab.com/gitlab-org/gitlab/-/commit/a73aec8262d259e47e9d51d63484bc371cd5d786) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176841)) **GitLab Enterprise Edition**
- [Remove tooltip from activity item](https://gitlab.com/gitlab-org/gitlab/-/commit/249e22a64ec988d86930b0bc7760d48693fb7710) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177313))
- [Model experiments: Rename candidate to run](https://gitlab.com/gitlab-org/gitlab/-/commit/ed296a14e6f6896c59fbcd4a89f8beed13c797c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177444))
- [Remove duo_seat_assignment_email_for_sm feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/aca41518cf9a5211949ea56766289bd64d6cb8ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177462)) **GitLab Enterprise Edition**
- [Model registry: rename candidate to "run"](https://gitlab.com/gitlab-org/gitlab/-/commit/e73083a1c41a06024c87a1a7becabcf8673c952c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177294))
- [Enable FF policies_always_override_project_ci by default](https://gitlab.com/gitlab-org/gitlab/-/commit/1f91a1f665e7871453ebaef7146d6c1af6d383f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177469)) **GitLab Enterprise Edition**
- [Dont show amazon q with duo add ons](https://gitlab.com/gitlab-org/gitlab/-/commit/4d99370cb9418c0aef56ef1db3163ff058dfa35d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177317))
- [Make in-app trials display fixed](https://gitlab.com/gitlab-org/gitlab/-/commit/1b19d6b0be2582258c0dd1062e49d4f762ff4e39) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177264)) **GitLab Enterprise Edition**
- [Show file type in security scan artifact download dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/b42bf9d862d1eddee8a2e6ccc915e6cfc083604f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177272))
- [Promote project.dependencies to generally available](https://gitlab.com/gitlab-org/gitlab/-/commit/90fb84cecada748b6989a85b4cff740f6ae12fd4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177450)) **GitLab Enterprise Edition**
- [Update adherence report drawer heading](https://gitlab.com/gitlab-org/gitlab/-/commit/f98dda4fd55059470755e43f64cd9f56d51499a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177332)) **GitLab Enterprise Edition**
- [Add X-Gitlab-Feature-Enablement-Type AI Gateway header](https://gitlab.com/gitlab-org/gitlab/-/commit/cb9ba07ad89f090ab3cc666e9d375f0ababe03c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176329)) **GitLab Enterprise Edition**
- [Enhance model experiments listing page](https://gitlab.com/gitlab-org/gitlab/-/commit/bdf6779047dd79920cb5712df768a3bc90e5b6a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176603))
- [Ref container darkmode color changes](https://gitlab.com/gitlab-org/gitlab/-/commit/4b4b00d3d8acb7b412d3f28cc2b16aa4dc9947b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171561))
- [Remove automatic feature access level adjustments when updating project visibility](https://gitlab.com/gitlab-org/gitlab/-/commit/05dc8f47f7bdd6d5ce6d9f06096103a00593442d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175070))
- [Remove WalReceiverSaturation indicator](https://gitlab.com/gitlab-org/gitlab/-/commit/cfdd6bf4b05b23b42bf45ff1dfdf9c5356c2b49a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177021))
- [Rename pages_default_domain_redirect to pages_primary_domain](https://gitlab.com/gitlab-org/gitlab/-/commit/f45bed58832d47b9f9bea6ac052a9a20959b9775) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176651))
- [Drop use of AWS SDK v1 in Workhorse uploads](https://gitlab.com/gitlab-org/gitlab/-/commit/bd66f8ff561b80fd1a20a8e82af4391748130349) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177161))
- [Change tooltip text and icon for Summarize button on issues](https://gitlab.com/gitlab-org/gitlab/-/commit/f12ef10445ea74668c120d125cfc87cac6f4241f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175087))
- [Allow nil values for project_id_to in zoekt index metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/0850cac2723dc6c9949b9e4ba228bf970c99e0f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175945)) **GitLab Enterprise Edition**
- [Update CreateIssueService rollback](https://gitlab.com/gitlab-org/gitlab/-/commit/45bfc379c9396c80a34ce635dde4378266b1c1a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176154)) **GitLab Enterprise Edition**
- [Remove default value for organization_id](https://gitlab.com/gitlab-org/gitlab/-/commit/75f3d3ef47eff70a64e0797a542881217d0a2187) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177080))
- [Change tooltips to HelpPopover in projects import](https://gitlab.com/gitlab-org/gitlab/-/commit/d6264503e29cf3078ca403a72c2a088d11162414) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176750))
- [Use diff_blobs for streaming compare rapid diffs](https://gitlab.com/gitlab-org/gitlab/-/commit/cb786bbb976bcbd369de8811ae7c880cf0d5b529) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174982))
- [Reject deletion of security policy projects](https://gitlab.com/gitlab-org/gitlab/-/commit/2b4b439c654a77ac07949877b81182dfc5f76adc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176601)) **GitLab Enterprise Edition**
- [Change pipeline identifier priority](https://gitlab.com/gitlab-org/gitlab/-/commit/38a814a3f67e3f72faad971d8002bf8053934ae1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177011))
- [Repaced and removed css gl-last-of-type-border-b-0](https://gitlab.com/gitlab-org/gitlab/-/commit/5921d0fc52a7f67dc7d5f59e952bad6478f764ab) by @illia_bakunovskyi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172870))
- [Group usage quotas: Update page hierarchy](https://gitlab.com/gitlab-org/gitlab/-/commit/763b438bea7b7154974e0d7f772ec5da922f823e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176265)) **GitLab Enterprise Edition**
- [Refactor topics admin page to use PageHeadingComponent](https://gitlab.com/gitlab-org/gitlab/-/commit/68f0dce2d59495b34f155359516f87840328335e) by @bufferoverflow ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170241))
- [Add validation for license rule](https://gitlab.com/gitlab-org/gitlab/-/commit/3917deddddcc245d3d10c12f2e68975b40977aa4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176445)) **GitLab Enterprise Edition**
- [Update widget in pipeline editor to use pipeline summary component](https://gitlab.com/gitlab-org/gitlab/-/commit/77c7d396c2857a0a730332a3b1d7b8679d297b75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175179))
- [Update licenses validation](https://gitlab.com/gitlab-org/gitlab/-/commit/1c4267febf66844af1560dc29f32413067358d8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176889)) **GitLab Enterprise Edition**
- [Unify error messages styling when onboarding](https://gitlab.com/gitlab-org/gitlab/-/commit/ca2788e54c7d1664f2a5246b602fc577bcd5d9b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176846))
- [Updates BBM docs](https://gitlab.com/gitlab-org/gitlab/-/commit/53b9386e18c1c412253724e0cbcb829a1c6f98bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175994))
- [New split view for a policy editor](https://gitlab.com/gitlab-org/gitlab/-/commit/92e1315b6cace0d2d57ef4118247baecd5ecc140) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176062)) **GitLab Enterprise Edition**
- [Remove validation for branches on group level](https://gitlab.com/gitlab-org/gitlab/-/commit/5c45399c5b3805a3057068cc5c1db63939d9a4e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175866)) **GitLab Enterprise Edition**
- [Enhance experiment candidate(run) detail page](https://gitlab.com/gitlab-org/gitlab/-/commit/e96e0f085bb7c282368560939ecf308f3d113ada) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175957))
- [Fix icon text alignment](https://gitlab.com/gitlab-org/gitlab/-/commit/3865a55ffdd733258354d41b74c2c58eaed3143f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176680)) **GitLab Enterprise Edition**
- [Sync index creation for p_ci_builds.trigger_request_id](https://gitlab.com/gitlab-org/gitlab/-/commit/2076737fd69773c0006ea090058b5ed7f39b660a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176641))
- [Moved seat_control from helper to controller](https://gitlab.com/gitlab-org/gitlab/-/commit/0deea04db8477c31d49a911014f6620a175da432) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176649)) **GitLab Enterprise Edition**
- [Remove old completions class and update service_class](https://gitlab.com/gitlab-org/gitlab/-/commit/0ebb0daf3776d466788571beefa837843098b7d1) ([merge request](https://gitlab.com/foo/bar/-/merge_requests/176468))
- [Enable scan_execution_pipeline_concurrency_control ff](https://gitlab.com/gitlab-org/gitlab/-/commit/229bae74c99e2faa81a3f7e3417c8c54aad9dd1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176469)) **GitLab Enterprise Edition**
- [Remove database default for organization_id from oauth tables](https://gitlab.com/gitlab-org/gitlab/-/commit/6106b31a16dae67ed50f4cd9bbb63d21fb2ab29b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175690))
- [Removed sync code for seat_control and new_user_signups_cap](https://gitlab.com/gitlab-org/gitlab/-/commit/26d3684a816e1ceff2338f4c152c4e722196753e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174712)) **GitLab Enterprise Edition**
- [Changes index on namespace_settings](https://gitlab.com/gitlab-org/gitlab/-/commit/eb97d8f5cd6dacb1350f7931d6617f56217e6583) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176454))
- [Add instructions in the pipeline editor for configuring jobs for MRs](https://gitlab.com/gitlab-org/gitlab/-/commit/7f39e9b7620ce55a51fdb8a9277571550c2c1ef9) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175715))
- [New machine learning runs use ml_model package type](https://gitlab.com/gitlab-org/gitlab/-/commit/8934468f93e76b22495557646320a850cbcf7ad3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173680))
- [Make details disclosures easier to spot in rendered markdown](https://gitlab.com/gitlab-org/gitlab/-/commit/8cee1c3660cf2745bcc9b1799d559ba12c5c245b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176396))
- [Added link to project and group](https://gitlab.com/gitlab-org/gitlab/-/commit/05d7b3ac0644e98b478d9323d3f7af0e25d6917a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176379))
- [Update label text for protected branch in commit change modal](https://gitlab.com/gitlab-org/gitlab/-/commit/dc046d7abeda5b5f9b6ff632af61408417f880f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176190))
- [Help Icon: Removes small size and replaces it with default](https://gitlab.com/gitlab-org/gitlab/-/commit/f01ef9c192026c79ee21db19d999406b3c985298) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176252))
- [Consolidate pipeline queries](https://gitlab.com/gitlab-org/gitlab/-/commit/4fe561fc1b84f467f566c5a8dc45d6416e3a503e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175914))
- [Update Kubernetes agent registration](https://gitlab.com/gitlab-org/gitlab/-/commit/8b0d1ea6e6c7e2087f26be6187a1858e469ce4a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175766)) **GitLab Enterprise Edition**
- [Improve readability of status icon](https://gitlab.com/gitlab-org/gitlab/-/commit/c6e09b5b3e9ce9ecb9fdd61174c9c848a66fba78) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176337)) **GitLab Enterprise Edition**
- [feat: Toggle Duo Chat drawer state instead of only showing](https://gitlab.com/gitlab-org/gitlab/-/commit/2d5efd1590b66e9dc9f2b5a3aa855f33bc47f710) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176288)) **GitLab Enterprise Edition**
- [Remove `download_code` dependency from access to read merge requests](https://gitlab.com/gitlab-org/gitlab/-/commit/1c2beb5e05a289be664cce8440952f41f3cd51e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175444))
- [Markdown: Use fixed type scale](https://gitlab.com/gitlab-org/gitlab/-/commit/e977306445647036bfb1d98dca299e58ea0256bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175258))
- [Add auto-approval param in CE](https://gitlab.com/gitlab-org/gitlab/-/commit/a8cd7c3f6676ed894d624f8f735338f265ae32f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176026))
- [Use diff_blobs for streaming commit rapid diffs](https://gitlab.com/gitlab-org/gitlab/-/commit/4832a7b37ee28057cd44d3e15f78cb187e34770c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174863))
- [Updated SeatControl UX](https://gitlab.com/gitlab-org/gitlab/-/commit/de31b5bd361011d1b636bceed83125bb4e627fb9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174514)) **GitLab Enterprise Edition**
- [Allow dots in path_prefix in Pages](https://gitlab.com/gitlab-org/gitlab/-/commit/e116421722541fddd85621118d3e34730a4e7bfd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175563))
- [Fix Direct Transfer scopes copy to be precise](https://gitlab.com/gitlab-org/gitlab/-/commit/e0e707b530a6c8f079999dfebcffd7d77ed7c221) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176211))
- [Use YMD date for value stream metrics queries](https://gitlab.com/gitlab-org/gitlab/-/commit/d31dacd8fd204d20b3e987ecbe8c006442be6ab3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175081))
- [Update edit blob to use commit change modal](https://gitlab.com/gitlab-org/gitlab/-/commit/1abc4f15c479e9dd118318095ef08252abb67655) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174287))
- [Update styling in pipeline mini graph dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/e07fa88c9442ffa68a1032e5dc231647b0df39a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175888))
- [Show an Actions column name on the pipelines list on the desktop view](https://gitlab.com/gitlab-org/gitlab/-/commit/fbcfc70f16ad1e9dff770e3aa6f4a358096d07ff) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176019))
- [Release feature flag ml_experiment_tracking](https://gitlab.com/gitlab-org/gitlab/-/commit/d3813a073988bd66698a66ca7f9daa88f1a83f5e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175814))
- [Model Experiments: Add menu item to MLflow usage example](https://gitlab.com/gitlab-org/gitlab/-/commit/3479919e0ced5f6c7ea7b2b2de4076eaa05ed130) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175813))
- [Remove default value from namespaces.organization_id column](https://gitlab.com/gitlab-org/gitlab/-/commit/3940199f1fd7b5644698a89460f6fd75d4110f67) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174559))
- [Replace NamespaceSettings index with composite](https://gitlab.com/gitlab-org/gitlab/-/commit/19c14b16220a0b0059f189fa8698eebbd3dde84e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175678))
- [Add Auditor badge to Admin area Users page](https://gitlab.com/gitlab-org/gitlab/-/commit/ea9d892642d681d1c5a6782b7eb3af1329243714) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175654)) **GitLab Enterprise Edition**
- [Uses organization id on Topics GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/1e8f770c7944da17fd1f3e0386d83ceb57b8a1bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175114))
- [Update sign up path on Admin Settings](https://gitlab.com/gitlab-org/gitlab/-/commit/5c8388d6c13b2efd07ab111d9620443fae15b401) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176011))
- [Remove BackfillPCiPipelinesTriggerId](https://gitlab.com/gitlab-org/gitlab/-/commit/9e2cba271682a3665893719274733ec2a6c5b0fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175517))
- [Change CreateMergeRequestService rollback for sec](https://gitlab.com/gitlab-org/gitlab/-/commit/2e9dd22fb7e93fc6ef749264e05572f13958e11c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172673)) **GitLab Enterprise Edition**
- [Fix first and last pagination icon sizes](https://gitlab.com/gitlab-org/gitlab/-/commit/e19abef1284a1a5015debd6cb7e772f0644f5a37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175320))
- [Use projects icon and add tooltips in admin > groups](https://gitlab.com/gitlab-org/gitlab/-/commit/aef53ef54fccc85a285a705bd82440e838b21639) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175965))
- [Update text in dependency table](https://gitlab.com/gitlab-org/gitlab/-/commit/55af56d5b736dd5729e169f3d1c8a34bf4973f3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175722)) **GitLab Enterprise Edition**
- [Remove increase_lsif_artifacts_limit feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/bdeda8e613c87cb2d4227e9911862164ab955830) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175685))
- [Increase ci_max_artifact_size_lsif default limit](https://gitlab.com/gitlab-org/gitlab/-/commit/dc7de5ed4cc655b168555aca75bbd028f03074d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175684))
- [Remove correct_work_item_type feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/ad39360932acce95be609d8bc2d906a22c88c529) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175934))
- [Update dependency auto-deploy-image to v2.115.0](https://gitlab.com/gitlab-org/gitlab/-/commit/9513699bb86fecab8cd60fc83efe4991ca420966) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175416))
- [Set cache: [] in SAST latest CI templates](https://gitlab.com/gitlab-org/gitlab/-/commit/613bab02b3ce3ff4fd94b83a889980872620db3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174987))

### Removed (17 changes)

- [Removed the ignore rule](https://gitlab.com/gitlab-org/gitlab/-/commit/16e980b27a1eccb7f19bacf5320a4cd1cd9bdd3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176730)) **GitLab Enterprise Edition**
- [Remove top-level group concurrency docs](https://gitlab.com/gitlab-org/gitlab/-/commit/ee2b19ee7f77dfe47d45b5939181b0c3d39837e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177632)) **GitLab Enterprise Edition**
- [Remove feature flag 'vulnerability_code_flow'](https://gitlab.com/gitlab-org/gitlab/-/commit/f52b0757bcb79b2bc3eaedfd965a7b371b5fc17b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177248))
- [Remove ci_graphql_pipeline_mini_graph](https://gitlab.com/gitlab-org/gitlab/-/commit/67b3cb5a12ab1d9211a9847cd8e2841434a7fb3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176822))
- [Remove pipeline editor dead code](https://gitlab.com/gitlab-org/gitlab/-/commit/5c5f29d24c91926659479554e3ae7522810faf30) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175334))
- [Removing ci_secure_files_read_only feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e5c0a143be5d6248939bbcc551958db2956d70aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177033))
- [Remove epic cached count checking](https://gitlab.com/gitlab-org/gitlab/-/commit/0c3ea92d9cd91e7d5729504148b4c02b8bcadb20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176976)) **GitLab Enterprise Edition**
- [Remove sync_audit_events_to_clickhouse feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/eb6be9bb3fd10d96120caae122530a9ec259b246) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175370))
- [Create migration for synchronous index removal](https://gitlab.com/gitlab-org/gitlab/-/commit/41c7dfc9a7e8de5fce5085f623bffd9b5b4b6b8a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176673))
- [Remove namespace_descendants_cache_expiration FF](https://gitlab.com/gitlab-org/gitlab/-/commit/6c2d1737f15b4f588dfe69abaa66ff3f64e5992d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176643))
- [Dropping confidence column from security_findings](https://gitlab.com/gitlab-org/gitlab/-/commit/832e071a3789e475532be32821b7147b6ba255de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176415))
- [Remove `use_holt_winters_forecast_for_deployment_frequency`](https://gitlab.com/gitlab-org/gitlab/-/commit/57073e040576fc72e3f333ba8938c621b601cf83) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175893)) **GitLab Enterprise Edition**
- [Remove require_resource_id feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/6b715a248f4026707a4c060187dfa835f88f65a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176155))
- [Remove self_hosted_models_beta_ended FF](https://gitlab.com/gitlab-org/gitlab/-/commit/15709f32291a6402e79ffbea9a986b7cd97a6ba1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176278))
- [Remove code_suggestions_usage_events_in_pg feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/326e9b308f206b2062f68b06d625ed49ab83b1db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175836)) **GitLab Enterprise Edition**
- [Remove groups_with_event_streaming_destinations metric](https://gitlab.com/gitlab-org/gitlab/-/commit/6f61a3d13eaf22c77e41e157474e8dfa48568115) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173590)) **GitLab Enterprise Edition**
- [Remove the 'auth_finder_no_token_length_detection' FF](https://gitlab.com/gitlab-org/gitlab/-/commit/31ce2ac7133143e567350dc2c7fc53c0d745d6c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175276))

### Security (12 changes)

- [Update KaTeX to fix several CVEs](https://gitlab.com/gitlab-org/gitlab/-/commit/6c0e0890a99748f9e73c9ebb6e010934f795c9d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176404))
- [Update rails to 7.0.8.7](https://gitlab.com/gitlab-org/gitlab/-/commit/ed8267b6d57c9bb995eb714d790fbff81f65277e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176769))
- [Revert "Merge branch 'sh-fix-http-io-empty-gz-handling' into 'master'"](https://gitlab.com/gitlab-org/gitlab/-/commit/7d5162c849e182435b05da0def80642972700502)
- [Add strong parameters to the passwords_controller](https://gitlab.com/gitlab-org/gitlab/-/commit/1bb92907f6c0e02cbf3152f8759b5f31e4fb26f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177050))
- [Fix handling of short gzip metadata files](https://gitlab.com/gitlab-org/gitlab/-/commit/0bd210b633756857a3ed1884eef58d248fc7ad0c)
- [Filter out sensitive parameters on Auth logs](https://gitlab.com/gitlab-org/gitlab/-/commit/4f778ed32ee45feb6ad66087108e2972ae2b9dee)
- [Prevent cyclic reference in work item hierarchy widget from frontend](https://gitlab.com/gitlab-org/gitlab/-/commit/2fdbe509828bc42960f70c576b1d94073610634c)
- [Allow external_provider config take precedence over external_groups](https://gitlab.com/gitlab-org/gitlab/-/commit/c2de306ba30f5afda1e7a24afb94c8e7dc04cedb)
- [Don't allow unauthorized users to close issues automatically](https://gitlab.com/gitlab-org/gitlab/-/commit/92c10374afb3a86ee76c149202204a642f8702ae)
- [Update golang.org/x/net package](https://gitlab.com/gitlab-org/gitlab/-/commit/776e269a1eab799fdeb891ac0e9e37d2c7d09037) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176775))
- [Update net-ssh to fix CVE-2023-48795](https://gitlab.com/gitlab-org/gitlab/-/commit/3d1006d7fdfd87028028d33d6cb3220832ef580d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176092))
- [Update yard to fix CVE-2024-27285](https://gitlab.com/gitlab-org/gitlab/-/commit/9ec01eecb1d1c229f723920622798e26ebfcdebd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176096))

### Performance (4 changes)

- [Implement included remote checksum in the Maven package registry](https://gitlab.com/gitlab-org/gitlab/-/commit/54d9368daf0d2d187e54a8108578291819d265b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177142))
- [Remove auto_merge_process_worker_sticky feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b0b910de2eda218f1220385f1ac55f6d42f67851) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177639))
- [Load entire discussion first when linking to a note](https://gitlab.com/gitlab-org/gitlab/-/commit/a85cea378a33605e7f0f1c907874a01588e281de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177058))
- [Lazy load create epic modal in group sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/a5cf2160ae974d9e3158002e81a00904b7452cb1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176945))

### Other (83 changes)

- [Finalize migration BackfillMlCandidateMetadataProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/bf4313ce6236ccecac61b9dfe26b6764ad322e9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177814))
- [Add not null constraint on boards_epic_lists.group_id](https://gitlab.com/gitlab-org/gitlab/-/commit/95af350244cf1d4370543b0856b102e8cc5a8e5e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177348))
- [Introduce partitioned table for maven virtual registry cache entries](https://gitlab.com/gitlab-org/gitlab/-/commit/04a2f8cd79bceba6ceca3d38d33cfc633ff8714c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174985))
- [Remove ci_catalog_ranking_from_new_usage_table feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/342fd847c9583e6292970693dbfafc8b096f48e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177553))
- [Add Asana instance integraiton model](https://gitlab.com/gitlab-org/gitlab/-/commit/b250029c95115685ef2269e96bf37a36bc25e7af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177009))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/845076c6395d038a8045e830922ac229b1ce6c0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177727))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/065b821dde75a03d953c28f9f5ef5942b8d73c6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177530))
- [Cleanup lfs_sync_before_branch_updates FF](https://gitlab.com/gitlab-org/gitlab/-/commit/db5b8e427a4a5b704e707f400817781b90738e7b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175629))
- [Remove actor override flag for GH and BBS importer](https://gitlab.com/gitlab-org/gitlab/-/commit/c31986a0ddf2adf22769fddd0bb7e8e227ea3a1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177225))
- [Finalize migration BackfillVulnerabilityIssueLinksProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/f44eddf3233085cfe20e35a155606edb8735c4ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173199))
- [Remove unnecessary wrapper method](https://gitlab.com/gitlab-org/gitlab/-/commit/1f8bf9d684128ca7abe5f86dd685c837828e5585) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176589))
- [Re-queue migration to delete orphaned groups](https://gitlab.com/gitlab-org/gitlab/-/commit/c987504d9fc3ab700ee2aab263bbb4065024d32f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176705))
- [Add closed reason urls to work item GraphQL types](https://gitlab.com/gitlab-org/gitlab/-/commit/6a0355bd1506bd802199a89a799d7fc6bcc02874) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176410))
- [Reorder migrations for ci_deleted_objects](https://gitlab.com/gitlab-org/gitlab/-/commit/811a15e015b86be3ad9460c3c8f58bf7c53f9ff6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177541))
- [Add ClickHouse table siphon for namespaces](https://gitlab.com/gitlab-org/gitlab/-/commit/439790c4a8d8245a0aced68b3affee354653628a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176809))
- [Remove actor override when Direct Transfer disabled](https://gitlab.com/gitlab-org/gitlab/-/commit/1fe4d0c48e09b07acdd85fa21047d7e37c127946) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177121))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/a4de4da3eb89ab6f2bcfc7737593e716c1cacb2c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168911))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/59114bd0f80fe80d958e5bf548a5707f71c79e25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175660))
- [Cell ID to default to null instead of 1](https://gitlab.com/gitlab-org/gitlab/-/commit/83bd31861bbb6f8f876dcc87a663e950df28ea74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176605))
- [Add Assembla instance integraiton model](https://gitlab.com/gitlab-org/gitlab/-/commit/61122c53f24dc875aed30c02685e9df3c8f56d01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177125))
- [Revert ElasticsearchSettingsFromApplicationSettings pd migration](https://gitlab.com/gitlab-org/gitlab/-/commit/c3297053affbbccd9daf032573ebb66f68afaa49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176987))
- [Remove Search::Zoekt::DeleteProjectWorker job instances](https://gitlab.com/gitlab-org/gitlab/-/commit/62d09ab48c065c57b49bb386c25fb903c582b020) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176796))
- [Drop sequence for work_item_types.id column](https://gitlab.com/gitlab-org/gitlab/-/commit/d7bd2d3a510a3b388bab70a2fd611cc1f4aeec35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177316))
- [Simplify Rouge/HLJS mapping](https://gitlab.com/gitlab-org/gitlab/-/commit/7288241f313b537e8d0147b599b62da48d35c8d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177237))
- [Fix issues.work_item_type_id values](https://gitlab.com/gitlab-org/gitlab/-/commit/b6187cdf82dac351a58d0caf7344fd239ae7f3a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177008))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/0c6ee9f4a1ffbb157a1d12229db86d3838bcad0b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176965))
- [refactor: Extract shared examples in create_package_service_spec.rb](https://gitlab.com/gitlab-org/gitlab/-/commit/a530d278547df27923777283767355289a8e0958) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/135552))
- [Only show active trial widget for ultimate trial plans](https://gitlab.com/gitlab-org/gitlab/-/commit/5989ba369767945fdce7f0d55cdb1d4c0fddef71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175126)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/8b772b9c2bf37c48facaa5a6e850584efd13ab19) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177206))
- [Finalize migration BackfillVulnerabilityMergeRequestLinksProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/17d866ec5b1b9eef51a2aeb57eb69f7673be8bdf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177102))
- [Finalize migration MigrateOsSbomOccurrencesToComponentsWithoutPrefix](https://gitlab.com/gitlab-org/gitlab/-/commit/a964506ec361525a586e3d2a8e18c6f862776e21) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176555))
- [Update downtime migration docs](https://gitlab.com/gitlab-org/gitlab/-/commit/454a7c8b049538bf067b5b26f216b24c0dd5f6cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177006))
- [Remove feature flag definition](https://gitlab.com/gitlab-org/gitlab/-/commit/3baa76347186820170868cd57bd586d137a4551f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177063))
- [Cleanup multiple_approval_actions feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/7c3464b10f99f0e9436b0a0cb6a68e5a938a2846) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176958)) **GitLab Enterprise Edition**
- [Finalize migration BackfillVulnerabilityUserMentionsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/35d58d1d41fbb4fa582c96f20e46a9d383da8dbe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177105))
- [Fix work_item_types.id values with sequential values 1-9](https://gitlab.com/gitlab-org/gitlab/-/commit/a7d408d949089bc57e8841515462ed2e65302a1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176199))
- [Enable pause control for zoekt workers](https://gitlab.com/gitlab-org/gitlab/-/commit/bd5fcddc39a1e9731bf685e6a8e7523e7b983c50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176397)) **GitLab Enterprise Edition**
- [Cleanup premium_can_trial_again feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/7014d9705e4cc911681699f96635d0dc99c118fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177012)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/bb539f05999f23195e720c414e08ea0a0bf03642) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176531))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/69387fa4904ced09c9e11a8008a0df850bb3cd2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176734))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/5a3e9a5ac09bd65b0374e8ef9fa671a51f3e7ba7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175935))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/ce1d3d5ccbc19db047edf5cb208f9e40cca49d66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176904))
- [Remove orphaned managers from .com ci_runner_machines_687967fa8a](https://gitlab.com/gitlab-org/gitlab/-/commit/462aaa7069a91bd8728ed5d03e7e66304965ca1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176702))
- [Requeue backfill of ci_runners_e59bb2812d table](https://gitlab.com/gitlab-org/gitlab/-/commit/352640b68f23df48a4c55ade1a5b86edac0eee1c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176848))
- [Fix a misspelling in BBM docs](https://gitlab.com/gitlab-org/gitlab/-/commit/d0ddaaa93a750f4d94f1e17932782587e51b4c2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176816))
- [Add tracking metrics for multiple approver actions](https://gitlab.com/gitlab-org/gitlab/-/commit/69698ce2a8fb498aa4fe23ae28b03f9f90732323) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176669)) **GitLab Enterprise Edition**
- [Delete redundant docs link from "Linked items"](https://gitlab.com/gitlab-org/gitlab/-/commit/02f55377e3ad2a835565f4649c537d1c8eae7db1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176373))
- [Remove UpdateIndexUsedBytesWorker job instances](https://gitlab.com/gitlab-org/gitlab/-/commit/e6ff37c5d5baf2c726a0e040adefe2cdf7ef0d4d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176370))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/a1e0166ed5be34e20a383ef708532601ea78e9e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176436))
- [Add feature category to github import specs](https://gitlab.com/gitlab-org/gitlab/-/commit/1eeee0715368cc84e14984a7ca129e85b4d26ef9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176639))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/77584f240200517e72f1bc2ee337f1b04adb98ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176622))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/6c7305dc7df6a81c2715092a1d7c3662b2f2fbef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176623))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/5794d86d54baa394202f1f884cf5a00b10ab0f2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176529))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/6c3878db73f8b22319370bf04157708fd93b1f4f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176528))
- [Remove feature_flag admin_agnostic_token_finder](https://gitlab.com/gitlab-org/gitlab/-/commit/98f46d84b317d58b390d132db614bf01ff7166cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175948))
- [Finalize migration BackfillVulnerabilityFindingLinksProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/f6a25bd597ee9ea6d40af40d264c197b903b16f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173669))
- [Finalize migration BackfillVulnerabilityFlagsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/1535feaa3f0cf60aa2d7d687db1d2a0095adbcf9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173666))
- [Finalize migration BackfillVulnerabilityFindingEvidencesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/18aa5ef132089182d9161d2a43bde86a8191bf82) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173670))
- [Finalize migration BackfillVulnerabilityFindingSignaturesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/e1fd372507b4c2a4ed7df951e1b3ae35fe345cff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173668))
- [Protected packages: Add regex validation for pypi protection rules](https://gitlab.com/gitlab-org/gitlab/-/commit/8f36ed9ab9ebbd936d3656196ac1f93174482377) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163504))
- [Merge branch '458891-metadata-api-get-kas-version-by-serverinfo-rpc' into 'master' ](https://gitlab.com/gitlab-org/gitlab/-/commit/df2696997a349f2eee23249ee03d544421620caf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164579))
- [Create helper method for tree header app](https://gitlab.com/gitlab-org/gitlab/-/commit/80c65af2ce8e4ded806234fae0bc52fd32380c8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175882)) **GitLab Enterprise Edition**
- [Removed git_guardian_integration FF](https://gitlab.com/gitlab-org/gitlab/-/commit/6010a33d68859beb94e2752e1d1fa1f1dc5cc070) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176391))
- [Detail view renders legcy issue view for unsupported work item types](https://gitlab.com/gitlab-org/gitlab/-/commit/1dc9935158f50957e8e085d4bb02484c22dc8abb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175109))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/8df9984fee8f89a492bf588ee579a12c20806b6f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175780))
- [Updates step_url for users that do not have registration_type](https://gitlab.com/gitlab-org/gitlab/-/commit/016db0bc2dc46dad61420cca3e44bbfea99ebf47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176324))
- [Update vulnerability_management_policy to clarify group availability](https://gitlab.com/gitlab-org/gitlab/-/commit/ab4a7bf97d0d641172a9beb4f3210bbd01843a73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176297)) **GitLab Enterprise Edition**
- [Consolidate elasticsearch application settings into one JSON field](https://gitlab.com/gitlab-org/gitlab/-/commit/32cdd44b376797f334d7caee3c1ae6ff479aff3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174172)) **GitLab Enterprise Edition**
- [Run EnsureFactoryForTable in CE to avoid RedundantCopDisableDirective](https://gitlab.com/gitlab-org/gitlab/-/commit/bb76605d0478523248efd3dfcf66db71c1f8c377) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176077))
- [Add missing widgets to incidents for parity with issues](https://gitlab.com/gitlab-org/gitlab/-/commit/088689c5ac4cd35385fde8f2a9dcddc5685102b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175386))
- [Add & backfill sharding keys for protected_branch_unprotect_access_level](https://gitlab.com/gitlab-org/gitlab/-/commit/dbfa3214907589f2b72b6a6209b133879687ba4d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175718))
- [Remove feature flag write_to_ci_runner_taggings](https://gitlab.com/gitlab-org/gitlab/-/commit/49f214f6bab911e8759e7d2b505955c2fd27c954) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176163))
- [test: Move test from feature test to model test](https://gitlab.com/gitlab-org/gitlab/-/commit/c6758b7dabde0357b81c001037d48da16cca0d21) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176136))
- [Reclaim disk space used by old job tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/2fda52e5b7c0f7ee4311b80cf7b3d2bcfab8336f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176025))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/6d1ff2c64b8bd29805d313ce6c279eba470b8fc2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175782))
- [Fix variable literal](https://gitlab.com/gitlab-org/gitlab/-/commit/9aaead6bf01a3d7e14ecfc7ffe23b4f85bcd53a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175983)) **GitLab Enterprise Edition**
- [Add and backfill namespace_id for issuable_slas](https://gitlab.com/gitlab-org/gitlab/-/commit/2ac50a8ce7a485bac517029185f48cde9558ce80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175719))
- [Add & backfill sharding keys for bulk_import_export_uploads](https://gitlab.com/gitlab-org/gitlab/-/commit/f38e81eda4b4c71cb1bae5372ddf6e6dc2045a19) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175723))
- [Use the project_id_from and project_id_to in InitialIndexingEventWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/9f084888bf20d6e4c0e4ddb0523f01f8e150ed64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175844)) **GitLab Enterprise Edition**
- [Remove cache_autocomplete_sources_* feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/20bb52a61f038d6e09f69fd852f8b0191846cbc6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175874))
- [Remove feature flag `ai_custom_model`](https://gitlab.com/gitlab-org/gitlab/-/commit/790adc35614aa08ea66a4a3b66233e9320cf9dce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175687))
- [Remove default on `group_saved_replies_flag feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/75d49fe13646e1e0d3b68233ac4a965c86853917) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175647))
- [Remove use_actual_plan_in_license_check flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b8c3fe16aedb69c82ff52d1c695d72e933c4b946) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175649))

## 17.7.7 (2025-03-11)

### Security (8 changes)

- [Vendor GraphQL gem](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1c7e70de86d4bdd9395c9bcda9f816a608d78a3d) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4839))
- [Ruby-SAML updates](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8ac8f914d289f182de00be49d10f15e7db7bd7a3) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4830))
- [Prevent custom role to activate group members](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1c01e25b256b30a8edca3024909c9b1df56adb59) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4835))
- [approval_rules name is unbounded](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1db850c51fcd8ceab50bced39165464c0943a45b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4836))
- [Limit preview size](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0ca0f0bad8d2d470b10491fa672e3134cb0d5acf) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4823))
- [Maintainer can inject shell code in Google integration configurations that...](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f22e6beb143b983e2bd76c08beff215816a52079) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4826))
- [Filter out internal notes if the recipient do not have access](https://gitlab.com/gitlab-org/security/gitlab/-/commit/17181360562c5f5b9c4907eb8f8d3aad12b7748b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4813))
- [Mask unencoded userinfo in project mirror errors](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a7a51b42149a2db1c39a948604c2296c61b1ddb9) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4778))

## 17.7.6 (2025-02-26)

### Fixed (1 change)

- [Fix failed jobs widget polling issue](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e2154d3d886d82e1f5fe62fb9d234d00e257e784)

### Security (4 changes)

- [Increase minimum role in SPP to read policy yaml](https://gitlab.com/gitlab-org/security/gitlab/-/commit/6d5c2ea1feb6097cb5720650f39b3808554b6a29) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4717))
- [Fix access to read code review analytics in private projects](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4454c18d19d2d8df92520f4c0fafa24ddbf9fbe4) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4757))
- [Escape work item dropdown items and restrict HTML tags](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a834b94cf4e967065590f6b78b15c8733d67df30) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4785))
- [Use stricter CSP values in the packages dependency proxy](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d975b402434b9e17ff2963d9c4c6f438f52545ed) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4765))

## 17.7.5 (2025-02-21)

### Fixed (1 change)

- [Revert stricter workhorse route regexes](https://gitlab.com/gitlab-org/gitlab/-/commit/9f1a05217022094de570ca4e4afd5b96b9b68c56) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181359))

## 17.7.4 (2025-02-11)

### Security (8 changes)

- [Security Duo Chat Escape Unknown Domain Hyperlinks](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d3eafa571712e6891f16ecccaaefd82b147b75f6) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4691))
- [Hide sensitive workhorse headers and fix route confusion between web and workhorse routes](https://gitlab.com/gitlab-org/security/gitlab/-/commit/af871eb34f21f862bce699839af69c88826a3420) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4762))
- [Do not allow Planner role to update or delete incidents](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f5ae9423dbd353f571ffbea5a8ffe2ac77b587d6) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4747))
- [Reduce memory allocations on create PAT endpoint](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d443ded9eaed1300b888594125684db884c88e4d) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4751))
- [Prevent SSRF attacks for Workspaces](https://gitlab.com/gitlab-org/security/gitlab/-/commit/03fbdbe7b80e1028098df6bb10abc749b4f4b968) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4730))
- [Prevent read code access when repository is disabled](https://gitlab.com/gitlab-org/security/gitlab/-/commit/fb3eb2135770abcea4951ffe432cebb2065e7d3c) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4700))
- [Fixes XSS on the target branch in the merge request widget](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f4fd06e3450f686817104895eb6aca42af4fab11) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4736))
- [Unsubscribe from actioncable channel when PAT is revoked](https://gitlab.com/gitlab-org/security/gitlab/-/commit/972f392e7daa6b60ed8ff03e6651944e1d045b40) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4726))

## 17.7.3 (2025-01-22)

### Fixed (1 change)

- [Add BoardEpicConnection type policy for pagination](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f49b4349cecbbca2629e4abf9e2746d48537f350) **GitLab Enterprise Edition**

### Security (4 changes)

- [Fix protected variable exfiltration](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ed6f52bb29b7dc1d6fad13c8d62725aa3a3c7283) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4714))
- [Enhance rich viewer sanitization](https://gitlab.com/gitlab-org/security/gitlab/-/commit/68187f7e86b936d1d361c78160b3855db7ffa495) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4709))
- [Avoid recursive sidekiq calls on cyclic work item hierarchies](https://gitlab.com/gitlab-org/security/gitlab/-/commit/77692306d5122b9a3006667a4bbd695f4e983a33) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4673))
- [Respect the private profile constraints](https://gitlab.com/gitlab-org/security/gitlab/-/commit/325eea0ef21773481a0aa753cffacf05a835acbc) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4698))

## 17.7.2 (2025-01-14)

### Fixed (1 change)

- [Fix handling of short gzip metadata files](https://gitlab.com/gitlab-org/gitlab/-/commit/aaa32a37cf34a2e171f5ae1b7ce1259796605f92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177633))

### Changed (1 change)

- [Remove `download_code` dependency from access to read merge requests](https://gitlab.com/gitlab-org/gitlab/-/commit/01a950b82192d6b93de58bf3678767f58c08c5f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176667))

## 17.7.1 (2025-01-08)

### Fixed (3 changes)

- [Update acme-client to v2.0.19](https://gitlab.com/gitlab-org/security/gitlab/-/commit/17fb399704080e909a7ffd188dad4a0367a41cf6)
- [Add a migration to regenerate CI job token signing key](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1a69b334e54530b37ca623b8e0d5da6ed2961fb1)
- [Fix CI job token signing key not always generated](https://gitlab.com/gitlab-org/security/gitlab/-/commit/6fd10c2117db61d7c894944462c29425038301c0)

### Security (4 changes)

- [Prevent cyclic reference in work item hierarchy widget from frontend](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a545d1f48720d3d9908880d2a77ff0e76bcaa9a5) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4684))
- [Allow external_provider config take precedence over external_groups](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c74b00da4e644dc5628f805587b2ec492e8bd044) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4680))
- [Filter out sensitive parameters on Auth logs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e6f661b6f3ec52e0e9d37b89d171e5b949346804) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4686))
- [Don't allow unauthorized users to close issues automatically](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b1ef837d0b61f997dacd3b299da17c96616ba275) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4674))

## 17.7.0 (2024-12-18)

### Added (178 changes)

- [Add iteration autocomplete to RTE](https://gitlab.com/gitlab-org/gitlab/-/commit/9e1c7e1dfb027154540aabd9dade248feeea4608) by @salihudickson ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175785)) **GitLab Enterprise Edition**
- [Add pages domain verify API](https://gitlab.com/gitlab-org/gitlab/-/commit/450f7f330e7588c61d95db871c3d630ae6a4bb9a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174330))
- [Add foreign key constraints to ci_runner_machines_687967fa8a](https://gitlab.com/gitlab-org/gitlab/-/commit/373fea60d3660aabe7048ba84b39b9b93f614b04) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171848))
- [Register new audit event](https://gitlab.com/gitlab-org/gitlab/-/commit/9ac3ceb4eabe7d14ff1c5f10e92869a3d48e245c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174412)) **GitLab Enterprise Edition**
- [Add credit_card_verification_enabled setting](https://gitlab.com/gitlab-org/gitlab/-/commit/d9364a34ddcec3c7a415adf6cdde7bff8e813365) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175148)) **GitLab Enterprise Edition**
- [Add internal events tracking to the individual release page](https://gitlab.com/gitlab-org/gitlab/-/commit/f3ced32bc0289a857e503102fd7f5db54b578aee) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175594))
- [GraphQL: add BranchDelete mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/4cde11ea43c33dcc8ee522473d79d2731d7217a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175270))
- [Update qa github spec](https://gitlab.com/gitlab-org/gitlab/-/commit/4bd5769773e2f40cf02b5739414447c91146cc67) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175385))
- [Add deny allow list to a policy drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/2132107b32bf6ddf953af4f45410cf709a9e11a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175439)) **GitLab Enterprise Edition**
- [Add search for Kubernetes pods](https://gitlab.com/gitlab-org/gitlab/-/commit/2f13cf47d690b93b3f12f68f0a0bded08d780a0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175585))
- [Add `/relate` quick action to WorkItems](https://gitlab.com/gitlab-org/gitlab/-/commit/14340fd8db5cc6acf78588873217c47f17890d56) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172901)) **GitLab Enterprise Edition**
- [Model experiments: Add empty state to performance graph](https://gitlab.com/gitlab-org/gitlab/-/commit/dcecf41948385ee059b11e8eb6427a7eee0f9e99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175688))
- [In project update service add support for pages default domain redirect](https://gitlab.com/gitlab-org/gitlab/-/commit/6a7a9f8c2b8e2fa5b04f490d76ea9e8ca9b93d82) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174813))
- [Log scope when auditor initialized](https://gitlab.com/gitlab-org/gitlab/-/commit/d1465ee7377d11eed4d598286e1b8531114c23fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175107))
- [Add validation key for license exceptions](https://gitlab.com/gitlab-org/gitlab/-/commit/1c396b582610eba69e690a3038ad7abe243a8157) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175132)) **GitLab Enterprise Edition**
- [Enable markdown description lists](https://gitlab.com/gitlab-org/gitlab/-/commit/bace25950945c55cb273d7212574fd065370f925) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175169))
- [Add backticks and remove FF](https://gitlab.com/gitlab-org/gitlab/-/commit/888268b0458492de713aade5fafd72126316d4ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174880))
- [Add note regarding user namespaces](https://gitlab.com/gitlab-org/gitlab/-/commit/4fdaf5c2b23fbab3e92d8ba806561e4b4c3e9371) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175545))
- [Model experiments: Add user, created_at, model_id](https://gitlab.com/gitlab-org/gitlab/-/commit/cd594594bc933a856d29071b1194e3a8ddaf8031) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175529))
- [Remove npm_extract_npm_package_model feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3b6c508c14412d76ccc819263a8e5273e5db5e71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173999))
- [Add ability to assign GitLab Duo seats based on SAML groups](https://gitlab.com/gitlab-org/gitlab/-/commit/44dc47007c61982d9fa82df13668fef00111c9c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174021)) **GitLab Enterprise Edition**
- [Add ci_requires_identity_verification_on_free_plan setting](https://gitlab.com/gitlab-org/gitlab/-/commit/f220095c6e267a3086ba90168e1cfe2fa5ab2609) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175305)) **GitLab Enterprise Edition**
- [GraphQL API: add endpoint to return a list open merge requests](https://gitlab.com/gitlab-org/gitlab/-/commit/d4523528d87731748cef2c9047f0e50a6ce2dc87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172997))
- [Admin Token API: Revoke token](https://gitlab.com/gitlab-org/gitlab/-/commit/4d27a6a59ca4715dc832a808f1a076a760d9be0f) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170421))
- [Default enable FF vulnerability_filtering_by_identifier](https://gitlab.com/gitlab-org/gitlab/-/commit/9540b807e10270ec5bae50bdd08134a9ed333d30) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175512)) **GitLab Enterprise Edition**
- [Allow default editor setting to be optional](https://gitlab.com/gitlab-org/gitlab/-/commit/3066c9c0d61057ffbec865da927120625c9a9b88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175187))
- [Support for Vulnerability webhook events](https://gitlab.com/gitlab-org/gitlab/-/commit/8304e298f5a009f33ff69c16bf16f52de3def85f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169701)) **GitLab Enterprise Edition**
- [Introduce Rotate Token in UI - Impersonation Tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/3d5eb88f078fce8852b060bb0fce5346183bd3f0) by @shangsuru ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173708))
- [Add and track events for Vulnerability auto-resolution](https://gitlab.com/gitlab-org/gitlab/-/commit/a547977c90c0249ea6d3881b5e2d99e14c286ba6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175012)) **GitLab Enterprise Edition**
- [Add pipeline summary for reusable pipeline widgets](https://gitlab.com/gitlab-org/gitlab/-/commit/13d0a286e3f766536064e4b7d1c05cceedc6bd2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173798))
- [Add UI for managing integrations allowlist](https://gitlab.com/gitlab-org/gitlab/-/commit/1947c028d8ed4189058cb0afb1af83e8e5704222) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174617)) **GitLab Enterprise Edition**
- [Add warning to group approval settings when policies may override it](https://gitlab.com/gitlab-org/gitlab/-/commit/21b49e946618a2f18588f0f19061e2f439d9a2ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175319)) **GitLab Enterprise Edition**
- [Add a warning when approval settings may be affected by policies](https://gitlab.com/gitlab-org/gitlab/-/commit/a52032aede263054c88a34b56418234ba07b5e72) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175303)) **GitLab Enterprise Edition**
- [Add new API to update secret push protection for group](https://gitlab.com/gitlab-org/gitlab/-/commit/aeabdc0aad3b5514a868e1e05060a770797fa4a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175225)) **GitLab Enterprise Edition**
- [Add build source filter to GraphQL Project Job query](https://gitlab.com/gitlab-org/gitlab/-/commit/7c5dde7c145f2c17907c343a432e6125f3ea599b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170899))
- [Added the ability to query EPSS data in GraphQL through vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/0f3309e4bc772b8efa183a0eca29404ad6e6539b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172285)) **GitLab Enterprise Edition**
- [Model experiments: Add candidates table](https://gitlab.com/gitlab-org/gitlab/-/commit/a725fbb73206c9dee593692547b22566510fd3bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174684))
- [Document skip_ci option for pipeline execution policies](https://gitlab.com/gitlab-org/gitlab/-/commit/fccfa6dcad20e83a7d3a3539c24e6c5495dc8c37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175239))
- [Adding metric for when a vulnerability is resolved](https://gitlab.com/gitlab-org/gitlab/-/commit/f63412bed60e525a780f4485929c029e83d1f390) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175174)) **GitLab Enterprise Edition**
- [Support composite identity in Runner activity](https://gitlab.com/gitlab-org/gitlab/-/commit/16683f568934fce717413f40fd7377f85169d3ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175406))
- [Allow users to configure skip ci behavior for pipeline execution policy](https://gitlab.com/gitlab-org/gitlab/-/commit/c1e9eba787436fa6f093f33a1b336b38b5e035a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173480)) **GitLab Enterprise Edition**
- [Enable VR in MR by default](https://gitlab.com/gitlab-org/gitlab/-/commit/9c816a94ffc91d96e89d521b51faa07bdfe3b8b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175150)) **GitLab Enterprise Edition**
- [Include snippet import requirements](https://gitlab.com/gitlab-org/gitlab/-/commit/f705d7335e7305e11be381318ea2ac63c44044cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175273))
- [Add vulnerabilities in Import and Export and Direct Transfer](https://gitlab.com/gitlab-org/gitlab/-/commit/a28d750a976ee29f379369a6d209eacd5ec7f0b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171684))
- [Add include_forked for blobs search graphql api](https://gitlab.com/gitlab-org/gitlab/-/commit/1ec2e0ab9cde8f6943dfd46a85339c6edcfbd784) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175008)) **GitLab Enterprise Edition**
- [Add new KAS fields to GraphQl](https://gitlab.com/gitlab-org/gitlab/-/commit/3b66c9f9372041cea417d2031ba5fce4fb535ed3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174384))
- [Fix the response order](https://gitlab.com/gitlab-org/gitlab/-/commit/b4401cd8a4ddadaedffbdc8d59b06c276708241f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173835)) **GitLab Enterprise Edition**
- [Add yaml update for allow list](https://gitlab.com/gitlab-org/gitlab/-/commit/6766162666f400cba193e727ed3ad27fa70a7218) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174296)) **GitLab Enterprise Edition**
- [Create approval rules for multiple policy approvers](https://gitlab.com/gitlab-org/gitlab/-/commit/d3be4a2f001d31c197a5ce5db893082fdcd9b7dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175162)) **GitLab Enterprise Edition**
- [Document that Planner role can import issues from CSV](https://gitlab.com/gitlab-org/gitlab/-/commit/fb1ac5aedeedf62ee44af567ef3b7a60b6161074) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174964))
- [Add migration to reindex all work items](https://gitlab.com/gitlab-org/gitlab/-/commit/560657f88b28dded6cddb177bcb601158f409961) by @joe-snyder ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174463)) **GitLab Enterprise Edition**
- [Add phone_verification_enabled application setting](https://gitlab.com/gitlab-org/gitlab/-/commit/e7b9c6b72a524c866be2733c6341e4cac27d0851) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175013)) **GitLab Enterprise Edition**
- [Added total policy violations count to the GrpahQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/b45f1690e400bc657f126a497aaa65b82fbd2fe1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175100)) **GitLab Enterprise Edition**
- [Add new API to update secret push protection for group](https://gitlab.com/gitlab-org/gitlab/-/commit/815b4e9e82dadf01cbd6f7c871e149852c414e76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174342)) **GitLab Enterprise Edition**
- [Add composite identity enforce setting to users](https://gitlab.com/gitlab-org/gitlab/-/commit/f57311382b7806c6113e289623d2400b1d6ff088) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174026))
- [Model experiments: Performance graph](https://gitlab.com/gitlab-org/gitlab/-/commit/44726791aa2f8497739baf0934caf6f84c8e77ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174413))
- [Backfill namespace shared_runner_minutes_limits](https://gitlab.com/gitlab-org/gitlab/-/commit/f1d1f9982bb10ed52759b007e677f53ba5f5a2e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161485)) **GitLab Enterprise Edition**
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/7568ee97793553d03f4b81040245208937bf1cf6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175078))
- [Add custom_role_approvers to MR approval policies](https://gitlab.com/gitlab-org/gitlab/-/commit/c90918772c19a163e5b2fef792df91c733822e6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174338)) **GitLab Enterprise Edition**
- [Remove merge_when_checks_pass_merge_train feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/a9723888bab8f764bef7424e3ccf202b0d83fbcf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174357))
- [Add indent and outdent functionality to RTE](https://gitlab.com/gitlab-org/gitlab/-/commit/1a8c7655abcbff13c392a963109908975f4529cd) by @salihudickson ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174311))
- [Add include_archived for blobs search graphql api](https://gitlab.com/gitlab-org/gitlab/-/commit/1739a9d16a46b332c2bc4aeb7e1cefbaa56dfe04) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174911)) **GitLab Enterprise Edition**
- [Adds autopopulated to group and project scope links tables](https://gitlab.com/gitlab-org/gitlab/-/commit/92d77f50cc25d40829523ef7735294996d38d5b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174901))
- [Support composite identity in CI pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/28e04061e7512239c37857773d23c27f415814f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174051))
- [Create entry in package reference when adding new package file](https://gitlab.com/gitlab-org/gitlab/-/commit/126e07bbce5598e67cfa96c14823439c1ec4a233) by @oceane_scania ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168381))
- [Add documentation and roll out ensure PEP pre stage complete](https://gitlab.com/gitlab-org/gitlab/-/commit/ca7f13e5795fbc3027c4617d7aae78e492ee6b13) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174663)) **GitLab Enterprise Edition**
- [Allow unverified users to opt-in to identity verification for access](https://gitlab.com/gitlab-org/gitlab/-/commit/360f470a4e803f6e6afd3f5f878a7c1bc6fc07ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174732)) **GitLab Enterprise Edition**
- [Add a type field to UserCore](https://gitlab.com/gitlab-org/gitlab/-/commit/00dff5f519dfb16c00fa8acd0cf387e76bfc9c31) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173568))
- [Add ai_conversation_threads and ai_conversation_messages tables](https://gitlab.com/gitlab-org/gitlab/-/commit/78d263911f80478f8f862cce52fdbb913b5a4e12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171934)) **GitLab Enterprise Edition**
- [Add auto stop setting to environments](https://gitlab.com/gitlab-org/gitlab/-/commit/d5792a14823eaf5da88bc84d9ba380a7d5d1db83) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173804))
- [Update issue tracking integrations to work  with instance integrations](https://gitlab.com/gitlab-org/gitlab/-/commit/f206ca18a208e1dc21fafe5b3ac9a1aef34f12c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173746))
- [Added new author filter for merge request scope](https://gitlab.com/gitlab-org/gitlab/-/commit/6929fb50e14bb135f7314124d895bd7c9a20fd7a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173247)) **GitLab Enterprise Edition**
- [Add GQL type on project for component usages](https://gitlab.com/gitlab-org/gitlab/-/commit/14cce165d7d51898b67cc50b9017fb068cd186e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173816)) **GitLab Enterprise Edition**
- [Settings block: Add id to url to make them shareable](https://gitlab.com/gitlab-org/gitlab/-/commit/dbaf3fc096131e8321ef232050b6f53d0136910a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173988))
- [Add pages_default_domain_redirect in project_settings](https://gitlab.com/gitlab-org/gitlab/-/commit/689a3a2c460d89a6de12fd025132a7d42328b280) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173510))
- [Write trigger_id to Ci::Pipeline](https://gitlab.com/gitlab-org/gitlab/-/commit/129af5381f27b1c897c9495298e2a0e248cff182) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174132))
- [Allow promoting a work item issue to an epic using quick actions](https://gitlab.com/gitlab-org/gitlab/-/commit/16c16f9c97668fd01141110ebaa34cf1c8ff80bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173718)) **GitLab Enterprise Edition**
- [Add backticks around username mentions](https://gitlab.com/gitlab-org/gitlab/-/commit/5595b18174e0e4d804ffcb6560e3fc912c8e98cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174536))
- [Implement WorkItemWidgetDevelopment.relatedMergeRequests field](https://gitlab.com/gitlab-org/gitlab/-/commit/86971adccc793f76e9cb77f6527b179e9215f3f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174044))
- [Add policy action_idx to approval rules validation](https://gitlab.com/gitlab-org/gitlab/-/commit/c9c7332c5c3d9f3d4eff07a27dc7278e4dfacd1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174308)) **GitLab Enterprise Edition**
- [Enable filtering by subscriptions in GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/e7d7fcb0d8c4586f7abdc99e657e7c4f6e1a5dfc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174578))
- [Add concurrency limit to CreateBotWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/3379a8ba1ac721d61189587f963d41d52dbb8d59) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174739)) **GitLab Enterprise Edition**
- [Vue Projects - Inactive project descriptions](https://gitlab.com/gitlab-org/gitlab/-/commit/0b81708152cb9b301d785d07b456521f0a52c45c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173788))
- [Add error_messages to GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/73c44ba81052972a24fdfaf30f19bd7cc647c56b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174434))
- [Introduce failed jobs in MR](https://gitlab.com/gitlab-org/gitlab/-/commit/7b12f3e6486766124a124a60f8b1766d5b022c7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174586))
- [Add option without auto-approvals to User Signup settings](https://gitlab.com/gitlab-org/gitlab/-/commit/93d6bed753f1582b632dd78b24e2f0db7b5d23de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172726)) **GitLab Enterprise Edition**
- [Handle variables_attributes for policy pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/3b45e590392ef5809334073a34ced282f6dc1d14) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174112)) **GitLab Enterprise Edition**
- [Enable work item epics](https://gitlab.com/gitlab-org/gitlab/-/commit/1d835ebbc3855a20ae0c9f4ffa713a6be1826516) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174341)) **GitLab Enterprise Edition**
- [Remove api_audit_requests_with_scope flag](https://gitlab.com/gitlab-org/gitlab/-/commit/cefe5f9a0816ccaaf1abf21c53b43258750b908b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174516))
- [Promote planner role on invite members page](https://gitlab.com/gitlab-org/gitlab/-/commit/e26dceb80d587b7b1c0f0f7f1541150554599227) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173733))
- [Add with_highest_role_planner field to users_statistics table](https://gitlab.com/gitlab-org/gitlab/-/commit/772a8f6aa0237e34d10fd9286461229ea3d02375) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170949)) **GitLab Enterprise Edition**
- [Specify namespace and flux_resource_path in CI job](https://gitlab.com/gitlab-org/gitlab/-/commit/7b6a1a8a8350de94ee476bdaefda635134edfe03) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173366))
- [Fix: Completions worker accessing deleting feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/abbc3cce57eba053d2490114abdc424d560e92a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173296)) **GitLab Enterprise Edition**
- [Update Initial Duo Config Box Settings](https://gitlab.com/gitlab-org/gitlab/-/commit/111fb1daf860a74e59d796bd2d565ffaa1a427f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168903)) **GitLab Enterprise Edition**
- [Add markdown include directive](https://gitlab.com/gitlab-org/gitlab/-/commit/f287ab276b6208332f3059b590c8ec1e10237a23) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174584))
- [Add rotate via UI to project and group access tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/3ef91c750102bf3bcd5c4a20c6d527739a163289) by @shangsuru ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173074))
- [Update dormant member docs to reference max value](https://gitlab.com/gitlab-org/gitlab/-/commit/5582dc3df9441f8acd1693afb57e9c6dca9792bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174168))
- [Remove specialized_worker_for_group_lock_update_auth_recalculation FF](https://gitlab.com/gitlab-org/gitlab/-/commit/e52726b7148104120b96178af38d6ddfe0ffdc46) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174519))
- [Add Owners to `Allowed to create projects` options on Group](https://gitlab.com/gitlab-org/gitlab/-/commit/7be0ea355e97730fcecd322d8ca203e3de60b852) by @yasuk ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173406))
- [Add pages_default_domain_redirect in project_settings](https://gitlab.com/gitlab-org/gitlab/-/commit/06dfce173aab739f504426ff4c08cc61b330e495) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173373))
- [Backfill issue_links_id on related_epic_links](https://gitlab.com/gitlab-org/gitlab/-/commit/d67572e8f44732d8a8a873a10e95f32fec612bfc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174444)) **GitLab Enterprise Edition**
- [Fix AiSetting race condition](https://gitlab.com/gitlab-org/gitlab/-/commit/0174485b9629506a394cb99fb5bfd2bb84755e7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173226)) **GitLab Enterprise Edition**
- [Added completion notification for project imports](https://gitlab.com/gitlab-org/gitlab/-/commit/75e5d99b8550801e770daf286f0c00afd834b39b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173596))
- [Add sharding key columns to uploads](https://gitlab.com/gitlab-org/gitlab/-/commit/e4a250a50637406ac515a41273791360794e9410) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168003))
- [Clean up expiring_pats_30d_60d_notifications FF](https://gitlab.com/gitlab-org/gitlab/-/commit/d9068fd1893f1909921269db36ee88f5239066d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173792))
- [Add stream destination mapping to legacy models](https://gitlab.com/gitlab-org/gitlab/-/commit/ff0a9f8cf8a755c0f823a47565f4f0126e964904) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173322)) **GitLab Enterprise Edition**
- [Add remaining licenses without spdx to custom software license table](https://gitlab.com/gitlab-org/gitlab/-/commit/8a064cabb152531ab165faad940e574a72c612c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173790))
- [Model registry: Add default experiment to model card](https://gitlab.com/gitlab-org/gitlab/-/commit/b1c35b84395c630ffd77e6b10aa4fe825ebf65bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174376))
- [Add persisted related item to new work item flow](https://gitlab.com/gitlab-org/gitlab/-/commit/a53198d43cbc68d022676b24aabbaf9c0f149c07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173840))
- [Add processing for additional error codes](https://gitlab.com/gitlab-org/gitlab/-/commit/5d454dc4372b829c79a3c1c9fe3bdac0891b21e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172117)) **GitLab Enterprise Edition**
- [Add the model for registry tag protection rules](https://gitlab.com/gitlab-org/gitlab/-/commit/57ffd8a98f26cf9357aa074db24ed84d9b04b9e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172580))
- [Added Work item frontend ground work](https://gitlab.com/gitlab-org/gitlab/-/commit/724a647c86633d343d77f9803b34c2f466d7be9a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171956)) **GitLab Enterprise Edition**
- [Integrations observe settings allow list](https://gitlab.com/gitlab-org/gitlab/-/commit/49e4313a57a89741985db74d32cda9740405ab58) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172951)) **GitLab Enterprise Edition**
- [Add dormant scope to seat assignments](https://gitlab.com/gitlab-org/gitlab/-/commit/03fa2e8035af8aad4409d210f8e689b9b75e8ceb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173518))
- [Add `suspended` status for Flux sync badge](https://gitlab.com/gitlab-org/gitlab/-/commit/9b46a4379bed74218d759f3ce9fcdcbfb40efdf1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174161))
- [Rename to follow convention](https://gitlab.com/gitlab-org/gitlab/-/commit/399474beca149c78ffc6aa2e886e610f032ec38a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173269)) **GitLab Enterprise Edition**
- [Add pages_default_domain_redirect in project_settings](https://gitlab.com/gitlab-org/gitlab/-/commit/a6be40915b17e2f0bee15e4060e7e758d474ceee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173120))
- [Add Duo seats usage panel to AI Impact dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/45562b25c5dc445f90beef3366d6c95b82372ac3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173735)) **GitLab Enterprise Edition**
- [Allow transfer of project with tags](https://gitlab.com/gitlab-org/gitlab/-/commit/e1f1f2a55c72477bedf3810293bd8edadc88be34) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173768))
- [Add trial date attribute validations](https://gitlab.com/gitlab-org/gitlab/-/commit/9d1bcda516085bdbc8c8daab0eb92f23487c83d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168521)) **GitLab Enterprise Edition**
- [Model registry: Add candidates tab to Model card](https://gitlab.com/gitlab-org/gitlab/-/commit/cec17ff9bf08f4df013ed7e7a272339297ade672) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173711))
- [Enforce allowlisted policies for CI/CD Jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/8a62251ec12aa5bb079e7f10189258725aaeabe0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169264))
- [Add additional fields and optional slot to commit changes modal](https://gitlab.com/gitlab-org/gitlab/-/commit/7747226a9d9d111ba23f51295bbbf6593e36265c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173620))
- [Adding update mutation for compliance requirements](https://gitlab.com/gitlab-org/gitlab/-/commit/e9857175b69f175f8f0fc60b2abe306b65316afe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170195)) **GitLab Enterprise Edition**
- [Add new index to alert management alerts](https://gitlab.com/gitlab-org/gitlab/-/commit/286822402922238185831b8bd1418f7f976f8644) by @max.woolf ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174015))
- [Exposed pre_receive_secret_detection_enabled in ProjectTypes](https://gitlab.com/gitlab-org/gitlab/-/commit/fd5498a92c9eac3f4ead0525e186fbfb44a776e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173221)) **GitLab Enterprise Edition**
- [Enable auto_stop_in for non-deployment environment actions](https://gitlab.com/gitlab-org/gitlab/-/commit/a87f6660f9f39add380276dae514c51fc6b5f643) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173351))
- [Add notes fields to work item query](https://gitlab.com/gitlab-org/gitlab/-/commit/d9e7a1f3589d790734fed7c71a9d88a99e031085) by @joe-snyder ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173719))
- [Add entry for GLQL to code block languages](https://gitlab.com/gitlab-org/gitlab/-/commit/64ee6208422f520dfddc7b5f4cc2dc8141db669b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174024))
- [Remove feature flag "beyond_identity_exclusions"](https://gitlab.com/gitlab-org/gitlab/-/commit/e81fb19e8f709b4c053ad2f40a3b670de2645884) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173281))
- [Set assign_custom_roles_to_group_links_sm to true by default](https://gitlab.com/gitlab-org/gitlab/-/commit/29cb8e88d0c885716eae14376ba75b38068d9a52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173941)) **GitLab Enterprise Edition**
- [Dynamically populate Duo Chat slash command suggestions based on URL](https://gitlab.com/gitlab-org/gitlab/-/commit/18aff951238eba8f77bf6d4dd847653889c477d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173052)) **GitLab Enterprise Edition**
- [GraphQL: Expose user timezone](https://gitlab.com/gitlab-org/gitlab/-/commit/55aec6880d7637e869dd428b823dbceb89d00350) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173913))
- [Add "GET /groups/:id/enterprise_users" API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/249d272cb8e182f9110bc805d1ee4971d69e8795) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172408)) **GitLab Enterprise Edition**
- [Remove work_items_rolledup_dates feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/cd713ebb3acb770c4bf613eef162d49d1acfd345) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167917)) **GitLab Enterprise Edition**
- [Include identifierName argument to vulnerabilitySeveritiesCount GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/92756c3569e3c042642c145278f942861067d57b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173545)) **GitLab Enterprise Edition**
- [Add duo workflow status check](https://gitlab.com/gitlab-org/gitlab/-/commit/0ccc5fd1c5b215cae14d26c64fbc964a0abe47c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173388)) **GitLab Enterprise Edition**
- [View branches in development widget](https://gitlab.com/gitlab-org/gitlab/-/commit/9c9f04acf04b2e309436c6c7d002a003f526759a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173384))
- [Setup associations for inviting a group to a project with a custom role](https://gitlab.com/gitlab-org/gitlab/-/commit/8fe027c539890788b6e4bfe81acd2a3f31e10c6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173658)) **GitLab Enterprise Edition**
- [Support job token auth for read-only changelog generation API](https://gitlab.com/gitlab-org/gitlab/-/commit/72fc936d08b8b37786911c993f9c0ee4bbdf0ee5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172842))
- [Admin Token API: Cluster Agent Tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/401f5a1f70ca1d021c953eccb2f1e33c49b9ae71) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172932))
- [Admin Token API: Add support for reading OAuth Application Secrets](https://gitlab.com/gitlab-org/gitlab/-/commit/ff403182b64c0260bfe550e26f411da967bd021e) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172985))
- [Update project statistics when create/delete NuGet symbols](https://gitlab.com/gitlab-org/gitlab/-/commit/63f36aec2e3dc1495a67b70d208d69f6bfa61d5d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173411))
- [Make PersonalAccessToken#token routable](https://gitlab.com/gitlab-org/gitlab/-/commit/3bd08ef6f1c743ca0c048f27256e05dd9667d7f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169322))
- [Update UI text referencing confidentiality visibility](https://gitlab.com/gitlab-org/gitlab/-/commit/bc354fa3e04f34356da591342e2e315689247489) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171950))
- [Show anchors in cleanup image tags regex input fields](https://gitlab.com/gitlab-org/gitlab/-/commit/da699f136b30089454d216c4e3cabdc288d06ede) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172537))
- [Add PostgresTableSize](https://gitlab.com/gitlab-org/gitlab/-/commit/751bb26364670539d59a2dc063a1ab6b66d5b21f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173113))
- [Add Planner role to access level GraphQL enums](https://gitlab.com/gitlab-org/gitlab/-/commit/d4ff282b9fc64f8eb841fc4a05afc07c44aef340) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170940)) **GitLab Enterprise Edition**
- [Add permissions for Planner role](https://gitlab.com/gitlab-org/gitlab/-/commit/5b833ab353dcb6703fa6983df23ae3287c996460) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171283))
- [Add Planner role to Roles and permissions admin page](https://gitlab.com/gitlab-org/gitlab/-/commit/f52054a5eb5cdb34f6ff56dbfaeb9c30b51b7f5e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173280)) **GitLab Enterprise Edition**
- [Add Planner role](https://gitlab.com/gitlab-org/gitlab/-/commit/382fea3baa01e3a53176140033a93129cc9c1581) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256))
- [Implement new routable token specification](https://gitlab.com/gitlab-org/gitlab/-/commit/5e0e3d943fa686a2ee3a271bd47ee39c186096cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172708))
- [New GraphQL API for filter by identifier dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/e1da1669afbe66d60c97775fe49e70cd219915b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171464)) **GitLab Enterprise Edition**
- [Initial checkin for Admin Duo Configuration page](https://gitlab.com/gitlab-org/gitlab/-/commit/adfd5a0556a2bf0d68ee5a00da7b796345836dca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168702)) **GitLab Enterprise Edition**
- [Destroy mutation for compliance requirements](https://gitlab.com/gitlab-org/gitlab/-/commit/b896d5301c0a183a9338476b3a7606d42484472f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170380)) **GitLab Enterprise Edition**
- [Add migration to create missing terraform module metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/def8125c3c3370c9fcc007ebbe577feb910d4288) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171729))
- [Create is_known_exploit column in pm_cve_enrichment and add tests](https://gitlab.com/gitlab-org/gitlab/-/commit/b6400000bef4d917ee47f97fb19690584d273bdd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172190))
- [Expose can_create_organization through application settings API](https://gitlab.com/gitlab-org/gitlab/-/commit/4f5951936862414b0cd91dfab866ef206bdac6ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173380))
- [Remove merge_when_checks_pass feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/17d4261428a490ebdb74d33fc75425f9a0e717dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170886))
- [Remove feature flag lfs_misconfiguration_banner](https://gitlab.com/gitlab-org/gitlab/-/commit/3f88a3b929edff076309684edefeb7ea283eb258) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173318))
- [Link compliance frameworks with vulnerability management policies](https://gitlab.com/gitlab-org/gitlab/-/commit/a1ae237770add362366d2231a92b7b4597a28ecf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171766)) **GitLab Enterprise Edition**
- [Fetch linked context lines](https://gitlab.com/gitlab-org/gitlab/-/commit/65c38f43458b2224ed25d89628b150584cd8de9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172990))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/561277f08c6ca3ceacb4175c6c6f9321b1927671) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172810))
- [Add additional JWT audiences for Jira Connect](https://gitlab.com/gitlab-org/gitlab/-/commit/004c681cd170cb857ad912f190e2c85a7915bcc1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171197))
- [Clean up sm_duo_pro_bulk_user_assignment](https://gitlab.com/gitlab-org/gitlab/-/commit/92a7cf6c4fd5970dcdd5c4a3dd74f6a3570b6ccd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172975)) **GitLab Enterprise Edition**
- [Add legacy_destination mapping for audit event streaming destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/142f916425191a5bff07499aee19370f2d72a161) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172308)) **GitLab Enterprise Edition**
- [Add transclusion markdown syntax](https://gitlab.com/gitlab-org/gitlab/-/commit/09e452c92a5d2584f08aa0e7efa64e44845c89ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169374))
- [Add ciJobTokenScopeAllowlist graphql type](https://gitlab.com/gitlab-org/gitlab/-/commit/ac9434f1aab54f6918ca9bab029059eb80067d8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171887))
- [Support claude 3.5 Sonnet new model version](https://gitlab.com/gitlab-org/gitlab/-/commit/b054b171a4b0efed9ed73bf5294e6249c7db204b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173134)) **GitLab Enterprise Edition**
- [Use feature flag to new streamers](https://gitlab.com/gitlab-org/gitlab/-/commit/52db19c6cde0333d29ecd969ca71d419e1f320db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171431)) **GitLab Enterprise Edition**
- [Project template becomes an official part of the product](https://gitlab.com/gitlab-org/gitlab/-/commit/c55cde183c38d6ca7716da731c8ec48180922362) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172802)) **GitLab Enterprise Edition**
- [Add support for using ActiveRecord::Encryption](https://gitlab.com/gitlab-org/gitlab/-/commit/d3a67954521dad93641184fb7e640b1411d5235a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168773))
- [Initial checkin for duo configuration page](https://gitlab.com/gitlab-org/gitlab/-/commit/7ad19b5b575dfc2038bfa7e7e62d5a248102f3bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168581)) **GitLab Enterprise Edition**
- [Mark note as internal permission on frontend](https://gitlab.com/gitlab-org/gitlab/-/commit/ca581bd32666f4d3008a43c7895867eee692dc28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173083))
- [Added Work item frontend ground work](https://gitlab.com/gitlab-org/gitlab/-/commit/376c1db623cc48d8e5fa3eb9ccace2f0ef48245c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171126))
- [Added keyboard shortcuts for command platte](https://gitlab.com/gitlab-org/gitlab/-/commit/8da80d24cca92030d72e3380c23a59182e07cfb6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172732))
- [Enable ingestion of EPSS data to GitLab database](https://gitlab.com/gitlab-org/gitlab/-/commit/79231461a37eecb62fd54a8f85cee0e781bfe175) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172510)) **GitLab Enterprise Edition**
- [Default Duo Chat output tokens to 8k](https://gitlab.com/gitlab-org/gitlab/-/commit/3f9d9d358cef7f877c65ed765c379d1ac3efad6e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167841)) **GitLab Enterprise Edition**

### Fixed (181 changes)

- [Fix duplicate reply bug on wiki comments](https://gitlab.com/gitlab-org/gitlab/-/commit/1666d68421a36da4522f66d4ac15844eedfa0e8d) by @salihudickson ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175794))
- [Set CVSS vectors during vulnerability scanning](https://gitlab.com/gitlab-org/gitlab/-/commit/a91afd97174798423ac4081cfd1303708b3fb2cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175756)) **GitLab Enterprise Edition**
- [Fix CreateService for buffered_token_expiration_limit](https://gitlab.com/gitlab-org/gitlab/-/commit/51dfa96b004a77fd007fa9563a8fd20b36e48ba8) by @joe-snyder ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175124)) **GitLab Enterprise Edition**
- [Render a warning for pull mirroring when the project is read-only](https://gitlab.com/gitlab-org/gitlab/-/commit/cf7adc171c308208fbcbaf293a63178b4acec790) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174976))
- [Fix classification label default behaviour](https://gitlab.com/gitlab-org/gitlab/-/commit/b95bd172405c7d08adc17fdb280ecb243881722c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175201))
- [Return `title` field from YAML for `name` custom role graphql field](https://gitlab.com/gitlab-org/gitlab/-/commit/f03c16c2dd0f73152dc948f22467d406e75f02d0) by @Florian_Lang ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167405)) **GitLab Enterprise Edition**
- [Fix alignment of MR approvals widget revoke button](https://gitlab.com/gitlab-org/gitlab/-/commit/5cdf0f910fc9fe06466741bb9e20bdf66006f0e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175277))
- [Additional updates to PAT buffered expiration flow](https://gitlab.com/gitlab-org/gitlab/-/commit/82b4bc81ec76474f21ab41758c568aa736b103da) by @joe-snyder ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175172))
- [Improve confusing UX when deleting free project on gitlab.com](https://gitlab.com/gitlab-org/gitlab/-/commit/ee7733ad4de0852a42b031b9d5ee776b8e3027aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173338)) **GitLab Enterprise Edition**
- [Fix styling in Analytics data explorer](https://gitlab.com/gitlab-org/gitlab/-/commit/356b906299231e84cd3c1a709dec297520b74e8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174994)) **GitLab Enterprise Edition**
- [Fix work item create new draft data](https://gitlab.com/gitlab-org/gitlab/-/commit/f8a94926a292f33422a7f647587de3a38bad0a44) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175682))
- [Don't rewrite `applies_to_all_protected_branches` value on update](https://gitlab.com/gitlab-org/gitlab/-/commit/b27e692c03a6802aef0abb58e1b473a290d18e65) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175708)) **GitLab Enterprise Edition**
- [BranchRuleDelete mutation: fix 500 error when rule is missing](https://gitlab.com/gitlab-org/gitlab/-/commit/1238183c8618eb71a317a5a544f840ee65970d32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175275))
- [Fix incorrect query parameters for commits request](https://gitlab.com/gitlab-org/gitlab/-/commit/139c8184c4a393987e8f1d9a683c9ca1ebd1d991) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175665))
- [Backport bugfix for diff_files highlighting](https://gitlab.com/gitlab-org/gitlab/-/commit/a01b3538f10067f52f7d005496320d76a4284d15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175661))
- [fix: Add missing gitlab_sec schema to PrometheusAlertIndicator](https://gitlab.com/gitlab-org/gitlab/-/commit/85f73bd285525b1e91d89c444bea5a0f31bbd687) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170857))
- [Fix message for the restart merge train popup](https://gitlab.com/gitlab-org/gitlab/-/commit/c462d86f529e3d01d36f635fcb28607849e3332a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175631))
- [Sync any_merge_request rules based on scan_result_policy_reads](https://gitlab.com/gitlab-org/gitlab/-/commit/032c9d530e7b40db72352393eab5518ec27c8c74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175539)) **GitLab Enterprise Edition**
- [Show group dropdown for minimal access users](https://gitlab.com/gitlab-org/gitlab/-/commit/f174719c6ba7306adacc9f2abe53538412b66be0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173937))
- [Set minimum override role to developer](https://gitlab.com/gitlab-org/gitlab/-/commit/dd21e69c38967dfb287a1e686da204951e9f7e26) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175592))
- [Fix vulnerability_states filter for pre-existing approval rules](https://gitlab.com/gitlab-org/gitlab/-/commit/a21ee903a96862ca26a34492910e57ec123bfccf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175282)) **GitLab Enterprise Edition**
- [Fix composite identities with Gitaly calls](https://gitlab.com/gitlab-org/gitlab/-/commit/32a1bafaaabc0c359b1d5f3d88bb33e4655cd225) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175361))
- [Fix a strange bug with preserving paragraphs and list items](https://gitlab.com/gitlab-org/gitlab/-/commit/cad030f57fb9e184a9d5867d2c35416d19196bc3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175455))
- [Strip frontmatter when including wiki content](https://gitlab.com/gitlab-org/gitlab/-/commit/0809fc62f1e93685110a55ce923ad7e705b67d2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173573))
- [Allow issuable expansion when previewing wiki](https://gitlab.com/gitlab-org/gitlab/-/commit/7f938b29b5b566a0f9e628cfdb119f41c5703453) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175451))
- [Fix: last commit box action styling](https://gitlab.com/gitlab-org/gitlab/-/commit/190bc73b383d923c1768adaf54d03d2b1a7cdd92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175024))
- [Allow deactivated users with password reset to reactivate their accounts](https://gitlab.com/gitlab-org/gitlab/-/commit/8d281824b6fe9e3c64aabc8387806904eaeb1756) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172879))
- [Make finalzie background migration no-op](https://gitlab.com/gitlab-org/gitlab/-/commit/16ab92d94e14462f372a96af975f9d42a644f5fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175250))
- [Clean up `upgrade_pdf` flag](https://gitlab.com/gitlab-org/gitlab/-/commit/20ab97875677e8c5ce7b73079cddd248ecba4522) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174904))
- [Capture composite identity in Git workflows](https://gitlab.com/gitlab-org/gitlab/-/commit/d441612eebac359d72b95abe6d2335bf8614a759) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175144))
- [Namespace api find un-replicated newly created trial group by id](https://gitlab.com/gitlab-org/gitlab/-/commit/e1e18d127af80cca3c2b524b98e6c98180504570) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174396)) **GitLab Enterprise Edition**
- [Remove Owner from base_access_level roles when creating custom role](https://gitlab.com/gitlab-org/gitlab/-/commit/17294c6b19cc223c2754205fc52863514b726bc9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174735)) **GitLab Enterprise Edition**
- [Fix free shared runners minutes backfill](https://gitlab.com/gitlab-org/gitlab/-/commit/b761668a1230b01f81b8a9691823e93b52fc193c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175354)) **GitLab Enterprise Edition**
- [Fix ability to use password for Git when password for Web is disabled](https://gitlab.com/gitlab-org/gitlab/-/commit/798dabc5892dfc3d4a649a2c890b0728f5f638e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175160))
- [Fix color of emoji picker sticky header category header](https://gitlab.com/gitlab-org/gitlab/-/commit/6bd31f686892c4e1a575b0d30dd535eaae344cb3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175027))
- [Ensure p element inside details summary behaves properly](https://gitlab.com/gitlab-org/gitlab/-/commit/db42f1734a95455917dfd12535bfa22965353c6f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175336))
- [Only truncate/scroll to anchor on mount of work item description](https://gitlab.com/gitlab-org/gitlab/-/commit/a5ee9f98b1a146f215bef30abbf5d253791c4152) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175322))
- [Add pagination to group applications](https://gitlab.com/gitlab-org/gitlab/-/commit/063b450e2315f817c6773f98a51aa84281a3e162) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174464))
- [Fix empty branch name exception for branch delete](https://gitlab.com/gitlab-org/gitlab/-/commit/418b08f07135af4b0e121308ee563c4eae504a8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175294))
- [Set engine for OpenSearch indices](https://gitlab.com/gitlab-org/gitlab/-/commit/f0dfb650059c6c76498376bd9ee5567ce8e3ff50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175261)) **GitLab Enterprise Edition**
- [Deprecate :labels negatable filter value](https://gitlab.com/gitlab-org/gitlab/-/commit/a2cedccbc13b8523293267e93b81c0725dbb1009) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175166))
- [Fix note creation error for SHA256 repositories](https://gitlab.com/gitlab-org/gitlab/-/commit/869627307ea51b7ef09c930881c7a48528bd9124) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174154))
- [Improve checking on status of SAST jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/e6c52452dab4f197600827cbc9ff1cf4e142dbe7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173027))
- [Set request_path when rendering repository blobs](https://gitlab.com/gitlab-org/gitlab/-/commit/d59d3e234ec4532e0d58d54fb3c279b2ec2cd9fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175185))
- [Remove redacting inaccessible wiki link slugs](https://gitlab.com/gitlab-org/gitlab/-/commit/90c973dc010a7202db03d24eee0ce66732a0997e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175180))
- [Make discussions API work with quick actions-only notes](https://gitlab.com/gitlab-org/gitlab/-/commit/69e3ac9592d5c655806a292266504f6fec484973) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174935))
- [Update doorkeeper to v5.8.1](https://gitlab.com/gitlab-org/gitlab/-/commit/1eea01929a9f382485e363892ac24d59fb359861) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175127))
- [Fix date re-calculation when moving children](https://gitlab.com/gitlab-org/gitlab/-/commit/b48ed43ee786f3d77c9514c2906178492c5853f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174698))
- [Changed A tag to pajamas button](https://gitlab.com/gitlab-org/gitlab/-/commit/1879d3d2d69df0fd894cba1fb7f2072fb4ca2d83) by @mehulsharma ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174427))
- [Fix Flux status popover with long message](https://gitlab.com/gitlab-org/gitlab/-/commit/b47a576bed610d1715905a4b6f68a600bf1b95ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174309))
- [Add additional checks for diff tabs](https://gitlab.com/gitlab-org/gitlab/-/commit/6f6d39ca707a39df474c50469df5d80e6267f973) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174972))
- [Fix font weight when selecting status](https://gitlab.com/gitlab-org/gitlab/-/commit/9f76d58c4af13caa7d942995306b8f8faa586b48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175058)) **GitLab Enterprise Edition**
- [Style fixes for on call schedules page](https://gitlab.com/gitlab-org/gitlab/-/commit/a94bdca0f4d1a0892a1c07788c41f85fc719f1b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175022)) **GitLab Enterprise Edition**
- [Remove FF update_approval_rules_for_related_mrs](https://gitlab.com/gitlab-org/gitlab/-/commit/c3faca64fa75d4a0697754781e4008876eefa373) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175009))
- [Fix scrolling in markdown/RTE](https://gitlab.com/gitlab-org/gitlab/-/commit/925226171d2c24bba4bad818f97c37e600926a7b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175002))
- [Adjust styles of Value stream filters row](https://gitlab.com/gitlab-org/gitlab/-/commit/cf7f7bc34f334a71956681db2a936a12b54a8451) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174991))
- [Adjust styling of Merge request analytics filters bar](https://gitlab.com/gitlab-org/gitlab/-/commit/df95760a73d0d7bd78d87fdd55eabb76268098b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174986))
- [Fix reference to inline code bug](https://gitlab.com/gitlab-org/gitlab/-/commit/2fe980ef0cf8c201f8ce62f0c1209ac278939e15) by @mehulsharma ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174837))
- [Emails on Push: fix wrong number of changed files](https://gitlab.com/gitlab-org/gitlab/-/commit/fee9b9be6d4fed0458b0e7a7b8179fbd4930fea6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172089))
- [Only add matching roles for codeowner role approvers](https://gitlab.com/gitlab-org/gitlab/-/commit/4c922d50a705bbd3fbef3a167a8ed5c2f430ead3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174681)) **GitLab Enterprise Edition**
- [Disable read_dependency and read_licenses policies for Planner role](https://gitlab.com/gitlab-org/gitlab/-/commit/414d277f5e7d918d8d6f68c03c34d825d9681d45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174838)) **GitLab Enterprise Edition**
- [Fix GlCard rendering in dark mode for empty repository message](https://gitlab.com/gitlab-org/gitlab/-/commit/6595c01bb1a8eb60aca0e61d8a8c8132a2fa6bd7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174927))
- [Re-order concurrency limit and deduplication middleware](https://gitlab.com/gitlab-org/gitlab/-/commit/3cb454fd744a04502011be8e3a0ff83e76ce45d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174929))
- [Make control expression nullable](https://gitlab.com/gitlab-org/gitlab/-/commit/fa968028f4a96193234ece0b7c3e368940990af6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174859)) **GitLab Enterprise Edition**
- [Update styles of Error tracking list page](https://gitlab.com/gitlab-org/gitlab/-/commit/a30b6fab9f714e6b2816bd5505af5e2f2933f1c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174916))
- [Mention ClickHouse requirement in GraphQL queries](https://gitlab.com/gitlab-org/gitlab/-/commit/7b455c62ec0c5704b254e7439f830f2158fd5b4d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174375)) **GitLab Enterprise Edition**
- [Set defaults format to csv](https://gitlab.com/gitlab-org/gitlab/-/commit/3952f89b17c2c8e8970e28e32e0967262e644d22) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174893))
- [Handle other errors from TomlRB library](https://gitlab.com/gitlab-org/gitlab/-/commit/63b2f80ec60fc1c5722af85ceea96c2a5793861d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174653))
- [Allow approvals widget content to wrap](https://gitlab.com/gitlab-org/gitlab/-/commit/f66ce9d7e2ca34eb9f2c13aeb09c5b66f12659d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174876))
- [Fix wording on vulnerability state transitions](https://gitlab.com/gitlab-org/gitlab/-/commit/ff91651f8153d48e9f603f8a5f7c08b0e0ba7687) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174736)) **GitLab Enterprise Edition**
- [Backfill ci_cd_settings when updating project](https://gitlab.com/gitlab-org/gitlab/-/commit/83628d9241f18ecc26ca3835ef5aa36020fbfa2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174841))
- [Move nuget symbol files creation outside uploading package transaction](https://gitlab.com/gitlab-org/gitlab/-/commit/01658378a654cbc59a0a6b5ffa73deff6ef2450d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174829))
- [Ensure project deletion with external pipeline works](https://gitlab.com/gitlab-org/gitlab/-/commit/b440048b56e815c0b3220eee29c045954e03b950) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174023))
- [Use `:not(.gl-button)` selector to avoid overriding GlButton usage](https://gitlab.com/gitlab-org/gitlab/-/commit/6476aba4b04331a2c54c088a16722fa3ba3f402d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174785))
- [Remove box-shadow from old dropdowns on hover](https://gitlab.com/gitlab-org/gitlab/-/commit/9c24418973a1819f13c4e862c88923a5eded31d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174733))
- [Pre-load the TanukiEmoji index](https://gitlab.com/gitlab-org/gitlab/-/commit/e511424b16ae0e80cd5e1fe1e18f5e5f21950e9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174729))
- [Add a namespace to the csv_download_path](https://gitlab.com/gitlab-org/gitlab/-/commit/7d0a3bffdf4bfc635e71acc36f220aed2b47eb22) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174656))
- [Fix dropdown variant for AI actions](https://gitlab.com/gitlab-org/gitlab/-/commit/f81dfdfc2b9978f2a41c3e0f8feafee868bd91d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174696)) **GitLab Enterprise Edition**
- [Re-add Tier/Offering details to bulk edit issues documentation](https://gitlab.com/gitlab-org/gitlab/-/commit/c9c3ee093d8381d046ea683a9f4a4b48c8731e12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174710))
- [Add budget into Auto Resolve process](https://gitlab.com/gitlab-org/gitlab/-/commit/d814866f564b0b996dcaaf5f3655b5c4090a7818) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174679)) **GitLab Enterprise Edition**
- [Backfill nil started_at values](https://gitlab.com/gitlab-org/gitlab/-/commit/6fc8954c60a9709e5502af19d257a9fafee3835e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174626))
- [Fix vertical alignment of MR approvals summary](https://gitlab.com/gitlab-org/gitlab/-/commit/ae0e87009353f274b3604d1ec210bcae383984c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174704))
- [Reset unconfirmed_email if it exists on /users/identity_verification/verify_email_code](https://gitlab.com/gitlab-org/gitlab/-/commit/b39f0b7f10a578708e00f8236fec097bd6cab667) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173468)) **GitLab Enterprise Edition**
- [Avoid creating approval rules from policies for unprotected branches](https://gitlab.com/gitlab-org/gitlab/-/commit/265ff008c7e016d693df24d6dbe03708aac4be66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173345)) **GitLab Enterprise Edition**
- [Fix alignment of wiki pages buttons](https://gitlab.com/gitlab-org/gitlab/-/commit/3bbaf9fcb5e4c5bb6457cf9280605d8c0407ff54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174601))
- [Fix page header button alignment](https://gitlab.com/gitlab-org/gitlab/-/commit/ea44033c54bd714fa0855ea35d486ecc1c53487a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174423))
- [Fix incorrect conflict warnings on issuable update](https://gitlab.com/gitlab-org/gitlab/-/commit/857ffd23fdf2a9d64d7138f0933eff994bf750fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174190))
- [Fix Psych::DisallowedClass in WebHookLog](https://gitlab.com/gitlab-org/gitlab/-/commit/c23ab1192b67cc2dd1d7c9d6dab03dc5d9982c9d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173064))
- [Fix integration test settings](https://gitlab.com/gitlab-org/gitlab/-/commit/2614b6b5c6b1ee25125fb9bc015df0f73b776e48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169861))
- [Fix gap between avatar and text for board assignee in config modal](https://gitlab.com/gitlab-org/gitlab/-/commit/ad2c12996f598f028fc0de06d399cf8732da8850) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174449)) **GitLab Enterprise Edition**
- [Fix spacing of boad configuration modal buttons at small size](https://gitlab.com/gitlab-org/gitlab/-/commit/9902d3eff80ada25ce23cbfce7bbd19eadcdbc06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174451))
- [Continue to show roadmap filters bar when no results to access settings](https://gitlab.com/gitlab-org/gitlab/-/commit/5951e7ea91b8757c43339ea601ac4816a81b5c83) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173597)) **GitLab Enterprise Edition**
- [Revert removing default value from oauth tables](https://gitlab.com/gitlab-org/gitlab/-/commit/17f12fa724658b14207327446b92a361d66af6b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174366))
- [Allow plus icons in project nav to inherit color](https://gitlab.com/gitlab-org/gitlab/-/commit/853e57f9a21201b24ad3a037e66be2590e9d8abd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174407))
- [Do not warn changelog required when removing feature flag patches](https://gitlab.com/gitlab-org/gitlab/-/commit/acda77c4f8583f6c8122c8c295e4dd825031e12e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173992))
- [Ensure access_level is present before comparison](https://gitlab.com/gitlab-org/gitlab/-/commit/0d29e52a16167c64895575ae60ac01ba80fcbcf0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174354))
- [Fix undefined method error 'assigned_to_duo_enterprise?'](https://gitlab.com/gitlab-org/gitlab/-/commit/a6b0defdd6783c1241b5d10e94a7f0531ae7f054) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174345)) **GitLab Enterprise Edition**
- [Fix accessibility violation for vue_shared/settings-block](https://gitlab.com/gitlab-org/gitlab/-/commit/bda71e932fc588b686ef66c68c73f97262a47c66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174321))
- [Support quick actions in commits and discussions API](https://gitlab.com/gitlab-org/gitlab/-/commit/05729f5de1d04de3c3fb9673b27a6f46e0705b3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173055))
- [Avoid reporting error in Sentry for known failures](https://gitlab.com/gitlab-org/gitlab/-/commit/d16df90a9c50fb7e36ffb4957ea3cf45252c4c89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174290))
- [Add optional chaining to avoid `null` error](https://gitlab.com/gitlab-org/gitlab/-/commit/511891bb1dd552391f724cc031d721b25b18a02b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173207))
- [Fix is_blocked_by for epic work item](https://gitlab.com/gitlab-org/gitlab/-/commit/b7402acc368b21b2d4ffbcba35a892eb70d516b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174277)) **GitLab Enterprise Edition**
- [Fix protected tags with Deploy keys](https://gitlab.com/gitlab-org/gitlab/-/commit/2f29d1c8efdb5e96cf992d80e6289dae2f3727af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174269))
- [Fix Dangerfile parsing non-Ruby files](https://gitlab.com/gitlab-org/gitlab/-/commit/22e9a73e1811ce5e6d34b13d8e9d0b58cb9ee6e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174179))
- [Fix epic work item rake task progressbar](https://gitlab.com/gitlab-org/gitlab/-/commit/0c9b1096d6413caa225fc2cae3145e3d9090913b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174265)) **GitLab Enterprise Edition**
- [Fix search on the environments page](https://gitlab.com/gitlab-org/gitlab/-/commit/704e3364b972bcf4ff20c0dfe4f6d9c3661883a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174128))
- [Only show LFS misconfiguration banner when objects exist in project repo](https://gitlab.com/gitlab-org/gitlab/-/commit/12969096d3852938cabff297206b467ba3400aed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173880))
- [Skip validations when transforming references](https://gitlab.com/gitlab-org/gitlab/-/commit/66c2e24db13ecb8edbbd32873d3ed7e3ad03322b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174201))
- [Mark repository at URL not found as missing on primary](https://gitlab.com/gitlab-org/gitlab/-/commit/3ffb9dc81250756c37f3e7f19152f098660c37dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173059)) **GitLab Enterprise Edition**
- [Fixed z-index issue in content editor box](https://gitlab.com/gitlab-org/gitlab/-/commit/be3e679d51c65c30a60b6be9ac9d6d5969cec946) by @mehulsharma ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173971))
- [Add guard clause to Wiki#find_page when title is nil](https://gitlab.com/gitlab-org/gitlab/-/commit/36c79908d95d8fb3f09ea5ee91cfa99352e96115) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174011))
- [Rewrite the InitialIndexingEventWorker to fix the SQL timeout](https://gitlab.com/gitlab-org/gitlab/-/commit/9ecb454feb61feda927298fcaaff383dbb2fa41f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174170))
- [Fix the logic of mark_indices_as_ready](https://gitlab.com/gitlab-org/gitlab/-/commit/f7c0b9e5f92a4352ba3765759c3c5c53d51a281c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174034)) **GitLab Enterprise Edition**
- [Cache Cloud Connector keys in process memory](https://gitlab.com/gitlab-org/gitlab/-/commit/2cf843753b825c79d0f5ad6eb155c8299314eda0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174153)) **GitLab Enterprise Edition**
- [Refactor to check if user has access to experimental features](https://gitlab.com/gitlab-org/gitlab/-/commit/ecae72d30bda91e4161c97d8f0ad3b435f45e450) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173015)) **GitLab Enterprise Edition**
- [Do not create system not when linked on same EPIC](https://gitlab.com/gitlab-org/gitlab/-/commit/cb695a0f0a4d7ba0c495342214fa66ae33521af5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173397)) **GitLab Enterprise Edition**
- [Fetch projects in subgroups for DORA projects comparison chart](https://gitlab.com/gitlab-org/gitlab/-/commit/708ba43689cc615b6832e22b4e0cec064c3aa053) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174088)) **GitLab Enterprise Edition**
- [Ensure cron manager receives updated geo node](https://gitlab.com/gitlab-org/gitlab/-/commit/b168df49e354ff5d68ff91fa72f891461b790f16) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173724)) **GitLab Enterprise Edition**
- [Raise internal/suggested_reviewers query limit to 110](https://gitlab.com/gitlab-org/gitlab/-/commit/03e0371a69ad0d50c6a7af2d0c29b53f4e125237) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174032))
- [Fix code block style in RTE](https://gitlab.com/gitlab-org/gitlab/-/commit/210e2fd3708e1df9f4e4d07e3968709f589093a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174016))
- [Release use_exclusive_lease_in_mvn_find_or_create_package FF](https://gitlab.com/gitlab-org/gitlab/-/commit/73fefd55fb9f6b5a4fb5296aa541f0c10d475224) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174007))
- [Allow pushing locked LFS files merged from upstream](https://gitlab.com/gitlab-org/gitlab/-/commit/58341e94a6b067f2225bfa76aeede7c84bbfee40) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174012))
- [Ensure .pipeline-policy-pre jobs finish before starting others](https://gitlab.com/gitlab-org/gitlab/-/commit/749f96fd3879365cdfc1b09dd46fb7ad8dd4352e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165096)) **GitLab Enterprise Edition**
- [Zoekt: Do not process failed repos](https://gitlab.com/gitlab-org/gitlab/-/commit/aa3f247637b072cb2ef56480e1bca01093b8ab7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173895)) **GitLab Enterprise Edition**
- [Fix stages_compatible? not being restrictive enough](https://gitlab.com/gitlab-org/gitlab/-/commit/f7d5120cf71d2a2e005b59e952f118aec2653fde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173273)) **GitLab Enterprise Edition**
- [Make sure ref_type for History control is appended only once](https://gitlab.com/gitlab-org/gitlab/-/commit/ad0d33b8368c1f74c974cb96e61a9900e96da566) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173980))
- [Fix wrong changes counter on merge request commit diffs](https://gitlab.com/gitlab-org/gitlab/-/commit/dc9d3e041fd83457f52939e23899c2d5c03df507) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173382))
- [Temporary fix for activity feed tooltip contrast](https://gitlab.com/gitlab-org/gitlab/-/commit/0b18716ac5872b9196fce14aad3bc4126c6512a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173610))
- [Fix 403 errors when setting CI/CD variables via REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/13039fa4d195efc2ac07441b55581261f5711c2c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173202))
- [Improve error message for runner creation with invalid scope](https://gitlab.com/gitlab-org/gitlab/-/commit/2e62c42ffe3b09727581800bf54ca15f485e1c2c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173862))
- [Fix model registry version table error with null author](https://gitlab.com/gitlab-org/gitlab/-/commit/c7f4b24ed82077ccc1818305b6b22a1d8adf177d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173504))
- [Fix dependency on ApplicationSetting stubs for `let_it_be`](https://gitlab.com/gitlab-org/gitlab/-/commit/18e0f0d04db50f9d055d191826165e1f4b7b771c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173636))
- [Improve MR resource prompt to avoid misunderstandings of LLM](https://gitlab.com/gitlab-org/gitlab/-/commit/baf66a2dc5b1cc8439558c7aee7a0ace1378680a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173679)) **GitLab Enterprise Edition**
- [Allow invited Owners to top-level group to manage its enterprise users](https://gitlab.com/gitlab-org/gitlab/-/commit/d0f4f00e5b57ec7221fd8f1093e8a146e8804a2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173179)) **GitLab Enterprise Edition**
- [Ensure placeholder references are creating in Direct Transfer](https://gitlab.com/gitlab-org/gitlab/-/commit/cdcab4aff69e678708e2229d8deb86cf57eba44d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173791))
- [Revert "Merge branch 'remove-ff-lfs_misconfiguration_banner' into 'master'"](https://gitlab.com/gitlab-org/gitlab/-/commit/877040fb364b1a510e770327eaaecb75cd3fa0c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173781))
- [Fix translated string used in comparison](https://gitlab.com/gitlab-org/gitlab/-/commit/ab6c63dda7da723ae49c15ae1cea2cba6a1fc2ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173749)) **GitLab Enterprise Edition**
- [Fix 500 error for /api/v4/groups?all_available=false&statistics=true API](https://gitlab.com/gitlab-org/gitlab/-/commit/7fe72d7b0af5303902827cf3ab1c3ad718ae7102) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173717))
- [Mini Pipeline Graph dropdown: Change job action button size to sm](https://gitlab.com/gitlab-org/gitlab/-/commit/42a31a470e60f008da4f9df766cb77aeac682c5c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173526))
- [Notes: Confidential or locked message see-through fix](https://gitlab.com/gitlab-org/gitlab/-/commit/5fe2592e218cfdfcad6c50cc9abd221a3e741bf5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172994))
- [Fix edit snippet button alignment](https://gitlab.com/gitlab-org/gitlab/-/commit/1ea88266c9013e7dc014756f5a1baadaec0b4f6e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173624))
- [Add a loading state for branch rule query](https://gitlab.com/gitlab-org/gitlab/-/commit/9939f9c06df9452f1a76196c2b1bcd703c77e9f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173441))
- [Ensures margin in confidential badge](https://gitlab.com/gitlab-org/gitlab/-/commit/66405cb450aeeca292520aa16d5bf9aba1e7283c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173589))
- [Fix creating current iterations](https://gitlab.com/gitlab-org/gitlab/-/commit/f6ab2be078b7d4da34f2104e96984b0dbe860a06) by @umahasu ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173544)) **GitLab Enterprise Edition**
- [Fix code reloading problems with custom database types](https://gitlab.com/gitlab-org/gitlab/-/commit/88ca73af56e44d91097177da64d7c4f722e426fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173566))
- [fix: Ordering of metadata on work items Child & Linked widgets](https://gitlab.com/gitlab-org/gitlab/-/commit/3f89e641172f70d692fd3617ce8898162cdaa320) by @vedant-jain03 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173033))
- [Sync security policies when compliance framework is changed](https://gitlab.com/gitlab-org/gitlab/-/commit/43285b93300a7c082cfb2aa864c684ba5e0e562a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173259)) **GitLab Enterprise Edition**
- [Return unique project set on any framework filter](https://gitlab.com/gitlab-org/gitlab/-/commit/080f52acd3c9e5a001707d124c12c8e25dd681ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173019)) **GitLab Enterprise Edition**
- [Fix issue dashboard ANY/NONE assignee filters](https://gitlab.com/gitlab-org/gitlab/-/commit/1883cb4f21d1cc6e1aef8d38190c93eb709b6f02) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173549))
- [Enable nested expansion in rules:changes/exists](https://gitlab.com/gitlab-org/gitlab/-/commit/6932feff4602d92f468f985b4ee90d2e99161dce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166779))
- [Enforce both scan and pipeline execution policies with missing CI](https://gitlab.com/gitlab-org/gitlab/-/commit/01bd8637fa7106f6c14b976c0386f030da436858) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171911)) **GitLab Enterprise Edition**
- [Sort by member role when a user has the same access_level](https://gitlab.com/gitlab-org/gitlab/-/commit/e01f2163c4787252c828dd0950d419c6c19f57b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171365))
- [Improvements for markdown editor resize behavior](https://gitlab.com/gitlab-org/gitlab/-/commit/4cec15e9014eff6aefc2b19e57242c7fef8b3066) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173465))
- [Hotix: filtering out licenses with a nil spdx_identifier](https://gitlab.com/gitlab-org/gitlab/-/commit/8727f65e95c13e757f5ceb50ce2bb134d0689c73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173279)) **GitLab Enterprise Edition**
- [Update glql docs link](https://gitlab.com/gitlab-org/gitlab/-/commit/602b4988d5903dad271cfbc15481fd4814433425) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173336))
- [Fix behavior of copy buttons on Wiki clone modal](https://gitlab.com/gitlab-org/gitlab/-/commit/eea9ea071b74ed56896b920b98eec26ce21a5937) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173319))
- [Ensure collapsed sidebar todo button is correct color](https://gitlab.com/gitlab-org/gitlab/-/commit/5fe2230a17a63371170da0942031f0d26a8f2eb3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172105))
- [Only show "can only add issues" warning when issuableType is issue](https://gitlab.com/gitlab-org/gitlab/-/commit/ae92e1d7d0a98e8730c40a39d688952d639ef927) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173297))
- [Remove description text limit on security_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/76456765571b2447c83fbcfcb7351eb92cc50d6e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172933))
- [Fix wrong MR reference in draft notes](https://gitlab.com/gitlab-org/gitlab/-/commit/b9a0ac495998c817f8292f3962e01b71791fa81d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173266))
- [Fix ElasticIndexingControlWorker exception](https://gitlab.com/gitlab-org/gitlab/-/commit/f14d9c9ef77bff333a4fd3394cd6749aab1884d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173252)) **GitLab Enterprise Edition**
- [Fix Keyboard shortcuts for work items](https://gitlab.com/gitlab-org/gitlab/-/commit/e87480380cdbf41666576288b867775c72a0b10b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173222))
- [Log AI Gateway client HTTP errors](https://gitlab.com/gitlab-org/gitlab/-/commit/b1c3318486e8a820f6073e0ee501bd1d1268498d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173164))
- [Ensure new issues in iteration list have that iteration](https://gitlab.com/gitlab-org/gitlab/-/commit/ef5201bb78b723a38d3a3e0e1a407c45b3e1359c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173194)) **GitLab Enterprise Edition**
- [Fix X-Gitlab-Token always present in webhook logs](https://gitlab.com/gitlab-org/gitlab/-/commit/59cc3aa28a28c57beb7107047e99a1b88b0008ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173062))
- [Revert external_audit_event_destination url generation change](https://gitlab.com/gitlab-org/gitlab/-/commit/bc8f7a89886728dfb2ab77908e86c0628271d9b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173172)) **GitLab Enterprise Edition**
- [Ensure `!` is used for MR identifiers in Vue MR list page](https://gitlab.com/gitlab-org/gitlab/-/commit/6b23937619c0b963d4719ce8ada2b872c7f5586f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173170))
- [Filter security_findings by latest successful security_scan](https://gitlab.com/gitlab-org/gitlab/-/commit/8ba6f54cb34def47dfd762fc717d08d046b272e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172587)) **GitLab Enterprise Edition**
- [Add pagination to projects DORA comparison table](https://gitlab.com/gitlab-org/gitlab/-/commit/56510c095476e05f7165bbae234b1411bb8471c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173175)) **GitLab Enterprise Edition**
- [Fix responsive layout of failed pipeline job troubleshoot button](https://gitlab.com/gitlab-org/gitlab/-/commit/2cd84de84cfd954dfefc92fd9eb92ab04905815a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173155)) **GitLab Enterprise Edition**
- [Fix 401 errors when installing the GitLab for Jira app](https://gitlab.com/gitlab-org/gitlab/-/commit/04fbcf053ef5a51a069100c5a7680576abc4cc9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173110))
- [Fix ActionView::Template::Error: undefined method `xpath'](https://gitlab.com/gitlab-org/gitlab/-/commit/af38b6f6aeaab369fd16614c707ccca6abc27cce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173127))
- [Nil check in after_sign_in_path_for](https://gitlab.com/gitlab-org/gitlab/-/commit/261fce48893dde8fb06cae9433d139a6ef8a7e35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172466))
- [Support stages from policies with override_project_ci strategy](https://gitlab.com/gitlab-org/gitlab/-/commit/116d562a3fdf5a0f7f80445cbd48a022f04e219b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171680)) **GitLab Enterprise Edition**
- [Pre-populate branch name for delete and replace blob](https://gitlab.com/gitlab-org/gitlab/-/commit/15ee0855c83c7225a9e256da1b51298b48fbe858) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172451))
- [Fix logic and styling of archived project warning in diff comments](https://gitlab.com/gitlab-org/gitlab/-/commit/191d9a469689737aa8cbab9e7d9fbe173dec74c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172588))
- [Change audit label to 30 days instead of month](https://gitlab.com/gitlab-org/gitlab/-/commit/d96797cbf19fea0eb9af8bcc1a927a3bd376419e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173010)) **GitLab Enterprise Edition**
- [Fix incorrect pull mirror configuration after re-creation](https://gitlab.com/gitlab-org/gitlab/-/commit/74ba3b60a1f4298eee4fec2903b23b7805a53b2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172982)) **GitLab Enterprise Edition**
- [Fix: incorrect sorting url for branches](https://gitlab.com/gitlab-org/gitlab/-/commit/a8b3ce112106810cae6a8784b2eea624ae17372e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172873))
- [Add missing email suffix for Emails On Push and Admin emails](https://gitlab.com/gitlab-org/gitlab/-/commit/a9b82b8d6a91e63b713f44e2eec30f8852a61761) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172846))
- [Show None role for invited group members when project sharing disabled](https://gitlab.com/gitlab-org/gitlab/-/commit/e5199ec4e1e8f8618d803865d79133dc04265050) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171904))

### Changed (227 changes)

- [Remove feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/157d25b1a90614a1f4a0f746a671b47b19e3974d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175803))
- [Add currentUser query to LockDirectoryButton](https://gitlab.com/gitlab-org/gitlab/-/commit/245b3b4b499c3ba7d6c42eb10c04058e94674586) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175591)) **GitLab Enterprise Edition**
- [Resolve cross-transaction when destroying project](https://gitlab.com/gitlab-org/gitlab/-/commit/236614127b7aa76c85a7348143f998628d6a6271) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171913)) **GitLab Enterprise Edition**
- [Extend topics explore page to provide more details](https://gitlab.com/gitlab-org/gitlab/-/commit/7770fd17bd7b560edb923dabbb702ca5681bd55c) by @bufferoverflow ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170104))
- [HelpIcon migrations](https://gitlab.com/gitlab-org/gitlab/-/commit/67b09704afcb375fb61a38d319684a3d86a5575a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175679))
- [Remove set_feature_flag_service feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b524038a66c90d45fadb3747be7bd32571a80343) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174208))
- [Basic MVP for wiki template management from create page](https://gitlab.com/gitlab-org/gitlab/-/commit/0ef72c4d4af11ce57964bc2cc969ea8a8d683201) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175329))
- [Add feature flags for all included duo context](https://gitlab.com/gitlab-org/gitlab/-/commit/2656adda266932047819695649f6fcaaf1fd6de3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175338)) **GitLab Enterprise Edition**
- [Add summarize new mr aigw service](https://gitlab.com/gitlab-org/gitlab/-/commit/5ff00a17c9f1d5a48209ead83a18b81996d819e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172962)) **GitLab Enterprise Edition**
- [Use cloud connector gem config and remove access_data.yml](https://gitlab.com/gitlab-org/gitlab/-/commit/78928e393dbe2ff45fe793038af66133b572f844) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175577))
- [Update existing approvers when yaml updates](https://gitlab.com/gitlab-org/gitlab/-/commit/34e4047a38107c55ce6a178a531b09adc7f15a93) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175344)) **GitLab Enterprise Edition**
- [Queue AfterImportWorker after every import](https://gitlab.com/gitlab-org/gitlab/-/commit/eb78e5e95ab9cd958ddfc25ca7dcc1670ade1662) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175651))
- [Enable closing issues automatically, cross-project](https://gitlab.com/gitlab-org/gitlab/-/commit/a271ae2fd16ecbd4e6d9a76935cb9f9ee3ece893) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175650))
- [Distinguish Jira Connect apps by hostname](https://gitlab.com/gitlab-org/gitlab/-/commit/8f332906f45d46fe41fcb826e90f50f2135742af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175353))
- [Write organization_id to oauth tables](https://gitlab.com/gitlab-org/gitlab/-/commit/f10561a8dae8e891fa4463e452e926cb9a6e8d12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174513))
- [Migrate value_stream_metrics REST queries to Graphql](https://gitlab.com/gitlab-org/gitlab/-/commit/488ad9e6d4b29508bf1f2d18e6e39f5653d55618) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170383))
- [Resolve "Geo - Rename Replication Status to Database Replication status and...](https://gitlab.com/gitlab-org/gitlab/-/commit/e64815b82abca17eeef7ef92fd36bf8a5a40b778) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174206)) **GitLab Enterprise Edition**
- [Use commit changes modal for upload/replace blob](https://gitlab.com/gitlab-org/gitlab/-/commit/315450480e62676e213c3d395aa7e8070eb9b9e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174093))
- [Rearrage viewer swithcer and table contents](https://gitlab.com/gitlab-org/gitlab/-/commit/08b13598324e4fdc7ac6fc9d033a3877d73fc091) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174992))
- [Refactor getIterationPeriod() to support locale dateformat](https://gitlab.com/gitlab-org/gitlab/-/commit/295e409ecd6df717432b97596d9b9ea3a5197b0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174408))
- [Add currentUser query to LockDirectoryButton](https://gitlab.com/gitlab-org/gitlab/-/commit/546143362385f8cf9255d3d55823eaf16e34c8e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175324)) **GitLab Enterprise Edition**
- [Protected branches settings: Change breakpoint of table](https://gitlab.com/gitlab-org/gitlab/-/commit/61af047f2aa18649718cc324994f435daf9c0183) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173983))
- [Don't expose url credentials for bulk import](https://gitlab.com/gitlab-org/gitlab/-/commit/4c876002632836721d0b1dd9e1fea701079671c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174980))
- [Remove cross-join from ProjectsGrade](https://gitlab.com/gitlab-org/gitlab/-/commit/ab6a9a13d7eabf8936bbabce1278c954a6e4e107) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172720)) **GitLab Enterprise Edition**
- [Remove isNotSastIACTemporaryHack](https://gitlab.com/gitlab-org/gitlab/-/commit/6ae8cb39635666a63b7a53a27bdb42706b4445b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174628)) **GitLab Enterprise Edition**
- [Update feature flag type for 3rd party importer user mapping to beta](https://gitlab.com/gitlab-org/gitlab/-/commit/e93f6b05f6896cc29e5267e733d1f03c1acf829b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175511))
- [Move compliance center up in project nav](https://gitlab.com/gitlab-org/gitlab/-/commit/1c7c2889c0583b77170c28919dee53e5848638bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174220))
- [Enabled importer_user_mapping by default](https://gitlab.com/gitlab-org/gitlab/-/commit/98149d2816e44a28387cfadb21d128f4c94455ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175371))
- [Enabled bulk_import_importer_user_mapping by default](https://gitlab.com/gitlab-org/gitlab/-/commit/311f159283be02246db1ddda5b336968eeb6b6aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175372))
- [Enable auto-resolve feature flags by default](https://gitlab.com/gitlab-org/gitlab/-/commit/56341bbf8c16a052474d24ab0f36f8a526ed2a32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175306))
- [Add currentUser query to LockDirectoryButton](https://gitlab.com/gitlab-org/gitlab/-/commit/33cf91017125ab7574816eca5367a2ab48244837) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174967)) **GitLab Enterprise Edition**
- [Change default of `restrict_user_defined_variables` to `true` behind FF](https://gitlab.com/gitlab-org/gitlab/-/commit/b51b09305169f8521b7ba12f746990e6432d0a96) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171424))
- [Rollout feature flag for self-maneged instances](https://gitlab.com/gitlab-org/gitlab/-/commit/e582cf6dfe767cf6082e215eaea083faea179777) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175397)) **GitLab Enterprise Edition**
- [Add exceptions selector to allow deny list](https://gitlab.com/gitlab-org/gitlab/-/commit/76605f64fa24334bdc94adcdcaa2b79011704f38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174930)) **GitLab Enterprise Edition**
- [Add time window for sep schedule scans](https://gitlab.com/gitlab-org/gitlab/-/commit/3e4bf913af8eb37126078f26663128ab34b28c9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174596)) **GitLab Enterprise Edition**
- [Raise error on rename/move if geo is enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/8986ee1b4b259f33602bad8e257aa9f7878612e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174753)) **GitLab Enterprise Edition**
- [Move confidentiality to actions menu for legacy issuable](https://gitlab.com/gitlab-org/gitlab/-/commit/f897f6788f5563a7bf8fb60ddf901e52c53a56a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172577))
- [Update validation for multiple approval actions](https://gitlab.com/gitlab-org/gitlab/-/commit/f35951c996d8fdbe20ce4ffa0041a4ee1ce9884d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174622)) **GitLab Enterprise Edition**
- [Switch duo pro cdot direct linking in favour of redirect](https://gitlab.com/gitlab-org/gitlab/-/commit/66df8845f5115203d87fe8db8ffc62b122fd37a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174884)) **GitLab Enterprise Edition**
- [Update validation of multiple approval actions](https://gitlab.com/gitlab-org/gitlab/-/commit/6d72e2b48bd3f23ca72640f3c188cc9f437e9f12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174068)) **GitLab Enterprise Edition**
- [Add conditions to LFK definition](https://gitlab.com/gitlab-org/gitlab/-/commit/15c0c870b6adb9d74794c364357136ed748cc3fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172412)) **GitLab Enterprise Edition**
- [Move work item dev widget to main body and add create entity](https://gitlab.com/gitlab-org/gitlab/-/commit/1f0611027b60cff4399ea6be8b92e1e57d80affa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173963)) **GitLab Enterprise Edition**
- [Move Import::GithubService#repository_size_limit to EE](https://gitlab.com/gitlab-org/gitlab/-/commit/c56e86ffb02a2488df59651718a12422a3bf6420) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173854))
- [Add disable password authentication to group audit events](https://gitlab.com/gitlab-org/gitlab/-/commit/89d89a543cefe0f6a34203a0da97a7409f6e05d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174468)) **GitLab Enterprise Edition**
- [Update labels for required comments and dismissal reasons](https://gitlab.com/gitlab-org/gitlab/-/commit/9f680566d487f515eed80a7a33e58b00522ff5dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174902)) **GitLab Enterprise Edition**
- [Iterations: Migrate to use Crud](https://gitlab.com/gitlab-org/gitlab/-/commit/f9b104eaf3d34b38bc928a28bd898ba074e355e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174367))
- [Remove role question from new group creation](https://gitlab.com/gitlab-org/gitlab/-/commit/cdf4a996b7c146c8cee55f9b0dd85ce2a53d1878) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174613))
- [Empty project page follow up](https://gitlab.com/gitlab-org/gitlab/-/commit/080b81e1147f072f41ecb695ef44062358aed045) by @mh4ckt3mh4ckt1c4s ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172725))
- [Remove search_auth_filter_for_work_items feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d8ebbb98d6f4de84cc262e8139d241d9a7d000e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175026)) **GitLab Enterprise Edition**
- [Delete remote_development_agent_configs table](https://gitlab.com/gitlab-org/gitlab/-/commit/992ead387f24aa39e4eeb4c9321c7c2a413e602b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164032))
- [Update dependency auto-deploy-image to v2.114.0](https://gitlab.com/gitlab-org/gitlab/-/commit/fe9e8bbf79d43d762a0b935dea709d38c45864b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175112))
- [Fix CI_PAGES_DOMAIN and CI_PAGES_URL for parallel deployments](https://gitlab.com/gitlab-org/gitlab/-/commit/38023beca86b9ca56070481269eda43e7aeac29b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165922))
- [Add assignee_ids field to merge request index](https://gitlab.com/gitlab-org/gitlab/-/commit/62a508e415a418af4458aebf2f590133287a47f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174673)) **GitLab Enterprise Edition**
- [Update compliance center framework drawer UX](https://gitlab.com/gitlab-org/gitlab/-/commit/482466ab21d3f941ff5fcf9d8555e97055d075d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174623)) **GitLab Enterprise Edition**
- [Remove temporary_ignore_tables_in_transaction issue already solved](https://gitlab.com/gitlab-org/gitlab/-/commit/31233b2a586f6bb63014899a0fa7bc3a75a757b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174386)) **GitLab Enterprise Edition**
- [Remove temporary_ignore_tables_in_transaction issue already solved](https://gitlab.com/gitlab-org/gitlab/-/commit/50f9deb9bc20955c27eb09183c8b0baf18b81689) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174383)) **GitLab Enterprise Edition**
- [Add correlation_id to mergeability check error](https://gitlab.com/gitlab-org/gitlab/-/commit/b9950de6bca9065acae7f7aa39943fd2ca2d7ef7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175030))
- [Remove multi column null constraint](https://gitlab.com/gitlab-org/gitlab/-/commit/a9dd13d420751fbf287205f3edcde25b5fec3f1c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174754)) **GitLab Enterprise Edition**
- [Remove search_query_authorization_refactor feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/eaf8adc0a4522c5910ca187670ded00f0033c8c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170602)) **GitLab Enterprise Edition**
- [Do not show username for vulnerability details system notes](https://gitlab.com/gitlab-org/gitlab/-/commit/4f6a9fcf0bab3a6d2b962a500f952e9139c79161) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174831)) **GitLab Enterprise Edition**
- [Admin Token API: Identify Pipeline trigger tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/586772c3ef4f29e6890607fd5d0b58d2c2bd2897) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174030))
- [Tag the ID/path in Projects::DestroyService logs](https://gitlab.com/gitlab-org/gitlab/-/commit/827d115c38b6fbf7d11fec0c5d83a027310e0e5d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174847))
- [Model creation screens "cancel" buttons to move back](https://gitlab.com/gitlab-org/gitlab/-/commit/3f9e8694471e657bd0893c6b63d98c80b3e9617d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174800))
- [Improve underscore error and Geo doc](https://gitlab.com/gitlab-org/gitlab/-/commit/439b6ac9da5bce53c4e1dbf558790464acd8fad2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174774)) **GitLab Enterprise Edition**
- [Add collapsible commit component for blob page on narrow viewports](https://gitlab.com/gitlab-org/gitlab/-/commit/4667a9daf9edda918c6666837d5278f023b4e500) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172637))
- [Make CI job token JWT available for composite identity users](https://gitlab.com/gitlab-org/gitlab/-/commit/c892eac8c863c7acfbe50ddbaef3fa8010bd3133) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174886))
- [Model version creation screen "cancel" button to move back](https://gitlab.com/gitlab-org/gitlab/-/commit/fa56279d4e784d9f1007ef4c92515dbd73bff4e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174801))
- [Set default for desired_config_generator_version fiedl](https://gitlab.com/gitlab-org/gitlab/-/commit/9716a4780f4626ea1bfcca72a64d92f5815e6689) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172593)) **GitLab Enterprise Edition**
- [Store vulnerability user mentions after commit](https://gitlab.com/gitlab-org/gitlab/-/commit/c0b7b7998c6465b76f7b911bd3a3803e3efc4a43) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174676)) **GitLab Enterprise Edition**
- [Use "Advanced SAST" name for SAST_ADVANCED report](https://gitlab.com/gitlab-org/gitlab/-/commit/64d37e0c9eeb412ad585f5db5f7d7573133c3451) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174599)) **GitLab Enterprise Edition**
- [Handle bespoke integrations observe allowlist](https://gitlab.com/gitlab-org/gitlab/-/commit/19a16a59b34b51c5eaf33ab30eaacee2d952e9f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172952)) **GitLab Enterprise Edition**
- [Update new pipeline button](https://gitlab.com/gitlab-org/gitlab/-/commit/a2ea86c18857f364c9544b98764d93e985e9d53e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174501))
- [Add toast when work item confidentiality is toggled](https://gitlab.com/gitlab-org/gitlab/-/commit/1818249b59ccf889339252f89ad829893da866b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174771))
- [Extend policy editor sidebar width](https://gitlab.com/gitlab-org/gitlab/-/commit/e10db0564d37e08545478f6354c011e01fb13dbb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174204)) **GitLab Enterprise Edition**
- [Changed shared component to be more universal](https://gitlab.com/gitlab-org/gitlab/-/commit/54c4bf302e63c2029c9c4e1cf89e211fabcef56f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173540))
- [Format numbers in statistics_card.vue](https://gitlab.com/gitlab-org/gitlab/-/commit/fc7138719ac2589cb0957ccb7eb8ba4fcc5304a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173964)) **GitLab Enterprise Edition**
- [Remove prompt_migration_categorize_question flag](https://gitlab.com/gitlab-org/gitlab/-/commit/59562fba5b2156ebaf0e48d1f05183e0d34c5301) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174493)) **GitLab Enterprise Edition**
- [Makes verify_self_hosted_setup accepts username](https://gitlab.com/gitlab-org/gitlab/-/commit/e2ecaf54b694e491e4c94cd9dbc5655483364acb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174199))
- [Change approval selector disabled state](https://gitlab.com/gitlab-org/gitlab/-/commit/619ed1f43c1943e6a096a2cad0b87ba18f2ad28d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174294)) **GitLab Enterprise Edition**
- [Update self-hosted models table column name](https://gitlab.com/gitlab-org/gitlab/-/commit/ab58260a1f6458ad4ae5fecaa2fe6bd2e00d4061) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174487))
- [Use link variant for merge trains button on MR list](https://gitlab.com/gitlab-org/gitlab/-/commit/2b202382b259a611eedad949686003303960efaa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174585))
- [Add allow deny list modal](https://gitlab.com/gitlab-org/gitlab/-/commit/eb049432d618397465d080636c4b4a8a1f45728c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171868)) **GitLab Enterprise Edition**
- [Don't fetch projects in subgroups for DORA projects comparison chart](https://gitlab.com/gitlab-org/gitlab/-/commit/fbf9ed62d014563569be4dabaf8451eee20ffcd9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174567)) **GitLab Enterprise Edition**
- [Adding a limit to the number of auto-resolved vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/45f3e2dbdcd78ed1bae149d5808f8a8ab4313227) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174454)) **GitLab Enterprise Edition**
- [Code flow: Make file title into a link to the file](https://gitlab.com/gitlab-org/gitlab/-/commit/70b5b919afe2bee80dd8364dccff0586d95e170a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173919)) **GitLab Enterprise Edition**
- [Additional webhook types for Datadog integration](https://gitlab.com/gitlab-org/gitlab/-/commit/16d1c6db83e4d3c72f94160a96cb9bec7656a002) by @rpelliard ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172565))
- [Activity contribution calendar: Migitate grid illusion](https://gitlab.com/gitlab-org/gitlab/-/commit/cc4402d8920e946076aa0d5838610448afbc5b54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174530))
- [Expose invite_accepted_at field to display member access granted date](https://gitlab.com/gitlab-org/gitlab/-/commit/7cf96321da22aaceda5d06918a40855e82aea3b1) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174259))
- [ML Model registry: Update create/edit forms](https://gitlab.com/gitlab-org/gitlab/-/commit/48183acc68e5568e45adf33fb48d95e19bb95250) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173409))
- [Refactor container registry list_spec.js](https://gitlab.com/gitlab-org/gitlab/-/commit/d25d7f18cd3ac6371ca4ed7a5a6caf8024f6ddf6) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174302))
- [Customize edit button in code flow file header](https://gitlab.com/gitlab-org/gitlab/-/commit/ae2c1782e535fe51a80197358b95587bd5eb2899) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173342)) **GitLab Enterprise Edition**
- [Update audit event streaming destination name validations](https://gitlab.com/gitlab-org/gitlab/-/commit/58f8125ef4a5f548e18a843d01028e9cd31ac819) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172275)) **GitLab Enterprise Edition**
- [Add copy branch button on branch creation alert](https://gitlab.com/gitlab-org/gitlab/-/commit/6aa04c005029c0f5f8b2502173e148f4f9c9cb38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174446))
- [Add usage of CustomersDot error messages to view helpers](https://gitlab.com/gitlab-org/gitlab/-/commit/b92e0919c41b9df356a6e8317885b12e22a0d538) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174160)) **GitLab Enterprise Edition**
- [Highlight changed fields in framework update audit log](https://gitlab.com/gitlab-org/gitlab/-/commit/d9c21207961682f1d4314e8eb30a337ec2c4c84b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174437)) **GitLab Enterprise Edition**
- [Pluralize job_token_policy route_setting](https://gitlab.com/gitlab-org/gitlab/-/commit/0d41ece998de8e89f98ee74f8816227a20bea50f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174227))
- [Admin Token API: Identify Impersonation Tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/55b29e52eea1128330fc0bb67f35c5626205fd6a) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173975))
- [Remove redundant self-hosted models HAML views](https://gitlab.com/gitlab-org/gitlab/-/commit/a4b4e6d9fa0dc8b0bdec9dc45faffe2052f06a19) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174216)) **GitLab Enterprise Edition**
- [Model registry: List all Experiments](https://gitlab.com/gitlab-org/gitlab/-/commit/427f0fd2a6e5ce9b670e9abf23be86343b701d2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174155))
- [Improve mobile layout of (Vue) Todos page](https://gitlab.com/gitlab-org/gitlab/-/commit/07fb7f2e9df65dce9ffd7da8e7264a5329246ff0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173460))
- [Changed text on the breadcrumbs for creating new entities in projects:](https://gitlab.com/gitlab-org/gitlab/-/commit/7cb21f52852ed4a7e90ae16671f96c9e2826fab2) by @illia_bakunovskyi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174314))
- [Replace unique index on scan_result_policies with action_idx](https://gitlab.com/gitlab-org/gitlab/-/commit/4af626bc09a0fe2c184bd3f76f920c9026b368d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174279)) **GitLab Enterprise Edition**
- [Use correct entity value in runner audit log events](https://gitlab.com/gitlab-org/gitlab/-/commit/7222d8a7b2726229429da2ff61c5bbfe77fd661b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173965)) **GitLab Enterprise Edition**
- [Remove `epic` and `reaction` from GLQL docs](https://gitlab.com/gitlab-org/gitlab/-/commit/3d0f792cd25f7ec65844a9d400b22c1231cdfa44) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174131))
- [Add gitlab standard layout to admin emails](https://gitlab.com/gitlab-org/gitlab/-/commit/573ca5a4b4d42c25af03c4da3e0b16f414fc4880) by @jimender2 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169848))
- [Model registry: Bump patch by default instead of major](https://gitlab.com/gitlab-org/gitlab/-/commit/0480c463af81cadd28d6fb8da40faad017a5ec72) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174156))
- [Move history button into commit box on repository and blob pages](https://gitlab.com/gitlab-org/gitlab/-/commit/fcf79cc88ad9b185ea7ca85f0b1556e690701d4d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172634))
- [Updates add seats button on duo seat utilization](https://gitlab.com/gitlab-org/gitlab/-/commit/15582223f6dca1132ed3cdc6aeeb90d18302ac50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174049)) **GitLab Enterprise Edition**
- [Resolve cross-transaction when moving issues](https://gitlab.com/gitlab-org/gitlab/-/commit/6b8a7bba5d7ef8c2df5d9caff083e72dbf09e6ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173979)) **GitLab Enterprise Edition**
- [Update sast and dast adherence wording](https://gitlab.com/gitlab-org/gitlab/-/commit/fd9f4798ec1ae023fb25cdb5ff118700f99da456) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174057)) **GitLab Enterprise Edition**
- [Regularly update zoekt indices with mismatched watermark levels](https://gitlab.com/gitlab-org/gitlab/-/commit/8ecdc427e6c29cbd9406596d975d1719a8846400) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173560)) **GitLab Enterprise Edition**
- [Package registry: Pretty wrap long names](https://gitlab.com/gitlab-org/gitlab/-/commit/1873671fc07d186831caadbf967470a6cb4b6755) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173287))
- [Display role labels instead of counters](https://gitlab.com/gitlab-org/gitlab/-/commit/d85b02817cf4efa02b1d0dade997b3d6a784e6f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174183))
- [Pipeline mini graph polling update](https://gitlab.com/gitlab-org/gitlab/-/commit/278f062537be15887770cdec946cf2e544df6fc8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173043))
- [Used seat_control_user_cap? to check user_cap enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/28a89edd647623e4733a03d85c10c46c1c85bff5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173425)) **GitLab Enterprise Edition**
- [Remove allow_cross_joins_across_databases](https://gitlab.com/gitlab-org/gitlab/-/commit/9a6f19ad7a0dd27789e3894b4a1c5a7a4c373278) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174119)) **GitLab Enterprise Edition**
- [Rephrase API forbidden error message](https://gitlab.com/gitlab-org/gitlab/-/commit/105906436efcf5481217db91082a6314a88c86e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174140))
- [Not use translated strings for deployment target on project creation](https://gitlab.com/gitlab-org/gitlab/-/commit/3d2c05f864b2c6bf7619dcc45a78a505c9aa0d49) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173849))
- [Update group for export_csv_preload_in_batches](https://gitlab.com/gitlab-org/gitlab/-/commit/44facbcf006e26096ad14bba9c42fdf106fd8407) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173958))
- [Remove btn-color SCSS mixin and usage](https://gitlab.com/gitlab-org/gitlab/-/commit/eb01b2b2b636502e8a873480653d467880c6c92c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174099))
- [Split Microsoft applications table](https://gitlab.com/gitlab-org/gitlab/-/commit/972b6e1479af92ad30c7d311028150061c081d10) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172497))
- [Expose exitCode on jobs in GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/11906aac366e5d9a2d538137f6c517c82bcf3125) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173295))
- [Remove feature flag glql_rust](https://gitlab.com/gitlab-org/gitlab/-/commit/461dac62af70d89dd48b0704f3c2ae5f2878d138) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174062))
- [Use correct entity value in runner audit log events](https://gitlab.com/gitlab-org/gitlab/-/commit/399a292bda313a501ece6811af70df2fd958aeef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173639)) **GitLab Enterprise Edition**
- [Show rule button tooltip for merge request approval policy](https://gitlab.com/gitlab-org/gitlab/-/commit/99d1de2b17e760b368004fd0a5d05da21bfd2743) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174036)) **GitLab Enterprise Edition**
- [Adjust the style of admin breakdown cards](https://gitlab.com/gitlab-org/gitlab/-/commit/a5dbc22dd10fbd07326d11ca6dc3e5da47e6b329) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172829))
- [Convert token_expiry_notify_inherited to cascading setting](https://gitlab.com/gitlab-org/gitlab/-/commit/d8df0bab125c380321602288e4af013814b283ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172494))
- [Create Dangerfile for internal user changes](https://gitlab.com/gitlab-org/gitlab/-/commit/33c608c9f6802864fbe37f1cf7eef222c00a6fba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171439))
- [Include last contacted time on audit log when runner is deleted](https://gitlab.com/gitlab-org/gitlab/-/commit/1112dd670ae6e594aa88fa1ef2774e23ec96a519) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173916)) **GitLab Enterprise Edition**
- [Add policy action index to approval rules and scan_result_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/abb912c6b3b14564b5ab7cbe9e7277406c5c5f2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173534)) **GitLab Enterprise Edition**
- [Write organization_id on OAuth tables](https://gitlab.com/gitlab-org/gitlab/-/commit/94c6f94b321160a2711e5da14947c3c5ea3f4566) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171628))
- [Admin Token Api: Identify Runner Authentication Tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/a975d6eff6accec051ec009e406302d9c453e116) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173987))
- [Enable not-null constraint on namespaces.organization_id column](https://gitlab.com/gitlab-org/gitlab/-/commit/af30ad7726fc1c87a1cfd303ceabcfaaff8a0ad7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173977))
- [Remove multiple versions setting from project settings](https://gitlab.com/gitlab-org/gitlab/-/commit/3c21025f99203700c5c323ee2c5849bb9a6e004d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173702)) **GitLab Enterprise Edition**
- [Generate audit event per project association from runner](https://gitlab.com/gitlab-org/gitlab/-/commit/384536712d1c64903a5584abed2bab0ebf8632b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173789)) **GitLab Enterprise Edition**
- [Remove allow_cross_joins_across_databases](https://gitlab.com/gitlab-org/gitlab/-/commit/df70e3477e1214a14e64c124ef40c02ff447b2b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173956)) **GitLab Enterprise Edition**
- [Adds page description to Usage Quotas Pipelines tab](https://gitlab.com/gitlab-org/gitlab/-/commit/8152321ccbe7fde8e788bbbc68c2dd42ba3f8695) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173954)) **GitLab Enterprise Edition**
- [Stop creating keep-arounds for sent notifications](https://gitlab.com/gitlab-org/gitlab/-/commit/1fc2f57ca78e5adad97547a6841515f7baf4a651) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173932))
- [Stop creating keep-arounds for Todos](https://gitlab.com/gitlab-org/gitlab/-/commit/114d786fbf51697bbc1c9248deb72105957144e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173932))
- [Model card tabs rendering without versions](https://gitlab.com/gitlab-org/gitlab/-/commit/36c5dd7403aca488f094d1a71574a5dd52e66d6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173392))
- [Move groups_controller from subscriptions](https://gitlab.com/gitlab-org/gitlab/-/commit/2ef3db7c6caec9e4ab166825bd010fcbe4facc1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171976)) **GitLab Enterprise Edition**
- [Move history button into commit box on repository and blob pages](https://gitlab.com/gitlab-org/gitlab/-/commit/566b4c0646cb292eee9f260ef23a6475c5a30685) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173484))
- [Remove the ci_skip_persistent_ref_existence_check feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/9d497a2c9e4172bf1b4e4d145412f602c43c8583) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173905))
- [Sort compliance framework project settings by created_at](https://gitlab.com/gitlab-org/gitlab/-/commit/ebe29afd49b0d35b90bc4a238ec43b1fb99f45dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172440)) **GitLab Enterprise Edition**
- [Set namespaces.organization_id to NOT NULL](https://gitlab.com/gitlab-org/gitlab/-/commit/ee3e4462ad51054010fe6ced67981edbdac4044e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171397))
- [Prevents db.rake to alter cell sequences range](https://gitlab.com/gitlab-org/gitlab/-/commit/33a4f2cf1a96f368105572fbd43f36dd0c2f5f78) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173875))
- [Update VR MR disclaimer text to `Fix' from `Patch`](https://gitlab.com/gitlab-org/gitlab/-/commit/682ca3287f0f97659ffd99db77a19db06e136783) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173865)) **GitLab Enterprise Edition**
- [Add ci minutes usage details to the warning banner](https://gitlab.com/gitlab-org/gitlab/-/commit/fe520ba89f2d39e8298654f8069df53ee08b5586) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173128)) **GitLab Enterprise Edition**
- [Diff viewed files: Make visual difference more evident](https://gitlab.com/gitlab-org/gitlab/-/commit/5ca16c913fd43605b8a1cbe9f520655921341537) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173842))
- [Display bolder warning if email TLD is missing](https://gitlab.com/gitlab-org/gitlab/-/commit/2a9fb44eca2d3aa22e4366df121a698e862d136a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172716))
- [Support cost factor fields in runner creation GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/89780ff476b8e557aef376dfa117874a256feb45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173553)) **GitLab Enterprise Edition**
- [Remove bulk_push_concurrency_limit_resume_worker FF](https://gitlab.com/gitlab-org/gitlab/-/commit/e69a71ac9fe80fee0e54ddbf4f68e471f3b1a2e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173820))
- [Update security policy yaml when filter is updated](https://gitlab.com/gitlab-org/gitlab/-/commit/71e06b02f69d5790ccd7653f2fae954300c611f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171558)) **GitLab Enterprise Edition**
- [It does not alter cell sequences for legacy cell](https://gitlab.com/gitlab-org/gitlab/-/commit/fd0cab58a8192a0dec2702cfd75b21d983005caa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172542))
- [Backfill spdx column in software_license_policies table](https://gitlab.com/gitlab-org/gitlab/-/commit/8d655fd69cc288af66a2e753515f8308c4d59104) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171688)) **GitLab Enterprise Edition**
- [Remove purchase seats button for duo enterprise trial](https://gitlab.com/gitlab-org/gitlab/-/commit/896647e869cc51357faa71409ff5b20ef39ceaef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173587)) **GitLab Enterprise Edition**
- [Add Ability to reference maintainers or developers from codeowners](https://gitlab.com/gitlab-org/gitlab/-/commit/19cdbde55524426c5e25ab69974318b09ac8602d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165537)) **GitLab Enterprise Edition**
- [Route minimal access user to groups dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/35cb0cc0e48dc97391dc7e32db4211c9ba52c835) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172226)) **GitLab Enterprise Edition**
- [Style improvements in the 2FA page](https://gitlab.com/gitlab-org/gitlab/-/commit/3238073b97643dd536e38734f7ba333343b19922) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173157))
- [Only remove SeatAssignment if no other membership](https://gitlab.com/gitlab-org/gitlab/-/commit/c4a4fc0859c651747ef7799ba7e354367f4bd286) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173699)) **GitLab Enterprise Edition**
- [Requeue backfill security policies background migration](https://gitlab.com/gitlab-org/gitlab/-/commit/114ee377ad52f36683f32a8c7bc19f3577edfbda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172988)) **GitLab Enterprise Edition**
- [Make dismissal comment required in finding modal](https://gitlab.com/gitlab-org/gitlab/-/commit/180ce0570a5c2e1470126c3cbc2da6c11fe842eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173290)) **GitLab Enterprise Edition**
- [Update Doorkeeper to version 5.8.0](https://gitlab.com/gitlab-org/gitlab/-/commit/20717c4f2a2524ffba5e08737a7c90554f52d11b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173481))
- [Add infinite scroll to exceptions dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/ccab1cc498880fc5599e9531298a5793f4edc882) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173408)) **GitLab Enterprise Edition**
- [Remove file path tooltips from repo page](https://gitlab.com/gitlab-org/gitlab/-/commit/af3ff1acbb71327a86e5d364a8ae92c368b7c5a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173605))
- [Fix failed jobs widget size](https://gitlab.com/gitlab-org/gitlab/-/commit/31104b38d0cde49c7c6e336dcea4a70cd56789ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173585))
- [Send stop indexing signal to zoekt nodes on critical watermark](https://gitlab.com/gitlab-org/gitlab/-/commit/bc1f50866eb9db0bfccc3b6faac15ffd21cbd110) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173167)) **GitLab Enterprise Edition**
- [Replace database token with JWT for CI Job Tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/ebee0e0877b3a7e32e638dc4b792821ae25cca84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167938))
- [Ignore failed zoekt repositories when checking non_ready instances](https://gitlab.com/gitlab-org/gitlab/-/commit/e92981f38b5bb93d7766621d14af62adc6e1d272) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173577)) **GitLab Enterprise Edition**
- [Reduce size and padding of collapse replies button](https://gitlab.com/gitlab-org/gitlab/-/commit/3015356cde3723c07a9ca71cc347c3e0fc7ccd40) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173575))
- [Mark all ready zoekt indices as pending](https://gitlab.com/gitlab-org/gitlab/-/commit/515bccc6fdf7561c38326e8c34b3c1d148db9a91) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172780)) **GitLab Enterprise Edition**
- [Ensure grouped iteration cadences are sorted alphabetically](https://gitlab.com/gitlab-org/gitlab/-/commit/ac58b71772e7bdccfc0aebf7ed8d1192c19c8c83) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173198)) **GitLab Enterprise Edition**
- [Support submitting create work item form with keyboard](https://gitlab.com/gitlab-org/gitlab/-/commit/22d8cf52158c02e885df882c7da10f24c4d2b958) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172891))
- [Removes unnecessary top margin on Members page](https://gitlab.com/gitlab-org/gitlab/-/commit/3357102a85aba73ee9613f10efb10daa9dec7edd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173539))
- [Disable OfflineCloudLicenseProvisionWorker for SaaS](https://gitlab.com/gitlab-org/gitlab/-/commit/86dc3a2f36c36d4c41a99c5c6f8ed574ebe462e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172094))
- [Remove embedding_cron_worker_re_enqueue feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/234c1c826b4e9bb90f36c2ada5789ff7b403b00f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173527)) **GitLab Enterprise Edition**
- [Log requested scopes when auth is denied](https://gitlab.com/gitlab-org/gitlab/-/commit/7bd760eed0e0a61f15208b041b79003228f6326d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173501))
- [Update dependency auto-deploy-image to v2.113.0](https://gitlab.com/gitlab-org/gitlab/-/commit/038dea018da239bc8607dffa542624f47a409644) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173500))
- [Update seat_control based on new_user_signups_cap](https://gitlab.com/gitlab-org/gitlab/-/commit/9169d36fd8684e08a3b0e35be1028ecadc533697) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172384))
- [Add feature flag for multiple approver action](https://gitlab.com/gitlab-org/gitlab/-/commit/7128174b37c2b5df67268caf50f4d19039a970c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173257)) **GitLab Enterprise Edition**
- [User profile contribution activity calendar darkmode update](https://gitlab.com/gitlab-org/gitlab/-/commit/80be3958748fcec6c59f237b1a67ee1edd138c26) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172839))
- [Use `WARN` log level when vulnerable code is too long for an LLM](https://gitlab.com/gitlab-org/gitlab/-/commit/965fc7fb7f71027aa08e69e3153740a71e82d2a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172227)) **GitLab Enterprise Edition**
- [Code flow: Truncate steps file path and file name](https://gitlab.com/gitlab-org/gitlab/-/commit/802de8a2d2e452f5988704f01577f0589a79bd44) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172573)) **GitLab Enterprise Edition**
- [Add feature flag for validation service](https://gitlab.com/gitlab-org/gitlab/-/commit/c4215cee1c29b1bf14212920ef91b217c0952903) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173339)) **GitLab Enterprise Edition**
- [Replace api calls with graphql queries](https://gitlab.com/gitlab-org/gitlab/-/commit/ef0b5dd2b9ad5f237a03053f2a99d4a5e2d19c26) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172723)) **GitLab Enterprise Edition**
- [Resolve cross-join in vuln bulk dismiss service](https://gitlab.com/gitlab-org/gitlab/-/commit/91f88eed87eb1e007097f860bf70390367d59db1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173235)) **GitLab Enterprise Edition**
- [Log check result status in mergeability logger](https://gitlab.com/gitlab-org/gitlab/-/commit/a69e5cd18b456d6de556ddb625d7980105c7c38f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173419))
- [Adds traversal_ids to merge request index](https://gitlab.com/gitlab-org/gitlab/-/commit/0769ea0333f4d0e8af9f556837f3bda42149d8ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171936)) **GitLab Enterprise Edition**
- [Add animation to a recation picker](https://gitlab.com/gitlab-org/gitlab/-/commit/78ad476a37a484d87d3ff5d8433fef704d6376a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173314))
- [Super sidebar: Refine Gray and Neutral themes in darkmode](https://gitlab.com/gitlab-org/gitlab/-/commit/8dfeda367388e47c5eb364c3effceb38d88e0e50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173014))
- [Change ProcessFileService to return error response when error](https://gitlab.com/gitlab-org/gitlab/-/commit/939129518faaa3e61cfae076831b89e96e086e20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173114))
- [Make Jenkins Banner dismissable](https://gitlab.com/gitlab-org/gitlab/-/commit/06473e41c377f93bc2d6ac6ca1e933dcc4b42fd8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172151))
- [Move `daysToSeconds` local function to the shared utils](https://gitlab.com/gitlab-org/gitlab/-/commit/ace47226a3ba9ca1460a0677017df30bbfd09f81) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172837)) **GitLab Enterprise Edition**
- [Sticky submit buttons in work item epic modal](https://gitlab.com/gitlab-org/gitlab/-/commit/f98982c38c1901b3b0696edf38b2aa1da374fe0c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168634))
- [Refine feature flags documentation](https://gitlab.com/gitlab-org/gitlab/-/commit/f0c34038ae766c25ca047ef64f33748e60c913b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173274))
- [Add indexes to improve syncing security policy to approval_rules](https://gitlab.com/gitlab-org/gitlab/-/commit/123209793a74fce1de46792996dca9e7c0880067) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172772))
- [Update documentation regarding custom stages and override_project_ci](https://gitlab.com/gitlab-org/gitlab/-/commit/d2dbff8bdecf2b86fe07f449ce9f9472964d7cfd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173276))
- [Clean up wiki clone steps](https://gitlab.com/gitlab-org/gitlab/-/commit/f8c2ce3c92ba50e76556fa05f24e7f81e19adbbf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173323))
- [Move types and enums  to registry namespace](https://gitlab.com/gitlab-org/gitlab/-/commit/a84bcef9da11098ed43f0ac3c21d6f8ec0cd0cc4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172756))
- [Update focused file styles](https://gitlab.com/gitlab-org/gitlab/-/commit/6d1c1584813551ada090945ea2b7f52378f07e5f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173163))
- [Backfill target_project_id for ComplianceViolation](https://gitlab.com/gitlab-org/gitlab/-/commit/45fdbe32451f63b6e205cb612e72815b569271c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172754))
- [Always show Flux resource selector on the environment settings page](https://gitlab.com/gitlab-org/gitlab/-/commit/cfce559569a5f89c3834e9209960b2cd31cfe3f7) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172830))
- [Update emojis from tanuki_emoji gem](https://gitlab.com/gitlab-org/gitlab/-/commit/63b52a26f138f3fb074e213c66b04755d846fc09) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166790))
- [Update zoekt watermark level whenever reservations change](https://gitlab.com/gitlab-org/gitlab/-/commit/bc22605d53862b301d3641cdd59e30bdeb00d9a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172790)) **GitLab Enterprise Edition**
- [Update dependency auto-deploy-image to v2.112.0](https://gitlab.com/gitlab-org/gitlab/-/commit/b6070ddc3e2c09fd1bc6aa3190912e5763ae05d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166275))
- [Re-redesignate merge_request_diff_commit_users as gitlab_main_cell](https://gitlab.com/gitlab-org/gitlab/-/commit/cea5b8d8f8ce62c4d473d39395d796ce8a7cf5fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173162))
- [Modify approval_rules when security policy is changed](https://gitlab.com/gitlab-org/gitlab/-/commit/613303c0ab9e022182cda17ed4eb08536abf757e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169700)) **GitLab Enterprise Edition**
- [Remove job polling](https://gitlab.com/gitlab-org/gitlab/-/commit/7c4164bc99b0019b8ca70dcf7a257737456b5a10) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173022))
- [Do not create DiffNote commented event in GithubImport](https://gitlab.com/gitlab-org/gitlab/-/commit/4851f355ee7cb681a3bf5a8adb5705871a84d464) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173169))
- [Reduce repository batch size for zoekt initial indexing](https://gitlab.com/gitlab-org/gitlab/-/commit/49a989eaeaf07cbb6b9f46a9f44626f57b0560ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172905)) **GitLab Enterprise Edition**
- [Update title copy for stop environment modal](https://gitlab.com/gitlab-org/gitlab/-/commit/d5e9ba43df4b4e064fca7d2a1613434d492a23e1) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173130))
- [Clarify origin of changes in merge conflicts](https://gitlab.com/gitlab-org/gitlab/-/commit/23a6165a2dbe76fc1e2980f9edc4cd164cf81c71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/149285))
- [Do not assign users to the default organization if it does not exist](https://gitlab.com/gitlab-org/gitlab/-/commit/9c054f05fcccec9a503d6a52ff430b8c422a24d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172814))
- [Two Factor Auth page: Migrate components](https://gitlab.com/gitlab-org/gitlab/-/commit/927d2bedde16fcb6761fcbf9992091c7d94f33ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171943))
- [Align note layout to legacy](https://gitlab.com/gitlab-org/gitlab/-/commit/bd60e3d8d5a41e834e3fab902b77c6367f07ff89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172470))
- [Remove cross-DB from related_vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/0df76a6bd4be1a0430da00f31230f301fd006787) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173025)) **GitLab Enterprise Edition**
- [Add top_level_only argument to a group resolver](https://gitlab.com/gitlab-org/gitlab/-/commit/86773261f9f9787cb2a1f271dfd5094bf6b5dfb2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172763))
- [Update sharding_key for ci_pipeline_chat_data](https://gitlab.com/gitlab-org/gitlab/-/commit/5880672bbee219110c1cbcdad2623da85a838077) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169068))
- [Update sharding key for p_ci_pipelines_config](https://gitlab.com/gitlab-org/gitlab/-/commit/db0fa62876145871ed30f4e60def4ed63e10c4c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169079))
- [Allow a non admin developers to download Terraform state via the UI](https://gitlab.com/gitlab-org/gitlab/-/commit/62b2b0ca600d557f4f3c6a75b6d1d103d35023c0) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172737))
- [Improve Stopping Environments Modal usability](https://gitlab.com/gitlab-org/gitlab/-/commit/1a9b2cb43c6102925220a8c95bda969f6e3e94d2) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172736))
- [Fix links to docs from misc ruby files](https://gitlab.com/gitlab-org/gitlab/-/commit/43df304f59adfc891902e38c3e1157d0706b287e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172789))
- [Drop broken FK for p_ci_builds.upstream_pipeline_id](https://gitlab.com/gitlab-org/gitlab/-/commit/4486dc9c4504cdf76b398822c107d25c2ebbb692) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172604))
- [Enhance consistency between dynamic and static 503 error pages](https://gitlab.com/gitlab-org/gitlab/-/commit/cefd1d784631de09fafa9c7484839d79e10b2946) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172506))
- [Skip create index tasks for indices that should be deleted](https://gitlab.com/gitlab-org/gitlab/-/commit/802644427c177c83df1bc1daa7eb7bc55332db0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172146)) **GitLab Enterprise Edition**
- [Remove dont_ignore_alternate_directories feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/c9281549e1b86607dc8cd7b72e166aebf68718dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172252))
- [Delete zoekt replicas during evictions](https://gitlab.com/gitlab-org/gitlab/-/commit/292eaeb90c33245eed09bf2fb1294b9c48ca6bc1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172153)) **GitLab Enterprise Edition**

### Deprecated (3 changes)

- [Initial checkin for GitLab Duo Usage Quotas alert](https://gitlab.com/gitlab-org/gitlab/-/commit/92077575688ca2a0e0640cbc8434cdba0b971a75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175616)) **GitLab Enterprise Edition**
- [Initial checkin for decomissioning general duo settings](https://gitlab.com/gitlab-org/gitlab/-/commit/a20af97b728d764e3babfda88bdf1af502708dbe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173613)) **GitLab Enterprise Edition**
- [Deprecate RunnersRegistrationTokenReset GraphQL mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/a57f2cdea0f2352b5828d9cafcae052d6cc31d26) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173450))

### Removed (21 changes)

- [Remove migrate_memberships column](https://gitlab.com/gitlab-org/gitlab/-/commit/c67db92365b9d589ea79adbd1e10735934f6346e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175006))
- [Remove feature flag pre_receive_secret_detection_push_check](https://gitlab.com/gitlab-org/gitlab/-/commit/2a494489a516aacbc4cbda1261c87f784360e141) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174948)) **GitLab Enterprise Edition**
- [Remove dead code associated with commit box pipeline status](https://gitlab.com/gitlab-org/gitlab/-/commit/beee8716aa8560216370809d1bb841e1cf21c1a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174931))
- [Remove the `enable_vsd_visual_editor` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b6a0568b46e21d97b9eef28c65f4f68b43852fc4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175450)) **GitLab Enterprise Edition**
- [Remove revisions columns from packages_conan_file_metadata table](https://gitlab.com/gitlab-org/gitlab/-/commit/0d8cc71ca041f8efc8794104c85f2bafebffab24) by @oceane_scania ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174960))
- [Remove feature flag - soft_limit_daily_phone_verifications](https://gitlab.com/gitlab-org/gitlab/-/commit/436520925962cd614d7793b0fe834f256b8b769d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174557))
- [Remove feature flag - credit_card_validation_daily_limit](https://gitlab.com/gitlab-org/gitlab/-/commit/c9a210aacbf185ebeac22f07952340dea2b2b871) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174716))
- [Remove feature flag - unverified-account-group-creation-limit](https://gitlab.com/gitlab-org/gitlab/-/commit/a412066c8275b7b96b488d40745d1fccb0853e22) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174697))
- [Remove bitbucket_server_user_mapping_by_username feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/ceb373625aed44c9a6a8b2d945139413972a3b8a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174110))
- [Remove feature flag cloud_connector_jwt_replace](https://gitlab.com/gitlab-org/gitlab/-/commit/91b900577413579a0f87acbcf9fecb3c994b6b3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174358)) **GitLab Enterprise Edition**
- [Remove feature flag: secret_detection_project_level_exclusions](https://gitlab.com/gitlab-org/gitlab/-/commit/a5eb2bda7fb8e965e655665d2ad6879fafff4a7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172794))
- [Revert "Relax criteria for proxying Git fetches"](https://gitlab.com/gitlab-org/gitlab/-/commit/d6d65ce9675fe2cb46368df15dc27f17af104804) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173926)) **GitLab Enterprise Edition**
- [Remove duplicated Duo Pro alert](https://gitlab.com/gitlab-org/gitlab/-/commit/d90d8f2fb211bc011904ac98296700780500ff44) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173160)) **GitLab Enterprise Edition**
- [Remove feature flag - require_identity_verification_for_old_users](https://gitlab.com/gitlab-org/gitlab/-/commit/ae87dd91263f209578e09e4c8aac9ba1e3c9f745) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172695))
- [Drop namespace_details pending_delete column](https://gitlab.com/gitlab-org/gitlab/-/commit/022e387ac6adba555e6050a919eec4ecb3535849) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173383))
- [Drop temporary_storage_increase_ends_on column](https://gitlab.com/gitlab-org/gitlab/-/commit/3bc5968bbd55076f35c0ebb9497f3aa1625a89ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173101))
- [Remove `vsa_standalone_settings_page` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3d1dcae5c2c96ab70964f5560eceaf9b4fdc5c04) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171856)) **GitLab Enterprise Edition**
- [Remove git_write_at column from onboarding_progresses](https://gitlab.com/gitlab-org/gitlab/-/commit/270c7bdc888fac27e09716a93d698ec89cf9d7b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173123)) **GitLab Enterprise Edition**
- [Drops file_checksum column from xray_reports table](https://gitlab.com/gitlab-org/gitlab/-/commit/b31ea2c6d385584ec1232e94e9330496a2106fe7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173116))
- [Remove last_activity_on from members table](https://gitlab.com/gitlab-org/gitlab/-/commit/7026824c582f746dda6cb327606e7e738e051d74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172350))
- [Cleanup references to epic_color_highlight feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f6fb45a4e1d48124d65a443b838a65dc405030ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171992)) **GitLab Enterprise Edition**

### Security (25 changes)

- [Update rails-html-sanitizer to 1.6.1](https://gitlab.com/gitlab-org/gitlab/-/commit/8348dea582fdcaed297c3fd773e1c313c459fe1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174860))
- [Revert "Merge branch '456922-confidential-issue' into 'master'"](https://gitlab.com/gitlab-org/gitlab/-/commit/e45d8f0cd351e0ce70880d281ff957925527767d)
- [Update file GITLAB_KAS_VERSION](https://gitlab.com/gitlab-org/gitlab/-/commit/7fcc3c48a14c1c1009e89065932af8a605368893)
- [Fix: unsubscribe from actioncable channel when PAT is revoked](https://gitlab.com/gitlab-org/gitlab/-/commit/52a0a4e49bc9655ee4c84ec89615bbab8fd56810)
- [HTML injection in vulnerability details, leads to XSS on self hosted servers](https://gitlab.com/gitlab-org/gitlab/-/commit/558af31a582d5f2136ad90ece53bb4c17d38918b)
- [Add timeout around Parslet in template parser](https://gitlab.com/gitlab-org/gitlab/-/commit/514bfb082fa1ec64a85921167b0d0cd038f096ea)
- [Add authorization check to protectableBranches field](https://gitlab.com/gitlab-org/gitlab/-/commit/9d856d297b1d7bc903988eb604077fe982056e31)
- [Ignore titles for GFM links in rich text editor](https://gitlab.com/gitlab-org/gitlab/-/commit/4fa9c1041a27ad7b795b0c1c551ebba6dead4542)
- [Add query to filter_parameters](https://gitlab.com/gitlab-org/gitlab/-/commit/99f19ca570e8cff641c0fcd3fd00c886e3b39d15)
- [Restrict user and group creation when same pages unique domain exist](https://gitlab.com/gitlab-org/gitlab/-/commit/fced55b8da2c99ff87eeb111a03ec9bd46a5964a)
- [Check harbor name & digest for path traversal](https://gitlab.com/gitlab-org/gitlab/-/commit/85dcd3a30d82b2551f4abbfc8ac3d612caff4252)
- [Added invalid redirect fragment check](https://gitlab.com/gitlab-org/gitlab/-/commit/0f9bdea0c2844cee90181c3ce4c2f54490cb9962)
- [Do not set session cookie for /v2 endpoints in the response](https://gitlab.com/gitlab-org/gitlab/-/commit/703bf4e4210bf18a02d58a9255d0abd758adf086)
- [DoS by repeatedly sending unauthenticated requests for diff-files of a commit or merge request](https://gitlab.com/gitlab-org/gitlab/-/commit/5581b0d0d1e95309d72ecca3b59650f28a29077c)
- [Make confidential threads unresolvable via new issue](https://gitlab.com/gitlab-org/gitlab/-/commit/fa33b0d8d6e80aed6f5c020b7240ddf59c7f94f0)
- [Reduce REGEXP_TIMEOUT_SECONDS to 45 seconds](https://gitlab.com/gitlab-org/gitlab/-/commit/86af7aa48d977c9f1d84c43197ca0273912880e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174854))
- [Update rails to version 7.0.8.6](https://gitlab.com/gitlab-org/gitlab/-/commit/ca1651d20a8e081ca4dce6f8e9356c5859b2b5b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174107))
- [Upgrade fugit to 1.11.1](https://gitlab.com/gitlab-org/gitlab/-/commit/898763f8ae3785bce797ec9f1af0852abf5bf69d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174037))
- [Add size check for harbor registry](https://gitlab.com/gitlab-org/gitlab/-/commit/30ae381d5f8a02d14f2be63ca5150de2852a206a)
- [Allow a LFS token to be used only for LFS related requests](https://gitlab.com/gitlab-org/gitlab/-/commit/d4d72811d27c8388bc8c7a276a1eb18535dec57f)
- [Adding JobArtifactReport class to pre-emptively validate job artifacts](https://gitlab.com/gitlab-org/gitlab/-/commit/88b5c418116227a84bec2ec0b9b797d449d83096)
- [Move allow_access_with_scope to class level](https://gitlab.com/gitlab-org/gitlab/-/commit/4ab578aa290b27427661908105019643a4eb0e9a)
- [Fix possible DOS with TOML file parsing](https://gitlab.com/gitlab-org/gitlab/-/commit/394176de261c7f5cc32cc5b6cb75871e65211e43)
- [Update cross-spawn to resolve CVE-2024-21538](https://gitlab.com/gitlab-org/gitlab/-/commit/12bb2a586f3ed990d7b026b14d3b25dde694867a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173661))
- [Update webrick to 1.8.2](https://gitlab.com/gitlab-org/gitlab/-/commit/fcbe6a7d54cf1d4537262f446c6307c924bc3907) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173439))

### Performance (9 changes)

- [Resolve N+1 queries in Groups::ChildrenController](https://gitlab.com/gitlab-org/gitlab/-/commit/5001959406c3b49e0de144f0d35047a9ff2adb6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175220))
- [Add responsive throttling for ph reassignment](https://gitlab.com/gitlab-org/gitlab/-/commit/21938997574721ec91ba67a6f8e3e9641b036701) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173292))
- [Improve performance of rendering fork button](https://gitlab.com/gitlab-org/gitlab/-/commit/9c36ab9e1cfce110ae18a578fae3d56bd4216b36) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175075))
- [Improve performance of feature checks with actor](https://gitlab.com/gitlab-org/gitlab/-/commit/02172915fd9c375eb68bb2b22e40a6bd45827e92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174947)) **GitLab Enterprise Edition**
- [Stop creating keep-arounds on merge-request notes](https://gitlab.com/gitlab-org/gitlab/-/commit/c9bc01f9967ab5633a8e03622cec1addc6f3aaca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174925))
- [Fetch sidebar counts async](https://gitlab.com/gitlab-org/gitlab/-/commit/0d6b2ad5c7d790cd97caebc6cc2414b8704ebbc3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173817))
- [Stop creating keep-arounds in cleanup ref service](https://gitlab.com/gitlab-org/gitlab/-/commit/2518396b63bb22be9b8071aa40926cf2eea196d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173938))
- [Remove billed_project_members_performance_improvement feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/c674351dbaaf95ea7b8843572014b59385236a87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173799)) **GitLab Enterprise Edition**
- [Optimize packages lookup in the deprecate npm packages service](https://gitlab.com/gitlab-org/gitlab/-/commit/d2d7dc9246c5ef21e712e53687cce2215e8728a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172430))

### Other (143 changes)

- [test: Refactor test utility configure_mock_auth](https://gitlab.com/gitlab-org/gitlab/-/commit/ac52a9139fd288818aaf2fd1fba02a79654f2025) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173300))
- [Add foreign key constraint to `namespaces.organization_id`](https://gitlab.com/gitlab-org/gitlab/-/commit/9204781b13addd8adb591e21ccbe91bb875a03d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166855))
- [Backfill onboarding_status_role from role column in users table](https://gitlab.com/gitlab-org/gitlab/-/commit/a5c8d2846909af672778755a1574afc25544ab66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175456))
- [Implement pipl alert](https://gitlab.com/gitlab-org/gitlab/-/commit/36d417a1d7a018e659e2355c44688fb47e866446) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175147)) **GitLab Enterprise Edition**
- [Cleanup globally enabled feature flag `incubation_5mp_google_cloud`](https://gitlab.com/gitlab-org/gitlab/-/commit/b31c799fece5894484c18d6ae6c60c62234fb1fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175471))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/3c1e0b37455d4b48599dd143c17000923556b4bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175781))
- [Remove ignore_policies_for_unprotected_branches feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/2d6b1eb5d05271ccdb3082c0c23f5a5436b39dc9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175508)) **GitLab Enterprise Edition**
- [Remove default on `project_saved_replies_flag` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b7ee6ab6fe7d60e42b7e6c765bc2d4b81d827630) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175646))
- [Fix rubocop bounded context for GitLab pages](https://gitlab.com/gitlab-org/gitlab/-/commit/bcdab3e87f73ae1a961717f06fdcd58b1da07b79) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170417))
- [Implement block pipl users](https://gitlab.com/gitlab-org/gitlab/-/commit/8c7210305dd17fefcd30b5ad21287a21b5bf43c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174387)) **GitLab Enterprise Edition**
- [Add telesign_intelligence application setting](https://gitlab.com/gitlab-org/gitlab/-/commit/eb3a6b8602970ce37cfc31f503985cffe4b1d3cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173821)) **GitLab Enterprise Edition**
- [Remove feature flag - hard_limit_daily_phone_verifications](https://gitlab.com/gitlab-org/gitlab/-/commit/13ed2c5b228f284be82fde42644cdaeb9b4d05bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174875)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/c513450482362387296bd68ec888ba74aeeacbd6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174940))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/cebfe2c214ce0ad2405c6a89a14ce1dab6565c42) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175659))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/4f0c88b8caf66531cd1c0ad1a3649704545d63d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175658))
- [Quarantine spec/features/cycl_analytics_spec.rb test](https://gitlab.com/gitlab-org/gitlab/-/commit/121e3ebba6ec74e0a56dc719f66c07b6b11c4bcd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175652))
- [Add new FK for builds execution configs](https://gitlab.com/gitlab-org/gitlab/-/commit/748fb7ff7cbdce07828e6779d1bbe5044dbce81a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175108))
- [Change data consistency for permissions workers](https://gitlab.com/gitlab-org/gitlab/-/commit/b84e2b690ad4492f2ac1ec99e598edeca0019c53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173210))
- [refactor: Use ServiceResponse for VerifyPagesDomainService](https://gitlab.com/gitlab-org/gitlab/-/commit/caec9034472e0dcb591d0198ebdd517654784cf5) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162199))
- [Enable ci_optimize_memory_for_variables and remove the FF](https://gitlab.com/gitlab-org/gitlab/-/commit/fe047b05c8e8647aabfa03fc69d0b5e493389043) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175522))
- [Allow premium namespaces who trialed as free to do it again](https://gitlab.com/gitlab-org/gitlab/-/commit/1e919f158126afc71d8c972758f7cd2e8916a4c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174779)) **GitLab Enterprise Edition**
- [Add a new scheduling task adjust_indices_reserved_storage_bytes](https://gitlab.com/gitlab-org/gitlab/-/commit/ee6e6a118b9f5eac8157d2c0fbca0128858383ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175296)) **GitLab Enterprise Edition**
- [Excludes existing bigint IDs from bigint conversion helpers](https://gitlab.com/gitlab-org/gitlab/-/commit/01f730f3a1c7686e613c47ddda32020cc4c4ff02) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170214))
- [Schedule async FK validation for p_ci_stages partitions](https://gitlab.com/gitlab-org/gitlab/-/commit/b4061e05e5cc1fac5997c80225c8af63fd900ce4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175373))
- [Remove the deprecated worker](https://gitlab.com/gitlab-org/gitlab/-/commit/09ebb43215acb2ada387b919589efa68b37889a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169247))
- [Add the FF zoekt_optimized_performance_indexing](https://gitlab.com/gitlab-org/gitlab/-/commit/e29292f52909e82db64a1f10c020a6bf723e8b53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175413)) **GitLab Enterprise Edition**
- [Remove software licenses sharding key issue url](https://gitlab.com/gitlab-org/gitlab/-/commit/f034b9d6201c2569227423a854c012e4546f6ed2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175398))
- [Ensures the ticket work item type has the same widgets as issues](https://gitlab.com/gitlab-org/gitlab/-/commit/588cd9e9b0fd539a4077bbe927245231be0136b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174135))
- [Update github service](https://gitlab.com/gitlab-org/gitlab/-/commit/8d7d4e913ab242342ae583c3459029c485145bc7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174185))
- [Remove company question from duo pro and ultimate trial forms](https://gitlab.com/gitlab-org/gitlab/-/commit/316c5fd9626b4c945ae9f6641f4a11ead0c6ed84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174448)) **GitLab Enterprise Edition**
- [Cleanup stop_bulk_sidekiq_job_activation feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/37f2e2fbb2ff67c1d35f7c13d3e8bfc93e5dfebe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175289)) **GitLab Enterprise Edition**
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/05e66b79b5bdab79486b7a59577398a8a0587c37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175103))
- [Requeue backfill milestone releases](https://gitlab.com/gitlab-org/gitlab/-/commit/2235ba43d9f3b17dc2027fccfae2395a12f12100) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170694))
- [Add RuboCop rule to enforce class-level allow_access_with_scope](https://gitlab.com/gitlab-org/gitlab/-/commit/66ac821cfc0ed1f81ffe074dab3d8380faa9971e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174343))
- [Remove references to Codestral model for SaaS](https://gitlab.com/gitlab-org/gitlab/-/commit/12b96d77f9c597fbdb5bfba86f52f1d650f57697) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174822))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/1a2f013d5840312c43719652c4cf69bb3cbb6672) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173809))
- [Add and backfill namespace_id for status_page_published_incidents](https://gitlab.com/gitlab-org/gitlab/-/commit/fb12090f1ad930ddb5942a1cddbf28a42bc5b4a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174868))
- [Finalize migration BackfillResourceLinkEvents](https://gitlab.com/gitlab-org/gitlab/-/commit/656d155da6a5730057e050f370c9735b9ee17395) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174621))
- [Add & backfill sharding keys for protected_branch_merge_access_levels](https://gitlab.com/gitlab-org/gitlab/-/commit/48520bd3e82ef405d4726ecf3326fa3ec1427b9e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174564))
- [Add new FK for build execution configs](https://gitlab.com/gitlab-org/gitlab/-/commit/e90f00aadbc9dcec5b36ad06a67d69adb2a08d70) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174671))
- [Add and backfill namespace_id for resource_weight_events](https://gitlab.com/gitlab-org/gitlab/-/commit/66988cd152b4e9c553256eb183fa9da44eccc042) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174405))
- [Remove sharding key issue from geo_events](https://gitlab.com/gitlab-org/gitlab/-/commit/3de0db0319ce075ba1a613a409692d7ed94b0ebf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174848))
- [Add NOT NULL constraint on project.organization_id column](https://gitlab.com/gitlab-org/gitlab/-/commit/86cc42748922ca6f51d58be72fe781db0a023abd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173090))
- [Remove run_keyword_instrumentation feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f42773d1566d4d1a8ab0d4cc3108f14b43fa6ac3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174810))
- [Clean up YAML definition file for prompt_migration_summarize_review ff](https://gitlab.com/gitlab-org/gitlab/-/commit/bf5862c557832e6a8b2cbf6088068b2082273f79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174738))
- [Add and backfill namespace_id for issue_emails](https://gitlab.com/gitlab-org/gitlab/-/commit/51653614973b2a7c16fd8db05f09c41921aa5ae0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174507))
- [Add and backfill namespace_id for issue_user_mentions](https://gitlab.com/gitlab-org/gitlab/-/commit/fbb1cfe86154b917fb29fcbe888560c87b1ac498) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174399))
- [Remove feature flags for pre-Chat GA](https://gitlab.com/gitlab-org/gitlab/-/commit/addb836ebf01f936358e95cac1c4c27f3f86f61a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173220)) **GitLab Enterprise Edition**
- [Add desired sharding key for BuildPendingStates](https://gitlab.com/gitlab-org/gitlab/-/commit/78464d164af1da107d9c12778b0ae2f4e513d71b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171427))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/6296ffc3cdefe482d50e192e12a82c24b240e3a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174633))
- [Add and backfill namespace_id for issue_metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/2b2308282a197ab0c27c77a754cba1c9d593f430) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174502))
- [Add and backfill namespace_id for sentry_issues](https://gitlab.com/gitlab-org/gitlab/-/commit/f96766e72f0b50c59347b19290078441e3c358fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174555))
- [Add and backfill namespace_id for issue_customer_relations_contacts](https://gitlab.com/gitlab-org/gitlab/-/commit/c535c0c7a6cc67adefc16605618542bfc63410a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174504))
- [Add and backfill namespace_id for issue_email_participants](https://gitlab.com/gitlab-org/gitlab/-/commit/123cce5cd0c2672a79ee1182a82a1363e909f935) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174506))
- [Add and backfill namespace_id for resource_link_events](https://gitlab.com/gitlab-org/gitlab/-/commit/7ce236db4929174cd3ec80100f311786012d9318) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174402))
- [Add and backfill namespace_id for issuable_metric_images](https://gitlab.com/gitlab-org/gitlab/-/commit/3b49abaeb46e251da77a1755b1e28d4fa3b61496) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174508))
- [Add and backfill namespace_id for issue_assignment_events](https://gitlab.com/gitlab-org/gitlab/-/commit/d946d269b2ac82873bd067cb6890cbceb5ac1f14) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174500))
- [Add missing rollout issues for feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/a99072b1a05a13853cabc1ae79fc06e1d150aabb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174539)) **GitLab Enterprise Edition**
- [New web_hooks.vulnerability_events migration](https://gitlab.com/gitlab-org/gitlab/-/commit/ef7ec3d69bd2728b13f5ec4b43821850013b7aa5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174335))
- [Store WAL locations in concurrency limiter](https://gitlab.com/gitlab-org/gitlab/-/commit/70ee8a86ef874f52e02da7838944d64a5caf1ae9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174355))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/47053fb99a3e598597d6ced12cdf109c47d229b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174485))
- [Add and backfill namespace_id for incident_management_issuable_escalatio](https://gitlab.com/gitlab-org/gitlab/-/commit/a36465b5a9b3a798233a3617800eb2c2bc46a0d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174415))
- [Add and backfill namespace_id for work_item_progresses](https://gitlab.com/gitlab-org/gitlab/-/commit/2ff3f149008e6f7dc7ce3cd2708782249498bede) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174410))
- [Add and backfill namespace_id for issuable_resource_links](https://gitlab.com/gitlab-org/gitlab/-/commit/0369e22e70222fde345d622e8cf42251f4c909d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174419))
- [Backfill missing user_detail records for specific user_types](https://gitlab.com/gitlab-org/gitlab/-/commit/db133ec643f5cd7717ccb5e63a906690a23c37cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174064))
- [Add Edit button to tree header](https://gitlab.com/gitlab-org/gitlab/-/commit/50ab2b4b3323fde9726a2741d8ad61f8ee73709a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171946)) **GitLab Enterprise Edition**
- [Add and backfill namespace_id for issuable_severities](https://gitlab.com/gitlab-org/gitlab/-/commit/895dd2b054db0ffeeba6f316e4c2d9a4f4f0ab60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173728))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/b4556e192ceb704d554300e557cc9dc771eb15b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174371))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/42c46c6a6cb8f8a1a5984ab3bd4a47a57e9e6a9e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174223))
- [Set missing/incorrect feature categories for tests](https://gitlab.com/gitlab-org/gitlab/-/commit/eebfbe6e50a24a0a80961b6945c94334aa6b069d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174257))
- [Sync approval policies after creating security_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/e64ee571683b41892eb3fdfe7bf30f392f85721c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174150)) **GitLab Enterprise Edition**
- [Set pipeline expiry time](https://gitlab.com/gitlab-org/gitlab/-/commit/27ad2f67670eb34dc1a18513dbe7c1d1770dee3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173982))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/98d6f6640a930ad84a992dfe130656796e8ca020) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173657))
- [Cleanup security_policies_sync feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/8d49404b90ef27521d584397b213d7bbb24be5c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174014)) **GitLab Enterprise Edition**
- [Add foreign key beween builds and pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/90920d6c3bf07f866569424177ab9f42524f1bfb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173678))
- [Change data consistency for workers maintained by code_testing](https://gitlab.com/gitlab-org/gitlab/-/commit/4d8f01294d15293a38c633c77d66236d432f09f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172692))
- [Async validate new ci_pipelines FKs](https://gitlab.com/gitlab-org/gitlab/-/commit/d0f412da9b120f0bfd9bd5b5447291a7b4ba32c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174126))
- [Remove broken FK between pipelines and build exec configs](https://gitlab.com/gitlab-org/gitlab/-/commit/35d7d2338e152364fe9bcb175e16994b20d59d7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174125))
- [Remove duo_chat_stream_help_answer feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/edcbb8ab34a61abbabbca5a5e419b797deda63aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174108)) **GitLab Enterprise Edition**
- [Finalize migration BackfillVulnerabilityFindingsRemediationsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/c5162bc5df20cfb52ffd7827d0479d433e5e57fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173667))
- [Remove feature flag: fail_stuck_mirrors](https://gitlab.com/gitlab-org/gitlab/-/commit/4ca9e94434d65f8768893e435e8104c984a9921c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174052))
- [Remove "remote_mirror_fail_on_lfs" feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/413451b3c1cb7efbe7a584ceacc04f64c416224d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174027))
- [Start implementing recurring PIPL email](https://gitlab.com/gitlab-org/gitlab/-/commit/b0df91750fc55888f63b2ad711167284b883832f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173231)) **GitLab Enterprise Edition**
- [Finalize DisableAllowRunnerRegistrationOnNamespaceSettingsForGitlabCom](https://gitlab.com/gitlab-org/gitlab/-/commit/b3c3c43213ae0e84758c2ab98785df828b0a3235) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171198))
- [Remove unused matched_lines_count](https://gitlab.com/gitlab-org/gitlab/-/commit/1ce4657cf56b1f2b87ecac5271bdf232c8a6fac1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173998))
- [Fix all RSpec/IsExpectedSpecify offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/d1b970274ec26d2a22e763bd6b17edaf10dff62d) by @richie_ctr360 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173878))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/35e0c94f9a97d38fa508cf665f68c460d16c3062) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173942))
- [Backfill subscription_seat_assignments table](https://gitlab.com/gitlab-org/gitlab/-/commit/58c4ec8a24119808649f406d414fd0ee38e74ed2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172095)) **GitLab Enterprise Edition**
- [Remove `ssh_certificates_rest_endpoints` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/41cf4bf5087470c9c519432fecd32f335c247860) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173529))
- [Cleanup use_latest_security_scans_for_security_policies flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3bbf15f37eda97b5fed1fac9204381af352f768f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173834)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/fc404e3515590b929a1cb2cf6683c29fcde075f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173808))
- [Add and backfill group_id for group_wiki_repository_states](https://gitlab.com/gitlab-org/gitlab/-/commit/f4a6b655b40e8018d32f1e084bd1df914cfa2359) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169242))
- [Fix Layout/LineLength offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/8f38f85ba61a84d21e2d32a7a207ac7d233d7120) by @ikelax ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170227))
- [Change data consistency for workers maintained by importers](https://gitlab.com/gitlab-org/gitlab/-/commit/d8473ee0462678e8f6941b1cdf30fb74812b1a02) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172689))
- [Change data consistency for workers maintained by pipeline_composition](https://gitlab.com/gitlab-org/gitlab/-/commit/dd1ecf85b558e68ffeeac5cf958a25fa64fdbad9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172691))
- [Fix the spacing between trials title and text](https://gitlab.com/gitlab-org/gitlab/-/commit/a73b788cb7555ce5e5dd085ef5e3dead198f2e73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173713)) **GitLab Enterprise Edition**
- [Model registry: Add metrics for projects and namespaces](https://gitlab.com/gitlab-org/gitlab/-/commit/7e1726d2de2f6bdf522432dd209637cba88e1dec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173261))
- [Create foreign key for build execution configs](https://gitlab.com/gitlab-org/gitlab/-/commit/9dcac800cddfa7447c038bb9d152df64d6a6c223) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172851))
- [Remove "cached_commits" feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/7bfa77c292a1b4fc2b25b45f3eb2e50b41615fcd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173709))
- [Remove the variable from manual_confirmation message](https://gitlab.com/gitlab-org/gitlab/-/commit/acf5a4531b895f79b08c69ec1134f234d959a4bf) by @francoisauclair911 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173456))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/2e875a0c586d677ecaf71ea01b5ef5eb01ba050c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173705))
- [Update chat-based integrations to use shared modules](https://gitlab.com/gitlab-org/gitlab/-/commit/a595c08a694ab5ae47d3abf7c955731e9ad82870) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172112)) **GitLab Enterprise Edition**
- [Remove 'explain_code_chat' feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/96b53c40c16cfcd2d0f8c229e93dc76d0a06676e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173693))
- [Remove `web_ui_commit_author_change` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/a587ee86858a7dd677d232149e2f098ba167d226) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173547))
- [Remove the FF ci_variables_optimize_kubernetes_variables](https://gitlab.com/gitlab-org/gitlab/-/commit/b66f30df0b7d8a7381d1643dd2d129d8d9a583cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173676))
- [Cleanup trial gitlab subscription date attributes](https://gitlab.com/gitlab-org/gitlab/-/commit/915e0eea163b4df2a3f90bf4e128572fb7d26d01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169196)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/1034e5db32e46bcb94d5c69f87c1906124e47a76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173627))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/f2c5715a00a6433e20d14a8efd2adb9549f74b99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173498))
- [Adding ci_pipelines to LFK config file](https://gitlab.com/gitlab-org/gitlab/-/commit/1433431ed0996fc17b8b87eaaedc2d98231c76c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173581))
- [Fix Style/IfUnlessModifier offences](https://gitlab.com/gitlab-org/gitlab/-/commit/ed196a994fffd9f6615bf8fb0d0157d972ee8770) by @divyamtayal ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170337))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/a37812d919e6baef2782b6164150185a8f2bf33d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172977))
- [Remove "handle_structured_gitaly_errors" feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/59a9de5c8be746396ac8d9accdeedff96a26628b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173543))
- [Mark 20240626145458 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/277e30a7a5f263dc4933b82e1749d910defe2e21) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172938)) **GitLab Enterprise Edition**
- [Remove zoekt_send_tasks feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/8ef0b870c27131d12f31573fbe9cf90ed947f9b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173520)) **GitLab Enterprise Edition**
- [Add UX improvement for in-app trials on button and titles](https://gitlab.com/gitlab-org/gitlab/-/commit/4cdfcf26515fe6165fee55008fa7d1cd37c48e22) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173002)) **GitLab Enterprise Edition**
- [Refactor RubyGems package enqueuing](https://gitlab.com/gitlab-org/gitlab/-/commit/5abe70818841aedcbfd637399c92ba172391c674) by @holtvogt ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170696))
- [Finalize migration BackfillProjectRelationExportsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/a1b7ccd5bdffd3595f3ea3778316abdcb95c3574) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172600))
- [Cleanup "enforce_ssh_certificates_via_settings" feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/5a324b16bdcc556f800f95afa8cb348703d7c1c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173302))
- [config: Disable GitLab container registry by default in gitlab test env](https://gitlab.com/gitlab-org/gitlab/-/commit/fb144675feb295b370bbe14b297d2d4a96801e01) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173299))
- [Bulk enqueue for ConcurrencyLimit::ResumeWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/b89dcd762daa16c51285b2015e343d5c9d60a45f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172553))
- [Add resource_usage_limits column to application_settings](https://gitlab.com/gitlab-org/gitlab/-/commit/6c0625d04554f9fd29cc03b7e5011c8cfb9a781b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171097))
- [Add async validation for p_ci_builds - p_ci_pipelines FK](https://gitlab.com/gitlab-org/gitlab/-/commit/5c53312fa80991a94c00001f4933be9eec01137f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173144))
- [Validate duplicate jobs cookie against schema](https://gitlab.com/gitlab-org/gitlab/-/commit/6237cc9a836f0fe8b47022a2c232319dda726915) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172124))
- [Finalize migration BackfillStatusCheckResponsesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/129aea956ca22e63dbdb919dea4f922ab34e5cf4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172913))
- [Remove CiEditor tool](https://gitlab.com/gitlab-org/gitlab/-/commit/874d81c9a698b7a87493adf185ea9142d277991b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172563)) **GitLab Enterprise Edition**
- [refactor: Use single quote in shared example](https://gitlab.com/gitlab-org/gitlab/-/commit/3aaf2ec3fa130f9e03b259ebc6435f157ce5e352) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172819))
- [Cleanup spamcheck_runway_migration feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d90a94a9c910d41b5fdf0df5f250b0901be0c782) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172605))
- [Remove ai_impact_only_on_duo_enterprise feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/fd6d2104346653b9568b52b9343085ab4835150b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173165)) **GitLab Enterprise Edition**
- [Bump ruby-lsp version](https://gitlab.com/gitlab-org/gitlab/-/commit/a7e3592b0fdab744c10bd359d458de21e4afdfba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173132))
- [Remove search_mr_filter_label_ids feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/c94b9711ea6dd19bb5071cb7780397a4d8f0691d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172520)) **GitLab Enterprise Edition**
- [Mark 20240517092224 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/9c48eb0038f0a3a0e11aca9740f4c1c1b6a2cffb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172937)) **GitLab Enterprise Edition**
- [Update step JSON schema](https://gitlab.com/gitlab-org/gitlab/-/commit/71f86db24344caf1159d44c2dbb44842a741e333) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168874))
- [Finalize CopyTaggingsToPCiBuildTags migration](https://gitlab.com/gitlab-org/gitlab/-/commit/0e574aaf3e79d36d56d4acfa5af81f56b85f1caf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172845))
- [Send invited_user_ids on MembersAdded event](https://gitlab.com/gitlab-org/gitlab/-/commit/233d840b3847d5d9ec3850d3937f5e6e677b29ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172365))
- [Finalize DeleteOrphanedBuildRecords migration](https://gitlab.com/gitlab-org/gitlab/-/commit/5264be80c199485fb53697caf501286a2e431e8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172836))
- [Concurrency limit: parallelize resume worker](https://gitlab.com/gitlab-org/gitlab/-/commit/c96c80a5034f246cacd63d98d9b91e0d6b820b8d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172122)) **GitLab Enterprise Edition**
- [Finalize migration BackfillUserAchievementsNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/ebdd4f074f7cc3edaeeafab8d0779dc5fffd2c54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172915))
- [Finalize migration BackfillTerraformStateVersionsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/54eb037de5e26b78bcdfae9683f079a5fb5e2c74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172914))
- [Model registry: Add additional tests](https://gitlab.com/gitlab-org/gitlab/-/commit/3f6a9dbd64ca6ceba54f66480fa2566947f9259d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172972))
- [Fix Layout/LineLength offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/620a9060af26b2d18b46d29d4d7674a71db107d5) by @ikelax ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170316))
- [Protected packages: Use CheckRuleExistenceService in npm push protection](https://gitlab.com/gitlab-org/gitlab/-/commit/a57fa587649d1280132d041b802b93ae172c403d) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166925))
- [Finalize migration BackfillMlExperimentMetadataProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/0768d34e5d66ec56aa9104206120d2b691d3781f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172003))
- [Finalize migration BackfillDastSiteValidationsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/edb777429d66afe879a5bb8d4652a610eb39eb7c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171199))

## 17.6.5 (2025-02-11)

### Security (7 changes)

- [Security Duo Chat Escape Unknown Domain Hyperlinks](https://gitlab.com/gitlab-org/security/gitlab/-/commit/cdb737c04cdf611b2f6818a294b7157039adcce8) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4692))
- [Hide sensitive workhorse headers and fix route confusion between web and workhorse routes](https://gitlab.com/gitlab-org/security/gitlab/-/commit/dd5fb5b4e217868aa8602acee276883ae8e42126) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4763))
- [Reduce memory allocations on create PAT endpoint](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d86c90fdfee1aef2eaa958ddc9e0ba379f8e221e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4752))
- [Prevent SSRF attacks for Workspaces](https://gitlab.com/gitlab-org/security/gitlab/-/commit/16659a9efb33ec22055b927fd716f5acc80361e9) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4731))
- [Prevent read code access when repository is disabled](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ff08db2dd2efa55e4e868591c61c144ec3febe32) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4701))
- [Fixes XSS on the target branch in the merge request widget](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1cc0ad7a4f3f0ab44dd959a58b3ed63786037a06) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4737))
- [Unsubscribe from actioncable channel when PAT is revoked](https://gitlab.com/gitlab-org/security/gitlab/-/commit/26fff506ff66eedea4dc911eb1c9f4686d643650) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4727))

## 17.6.4 (2025-01-22)

### Fixed (2 changes)

- [Add BoardEpicConnection type policy for pagination](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0fc02660321fef5d2fee627bd9b81c0aaca62a82) **GitLab Enterprise Edition**
- [Fix handling of short gzip metadata files](https://gitlab.com/gitlab-org/security/gitlab/-/commit/09c5801a07e2dcbd48a44ea97cb56aa6fb141105)

### Security (4 changes)

- [Fix protected variable exfiltration](https://gitlab.com/gitlab-org/security/gitlab/-/commit/da2d664ff802e6c961a8e463f39d5b7f179ba0f7) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4715))
- [Enhance rich viewer sanitization](https://gitlab.com/gitlab-org/security/gitlab/-/commit/fca347dbd3660d89b1a58d39e1cf4ce680363988) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4710))
- [Avoid recursive sidekiq calls on cyclic work item hierarchies](https://gitlab.com/gitlab-org/security/gitlab/-/commit/db1de035fb5ddfee1849a411020f22f5808e811b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4660))
- [Respect the private profile constraints](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e834095ace85698c4c32f915e280158bb0ae9e88) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4699))

### Other (1 change)

- [Reorder migrations for ci_deleted_objects](https://gitlab.com/gitlab-org/security/gitlab/-/commit/313e91e2a458db2ebcab4a8bb57384467ee295be)

## 17.6.3 (2025-01-08)

### Fixed (2 changes)

- [Backport bugfix for diff_files highlighting](https://gitlab.com/gitlab-org/security/gitlab/-/commit/827c6864e66e9aa4b97f488212f6bb01a3d62342)
- [Fix ability to use password for Git when password for Web is disabled](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ba71cf797b32dedfcf83b31af1a09939c12a796c)

### Security (4 changes)

- [Prevent cyclic reference in work item hierarchy widget from frontend](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3eeb33ecc4af1392f8df5ada5ff5447d177bc030) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4685))
- [Allow external_provider config take precedence over external_groups](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e69bec763b1eac5995a0355fac8b6f7a6918cffc) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4657))
- [Filter out sensitive parameters on Auth logs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2a5927933b15993e61c45f31c86b2416dd16c0d1) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4666))
- [Don't allow unauthorized users to close issues automatically](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f5bb3a32dd675185c9072a27313e9fb03fb9fe14) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4675))

## 17.6.2 (2024-12-10)

### Fixed (2 changes)

- [Add guard clause to Wiki#find_page when title is nil](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1be99d9925c659f168dccb4b2cfb3510ac74e7ed)
- [Fix 401 errors when installing the GitLab for Jira app](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8e15de4128733083fe3bf640751aecf95d5471a7)

### Security (11 changes)

- [Add timeout around Parslet in template parser](https://gitlab.com/gitlab-org/security/gitlab/-/commit/74de080527cf262ecec44e97c78705953cfa1cdc) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4653))
- [Add authorization check to protectableBranches field](https://gitlab.com/gitlab-org/security/gitlab/-/commit/16152cf39642bd4dc9ed023d52493c9522ef87f2) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4652))
- [Check harbor name & digest for path traversal](https://gitlab.com/gitlab-org/security/gitlab/-/commit/734520792bc637580fd79ce2d368268501382d76) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4629))
- [Ignore titles for GFM links in rich text editor](https://gitlab.com/gitlab-org/security/gitlab/-/commit/769b309ded5f3fca7f550ef9972750cd60298b73) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4649))
- [Restrict user and group creation when same pages unique domain exist](https://gitlab.com/gitlab-org/security/gitlab/-/commit/09997ce510251b8f58343464143e40f1f5ed00c2) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4618))
- [DoS by repeatedly sending unauthenticated requests for diff-files of a commit or merge request](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c0045078225c4b64fa1dd2582c246df5b7b4a96a) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4639))
- [Add query to filter_parameters](https://gitlab.com/gitlab-org/security/gitlab/-/commit/32485a34d6f3ee22fdbe20d0a41cd6b10f0cd511) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4625))
- [Added invalid redirect fragment check](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5c69fef592ceab17eaeda04fd78e120116229b03) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4609))
- [Make confidential threads unresolvable via new issue](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1396d48051a02153a9bd064d39d2d5c09233f3c6) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4633))
- [Do not set session cookie for /v2 endpoints in the response](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3305b0fafe245a02fa01a5b882e8ad5b565f8736) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4630))
- [HTML injection in vulnerability details, leads to XSS on self hosted servers](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4284532cd6ae8f0166806a81628887f82756ceef) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4619))

## 17.6.1 (2024-11-26)

### Security (6 changes)

- [Add size check for harbor registry](https://gitlab.com/gitlab-org/security/gitlab/-/commit/48579cdb744f994dc0fb2b4f96b1ada3e94a59e6) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4614))
- [Adding JobArtifactReport class to pre-emptively validate job artifacts](https://gitlab.com/gitlab-org/security/gitlab/-/commit/83f0e6c1ea1ea6a82e8cf7bdfec0944990f8ec23) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4616))
- [Fix: unsubscribe from actioncable channel when PAT is revoked](https://gitlab.com/gitlab-org/security/gitlab/-/commit/302ed663e0d9a68c413732e9d7a260b6be1b477d) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4621))
- [Allow a LFS token to be used only for LFS related requests](https://gitlab.com/gitlab-org/security/gitlab/-/commit/800c79606ab237536ea5cf9a29e541855fc01477) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4613))
- [Fix possible DOS with TOML file parsing](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7b6057a43cd11aae5a5e8f2f91c76a90a4310ec2) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4617))
- [Move allow_access_with_scope to class level](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b70cb1e7d430bbbcd8da22b33e7d07cb136189d7) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4610))

## 17.6.0 (2024-11-20)

### Added (181 changes)

- [Added type and controls column to requirements and api](https://gitlab.com/gitlab-org/gitlab/-/commit/fcfffdfd869631a4d50e8ccec61dae675557e6ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168478)) **GitLab Enterprise Edition**
- [Allow Sidekiq workers to be disabled by default by configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/64cd00b6fa19b93f420b8153af81b73543f4db7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166652)) **GitLab Enterprise Edition**
- [Remove nuget_extract_nuget_package_model feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e2c9f8c0afaf438f37013e31dd4e6ac2d884a6d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172379))
- [Introduce rotation of personal tokens in UI](https://gitlab.com/gitlab-org/gitlab/-/commit/b70f9cd3ff08e4a0a186d505efaa99dc57c000d7) by @shangsuru ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169954))
- [Add worker for member deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/1588f2a9107f4d7b3e0d2f7aee106539649e94b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170820))
- [Adds ciJobTokenScopeAllowlistEntry graphql type](https://gitlab.com/gitlab-org/gitlab/-/commit/6edad95e175c72ad3dce1ccd644d8613608c9132) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171497))
- [Update docs to reflect workspaces private container registry support](https://gitlab.com/gitlab-org/gitlab/-/commit/152ec4a7fdea53412fb44732898a87ecfbed3005) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172538))
- [Track epic syncing errors](https://gitlab.com/gitlab-org/gitlab/-/commit/30edaa6801e5d028d8f3ccb7c879828f1aeb1bb2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172416)) **GitLab Enterprise Edition**
- [Create ci_runner_tags table](https://gitlab.com/gitlab-org/gitlab/-/commit/3cea0d49e9e3ff470a082528389fff863efca8c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170778))
- [Add ai_settings table](https://gitlab.com/gitlab-org/gitlab/-/commit/e829797f9e65f2d198503532d649c84e1fbadadb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172007))
- [Add network polling and pagination](https://gitlab.com/gitlab-org/gitlab/-/commit/ca4822a38aae9cc532b4d20b2cf1a47849921ec6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172143))
- [Added API for Project Security Settings](https://gitlab.com/gitlab-org/gitlab/-/commit/ccfdaeaa4501a8a015a10ea02b00745d1af00df5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171499)) **GitLab Enterprise Edition**
- [Add sep concurrency control documentation](https://gitlab.com/gitlab-org/gitlab/-/commit/c585b437b5b259aa8a5400241c0d9fc0b775926a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161383))
- [Add DORA projects comparison panel to group Value Streams Dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/14eda95a20db647150ecc662e9ed64c10181344d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172118)) **GitLab Enterprise Edition**
- [Add missing fields to WorkspaceType](https://gitlab.com/gitlab-org/gitlab/-/commit/8f1d3b2f24e9de198010ff797cab3480d8c47f98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170854)) **GitLab Enterprise Edition**
- [Update routes to redirect to duo home](https://gitlab.com/gitlab-org/gitlab/-/commit/16f3699d941baa05008a75607add0925209c30b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169501)) **GitLab Enterprise Edition**
- [Support workspace suspension](https://gitlab.com/gitlab-org/gitlab/-/commit/ed88fc037fb7bffc5b6438e7afbb485a03219635) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166065))
- [Backfill security policies table from YAML](https://gitlab.com/gitlab-org/gitlab/-/commit/57407e3fca30a761dc4294aa60e756b1410e1fb6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164575)) **GitLab Enterprise Edition**
- [Add spdx column to software_license_policies table](https://gitlab.com/gitlab-org/gitlab/-/commit/03e556c7cdc18bf9fa4c43a45f1aa95471a68926) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171584)) **GitLab Enterprise Edition**
- [Create streamers for audit events streaming destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/0845e8639b122a36a07fa1a3b8f3f2e6efbcc43a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171430)) **GitLab Enterprise Edition**
- [Add job to create missing ExternalIssueLinks](https://gitlab.com/gitlab-org/gitlab/-/commit/3824743972cabee76cf0af2b602242ed20340710) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167564)) **GitLab Enterprise Edition**
- [Persist add on seat assignments records on CH](https://gitlab.com/gitlab-org/gitlab/-/commit/0b08706c845049826ef9392d271b69b610fc4aec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171552)) **GitLab Enterprise Edition**
- [Add base importers for GitHub import user mapping](https://gitlab.com/gitlab-org/gitlab/-/commit/a2412081ac03faebd0a0f40224da863edf98ec34) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171910))
- [Add rake task to enable work item epics](https://gitlab.com/gitlab-org/gitlab/-/commit/c07ad51cec5a6cd7a77eca9b6c8cbd9fa978f3a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169457)) **GitLab Enterprise Edition**
- [Sync Application Settings seat_control value with new_user_signups_cap](https://gitlab.com/gitlab-org/gitlab/-/commit/211f556d0ab7361466328598c289d74658d70702) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172293)) **GitLab Enterprise Edition**
- [Protected packages: Integrate push package protection for conan packages](https://gitlab.com/gitlab-org/gitlab/-/commit/8d8299ff6a9de9d6649703c26f28d913e1b6bbb3) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168224))
- [Backfill project bot user details bot namespace](https://gitlab.com/gitlab-org/gitlab/-/commit/7f5392b6cabd1086240d9a98d46d34b14f612bb5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171326))
- [Add placeholder field for work_item related merge requests](https://gitlab.com/gitlab-org/gitlab/-/commit/15e86c65acf52ede91ca71ba09f3286157676529) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172428))
- [Remove feature flag unblock_rules_using_execution_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/e3042c239a34cd3bd6b7c82e025ea82c90f5c9f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172403)) **GitLab Enterprise Edition**
- [Claude 3.5 Haiku model addition gitlab-rails](https://gitlab.com/gitlab-org/gitlab/-/commit/7647a899c279074d915054c860d03c8c3387cdb2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171918)) **GitLab Enterprise Edition**
- [Add support for changing group contact source (for CRM)](https://gitlab.com/gitlab-org/gitlab/-/commit/b546410ec20f9e0d42d964f88f3adea8b0a3f152) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167475))
- [Add Conda to supported SBoM PURL_TYPES](https://gitlab.com/gitlab-org/gitlab/-/commit/dcaa6b1e31bc2d37a2c0f8c38e61490141927ba7) by @duncanmmacleod ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172109)) **GitLab Enterprise Edition**
- [Add webhook for creating a repo (project)](https://gitlab.com/gitlab-org/gitlab/-/commit/e28cc17f2441f19117e0eaa7ed659c8c7b55e7bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160887)) **GitLab Enterprise Edition**
- [Expose KAS Kubernetes API Proxy URL in metadata APIs](https://gitlab.com/gitlab-org/gitlab/-/commit/fe2cfa8ac063845f9c9f9d707140ce3692a90db0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172373))
- [Include model changes and graphql arg for filter by identifier name](https://gitlab.com/gitlab-org/gitlab/-/commit/31f39dae4f63a4f5b6be2cd480b676d41c344f96) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171463)) **GitLab Enterprise Edition**
- [User Mapping: Add warning about reasssignments being permanent](https://gitlab.com/gitlab-org/gitlab/-/commit/8c674a68a798e2b0876347404a6bfab9f5930842) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172023))
- [Add frameworks tab at project compliance center](https://gitlab.com/gitlab-org/gitlab/-/commit/4051dd84f6cbba2b7e821a51919b52911c5b205d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172326)) **GitLab Enterprise Edition**
- [Add filter by group inside compliance center projects tab](https://gitlab.com/gitlab-org/gitlab/-/commit/80bf146d1348ad4a9bc3064b5009519261ae3a3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172341)) **GitLab Enterprise Edition**
- [Show comment tooltips for markdown links to comments](https://gitlab.com/gitlab-org/gitlab/-/commit/59b3262993c5e1a452fbaee19b052c2162c727c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171353))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/f78ef4ddebd99bd95d56f3c58b78ee05aa25924a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172336))
- [GitHub importer add backticks to imported notes](https://gitlab.com/gitlab-org/gitlab/-/commit/3ff8e1872928fcb4ddabff5d7d0a9b2f6a440d3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171550))
- [Adds user_seat_management setting](https://gitlab.com/gitlab-org/gitlab/-/commit/c95b5457a83c5295e716f9b6384109fc796fdef0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171932))
- [Add frontend and controllers for scheduled merge](https://gitlab.com/gitlab-org/gitlab/-/commit/2a04ffdd32afafd7d77c24bd7f84adffbdff006d) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165250))
- [Create is_known_exploit column in pm_cve_enrichment and add tests](https://gitlab.com/gitlab-org/gitlab/-/commit/47e2136325b66053edbf883508213d0c001ceb57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171519))
- [Allow to regenerate the schema from the beginning by loading init schema](https://gitlab.com/gitlab-org/gitlab/-/commit/9733087af2606593e91bb479480fae903fd0243a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172059))
- [Enable FF true for VR filter in the vulnerability](https://gitlab.com/gitlab-org/gitlab/-/commit/891e9acac91fc56f43941bf7f32fd5b83dd2aed1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171718)) **GitLab Enterprise Edition**
- [Add licenses without spdx to custom software license table](https://gitlab.com/gitlab-org/gitlab/-/commit/2617b545770682b3f8033056ec1960bfdaee40f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171528))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/ba7875928bbced1c8db500dacc4dd5fc1ed80ee5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172015))
- [Adding adherence check for DAST scanner on UI](https://gitlab.com/gitlab-org/gitlab/-/commit/758c0a6f6f64761c124cbf85cbbaa5211010240a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171650)) **GitLab Enterprise Edition**
- [Add paper trail to seat assignment models](https://gitlab.com/gitlab-org/gitlab/-/commit/25878117ae9508d8858e9ec8d19f7410ba0b83f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169180))
- [Add policy_tuning into merge request approval policies documentation](https://gitlab.com/gitlab-org/gitlab/-/commit/2efd9e8b0dcc87eb076ef8bf5ca18febde71946e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171829))
- [Adds Members::DeletionSchedule model](https://gitlab.com/gitlab-org/gitlab/-/commit/e23307aa25fe4796592b725c49c7a033651c7bc3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170268))
- [Allow non-epics to use new related item](https://gitlab.com/gitlab-org/gitlab/-/commit/2bbd07405194716f4a8550203549ca3244e70f1c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171264))
- [Model registry: Add actions to models table](https://gitlab.com/gitlab-org/gitlab/-/commit/ac453dcaa5b2665863b33a1d852d113a1510889a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171284))
- [Backfill ci_runner_machines_687967fa8a partitioned table](https://gitlab.com/gitlab-org/gitlab/-/commit/6b4ac23a93e53b6328801b661b424938b131458a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171901))
- [Add DORA projects comparison analytics dashboard visualization](https://gitlab.com/gitlab-org/gitlab/-/commit/914e25dd87704cf16bd7178341de9ccbdc89b194) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170810)) **GitLab Enterprise Edition**
- [Enable internal Repository X-Ray service](https://gitlab.com/gitlab-org/gitlab/-/commit/cfd8100ae8a7c81337cc455673a7da75bf9db3d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171878))
- [Display project visibility level](https://gitlab.com/gitlab-org/gitlab/-/commit/d2b2fffe9ce55b764d59eb266d22b96720310c66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171749))
- [Enable admin agnostic token finder](https://gitlab.com/gitlab-org/gitlab/-/commit/94e73b4671ecf85e266ea61bf84bfe832f5e4fe2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171406))
- [Consolidate audit event streaming strategies to streaming destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/c4e6a892324d4b58ef587c611d221c47ab72bea5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171429)) **GitLab Enterprise Edition**
- [Added validation for streaming destinations on secret token](https://gitlab.com/gitlab-org/gitlab/-/commit/51fb0374af8c166623a3c3b82ebd00f64d573c7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/143914)) **GitLab Enterprise Edition**
- [Create todos for expiring and expired SSH keys](https://gitlab.com/gitlab-org/gitlab/-/commit/bafda91d715f980215b9af246d46c9fa1b6bd53a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171826))
- [Log current organization id](https://gitlab.com/gitlab-org/gitlab/-/commit/e9f48f37c44860ea6c9a92e523ba0ae9a3368019) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171256))
- [Adds syntax highlight support to richt text editor diffs](https://gitlab.com/gitlab-org/gitlab/-/commit/2342bf264de82802bedf5ec0fb2ff849e3678391) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171276))
- [Model registry: Add artifacts tab on Version card](https://gitlab.com/gitlab-org/gitlab/-/commit/d71910c1845ed3711fe9ed1b3efb5a06595966fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169445))
- [Add application settings to allowlist integrations](https://gitlab.com/gitlab-org/gitlab/-/commit/7186906fd32d1092c9991d48a011d8edc0e9de15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171617)) **GitLab Enterprise Edition**
- [Added headers hash for http destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/b4cf955d2bae8b05ca4465585e77bdfd8815976e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165160))
- [Render description column as HTML in GLQL](https://gitlab.com/gitlab-org/gitlab/-/commit/47e65fb4737e9cd7e007a3093e45953299b1fc6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168256))
- [Backfill p_ci_runners table](https://gitlab.com/gitlab-org/gitlab/-/commit/676e40c4dfa0071d4931b25ddbaf1375e59baeb0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166520))
- [chore: Adding changelog](https://gitlab.com/gitlab-org/gitlab/-/commit/4840c17151498f3e27bfcc627c74b6e55eae48da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157084))
- [Update package registry list to show accurate number of error packages](https://gitlab.com/gitlab-org/gitlab/-/commit/005d93c0874cc457f1b9486619469b61aed27210) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171225))
- [Unset auto-resolved status on Vulnerability when unresolving](https://gitlab.com/gitlab-org/gitlab/-/commit/847a858a8eb80804313974d959d92fc2d7d8bc1f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171696)) **GitLab Enterprise Edition**
- [Allow maintainers to admin notes in group level issues](https://gitlab.com/gitlab-org/gitlab/-/commit/e32d44fe83eca20872b03103a859365e14cf38bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171678))
- [Add standards adherence lighthouse metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/cc5ba5db548ed5123c66c2b6f2aa22bd2d673252) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168865)) **GitLab Enterprise Edition**
- [Add sorting component for deployments](https://gitlab.com/gitlab-org/gitlab/-/commit/d8c4f3b3735c8fe27f05966d70409f7528afbbfe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170650))
- [Adding adherence check for SAST scanner on UI](https://gitlab.com/gitlab-org/gitlab/-/commit/0c159e5ed0df3575c9eede174eb042e68cd94c64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171072)) **GitLab Enterprise Edition**
- [Add limit to concurrent batch exports](https://gitlab.com/gitlab-org/gitlab/-/commit/b247b441d69f189f53523c4b5f440e9d946d82dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169122))
- [Add VSA StageAggregation model](https://gitlab.com/gitlab-org/gitlab/-/commit/6d3fc2dfb2c4c4ce1d7021a3fd7d8112284303a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170988))
- [Add mark_internal_note permission to note](https://gitlab.com/gitlab-org/gitlab/-/commit/a825d8d865f728f06755022f8575fbd0fb9818e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171084))
- [Create Projects::DeployTokens::RevokeService](https://gitlab.com/gitlab-org/gitlab/-/commit/9e070e6df6878eefad1c8a8629e4823c9f6a9278) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170585))
- [Add subtab query param to placeholders section](https://gitlab.com/gitlab-org/gitlab/-/commit/4a4b7d9497f2024dcae668fcc59b72dcf98b3371) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170345))
- [Add modal to keep all contributions as placeholders](https://gitlab.com/gitlab-org/gitlab/-/commit/ea84699a0b53196f238b293a2aff5b8d693c46f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169285))
- [Add vulnerability_reference_information table](https://gitlab.com/gitlab-org/gitlab/-/commit/9fcb93fef99fddff157a218fb6596e99caf153bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169293))
- [Create index supporting sbom_occurrences.package_manager search](https://gitlab.com/gitlab-org/gitlab/-/commit/592f692452c4b0f43ef10a008aea491e9a85ed97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171533))
- [Move 'Maximum number of jobs in a single pipeline' from EE to CE](https://gitlab.com/gitlab-org/gitlab/-/commit/05fb2beae141aa726ea49bca77bedce3f404f33b) by @choznerol ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164596)) **GitLab Enterprise Edition**
- [Add security policy bot for container scanning](https://gitlab.com/gitlab-org/gitlab/-/commit/dd149865ea1440baf751fe77008f85bcf71a6a95) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167602)) **GitLab Enterprise Edition**
- [Adding adherence check for dast scanner run](https://gitlab.com/gitlab-org/gitlab/-/commit/c4ffc7b6d05eb4b25b4ebbbd789576b69dc3baa0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170688)) **GitLab Enterprise Edition**
- [Add admin role option for the default project creation protection](https://gitlab.com/gitlab-org/gitlab/-/commit/cb18fba2672d44e88a9c9ebb77b21ef20f742aec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171245))
- [Configure Sec CI for MR's labelled sec-decomposition](https://gitlab.com/gitlab-org/gitlab/-/commit/38961468569106fe6c987c31c7cea22778c8f499) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169907))
- [Model registry: Add actions to versions](https://gitlab.com/gitlab-org/gitlab/-/commit/0a320c8d1460aaabd377e8b0b06912b9f198afe8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170977))
- [Default enable security_policies_sync feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/146edce7fe7854d3b4bad437c34f46afb38356a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170146)) **GitLab Enterprise Edition**
- [Add JobTokenAuthLog resolver and type](https://gitlab.com/gitlab-org/gitlab/-/commit/858f5c3ad9149dd49666aebba764ee0bec1c4cdb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169323))
- [Add `solo_owned` filter to the Users#Organizations resolver](https://gitlab.com/gitlab-org/gitlab/-/commit/439076d9e2d8029d45db7b3b36f8b3c36ff2d458) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170385))
- [Adds UI elements for deprecated packages](https://gitlab.com/gitlab-org/gitlab/-/commit/bc58721e8399962bece7d200419b4e3493935ce1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170435))
- [Model registry: Add artifactsCount](https://gitlab.com/gitlab-org/gitlab/-/commit/5d745f231c338016c82e3e2a48bf15ab33300000) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170450))
- [Make GKE runner option generally available](https://gitlab.com/gitlab-org/gitlab/-/commit/9badbb7693e4692d2d78fa78bce2f2339be5006d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171044)) **GitLab Enterprise Edition**
- [Model registry: Add performance tab to Version card](https://gitlab.com/gitlab-org/gitlab/-/commit/a92ef60715068728210ee468426161793979c561) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170802))
- [Enable NOT filtering for target branches in MR List GQL](https://gitlab.com/gitlab-org/gitlab/-/commit/a250628ce585e15b9a7ce34d5f3e073c45b806ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170664))
- [Activate syntaxhighlighting in CI/CD catalog README](https://gitlab.com/gitlab-org/gitlab/-/commit/5d033f2e45bffb09aac17e4dea8137d143c2d781) by @hairmare ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170091))
- [Adding adherence check for sast scanner run](https://gitlab.com/gitlab-org/gitlab/-/commit/6a819456d845f4a4a976834fd29eb3167bb3a4c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163579)) **GitLab Enterprise Edition**
- [Added ability to push multi-result count to sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/0a5a5fb03d2e08d2c6b86ece9ba0199ae17e5f57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170459))
- [Add streamed diffs to rapid diffs commit page](https://gitlab.com/gitlab-org/gitlab/-/commit/4ec2d3aeb3a13bd2a02ec6baa02ce10695c36fb7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170255))
- [Add GraphQL API for Wiki notes](https://gitlab.com/gitlab-org/gitlab/-/commit/8eef64ad4e2e050a6da79e0ba161993c5c6548c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164071))
- [Add and backfill project_id for ci_trigger_requests](https://gitlab.com/gitlab-org/gitlab/-/commit/4aae397a23677d2b47ca2363e0b9a3b1c4ffbf4f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169236))
- [Create ci_runners_e59bb2812d partitioned table](https://gitlab.com/gitlab-org/gitlab/-/commit/99890a5265ef517a020c2e5c79d296f608f4c179) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166308))
- [Model registry model right sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/bcd86f8104bc475fcbcedfe70a44705ac85215c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170291))
- [Add DeleteNotPresentOccurrencesService for CS4R](https://gitlab.com/gitlab-org/gitlab/-/commit/1ad9b549feb952486f052076e28c42b1e8535779) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169134)) **GitLab Enterprise Edition**
- [Group settting to notify inherited members for access token expiry](https://gitlab.com/gitlab-org/gitlab/-/commit/ee9e781b9404eeaaeefaebe41d6f21bcf8c0628f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168439))
- [Add a setting for text editors](https://gitlab.com/gitlab-org/gitlab/-/commit/0fb1742c8c316f3aa7003218b607b623d5259353) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168077))
- [Create an audit event when SD exclusion is applied](https://gitlab.com/gitlab-org/gitlab/-/commit/cbd1c6334f225b5d4d5a8cdc2b9789301431ea77) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168955)) **GitLab Enterprise Edition**
- [Add mailer for duo enterprise seat assignment](https://gitlab.com/gitlab-org/gitlab/-/commit/b7e3924a408117d7b1335432a590de0d4ff115eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170507)) **GitLab Enterprise Edition**
- [Model registry: Add tabs to Version card](https://gitlab.com/gitlab-org/gitlab/-/commit/ba1d73b6221ace42fbbf1a21f464c0666a1c96a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170793))
- [Subscribe to Members::Added event](https://gitlab.com/gitlab-org/gitlab/-/commit/d0291e97cc8ec92d721f1c6b683172d09b5b3503) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169267)) **GitLab Enterprise Edition**
- [Add license option to sort options](https://gitlab.com/gitlab-org/gitlab/-/commit/287713d8669e398a598d34094bd20d53b2ed0efb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170776)) **GitLab Enterprise Edition**
- [Add reverse_lock_order on pending_alert_escalations table](https://gitlab.com/gitlab-org/gitlab/-/commit/e1392811b2647aa9506ed8ea5f8e59637a40ea99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168212))
- [Add Feed Tokens to Token information API](https://gitlab.com/gitlab-org/gitlab/-/commit/0e0b2c6af73e69a581bacaea17db8e774717d248) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170690))
- [Remove terraform_extract_terraform_package_model feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f8d1feb0676e16a5dcaa54470b33d654c9d8f842) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170584))
- [Adds enable_member_management setting to api response](https://gitlab.com/gitlab-org/gitlab/-/commit/bc90c3e9034d61cbcb54d0e49bcfd589ea4c1ec2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168356)) **GitLab Enterprise Edition**
- [Expose /licenses endpoint on Project Dependency list](https://gitlab.com/gitlab-org/gitlab/-/commit/520f17a0594f9cc049036c0b5b8ca47a33790f8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170619)) **GitLab Enterprise Edition**
- [Add `auto_resolved` column to `vulnerabilities` table](https://gitlab.com/gitlab-org/gitlab/-/commit/cd56249b906ca67ee31abe8e1f1726c877b8b4b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169949))
- [Add archived to NamespaceSettings for groups](https://gitlab.com/gitlab-org/gitlab/-/commit/a45cff79b2014278f78d1fbf4adceead52fc2284) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170388))
- [Add label filter for merge requests scope](https://gitlab.com/gitlab-org/gitlab/-/commit/c5114a8e6357ec1491125f4b832e9e48ece6674b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170294))
- [Add new event Members::DestroyedEvent](https://gitlab.com/gitlab-org/gitlab/-/commit/8506dbc673e6aa0ce9ac24dd449b168e1f15a0f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169756)) **GitLab Enterprise Edition**
- [Audit when multi project down stream pipeline is created](https://gitlab.com/gitlab-org/gitlab/-/commit/3a88218d4be2535c2c492d2753d6f275a7ecb282) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168626)) **GitLab Enterprise Edition**
- [Backfill sharding key for events](https://gitlab.com/gitlab-org/gitlab/-/commit/b3e8ce1827fddbd6ee410c6e60b4a740fd10da95) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166563))
- [Make JaCoCo reports Generally Available](https://gitlab.com/gitlab-org/gitlab/-/commit/1a7d16a21ea8b3060ba12e4edd0b859edc59cd82) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170513))
- [Add warning to file uploads in confidential/internal notes](https://gitlab.com/gitlab-org/gitlab/-/commit/d87a8befd9e89727e7f57eaa4a0a61e49e446dff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170125))
- [Assume high risk for users who use a duplicate phone number](https://gitlab.com/gitlab-org/gitlab/-/commit/c43ccd96bfe6402cf3706281d2e24b60909cd658) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170508)) **GitLab Enterprise Edition**
- [Added mutation for creating compliance requirements](https://gitlab.com/gitlab-org/gitlab/-/commit/ea17924b49b4bcc67801f2a9486a30785cb49fca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169485)) **GitLab Enterprise Edition**
- [Release Jira deployment gating feature](https://gitlab.com/gitlab-org/gitlab/-/commit/bab9629597d298d9c528f634f786832d7fef8c40) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168739))
- [Prepare conversion of abuse_reports to bigint](https://gitlab.com/gitlab-org/gitlab/-/commit/fa537e0fd5d1a37b8d99bf03807e894516050901) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170425))
- [Support X-Delivered-To headers for email ingestion](https://gitlab.com/gitlab-org/gitlab/-/commit/3c505e9451dea68e62989851b5cf2f81317b0303) by @divyamtayal ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170221))
- [Remove model registry feature flag by releasing the feature](https://gitlab.com/gitlab-org/gitlab/-/commit/7a717bb8643b83edd3cb6bf711288d0b6e5b0e9e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170070))
- [Model registry: Display author in model metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/cbab2c881a07b20c206dc3917bdfa56aead252dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170109))
- [Add support for assigning an agent to an environment via CI](https://gitlab.com/gitlab-org/gitlab/-/commit/a9121970c472c2408c1d2c64be7a5656f5ca767c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169675))
- [Add work item iteration to create flow](https://gitlab.com/gitlab-org/gitlab/-/commit/549efa40e5a2c5084a643eafdf699b34614a48bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169087))
- [Expose list of Duo Chat available features](https://gitlab.com/gitlab-org/gitlab/-/commit/c1b1b17ff394a8d5f825e1be523bcbfdc823eb1b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168794)) **GitLab Enterprise Edition**
- [Support subscriptions in GraphQL explorer](https://gitlab.com/gitlab-org/gitlab/-/commit/943c0d6cfd53626d9af8b39d2b68616f52dd66bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169619))
- [Release protected npm packages feature](https://gitlab.com/gitlab-org/gitlab/-/commit/ed4d68b173e2c4790b2ae6683a51db5450062e45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169246))
- [Remove `ci_retry_on_exit_codes` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d57fa8ee02997588f34b838f8eb95a114150bcb2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169434))
- [Retry some errors](https://gitlab.com/gitlab-org/gitlab/-/commit/fd4e4bff71990f1b49d9d4ff8e19d8225a994f1c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167809)) **GitLab Enterprise Edition**
- [Display external author in note header on work items](https://gitlab.com/gitlab-org/gitlab/-/commit/e513a5170e72ea6a876e4fae4fb2eee10e1ecd73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169929))
- [Filter todos when marking all as done](https://gitlab.com/gitlab-org/gitlab/-/commit/7deeb18ec745dc94f57702e60c5101f0c705e085) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170170))
- [Add identity_verification_settings column to application_settings table](https://gitlab.com/gitlab-org/gitlab/-/commit/58b635c8f1da119f8f4afc764dc03441ccec7baa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167982))
- [Rake to alter cells only table sequences](https://gitlab.com/gitlab-org/gitlab/-/commit/b1fa834b884803b9ac4d816b2443cb2831c88016) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168941))
- [Model registry: Display author in modelversion metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/d61c2983e8cec361c81c3ac8b6f55fe237af2a54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170106))
- [Protected packages: Integrate package protection rules for pypi packages](https://gitlab.com/gitlab-org/gitlab/-/commit/615721cdd0ced393dd44d7fd239b7148ed99a1c5) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/135475))
- [Create unique table visualizations for analytics dashboards](https://gitlab.com/gitlab-org/gitlab/-/commit/afec89eb34ff57e66e8f7ce6bcbedc34b04b39f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169618)) **GitLab Enterprise Edition**
- [Add duo enterprise trial discover page](https://gitlab.com/gitlab-org/gitlab/-/commit/5d522ee10b0cf1cd92d28202b232f90584adef6f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168823)) **GitLab Enterprise Edition**
- [Add feature flag for github import user mapping](https://gitlab.com/gitlab-org/gitlab/-/commit/25106f1b7f443e1db72e70b02e7801374422bcb4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169726))
- [Add duoUsedCount aiMetrics](https://gitlab.com/gitlab-org/gitlab/-/commit/4c05c479e852db5fd482d6bbc9db36bc78fe4216) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169722)) **GitLab Enterprise Edition**
- [Add `counts.groups_with_enterprise_users` metric](https://gitlab.com/gitlab-org/gitlab/-/commit/b547b957d21d76b4a8026287621907359ccb077e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169631)) **GitLab Enterprise Edition**
- [Add visibilityLevel to Ci::Catalog::Resource type in GQL](https://gitlab.com/gitlab-org/gitlab/-/commit/b5cb5fc21ca4a11c8dac24fe5ee1863afab5ab57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169480))
- [Create new compute_minutes internal API route](https://gitlab.com/gitlab-org/gitlab/-/commit/7b9e01b3ba83b085ba4e71eb9069992ec1038ba4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169609)) **GitLab Enterprise Edition**
- [Add project_id to ci_pipeline_messages](https://gitlab.com/gitlab-org/gitlab/-/commit/28216b96068458b87052d06a1926a4eb64033b1c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169208))
- [Add `theme` parameter to broadcast message API](https://gitlab.com/gitlab-org/gitlab/-/commit/d08706167b6722a2c3280cf3e4b341f571854a7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169762))
- [Customize GraphQL explorer logo and welcome text](https://gitlab.com/gitlab-org/gitlab/-/commit/25497254be78f13382e2c27faa9167f9bf014de7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169610))
- [Add GKE provisioning service](https://gitlab.com/gitlab-org/gitlab/-/commit/f80d3c462e820cf81c0f467bc2c990b32a85291b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167246)) **GitLab Enterprise Edition**
- [Setting for resource token expiry notifications to inherited members](https://gitlab.com/gitlab-org/gitlab/-/commit/09ba517cb5771b5065c6f8bdc5030bb774d10abf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168245))
- [Model registry: Add author to model and model version](https://gitlab.com/gitlab-org/gitlab/-/commit/94b8ce416efee628b36762149afc232f183305d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169447))
- [REST API: add an endpoint to configure pull mirrors](https://gitlab.com/gitlab-org/gitlab/-/commit/ce0aeec2ee7ea66f8f8ca5f01d224d767832d09f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167901)) **GitLab Enterprise Edition**
- [Add forked_from_project_id to project entity](https://gitlab.com/gitlab-org/gitlab/-/commit/8d2f35f32b48b76582e73e8a691375fc5a616b86) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168501))
- [Search API: Issue support fields parameter to search by title](https://gitlab.com/gitlab-org/gitlab/-/commit/c64cf2c498a46017326891e3acdcb89a726c0c4e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169386)) **GitLab Enterprise Edition**
- [Add AssignDesiredShardingKey to support non id PK](https://gitlab.com/gitlab-org/gitlab/-/commit/64030c654fcbcd977bd5829588933092819c77ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169530))
- [Create rake task to cleanup wrongly provisioned add-on purchases](https://gitlab.com/gitlab-org/gitlab/-/commit/4aa6d9f64f3a9980872e579d73cfdfd1158593c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169614)) **GitLab Enterprise Edition**
- [Auto-ban duplicate users when a user is banned](https://gitlab.com/gitlab-org/gitlab/-/commit/8fc382adc19fa4bc3b17380f853031cd87a56678) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167357))
- [Export CI Job Token Authorizations in CSV](https://gitlab.com/gitlab-org/gitlab/-/commit/13271c49c030fbafbc4f7df16002dbf8e90cc021) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168413))
- [Add skip parameter in network graph list commits](https://gitlab.com/gitlab-org/gitlab/-/commit/4e3baa520bb2f7be8d802b4251bc1b1ab0dce38a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169210))
- [Service Ping count projects using multiple compliance frameworks](https://gitlab.com/gitlab-org/gitlab/-/commit/435370dd34b9fe6edc2de075e67d52693e159bd0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169047)) **GitLab Enterprise Edition**
- [Add GitLab University link to pipeline editor](https://gitlab.com/gitlab-org/gitlab/-/commit/2b10b290f33c64e1bed8d05138388e075c660a0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169327))
- [Check parents when rendering 'pending deletion' badges](https://gitlab.com/gitlab-org/gitlab/-/commit/70277d13c369e01a1ab779e9f11e573011939da8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168963)) **GitLab Enterprise Edition**
- [Create new gitlab_subscriptions internal API route](https://gitlab.com/gitlab-org/gitlab/-/commit/7412ec02f272f7526baf597bce98a7231fbe0951) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169430)) **GitLab Enterprise Edition**
- [Adds external author to note type](https://gitlab.com/gitlab-org/gitlab/-/commit/0bf5c9714dfd66a0507c6a6da18307f7fbc31f80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168678))
- [Add epic_issue and epic_links work item references](https://gitlab.com/gitlab-org/gitlab/-/commit/8d7df0391ec9b1bab9a5160e5d9e72c960a886ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168122)) **GitLab Enterprise Edition**
- [Validate OmniAuth email length by default](https://gitlab.com/gitlab-org/gitlab/-/commit/d9b253df38631bded2766a102ed1fe5b5e9870ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169337))
- [Use LFK to mark packages nuget symbols for destruction](https://gitlab.com/gitlab-org/gitlab/-/commit/cae0c3adaf0cde0c0a99ebc940d601bffe521b96) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166743))
- [Adds email participants widget definition](https://gitlab.com/gitlab-org/gitlab/-/commit/f51b20bd6c5e5481b050e9e252104ae2e6357114) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168536))
- [Add sharding key project_id for p_ci_pipelines_config](https://gitlab.com/gitlab-org/gitlab/-/commit/c031f8ea82252f4a43c0dff950965222d54a9a77) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167387))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/58b989588c9bbf60a826c2020b05c13f2b468b60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169233))
- [Add badges to Catalog releases](https://gitlab.com/gitlab-org/gitlab/-/commit/6f0c91310739a0392d263ba74ac573824d9e0829) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167944))
- [Add lastActivityOn field to MemberInterface type](https://gitlab.com/gitlab-org/gitlab/-/commit/52fa24d2e1e0984a3c942bf87a428335b036d3dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168714))

### Fixed (176 changes)

- [Limit follower and following count to 21 before pagination](https://gitlab.com/gitlab-org/gitlab/-/commit/8401215a9f6f4191e471cb14e3d8df8070e54e0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172586))
- [Only highlight file on changes tab](https://gitlab.com/gitlab-org/gitlab/-/commit/ef183cab18d4c6aaa7de590879f7f88f9a1ac6fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173057))
- [Use GlFormSelect for project visibility dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/a983fe9559d82445fe3ef4c1de87cf4b44a3bc3d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172125))
- [Update namespace_id when moving issues](https://gitlab.com/gitlab-org/gitlab/-/commit/ee2a308faa7f8b7398edfa64a7926e18ec6ab576) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166617))
- [Fix setting namespace_id for group wiki page notes](https://gitlab.com/gitlab-org/gitlab/-/commit/53863eb7b44da9d9823393d66380d2c354e30fda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171889))
- [Add quickActionsStatus field to create/update note GraphQL mutations](https://gitlab.com/gitlab-org/gitlab/-/commit/478e89b42ea402e37f253f6df5c472d8ab67a247) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172179))
- [No op BBM QueueCreateMissingExternalLinksForVulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/43b9305198f2ec1aa7479977e05dec98928e57ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172875))
- [Fix padding of reply comments so that username and comment content align](https://gitlab.com/gitlab-org/gitlab/-/commit/4a885fb333ecf7c161ab4313c8c75da102b21add) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172861))
- [Merge request: Add correct design token for border bottom](https://gitlab.com/gitlab-org/gitlab/-/commit/a4e5d580d5bd99f2448590cd69d854aeb4a44ee1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172858))
- [Publish AuthorizationsAddedEvent with multiple projects](https://gitlab.com/gitlab-org/gitlab/-/commit/0020784a161249ec3dedf5780926878d9e5a6d9a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171991)) **GitLab Enterprise Edition**
- [Fix displaying “unsupported” emojis](https://gitlab.com/gitlab-org/gitlab/-/commit/5a15139a5d822eacf921723446266e90497af25f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172747))
- [Do not run validations on AccessToken revocation](https://gitlab.com/gitlab-org/gitlab/-/commit/357c444badff7cae0ce66525be6b0c4d08c03951) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172480))
- [Save comments on a diff file automatically](https://gitlab.com/gitlab-org/gitlab/-/commit/797bc038d9d6b0d01e27db716e92826724086430) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171571))
- [Remove ci_redis_pipeline_creations flag](https://gitlab.com/gitlab-org/gitlab/-/commit/29ab73390753ab571c7159422703bb1d12980682) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172674))
- [Exclude hidden issues in sidebar count](https://gitlab.com/gitlab-org/gitlab/-/commit/ab1aa8f8ca862a07404cef08ef4f9356fea805b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172665))
- [Return error when unable to create import relation](https://gitlab.com/gitlab-org/gitlab/-/commit/53f201f924ec7c9e3da6149c8f1f4c5e863c73be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172631))
- [Consider manual pipeline for unenforceable policy rules](https://gitlab.com/gitlab-org/gitlab/-/commit/9042c6aa381f4271f45c7fb2403f26872b51ed95) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172570)) **GitLab Enterprise Edition**
- [Fix application errors in /user/personal_tokens endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/d053bc06e7867abd6e9b94e9e73ae7c5a4c5b387) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172274))
- [Fix check for `Diff::Line#match?`](https://gitlab.com/gitlab-org/gitlab/-/commit/ab2fbeb3dd6762e24fbdb181eb21a7cbd924361e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172067))
- [Update AuthorizationsAddedEvent to handle multiple projects](https://gitlab.com/gitlab-org/gitlab/-/commit/4599571aba14cbc46a283e9e5f0874b51d343c9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171990)) **GitLab Enterprise Edition**
- [Fix pipeline security summary not loading](https://gitlab.com/gitlab-org/gitlab/-/commit/96198287f5a4732ad0668e45cd3d7c3d8885eef5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172495)) **GitLab Enterprise Edition**
- [Fix on call rotation modal styles](https://gitlab.com/gitlab-org/gitlab/-/commit/a99080f7f6de5b57b072f3bba1ba3b275d9403b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172499))
- [Check title and name fields for scope delimiter for labels](https://gitlab.com/gitlab-org/gitlab/-/commit/1b4900ca9ba22e8f35be8639ed8b4a691a81a92f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172452)) **GitLab Enterprise Edition**
- [Display the mermaid plot in terms page when 2FA on](https://gitlab.com/gitlab-org/gitlab/-/commit/e1477b55b1e47790d47e0a97576aa2645f1a9d72) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171407))
- [Let activity entries wrap instead of overflowing](https://gitlab.com/gitlab-org/gitlab/-/commit/892ec23733da45f949bf0eeebac46605d61bf299) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172439))
- [Use nav item title as aria-label on nav link](https://gitlab.com/gitlab-org/gitlab/-/commit/e8d5ce480640f42d88f499bda211bac27ac4a72f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172436))
- [Fix warning background color for compare page](https://gitlab.com/gitlab-org/gitlab/-/commit/609e13dc5c107e70d4721905e81b297bf4cea50e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172351))
- [Index work items when project visibility level changes](https://gitlab.com/gitlab-org/gitlab/-/commit/c540267f275647c25f19165abc2a824af89e60d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171978)) **GitLab Enterprise Edition**
- [Conditionally show Users without a group or project in correct section](https://gitlab.com/gitlab-org/gitlab/-/commit/0d2e54e2780632b49b4a78f5dab30ff3859c42ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172028)) **GitLab Enterprise Edition**
- [Add missing namespace IDs header for Code Completion requests](https://gitlab.com/gitlab-org/gitlab/-/commit/caac8c44fab058a1d3f222d65f14ad081e30f47f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171216)) **GitLab Enterprise Edition**
- [Optimize `standardRoles.memberCounts` query](https://gitlab.com/gitlab-org/gitlab/-/commit/061a21e078d5473dac17c8a2dabb59f27f026e87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169783)) **GitLab Enterprise Edition**
- [Re-add utility classes mw-m, mw-l and mw-xl for metadata_item.vue](https://gitlab.com/gitlab-org/gitlab/-/commit/a4978a8149f027c2d83708025e77e070e16e691f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172032))
- [Check work_item_epics FF for legacy date rollup](https://gitlab.com/gitlab-org/gitlab/-/commit/6b7e60ec4ec3225e27f5302b27aaf3d8242f2f4a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172241)) **GitLab Enterprise Edition**
- [Fetch left super sidebar counts with async GraphQL calls](https://gitlab.com/gitlab-org/gitlab/-/commit/5ee53e379787cd53f9851cd49107404dece20fda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171454))
- [Vertically align badges in glql lists](https://gitlab.com/gitlab-org/gitlab/-/commit/2c6d1d074b603c192f968758c1549d17d681330f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172141))
- [Fix issue with /label and /unlabel commands](https://gitlab.com/gitlab-org/gitlab/-/commit/84b561d7a01f718ef3e6a1019abd044f79fb01d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172104))
- [Fix updating approvers of multiple merge request rules](https://gitlab.com/gitlab-org/gitlab/-/commit/139f956eb456b2eb5c1cf8492a2c74184d6552e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172097)) **GitLab Enterprise Edition**
- [Adds findings exists check](https://gitlab.com/gitlab-org/gitlab/-/commit/424b149a8fba75a41c3ebfaf0fb77eb576eff2b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171324)) **GitLab Enterprise Edition**
- [Fix LLM AI client not returning a HTTP response with 204 responses](https://gitlab.com/gitlab-org/gitlab/-/commit/98e578c946dbb9ab27fe9fff5cb934c7d3d4c05a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172025))
- [Fix error during project deletion when pipeline sha is nil](https://gitlab.com/gitlab-org/gitlab/-/commit/120b968f5c401969419dfaa7d0a9ab5443da1462) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172046))
- [Fix user caps alert positioning to be above members buttons](https://gitlab.com/gitlab-org/gitlab/-/commit/3dfeba9c2fd0a8091faeaecb3b87830962fdb4d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172039)) **GitLab Enterprise Edition**
- [Fix double API call when inviting a project member](https://gitlab.com/gitlab-org/gitlab/-/commit/18dafa2fedf4036b1d098c5501e5a585e8c9f565) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172011)) **GitLab Enterprise Edition**
- [Check for package_forwarding feature availability in admin's settings](https://gitlab.com/gitlab-org/gitlab/-/commit/d7f92f9a6b7f5821be84ea15c1f95b780fd93990) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171949)) **GitLab Enterprise Edition**
- [Wait until pipeline finishes to evaluate unenforceable scans](https://gitlab.com/gitlab-org/gitlab/-/commit/c6f5ee46e8078fa5f95ee13fa4d2a055d99d94da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171970)) **GitLab Enterprise Edition**
- [Fix AIGW header for chat requests](https://gitlab.com/gitlab-org/gitlab/-/commit/98ad4e2c03df66d938c2a44cb2b5ddc19486dc4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171679)) **GitLab Enterprise Edition**
- [Stop blocking pre-existing policy rules as unenforceable](https://gitlab.com/gitlab-org/gitlab/-/commit/aaf5b53138e0755a83fb92f8ef6ad98538e57836) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171931)) **GitLab Enterprise Edition**
- [Use Gitlab::HTTP for outbound filtering rules](https://gitlab.com/gitlab-org/gitlab/-/commit/9cbb009f4bae43dbc8af1507ae812e0da3265ec2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171881))
- [Remove #find_object override in CI job mutations](https://gitlab.com/gitlab-org/gitlab/-/commit/21421bcf752b9deef506d00279c699a2615fbc86) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171874))
- [Handle TypeError in parsing webhook template](https://gitlab.com/gitlab-org/gitlab/-/commit/55dbd1673777bf3496bee7fb1d878f7d699ed197) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171871))
- [Create migration to update admin bot profiles](https://gitlab.com/gitlab-org/gitlab/-/commit/2f74b9d9ebd1ccf0e68e89ad0b4197e206e44568) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171035))
- [Implement abort pod logs stream](https://gitlab.com/gitlab-org/gitlab/-/commit/18118042141c49d0993b4cb5ee1c645ac264dfda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171415))
- [Fix cron worker that deletes project_bot users to delete inactive only](https://gitlab.com/gitlab-org/gitlab/-/commit/131a942ae94a1242cf5d57879a9ee1b761707358) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169012))
- [Use subscription data for subscription related card](https://gitlab.com/gitlab-org/gitlab/-/commit/885fdbb520254894df161e676f095a80dd20c0f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170925)) **GitLab Enterprise Edition**
- [Fix pagination redirect for protected branches/tags](https://gitlab.com/gitlab-org/gitlab/-/commit/fd70fce5515a64099dbf6d030fe56659f0699d87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171832))
- [Don't change MR closing issues if MR is set to auto merge](https://gitlab.com/gitlab-org/gitlab/-/commit/8751654e580846b8c26a0979e3e493959786d417) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171721))
- [Return an error for an invalid ref_name](https://gitlab.com/gitlab-org/gitlab/-/commit/a47d7f59fe4000ecc820fc1027ae6f9c765e9cd4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171808))
- [Fix group wiki activity events breaking the user feed](https://gitlab.com/gitlab-org/gitlab/-/commit/6e1e569ba873bde03a5f65cc28f170ea33373b32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171652))
- [Fix PendingStatusCheckWorker when merge_request is not found](https://gitlab.com/gitlab-org/gitlab/-/commit/f5ba1ca23fbd96f100a2554991837757dff1bd32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171523)) **GitLab Enterprise Edition**
- [Fix RTE rendering bug with empty code blocks](https://gitlab.com/gitlab-org/gitlab/-/commit/a3dbfacfc00b7ec46e664ce40403f0745f94a9df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171730))
- [Fix project subscriptions policy](https://gitlab.com/gitlab-org/gitlab/-/commit/d11431241492bd79cbef6bd9aa03c424940af5d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/142700)) **GitLab Enterprise Edition**
- [Fix repository push emails: don't escape commits for plain text emails](https://gitlab.com/gitlab-org/gitlab/-/commit/a702a335cd94d6ebe3753ff92785b4ded7085796) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171640))
- [Changelog API: fix pattern for header detection](https://gitlab.com/gitlab-org/gitlab/-/commit/a6f2b68abc303799e569f4bebb12e054f9cde104) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171654))
- [Allow job play mutation to act on instances of Ci::Bridge](https://gitlab.com/gitlab-org/gitlab/-/commit/d01c2e573123f8218a373d545859cf7a4f0ee19c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171344))
- [Create project security_setting if necessary](https://gitlab.com/gitlab-org/gitlab/-/commit/55110296e58e6928a6d68af73722e1b79dbfad68) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171599)) **GitLab Enterprise Edition**
- [Fix update of violation status for non-applicable approval rules](https://gitlab.com/gitlab-org/gitlab/-/commit/24dabd81fd6e6786450d1ec8458d2d003b420133) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171385)) **GitLab Enterprise Edition**
- [Avoid updating or creating runner managers when deleting runner](https://gitlab.com/gitlab-org/gitlab/-/commit/d2d6f6e0843e5c598f0ce0a8f61c1973ecb3eff3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171575))
- [Fix start and due dates values for work items](https://gitlab.com/gitlab-org/gitlab/-/commit/e0215277b3935033eb7608188a2e58dce2a0e49c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170866)) **GitLab Enterprise Edition**
- [Markdown header: Fix bg color in darkmode](https://gitlab.com/gitlab-org/gitlab/-/commit/4669f26437f57070b615b20d67168db01d5e34f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171524))
- [fixed: Redirect behaviour for git-upload-pack requests](https://gitlab.com/gitlab-org/gitlab/-/commit/46fbb5fae8d37b64d4cdb42a4458907a73a88f1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166965)) **GitLab Enterprise Edition**
- [Settings footer: increase z-index by 1 from header](https://gitlab.com/gitlab-org/gitlab/-/commit/0fd4aec242df74e0cb5b048039e8e51e39b46852) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171404))
- [Repo language bar: Fix text in darkmode](https://gitlab.com/gitlab-org/gitlab/-/commit/12ce9fff08c5ca5a6087027d03205ce0171036f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171386))
- [Don't create approval rules without require_approval action](https://gitlab.com/gitlab-org/gitlab/-/commit/ea7d0b7b5b06f683d15a213656fe933cf3eb5a4e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171390)) **GitLab Enterprise Edition**
- [Model registry: Allow author to be missing](https://gitlab.com/gitlab-org/gitlab/-/commit/4b129499d33190f01416fa6ede4ea46f7ef2dcb8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171367))
- [Update container registry link to settings path](https://gitlab.com/gitlab-org/gitlab/-/commit/7ab9767dc49421962ab7773855380b5dced8ad24) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171362))
- [Only set has_vulnerabilities records are ingested](https://gitlab.com/gitlab-org/gitlab/-/commit/7e09ea99fdcbf8b3da9af526e4155b1b0aefb498) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170811)) **GitLab Enterprise Edition**
- [Fix incorrect `has_vulnerabilities` values](https://gitlab.com/gitlab-org/gitlab/-/commit/96038f8c4a1b897c4c51a4b016dda755437fcaef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171029))
- [Replace non-existing path in the profile 2FA page](https://gitlab.com/gitlab-org/gitlab/-/commit/904003e9cc1325c5bd2eeabdc3b06bc3e01f60e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169534))
- [Fix diff hunk header overflow](https://gitlab.com/gitlab-org/gitlab/-/commit/7d12eeb46e907645497480d7069dc0f2f6bc752f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171299))
- [Corrects an inaccuracy in idempotent jobs docs](https://gitlab.com/gitlab-org/gitlab/-/commit/ec19366c3e1abea00e62c65c2d403866277dfa57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171290))
- [Fix GitLab Duo chat session error in the Web IDE](https://gitlab.com/gitlab-org/gitlab/-/commit/f6d1cd25aab61f1f182cb772693e811168f43ff2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171262)) **GitLab Enterprise Edition**
- [Uses tool input rather than user_input for calls](https://gitlab.com/gitlab-org/gitlab/-/commit/ef4b4e366e4e3b43594846d5a3b6b6723b30b08e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169753))
- [Fix: admin group update logic](https://gitlab.com/gitlab-org/gitlab/-/commit/fef6c679a3405612d3e8d88602f6b89e49d82789) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170068)) **GitLab Enterprise Edition**
- [Resolve "Correct cve-enrichments to cve-enrichment"](https://gitlab.com/gitlab-org/gitlab/-/commit/62f57fec2776e5c1191e65d4d21ee8009c1fcde7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171094))
- [Ensure auto_merge_enabled is set when validating merge trains](https://gitlab.com/gitlab-org/gitlab/-/commit/2c1ecb070dc16b131888b2a9227b1e5842697b30) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170652)) **GitLab Enterprise Edition**
- [Fix nondeterministic `discussions_for_summary` method](https://gitlab.com/gitlab-org/gitlab/-/commit/dd3cba0fdb52bf1235234828cbf7c51fb74dd295) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171131)) **GitLab Enterprise Edition**
- [Convert 20241022181600 to a schema migration](https://gitlab.com/gitlab-org/gitlab/-/commit/6717cbce352496fb3fce11d2fb53ae155e9aa65c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171158))
- [Support namespaces in X-Gitlab-Duo-Seat-Count](https://gitlab.com/gitlab-org/gitlab/-/commit/7c36c68eb54b606d6d6c9bebd3c944cf9ee96ac2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171135)) **GitLab Enterprise Edition**
- [Fix edge case when imprting issues with invalid associations](https://gitlab.com/gitlab-org/gitlab/-/commit/0bddcdf50204d50be029e19de13d0a145178a6f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170786))
- [Go-get: return 404 error code when personal token is invalid](https://gitlab.com/gitlab-org/gitlab/-/commit/fa76ff697f8d44ced7fb59930f82b98336683b8a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170831))
- [Group filtered search: Fix bg and border color](https://gitlab.com/gitlab-org/gitlab/-/commit/bd2ca5ac8a34c6a8ff94f6dcabdf8e9c6fadf579) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170564))
- [Unmark project as pending delete if user lacks delete access](https://gitlab.com/gitlab-org/gitlab/-/commit/3acced9dc63ba0203020c55e2e3a990c89fa6ceb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170770))
- [Remove duplicate banner for scheduled project and group deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/39af98537f9da8de2e8ad6ced57ddf421251c809) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170887)) **GitLab Enterprise Edition**
- [Fix show/hide logic for licenses tap in pipeline view](https://gitlab.com/gitlab-org/gitlab/-/commit/e1a9e898bf1346766b6b7ad8f40ec1406cb0b5ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170903))
- [Fix error when adding quick actions to diffs](https://gitlab.com/gitlab-org/gitlab/-/commit/97cdad1d77a079791aa3d0ea7f75bad1f1c19394) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170913))
- [Fix markdown editor header background](https://gitlab.com/gitlab-org/gitlab/-/commit/ba5514cd93d7ecde1c5626a245453ca7ab36b029) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170993))
- [Catch analytics tracking error during maintenance mode](https://gitlab.com/gitlab-org/gitlab/-/commit/7905c4d9c45b380b01ebe25a1acda83b043a5f22) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170436))
- [Fix redirect after sign in when requesting access](https://gitlab.com/gitlab-org/gitlab/-/commit/66bef6cf063cd3d69f93952bec1a789f8efac59b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170956))
- [Fix unlikely race on previous merge train car](https://gitlab.com/gitlab-org/gitlab/-/commit/baeba63afc02a68e6f213d46bcea33cde7603555) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170953)) **GitLab Enterprise Edition**
- [Make merge trains more robust to ref deletion errors](https://gitlab.com/gitlab-org/gitlab/-/commit/1fddbdf0af8cc5cc1b935d43c87c718226cc5f5b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170932)) **GitLab Enterprise Edition**
- [Update pdf worker file path in pdf viewer](https://gitlab.com/gitlab-org/gitlab/-/commit/5e730185bf39be9e01f5ffa7125934c4e6795793) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170803))
- [Fix work item assignees ordering GQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/5a9d4d01fe1552503902355496d59cba909eb98b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170168))
- [Specify default query sync values for status token](https://gitlab.com/gitlab-org/gitlab/-/commit/6b98a6ef5897b6991f6ba52f552a5ba7e692e7b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170779)) **GitLab Enterprise Edition**
- [Change TailwindCSS darkMode from default to selector](https://gitlab.com/gitlab-org/gitlab/-/commit/ca186280d8d2cf5ac10efcdbd399b76a56a7bfce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170548))
- [Change root namespace for specific projects](https://gitlab.com/gitlab-org/gitlab/-/commit/7ee8c3dceed249b5c5fb725943808b2e816c4099) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170873)) **GitLab Enterprise Edition**
- [Fix directory resolution for Google Cloud runners services](https://gitlab.com/gitlab-org/gitlab/-/commit/2ff3afe60d4d49596bc17e84f1cfabad37dc88ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170161))
- [RefSwitcher: fix support for `%` symbol in reference names](https://gitlab.com/gitlab-org/gitlab/-/commit/4ee4baffd5482ce005117a96f5f17cda38ff9cba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170815))
- [Fix work item icon when conflicted with cache](https://gitlab.com/gitlab-org/gitlab/-/commit/c4e2098282b6e1b4fbd05e72ab0f79f8b51b5993) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170231))
- [Prevent group restoration during deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/26b4424e19ed87dfdef1e4961b5cbb00eea33473) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170774)) **GitLab Enterprise Edition**
- [History rewrite: handle Gitaly errors](https://gitlab.com/gitlab-org/gitlab/-/commit/6de22b2d6d4dc9982c15306ca1293ff2f053e832) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169916))
- [Fix Module deployment in Terraform template](https://gitlab.com/gitlab-org/gitlab/-/commit/597c1872bcfe971e39a8dd3acbcbf4876a5f763b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170759))
- [Update `has_vulnerabilities` when deleting records](https://gitlab.com/gitlab-org/gitlab/-/commit/fc44f83de6a8ac0587dfe886948410b9a9863e6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170642))
- [Add search for a ful path for polices](https://gitlab.com/gitlab-org/gitlab/-/commit/4e7ab11f26a092efc9e4e63128dc5b535e00e8e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170609)) **GitLab Enterprise Edition**
- [Make sure framework selection is updated](https://gitlab.com/gitlab-org/gitlab/-/commit/657600a5b3482d6a7e42032adca71920ce69f887) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170597))
- [Deduplicate issuable_resource_links](https://gitlab.com/gitlab-org/gitlab/-/commit/76d01630efd42d372ff17f468435e8afc67539d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144327))
- [Fix double line number hash on pipeline security tab](https://gitlab.com/gitlab-org/gitlab/-/commit/02d23ce71763ea205317b47f0a3aa483c194ef89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170541)) **GitLab Enterprise Edition**
- [Broadcast message settings: Render message preview](https://gitlab.com/gitlab-org/gitlab/-/commit/fb9e1045fa3a101bf24ee84ef094908888da3950) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170570))
- [Sidebar navigation: Fix skip link position](https://gitlab.com/gitlab-org/gitlab/-/commit/7aa0aff76c52938d93f8e6f5a0d8b8839e9d2f02) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170555))
- [Simplify DropCiPipelinesConfig migration](https://gitlab.com/gitlab-org/gitlab/-/commit/ea95f4545369c640d7dbc5faff2fb4db64559a67) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170540))
- [Fix trial title for duo info card](https://gitlab.com/gitlab-org/gitlab/-/commit/321309b88e9a918314936592405c15915e89e698) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169349)) **GitLab Enterprise Edition**
- [Fix marking CVS vulnerabilities as no longer detected](https://gitlab.com/gitlab-org/gitlab/-/commit/b845703f7f041509bd5ffe6534836a0549e7918d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170465)) **GitLab Enterprise Edition**
- [Pipeline graph: Fix item hover in lightmode](https://gitlab.com/gitlab-org/gitlab/-/commit/24e9e7172264a3400d7d5eccca2d0b5938e40d10) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170409))
- [MR sidebar: Refactor resize handling, remove CSS](https://gitlab.com/gitlab-org/gitlab/-/commit/fa72862ab93c5c7a3073c8e1f518e62e1965ffd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170097))
- [Disable DNS rebinding protection when proxy used](https://gitlab.com/gitlab-org/gitlab/-/commit/4f0eb862f7f1c7551ec5f31b03aeb68a46a3df3d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170392))
- [Retry RepositoryUpdateMirror jobs on failure](https://gitlab.com/gitlab-org/gitlab/-/commit/c2f38efdffd09170313281946f84962ad4033ec7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168349)) **GitLab Enterprise Edition**
- [Fix unneeded right sidebar gap for work item epic page](https://gitlab.com/gitlab-org/gitlab/-/commit/252b5d6c21458ecaacaeba5f9714fca831232bcc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170319)) **GitLab Enterprise Edition**
- [Localize dates on UI](https://gitlab.com/gitlab-org/gitlab/-/commit/1667741675287ef6f8a547d0e430aad3886d771f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170282))
- [Commit note: Fix commit on image styles](https://gitlab.com/gitlab-org/gitlab/-/commit/f81cc6ba50b9d08cec5f8e977bda8c03dc93c4b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169921))
- [Fix comment template button missing from issue child items](https://gitlab.com/gitlab-org/gitlab/-/commit/8375e509e317cc6f8142c266f261c69fb67d6146) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170269))
- [fix: Admin user can see pipeline trigger token from other project](https://gitlab.com/gitlab-org/gitlab/-/commit/7843c7b266bdead12a7a065dec18a26d1c4ec164) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169169))
- [Include LDAP blocked users in user dropdowns](https://gitlab.com/gitlab-org/gitlab/-/commit/957f2dbda33b3e8a374bbdb1cbaef0b7b9c32b6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170263))
- [Notes app: Fix use of shortcut 'r'](https://gitlab.com/gitlab-org/gitlab/-/commit/d2a6005c3df2a663e048b5876243ad847afe0aa7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169936))
- [Fix followees count (only count active users)](https://gitlab.com/gitlab-org/gitlab/-/commit/24d30cec6d9b1fd458015ae7cbce9f8ac68030cd) by @bufferoverflow ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170056))
- [Prevent errors in GraphQL notes type](https://gitlab.com/gitlab-org/gitlab/-/commit/6e4cd5c97082d2deffbcd7b21ce45003c8e106b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170023))
- [Reduce batch size when backing up group wiki repositories](https://gitlab.com/gitlab-org/gitlab/-/commit/dff96cf9a6cef2bb9ee4f8df3cc61d2bb696fd71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170141)) **GitLab Enterprise Edition**
- [Increase precision of Value stream analytics time values](https://gitlab.com/gitlab-org/gitlab/-/commit/a1e2967929c6c335245494987099598742b51670) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170065)) **GitLab Enterprise Edition**
- [Secure Policies list: Fix vertical spacing and delete action](https://gitlab.com/gitlab-org/gitlab/-/commit/45fde79aedb4f12174dc2e182bfc13f0a19ee85b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169947))
- [Fix admin groups page LDAP group links display](https://gitlab.com/gitlab-org/gitlab/-/commit/b3a0d91863897b0b481fda2307021821121fdd19) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169986)) **GitLab Enterprise Edition**
- [Avoid SELECT 1/LIMIT 1 query in credentials inventory](https://gitlab.com/gitlab-org/gitlab/-/commit/83b9d54f0341486cf140e4dc87b5a0d43ba15afb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169962)) **GitLab Enterprise Edition**
- [Fix broken link to doc on project transfer dialog](https://gitlab.com/gitlab-org/gitlab/-/commit/b6c28b7f63dcafb1f0487d9ef2505a6aff379e77) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169955))
- [Remove  from Matrix notify](https://gitlab.com/gitlab-org/gitlab/-/commit/1f2d9661c2f41ba30f891c69d46676b4a9e315f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169577))
- [Fix possible javascript loading order issues with trial widget dismissal](https://gitlab.com/gitlab-org/gitlab/-/commit/e6954d620286284abbeed87ad98276382565be96) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169516)) **GitLab Enterprise Edition**
- [Fix performance of deleting MR approval_rules](https://gitlab.com/gitlab-org/gitlab/-/commit/1a95b761eada6000c36df5d4af2cbb77aa57147b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169622)) **GitLab Enterprise Edition**
- [Widgets: Use chevron lg size as design specs indicate](https://gitlab.com/gitlab-org/gitlab/-/commit/18ba27e91d226ea9164ac220201574a2ffaab7db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170052))
- [Remove policy_scope check to stop N+1 queries](https://gitlab.com/gitlab-org/gitlab/-/commit/9bd4e848335dd9890d06b1cd91184b8d4f04b71b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169911)) **GitLab Enterprise Edition**
- [Fix new project group templates pagination](https://gitlab.com/gitlab-org/gitlab/-/commit/b32e0270788a513215524b4b1a44da4d8b5f321a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169902)) **GitLab Enterprise Edition**
- [Gracefully handle timeouts when counting issues](https://gitlab.com/gitlab-org/gitlab/-/commit/410e2cd8a254da8cc7b4dda7fbc5cdc7d06a6ac0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169391))
- [Skip defering scheduled jobs in concurrency limit client middleware](https://gitlab.com/gitlab-org/gitlab/-/commit/6ab2f72935054df828831a938ddd7ea7c5e57dee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169823))
- [Use text-subtle for secondary text color in autocomplete](https://gitlab.com/gitlab-org/gitlab/-/commit/b556dc391267d2ebacc08f2cd42a1da229854ba4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169811))
- [Security patch upgrade alert: Only expose to admins](https://gitlab.com/gitlab-org/gitlab/-/commit/1f587b1d5b278d72c6c96f27b3d5fd294e202f41) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169273))
- [Add check for CodeSuggestions API](https://gitlab.com/gitlab-org/gitlab/-/commit/36e70973f64a4e7717146f05c7423f25fd0121b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169407))
- [Fix creating of terraform module metadatum](https://gitlab.com/gitlab-org/gitlab/-/commit/1b248d17fb83eaca6c103cfc9ad47779119e8604) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169703))
- [Fixed isNarrowScreen helper to not require specific element](https://gitlab.com/gitlab-org/gitlab/-/commit/633eea24e975a06c60bb3395233b0be24f79da40) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167992))
- [Only delete protected tags if text matches](https://gitlab.com/gitlab-org/gitlab/-/commit/b3b14722f02d8f77ea2afd630172c2df44a501d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169645))
- [Fixed isNarrowScreen helper to not require specific element](https://gitlab.com/gitlab-org/gitlab/-/commit/ade8638b793e7b26a95bfdf9fcd847bd714b1e51) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169261))
- [Fix an intermittent add_on_purchase finding issue with duo trials](https://gitlab.com/gitlab-org/gitlab/-/commit/88b893815246767ea64193aacd9b23453369eb00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169628)) **GitLab Enterprise Edition**
- [Fix work item modal timeline in dark mode](https://gitlab.com/gitlab-org/gitlab/-/commit/ad492e42992a8004d5528edcb6efb8c7c9018fe8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167973))
- [Dont use blob stitcher when finding oversized blobs](https://gitlab.com/gitlab-org/gitlab/-/commit/5f7fad38245cf3c67f5fee47d0cc6070ebb14aaa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169154))
- [Fix two agent authorization UI issues](https://gitlab.com/gitlab-org/gitlab/-/commit/4693163fd0ff9c6e885121f0d09280b962cf2822) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169554)) **GitLab Enterprise Edition**
- [Treat a missing fixed_code block as a false positive](https://gitlab.com/gitlab-org/gitlab/-/commit/8baf9c1651e84ed9d29e8903c40be8d52e740dea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168870)) **GitLab Enterprise Edition**
- [Localize dates on UI](https://gitlab.com/gitlab-org/gitlab/-/commit/bd80a5d231b87b50527e80a9f2bb6220b6aa79d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169509))
- [Show SAML badges for projects under nested subgroups](https://gitlab.com/gitlab-org/gitlab/-/commit/65b33e315ee85e572038ce6b0457102f76a32f8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167218)) **GitLab Enterprise Edition**
- [Rollback related links on partial success](https://gitlab.com/gitlab-org/gitlab/-/commit/01573ab5157cc81978a5c18b6d08d71bdc7893ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168681)) **GitLab Enterprise Edition**
- [PullMirrors::UpdateService: fix a case with not enough provided params](https://gitlab.com/gitlab-org/gitlab/-/commit/01f71f6d4ef05118c61732c8cc1382c0bc9c5af4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169427)) **GitLab Enterprise Edition**
- [Delete orphaned stages](https://gitlab.com/gitlab-org/gitlab/-/commit/5c7dc783cd06360e638a980d506a0fece8e70b80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168750))
- [Don't show note from background item in work item modal](https://gitlab.com/gitlab-org/gitlab/-/commit/87cd2f7157caafd08d8e541abbeb3665faa6685e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169398))
- [Fix admin_mode enforcement in AdjournedProjectDeletionWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/19205b66d636ac7073f74e21e538b9f854e875e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167779)) **GitLab Enterprise Edition**
- [Include project ancestors when determining agent user access](https://gitlab.com/gitlab-org/gitlab/-/commit/99fe229da1a37dbb6fac52a785225b0dd30aef96) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167868))
- [Badges - Migrate to Server Side Pagination](https://gitlab.com/gitlab-org/gitlab/-/commit/0bad0019bd50d981bd7c3fc9436dec0b1ea4a382) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168234))
- [Fix searching in the label filter](https://gitlab.com/gitlab-org/gitlab/-/commit/5f031631659bfaed09084e246c608d9181b2e095) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167624))
- [Fix missing groups in autocomplete](https://gitlab.com/gitlab-org/gitlab/-/commit/ff96c90e03b0f566dcdc7384846624edf62a7840) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169230))
- [Fix container registry tag cleanup schedule visibility](https://gitlab.com/gitlab-org/gitlab/-/commit/9499125d8866d859c64ac931962258d2a43b6bed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168810))
- [Localize dates in epics and roadmaps UI](https://gitlab.com/gitlab-org/gitlab/-/commit/fb1e23b313a7f0026a0d3f23d642ca1205008cae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169161))
- [Remove Manual sort option from issues dashboard page](https://gitlab.com/gitlab-org/gitlab/-/commit/b853bf4b31e9eead72835e4c7beed08de12d3f31) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169158))
- [Have user_ids.size look for greater than or equal to 1 record](https://gitlab.com/gitlab-org/gitlab/-/commit/8815e51dc676a9136378dfe615af968a8f40cc3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169026)) **GitLab Enterprise Edition**
- [Lazy render emoji dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/324d82c9570c232da66671cff3fa74cda2fddb1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168623))
- [Remove &nbsp; on empty task lists](https://gitlab.com/gitlab-org/gitlab/-/commit/b9585df62a40dfd8fb45a5767d3d63f3aadc918b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168250))

### Changed (281 changes)

- [Change yaml format for approval policy](https://gitlab.com/gitlab-org/gitlab/-/commit/4bd4c22c545db5996693fdd84d59ac306d283706) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172312)) **GitLab Enterprise Edition**
- [Move history button into commit box on repository and blob pages](https://gitlab.com/gitlab-org/gitlab/-/commit/127d55ae0a4944ba3a0ea56e99bf8573909085b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172632))
- [Disable scan_execution_pipeline_concurrency_control ff](https://gitlab.com/gitlab-org/gitlab/-/commit/31d311be0c1bcd4ccea176d5eacddb3024455b0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173047)) **GitLab Enterprise Edition**
- [Disable ViewComponent deprecation warnings in production](https://gitlab.com/gitlab-org/gitlab/-/commit/60e9e83d5357b82f2784e56cbcaeee94669ddc8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172924))
- [Change yaml format for vulnerability management policy](https://gitlab.com/gitlab-org/gitlab/-/commit/21dceddfaa6fb0a317670b2783fd8ec743069152) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172911)) **GitLab Enterprise Edition**
- [Refactor notes quick action handling](https://gitlab.com/gitlab-org/gitlab/-/commit/1889ea9efb6b6b00b971fe08c39d9f9d28164c03) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172179))
- [Prevent missing records in Direct Transfer when Sidekiq restarts](https://gitlab.com/gitlab-org/gitlab/-/commit/e248bfab819d7cee880d16c1f9a0a84e328d1611) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172568))
- [Update framework detail text on audit events](https://gitlab.com/gitlab-org/gitlab/-/commit/194dd958553d87415ed849ceaf7ba02fbf6808f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172850)) **GitLab Enterprise Edition**
- [Fix broadcast message dismissal for Omniauth/SAML](https://gitlab.com/gitlab-org/gitlab/-/commit/2123ae32c6be2f4b71025967641794f039d96726) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171332))
- [Change yaml format for pipeline execution policy](https://gitlab.com/gitlab-org/gitlab/-/commit/a280ff74ad7650828ffa169cff7e660f4ef962a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172868)) **GitLab Enterprise Edition**
- [Initial checkin for Admin Duo Home Page](https://gitlab.com/gitlab-org/gitlab/-/commit/66630e191a7acede585c4a218bd7abdef97b214e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168454)) **GitLab Enterprise Edition**
- [Add ids argument to a group resolver](https://gitlab.com/gitlab-org/gitlab/-/commit/add35204107573eecbf570066ebecf37bfcb429d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172453))
- [Handle mailmaped emails for verified gpg signed commits](https://gitlab.com/gitlab-org/gitlab/-/commit/f44f805ef98061f40d9a1d71544d17f8457ce6c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172792))
- [Allow LLMs to return a full resource definition](https://gitlab.com/gitlab-org/gitlab/-/commit/8eec5cb336b59c85a9de504061a44f978ef121c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172834))
- [Small visual updates to glql UI](https://gitlab.com/gitlab-org/gitlab/-/commit/ff4b76ce357dd20e155af61949fcb2bc97971939) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172147))
- [Enable ai_commit_reader_for_chat feature flag by default](https://gitlab.com/gitlab-org/gitlab/-/commit/d35fc8d54cfa72042778ff0429e72f938d894070) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172818)) **GitLab Enterprise Edition**
- [Update edit blob to use commit change modal](https://gitlab.com/gitlab-org/gitlab/-/commit/3d369ee9865ba7c1b2f1ca16f32ae91cbbc4ad45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170512))
- [Collapse Pipeline section when empty on load](https://gitlab.com/gitlab-org/gitlab/-/commit/dcc5c6cdbd9bef89a91b16cb102f8f85efd72913) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171851)) **GitLab Enterprise Edition**
- [Validate sharding constraint on p_ci_stages](https://gitlab.com/gitlab-org/gitlab/-/commit/5ba522fa46848a3fd9776f4eb9ce8f315dd5ec1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170500))
- [AI-Resolution: Add public project warning](https://gitlab.com/gitlab-org/gitlab/-/commit/4b640122d3b57f6b6106ae81d0424950ab1dc28e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172280)) **GitLab Enterprise Edition**
- [Remove search and allow text input for job token allowlist](https://gitlab.com/gitlab-org/gitlab/-/commit/84eb3e688d878712cfa4510ba5bdc1eda6d87007) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171659))
- [Put inline blame behind feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/eca111ad2dc685c6c5c9aee4aab033d988ae78e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171249))
- [Updated all audit events to be streamed](https://gitlab.com/gitlab-org/gitlab/-/commit/08581c9c05576ffa3a2d8fcd69b59c4923b06ef1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172757)) **GitLab Enterprise Edition**
- [Replace text-muted class with gl-text-subtle](https://gitlab.com/gitlab-org/gitlab/-/commit/4caee1cbd1399a5b0f1683e0b2925aad01c1c98f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172484))
- [Synchronize prepared security policy indexes](https://gitlab.com/gitlab-org/gitlab/-/commit/99d4e8b5f8c01c473ea7657ccd76b3d1f2b81db4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169442))
- [Remove enable_adherence_check_for_scanners feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b099360d2cf3b301aa441a017316d4029e4a8537) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172352))
- [Remove unused policy helper property](https://gitlab.com/gitlab-org/gitlab/-/commit/51cb9e00cd29e3c4149d54da9307f7c2bac2cac4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172182)) **GitLab Enterprise Edition**
- [Update User Cap settings message](https://gitlab.com/gitlab-org/gitlab/-/commit/4f8a27d06a7deb0ae2ef542609c18556f8603042) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172346)) **GitLab Enterprise Edition**
- [Change yaml format for scan execution policy](https://gitlab.com/gitlab-org/gitlab/-/commit/ff9625bc07830ee5ca9996dd4902056d64ea6954) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170470)) **GitLab Enterprise Edition**
- [Fix discover page breadcrumbs title](https://gitlab.com/gitlab-org/gitlab/-/commit/d92500d5399b16e0b01bc8dd5f4f638c07c18a28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172569)) **GitLab Enterprise Edition**
- [Update decompose approvers](https://gitlab.com/gitlab-org/gitlab/-/commit/af2022f23556c82fb092193092630574f806c60d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172549)) **GitLab Enterprise Edition**
- [Model registry: Allows directories in MLflow artifacts](https://gitlab.com/gitlab-org/gitlab/-/commit/f9e7eb2b28a46ee017e7e2b24bf11bd356c4659a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172524))
- [Allow project transfer with tags conditionally](https://gitlab.com/gitlab-org/gitlab/-/commit/4de3c7debfe81b368cf1f0e8d12c6dcad5809bbe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171036))
- [Clean up ai_build_reader_for_chat feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/c905b77f1f4d1898f12af70a3e41b09adaeb9024) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172488)) **GitLab Enterprise Edition**
- [Update outdated links](https://gitlab.com/gitlab-org/gitlab/-/commit/d702a6ec302856b272fc7e2957ffc195f32b9303) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172361))
- [Enable FF enable_add_on_users_pagesize_selection by default](https://gitlab.com/gitlab-org/gitlab/-/commit/acbf06eb5c4e08bd96f15409b5c04693f8dbf8ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172444)) **GitLab Enterprise Edition**
- [Initial checkin for Groups Duo Home Page](https://gitlab.com/gitlab-org/gitlab/-/commit/68913f361cb754b566e782b2caece0e65fc9a23d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169498)) **GitLab Enterprise Edition**
- [Remove search and allow text input for job token allowlist](https://gitlab.com/gitlab-org/gitlab/-/commit/b8c7b7a23a9107e49eca69d70caf3168b8f0df09) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171544))
- [Clean up gitlab_ci_archived_trace_consistent_reads feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b38b9bd2dfd3d5898f5c108bb8fe676ee9333ff5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172424))
- [Update Admin Dashboard to fetch KAS version from KAS](https://gitlab.com/gitlab-org/gitlab/-/commit/58cfec4c10ea994f25e6c3fddea984b523972761) by @choznerol ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164613))
- [Move creator_id LFKs to routing table ci_runners_e59bb2812d](https://gitlab.com/gitlab-org/gitlab/-/commit/1c4e090c7b6c5d762df79c6712a20af7c7977b55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172377))
- [Migrate text variables to design tokens in sidebars](https://gitlab.com/gitlab-org/gitlab/-/commit/b2483888587c02a97a1517d83faa7f7ac8328f3d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171698))
- [Make memberships import optional](https://gitlab.com/gitlab-org/gitlab/-/commit/86b4bbdd93dadb5414b19fd7527d71a64d0e4dd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166658))
- [Require projects to be associated to an organization](https://gitlab.com/gitlab-org/gitlab/-/commit/f7557c2e74f8d9de1baf1d2e7f0e12b7168b0881) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172217))
- [Re-route pmg dropdowns to GraphQL version](https://gitlab.com/gitlab-org/gitlab/-/commit/be4f4da687ff23c04afd0d73f5cbf9ab87b32b77) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171862))
- [Improve VSD and AI analytics dashboards panel titles](https://gitlab.com/gitlab-org/gitlab/-/commit/1897e03888e532a7df378fde5db34a6040ecfc7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172300)) **GitLab Enterprise Edition**
- [Error page: use a user friendly error page for ResourceExhausted errors](https://gitlab.com/gitlab-org/gitlab/-/commit/3291d95278d78f9de85af24424f143820287d202) by @divyamtayal ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169039))
- [Remove FF batched_redis_updates_for_kubernetes_agent_events](https://gitlab.com/gitlab-org/gitlab/-/commit/ad79c662dcef325994b5ca0c8bbf310bde75fb57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172038))
- [Update jwt gem to 2.9.3](https://gitlab.com/gitlab-org/gitlab/-/commit/e964c6c0420cdd30054bd9df0dd615ce58babf20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172279))
- [Migrate your work MR dashboard to use Crud component](https://gitlab.com/gitlab-org/gitlab/-/commit/d3367345a167cef9aa906c71d0b517bab045591b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168980))
- [Remove collapse_card.scss stylesheet](https://gitlab.com/gitlab-org/gitlab/-/commit/32faba45616826353bbe7fb3d99fd0259f52878e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172225))
- [Enable reviewer_assign_drawer feature flag by default](https://gitlab.com/gitlab-org/gitlab/-/commit/92204bc98ce789feec388b70bd39fe0dc9eeb44c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171690))
- [Improve layout of workspace items](https://gitlab.com/gitlab-org/gitlab/-/commit/98f2b00c2632aedb4c17b439d5abcd5951f55e16) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163093)) **GitLab Enterprise Edition**
- [Remove old format for action approvers](https://gitlab.com/gitlab-org/gitlab/-/commit/52e5f6589f7ce18ead306dd2f71728ddb4a2b508) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172170)) **GitLab Enterprise Edition**
- [Enable scan_execution_pipeline_concurrency_control FF](https://gitlab.com/gitlab-org/gitlab/-/commit/04f9c3eb56be1510dce618736cb61a9f8727bde0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172158)) **GitLab Enterprise Edition**
- [Add user ssh and gpg system signatures using signature author email](https://gitlab.com/gitlab-org/gitlab/-/commit/6da096b6ce786b57dc5a3aad6d3750a329feba09) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171259)) **GitLab Enterprise Edition**
- [Allow interrupted RelationBatchExportWorker to bypass limit](https://gitlab.com/gitlab-org/gitlab/-/commit/2d9b7645ec6700162039f43c54b3d17f1768a0cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171977))
- [Model registry: Change create button](https://gitlab.com/gitlab-org/gitlab/-/commit/60cf886150111cb3fa3df8fd71ac306fc184f842) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171938))
- [Ensure ID uniqueness for p_ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/0c42e62b5e9d1a09e1c9103084bb92dc66bec2ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164707))
- [Create separate tables for group SCIM](https://gitlab.com/gitlab-org/gitlab/-/commit/acf530da8cc803f071dce56c1200ad8edc7c2393) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171378))
- [Update audit event scope when a group disables 2FA for a user](https://gitlab.com/gitlab-org/gitlab/-/commit/20f7c0bf098d4aca27cf751832b79344eda5fe08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171988)) **GitLab Enterprise Edition**
- [Remove subscriber code from zoekt update used bytes worker](https://gitlab.com/gitlab-org/gitlab/-/commit/dd2649229137f47f6d7313d9c1f0abad5b2f9e3d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171993)) **GitLab Enterprise Edition**
- [Use latest tanuki_emoji gem](https://gitlab.com/gitlab-org/gitlab/-/commit/b81c66c3b4573a20fb29982499adc4c310aff455) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171446))
- [Drop requires_credit_card_verification column](https://gitlab.com/gitlab-org/gitlab/-/commit/3cf2e3daf00060260bf26aac143cdfe993be551c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171859))
- [REST API: deprecate old pull mirror configuration process](https://gitlab.com/gitlab-org/gitlab/-/commit/affb12fe3fbcb8ebec816bb1b6b32dc5cf03ad64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169908)) **GitLab Enterprise Edition**
- [Improve formatting of geo:status Rake task](https://gitlab.com/gitlab-org/gitlab/-/commit/3fddf023555a0d5a5cdc3bfac09f1cdad036ff2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171179)) **GitLab Enterprise Edition**
- [Update opt-in email copy and remove deprecated language](https://gitlab.com/gitlab-org/gitlab/-/commit/f9d532aa15393d9b4f3cd755df235e8b393cc8c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171608)) **GitLab Enterprise Edition**
- [Show warning about importing memberships when user namespace is selected](https://gitlab.com/gitlab-org/gitlab/-/commit/d5b1cfc257e3ed3c629fe17e43940f85802371fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171402))
- [Refactor auditor subclasses to their bounded contexts](https://gitlab.com/gitlab-org/gitlab/-/commit/e84a3055bdf717f1e2f14a07c4ee5a6fb9313ab3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170501)) **GitLab Enterprise Edition**
- [Remove cross-join from vuln stat adjustment](https://gitlab.com/gitlab-org/gitlab/-/commit/29fe9b5f68c354ba1dfb4a206acff2069f5538bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171830)) **GitLab Enterprise Edition**
- [Add timeout handling for release evidence workers](https://gitlab.com/gitlab-org/gitlab/-/commit/adb16c686a28cfd4581d55c7af67be527cda8eef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171011))
- [Add user ssh and gpg system signatures using signature author email](https://gitlab.com/gitlab-org/gitlab/-/commit/947c12ea10171f95bb82835e4d4b0dc284545e81) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171259)) **GitLab Enterprise Edition**
- [Extract approvers mapping method to utils](https://gitlab.com/gitlab-org/gitlab/-/commit/815c9e6e6457b258f93a9c99a06cacd1330642ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171933)) **GitLab Enterprise Edition**
- [License Scanning metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/58b7203025f1f50fc2e25952be6853ee7d17eabb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169401)) **GitLab Enterprise Edition**
- [Enhance model registry and experiments permissions](https://gitlab.com/gitlab-org/gitlab/-/commit/e24beb46edb336a23d4a3af522ee79afcb930904) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171501))
- [Keep search enabled for namespaces with evicted zoekt indices](https://gitlab.com/gitlab-org/gitlab/-/commit/6a0114fa84354ecd741a69c8355efcd4f07cd96c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171545)) **GitLab Enterprise Edition**
- [Add user to organization after group/project access request is approved](https://gitlab.com/gitlab-org/gitlab/-/commit/174a78a8a67e65814669f15d3149c817f85ecdea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171513))
- [Run CVE Enrichment worker once an hour](https://gitlab.com/gitlab-org/gitlab/-/commit/dade3d3a9747e539ad1cb73f5a58788fba5695f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171907)) **GitLab Enterprise Edition**
- [Remove cross-join from snapshot calculator](https://gitlab.com/gitlab-org/gitlab/-/commit/e86785acae6f8fff7eef8cd68327c4bee91aac61) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171846)) **GitLab Enterprise Edition**
- [Project sidebar: Migrate color classes to design tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/2be5f8dc396450a4cda1e384a948f16bfa2d01fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171717))
- [Remove autocomplete_group_search_optimization feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b0b540b57fa1527f527acbe748f21a55b0c9e9fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171898))
- [Remove feature flag to rollout code generation](https://gitlab.com/gitlab-org/gitlab/-/commit/c05c66d5498c79619a55c4d80c4dc2a9d44379b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171711))
- [Add multiple approval action support](https://gitlab.com/gitlab-org/gitlab/-/commit/27516f8c4a2aff667b3fbd6f9a735a0bdc68ad84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168297)) **GitLab Enterprise Edition**
- [Update vertical spacing of project settings](https://gitlab.com/gitlab-org/gitlab/-/commit/634e5d51b25d16589ec7c41737d534bd6e497cd5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171432))
- [Update zoekt index storage reservations](https://gitlab.com/gitlab-org/gitlab/-/commit/ac7adfbc28bd2759ed1723f907dc42896f6d3f0d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168462))
- [Update link size in time tracking](https://gitlab.com/gitlab-org/gitlab/-/commit/18bb6449898bdf015b39c9edc3bf5a16daa2fd0b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171850))
- [Diff file too large warning: Migrate to design tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/020813282af2faf76a9bee40e247321af0c84c92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171514))
- [Avoid setting spent at value from the frontend when creating a timelog](https://gitlab.com/gitlab-org/gitlab/-/commit/eec2285b153721f02ef62bd8fce9015710477129) by @zillemarco ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171373))
- [Update pages custom domains](https://gitlab.com/gitlab-org/gitlab/-/commit/8fa7c2845811d937d075d30800ee5d44a1bf453c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170888))
- [Add backend validation for multiple actions](https://gitlab.com/gitlab-org/gitlab/-/commit/358a0afaf093248e5aba16e1bfbc8d8e8fe2bba0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171389)) **GitLab Enterprise Edition**
- [Add actor for CreatePipelineWorker FF check](https://gitlab.com/gitlab-org/gitlab/-/commit/03945ceeb16a8bcee498b15b3081131ccba74efe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168922)) **GitLab Enterprise Edition**
- [Cleanup cte_for_group_search_access_level Feature Flag](https://gitlab.com/gitlab-org/gitlab/-/commit/ce05a11b263d21ae5d1d11026f403a3b24408e29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171822))
- [Cleans up duo_chat_use_tool_input](https://gitlab.com/gitlab-org/gitlab/-/commit/5fb1067f8c79869cfcdff9bf7131f36667e4245a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171803))
- [Sync FK for p_ci_builds.upstream_pipeline_id](https://gitlab.com/gitlab-org/gitlab/-/commit/fb2350366500869537c003de2e9bdb144cd38094) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171800))
- [Model registry: Enhance model create flow](https://gitlab.com/gitlab-org/gitlab/-/commit/cb2d0def2c7a87598f703cbf62acf1e220c65cfa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171370))
- [Log TriggerIndexingWorker task argument for debugging](https://gitlab.com/gitlab-org/gitlab/-/commit/a0dea2e2e705eea338c6cff954049d0a64175ec5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171791)) **GitLab Enterprise Edition**
- [Add remaining changes to topics](https://gitlab.com/gitlab-org/gitlab/-/commit/884e581c6b63c19872f64251e9eff9583ba3dd76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165066))
- [Remove search_project_query_builder feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/dafe5ae94a40b2e63fd407fe853a07ccc457a162) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171312)) **GitLab Enterprise Edition**
- [Remove feature flag no_locking_for_stop_actions](https://gitlab.com/gitlab-org/gitlab/-/commit/95194c5ededaa866773bdb76ab2f82ccedabef1b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171708))
- [It adds a new Keep to change worker data consistency](https://gitlab.com/gitlab-org/gitlab/-/commit/5325b7035f24e8d2d3ee59ca214844aed310224b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167993))
- [Improve standard role type](https://gitlab.com/gitlab-org/gitlab/-/commit/8277b648e3f2360e877f71785a2ae11ea704719b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170013)) **GitLab Enterprise Edition**
- [Update breadcrumbs and page headers](https://gitlab.com/gitlab-org/gitlab/-/commit/cbf63777c7942f5d33c2826eac92b21da8deddee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171025))
- [Post bot message for fail-open violations](https://gitlab.com/gitlab-org/gitlab/-/commit/06684430b6484687ef32842c7100d1195c25ec6f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168844)) **GitLab Enterprise Edition**
- [Cleanup v2_chat_agent_integration feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/32daf3535d25c7b1e885c760e4d6cf353e977c20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171631))
- [Use devise authenticate_user! for search controller](https://gitlab.com/gitlab-org/gitlab/-/commit/d2fb982c5c226ea80edabdc5d720ffea7b4a8a23) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171368))
- [Refactor ci templates page](https://gitlab.com/gitlab-org/gitlab/-/commit/d55fa4e490a479e763cf255722091fb7f841ad04) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170016))
- [Send emails on bulk user duo seat assignment](https://gitlab.com/gitlab-org/gitlab/-/commit/74a8c931f3869ee9991df67e827c43c8db017865) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171030)) **GitLab Enterprise Edition**
- [Update breadcrumbs for edit pages](https://gitlab.com/gitlab-org/gitlab/-/commit/3ce57dbb12b2b390d327e9a71f3169c2d4ea3bac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170637))
- [Enhance model registry version creation](https://gitlab.com/gitlab-org/gitlab/-/commit/f1b86b99985ba388c68d372169a7d5d745d8b60b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171388))
- [Extend merge request approval graphql api](https://gitlab.com/gitlab-org/gitlab/-/commit/2a42ec8f3226abeab3b33ac20c11ab2ec5fd2646) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170717)) **GitLab Enterprise Edition**
- [Removed data.js files from filters as part of the code maintenance](https://gitlab.com/gitlab-org/gitlab/-/commit/a73f9a2a77cb72e1c54606b7f5849f45453d9832) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168343))
- [Wells: Update design to match darkmode design direction](https://gitlab.com/gitlab-org/gitlab/-/commit/06a14bc2ec5e0f3730f215c3d0c8c3ac107898ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169570))
- [Add optimization for groups autocomplete](https://gitlab.com/gitlab-org/gitlab/-/commit/e04506f757f5c5564de6b116f567715f3ab87512) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170948))
- [Rollout two feature flags for self-maneged instances](https://gitlab.com/gitlab-org/gitlab/-/commit/995280387a0d7ba366e7f2d28085c62192cb0a6f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171462)) **GitLab Enterprise Edition**
- [Renamed Promotion Management util methods](https://gitlab.com/gitlab-org/gitlab/-/commit/f540bfbe1da5eae36316487f8d8582be31b2d70e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171081)) **GitLab Enterprise Edition**
- [Tree table: Update design for darkmode](https://gitlab.com/gitlab-org/gitlab/-/commit/be5c1b2ecc0b4429e31e48b12c0f14e06c297405) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169579))
- [User Account - Block deletion with org ownership](https://gitlab.com/gitlab-org/gitlab/-/commit/c14da813d0ac0de6d0d13898ad4020b3d32141a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170660))
- [Replace toggle with checkbox in upload file, create dir modals](https://gitlab.com/gitlab-org/gitlab/-/commit/c139e900b87bb09eddaa933ccac6cb443c63a7f3) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168789))
- [Update zoekt index used_storage_bytes on interval instead of callbacks](https://gitlab.com/gitlab-org/gitlab/-/commit/f3d15a6f59052a753837e2d7ef18ac86295183f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168668)) **GitLab Enterprise Edition**
- [Enable license_scanning_with_sbom_licenses by default](https://gitlab.com/gitlab-org/gitlab/-/commit/2835b85f6224f66dbc7edd1e286f8d237679df24) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171307)) **GitLab Enterprise Edition**
- [Add clarifying help text to legacy issueable linked items input](https://gitlab.com/gitlab-org/gitlab/-/commit/33262f198a4563c69292739cce6bfcb5afc733c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170336))
- [Updates text under container image cleanup policies settings section](https://gitlab.com/gitlab-org/gitlab/-/commit/889880148322a7a76087118b83855493ce808a62) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171209))
- [Update semver_dialects gem](https://gitlab.com/gitlab-org/gitlab/-/commit/2231c3029b9c58c61809d1dbf95db4f0938660ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171167))
- [Allow multiple approver actions](https://gitlab.com/gitlab-org/gitlab/-/commit/1d262497294abc47c52dbf58ea0a7cc55cdac77f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166794)) **GitLab Enterprise Edition**
- [Add projects label for exceeding number](https://gitlab.com/gitlab-org/gitlab/-/commit/6c2a8d7cd358bca77bf83d521c112c615b4532a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171342)) **GitLab Enterprise Edition**
- [Use page header component for group members](https://gitlab.com/gitlab-org/gitlab/-/commit/98215d19323005ab1a2f74c45ea7510e0678a7ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171335))
- [Allow users with permission to delete last board](https://gitlab.com/gitlab-org/gitlab/-/commit/363c6e2d9bed7a723fcb1e4be5ae3f1a83d0669b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170317))
- [Model version right sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/7fb1efa8e8d49ca2c119a3c03cc73c57b1fc3fd3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170542))
- [Update contents of empty state without any issues](https://gitlab.com/gitlab-org/gitlab/-/commit/bea178f82027b31d21cc5604ed930fed70dad344) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171171))
- [Update license violation checker for custom software licenses](https://gitlab.com/gitlab-org/gitlab/-/commit/be7d2f974d9a10eacb000fbfd308ab372ba51979) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156405)) **GitLab Enterprise Edition**
- [PA team paper cuts 17.6](https://gitlab.com/gitlab-org/gitlab/-/commit/8de2e8c7b847ec4ea6b62dd39508b7e96fde6888) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169492))
- [Replace `duoProAssignedUsersCount` usage with `duoAssignedUsersCount`](https://gitlab.com/gitlab-org/gitlab/-/commit/cbb00a09505dcdb9446a1a1d6f3553a8292736d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171295)) **GitLab Enterprise Edition**
- [Rewrite HostProbe to use Gitlab::HTTP](https://gitlab.com/gitlab-org/gitlab/-/commit/978e766c47c6183d28c0a904087f9edb9b146cc5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170951)) **GitLab Enterprise Edition**
- [Feature flag clean up for purchase flow migration](https://gitlab.com/gitlab-org/gitlab/-/commit/e5d1b63e366fb5b97512a9904ee0edc298afb6f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170411)) **GitLab Enterprise Edition**
- [Expose signature author email from gitaly](https://gitlab.com/gitlab-org/gitlab/-/commit/7c6f851067ff6389a00c4dc78d3c542ccbce7c6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171258))
- [Initial checkin for Groups Duo Home Page](https://gitlab.com/gitlab-org/gitlab/-/commit/f100a80382fe71105a54a90ed6f6044983e57f97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168295)) **GitLab Enterprise Edition**
- [Allow for `closed_by_id` param in issues API queries](https://gitlab.com/gitlab-org/gitlab/-/commit/2be56f801726a1b652d6906cef2e739a47b29849) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170655))
- [Update admin breadcrumbs and page headers](https://gitlab.com/gitlab-org/gitlab/-/commit/c1a6aff481af20777e7f717035341a5ecf6e82b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170860))
- [Notes: Migrate to section tokens to unbox darkmode](https://gitlab.com/gitlab-org/gitlab/-/commit/4466aa36bae2e882d2375af0fcb426d2a9e32dc7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170543))
- [Update layout of alert header](https://gitlab.com/gitlab-org/gitlab/-/commit/48592435ba8d5f1a0b0781ad4c7219a4a3632484) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171168))
- [Add migration for setting Namespace organization_id to 1](https://gitlab.com/gitlab-org/gitlab/-/commit/46cc5315d4fab1faadac9bee0c43029c0e4453e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170997))
- [Job log detail line number: Migrate text value](https://gitlab.com/gitlab-org/gitlab/-/commit/0a029d78a35c967e41c5a3243b5951756e62cf1c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171129))
- [Use elastic retry setting for search requests](https://gitlab.com/gitlab-org/gitlab/-/commit/2a6fddae8ff0bd725bcbc2332828c0c92405d3bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170572)) **GitLab Enterprise Edition**
- [Remove FF prevent_job_token_admin_permissions](https://gitlab.com/gitlab-org/gitlab/-/commit/b21f2bd4bf194e4194313a8eff54823c5716bcd4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169149))
- [Show release notes on deployment approval page for tagged deployments](https://gitlab.com/gitlab-org/gitlab/-/commit/e36ab700ef980e63feba40e0ec7bf136a5925f51) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169830)) **GitLab Enterprise Edition**
- [Modify text for scheduled policy scan concurrency](https://gitlab.com/gitlab-org/gitlab/-/commit/211045487fc478c702197be5a8dc1485fd4225eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170783)) **GitLab Enterprise Edition**
- [Use lowercase text for environment badges](https://gitlab.com/gitlab-org/gitlab/-/commit/36cde1410d2a2b6706598ca96b353883ca138755) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171033))
- [Use calendar-overdue for past due dates](https://gitlab.com/gitlab-org/gitlab/-/commit/ba8ec0e47cc5817e66d1601e4ddade6283d4366e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167370))
- [Update layout of edit application page](https://gitlab.com/gitlab-org/gitlab/-/commit/3646eb584fca2f3c17a7bd7600fdca5ecaca30c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170858))
- [Add multiple approvers action support](https://gitlab.com/gitlab-org/gitlab/-/commit/2980c5ee7d5b0491f2bcf6bf33b93fa4a3e376c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168583)) **GitLab Enterprise Edition**
- [Changed Global Search modal scoped search position](https://gitlab.com/gitlab-org/gitlab/-/commit/b07ffc0d5097e64d0da646ba0f8fd8f71ed73f72) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169780))
- [New runner page: Use PageHeading component](https://gitlab.com/gitlab-org/gitlab/-/commit/6c78b23fec1a25d06e63182f228158eb497061d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170804))
- [Adjust report abuse layout](https://gitlab.com/gitlab-org/gitlab/-/commit/e443306c8cb24da9576dfd566ccdc062ee680543) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170855))
- [Update false positive have uniform text size](https://gitlab.com/gitlab-org/gitlab/-/commit/7e3f413eb01d8def4699807c4ab3cafa763f435a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170952)) **GitLab Enterprise Edition**
- [Update embedding developer docs](https://gitlab.com/gitlab-org/gitlab/-/commit/7fcda2cbd8e120f4deaacb163c1affcfb6368dc8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170581)) **GitLab Enterprise Edition**
- [Refactor pipeline editor drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/0890d3c8a89eb1120d435cbd715f362290303794) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170001))
- [Model registry: Improve model listing](https://gitlab.com/gitlab-org/gitlab/-/commit/1beb9ac93e782c723cd4f6848ae5e68ebe4bb932) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170276))
- [Replace prop drilling in pipelines.vue with provide/inject pattern](https://gitlab.com/gitlab-org/gitlab/-/commit/173ab0d11158d9d832d6f90b957f08571a145e65) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170906))
- [Add link to Epic modal trigger button](https://gitlab.com/gitlab-org/gitlab/-/commit/7dbc9e7a9e52741d724c19b02056d5dfdadc059c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168777))
- [Add instance setting to enforce CI job token scope](https://gitlab.com/gitlab-org/gitlab/-/commit/c5db6d1f931607f1ba173a17fe848efa66f2416f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170232))
- [This MR cleans out feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/0940d14e9556f52bae481dfe2a342d4f829b5acc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165870)) **GitLab Enterprise Edition**
- [Update layout of admin edit project page](https://gitlab.com/gitlab-org/gitlab/-/commit/24ea9c7b48a79da3593e3be73b6f14bddccd814f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170826))
- [Adds migration to make file_checksum colmumn nullable](https://gitlab.com/gitlab-org/gitlab/-/commit/cbe73c462b249e9bebd283f01bc43b5e08bbc241) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169920))
- [Job page: Migrate to use design tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/265144e6b29359f121e8d8bc22ee895f96b9117f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170398))
- [Move WorkerDataConsistency inline disables to external file](https://gitlab.com/gitlab-org/gitlab/-/commit/33153cacc444a9c1d813a96cab40f48e7c8974bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167337))
- [Improves custom email verification SMTP error logging](https://gitlab.com/gitlab-org/gitlab/-/commit/d27ab1307e526b2d8e96eb087857c47d417acb55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169728))
- [Remove feature flag `async_rewrite_history`](https://gitlab.com/gitlab-org/gitlab/-/commit/2ad9140855a541ffdecad4083fcfe640913dcde9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169888))
- [Add slash command GraphQL query for Duo Chat](https://gitlab.com/gitlab-org/gitlab/-/commit/46872ad0c856de80e1f1294a3f46a318fd83479c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169641)) **GitLab Enterprise Edition**
- [Replace `span` element by `button` in the group dependencies to fix a11y](https://gitlab.com/gitlab-org/gitlab/-/commit/112b1f5b09f2353895309d38bbbae4e22fff80a4) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170644)) **GitLab Enterprise Edition**
- [Drop the editor feild from the workspaces table](https://gitlab.com/gitlab-org/gitlab/-/commit/d2924145f440489f4aaa8104bd237adc8448f37c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167823)) **GitLab Enterprise Edition**
- [Fix alignment of actions in requirements drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/35dea2b383be47866313ac1d7a4c0fea20abdaad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170635))
- [Replace GlSegmentedControl with a more modern component with better UI](https://gitlab.com/gitlab-org/gitlab/-/commit/30f76a1f294c97d78adabea5cd23256db0270f06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170594))
- [Improve regexp for system note email obfuscation](https://gitlab.com/gitlab-org/gitlab/-/commit/4e07a7ea87aa73055a7d764573dd6d56c5ed57ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169165))
- [Wiki form: Don't disable submit button](https://gitlab.com/gitlab-org/gitlab/-/commit/6859d11fafc72d9febaf25c8f30948a3c64dce74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170561))
- [Add policy type for breadcrumb](https://gitlab.com/gitlab-org/gitlab/-/commit/863a4a06792232509fd1b0cdbf11c706db5a3760) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168970)) **GitLab Enterprise Edition**
- [Adds application setting for elasticsearch retry on failure](https://gitlab.com/gitlab-org/gitlab/-/commit/fbdb921ee995ac97a8446bc331e8e961456354cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169903)) **GitLab Enterprise Edition**
- [Enhance model registry model version deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/f1a3d6dada8f8fc5346da06ce494dd31d4cfa826) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170210))
- [Add organization_id to oauth_device_grants table](https://gitlab.com/gitlab-org/gitlab/-/commit/5784d3658019d7ccf0e221dc8e92e00b9b1d4e93) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170391))
- [Update Duo troubleshooting docs](https://gitlab.com/gitlab-org/gitlab/-/commit/0fe577d5d49edad2522f9efdb43ed4221c062b22) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170384))
- [Restore scheduled deletions if the user loses group/project access](https://gitlab.com/gitlab-org/gitlab/-/commit/e6579622695fb50389bda8cd2f7cdf593410830c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165963)) **GitLab Enterprise Edition**
- [Enhance model registry model deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/a313788a04efc56742ebe2df0c3d6c99eb1ff7ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170211))
- [Set zoekt enabled namespaces to have search enabled by default](https://gitlab.com/gitlab-org/gitlab/-/commit/1efc19bf3fc91767a39dd477164c8601334e11f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170480)) **GitLab Enterprise Edition**
- [Remove transition animation of copy code button](https://gitlab.com/gitlab-org/gitlab/-/commit/3b4f7691908a5c814e53ef23a104512fc62d74af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170478))
- [Add edit text to edit snippet breadcrumbs](https://gitlab.com/gitlab-org/gitlab/-/commit/c88c93d678a2dc15ec173e225838dde4dff07907) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170157))
- [Clean up the UI for the protected environments settings](https://gitlab.com/gitlab-org/gitlab/-/commit/28c9939ee36616ae719847f6a146e023f03af62d) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169757)) **GitLab Enterprise Edition**
- [Index work_item embeddings](https://gitlab.com/gitlab-org/gitlab/-/commit/87dc78309b83cad17c0ecee27e0ebc3de6fa8198) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169260)) **GitLab Enterprise Edition**
- [Adjust Bulk create/remove limit for up to 100 assignments](https://gitlab.com/gitlab-org/gitlab/-/commit/8154d248b42d415b2b94cc53b4df15e1ed594fe4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170150)) **GitLab Enterprise Edition**
- [Enabling group_level_dependencies_filtering_by_component by default](https://gitlab.com/gitlab-org/gitlab/-/commit/1cef27de0998eb52f4691e98bd067283fb3ac97b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170453))
- [apps/settings: Extend maximum token and SSH key expiration to 400 days](https://gitlab.com/gitlab-org/gitlab/-/commit/dc4177b1d3e6bdcb731ecc7e2969cf0f8291d6fc) by @ben.boeckel ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153876))
- [MR widget: Migrate to use design tokens to update darkmode](https://gitlab.com/gitlab-org/gitlab/-/commit/6c82986a5659bd75cd9531dab4c35fc1ef7ff0da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169597))
- [Remove cross join exception](https://gitlab.com/gitlab-org/gitlab/-/commit/c10ae321e3adef890a1a447bdd32e2ab962dcf32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169558)) **GitLab Enterprise Edition**
- [Model registry: Improve model version listing](https://gitlab.com/gitlab-org/gitlab/-/commit/472cea564d3db58ea732876d1d4421db5645dd08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169448))
- [Default enable ff_pages_use_open_file feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/7a602a1941bdaa5a77e138ec10de2137010de4df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169952))
- [Secure policies edit: Move delete action to right side](https://gitlab.com/gitlab-org/gitlab/-/commit/023e6ade1c8f8e71d4f05a9c7546fc0a72a810e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169943))
- [Fix links in pipeline editor helper](https://gitlab.com/gitlab-org/gitlab/-/commit/b5cdb8009994a1884c92d6a6d2b4e57f3468f976) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170378))
- [Finalize BackfillRootNamespaceClusterAgentMappings migration](https://gitlab.com/gitlab-org/gitlab/-/commit/c9cd32f09398d7fb80aa752b35fbb4c6764f3a2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170341))
- [Always search through zoekt replicas](https://gitlab.com/gitlab-org/gitlab/-/commit/08d4b70624e677fc36079c69fd286a7d83978e7c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168427)) **GitLab Enterprise Edition**
- [Move model registry model editing from modals into forms](https://gitlab.com/gitlab-org/gitlab/-/commit/9b1f421c458a1c931f18b7657e8226a190e4acab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169818))
- [Increase zoekt bytes limit to 450 GB](https://gitlab.com/gitlab-org/gitlab/-/commit/2e72cc3420688ad77e3bf46d42bc0bd681ab3f1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170164)) **GitLab Enterprise Edition**
- [Increase zoekt indexing timeout](https://gitlab.com/gitlab-org/gitlab/-/commit/2f1ab58ba2cdf878f2d3fb27ec128943b78622ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170162)) **GitLab Enterprise Edition**
- [Improve security policy comparison before persisting](https://gitlab.com/gitlab-org/gitlab/-/commit/f6ac5ff4c555adec1e508b2176d6f36c96a3b909) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169174)) **GitLab Enterprise Edition**
- [Update empty policy list page svg](https://gitlab.com/gitlab-org/gitlab/-/commit/963ad5545251afe6354ff439756170ffcc4470b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170271)) **GitLab Enterprise Edition**
- [Disable add action button when limit is reached](https://gitlab.com/gitlab-org/gitlab/-/commit/b189041c366d6dbb0eb0187b34e28f06e48acfe3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169953)) **GitLab Enterprise Edition**
- [Deprecate `force_push_regex` and `delete_branch_regex` from push_rules](https://gitlab.com/gitlab-org/gitlab/-/commit/1c586e1351f868c47f6bf4886bf27495791ddf10) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170266)) **GitLab Enterprise Edition**
- [Pipeline editor: Replace the commit confirmation alert with a toast](https://gitlab.com/gitlab-org/gitlab/-/commit/776adf4a5172bcbc925824f0624551260e05f439) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168672))
- [Editor: Use design tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/474e849b5982112431ead288ff46500f7e5c415c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170256))
- [Sidebar nav: Change background in darkmode](https://gitlab.com/gitlab-org/gitlab/-/commit/f12409003c25aa9aa3a14cebaeb3e0649d9b13ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169573))
- [Add name to paths in edit label and milestone pages](https://gitlab.com/gitlab-org/gitlab/-/commit/16ebd3a72ba43068e2fe62eb48c72e1bbd283409) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170160))
- [Increase create work item toast delay](https://gitlab.com/gitlab-org/gitlab/-/commit/85c1272ec810903a6457fe80c119b0e4db41b183) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170015))
- [Model registry: Improve empty version description state](https://gitlab.com/gitlab-org/gitlab/-/commit/6756c98e4f3c31d67802c9d3505552da6deca48a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169572))
- [Expose schedule name](https://gitlab.com/gitlab-org/gitlab/-/commit/d1d9eb80e60a84cb7ae649d165740cc899829936) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169500))
- [Modify the way the zoekt multi-result loads](https://gitlab.com/gitlab-org/gitlab/-/commit/94eaf39d21b64e9f2d9c7a9bd8c41bd22aac708e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167435)) **GitLab Enterprise Edition**
- [Cache user project authorizations for faster autocomplete and search](https://gitlab.com/gitlab-org/gitlab/-/commit/09c31ff25305c1e2e66f5e3c916e1553bf4ca8d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169630))
- [Update blob delete modal](https://gitlab.com/gitlab-org/gitlab/-/commit/9a8161bc94cafec3b10cc54f7df636ab0cde66cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168992))
- [Move model registry model editing from modals into forms](https://gitlab.com/gitlab-org/gitlab/-/commit/340e5061819b747d33a4047656b61cbc4443e9d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169544))
- [Store abuse report labels separate from project/group labels](https://gitlab.com/gitlab-org/gitlab/-/commit/e6dd2472980026114dae8143f790680a3a9a02c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168186))
- [Allow overriding of ingest and query O11y URLs](https://gitlab.com/gitlab-org/gitlab/-/commit/17a5f90441be08fbe6a5d02a8577f1312c23e083) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169439)) **GitLab Enterprise Edition**
- [Swap beta badge component on Self-hosted models page](https://gitlab.com/gitlab-org/gitlab/-/commit/0e57ebc6ae1f57db0ef960aae0209a741013a4d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169778))
- [Define sharding key for `snippets`](https://gitlab.com/gitlab-org/gitlab/-/commit/978f7aa2978597ced644761879e0fc1ea58c2577) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160060))
- [Finalize `ResolveVulnerabilitiesForRemovedAnalyzers` migration](https://gitlab.com/gitlab-org/gitlab/-/commit/fc93d5b86846cabd12532e4b9b21b2bef8df0c1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169339))
- [Adds knn index setting for opensearch clusters for workitem index](https://gitlab.com/gitlab-org/gitlab/-/commit/bdd0c9f4d4867ae6149874ec2f2650ab6e72854b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169560)) **GitLab Enterprise Edition**
- [Show copy action in milestone list](https://gitlab.com/gitlab-org/gitlab/-/commit/095a8a762382d96b7df9b3776a2004e5e7773976) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168868))
- [Add job to run rubocop docs link check in docs pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/e1dc2875eb7c7fb7331f8cba15d3a1504744d5f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169734))
- [Cleanup feature flag ff_compliance_audit_mr_merge](https://gitlab.com/gitlab-org/gitlab/-/commit/6925d2b0a4de95d3b5144f1278bc0e200d364279) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169892)) **GitLab Enterprise Edition**
- [Your work MR dashboard: Align approval badge icon on left side](https://gitlab.com/gitlab-org/gitlab/-/commit/8e1e3a8f6a292d5abc957064a5353d4796c25e71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168960))
- [Allow changing synced work item epics](https://gitlab.com/gitlab-org/gitlab/-/commit/8070812ea33c8cd0d48004fe4457bdaa46c8229d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169875)) **GitLab Enterprise Edition**
- [Update usercap email to use standard email template](https://gitlab.com/gitlab-org/gitlab/-/commit/c3c040cbc932afe3d7f390355d87c4e955d6b25c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169865))
- [Mirror repository email apply standard template](https://gitlab.com/gitlab-org/gitlab/-/commit/a0a77bf1229000cb6af0c9d43c1770d6d2db073b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169859))
- [Remove allow_cross_joins_across_databases](https://gitlab.com/gitlab-org/gitlab/-/commit/cfe5d64af45981f8f19e3dc2b478cd0b4b5b8b3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168348)) **GitLab Enterprise Edition**
- [Groups Projects - Unify Restore UX](https://gitlab.com/gitlab-org/gitlab/-/commit/754f60ae614e060f34c70d90361e88995ed4ccc7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168696)) **GitLab Enterprise Edition**
- [Remove `access_token_pagination` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/1d0142aad67bd12f5562357e873a2eca19be9d9e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169765))
- [Restore opt-in values from temporary table](https://gitlab.com/gitlab-org/gitlab/-/commit/78f57f4b8c1dae45f69bad4377c47c26f123f7c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165155)) **GitLab Enterprise Edition**
- [Add not null constraint on p_ci_stages](https://gitlab.com/gitlab-org/gitlab/-/commit/23539c48a7bf97fefd982dab2bcad840fae9383a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168568))
- [Use search service for project autocomplete](https://gitlab.com/gitlab-org/gitlab/-/commit/aa4f075cccda7027df738417b92bb4151e72942b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169425))
- [Changed placeholder text in global search modal](https://gitlab.com/gitlab-org/gitlab/-/commit/1119741f9d85a6b88d2b79c5cb1ced396fc56c2c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169752))
- [Update delete approval rules query to use index](https://gitlab.com/gitlab-org/gitlab/-/commit/456055d74a174b047c11984d9e06cca666f2429c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169353)) **GitLab Enterprise Edition**
- [Fix rubocop violations from docs links](https://gitlab.com/gitlab-org/gitlab/-/commit/aa5403d5cdfa85c74f2f62a6f71a50df2cf561a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169682)) **GitLab Enterprise Edition**
- [Updated error message when VR MR suggestions can’t be created](https://gitlab.com/gitlab-org/gitlab/-/commit/5fcddce47e87fd03c6abc88a2a62dc406324ca02) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168986)) **GitLab Enterprise Edition**
- [Remove unused table classes in alert details](https://gitlab.com/gitlab-org/gitlab/-/commit/a76f31ca4bf3585fbb9775d09018950c80cadb81) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169424))
- [Add call to action to issue analytics empty state](https://gitlab.com/gitlab-org/gitlab/-/commit/69cc1320fb23457ab2cce2e975ca745485d5bad1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168132)) **GitLab Enterprise Edition**
- [Allow vertically resizing markdown and rich text fields](https://gitlab.com/gitlab-org/gitlab/-/commit/7ba0ae9ee225041eed2e2b25c204e521d41e2bdc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169634))
- [Use routing table name for BuildTraceMetadata model](https://gitlab.com/gitlab-org/gitlab/-/commit/0dc648e18a33931303695dfe36385f4cb88818b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169234))
- [Model registry: Improve empty version description state](https://gitlab.com/gitlab-org/gitlab/-/commit/ecee83d6923274dc04f089c394c856d8fa40d089) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169562))
- [Add title attribute to MR list diff stats](https://gitlab.com/gitlab-org/gitlab/-/commit/6af160ae941b6eb9f70626e929d862e1695581e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169510))
- [Add back refetchQueries to placeholder_actions](https://gitlab.com/gitlab-org/gitlab/-/commit/981584e8202078fab0aa47014ac6a14c2ac01445) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169316))
- [De-emphasize required approvals in sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/a5934d21b009abf69b90a7c53738fbeb48c4c0db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168428))
- [Replace label fuzzy search with exact search for VSD](https://gitlab.com/gitlab-org/gitlab/-/commit/706a08d1cda427ef756d602bcade6f3184cb29c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169073)) **GitLab Enterprise Edition**
- [Transition vulnerability feedback to gitlab_sec](https://gitlab.com/gitlab-org/gitlab/-/commit/079fb26a70038642d935c4171f4ac7c50f11456d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168978)) **GitLab Enterprise Edition**
- [Remove `webauthn_without_totp` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/2dcdda2f62c2a763260b9744b6f5ca69a5d73c3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/116527))
- [Add feature flag for zoekt index circuit breakers](https://gitlab.com/gitlab-org/gitlab/-/commit/7a90836369b4fe1b1f0ee139b68b96d7403d57cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168566)) **GitLab Enterprise Edition**
- [Move model registry UI away from modals into pages](https://gitlab.com/gitlab-org/gitlab/-/commit/42261e4bed235029741ec58845e2a6ebb6faf275) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168935))
- [Backfill project_id on Ci Stages](https://gitlab.com/gitlab-org/gitlab/-/commit/89d91becd29862b828d3ae48085f9abc538fb2a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168135))
- [Crud: Migrate design tokens to use section tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/30ad484740b9395aa515d70a813172988b43df61) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169455))
- [Add organization_id to OAuth tables](https://gitlab.com/gitlab-org/gitlab/-/commit/14c26b5181675aea6e29299e02600bc9064e9ca5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167668))
- [Prepare async fk validation for p_ci_builds.upstream_pipeline_id](https://gitlab.com/gitlab-org/gitlab/-/commit/11317e1aae24a44a65e9a825c9f9caf16b29c14a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169229))
- [Reorder note actions](https://gitlab.com/gitlab-org/gitlab/-/commit/40ee27455ab3e3290531e278f4fa87e3c502fbb8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168578))
- [Sync security_policies when project is added to group](https://gitlab.com/gitlab-org/gitlab/-/commit/07815a4a504fd15f60916013f309c62b7deea173) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168850)) **GitLab Enterprise Edition**
- [Remove error message if replication not enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/1abd53e9a1653ba35567e85bdbbc4a71bb7ff2e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167925)) **GitLab Enterprise Edition**
- [Bump Gitaly gem to 17.5.0.pre.rc1](https://gitlab.com/gitlab-org/gitlab/-/commit/f15a062e13b7f4c0a2eedb2c49c8113e34f0e10b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169279))
- [Implement new Duo Pro trial widget design](https://gitlab.com/gitlab-org/gitlab/-/commit/b7289103751e4f0a328aa367cbdd422b5c400b4f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168790)) **GitLab Enterprise Edition**
- [Update CI templates for Browser Performance Testing](https://gitlab.com/gitlab-org/gitlab/-/commit/800200ee9c543ef64664b9af8fa216212d18a38e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168082))
- [Put Geo::MetricsUpdateWorker behind a feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/601d8b154b2ad7449efe63f94c4b0a76383cdd34) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169346)) **GitLab Enterprise Edition**
- [Remove set_delete_failed_container_repository flag](https://gitlab.com/gitlab-org/gitlab/-/commit/2fa07cdd451e8e7a44f8c90f8cc618149d1ee354) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169040))
- [Remove ci_hidden_variables ff](https://gitlab.com/gitlab-org/gitlab/-/commit/8a6d4bdcd81a733f9d33b5b575544ab1bb5741cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165843))
- [Surface which unspecified stage was incorrectly chosen](https://gitlab.com/gitlab-org/gitlab/-/commit/f0502450334c0434b1d322fb323b9127611c6f3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165998))
- [Show the vulnerability report even if 0 vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/721fa3adf40509596910891566882457a1adc4c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167948))
- [Add the bootstrap command to the agent creation modal](https://gitlab.com/gitlab-org/gitlab/-/commit/b06d8a3727b6cb0da82505979df6b089d3bfcac7) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169188))
- [Improve SBoM search performance with a inverted index](https://gitlab.com/gitlab-org/gitlab/-/commit/9f34616c19ed2744c1a271acf02f4b0de80e3848) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168962))
- [Update empty states on group landing page](https://gitlab.com/gitlab-org/gitlab/-/commit/5cb0140b4510fb1ae99c8fadb246b125dd598abe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168656))
- [Finalize rename of ::Abuse workers to ::AntiAbuse bounded context](https://gitlab.com/gitlab-org/gitlab/-/commit/8e4f8372fbb6b94b32dddf400111af2c3e5aee10) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169198))
- [Rename duoProAssignedUsersCount GraphQL field](https://gitlab.com/gitlab-org/gitlab/-/commit/66d59a54832260d539d87433e91e743aa39a0201) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169105)) **GitLab Enterprise Edition**
- [Back up secrets.yml if it changes](https://gitlab.com/gitlab-org/gitlab/-/commit/2169cb60de57a7aa5b3121485a0b3487466e516e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169024))
- [Update pipeline mini graph upstream/downstream](https://gitlab.com/gitlab-org/gitlab/-/commit/13f3ccf3994a6078fd1d317a49d41bfaf0ef8c66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168567))
- [Require password to delete WebAuthn devices](https://gitlab.com/gitlab-org/gitlab/-/commit/ef824d67b766c95d0baaca9ac1c09c6d18bbaa40) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168976))
- [Work item hierarchy - Prevent dropping in child when type is not allowed](https://gitlab.com/gitlab-org/gitlab/-/commit/e94f02b836ef8289b64fe73d48c91d3993d11e1c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168594))
- [Roadmap - Expand caret does not display if no children in timeframe](https://gitlab.com/gitlab-org/gitlab/-/commit/8db995ef3b05a706ed8d1e3762ccb1c3647b9006) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156595)) **GitLab Enterprise Edition**
- [Identify masked variable output clearly](https://gitlab.com/gitlab-org/gitlab/-/commit/463d8a4da6fbe5f09f948347d06ccb2b30e609fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160097))
- [Adding limit constraints on frameworks and requirements](https://gitlab.com/gitlab-org/gitlab/-/commit/c8bbf4d234972c6f1393e82a1bd7a1704aef6aab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168608)) **GitLab Enterprise Edition**
- [Use `helpPagePath` to render container registry documentation links](https://gitlab.com/gitlab-org/gitlab/-/commit/4ef7cc8bf2b3d09794476c18f1a51c7a7ef76647) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168283)) **GitLab Enterprise Edition**
- [Show confidential action disabled when unavailable](https://gitlab.com/gitlab-org/gitlab/-/commit/0237b7d55e50ad4c22a8727f7ef8fd708160efb3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168405))
- [Add "skipped" as valid state for commit status API](https://gitlab.com/gitlab-org/gitlab/-/commit/829cccc24401c7733181cf7891264d3c678dc014) by @marthyn.elzes ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168350))

### Deprecated (1 change)

- [Deprecate GitLab chart NGINX controller image v1.3.1](https://gitlab.com/gitlab-org/gitlab/-/commit/95281fe16aa7a78ad6aa2fa82a6eeca16cf6e83c) ([merge request](https://gitlab.com/gitlab-org/charts/gitlab/-/merge_requests/3901))

### Removed (27 changes)

- [Remove scan_execution_pipeline_worker feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/2b19aaf2368eb96c93efe2e8676e90ecabcbd3b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172719))
- [Remove dead legacy pipeline mini graph code](https://gitlab.com/gitlab-org/gitlab/-/commit/eb19a1b96cccd3b9acbcbff3704f2c2d63c0d54a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172155))
- [Remove faulty async index definitions](https://gitlab.com/gitlab-org/gitlab/-/commit/721848957268670ef5948ddf2de79ba618f2401a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172546))
- [Removed feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/6f4450c65cbd3cc982f0eaae59bcb1712e03663c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172502))
- [Remove commented code](https://gitlab.com/gitlab-org/gitlab/-/commit/f83666a77be8461c0f1fb9387a24318d2f18e447) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172585))
- [Remove `confidence` column from `vulnerability_occurrences`](https://gitlab.com/gitlab-org/gitlab/-/commit/7aa754f58086e9da84ab8575e604a6f6f0d2d510) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172414))
- [Remove generate description rails feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/25d41c4664c7227ecc8195683b6430a844ba3052) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172192))
- [Removes finalized BBM for project stats](https://gitlab.com/gitlab-org/gitlab/-/commit/3ec2fa300fab10c83672f802ab1e5e6c6524ca88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171531))
- [Remove BAS security configuration option](https://gitlab.com/gitlab-org/gitlab/-/commit/e963dd301ba63f95eb3f988cb778fe3ea3f8e8c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169563)) **GitLab Enterprise Edition**
- [Remove stepper in policy editor](https://gitlab.com/gitlab-org/gitlab/-/commit/1234bcd9019abe5f0276becd817d173a750c37db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171750)) **GitLab Enterprise Edition**
- [Removes finalized background migration](https://gitlab.com/gitlab-org/gitlab/-/commit/9b80130cf3d9232869a3f157f76e21109dd9c8b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171396))
- [Cleanup duo_free_access_ending_banner feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/0bf4b5816955186e88779adfafdf7a666dbae040) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170868))
- [Drop old temporary vulnerability management indices](https://gitlab.com/gitlab-org/gitlab/-/commit/d16898490e7cf6120ea583a94b2544665ef4e1cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170488))
- [Drop user_canonical_emails table](https://gitlab.com/gitlab-org/gitlab/-/commit/fc8875d9d54ae2fda5ea5e73d439f06c7abcabb2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169963))
- [Remove `vulnerability_occurrence_pipelines` table and code](https://gitlab.com/gitlab-org/gitlab/-/commit/bdebec6cc8c4c3ca3946e780b8b735f776cd02fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170153)) **GitLab Enterprise Edition**
- [Remove tmp index from vulnerability_reads for bbm](https://gitlab.com/gitlab-org/gitlab/-/commit/ee18e43632a6de0a0c8ba72dbcb8b02e8dcb3308) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164430)) **GitLab Enterprise Edition**
- [Remove `namespace_id` from `vulnerability_reads` table](https://gitlab.com/gitlab-org/gitlab/-/commit/ab89077e9e8a1708ab0633aada5e5fa5f89be79e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167643))
- [Remove database table packages_composer_cache_files](https://gitlab.com/gitlab-org/gitlab/-/commit/a9a6b84473efeb90395bdff77321128fe167b83c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159904))
- [Remove feature flag and code combining queries](https://gitlab.com/gitlab-org/gitlab/-/commit/6154e6d1153d6469ed94c4d35a5d75bd03967d28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170025))
- [Remove sharding key issue url keys](https://gitlab.com/gitlab-org/gitlab/-/commit/652b0566488dd001df1a1a5ac69f11f97adf7f77) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169869))
- [Remove Packages::Composer::CacheFile and related code](https://gitlab.com/gitlab-org/gitlab/-/commit/6373f7a1822952d817cfd2550bb31a12fa492a6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166344))
- [Delete no longer used BBM code ahead of Sec Decomposition](https://gitlab.com/gitlab-org/gitlab/-/commit/751756c99705c8cb0eaebd724edebc1868766a5c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167795))
- [Remove labels parameter](https://gitlab.com/gitlab-org/gitlab/-/commit/db46f90d4827b13cefea113dbd42de46cdf17c28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168671)) **GitLab Enterprise Edition**
- [Remove unused vulnerability header CSS](https://gitlab.com/gitlab-org/gitlab/-/commit/d0c8fd64387ba36f3222a92f2353d749bce25dc7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169227))
- [Clean up ci_require_credit_card_on_trial_plan feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/53bfbf6861eabfa1bcdc0da4584674008b7ede5b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167139)) **GitLab Enterprise Edition**
- [Remove cross join suppression ahead of sec-decomposition](https://gitlab.com/gitlab-org/gitlab/-/commit/448721709339f5c5163ed7da01ba99e689189da3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168227)) **GitLab Enterprise Edition**
- [Remove user canonical emails](https://gitlab.com/gitlab-org/gitlab/-/commit/3c4918cc2946fb661e06f3eb4740a5232d17f94b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167687))

### Security (15 changes)

- [Update rails-related gems in gems folder](https://gitlab.com/gitlab-org/gitlab/-/commit/b8bf70b34db2aa27c7a50686a09300713edfd135) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172257))
- [Removed id from authorize buttons and added specs](https://gitlab.com/gitlab-org/gitlab/-/commit/ddf06283c33c5b7828843421812353dfaeee2551)
- [Prevent agent access via unconfirmed or disallowed group members](https://gitlab.com/gitlab-org/gitlab/-/commit/a4c417f124d62068cbf829248f243f9c2e7d1333)
- [Details of blocking merge request can be exposed via list](https://gitlab.com/gitlab-org/gitlab/-/commit/3ed2ec16854bec0b0463207c3c2c604af0635ddb)
- [Remove is-unsafe-link from product analytics tables to prevent XSS](https://gitlab.com/gitlab-org/gitlab/-/commit/80eb472665efdf13beb9296faa1c4149059fd042)
- [HTML injection in vulnerability Code flow leads to XSS on self hosted instances](https://gitlab.com/gitlab-org/gitlab/-/commit/5e822c1e27a1b26518c6ec8ef4ca8f4650f84c82)
- [Use custom adapter for parsing FogBugz XML](https://gitlab.com/gitlab-org/gitlab/-/commit/3880dcd2b426d3bbc384dbdb3146935c643a30af)
- [Update nokogiri to fix recent CVEs](https://gitlab.com/gitlab-org/gitlab/-/commit/bbcb1c987d2f0df2e7731cee25b4aa9aaf253f45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171655))
- [Limit ProcessCommitWorker by number of branches](https://gitlab.com/gitlab-org/gitlab/-/commit/268840eaf7ca2328cd3dc2307ed10b86618221cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171786))
- [Update rexml to fix CVE-2024-49761](https://gitlab.com/gitlab-org/gitlab/-/commit/311f5b34a38d669dc3e2633f42d81b9f27bf43c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171537))
- [Bump rack minor versions to patch CVEs](https://gitlab.com/gitlab-org/gitlab/-/commit/fe50ebd6cc23b23e3eb859d1b91570d20cbbdf13) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169705))
- [Fixed HTML injection in Global Search bug - renamed branch](https://gitlab.com/gitlab-org/gitlab/-/commit/036d7b2cc710cd00a2068b38dfcdf0ea0f8472cb)
- [Limit max size of manifest file upload](https://gitlab.com/gitlab-org/gitlab/-/commit/505c055c8c22a93b32dfc0c0738fd93f81b38335)
- [Update rexml to fix CVE-2024-41946](https://gitlab.com/gitlab-org/gitlab/-/commit/8feae3956828b94ff84f25affc41e61750baa5d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169632))
- [Set Global timeout for Regexp to prevent ReDOS](https://gitlab.com/gitlab-org/gitlab/-/commit/10fd9dfc9473a842fe70a4dd6157b3622215045f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/145679))

### Performance (17 changes)

- [Set PipelineProcessWorker to use sticky data consistency for main db](https://gitlab.com/gitlab-org/gitlab/-/commit/36c68da9ee42a84d1aa792d66c2db6d18f405b26) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166729))
- [Optimize the upload confirmation endpoint in the virtual registries](https://gitlab.com/gitlab-org/gitlab/-/commit/5c9fdf3d64e99088ae36e7bf07cb8ca0cbd7a1b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171297))
- [Default to sticky for Ci::BuildFinishedWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/cca08652196e49738eda2115dfd60904230a1493) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171794))
- [Use CTE for Group access_level search](https://gitlab.com/gitlab-org/gitlab/-/commit/137d4af853b21e403b386f4bac40f47c839313f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171735))
- [Prepare index for faster search build name](https://gitlab.com/gitlab-org/gitlab/-/commit/8353654aa96a48be325497cec325a8877f81cf96) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170836))
- [Optimize: custom ability verification](https://gitlab.com/gitlab-org/gitlab/-/commit/0116846250515a7d95a1813f658156aef2d2fc54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170610)) **GitLab Enterprise Edition**
- [Enable CI kubernetes variables optimization for pipeline creation](https://gitlab.com/gitlab-org/gitlab/-/commit/31c3788b549ba493988bb025d65b9cb0a7813185) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170763))
- [Use `:delayed` or `:sticky` data_consistency for cleanup policy workers](https://gitlab.com/gitlab-org/gitlab/-/commit/aef46aad9676cf191a2766cf538760d5709fc013) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170103))
- [Use sticky data consistency for InitialPipelineProcessWorker by default](https://gitlab.com/gitlab-org/gitlab/-/commit/7d8ecff7a1ff0cfde91099f679cfe9b16616892e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170218))
- [Optimize: association loading for RepositoryController](https://gitlab.com/gitlab-org/gitlab/-/commit/86dd58fcd149947c23b8eb9b36216aa56e4661bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169280))
- [Remove permissions JSONB column from the condition](https://gitlab.com/gitlab-org/gitlab/-/commit/e6cbe19b446047cc3d9c810175d137e851784d82) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169094)) **GitLab Enterprise Edition**
- [Update import_export_uploads sharding](https://gitlab.com/gitlab-org/gitlab/-/commit/375b4e6d2b08b0698ef674ab58d70abe170d4a73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168392))
- [feat: Update Occurrence group scope to rely off traversal_ids](https://gitlab.com/gitlab-org/gitlab/-/commit/8da7a6c720236725f962a60078276591864d0a8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168704)) **GitLab Enterprise Edition**
- [Create multi not null constraint for exports](https://gitlab.com/gitlab-org/gitlab/-/commit/7b6dc073fc9ad36c0d3f0f44b39806e96247d366) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168411))
- [Optimization: don't load a User when user_id is missing](https://gitlab.com/gitlab-org/gitlab/-/commit/fea653f28468b9fa996cd881b2fde5d769e07659) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169163))
- [Optimization: don't load group if not needed](https://gitlab.com/gitlab-org/gitlab/-/commit/9e5ad5aa54e684cbe3d8f60187531e6cee07b80b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169276))
- [Improve performance of issues autocomplete](https://gitlab.com/gitlab-org/gitlab/-/commit/21c3c7c4eb5504ef23672db3c02aba503672a3ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169235))

### Other (258 changes)

- [Backfill project organization_id column](https://gitlab.com/gitlab-org/gitlab/-/commit/588fb65383c52ff25c7741ef2a2cee0a683fc07d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170206))
- [Add non id primary key support for backfill](https://gitlab.com/gitlab-org/gitlab/-/commit/f57eaab1fa59e012f09e0ae2dd11c3506f844219) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170680))
- [Remove dependency_list_exports from wip](https://gitlab.com/gitlab-org/gitlab/-/commit/cf6e3059178e4356d7028e1728e4d29807ae4e76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172746))
- [Unquarantine project subscriptions spec](https://gitlab.com/gitlab-org/gitlab/-/commit/0986a9258a55a01762bf469d62c76668eedca7ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172976)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/86a1846acdb6eca7b540bc60a008da835f8a625c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172920))
- [Add PIPL email sent timestamp](https://gitlab.com/gitlab-org/gitlab/-/commit/965e564a8d289a4ceb3f522203b8cddc937d76c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171902))
- [Add models and initial ability for admin related custom roles](https://gitlab.com/gitlab-org/gitlab/-/commit/1848798db4dca564e6d9126f758568a7b30c1fab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171581))
- [Quarantine test suite](https://gitlab.com/gitlab-org/gitlab/-/commit/f9976944bea4864bbfd7e7ad6e030f5818799cd7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172828)) **GitLab Enterprise Edition**
- [Remove orphaned managers from ci_runner_machines_687967fa8a on .com](https://gitlab.com/gitlab-org/gitlab/-/commit/a0bf8950491c36ac104ce94e0a7128a97bb67794) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172422))
- [Remove FF owasp_top_10_null_filtering](https://gitlab.com/gitlab-org/gitlab/-/commit/33cd3ec3be7e1b2562bb6e0c1260b5ec541ab37f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171813)) **GitLab Enterprise Edition**
- [Finalize migration BackfillSbomOccurrencesVulnerabilitiesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/d9689cb7f1e40ddef7de1102c1e92800b4b40823) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172770))
- [Cleanup monolith prompt for glab_ask_git_command](https://gitlab.com/gitlab-org/gitlab/-/commit/9009d712dee4ca3aa117c6737f4077b9fb6a8fc6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172760))
- [Add NOT NULL for sharding key on security_scans](https://gitlab.com/gitlab-org/gitlab/-/commit/88d7e314fb1094687ceda819d8792e0a3ca82b0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171845))
- [Quarantine flaky spec](https://gitlab.com/gitlab-org/gitlab/-/commit/6d14d4f3bf14a495d0135b7f07cf648d81180773) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172731)) **GitLab Enterprise Edition**
- [Finalize migration BackfillPkgsDebianProjectDistributionKeysProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/1b4877f58ed9f65cfb6fe3175bae8cae34a292c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172597))
- [Use SessionMap for tracking per-db primary/replica usage](https://gitlab.com/gitlab-org/gitlab/-/commit/34b6032473f0e3bd38122f57fbdf8b2c89b944ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168642))
- [Finalize migration BackfillPackagesDebianPublicationsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/c14593770c50261e145bc6ebdf0126a9eb4e5c9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172599))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/1b8a3a53544105426a03b14ef9e5483a6a5b2de8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172636))
- [Finalize migration BackfillReleaseLinksProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/a0a52ea07161ae3e37e9bb0c20a2128700994250) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172602))
- [Finalize migration BackfillRelatedEpicLinksGroupId](https://gitlab.com/gitlab-org/gitlab/-/commit/1e89c8e38467eb9028cded52e95543e048102c3e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172601))
- [Fix Layout/LineLength offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/05e99f9c9ee31b03d7911116743b9d5ee8c942cf) by @ikelax ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170715))
- [Model registry: Fix position of actions ellipsis](https://gitlab.com/gitlab-org/gitlab/-/commit/10ea05e722aa134306c1342b11f7b49defe0395b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172552))
- [Remove current partition feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/aa2aa07b28d0e99049a04e0e6365acb539d0ee2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172397))
- [Elasticsearch migration: Backfill correct_work_item_type_id](https://gitlab.com/gitlab-org/gitlab/-/commit/2ee1855452bada094670a2f4152fc1c9aa75d150) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171921)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/150a83e4f8a82285fb0d8cf4ef1d962b603242bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172472))
- [Finalize migration BackfillPackagesDebianGroupDistributionKeysGroupId](https://gitlab.com/gitlab-org/gitlab/-/commit/d067e27f5f2ef0db25cb45a3cac0015d4c1bca7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172455))
- [Finalize migration BackfillPackagesBuildInfosProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/d4b5be28f91c5a21f48d4a86dbb534c74847e0b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172454))
- [Finalize migration BackfillOperationsStrategiesUserListsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/1d9d82e64a481307c305be7e71a93cdfe27fe1cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172168))
- [Protected containers: Remove field "Minimum access level for delete"](https://gitlab.com/gitlab-org/gitlab/-/commit/f0fe61070f353deee5fccd0f4f07b1ac8e4f5856) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172284))
- [Calls alter_cell_sequences_range rake from db:configure](https://gitlab.com/gitlab-org/gitlab/-/commit/8082c3ecd598bce1f9a6c8d8d4799b9899423852) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170613))
- [Finalize backfill_vulnerability_state_transitions_project_id bbm](https://gitlab.com/gitlab-org/gitlab/-/commit/686cef3e70e954ed3b3308d4a090e14386766c92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172376))
- [Add custom access denied page for ultimate trials in-app](https://gitlab.com/gitlab-org/gitlab/-/commit/ab2127cf39b78b9bf9ce8a30551469670e15a2df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171981)) **GitLab Enterprise Edition**
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/ab5a85091963f08f29e089d5f2d2753c29a8c5e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172260))
- [Add NOT NULL for sharding key on dependency_list_exports](https://gitlab.com/gitlab-org/gitlab/-/commit/b0d7c70c86c40ef973f0b9738619d7a60680e32d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172178))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/0c8242752dbba611e8933dc2e578a62489dc7578) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172216))
- [Finalize migration BackfillMergeRequestAssigneesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/a3395062e13a6b6a4d5efb47e6c8833f4f5d51d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171763))
- [Add issues.correct_work_item_type FK](https://gitlab.com/gitlab-org/gitlab/-/commit/71dd61f74b691e2beb486e9940564e84374c21c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172310))
- [Add tmp issues.correct_work_item_type_id indexes](https://gitlab.com/gitlab-org/gitlab/-/commit/1c38b2f62832f208530faa65ca1f63d66d73a00c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170005))
- [Update postgres_sequences view](https://gitlab.com/gitlab-org/gitlab/-/commit/571df3ee8621bfea80db8a14e1dd810892471dcb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170808))
- [Protected packages: Remove scope :matching_package_protection_rules](https://gitlab.com/gitlab-org/gitlab/-/commit/a1bba7cdefae3911d2a23dfe71693672d8519e51) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172258))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/a0c705ce3880591eae585df78f0a2fb3260c94fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171620))
- [Finalize migration BackfillMergeRequestContextCommitsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/09dfb8b7cd8ee5c9a27e885d72520d66887614d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172002))
- [Finalize migration BackfillMergeRequestBlocksProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/78157b6fb8079b7eaecbf22badb1fa9fb6b1dd55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172001))
- [Finalize migration BackfillOperationsStrategiesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/004f12afbf6923ddf020759d9e3409fda648b9fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172167))
- [Add and backfill work_item_types.old_id column](https://gitlab.com/gitlab-org/gitlab/-/commit/6343cb16b0ff192d05c56fc63f3ed043c1d0df84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172149))
- [Check if user can create package in npm create package service](https://gitlab.com/gitlab-org/gitlab/-/commit/6d1ef41d216da7961a5f3d006b32055c749967b2) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171409))
- [Better extraction of variable and rubocop](https://gitlab.com/gitlab-org/gitlab/-/commit/7ee911a1aa86501ac8d94e59639ba3ce7bc214b4) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171425))
- [Change data consistency for workers maintained by integrations](https://gitlab.com/gitlab-org/gitlab/-/commit/5708f0a50728a17937f11588760772b332bb456d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170351))
- [Finalize migration BackfillEpicUserMentionsGroupId](https://gitlab.com/gitlab-org/gitlab/-/commit/2c2285acec0b27aba50d83d3965261930ed559d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171614))
- [Use p_ci_build_tags for jobs queuing](https://gitlab.com/gitlab-org/gitlab/-/commit/c4130263d09840388e1a03346eed296a8022c11f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172048))
- [Fix Layout/LineLength offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/f5295ec76f6f4b85d099aaa40faa4da8c644d217) by @ikelax ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170700))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/b04b0e1e33718709724d6f05dca18a36ff7ce379) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172012))
- [Finalize migration BackfillOperationsFeatureFlagsIssuesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/08ba5a6fdb22fc0039614125754a982f2f15b46c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172004))
- [Finalize migration BackfillIssueLinksNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/3366b74028cfb4e11e33ecff697da81efce7b044) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171615))
- [Use sidekiq_interruptions_exhausted in Direct Transfer jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/6f7bdef804fbfe0066fd767851761ed5cdfb5609) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169183))
- [Remove add_on_purchase_expires_on feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/09a3db4a2fb5d4ec4171a3765fc4e7ecff47c390) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171965)) **GitLab Enterprise Edition**
- [Revert caching authorized_projects](https://gitlab.com/gitlab-org/gitlab/-/commit/11f56525d2be98cd068958659ff4e0883277581b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171798))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/5d2bd6cafd520eb3dd6abc4094a148c96f1b7658) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171494))
- [Requeue migration security findings](https://gitlab.com/gitlab-org/gitlab/-/commit/a8e66d87eac136d6cf236733bfd2908262f289b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171503))
- [Fix Layout/LineLength offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/1c6004bd648d91bd16b3c5518def7250cde83795) by @ikelax ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170712))
- [Backfill embeddings for work items](https://gitlab.com/gitlab-org/gitlab/-/commit/38173d1fdbd2578d42383ce9b5b656081be7d829) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170784)) **GitLab Enterprise Edition**
- [Finalize BackfillProjectIdToDependencyListExports](https://gitlab.com/gitlab-org/gitlab/-/commit/e792d7a9ad1eec805d307d3a5446d4fb3d362613) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171854))
- [Elasticsearch: Migration to add work item type correct id](https://gitlab.com/gitlab-org/gitlab/-/commit/2b5d65b521ec9bc29138963ddb415bc757781e03) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171704)) **GitLab Enterprise Edition**
- [Use p_ci_pipelines by default](https://gitlab.com/gitlab-org/gitlab/-/commit/498c36e17910ec2070d5a6a1af1d1a0171a2b2e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171834))
- [Remove prompt migration feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/f3801f26c5df0064531ee04b06d36f3c83a6e260) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171532)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/4bf09088fc4b21f7c19c3a2a8f8999d48f4f22f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171778))
- [Finalize migration BackfillDraftNotesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/39cb7750dbafe7c336a6bdfb2c35718f216457ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171613))
- [Finalize migration BackfillDesignManagementVersionsNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/ebd38a95ea212a30f0a61ce38d931dafb1952205) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171611))
- [Finalize migration BackfillDesignManagementRepositoriesNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/1fc96881d206ef32cdfc7ecb9d0bddb5f7c64cd5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171442))
- [Finalize migration BackfillWorkspaceVariablesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/45d903fad1b4785623ec94e34470def38d568776) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171046))
- [Fix Layout/LineLength offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/89274a6ed3ce534d26142fc15c6ebb92330d0b48) by @ikelax ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170710))
- [Use 24 hours lease time](https://gitlab.com/gitlab-org/gitlab/-/commit/1a96b6bd00729b68ccd5ed966dc8749ab78adb1f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171695)) **GitLab Enterprise Edition**
- [Fix sidekiq warning for ElasticsearchIndexedWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/15e0ab155315b5532aea50412be5ef654c9c57f1) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164096)) **GitLab Enterprise Edition**
- [Fix Layout/ExtraSpacing offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/0dc27019c0d22eee2694632a2c163abab9b08411) by @mr1chter ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170970))
- [Finalize BackfillProjectIdToSecurityScans](https://gitlab.com/gitlab-org/gitlab/-/commit/6c3933c3f85ad0c72a5884a0808b2ffd27636f88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171458))
- [Create new internal path for AddOnPurcahse](https://gitlab.com/gitlab-org/gitlab/-/commit/611d6a51f38d7ad622ec4543ea2f5bde7e6bbb7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170994)) **GitLab Enterprise Edition**
- [Groups::DeployTokens::RevokeService should return ServiceResponse](https://gitlab.com/gitlab-org/gitlab/-/commit/2aae45bc59bdcfee16fadb234f6b0a189b0fd7fa) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170640))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/00702a81ae2edf3a1aacec3b29aa77bcf8b3fd0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171489))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/16bc6e3d34a7d26e66d7c86c03197ccdde008670) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171490))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/683d080056437a49ae871ba25d22bbf927affa53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171491))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/d10f2dbc482b78864b177e9638df69ea2f2d6b55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171449))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/9fe14615e1ae4a2eb8e2a1ed163a1512a45d5165) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171492))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/2b2a3a608199c54a76ac7e3d752839b4eebe2cd3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171619))
- [Finalize migration BackfillDoraDailyMetricsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/f23e6bdd445099cb6c24e1cd0b6bb57f83938d48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171612))
- [Finalize migration BackfillDesignManagementDesignsNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/a665e564bbd1bc2dfbbe8f259bafec0fc06dacf6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171346))
- [Add desired sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/2c9ba799d332c6830cdadfbd3882ad8561121182) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171604))
- [Create a new zpekt scheduling task repo_to_index_check](https://gitlab.com/gitlab-org/gitlab/-/commit/4b5b508461e13fad908a8ede43c345f513e24448) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170288)) **GitLab Enterprise Edition**
- [Add desired sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/bcc684077a9995342baa7282f4a3b9d31ecdcd93) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171601))
- [Add policy toggle unblock_rules_using_scan_execution_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/167da2e7651788f92df96264665fbb8b36902559) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170605)) **GitLab Enterprise Edition**
- [Cleanup CreateIterableTriggersWorker class and instances](https://gitlab.com/gitlab-org/gitlab/-/commit/32ea9c674ea8fd894ff5cf8e306552d840989bba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171541)) **GitLab Enterprise Edition**
- [Cleanup duo enterprise rollout feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/fb69200aacc4d177a54e8c39359c7c16979a4bf8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170864)) **GitLab Enterprise Edition**
- [Use lock_key for BulkRefreshUserAssignmentsWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/9cfcab2275e82912de8a7b49b1684fa82c095483) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170929)) **GitLab Enterprise Edition**
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/89dec2564e291d3923c6d7baeccf5fc24803387e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171526))
- [Add pipl_users table](https://gitlab.com/gitlab-org/gitlab/-/commit/cb85e2926b2f2111d143b164a0e0e0d44ed3750e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169769)) **GitLab Enterprise Edition**
- [Protected packages: Add tests for pypi push protection with deploy token](https://gitlab.com/gitlab-org/gitlab/-/commit/a6ffc0f9cc1ce711aa7cc20bf626160680a32e25) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171516))
- [Mark 20240410193847 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/9064247184ca4e5a4688ed31db4f82817dd6db6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169314)) **GitLab Enterprise Edition**
- [Introduce histogram for ApplicationRateLimiter](https://gitlab.com/gitlab-org/gitlab/-/commit/2b540efd81f45bf8355a113ac8420de7b2b0759f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169655))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/e9ec3295766a3b3f9317998c560335b4ed5a2f8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171493))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/71dd85c5bc6ee79331de3e3ed7ee5fe5fbf34421) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171355))
- [Finalize migration BackfillDefaultBranchProtectionSettings](https://gitlab.com/gitlab-org/gitlab/-/commit/6d8fc9863e98b0ab2f8f26d990062fda4b310583) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171200))
- [Finalize migration BackfillDastSiteProfileSecretVariablesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/32b9635a277d73cd7352f4dc9ad2d4f39eb2b968) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170669))
- [Finalize migration BackfillDastProfilesTagsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/7d036de56f848b7d549ea26699c3a9bc6654e3d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170667))
- [Finalize migration BackfillWorkItemParentLinksNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/ea2dceb7e49708dd2964ddf85c4d2c4c860366b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170879))
- [Finalize migration BackfillJiraTrackerDataProjectKeys](https://gitlab.com/gitlab-org/gitlab/-/commit/9cc605b0b2cdea2f07dfeb89051303b30a7f0734) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170877))
- [Fix Lint/UselessNumericOperation offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/c94fc73a2226ac8eca3ebb6066b28b3a9ae60d7e) by @ksp_1306 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171460))
- [Fix Layout/LineLength offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/e9512e4ad3c3c63b244880a08b6d98df78dfd027) by @ikelax ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170711))
- [Create new WorkflowsInternal API for ai_workflows scope](https://gitlab.com/gitlab-org/gitlab/-/commit/5e649ce892ec159ded1b619f31b0fb974d4b051e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171229))
- [Fix Style/IfUnlessModifier offences](https://gitlab.com/gitlab-org/gitlab/-/commit/56258237ddf1826cd7145ffe42d9e8cc21b56aed) by @divyamtayal ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170457))
- [Change data consistency for workers maintained by permissions](https://gitlab.com/gitlab-org/gitlab/-/commit/971558937d6b247d597740cc5680c8b53825966e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170347))
- [Fix Layout/LineLength offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/21f7c2f08821e092d408e0550ab7ddf1d591b4e6) by @ikelax ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170704))
- [Add service ping to support tracking runner maintenance notes](https://gitlab.com/gitlab-org/gitlab/-/commit/0bdb6d0d960c8128475ad8742192fc2d6547e2f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170483))
- [Add work item weight sources table](https://gitlab.com/gitlab-org/gitlab/-/commit/4193ae7a2460614f747212473b91f619eddc0e72) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170371))
- [Finalize migration BackfillWikiRepositoryStatesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/71acdb27fbf881ab9b439a1212815be9862db8ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170878))
- [Fix Layout/LineLength offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/6318b592750a246e8d2c3f6a09f12def797e8d09) by @ikelax ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170701))
- [Fix Layout/LineLength offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/2d0999f0cddf9eb0e479ac9040779b978d0246b9) by @ikelax ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170707))
- [Remove the trial boolean qualification for ultimate trials](https://gitlab.com/gitlab-org/gitlab/-/commit/f1dd21f41295fbd062d97eb6afb7b86bd6197416) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171306)) **GitLab Enterprise Edition**
- [Fix Style/IfUnlessModifier offences](https://gitlab.com/gitlab-org/gitlab/-/commit/4fc6a0cb0b13d413d87b8e72bf17394dfe55a081) by @divyamtayal ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170331))
- [Remove expired cut off date feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/2ad2719a5b92c78a84b15b70b4f6918a02401e1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170101))
- [Make to-do item spelling in UI consistent](https://gitlab.com/gitlab-org/gitlab/-/commit/9ef27900791d9d06be33bebb6cedcacd15944d07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171007)) **GitLab Enterprise Edition**
- [Update Dependency List docs](https://gitlab.com/gitlab-org/gitlab/-/commit/94527a8624530cc5a51ce8df64cd00a5d19be93c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171115)) **GitLab Enterprise Edition**
- [Remove trial column observance from the eligible trial query](https://gitlab.com/gitlab-org/gitlab/-/commit/e43ea49be52e3bebaa1b135867e91aca1238a6ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171211)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/8103e45a701b03e829bbb23b643e08b9e3f3fe17) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171220))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/4b0d928ae5fcfaf91b081b5d8dd04854e1da66bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171219))
- [Finalize migration PopulateTopicsSlugColumn](https://gitlab.com/gitlab-org/gitlab/-/commit/390edddfe543dd9c7e0c20909fd3b582bb64986e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170875))
- [Add sharding_key_issue_url for manually backfilled](https://gitlab.com/gitlab-org/gitlab/-/commit/7740e0c893c4664232f11ea1acbc1a7c5f5cc0db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171076))
- [Log relation name when exporting projects](https://gitlab.com/gitlab-org/gitlab/-/commit/fd2218d3b5fec0a462db016997f0ddbaf9776bc7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171157))
- [Fix Layout/LineLength offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/cca7ab85039a13f33f785ea76a64317b83ad4c70) by @ikelax ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170292))
- [Add and backfill namespace_id for analytics_cycle_analytics_value_stream](https://gitlab.com/gitlab-org/gitlab/-/commit/43c52121be28d2ddb65e6ca159661b043a4e9e24) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169585))
- [Remove custom_models_vue_app feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/182b6dd64bc0fbb513b0695a3b4bdd5f1dd441c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170891)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/fa96d7437e5237ffeb76af9c918f1b6b47c89ed0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171056))
- [Finalize migration UpdateSbomOccurrencesComponentNameBasedOnPep503](https://gitlab.com/gitlab-org/gitlab/-/commit/ad08d7a6fae3fe2b0b3217a17d425155d3abf6e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170876))
- [Fix Layout/LineLength offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/20460968896de297eb4e02fcd5f9b486f37b3aec) by @ikelax ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170709))
- [Fix Style/CombinableLoops offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/af9b15536eda42064501d1f9a2d468b4b8988c31) by @JonstonChan ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169977))
- [Remove custom_models_feature_settings_vue_app feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d64dc841241ef4ae7e49ddfe5eb0ee74586cb0ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170201)) **GitLab Enterprise Edition**
- [Add ci_deleted_objects#project_id not null constraint](https://gitlab.com/gitlab-org/gitlab/-/commit/1aa273c0c7df5125bc12169375b456483852105d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170215))
- [Mark 20240213091440 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/40f17a4bb78840c5a66ccbc538048bc970cd2c87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169311)) **GitLab Enterprise Edition**
- [chore: Adds additonal properties in duo workflow event definitions](https://gitlab.com/gitlab-org/gitlab/-/commit/5c4e5fabac1cd0139dd19f30e8681c2813a4c890) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170950)) **GitLab Enterprise Edition**
- [Move base integration code to a separate module](https://gitlab.com/gitlab-org/gitlab/-/commit/1ec1990c151800a5c95e4de4e731fdd2464a8691) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170439))
- [Track worker concurrency using Redis hash](https://gitlab.com/gitlab-org/gitlab/-/commit/b6f049e690b040bf34e0a03345d38b11306f7382) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167027))
- [Update instance_integrations table to match integrations schema](https://gitlab.com/gitlab-org/gitlab/-/commit/4917d4151a855cc87b1fb40fb487d8f33e7aca60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170247))
- [GitLab pages: Fix rubocop issues in certain files](https://gitlab.com/gitlab-org/gitlab/-/commit/5fab53761c269d34fb8d59b27562ff0b7bfdb53c) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162847))
- [Add `namespace_details.deleted_at` column](https://gitlab.com/gitlab-org/gitlab/-/commit/f75a1bb76a3e5f90956529396d2762abd6bde44f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170898))
- [Exclude qa sbom fixtures from dependency scanning](https://gitlab.com/gitlab-org/gitlab/-/commit/2a887a1cb1d3b64cfdf2c9fc75ba5e8e1181a95f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169761))
- [Add RequeueBackfillApprovalProjectRulesProtectedBranchesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/fc6fb00a6f4919490bb73c39b05c1bf1a7265507) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170799))
- [Change data consistency for workers maintained by not_owned](https://gitlab.com/gitlab-org/gitlab/-/commit/cd5f35fff1f2ff86b2df21cd8a4ddaf2753580af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170350))
- [Remove sync_traversal_ids_nowait feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/333dd2c97b3a6702fac20bdd033ed04e7410b546) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170752))
- [Finalize migration DeleteOrphansApprovalProjectRules2](https://gitlab.com/gitlab-org/gitlab/-/commit/ba905bc24ee889c93d7e0de63ab55faa0099ccb0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159492))
- [Fix Gitlab/StrongMemoizeAttr offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/361b701f4f5e413331bcfac2074031d81525c05c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170399))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/63a9549049890af0412ebc11108417d5fe818b76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170674))
- [Finalize migration BackfillDastScannerProfilesBuildsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/fb67b4be4a3e6aa996c05615ceeef87b452a2cea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170668))
- [Finalize migration BackfillDastProfilesPipelinesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/e1e9dfbd78b0aaa553d112338cfb63bab75bfb46) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170666))
- [Finalize migration BackfillAlertManagementAlertMetricImagesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/c2763bae4db5ca06a4dd86f445aa0481ef76bde4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169518))
- [Support data consistency overrides for specific db in ApplicationWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/855dbf096b761702c1d08118347e770e1e8a6f62) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166729))
- [Fix Style/IfUnlessModifier offences](https://gitlab.com/gitlab-org/gitlab/-/commit/b0fcf8b93aff19779b04480d39f01a2b10818f72) by @divyamtayal ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170675))
- [Topology Service CellService client](https://gitlab.com/gitlab-org/gitlab/-/commit/3f0d395275394f783f90980afb72a03d30fb70ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169787))
- [Log when placeholder users are created](https://gitlab.com/gitlab-org/gitlab/-/commit/f4e352dfae21fc8e36112b965542def47bf0767a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170599))
- [Finalize BackfillPCiRunnerMachineBuildsProjectId migration](https://gitlab.com/gitlab-org/gitlab/-/commit/cea4e6efbf00c0698b0ed5667c43cebfcaa34ab6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170308))
- [Update seed factory exclusion](https://gitlab.com/gitlab-org/gitlab/-/commit/2187c36808be88bf629f6ec774bac05f0b76c755) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170546))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/00a120b6676768dcc56be20b01bae50634a21818) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170529))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/100ee160c7f10a4ebecf803c8d0b9b82cb84e527) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170528))
- [Add created_by and updated_by to custom fields](https://gitlab.com/gitlab-org/gitlab/-/commit/843640c410c8c7a7ea0b28dc8d9f730ac09f4c33) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169770))
- [Use exclusive lease for resuming job processing](https://gitlab.com/gitlab-org/gitlab/-/commit/d7f9af35acacc04ef59942913e576fd11ce521e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170537))
- [Finalize migration BackfillDastPreScanVerificationsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/f00d8124babd3440e09377320a62cac255f5030b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169203))
- [Finalize migration BackfillAuditEventsStreamingEventTypeFiltersGroupId](https://gitlab.com/gitlab-org/gitlab/-/commit/1fd3c0986fe4c3635b04f0dfe1fc08081d91b3bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167508))
- [Finalize migration BackfillAlertManagementAlertUserMentionsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/31eabf00bd47e972231c70cc5826771c8d86b8a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169519))
- [Finalize migration BackfillAlertManagementAlertAssigneesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/8034565ab755a8b154c0bf1ed62f4c60c47a80db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169517))
- [Finalize BackfillRunnerTypeAndShardingKeyIdOnCiRunnerManagers](https://gitlab.com/gitlab-org/gitlab/-/commit/28bd7776938e80c942f393454f2c10e5440f5558) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169964))
- [Enqueue migration to fix canceling attributes for CI jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/65f9ca582846e5bfbf97e54452eb4574cd1a33ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170253))
- [Mark 20240130154724 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/1ad966a5bf6f606d03a9d3fee4f9dc3c0f5e445f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169304)) **GitLab Enterprise Edition**
- [Check if user can create package in pypi create package service](https://gitlab.com/gitlab-org/gitlab/-/commit/2a24b8e3063e2d9b2c5d6720ae1e61a4afb76b3c) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168071))
- [Update to add sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/d2922e4e667768eb57670f74e41b2f37f3623811) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170467))
- [Protected packages: Return ServiceResponse for CreateConanPackageService](https://gitlab.com/gitlab-org/gitlab/-/commit/d0e9e48b6f6a8cdc7f1836cb3d75fb9e689c734c) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168214))
- [Change data consistency for workers maintained by importers](https://gitlab.com/gitlab-org/gitlab/-/commit/41d408a910c5163e3a0e9bcf20e62b50a443b89d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170349))
- [Fix docs link in UI](https://gitlab.com/gitlab-org/gitlab/-/commit/270291f91efe0521621a80582becbdf0e8f382be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169461)) **GitLab Enterprise Edition**
- [Add missing test for method #consume_event in Subscription](https://gitlab.com/gitlab-org/gitlab/-/commit/db1306cef4f09a5564f8001fe9a720a195ad4ea3) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164373))
- [Drop search_namespace_index_assignments and search_indices tables](https://gitlab.com/gitlab-org/gitlab/-/commit/bf8ce6cb0f416d6cfe3df7dbb38d6629dfa03876) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170242))
- [Fix Layout/LineLength offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/efd2ff98e0492edd1922d54e29cff6c685229f35) by @ikelax ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170165))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/43b94daf6fdf6d9ae6e0f85f12019df6b932ec97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170367))
- [Temporarily unapprove MR for code owner rules to sync](https://gitlab.com/gitlab-org/gitlab/-/commit/571309cd5717d19399a869f54fdcb36ef0807472) ([merge request](gitlab.com/gitlab-org/gitlab/-/merge_requests/167592)) **GitLab Enterprise Edition**
- [Use SessionMap for tracking per-db primary/replica usage](https://gitlab.com/gitlab-org/gitlab/-/commit/7ad5ee203d8e8102ba2049080e95ce302035ecb5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168642))
- [Use project_id as sharding key for packages_dependencies table](https://gitlab.com/gitlab-org/gitlab/-/commit/3744108d2ec4677f5a1159e12d2c5682f46477ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169394))
- [Finalize migration BackfillBoardsEpicBoardLabelsGroupId](https://gitlab.com/gitlab-org/gitlab/-/commit/05b351e1341154ede3e88bf0ee067a557a3b0788) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167978))
- [Change data consistency for workers maintained by auto_devops](https://gitlab.com/gitlab-org/gitlab/-/commit/32af56d2b154b4064b89ae3c25621e661d1b6865) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170348))
- [Improve test performance of conan request tests](https://gitlab.com/gitlab-org/gitlab/-/commit/a55435b71db1c311455b855ea552ca16f688fec3) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168984))
- [Change ultimate trial select namespace form language for duo](https://gitlab.com/gitlab-org/gitlab/-/commit/180ac4c9bfb96d6e512eed634da21038a2903e8d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169983)) **GitLab Enterprise Edition**
- [Remove the FF zoekt_initial_indexing_task](https://gitlab.com/gitlab-org/gitlab/-/commit/ee973e1ed4eb7bc3293ed5ceef29e637cd402071) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170274)) **GitLab Enterprise Edition**
- [Refactor Token Identification](https://gitlab.com/gitlab-org/gitlab/-/commit/3b32ce03e0d40f394124ffd6e78e7ad38a640d8b) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169821))
- [Add opensource limit to pages deployments limit](https://gitlab.com/gitlab-org/gitlab/-/commit/1c94996069f3c7b1ed6ce1779cf60f954c4e7152) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169910))
- [Mark 20240130215043 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/3497bb85586854b29d1e96528ad06947e3783d37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169306)) **GitLab Enterprise Edition**
- [Finalize the backfill user details migration](https://gitlab.com/gitlab-org/gitlab/-/commit/3f0b7395adb7aae1cebc235910e0e7261a78db66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162735))
- [Finalize BackfillShardingKeyIdOnCiRunners background migration](https://gitlab.com/gitlab-org/gitlab/-/commit/089e327ba1b66ba8b976bb1cf572a329bffb8f27) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169958))
- [Add NOT NULL for sharding key on agent_activity_events](https://gitlab.com/gitlab-org/gitlab/-/commit/7312f7d8dec8449c01242cd71b60b232e51a94f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170139))
- [Improve sharding key spec](https://gitlab.com/gitlab-org/gitlab/-/commit/56ca95ed1720fdf32ac9119377cd3012dcb9c461) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170197))
- [Add NOT NULL for sharding key on subscription_user_add_on_assignments](https://gitlab.com/gitlab-org/gitlab/-/commit/d9ddb4a1a5b464aad4a85e566e0579df24b2abb9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170136))
- [Cleanup group_protected_branches feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/a7b1c6cf1133b74ad2c6d797109419d3a32a1ea0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170128))
- [Add and backfill project_id for security_findings](https://gitlab.com/gitlab-org/gitlab/-/commit/362c9b3afce3f405d0c62ef57d1c67280b298366) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169121))
- [Remove search_indices table related code](https://gitlab.com/gitlab-org/gitlab/-/commit/1a7ee8d73e927907f135b7e5e3382c8e56d7bd44) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169909)) **GitLab Enterprise Edition**
- [Fixed rubocop space_inside_parens](https://gitlab.com/gitlab-org/gitlab/-/commit/b77fd9f05ef627cfa15261ae4ce86ce84cde560a) by @b310-jannik ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170123))
- [Fix sidekiq warning for MergeRequests::RemoveUserApprovalRulesWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/967940dd873f095c8036856fe4c2e07ec6f2da46) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169957))
- [Bump issues bigint conversion cols removable data](https://gitlab.com/gitlab-org/gitlab/-/commit/80690b527c35f51f61b498b15111c23cdc344403) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170083))
- [Remove unnecessary ExclusiveLeaseHelpers from spec](https://gitlab.com/gitlab-org/gitlab/-/commit/afec8f505e27de430b61433f4caf0374042dadd7) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170082))
- [Use AssignResourceFromResourceGroupWorker instead of V2](https://gitlab.com/gitlab-org/gitlab/-/commit/cbc4af047bc42309a41de4782496763afeec627a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168483))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/8f28b7cc2808e3c0619a5572a7f76d5b5f165ef1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169817))
- [Add foreign key constraints to `organization_users`](https://gitlab.com/gitlab-org/gitlab/-/commit/fde94be689e01d6e649fa6b791288b431af5026f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169382))
- [Prepare async index creation for issues.correct_work_item_type_id](https://gitlab.com/gitlab-org/gitlab/-/commit/4516cf901060f3701cdd16f2252337ceb42e8bd7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170009))
- [Introduce a checking state for approvals mergeability check](https://gitlab.com/gitlab-org/gitlab/-/commit/9076157ea1442b427d418614aa8485a217424d02) ([merge request](gitlab.com/gitlab-org/gitlab/-/merge_requests/169689)) **GitLab Enterprise Edition**
- [Remove the search_issues_uses_work_items_index ff](https://gitlab.com/gitlab-org/gitlab/-/commit/9d7c8b3f154096740d92905dc5162b893c521948) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169418)) **GitLab Enterprise Edition**
- [Mark 20240123181031 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/1ad8278054048a29f683a75f117fe8480d9daab6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169300)) **GitLab Enterprise Edition**
- [Projects::Settings::RepositoryController#show: re-enable query limit](https://gitlab.com/gitlab-org/gitlab/-/commit/2fe6f40c2072e5a170d6a0785c18b1513f227aa5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169948))
- [Mark 20240130144625 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/c80743a616f004b50566655ebb64522b709b7b38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169302)) **GitLab Enterprise Edition**
- [Set retention period of 1 month for web_hook_logs](https://gitlab.com/gitlab-org/gitlab/-/commit/baad9506130fa1ab988fdd4238dc72ebec60352d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168654))
- [Validate ci_job_variables#project_id constraint](https://gitlab.com/gitlab-org/gitlab/-/commit/0a5d16650da31576533fa344e164ea3d54e635ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169232))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/d9a0032d22d5da3b0d9e1cf9f348fb5dedd4efee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169130))
- [Cleanup allow_protected_branches_for_group feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/5628433ccf331016e6c8a198ca836f2b32c92268) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169482))
- [GitLab Pages: Move error handling to model Gitlab::LetsEncrypt::Order](https://gitlab.com/gitlab-org/gitlab/-/commit/38436391e85a39de74617e52e82af9b402e1a4a1) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162835))
- [Remove ignore rule for identifier_external_ids column](https://gitlab.com/gitlab-org/gitlab/-/commit/70c48db303703e782f84a555cc4c40b51225f9c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169877)) **GitLab Enterprise Edition**
- [Finalize BackfillSubscriptionUserAddOnAssignmentsOrganizationId](https://gitlab.com/gitlab-org/gitlab/-/commit/b6ad59fe97874c8ce7c5081d6466597cce2d441b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169834))
- [Add NOT NULL for sharding key on approval_group_rules_users](https://gitlab.com/gitlab-org/gitlab/-/commit/20a1f59fe71f26d700fbc751dca39edf7162dd98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169836))
- [Emit concurrency limit stats in background sampler](https://gitlab.com/gitlab-org/gitlab/-/commit/4e3b54a4e0fd5a233f6da7bc3b25477570dbd09d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168926))
- [Change data consistency for workers maintained by source_code_manageme](https://gitlab.com/gitlab-org/gitlab/-/commit/36c74f4effdfeb151ed524f47fb6a7c9b4fef315) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169450))
- [Mark 20240219161432 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/0bbf4341916f3674194fe9767d44813f7a9c66b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169312)) **GitLab Enterprise Edition**
- [Replace ci_build_trace_metadata with dynamic partitions](https://gitlab.com/gitlab-org/gitlab/-/commit/27f6b7e59c872fc7c9ac6b03cd83cc85fc3d31a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169702))
- [Delete orphaned pipeline variables](https://gitlab.com/gitlab-org/gitlab/-/commit/277cf3836684ba446e8252abcbaa2c28b0202ec2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169441))
- [Update work_item_types FKs to UPDATE CASCADE](https://gitlab.com/gitlab-org/gitlab/-/commit/b87d0147df16be3434460ca76df0529b8a38aeb5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169351))
- [Change data consistency for workers maintained by user_profile](https://gitlab.com/gitlab-org/gitlab/-/commit/4d669123669235e8b8ecff0e7bceee313fbe385a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169452))
- [Mark 20240119130539 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/3512ce8416cb8a03fe85d1772d75b3c4550f1a74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169299)) **GitLab Enterprise Edition**
- [Ignore last_activity_on column](https://gitlab.com/gitlab-org/gitlab/-/commit/5481b722e65b1094dab7f5a462b3511b8d28e48f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168982))
- [Finalize migration BackfillBoardsEpicUserPreferencesGroupId](https://gitlab.com/gitlab-org/gitlab/-/commit/cc824bdac9189c0c0af83499f2c39f63e02f3523) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168459))
- [Replace ci_pipelines_config with dynamic partitions](https://gitlab.com/gitlab-org/gitlab/-/commit/175fac5d7a10913e1b227104786cc1a125e1b7ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169251))
- [Remove ignore state_changed_at_pipeline_id rule](https://gitlab.com/gitlab-org/gitlab/-/commit/2faf39f378f38bbfc317e7381dd0a6bd7781411f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169550)) **GitLab Enterprise Edition**
- [Remove FF ci_variables_optimization_for_yaml_and_node](https://gitlab.com/gitlab-org/gitlab/-/commit/e57de1b1814ee1f5dda5ed4804b89d3a7903f3bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169548))
- [Finalize BackfillDeployTokensShardingKey background migration](https://gitlab.com/gitlab-org/gitlab/-/commit/c4548003776bb4e73e48b97f7efeedad6f47d665) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166556))
- [Finalize DeleteOrphanedDeployTokens background migration](https://gitlab.com/gitlab-org/gitlab/-/commit/f52aa59dec9b7dde8874ade997e7da0d9031ed2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166557))
- [Allow the day 0 option of the trial widget to still show as active](https://gitlab.com/gitlab-org/gitlab/-/commit/ed48bcd921d525d75eb2ff2636280d1138bfb0b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169502)) **GitLab Enterprise Edition**
- [Use project_id as sharding key for packages_npm_metadata_caches table](https://gitlab.com/gitlab-org/gitlab/-/commit/70d6db4ddc987dd9c3ff3eb62b36b0bf7df84a60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169400))
- [Drop `vulnerability_count` column from `project_statistics` table](https://gitlab.com/gitlab-org/gitlab/-/commit/13f6c8abd674e06042120f929255fcc7c53cdd1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169479))
- [Updating Topology Service Client Gem to d88ee3c](https://gitlab.com/gitlab-org/gitlab/-/commit/ee8f40d860576b0d613ca1dd164cf53074be5970) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169326))
- [Suppresses Composite PK warning for Security::Finding](https://gitlab.com/gitlab-org/gitlab/-/commit/c0c3225837465d0bd62498435f3391d9f976ab47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169489)) **GitLab Enterprise Edition**
- [Reduce frequent nodes update](https://gitlab.com/gitlab-org/gitlab/-/commit/e9a71047a6d1ae96cd2651cfe0c6eaf00b2e44a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169148)) **GitLab Enterprise Edition**
- [Add and backfill group_id for dependency_proxy_manifest_states](https://gitlab.com/gitlab-org/gitlab/-/commit/d853077434814bc72990b4901a360415bd5b57e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169239))
- [Remove the search_issues_uses_work_items_index ff](https://gitlab.com/gitlab-org/gitlab/-/commit/c9cf150a71c794d9674795bf67ed89ced30cdbd6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169378)) **GitLab Enterprise Edition**
- [Mark 20240201164432 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/1bde603cf2077e1446240b79063595c83dd6b488) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169308)) **GitLab Enterprise Edition**
- [Change data consistency for workers maintained by devops_reports](https://gitlab.com/gitlab-org/gitlab/-/commit/07fd1c1739f087292f218e696e9237dd418618ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169451))
- [Mark 20240208160152 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/0a3226a6b4d369261cc029d10f3683613f3ed36b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169309)) **GitLab Enterprise Edition**
- [Add and backfill group_id for dependency_proxy_blob_states](https://gitlab.com/gitlab-org/gitlab/-/commit/cab0fea2e4756ae1a7e1bb67437346d9f1300574) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169237))
- [Add and backfill project_id for container_repository_states](https://gitlab.com/gitlab-org/gitlab/-/commit/71e3435683457d4813b36e4aa19ad9109a15fb15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169240))
- [Remove cross join suppression from vuln create service](https://gitlab.com/gitlab-org/gitlab/-/commit/69eb5c666d275514443db75db8ec8674c265ff04) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169431)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/725deb0e8cc4d8eecc2b55630d072859a8308083) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166799))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/510b3c00d3d18067440b04693fc926ec31dbbfd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166800))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/3cf25d1fb84a404ff9ce03019343e5e4710ffb0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168904))
- [Finalize migration BackfillComplianceFrameworkSecurityPoliciesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/44cf646b76b3b83ff3d711b022c65efe7d961117) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169202))
- [Drop index_for_owasp_top_10_group_level_reports idx](https://gitlab.com/gitlab-org/gitlab/-/commit/f76faed0e14aeb86a0591db0302dd9ff40255f98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165514))
- [Use Job::Setter to indicate resumed job for concurrency limiting](https://gitlab.com/gitlab-org/gitlab/-/commit/2d7b5ab43f92c1720da6263c19bceb759b6da702) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169220))
- [Index namespace historical vulnerability statistics table](https://gitlab.com/gitlab-org/gitlab/-/commit/8cc47fbaad449fe8eb12325d65464e70cd667c89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169170))
- [Remove unused Users::RecordLastActivityWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/56ca06fc1b3e582da4b4d2286e24d50101bd0920) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169131))
- [Remove block_password_auth_for_saml_users FF and the accompanying code](https://gitlab.com/gitlab-org/gitlab/-/commit/02ecabc6dd80b6a700aeec569014642dcb30704f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160850)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/7427f68ca476bd1294900155a2a93b470ef888a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165742))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/81ccade46593d99c938fd8ab03c2e299f6f62377) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164711))

## 17.5.5 (2025-01-08)

### Fixed (2 changes)

- [Fix ability to use password for Git when password for Web is disabled](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1b646d0e5d3fe2825a2ad2374687bfe68d3b289f)
- [Backport bugfix for diff_files highlighting](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c42bbbbb286533b0c05d8ea4ffccc38e9419f8ed)

### Security (4 changes)

- [Prevent cyclic reference in work item hierarchy widget from frontend](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ad6ec44b4d7913ac9d68c34f484dc6cb2d674f3d) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4687))
- [Allow external_provider config take precedence over external_groups](https://gitlab.com/gitlab-org/security/gitlab/-/commit/51bd1570e4cbf9c1e6fafe164fdda738150b4f69) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4658))
- [Filter out sensitive parameters on Auth logs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/45d1f89667f9f7488dbf5056934b81d097e9f7ac) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4667))
- [Don't allow unauthorized users to close issues automatically](https://gitlab.com/gitlab-org/security/gitlab/-/commit/301e42724feeaa53349a698e2985cb5e6400ff2a) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4676))

## 17.5.4 (2024-12-10)

### Fixed (1 change)

- [Fix 401 errors when installing the GitLab for Jira app](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5499b8941f6d0dec42bbd7469ca806890edae35e)

### Security (11 changes)

- [Add timeout around Parslet in template parser](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b9ce9e051da449add787b16f7cf2d08f8eb11115) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4654))
- [Add authorization check to protectableBranches field](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3f870e741e15034bca056fba125a0badbbe264bf) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4595))
- [Check harbor name & digest for path traversal](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2257cdf16e6ddbfdfddbbecd694e30589581be4e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4628))
- [Ignore titles for GFM links in rich text editor](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2215af32dfa6074844e4b39a5ce12dc8b2590d09) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4650))
- [Restrict user and group creation when same pages unique domain exist](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c7c6fbba10470644b4d532b3ba1aa00240bde391) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4576))
- [DoS by repeatedly sending unauthenticated requests for diff-files of a commit or merge request](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8f0c1b73b4e2584aba7866653828b15283d10a90) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4638))
- [Add query to filter_parameters](https://gitlab.com/gitlab-org/security/gitlab/-/commit/707d7792996ebe8e4c8da2a587810e3339432352) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4626))
- [Added invalid redirect fragment check](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e2760b5a3425f50c3444ff264d4e3381f11894ea) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4605))
- [Make confidential threads unresolvable via new issue](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a7ff5a159f7d699eec9e9844e5ab0727219ecb91) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4634))
- [Do not set session cookie for /v2 endpoints in the response](https://gitlab.com/gitlab-org/security/gitlab/-/commit/542c5b0dbc4744dab0d89bc42b34bfe16e760e54) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4631))
- [HTML injection in vulnerability details, leads to XSS on self hosted servers](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f7e572e94c2360b93fe6e04a65b9874975382693) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4553))

## 17.5.3 (2024-11-26)

### Fixed (1 change)

- [Ensure auto_merge_enabled is set when validating merge trains](https://gitlab.com/gitlab-org/security/gitlab/-/commit/91ef505e1e984525a22a92fefc6e88bfd6b55a14) **GitLab Enterprise Edition**

### Security (6 changes)

- [Add size check for harbor registry](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7aea8120573400b49f7cf99dfa775604a2c8255f) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4599))
- [Adding JobArtifactReport class to pre-emptively validate job artifacts](https://gitlab.com/gitlab-org/security/gitlab/-/commit/6702ca1b2f320429abf67741b70a969b8dee4185) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4568))
- [Fix: unsubscribe from actioncable channel when PAT is revoked](https://gitlab.com/gitlab-org/security/gitlab/-/commit/793476f8556c7db20633093e993298e8247ed1d4) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4550))
- [Allow a LFS token to be used only for LFS related requests](https://gitlab.com/gitlab-org/security/gitlab/-/commit/bc1281f297568cffe9f9ef9c4ddfdeb819dbc319) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4582))
- [Fix possible DOS with TOML file parsing](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7938b04aeae9ed9b6f75429367613df4b57d12b3) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4590))
- [Move allow_access_with_scope to class level](https://gitlab.com/gitlab-org/security/gitlab/-/commit/31ee3de85aa7a92e6ade8cb3a6dab69505d3cee6) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4611))

## 17.5.2 (2024-11-12)

### Fixed (4 changes)

- [Fix group wiki activity events breaking the user feed](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2c10d817d961bf6ae229fb436126713d0199aece)
- [Add param filtering to avoid error while saving project settings](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7e1bf6aa4087c0789ecff48ca716b30d841a3140) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171554)) **GitLab Enterprise Edition**
- [Fix new project group templates pagination](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3fed777c0e1f52816206b546f2063043febedd0b) **GitLab Enterprise Edition**
- [Update pdf worker file path in pdf viewer](https://gitlab.com/gitlab-org/security/gitlab/-/commit/406b66e9140b4ee4e79edc84e2870e0fbb90d149)

### Security (7 changes)

- [Add missing project_id for build_chat_data](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5a4e1bd3443cc786ab7558b1d6fa77962318c173) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4602))
- [Use custom adapter for parsing FogBugz XML](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f8c4b8942e6fca667c6a2b975d9fa792b0d559fa) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4592))
- [Removed id from authorize buttons and added specs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7e9ac80271a0c8a7ed73f1cb4a34f053652f07f6) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4573))
- [HTML injection in vulnerability Code flow leads to XSS on self hosted instances](https://gitlab.com/gitlab-org/security/gitlab/-/commit/fbff5c445ecc99f438ab56a0c5add0ff5cd1e2aa) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4564))
- [Remove is-unsafe-link from product analytics tables to prevent XSS](https://gitlab.com/gitlab-org/security/gitlab/-/commit/605d8bf88e03ec6f447141049952b623eab2200c) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4579))
- [Details of blocking merge request can be exposed via list](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0fe3d3020954f79337b6138e7b1ee6baed346c3c) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4545))
- [Prevent agent access via unconfirmed or disallowed group members](https://gitlab.com/gitlab-org/security/gitlab/-/commit/fa41ba0bc926e7b0091e4fb1cb6298b0b86eace5) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4559))

### Performance (1 change)

- [Remove permissions JSONB column from the condition](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a5b902c35e60e36f3e98db2af221976093fe2278)

## 17.5.1 (2024-10-22)

### Security (2 changes)

- [Fixed HTML injection in Global Search bug](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a7e8948dba537f4e625c155ab6554919c17377d6) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4542))
- [Limit max size of manifest file upload](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9bedc6764bd1de6fa694f15898cded41733982f4) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4541))

## 17.5.0 (2024-10-16)

### Added (145 changes)

- [Add X-Forwarded-To to allowed headers for email ingestion](https://gitlab.com/gitlab-org/gitlab/-/commit/e50f934dc3bcb7e1a9d85680d9c54a8ce8faebb1) by @divyamtayal ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168716))
- [Search API: Merge request support for title search_as_you_type](https://gitlab.com/gitlab-org/gitlab/-/commit/9e0d5caa5d6e07e2868a82a31b24862e06b46ee7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167432)) **GitLab Enterprise Edition**
- [Added the group select to the global timelogs report](https://gitlab.com/gitlab-org/gitlab/-/commit/9b4ed0b57d5cab002520a4fd8c9190ee5ccca459) by @zillemarco ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167238))
- [Add global work item epics feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/41c10350edd29e5046670756c9844fb0969fa6e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168943)) **GitLab Enterprise Edition**
- [Add support for updating abuse report notes](https://gitlab.com/gitlab-org/gitlab/-/commit/25369ba6fa9a66000d8e12d9afd73e29470814f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167011))
- [Audit merged MRs](https://gitlab.com/gitlab-org/gitlab/-/commit/de051e539c6f4cf1c26b9035fd2ccf17aec9b370) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164846)) **GitLab Enterprise Edition**
- [Add user level AI metrics API](https://gitlab.com/gitlab-org/gitlab/-/commit/838ccd4fb0c806464bced8feea26766888b98147) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166745)) **GitLab Enterprise Edition**
- [Reschedule BackfillPCiRunnerMachineBuildsProjectId migration](https://gitlab.com/gitlab-org/gitlab/-/commit/f447557e7b893457927711f9d856dc3bdb35c61d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168420))
- [Backfill runner_type, sharding_key_id columns on ci_runner_machines](https://gitlab.com/gitlab-org/gitlab/-/commit/a71538127ac2aafe0c8e9f3ffb92648811a28dd9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168651))
- [Add sharding key ci_pipeline_chat_data.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/d28b07c40ab58a4e2663847af820c0e21032770d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167729))
- [Add customize jira issue setting](https://gitlab.com/gitlab-org/gitlab/-/commit/ea22e7d7e6f3d01e32b3bb7029e46d3a3892d76c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164802)) **GitLab Enterprise Edition**
- [Create todos for expired SSH keys](https://gitlab.com/gitlab-org/gitlab/-/commit/dd9383c7162eec67bf62bcc5a9b7fbfff6768f93) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166168))
- [Implement project compliance center](https://gitlab.com/gitlab-org/gitlab/-/commit/daa6a9a5119f0d49e6b14458fcf4125dc6bed5f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168318)) **GitLab Enterprise Edition**
- [Add search button back to the header gated by feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e284b809076fbe43661ae47f9bf69461e41503a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165526))
- [History rewrite: send emails after asynchronous processing](https://gitlab.com/gitlab-org/gitlab/-/commit/d0d6a197f7b255df2d2ff6390f5254dde48d47f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167473))
- [Add Project.projectComplianceStandardsAdherence field](https://gitlab.com/gitlab-org/gitlab/-/commit/89007ca5a4a74eedfe72616c41e86b8c671b333c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168299)) **GitLab Enterprise Edition**
- [Add Project.projectComplianceStandardsAdherence field](https://gitlab.com/gitlab-org/gitlab/-/commit/9085b0ab5c92206855208e05007078697f84e6e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168260)) **GitLab Enterprise Edition**
- [Allow disabling password auth for SSO users](https://gitlab.com/gitlab-org/gitlab/-/commit/688786b4c616ed7f93c8eb4165439427c8200df3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168111))
- [Add download button to a health-check page](https://gitlab.com/gitlab-org/gitlab/-/commit/ec0b84cfb03cbadfe22084071a5c212394b1d351) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165032)) **GitLab Enterprise Edition**
- [Release project-level security exclusions feature](https://gitlab.com/gitlab-org/gitlab/-/commit/c1a49219c245e528a81f71ae1b3f9af1c4d36379) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168271)) **GitLab Enterprise Edition**
- [Directly ingest emails by custom email in To header](https://gitlab.com/gitlab-org/gitlab/-/commit/29da1cc92ddebfb4bf90694a52d376213a274a8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167770))
- [Add migrate_memberships to BulkImportEntities](https://gitlab.com/gitlab-org/gitlab/-/commit/21653f70ac61f2abf70a5f3fb2023aa961ceaa3e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168128))
- [Ignore column vulnerablity_count in project_statistics table](https://gitlab.com/gitlab-org/gitlab/-/commit/c4c510e6bc99e3c6f074986a01c929304168b4e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168284))
- [Add custom license to license widget](https://gitlab.com/gitlab-org/gitlab/-/commit/f6762215a74d672c8ed4e5a3e12c1a4ca5e55457) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162488)) **GitLab Enterprise Edition**
- [Update Saml NameID related authentication errors](https://gitlab.com/gitlab-org/gitlab/-/commit/720dad3842fd826c925c379a2600b989e1bc035f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168353)) **GitLab Enterprise Edition**
- [Add /help slash command](https://gitlab.com/gitlab-org/gitlab/-/commit/647bf92af43d1d0507018fffbc7cfcc486770f17) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167876)) **GitLab Enterprise Edition**
- [Integrate SD Exclusions with Scan Diffs feature](https://gitlab.com/gitlab-org/gitlab/-/commit/1eaff0b8c33107d5f95f455c6557f548b8b8bbdf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168364)) **GitLab Enterprise Edition**
- [Create audit event for container_repository_created](https://gitlab.com/gitlab-org/gitlab/-/commit/f146d9f2eab1f1d2c67f618d4fb21888ad390948) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156037)) **GitLab Enterprise Edition**
- [Document new API endpoint `POST /deploy_keys`](https://gitlab.com/gitlab-org/gitlab/-/commit/a0bacc4da1ce546ba5b68c1908633ee88e90d2c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167873))
- [Pull mirror API: extend response with mirror related fields](https://gitlab.com/gitlab-org/gitlab/-/commit/a2929c517696b305f94742b0d1e5b60c3ba04944) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168377))
- [Add update event handler for security policies](https://gitlab.com/gitlab-org/gitlab/-/commit/5f343163d5f088335663e3f82de6a64cfd5f857e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165572)) **GitLab Enterprise Edition**
- [Persist additional context in chat history](https://gitlab.com/gitlab-org/gitlab/-/commit/215d12834c623de975e0f277fea9a95c15cf4928) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168127)) **GitLab Enterprise Edition**
- [Model registry: Metrics for pull and push package](https://gitlab.com/gitlab-org/gitlab/-/commit/4064bf4d8fb245ec782adda654d08e3a2ca2531c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167298))
- [Add runner_type, sharding_key_id columns to ci_runner_machines](https://gitlab.com/gitlab-org/gitlab/-/commit/51f67409e49062f7340930b35edb835a7079fae4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168069))
- [Allow setting of weight on work item create](https://gitlab.com/gitlab-org/gitlab/-/commit/9c799b3ed901179eceb0cce2242e4ad66d2b4074) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168475)) **GitLab Enterprise Edition**
- [Restoration of object storage through gitlab-backup-cli](https://gitlab.com/gitlab-org/gitlab/-/commit/b6b9c6b9387e9250bff23f79ad7c71d0a0d41e2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163389))
- [Add FK on events.personal_namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/1829084aa298519b35ee81e067b007eef886c1be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168320))
- [Create AbuseReportLabelType GraphQL type](https://gitlab.com/gitlab-org/gitlab/-/commit/30968b5187756fc0f171334ef52ab429778e39b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168473))
- [Changed feature flag type from wip to beta](https://gitlab.com/gitlab-org/gitlab/-/commit/cbb6bcb6b262e4480e2ccf27fd00419da3d6b97a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167757)) **GitLab Enterprise Edition**
- [Introduce notes and notes_internal to WorkItems](https://gitlab.com/gitlab-org/gitlab/-/commit/64db46386933e53321994d4a1a20424f8b153ce4) by @joe-snyder ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168216)) **GitLab Enterprise Edition**
- [Changes for allowed_email_domain update audit event](https://gitlab.com/gitlab-org/gitlab/-/commit/7a76a2c665caddc38cbdc2011fe9d1b3e72f871a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166105))
- [Add migration and model for max retries and backoff](https://gitlab.com/gitlab-org/gitlab/-/commit/4a0d167477daf555cc89079cd64baa5407b92f36) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166119))
- [Added service ping metric for member management enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/e02f9dc1a6bf952ff91377c82415d5e1661c8941) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168096)) **GitLab Enterprise Edition**
- [Add members activity tracker worker](https://gitlab.com/gitlab-org/gitlab/-/commit/5911fc82d8f0cec1190028771f870640132fa171) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167423)) **GitLab Enterprise Edition**
- [Show location and ISP in sign in from new location email](https://gitlab.com/gitlab-org/gitlab/-/commit/d6be7a24f833a2f000e903ddfd4516c2a19bf931) by @shangsuru ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163914))
- [Add project.mergeRequestViolations field on project type](https://gitlab.com/gitlab-org/gitlab/-/commit/163bd7a56baefa7d323c5d8bd331c9f34723081f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158884)) **GitLab Enterprise Edition**
- [Added new table and API for Workflow Events](https://gitlab.com/gitlab-org/gitlab/-/commit/d2397278ebfae0ec323400fd9926ad473428cc25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166397)) **GitLab Enterprise Edition**
- [Enable edit_branch_rules feature falg by default](https://gitlab.com/gitlab-org/gitlab/-/commit/724653c4d4cc9883ce18049be5625d2965ddb032) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166654))
- [Add job_token_policies column to CI job token allowlist](https://gitlab.com/gitlab-org/gitlab/-/commit/1156ad38b4faa8ea70735876dec644f1378cda02) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166688))
- [Add work_item_epics_ssot feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e29682b09ab497bacdfcebfdcda0d256e7d344f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168174)) **GitLab Enterprise Edition**
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/59f33e5fdacad2fc90f78c11725314e168787178) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168202))
- [Alert success or file errors with model/version creation](https://gitlab.com/gitlab-org/gitlab/-/commit/c1ff9fc04813bb0a2bf759ef7d82f20c5372550c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166479))
- [Remove pypi_extract_pypi_package_model feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/85d5be158023e45cc1bc6c7a217a3c44afae6f47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167762))
- [Model Registry ability to delete experiment](https://gitlab.com/gitlab-org/gitlab/-/commit/18eb2732ed482284d4eb2b2425aa162b86e646f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167414))
- [Display page header and subheader](https://gitlab.com/gitlab-org/gitlab/-/commit/6509f8f185983b3dd9bce06a87a01a1da12f54c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167612)) **GitLab Enterprise Edition**
- [Add a GraphQL mutation for updating `OrganizationUser`](https://gitlab.com/gitlab-org/gitlab/-/commit/95b9e199ee1cdf17853ad4b2f61131f4be4c940c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168037))
- [Adds a cop and a generator to initialize bigint conversion](https://gitlab.com/gitlab-org/gitlab/-/commit/fff3f8369cc87460f6fee80d62ed3516512a083d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164788))
- [Add search argument to contributed projects GraphQL query](https://gitlab.com/gitlab-org/gitlab/-/commit/addaf622c113c95022e88fb97d6b68c8d138cedb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167966))
- [Add min_access_level and programming_language_name arguments](https://gitlab.com/gitlab-org/gitlab/-/commit/39f4ff2d7b58980f6ef32d08d2a8cb4871e940d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167962))
- [Add audit events for SD Exclusions on create, update and delete](https://gitlab.com/gitlab-org/gitlab/-/commit/bd4c946f826be442037776da4e084366060626ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167943)) **GitLab Enterprise Edition**
- [Add programming language filter to contributed projects GraphQL query](https://gitlab.com/gitlab-org/gitlab/-/commit/3dff73035f5b784ad929811887da716ba0638f55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167017))
- [Model Registry ability to delete candidate](https://gitlab.com/gitlab-org/gitlab/-/commit/a39b2f0d0b4a415b9af8430abd5f273750d01793) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167718))
- [Create merge request dependency api endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/3b92612d27b4a8dec8f196cbd0e68dbaeeb081e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166700)) **GitLab Enterprise Edition**
- [Add async index to partition table](https://gitlab.com/gitlab-org/gitlab/-/commit/b4a3ad684e40ac20b5dd3e459c6266bc88eba120) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167814))
- [Add instance level job token application settings](https://gitlab.com/gitlab-org/gitlab/-/commit/e1852d2b5b93559512feee725f4084ac3ef1395e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166952))
- [Add async index to partition table](https://gitlab.com/gitlab-org/gitlab/-/commit/68122df51808168f16c851fd4c76c4e21535fba4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167811))
- [Expose code suggestion events on GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/29c5c9218936e4d013c87d1541226b59637adb99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165565)) **GitLab Enterprise Edition**
- [Add sharding_key_id to ci_runners table](https://gitlab.com/gitlab-org/gitlab/-/commit/f891e25cda3463904a6c21f6e57850fea150af43) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166916))
- [Introduce group-level protected branches](https://gitlab.com/gitlab-org/gitlab/-/commit/a633fc221ff1f83b0d4f720411ffadda0f5cff69) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167753)) **GitLab Enterprise Edition**
- [Release "allow anyone to pull" feature for terraform modules](https://gitlab.com/gitlab-org/gitlab/-/commit/0df09a776924dc95bc3428c8faac2432b981439a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167739))
- [Update API and docs to account for non-billable promotions](https://gitlab.com/gitlab-org/gitlab/-/commit/b42f20115b6e83c020db173240f8e8da28e764d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167020)) **GitLab Enterprise Edition**
- [Populate personal namespace for events](https://gitlab.com/gitlab-org/gitlab/-/commit/6f6af234dee87200827153f25b107e069f494c01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164979))
- [Add ml-candidate-metadata sharding-key](https://gitlab.com/gitlab-org/gitlab/-/commit/c770a2096dbaf9908598289631f05eb1ba98a5ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167660))
- [Add aiFeatureSettings GQL query](https://gitlab.com/gitlab-org/gitlab/-/commit/659d8e03f89931638a69b1ec64c161730ad21ee2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166463)) **GitLab Enterprise Edition**
- [Ingest identifier_names of vulnerability_reads](https://gitlab.com/gitlab-org/gitlab/-/commit/f42afba65294540e03067cc950fb1d20e6f70dc8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163086))
- [Auto-ban duplicate users when a user is banned](https://gitlab.com/gitlab-org/gitlab/-/commit/0ac977cc965ad2664a7fe02dc8387d44a8dafe78) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166673))
- [Add new project redirect route to spec](https://gitlab.com/gitlab-org/gitlab/-/commit/b7cebc25cca7bdaae2751b20b7663db8fb960db2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165889))
- [Add Duo permission ability to vulnerability report](https://gitlab.com/gitlab-org/gitlab/-/commit/35a30d05511e5f4a8c87962193ed4589abf8ab7a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167583)) **GitLab Enterprise Edition**
- [Add UserActivity class](https://gitlab.com/gitlab-org/gitlab/-/commit/4dff8c5eea8efdcc227b85e7a4e3af8ffd92d855) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167035)) **GitLab Enterprise Edition**
- [Add a link to navigate to the CI/CD analytics on the pipelines page](https://gitlab.com/gitlab-org/gitlab/-/commit/4cd78d7504f49934c247ce819d384a0349cd46bb) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167311))
- [Enable CI job token authorizations log](https://gitlab.com/gitlab-org/gitlab/-/commit/329342b4b12b9a20e84c9a5f460e2513a8301cef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167416))
- [Model Registry ability to load model](https://gitlab.com/gitlab-org/gitlab/-/commit/9e2df64ca337ac3883e038a4ffabb54aba06c422) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165815))
- [Add migrate_memberships to bulk_import_config](https://gitlab.com/gitlab-org/gitlab/-/commit/70bccda6c6ee42de11d2353c33a3e542ad07b8c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167056))
- [Add duo free access ending alert banner](https://gitlab.com/gitlab-org/gitlab/-/commit/f8ddc764202b359e7aa085999684d02062526b25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167061)) **GitLab Enterprise Edition**
- [Delete stale npm metadata caches with background migration](https://gitlab.com/gitlab-org/gitlab/-/commit/f4d4ca9921889a52190f5f2f894e31800d54ab9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165813))
- [Add suffix strategy selector](https://gitlab.com/gitlab-org/gitlab/-/commit/ceb2fa2c7fb2e4d8d1f4f9ece3a7bbe04ce7eb95) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166549)) **GitLab Enterprise Edition**
- [Save draft data in storage](https://gitlab.com/gitlab-org/gitlab/-/commit/9de95c47c3e44b6bec50d07f908b76b9d0939580) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166586))
- [Add ability to remove resolved vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/32e3c13a5985d73e991473594ae118f72417d1f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166914)) **GitLab Enterprise Edition**
- [Add description field environments API](https://gitlab.com/gitlab-org/gitlab/-/commit/345f30d175d5ba270dbd31ad72871524a0242b4f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167079))
- [Expose `has_vulnerability_resolution` via GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/7f704def79735d36a980e72fc8b957d2e6a5860c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166312)) **GitLab Enterprise Edition**
- [Add description text field to environment details](https://gitlab.com/gitlab-org/gitlab/-/commit/093182d3e38039e69d8cf5a2e0d591357208a7a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167062))
- [Add description field to environment (BE & DB)](https://gitlab.com/gitlab-org/gitlab/-/commit/c963b54cdfa00a5f21c9ac6905e7cb6a4f740a7a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166941))
- [Create the snooze and un-snooze todos mutations](https://gitlab.com/gitlab-org/gitlab/-/commit/9331b24be15f604234eb7b04646dfacba82f8aa9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164262))
- [Filter merge trains by branch param](https://gitlab.com/gitlab-org/gitlab/-/commit/ce725c21a1eaa08b94942661de0bed6b6027fd9d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166949)) **GitLab Enterprise Edition**
- [Introduce a delete MR dependency api endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/fb1ae36c0f4fb5d29a9d6e5e4cf5be84e108139d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166339)) **GitLab Enterprise Edition**
- [Add `include_personal` argument to contributed projects GraphQL query](https://gitlab.com/gitlab-org/gitlab/-/commit/616f6dfb10be465829ab41e64638fa02c7a772d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167174))
- [GraphQL: Add `aggregate` field to PipelineAnalytics](https://gitlab.com/gitlab-org/gitlab/-/commit/719e68074bf30bb9f224d16b0c162bab503db360) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165549))
- [Update Llm completion for VR suggestion](https://gitlab.com/gitlab-org/gitlab/-/commit/cb4252ae300cfe7ed7396922ebf692fbee8bf0f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166230)) **GitLab Enterprise Edition**
- [Add source-branch filter](https://gitlab.com/gitlab-org/gitlab/-/commit/dfa9283d8c1aee78b05f3f1d3f4872d08b52c8fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156491))
- [Enable Ruby support for GitLab Advanced SAST](https://gitlab.com/gitlab-org/gitlab/-/commit/a319102766075cb2597a1365f28b602a246584b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165943))
- [Add ingestion for EPSS data into GitLab DB](https://gitlab.com/gitlab-org/gitlab/-/commit/6a17d43561196e6165c8ec1560ec3bdc4e520660) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164348)) **GitLab Enterprise Edition**
- [Remove feature flag vulnerability_resolution_ga](https://gitlab.com/gitlab-org/gitlab/-/commit/c5456f1548914668659ac06a67dafe9003a96988) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166354)) **GitLab Enterprise Edition**
- [Added membership_modified_by_admin_event](https://gitlab.com/gitlab-org/gitlab/-/commit/7a71e994d79cd3ba9752ce50df32cb54bc194bd1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163631)) **GitLab Enterprise Edition**
- [Protected branches API: support `deploy_key_id`](https://gitlab.com/gitlab-org/gitlab/-/commit/ffa03ce93bdfb03a2ceb8b86d87cc596bbc6583c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166598)) **GitLab Enterprise Edition**
- [Remove loose_foreign_keys_update_column_to feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4b159a7f0c266274ed4ff8a4f9bdbacd1d79259c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167006))
- [Add an empty state for MR approvals per branch](https://gitlab.com/gitlab-org/gitlab/-/commit/85ad6180f1d95e55bab21b24875a8298bf60285d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166996)) **GitLab Enterprise Edition**
- [Adds GitlabSubscriptions::SeatAssignment model](https://gitlab.com/gitlab-org/gitlab/-/commit/563a3eb96a81844a5bb495c3812335a4e4ec1b79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164799)) **GitLab Enterprise Edition**
- [Backfill for `vulnerability_reads.has_vulnerability_resolution`](https://gitlab.com/gitlab-org/gitlab/-/commit/5db7c9bf3c95d2185e71ece8e3856036277ee1c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166110)) **GitLab Enterprise Edition**
- [Elasticsearch: Merge requests with title completion](https://gitlab.com/gitlab-org/gitlab/-/commit/eac40c5be6b672138a38c6623ab3edb0101a1032) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166751)) **GitLab Enterprise Edition**
- [Add min_access_level argument to contributed projects GraphQL query](https://gitlab.com/gitlab-org/gitlab/-/commit/d79ebab6a1b1ed1ba8a1f7c19b8c3977a7dffbc7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166409))
- [Use CycloneDX SBOMs licenses in license scanner](https://gitlab.com/gitlab-org/gitlab/-/commit/abdfd55584c321e43e4b427f6d2bd03dc8b4c7aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162631)) **GitLab Enterprise Edition**
- [Add backticks to GitHub import user mentions](https://gitlab.com/gitlab-org/gitlab/-/commit/46dd8d71f2912a2fce793158657e0afecedf48bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166635))
- [Support for editing the model version description in the model registry](https://gitlab.com/gitlab-org/gitlab/-/commit/2ae4f7108fcbbc5112bb1795df28ec3205517094) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165539))
- [Add column 'max_number_of_vulnerabilities' to 'project_settings' table](https://gitlab.com/gitlab-org/gitlab/-/commit/a25e82643726a3f06f019c0fe9461808edf8c4f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166578))
- [Add RewriteHistoryWorker to asynchronously rewrite repository history](https://gitlab.com/gitlab-org/gitlab/-/commit/9b8bb4a8cf2e750ad47c8c7e983f1440d05f58f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162306))
- [Protected tags API: support `deploy_key_id`](https://gitlab.com/gitlab-org/gitlab/-/commit/5e428dfbbebc0692968757d1109f2fb8c0c84fc2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166866)) **GitLab Enterprise Edition**
- [Remove work_item_epics_rollout feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3efdcc118619284090d23a08ffb66ed9ce7b6a7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165338))
- [Add cron info to pipeline schedules table](https://gitlab.com/gitlab-org/gitlab/-/commit/1013d760aaa17eaf5f515d4c5265ffa5daed005f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166547))
- [Add subscribed argument to issues query](https://gitlab.com/gitlab-org/gitlab/-/commit/738d8e2cdac5d3b633a1238426b7a6cde8c4133e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/134807))
- [Initial checkin for Banner](https://gitlab.com/gitlab-org/gitlab/-/commit/9bc518e510d2e45905c6bec6048e4f9e6eabaaa5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165756)) **GitLab Enterprise Edition**
- [Change relationship type of linked items via drag & drop](https://gitlab.com/gitlab-org/gitlab/-/commit/97bdd0a47b648241d90a23f6b58eb17e8c3f0edd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164296))
- [Remove references to gitlab_com_duo_pro_bulk_user_assignment](https://gitlab.com/gitlab-org/gitlab/-/commit/6d3312d46ddefb2eb0799bb8a35242cdf08d446a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166747))
- [Add rails endpoinds for workflow status updates](https://gitlab.com/gitlab-org/gitlab/-/commit/16ee928bc5e7d6e16d0feda57e710dc6d2de30d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165818)) **GitLab Enterprise Edition**
- [Add event handlers for security policies changes](https://gitlab.com/gitlab-org/gitlab/-/commit/a9182c9344c1785fe80b2a9a2f14241b59ac633d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165569)) **GitLab Enterprise Edition**
- [Add API endpoint to publish CI Catalog Resource Version](https://gitlab.com/gitlab-org/gitlab/-/commit/9db6aa7ed4820488e817096759d8d4d10622032d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164858))
- [Add language filter to projects GraphQL query](https://gitlab.com/gitlab-org/gitlab/-/commit/935b8fd064877aec1f37556a569d3eee8b47dcf9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166098))
- [Database changes for splitting microsoft applications](https://gitlab.com/gitlab-org/gitlab/-/commit/6467dddd1286a663877d2b8b9d5cc41bbddfe5da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164377))
- [Add vuln counts to container regsitry page](https://gitlab.com/gitlab-org/gitlab/-/commit/70c9d6928209e1d6504c94dbf0d46bc4ac4d26fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161994))
- [Add license checks to group level work items ability checks](https://gitlab.com/gitlab-org/gitlab/-/commit/6800de2b04e5ddab1937d36ba2891ea19a889aea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165909))
- [Add log fingerprint to the created issue](https://gitlab.com/gitlab-org/gitlab/-/commit/3cb1073119f2be42d85dd605ddf27ba5b855061d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166214)) **GitLab Enterprise Edition**
- [Add min_access_level argument to Projects GraphQL query](https://gitlab.com/gitlab-org/gitlab/-/commit/1f94c52f172b45be3fb72d5a613bf76e97d59368) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166376))
- [Add graphql mutations for project security exclusions](https://gitlab.com/gitlab-org/gitlab/-/commit/1d3f7c7c1336f708a8f03bfd25010a7208ca9235) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165396)) **GitLab Enterprise Edition**
- [Admin API Endpoint: Token Info](https://gitlab.com/gitlab-org/gitlab/-/commit/142cca525f054dae36fdaf9b1368f7c7db9246f9) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165157))
- [Release "allow anyone to pull" feature for group-level maven endpoints](https://gitlab.com/gitlab-org/gitlab/-/commit/c4ff30e55761c74c20d4776e724bfb58e8e91f01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166115))
- [Add artifacts archive setting](https://gitlab.com/gitlab-org/gitlab/-/commit/f8d5adce372ebbac2dd1036f658c32961f5019eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166496))
- [Release "allow anyone to pull" feature for group-level NuGet endpoints](https://gitlab.com/gitlab-org/gitlab/-/commit/e3020839c59d094d1058b89ccc87a3a9913e785a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164325))
- [Delete `custom_ability_admin_runners` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/68efeab37432d0579da5c16065b0f93c086398f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163234)) **GitLab Enterprise Edition**
- [Persist approval_policy_rule_id for scan_result_policy_violations](https://gitlab.com/gitlab-org/gitlab/-/commit/5068afd1791dfec1817b7f3275ddab680d3ae6d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164808)) **GitLab Enterprise Edition**
- [Move the zoekt_repository to failed if retries_left gets 0](https://gitlab.com/gitlab-org/gitlab/-/commit/11fdad2ff35c1707d03651142bf21428de7d02d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165187)) **GitLab Enterprise Edition**
- [Rename and add fields additional context rest api](https://gitlab.com/gitlab-org/gitlab/-/commit/96006484858a7c8cd5b369f20185e87515ee6d14) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164944)) **GitLab Enterprise Edition**
- [Show SBOM reports errors on the pipeline security and licenses tabs](https://gitlab.com/gitlab-org/gitlab/-/commit/1f079c0ae6293aff0bf95597001a6c9a56419e96) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161235)) **GitLab Enterprise Edition**
- [Enable dependency_scanning_using_sbom_reports by](https://gitlab.com/gitlab-org/gitlab/-/commit/b44bc52692676d7894aaa2c363cb845e12b75491) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165775)) **GitLab Enterprise Edition**
- [Add aiSelfHostedModelFeatureSettings query](https://gitlab.com/gitlab-org/gitlab/-/commit/b26d01ea4138e0e2585e8dc2831271f8ab7a3aea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166315)) **GitLab Enterprise Edition**
- [Add merge_after attribute to MergeRequest](https://gitlab.com/gitlab-org/gitlab/-/commit/c36f582d9f5134693add8cde163744ec2344337f) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165092))
- [Suspend/Resume flux reconciliation from the UI](https://gitlab.com/gitlab-org/gitlab/-/commit/9e94ac3afdd5a91464498e1ae721f25339cab13b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165955))

### Fixed (132 changes)

- [Protected containers: Push protection for admin users](https://gitlab.com/gitlab-org/gitlab/-/commit/443b67e0f0a7aa50f6a34b88c2acccc2f69f6b63) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157464))
- [Prevent submitting form when pressing enter in transfer location search](https://gitlab.com/gitlab-org/gitlab/-/commit/4326a77740e85de613744ef3ba84278f9c4300db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168440))
- [Revert "Fix Helm chart appVersion not being quoted in index.yaml"](https://gitlab.com/gitlab-org/gitlab/-/commit/f5468087f7ce77a04f14d054817dfc3be8145b01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169141))
- [Cloud Connector sync: Read license from DB](https://gitlab.com/gitlab-org/gitlab/-/commit/24faba75877ffc5454e98c6b83fc30570587d1c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168796)) **GitLab Enterprise Edition**
- [Revert "Merge branch 'sc1-optimise-concurrency-tracking' into 'master'"](https://gitlab.com/gitlab-org/gitlab/-/commit/58924e97585f2fe2f5c6cac3ca1bf513ed67f03a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169050))
- [Fix handling of loading secrets with empty section](https://gitlab.com/gitlab-org/gitlab/-/commit/c25f903f3cff73bb47b2d1ee9ade9febfd170b07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168902))
- [Merge requests API: fix cache for "with_labels_details" argument](https://gitlab.com/gitlab-org/gitlab/-/commit/3d7e2858794c7a44225b1c6e8e9ed08095fd4e08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167440))
- [Labels page: Fix vertical alignment and badge](https://gitlab.com/gitlab-org/gitlab/-/commit/6bdc6cb4fd6069f1c821150ca5f64efaf662a7c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168932))
- [Prevent non-ASCII names](https://gitlab.com/gitlab-org/gitlab/-/commit/21020627671ee03012b5f1e8637d11725fc732e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168899))
- [Mini Pipeline graph: Fix height of item and alignment of retry](https://gitlab.com/gitlab-org/gitlab/-/commit/f964a98df5ebf6221ec72539045569051fb08a53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168798))
- [Add response-content-disposition to url in  Workhorse.send_url](https://gitlab.com/gitlab-org/gitlab/-/commit/eeb0598b35e889dc96aa108d59bb36363603643f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167015))
- [PullMirrors::UpdateService: remove previous data after mirror's update](https://gitlab