# TypeScript Definitions Coverage

This document provides an overview of TypeScript definitions that are currently captured by our parser, along with definitions that should be added in future iterations.
Do note that this also includes support for Javascript natively, as typescript is a superset of JS.

> See the [Typescript Parser](parser_overview.md) documentation for how the parser works.

## Currently Supported Definitions

| Definition Type | Status | Description | Example | Capture Variables | FQN Support |
|----------------|--------|-------------|---------|-------------------|-------------|
| **Class** | ✅ Supported | Class declarations | `class User extends BaseUser` | `CLASS_DEF_NAME` | ✅ Full |
| **Named Class Expression** | ✅ Supported | Class expressions assigned to variables/constants | `const UserClass = class {}` | `CLASS_EXPR_NAME`, `CLASS_EXPR_BODY` | ✅ Full |
| **Method** | ✅ Supported | Instance and class methods in classes | `authenticate(user, password)` | `METHOD_DEF_NAME` | ✅ Full |
| **Static Field** | ✅ Supported | Static class fields with expressions | `static InnerStatic = class {}` | `CLASS_EXPR_NAME`, `CLASS_EXPR_BODY` | ✅ Full |
| **Private Method** | ✅ Supported | Private class methods | `#validateConfig(config)` | `METHOD_DEF_NAME` | ✅ Full |
| **Function** | ✅ Supported | Function declarations | `function authenticate(user, password)` | `FUNCTION_DEF_NAME` | ✅ Full |
| **Named Arrow Function** | ✅ Supported | Arrow functions assigned to variables/constants | `const validate = (input) => {}` | `NAMED_ARROW_FUNC_DEF_NAME`, `NAMED_ARROW_FUNC_BODY` | ✅ Full |
| **Named Function Expression** | ✅ Supported | Function expressions assigned to variables/constants | `const validate = function(input) {}` | `NAMED_FUNC_EXP_NAME`, `NAMED_FUNC_EXP_BODY` | ✅ Full |
| **Named Generator Function** | ✅ Supported | Generator functions assigned to variables/constants | `const generator = function* () {}` | `NAMED_GENERATOR_FUNC_DEF_NAME`, `NAMED_GENERATOR_FUNC_BODY` | ✅ Full |

## Missing Definitions (Future Roadmap)

| Definition Type | Description | Example | Complexity | Notes |
|----------------|-------------|---------|------------|-------|
| **Object Methods** | Methods defined in object literals | `const obj = { method() {} }` | Medium | Important for object-oriented patterns |
| **Getters/Setters** | Property accessors in objects and classes | `get name() {}` | Medium | Essential for property access patterns |
| **Decorators** | Method and class decorators | `@decorator class` | High | Requires experimental support |
| **Complex Class Expressions** | Classes defined in object literals or complex expressions | `const classes = { A: class A {} }` | High | Important for class factories and registries |
| **Class Factory Functions** | Functions that return class definitions | `const ClassFactory = (base) => class extends base {}` | High | Essential for higher-order component patterns |
| **Dynamic Method Names** | Methods with computed property names | `[`dynamic${Date.now()}`]() {}` | Medium | Important for meta-programming |
| **Named IIFEs** | Named Immediately Invoked Function Expressions | `(function namedIIFE() {})()` | Low | Useful for debugging and stack traces |
| **Ambient Declarations** | Declarations using the `declare` keyword | `declare class ExternalClass {}` | Medium | Important for type definitions and module augmentation |
| **Enums** | Enumerated type definitions | `enum Direction { Up, Down }` | Low | Common in TypeScript for defining constants |
| **Interface Method Declarations** | Method signatures in interfaces | `interface Name { methodName(): void }` | Low | Essential for interface definitions and type contracts |

## Currently Supported Imports

The parser supports a wide range of ES and CommonJS import syntaxes, which are crucial for understanding module dependencies.

| Import Type | Status | Description | Example |
|----------------|--------|-------------|---------|
| **Default Import** | ✅ Supported | Default exports from a module | `import React from 'react'` |
| **Named Import** | ✅ Supported | Named exports from a module | `import { useState } from 'react'` |
| **Aliased Import** | ✅ Supported | Renaming named exports during import | `import { Component as ReactComponent } from 'react'` |
| **Mixed Imports** | ✅ Supported | Combining multiple import types in one statement | `import D, { A, B as C } from 'mod'` |
| **Namespace Import** | ✅ Supported | Importing all exports as a single object | `import * as React from 'react'` |
| **Side-Effect Import** | ✅ Supported | Importing a module for its side effects only | `import 'reflect-metadata'` |
| **CommonJS Require** | ✅ Supported | Basic `require()` for single variable assignment | `const fs = require('fs')` |
| **Destructured Require** | ✅ Supported | Destructuring `require()` for named members | `const { readFile } = require('fs')` |
| **Aliased Destructured Require** | ✅ Supported | Destructuring `require()` with renaming | `const { readFile: fsRead } = require('fs')` |
| **Mixed Destructured Require** | ✅ Supported | Combining aliased and non-aliased destructuring | `const { A, B: C } = require('mod')` |
| **Dynamic `import()`** | ✅ Supported | Dynamic `import()` with static string source | `const fs = await import('fs')` |
| **Side-Effect `require()`** | ✅ Supported | `require()` a module for its side effects | `require('dotenv/config')` |
| **TypeScript `import = require`** | ✅ Supported | TypeScript-specific import-require syntax | `import express = require('express')` |
| **Type-Only Imports** | ✅ Partially Supported | TypeScript `import type` syntax (parsed as value imports) | `import type { FC } from 'react'` |

## Missing Imports (Future Roadmap)

| Import Type | Description | Example | Complexity | Notes |
|----------------|-------------|---------|------------|-------|
| **Re-exports** | Re-exporting symbols from another module | `export { Component } from 'react'` | Medium | Essential for creating module entry points. |
| **Dynamic Import with Expressions** | `import()` with a variable or expression as the source | `const module = await import(moduleName)` | High | Important for plugins and conditional loading. |
| **Import Assertions** | `assert` clause for imports (e.g., for JSON modules) | `import config from './config.json' assert { type: 'json' }` | Medium | A modern feature for importing non-JS assets. |
| **Full Type-Only Import Metadata** | Distinguishing type-only imports from value imports. | `import type { FC, T as U } from 'react'` | Low | The parser recognizes type-only import syntax but treats them as standard value imports (`DefaultImport`, `NamedImport`, `AliasedImport`). It does not yet capture their specific type-only nature. |
