## [0.20.2](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.20.1...v0.20.2) (2025-11-11)

### :bug: Fixes

* add version checking to libparser downloader ([e888634](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/e888634cfb89b09e50c7e74df27db3d0df2fc20a)) by Dmitry Gruzd
* **java:** parse Java expressions iteratively ([924bd05](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/924bd056b74796d698c44248b9d713b2909a921c)) by Jean-Gabriel Doyon

## [0.20.1](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.20.0...v0.20.1) (2025-10-22)

### :bug: Fixes

* **chunker:** use fallback when we run out of code splits to use ([11475ab](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/11475abd1479b3f40d535980edc5b48001136518)) by James Fargher

### :repeat: Chore

* **deps:** update rust crate zip to v4.6.1 ([c9b00e9](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/c9b00e9dbe6be14121e186d8fc2599b173980bcb)) by GitLab Renovate Bot

## [0.20.0](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.19.3...v0.20.0) (2025-10-15)

### :sparkles: Features

* **chunker:** add token chunk size limits ([db5d58b](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/db5d58b7aaf2af7a55b19a89ab8c040e54632f39)) by James Fargher

## [0.19.3](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.19.2...v0.19.3) (2025-10-03)

### :fast_forward: Performance

* **indexing:** optimize referenceinfo for memory ([cd2121d](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/cd2121db66fb2db9a640a436739531cf377bb14c)) by Bohdan Parkhomchuk

## [0.19.2](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.19.1...v0.19.2) (2025-10-01)

### :fast_forward: Performance

* reduce memory usage by using dynamic structures and shrinking them ([08e2c57](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/08e2c57c21f3fa6ae92e5b57a027f82bbdb377b5)) by Bohdan Parkhomchuk

## [0.19.1](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.19.0...v0.19.1) (2025-09-30)

### :fast_forward: Performance

* **parsing:** reduce memory usage with fqn parts interning ([727648a](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/727648a21cfd27089aaa76a3c753c9f657ab4312)) by Bohdan Parkhomchuk
* **parsing:** use empty name for Kotlin and Java expressions ([9f7babd](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/9f7babd3d786205555bf39a83c50ce317591da73)) by Jean-Gabriel Doyon

## [0.19.0](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.18.1...v0.19.0) (2025-09-29)

### :sparkles: Features

* **kotlin:** parse kotlin expressions ([e9a8e8b](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/e9a8e8b09b32d7831aca5e70ffd251af6a52e3ab)) by Jean-Gabriel Doyon

## [0.18.1](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.18.0...v0.18.1) (2025-09-17)

### :bug: Fixes

* **java:** ensure java file is a lexical scope to support scripting file declarations ([066c9f6](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/066c9f6a628480b0598d9bcd4bb9e2cc4a170fc3)) by Jean-Gabriel Doyon

## [0.18.0](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.17.0...v0.18.0) (2025-09-14)

### :sparkles: Features

* **ts:** migrating ts/js imports to swc ([27ae6cb](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/27ae6cb143f5bb5a93eba3567fadfacbb24272d8)) by Michael Usachenko

### :bug: Fixes

* **java:** resource variables should not create a lexical scope ([2dba7fd](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/2dba7fd593c2a8b4bdbc4e034d22cf8bfcdd64fb)) by Jean-Gabriel Doyon

### :repeat: Chore

* **deps:** update rust crate mimalloc to v0.1.48 ([f205924](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/f2059249e028b2bd24f9cdc6bb8f70a696b4ec0c)) by GitLab Renovate Bot
* **mr:** shorten performance analysis section in merge request ([a982520](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/a9825206a17d4d6e1e8900b3f011a78449891c88)) by Jean-Gabriel Doyon

## [0.17.0](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.16.1...v0.17.0) (2025-08-25)

### :sparkles: Features

* **java:** parse Java references ([9f5bbf3](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/9f5bbf3d21abf6e0b461140d5cda6efddb9772f5)) by Jean-Gabriel Doyon
* **ts:** integrating swc parser for js/ts ([1390ff6](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/1390ff6d2a056e4cfc63e42aea0e5f2f5e546164)) by Michael Usachenko
* **ts:** migrating ts/js definition parsing to swc ([805a69f](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/805a69f9435fab41150fe99812c6b0bb07569c01)) by Michael Usachenko

### :repeat: Chore

* **deps:** bump dependencies ([af53ff5](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/af53ff56eabd1921fdd3bba615b6ae178e2e1474)) by Michael Usachenko
* **deps:** update rust crate thiserror to v2.0.15 ([561e41b](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/561e41b3d91b59aa108ce50fc199410c9238befe)) by GitLab Renovate Bot

## [0.16.1](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.16.0...v0.16.1) (2025-08-19)

### :bug: Fixes

* **py:** memoized data flow graph traversals during reference resolution (Python) ([0a69e5b](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/0a69e5b406b77675d31ba4e205fd5a1ee0dbc103)) by Jonathan Shobrook

### :repeat: Chore

* **deps:** update rust crate ast-grep-language to v0.39.4 ([ca828f6](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/ca828f63cbc869f55b781d39e4d1d6940de2853b)) by GitLab Renovate Bot

## [0.16.0](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.15.2...v0.16.0) (2025-08-17)

### :sparkles: Features

* **py:** parsing and resolving references ([17d476e](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/17d476e28aeafc2da7bf49003b0b464421cbce2b)) by Jonathan Shobrook

### :bug: Fixes

* **chunker:** ensure size chunker does not split multi-byte utf-8 characters ([187ff86](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/187ff8697bfa9e30617b437b2102395e0e1d7a4c)) by James Fargher

## [0.15.2](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.15.1...v0.15.2) (2025-08-14)

### :repeat: Chore

* **bindings/go:** add license file ([2b15971](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/2b159719314638b42210e7c6de53e0b73096ea26)) by James Fargher

## [0.15.1](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.15.0...v0.15.1) (2025-08-14)

### :bug: Fixes

* **ts:** fix bug with ts intra-file reference scope assignment ([c7adf33](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/c7adf33820922d6bac682b90a752abae8bf06c67)) by Michael Usachenko

## [0.15.0](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.14.1...v0.15.0) (2025-08-14)

### :sparkles: Features

* **cli:** adding parsing statistics to cli --analyze ([eb151cd](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/eb151cd939a439510d7ea95522a0d9d4be66e3e7)) by Michael Usachenko
* **kotlin:** parse Kotlin same file references ([c224e6c](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/c224e6cfeaf167cb8ef29663651bc0a7275494b1)) by Jean-Gabriel Doyon
* **parser:** added excluded extensions field for SupportedLanguage ([5e89d84](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/5e89d84cc3345fcf66aba36a9ad17ed918e34876)) by Michael Usachenko
* **ruby:** add expressions and references ([94bd645](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/94bd645a872dec28eb0a6fe8f79b7f68b13e876d)) by Michael Angelo Rivera
* **ruby:** add ruby to parser cli ([8adda0e](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/8adda0e14177bf9562af7e366ea95244c90137bb)) by Michael Angelo Rivera
* **ruby:** introduce prism parser ([c735dc5](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/c735dc58895de4dad6cd563b5786c76ec0c02155)) by michaelangeloio
* **ruby:** introduce prism visitor ([98a5735](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/98a57355fc61809c9eacfe4ce2bba9cc396f9c57)) by michaelangeloio
* **ruby:** switch definitions and fqn to prism ([383c531](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/383c531f77d93dca7bd426be2a196ec0c10b3348)) by michaelangeloio

### :bug: Fixes

* **py:** designed scope hierarchy to be more memory efficient ([2c8769b](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/2c8769b28c8d871b68c8afc5740fcd11c30885a3)) by Jonathan Shobrook

### :white_check_mark: Tests

* switch to new benchmarking framework ([5672e68](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/5672e6846e1f4b7b11138fc2fe9654c4fa4b761e)) by michaelangeloio

### :repeat: Chore

* **deps:** update rust crate clap to v4.5.45 ([ce90e85](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/ce90e858b1534e2acaae7a5ecba3c6b1b3e9c7dc)) by GitLab Renovate Bot
* **deps:** update rust crate reqwest to v0.12.23 ([3e04c4f](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/3e04c4f6020326f5990a62ef36a6986634b26afa)) by GitLab Renovate Bot
* **deps:** update rust crate thiserror to v2.0.14 ([5340f92](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/5340f92f8eda6eba4413d5e5fe284e947ca0d085)) by GitLab Renovate Bot
* **utils:** exposing interval tree generic as a proper utility ([dec1b55](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/dec1b550aa182767905585609982dfb40521682c)) by Michael Usachenko

## [0.14.1](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.14.0...v0.14.1) (2025-08-14)

### :bug: Fixes

* **bindings/go:** stop using os.Root ([7c8027a](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/7c8027a1ab1e91727981f82fd9e2b110208f268c)) by James Fargher

### :repeat: Chore

* **ci:** fix command to push go tag ([9b089ec](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/9b089ecedddf544a0f26d077e908bdf867b1df32)) by Bohdan Parkhomchuk

## [0.14.0](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.13.0...v0.14.0) (2025-08-14)

### :sparkles: Features

* **py:** added symbol table builder ([59a650b](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/59a650b84380880a4fd729ba2509e3a757eea791)) by Jonathan Shobrook
* **ts:** basic intra-file reference resolution + infra for scope-aware resolution ([6142173](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/61421733031248b3ea131ebe2ed616276d289e3e)) by Michael Usachenko

### :bug: Fixes

* **ts:** assign correct scope to ts references during resolution ([42b159c](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/42b159c468ca0dace011ace5704cd41df77d1dad)) by Michael Usachenko

### :repeat: Chore

* **csharp:** add missing implementations ([2ed8590](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/2ed8590fad1362a137a1b8acf20ca45c83571060)) by Bohdan Parkhomchuk
* **release:** push go binding release tag ([862bd63](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/862bd63ff7a453952ac90d68ac3b4866242b6a2a)) by James Fargher

## [0.13.0](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.12.0...v0.13.0) (2025-08-12)

### :sparkles: Features

* **bindings/go:** add download command ([554940a](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/554940a7a58409dc97443ad5f9a6470110f9352f)) by James Fargher

## [0.12.0](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.11.0...v0.12.0) (2025-08-12)

### :sparkles: Features

* **cli:** simple cli for local benching and measuring relative performance differences ([79087d6](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/79087d69a1b6a74bbfdf02105a90741d28e3e97a)) by Michael Usachenko
* **parser:** add references to analyzer result ([75297b7](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/75297b7a44239d357a6615906efc580e64a27163)) by michaelangeloio
* **parser:** add scope to references ([c720b1d](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/c720b1dae82573a02d62463a32a8a1c8aeb6758a)) by michaelangeloio
* **perf:** added support for mimalloc ([1e261fa](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/1e261faf98ed81f0a2ebf504d3eeec23b9477304)) by Michael Usachenko
* **ts:** expression builder for ts/js intra-file reference resolution ([229c046](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/229c046f6538073fad0c6cf922ec84b554d6c96e)) by Michael Usachenko

### :fast_forward: Performance

* **cli:** only allocate analyzers once per thread + allow per lang benching ([45c1e56](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/45c1e56bf85babbd66162ed4158bc8075d94f2f6)) by Michael Usachenko

### :repeat: Chore

* **bindings/go:** add compiled libraries and header to gitlab release ([4118868](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/411886872fea3cb42d798020dbaad4e80bc61d69)) by James Fargher
* **ci:** fix ci failure in forks ([0aa7e02](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/0aa7e029db58e402a99770ed018b4f65be6bc8aa)) by Bohdan Parkhomchuk
* **csharp:** cleanup after ast grep usage removal ([2686d89](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/2686d894f66729c058f9f0d51ef2318f129cdbaf)) by Bohdan Parkhomchuk
* **deps:** update ast-grep ([40d60af](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/40d60af09a2e37f76d97677ca1f99685f8ff55cd)) by Bohdan Parkhomchuk
* **deps:** update rust crate ast-grep-config to v0.39.3 ([51375d5](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/51375d5d1b81d3e1d3a985874dd8a38b38677b40)) by GitLab Renovate Bot
* **deps:** update rust crate ast-grep-core to v0.39.3 ([451d24f](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/451d24f834800d3034057c450523a6a0ba3255b0)) by GitLab Renovate Bot
* **deps:** update rust crate clap to v4.5.43 ([120dd19](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/120dd19db39c74c6707d6bcab162d19ad789d2f1)) by GitLab Renovate Bot
* **deps:** upgrade rust to 1.89.0 ([2a77787](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/2a77787fc2bc15c1bc123dffb09a1c1a88ae1f18)) by michaelangeloio
* **gitlab-ci:** fix release tar invocation ([ba475a8](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/ba475a8a19f2c4802b218f81305bf3c73c312e72)) by James Fargher
* **perf:** added full lto and set codegen units to 1 for release builds ([e1d1e90](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/e1d1e9005ec97fde8cd16c6fb3b4aad10c845485)) by Michael Usachenko
* **releaserc:** remove trailing comma ([67d90da](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/67d90dade0d2a61a66f3c4b7afbd314c723d35d9)) by James Fargher

## [0.11.0](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.10.0...v0.11.0) (2025-08-06)

### :sparkles: Features

* **csharp:** imports parsing ([720e6e3](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/720e6e33853ded91021afb4eb80976419f9b7c2c)) by Bohdan Parkhomchuk
* **csharp:** parse definitions without ast-grep rules ([571bd17](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/571bd175f8628c78dc3920a08109444fa9a32404)) by Bohdan Parkhomchuk
* **java:** parse definitions without ast-grep ([c6b358a](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/c6b358a1c2e2dba52a4f9f5e3372db98b43fae49)) by Jean-Gabriel Doyon
* **java:** parse Java definitions and import in a single pass ([1d828da](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/1d828da22380ffaa570dd5f6578b14792c137a35)) by Jean-Gabriel Doyon
* **kotlin:** parse definitions without ast-grep ([ee7f800](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/ee7f800000f1994c368edf6d25fa7ee99eba2ba4)) by Jean-Gabriel Doyon
* **kotlin:** parse Kotlin imports and definitions in a single pass ([fe6caf6](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/fe6caf6cac0fd277715bb9983b438a5462f4e1ef)) by Jean-Gabriel Doyon

### :bug: Fixes

* **rust:** unique import identifier ranges ([79a28e8](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/79a28e8618d6925b5b8db52fe3a1fbef3a9533e3)) by Michael Angelo Rivera

### :fast_forward: Performance

* **ts:** replace TS/JS ast grep import parsing with ast traversal ([bdd9a2c](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/bdd9a2c0dda35cd9a6b21b78ef5c9740606c62b9)) by Michael Usachenko

### :repeat: Chore

* update default mr template ([a9ff1fe](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/a9ff1fe1981128816653bb3f5d880d9efc086144)) by michaelangeloio

## [0.10.0](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.9.0...v0.10.0) (2025-08-05)

### :sparkles: Features

* **chunker:** add line number tracking to code chunks ([43863b8](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/43863b8dc6bc6b9c0ad8c2076d5beb574c2adc63)) by Vitali Tatarintev
* **ruby:** add imports ([7a796e3](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/7a796e35158b6e6a1b4ba7065c948cb9ecee7a67)) by Michael Angelo Rivera
* **rust:** add definitions ([829c579](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/829c57985253751d51ddae7eb025a7673a80efe7)) by michaelangeloio
* **rust:** add imports ([e316f4b](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/e316f4b62443fddb4df6b405eaef7714d778f12f)) by michaelangeloio
* **rust:** add rust ast ([3675b8c](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/3675b8cf90321e013e2b9489eb1d3581ea8bb225)) by michaelangeloio
* **rust:** add rust fqn and types ([13240d4](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/13240d48a1483c1b48a4b04fe4d2877893e67d23)) by michaelangeloio
* **ts:** remove ast grep for ts definitions ([c38428f](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/c38428f537a085d512f8bea468aef032261a64ce)) by Michael Usachenko

### :bug: Fixes

* **chunker:** handle chunk size and parsing errors within the code chunker ([329c911](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/329c911da4d7d8872e9cbe72c849c244b7ec0784)) by Tian Gao
* **parser:** make ast-grep rules optional ([b312bfd](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/b312bfd3c2975e11f578457aff35c6eea9243587)) by michaelangeloio
* **test:** yaml rule loading ([e49ea55](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/e49ea552bb892592ccd96fb9164ff6c077af97d5)) by michaelangeloio

### :zap: Refactor

* **parser:** make FQN mandatory for all definitions ([5914029](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/5914029e1b3778263692764fbcb943279686d55b)) by Vitali Tatarintev
* **ruby:** remove ast-grep ([4c24a04](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/4c24a0420fb57b347e9adfc6d56acd3b2213dc47)) by michaelangeloio
* **ruby:** switch to node_range in fqn ([8dfd341](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/8dfd341a2fd0d6be68c47c321ffc882d80c12ed5)) by Michael Angelo Rivera
* **rust:** remove ast-grep ([aa4819d](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/aa4819d861b2f37259d842ed4e704ec8313b02f6)) by michaelangeloio

### :repeat: Chore

* add issue template ([3f826ce](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/3f826ce3da602466d2ffedd2d3c3e88fb3414bd6)) by michaelangeloio
* add newlines mise task ([f1ef561](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/f1ef56125ce14568948996b15fb241fd71f1f242)) by michaelangeloio
* **chunker:** add paths to embedded library binaries for CGO FFI ([0972ad2](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/0972ad2789c56a7699540738b12bcb648cde7b64)) by James Fargher
* **ci:** cleanup ci, move heavy builds to release ([70a9ce3](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/70a9ce30d879c27ddb2c5d0320b6dd8df8ef0083)) by Bohdan Parkhomchuk
* **ci:** move ci file sections according to the order ([9279f5e](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/9279f5e3339303c711c5594f7ada930e7ec18aaa)) by Bohdan Parkhomchuk
* **ci:** remove clutter and repetitions in ci ([3ee92a5](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/3ee92a51abf48020e579b8b61fb1e00aa6e2a5c0)) by Bohdan Parkhomchuk
* **ci:** xtasks add or edit comment ([5a2be99](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/5a2be99348715bfa92e4e8a7192c8dfe3ba12319)) by michaelangeloio
* **deps:** update rust crate serde_json to v1.0.142 ([6871034](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/6871034df8ea4d069d88d6abe1696b643d97d1d9)) by GitLab Renovate Bot
* **deps:** update rust crate tokio to v1.47.1 ([cac64cd](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/cac64cde6ec0e00d69aa0104eacc724e088d42c1)) by GitLab Renovate Bot
* **deps:** update rust crate toml to v0.9.5 ([d929c6d](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/d929c6db49442a42b73330a48bbbfc6d8bb34803)) by GitLab Renovate Bot
* remove redundant cargo fmt from pre-commit hook ([76b15dc](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/76b15dc1ae64e63b4f847240c3399272e2efd54f)) by Jean-Gabriel Doyon

## [0.9.0](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.8.3...v0.9.0) (2025-07-31)

### :sparkles: Features

* add Git LFS support for static library binaries ([90bbb6d](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/90bbb6dfbf1ff484b205d3bec7df5cac086c5caf)) by Vitali Tatarintev
* **chunker:** return language str instead of enum number literal from rust FFI ([653ce89](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/653ce89572d894a8261bf43546785d9a56b7aeeb)) by Tian Gao

### :bug: Fixes

* **ci:** remove target/ from cross-build artifacts to prevent 413 error ([f4264fa](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/f4264fa545f67ce4a7e76afac355d89c50394a03)) by Vitali Tatarintev

### :zap: Refactor

* **core:** replace match_info with range ([a1856a7](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/a1856a7fe0ed675013f3ec1755c23ef25746725d)) by michaelangeloio
* move cbindgen to workspace dependencies ([644b3f2](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/644b3f21e5c52257d5c232e90db2b75ff4e8ba96)) by Vitali Tatarintev

### :fast_forward: Performance

* **ts:** use smallvec for ts fqn resolution + unified types ([cf4c79e](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/cf4c79edef55b0c93e1181a60ac3577533a143b4)) by Michael Usachenko

### :repeat: Chore

* add fix all mise command ([e854144](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/e854144d0c03b130de180671f8013491fc212f8c)) by michaelangeloio
* **ci:** add release optimization for size and perf ([9983258](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/998325821cf9ede274e7131fb651049c5fe54182)) by Bohdan Parkhomchuk
* **deps:** add gitlab-xtasks verify-newlines ([c2ffc7d](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/c2ffc7d9290b92214e4891946ac344b13eedb833)) by Michael Angelo Rivera
* **deps:** update rust crate ast-grep-language to v0.39.2 ([06ec41b](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/06ec41b584221b7a26fb64db47776ec496003f00)) by GitLab Renovate Bot
* **deps:** update rust crate tokio to v1.47.0 ([90cabf8](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/90cabf8b08115f41615f431a1e352778854e526f)) by GitLab Renovate Bot
* **deps:** upgrade ast-grep ([6ff3555](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/6ff3555028de9c50466e766dc05fd4f613fb6db7)) by michaelangeloio
* **docs:** add common mise commands ([200957d](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/200957d392f6099e1adaaf6ed3d7bd1d2e19ffaa)) by michaelangeloio
* **references:** made partial resolution of reference targets language-specific ([056c9a3](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/056c9a31326df8d406abeb3d34a261aec836b066)) by Jonathan Shobrook

## [0.8.3](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.8.2...v0.8.3) (2025-07-29)

### :bug: Fixes

* **ts:** correct byte range was not being captured for aliased imports ([55a892d](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/55a892d6976f779d5b277f1820ae01b42c6c47f7)) by Michael Usachenko

### :repeat: Chore

* **deps:** update rust crate ast-grep-config to v0.39.2 ([494bea1](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/494bea159e0cd3b7b4e9b9815f6fa0330e221516)) by GitLab Renovate Bot
* **deps:** update rust crate toml to v0.9.3 ([df52b61](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/df52b6168b6bba076ed1d21cf6216934f87a6870)) by GitLab Renovate Bot
* **references:** refactored references data structure to accommodate ambiguous references ([8511fe3](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/8511fe34af5f126519998ade55acd41a6282b8ea)) by Jonathan Shobrook

## [0.8.2](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.8.1...v0.8.2) (2025-07-27)

### :bug: Fixes

* **py:** fixed scope detection for Python imports ([e3112b3](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/e3112b3073bf3253b8e42aed33620b81df67d16e)) by Jonathan Shobrook

## [0.8.1](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.8.0...v0.8.1) (2025-07-27)

### :bug: Fixes

* **py:** fixed imported symbol range ([da0cd32](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/da0cd32c8e7081694a05bcb87b0e2b9e6750927e)) by Jonathan Shobrook
* **ts:** fix typescript import range captures ([52f55a1](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/52f55a1ecb1d4b519d71367544726d3d1a573f7f)) by Michael Usachenko

## [0.8.0](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.7.0...v0.8.0) (2025-07-26)

### :sparkles: Features

* **chunker:** expose error message for easier debugging ([cc1cf8a](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/cc1cf8a2b5b082dff62db6bc7a22c489bf254752)) by Pam Artiaga
* **csharp:** do not consider namespace a definition, consider file namespace a scope ([23f0c99](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/23f0c99f4c1121e26f5545a9c7d76f4b5a7eac3b)) by Bohdan Parkhomchuk
* **go-bindings:** add Length to Chunk struct ([b6c46c2](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/b6c46c291ee60cab9b08649803403dd3c2540918)) by Vitali Tatarintev
* **parser:** add ReferenceType to ReferenceInfo ([9914e38](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/9914e38710d3a8f96305fbfd010e9da3a2a6b389)) by Jean-Gabriel Doyon
* **parser:** added generic references data structure ([fd32d80](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/fd32d80c2ea0b10066f2380582e4e75311acd084)) by Jonathan Shobrook
* **ts:** import parsing for typescript and javascript ([6898645](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/689864540eb087081826fb2b8dc19c7da681eee0)) by Michael Usachenko

### :bug: Fixes

* **kotlin:** ignore Kotlin lambdas that can't be called ([bcb03ef](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/bcb03ef719752cdfb8b999cdb660ee2b56506940)) by Jean-Gabriel Doyon

### :repeat: Chore

* **deps:** bump dependencies + bump xtasks ([84b2e5a](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/84b2e5ab8b69093cf6ab5e43259ac6a9d85326ec)) by Michael Usachenko
* **ts:** move typescript to iterative fqn resolution for better performance ([d77577d](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/d77577d6aba8bb5411baa4cffed48305d9d108e9)) by Michael Usachenko

## [0.7.0](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.6.0...v0.7.0) (2025-07-21)

### :sparkles: Features

* **chunker:** add go bindings ([fc0b193](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/fc0b193f8dbee9736aed2cb809091944b8003617)) by James Fargher
* **chunker:** add multi-file chunking ([6c9ccd3](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/6c9ccd38898fb2abd41f8112b9e3cdf1cd3b1aea)) by James Fargher
* **ci:** add cross-compilation and precompiled binaries for Go bindings ([4d89ea9](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/4d89ea983c528fedebb9f433821125796a4ba0ad)) by Vitali Tatarintev
* **java:** support Java imports ([766e0e2](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/766e0e2d056a01db38a1756a3faf84e157a53d62)) by Jean-Gabriel Doyon
* **java:** use Java full import as path and identifier ([82162f4](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/82162f445f30d2d4eb39d5fd24f569c7fdff144a)) by Jean-Gabriel Doyon
* **kotlin:** explicit Kotlin class types and remove function and property extensions ([cfe7a5d](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/cfe7a5dad49ece5c5a24a75c61cc136d408a4538)) by Jean-Gabriel Doyon
* **kotlin:** parse Kotlin imports ([a91b1d2](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/a91b1d285cea061ecd58f4cfee526c8fe754ec01)) by Jean-Gabriel Doyon

### :repeat: Chore

* **py:** performance improvements, created types.rs file ([6f31e51](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/6f31e51d15ecd6789adb1b61438b62cfb76cc435)) by Jonathan Shobrook

## [0.6.0](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.5.0...v0.6.0) (2025-07-08)

### :sparkles: Features

* **ts:** add named call expression to definitions ([0fc0b95](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/0fc0b95d29c450986e223753a5e77581b157e550)) by John Smith

### :repeat: Chore

* **deps:** update rust crate reqwest to v0.12.21 ([5762e1a](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/5762e1adcb1adb0daa7e7e3f8d3b7a0942daacb2)) by GitLab Renovate Bot

## [0.5.0](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.4.0...v0.5.0) (2025-06-30)

### :sparkles: Features

* **csharp:** additional definitions support ([d4fe85d](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/d4fe85d44f5c3abcdda39b5c5c6cabb3d33797ed)) by Bohdan Parkhomchuk
* **releases:** include chore and other types in changelog ([150ecb1](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/150ecb1fff71f98b9175aaa59ebcbe56b8d0621d)) by John Smith

### :bug: Fixes

* **ci:** disable toolchain auto update during release ([c87eb3c](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/c87eb3c0647abea155096bbc429d2c69581bede3)) by John Smith

### :repeat: Chore

* cargo edition bump to 2024, and related linting, clippy fixes ([a4867a8](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/a4867a8a8ed0955d7624096ab5d9ca520b51f97b)) by Michael Usachenko
* **deps:** fix lint for rust 1.88 ([b903eb5](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/b903eb51f19b801f2dbaf745c2301d6dd699f14e)) by Bohdan Parkhomchuk

# [0.4.0](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.3.0...v0.4.0) (2025-06-26)


### Features

* **ci:** run builds on large runner ([0ffe4bc](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/0ffe4bcb3a6e4c64d6f886d6acc9afd98ba5efe0)) by Bohdan Parkhomchuk
* **java:** support Java callable lambdas ([3b4ffbd](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/3b4ffbdbbfc30490057a6d981400f576c497c539)) by Jean-Gabriel Doyon
* **kotlin:** add Kotlin lambdas support ([7e6e578](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/7e6e57866428a98d40a7eb9e0bf77de234508909)) by Jean-Gabriel Doyon
* **parser:** expose supported extensions method ([c939d66](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/c939d66409e3a7c0eda953e518dc0de962e5809f)) by Jean-Gabriel Doyon
* **py:** added parsing for Python imports ([305cf7c](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/305cf7cfbef4e9d09b2efb754d8b04eada1c8e71)) by Jonathan Shobrook

# [0.3.0](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.2.0...v0.3.0) (2025-06-23)


### Bug Fixes

* **changelog:** use shortHash in commit links and add newline ([68b9ac7](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/68b9ac7f373cfc4a2c8e375743365fc8d7c7a2d8)) by michaelangeloio
* **csharp:** benches, tests and fixes ([c4373b2](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/c4373b265863740b922612c6c1cf272037487f00)) by Bohdan Parkhomchuk
* **releases:** release prepare script ([0ff4d60](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/0ff4d60261f6a5f1d1b6caa0b600b74c7b6e1be1)) by Michael Angelo Rivera


### Features

* **chunker:** add language to chunks ([2051a7c](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/2051a7c442fe81ce03caca5f53050aa6e85d7226)) by James Fargher
* **java:** parse Java callable definitions ([80429aa](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/80429aa272ad838e1de3cd7edfcbf9be0027c7c7)) by Jean-Gabriel Doyon
* **kotlin:** differentiate annotation, enum and interface in Kotlin ([1287995](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/1287995a793efa3186ecbb911d6e1191f236c197)) by Jean-Gabriel Doyon
* **parser:** setup initial import generics ([f388495](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/f3884950406d7db55e175a4a7371ed84ea14c09c)) by Jonathan Shobrook
* **release:** add slackbot integration ([670bad0](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/670bad0020cb2c9eb7be02d419253d61462253cd)) by Michael Angelo Rivera

# [0.3.0](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.2.0...v0.3.0) (2025-06-20)


### Features

* **kotlin:** differentiate annotation, enum and interface in Kotlin ([1287995a793efa3186ecbb911d6e1191f236c197](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/1287995a793efa3186ecbb911d6e1191f236c197)) by Jean-Gabriel Doyon* **release:** add slackbot integration ([670bad0020cb2c9eb7be02d419253d61462253cd](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/670bad0020cb2c9eb7be02d419253d61462253cd)) by Michael Angelo Rivera

# [0.2.0](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.1.0...v0.2.0) (2025-06-20)


### Bug Fixes

* **ci:** add artifact fetcher to combine benchmark results ([4fe6c2a](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/4fe6c2a2716dc2a8f3d328844c014a8367ec25b3))
* **ruby:** expand FQN ranges to cover full definitions ([754870a](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/754870a9712e6a4c4e7120783144c08fd8d9c6bc))


### Features

* **chunker:** initial code parsing chunker ([b2c087c](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/b2c087cd1f97e3a9cdac706e482a14d96933a5fa))
* **csharp:** add C# definitions ([7ce83c7](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/7ce83c7c3a03e65264b22f96286c7de76abc1616))
* **js:** implement JS definitions ([4704f70](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/4704f700d7b493364fcc255028d6c418fe2ff4ee))
* **kotlin:** add Kotlin definitions ([f2afb0a](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/f2afb0aae1273404677e9136262b6b301e33df0b))
* **parser:** setup initial library ([dc112e1](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/dc112e19a6442a04e52cbf55b308d1cabfb5316e))
* **py:** added parsing for Python definitions ([fbdffcf](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/fbdffcfe1f5c8eff09ab1f906688a13712894641))
* **ruby:** implement ruby definitions ([99d241b](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/99d241b530f21a12c21056bd5b8cb7d165a431fc))
* **ts:** support for TS specific definitions + TS tests ([68e1781](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/68e1781c606c64180a394090cff500480a34282c))
* **ts:** use ast-grep TS parser for both JS and TS ([b18e6e0](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/b18e6e0d2ef92898cab9b1c6e1231a65a177f4dc))
* **xtask:** add flag to skip setting a stable toolchain ([a4f8213](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/a4f821364f6669263c1c5569bbab909eb14684aa))

# [0.2.0](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/compare/v0.1.0...v0.2.0) (2025-06-19)


### Bug Fixes

* **ci:** add artifact fetcher to combine benchmark results ([4fe6c2a](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/4fe6c2a2716dc2a8f3d328844c014a8367ec25b3))
* **ruby:** expand FQN ranges to cover full definitions ([754870a](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/754870a9712e6a4c4e7120783144c08fd8d9c6bc))


### Features

* **chunker:** initial code parsing chunker ([b2c087c](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/b2c087cd1f97e3a9cdac706e482a14d96933a5fa))
* **js:** implement JS definitions ([4704f70](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/4704f700d7b493364fcc255028d6c418fe2ff4ee))
* **kotlin:** add Kotlin definitions ([f2afb0a](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/f2afb0aae1273404677e9136262b6b301e33df0b))
* **parser:** setup initial library ([dc112e1](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/dc112e19a6442a04e52cbf55b308d1cabfb5316e))
* **py:** added parsing for Python definitions ([fbdffcf](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/fbdffcfe1f5c8eff09ab1f906688a13712894641))
* **ruby:** implement ruby definitions ([99d241b](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/99d241b530f21a12c21056bd5b8cb7d165a431fc))
* **ts:** support for TS specific definitions + TS tests ([68e1781](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/68e1781c606c64180a394090cff500480a34282c))
* **ts:** use ast-grep TS parser for both JS and TS ([b18e6e0](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/b18e6e0d2ef92898cab9b1c6e1231a65a177f4dc))
* **xtask:** add flag to skip setting a stable toolchain ([a4f8213](https://gitlab.com/gitlab-org/rust/gitlab-code-parser/commit/a4f821364f6669263c1c5569bbab909eb14684aa))
