package com.debug.test;

import java.util.function.Consumer;
import java.util.function.Supplier;

public class Observation {
    private Consumer<Object> action;
    private Object subject;

    public Observation(Object subject, Consumer<Object> action) {
        this.subject = subject;
        this.action = action;
    }

    public Observation() {
    }

    public void observe() {
        action.accept(subject);
    }

    public static <T extends Subject> Observation start(Supplier<T> who, Consumer<T> action) {
        T subject = who.get();
        if(subject != null) {
            return new Observation((Object) subject, (Consumer) action);
        }
        return new Observation();
    }
}