/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.launching.internal.weaving;

import org.eclipse.jdt.launching.internal.org.objectweb.asm.ClassReader;
import org.eclipse.jdt.launching.internal.org.objectweb.asm.ClassVisitor;
import org.eclipse.jdt.launching.internal.org.objectweb.asm.ClassWriter;

public class ClassfileTransformer {
    private static final String STRATA_ID = "jdt";
    public static final int MAX_CLASS_MAJOR = 70;
    private static final int ASM_API = 589824;

    public byte[] transform(byte[] classfileBuffer, final String location) {
        ClassReader r = new ClassReader(classfileBuffer, 0, classfileBuffer.length);
        ClassWriter w = new ClassWriter(r, 0);
        r.accept(new ClassVisitor(589824, w){

            @Override
            public void visitSource(String source, String debug) {
                String javaSource = source;
                if (debug == null) {
                    StringBuilder smap = new StringBuilder();
                    smap.append("SMAP\n");
                    smap.append(javaSource).append("\n");
                    smap.append("Java\n");
                    smap.append("*S jdt\n");
                    smap.append("*F\n");
                    smap.append("1 ").append(source).append("\n");
                    smap.append("2 ").append(location).append("\n");
                    smap.append("*L\n");
                    smap.append("*E\n");
                    debug = smap.toString();
                }
                super.visitSource(javaSource, debug);
            }
        }, 0);
        return w.toByteArray();
    }
}

