# JDT Debug

JDT Debug implements Java debugging support and works with any JDPA-compliant target Java VM.
It is implemented on top of the language independent "debug model" provided by the platform debugger. 
JDT debug provides the following debugging features:

- Launching of a Java VM in either run or debug mode
- Attaching to a running Java VM
- Expression evaluation in the context of a stack frame
- Scrapbook pages for interactive Java code snippet evaluation
- Dynamic class reloading where supported by Java virtual machine

For more information about JDT Debug refer to the [JDT Debug website](https://eclipse.dev/eclipse/debug/index.php).
For general information about JDT and important links, refer to the [JDT wiki page](https://github.com/eclipse-jdt/eclipse.jdt.core/wiki) or the [JDT project overview page](https://projects.eclipse.org/projects/eclipse.jdt).

## Contributing

[Contributions are always welcome!](https://github.com/eclipse-jdt/.github/blob/main/CONTRIBUTING.md)

Please bear in mind that this project is almost entirely developed by volunteers.
If you do not provide the implementation yourself (or pay someone to do it for you), the bug might never get fixed.
If it is a serious bug, other people than you might care enough to provide a fix.

[![Create Eclipse Development Environment for JDT Debug](https://download.eclipse.org/oomph/www/setups/svg/JDT_Debug.svg)](
https://www.eclipse.org/setups/installer/?url=https://raw.githubusercontent.com/eclipse-jdt/eclipse.jdt.debug/master/org.eclipse.jdt.debug.setup/JdtDebugConfiguration.setup&show=true
"Click to open Eclipse-Installer Auto Launch or drag into your running installer")

## License

[Eclipse Public License (EPL) v2.0](https://www.eclipse.org/legal/epl-2.0/)

## Links

- https://github.com/eclipse-jdt/eclipse.jdt.core/wiki
- https://github.com/eclipse-jdt/.github/blob/main/CONTRIBUTING.md
- https://projects.eclipse.org/projects/eclipse.jdt
