/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.snippeteditor;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.CodeSource;
import java.security.ProtectionDomain;

public class ScrapbookMain {
    public static void main(String[] args) {
        URL[] urls = ScrapbookMain.getClasspath(args);
        if (urls == null) {
            return;
        }
        try {
            while (true) {
                ScrapbookMain.evalLoop(urls);
            }
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException exception) {
            return;
        }
    }

    static void evalLoop(URL[] urls) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (URLClassLoader cl = new URLClassLoader(urls, null);){
            Class<?> clazz = cl.loadClass("org.eclipse.jdt.internal.debug.ui.snippeteditor.ScrapbookMain1");
            Method method = clazz.getDeclaredMethod("eval", Class.class);
            method.invoke(null, ScrapbookMain.class);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void nop() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {}
    }

    static URL[] getClasspath(String[] urlStrings) {
        URL[] urls = new URL[urlStrings.length + 1];
        int i = 0;
        while (i < urlStrings.length) {
            try {
                urls[i + 1] = new URL(URLDecoder.decode(urlStrings[i], StandardCharsets.UTF_8.name()));
            }
            catch (UnsupportedEncodingException | MalformedURLException iOException) {
                return null;
            }
            ++i;
        }
        ProtectionDomain pd = ScrapbookMain.class.getProtectionDomain();
        if (pd == null) {
            return null;
        }
        CodeSource cs = pd.getCodeSource();
        if (cs == null) {
            return null;
        }
        urls[0] = cs.getLocation();
        return urls;
    }
}

