/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.launching.internal.javaagent;

import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import org.eclipse.jdt.launching.internal.weaving.ClassfileTransformer;

public class Premain {
    private static final ClassfileTransformer transformer = new ClassfileTransformer();

    public static void premain(String agentArgs, Instrumentation inst) {
        final boolean debuglog = "debuglog".equals(agentArgs);
        short major = Premain.readJavaLangObjectMajor(debuglog);
        if (major < 0 || major > 69) {
            String vendor = System.getProperty("java.vendor");
            String version = System.getProperty("java.version");
            System.err.printf("JRE %s/%s is not supported, advanced source lookup disabled.\n Eclipse debugger will use less precise source lookup implementation for this debug session, but everything else will continue to work otherwise.\nUpgrading Eclipse to the latest version will likely make this warning go away.", vendor, version);
            return;
        }
        inst.addTransformer(new ClassFileTransformer(){

            @Override
            public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
                try {
                    if (protectionDomain == null) {
                        return null;
                    }
                    if (className == null) {
                        return null;
                    }
                    CodeSource codeSource = protectionDomain.getCodeSource();
                    if (codeSource == null) {
                        return null;
                    }
                    URL locationUrl = codeSource.getLocation();
                    if (locationUrl == null) {
                        return null;
                    }
                    String location = locationUrl.toExternalForm();
                    return transformer.transform(classfileBuffer, location);
                }
                catch (Exception e) {
                    System.err.printf("Could not instrument class %s: %s.\n", className, e.getMessage());
                    if (debuglog) {
                        e.printStackTrace(System.err);
                    }
                    return null;
                }
            }
        });
        Premain.printErrorMessage("Advanced source lookup enabled.", null, debuglog);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static short readJavaLangObjectMajor(boolean debuglog) {
        int offset = 6;
        try (InputStream is = ClassLoader.getSystemResourceAsStream("java/lang/Object.class");){
            if (is == null) {
                Premain.printErrorMessage("Could not open java/lang/Object.class system resource stream.", null, debuglog);
                short s = -1;
                return s;
            }
            byte[] bytes = new byte[8];
            if (is.read(bytes) < bytes.length) {
                Premain.printErrorMessage("Could not read java/lang/Object.class system resource stream.", null, debuglog);
                short s = -1;
                return s;
            }
            int magic = (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
            if (magic != -889275714) {
                Premain.printErrorMessage("Invalid java/lang/Object.class magic.", null, debuglog);
                short s = -1;
                return s;
            }
            short s = (short)((bytes[6] & 0xFF) << 8 | bytes[7] & 0xFF);
            return s;
        }
        catch (Exception ex) {
            Premain.printErrorMessage("Could not open java/lang/Object.class system resource stream.", ex, debuglog);
            return -1;
        }
    }

    private static void printErrorMessage(String errorMessage, Exception ex, boolean debuglog) {
        if (debuglog) {
            System.err.println(errorMessage);
            if (ex != null) {
                ex.printStackTrace(System.err);
            }
        }
    }
}

