/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.simpleconfigurator.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.eclipse.equinox.configurator.Configurator;
import org.eclipse.equinox.internal.simpleconfigurator.utils.EquinoxUtils;
import org.eclipse.equinox.internal.simpleconfigurator.utils.SimpleConfiguratorUtils;
import org.eclipse.equinox.internal.simpleconfigurator.utils.Utils;
import org.eclipse.equinox.simpleconfigurator.internal.ConfigApplier;
import org.osgi.framework.BundleContext;

public class SimpleConfiguratorImpl
implements Configurator {
    BundleContext context;
    ConfigApplier configApplier;
    private URL url = null;

    SimpleConfiguratorImpl(BundleContext context) {
        this.context = context;
    }

    private URL getConfigurationURL() {
        try {
            String specifiedURL = this.context.getProperty("org.eclipse.equinox.simpleconfigurator.configUrl");
            if (specifiedURL != null) {
                return new URL(specifiedURL);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        try {
            URL configURL;
            if (this.context.getBundle().loadClass("org.eclipse.osgi.service.datalocation.Location") != null && (configURL = EquinoxUtils.getDefaultConfigURL(this.context)) != null) {
                return configURL;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return null;
    }

    public synchronized void applyConfiguration(URL url) throws IOException {
        if (url == null) {
            return;
        }
        this.url = url;
        List bundleInfoList = SimpleConfiguratorUtils.readConfiguration(url);
        if (bundleInfoList.size() == 0) {
            return;
        }
        if (this.configApplier == null) {
            this.configApplier = new ConfigApplier(this.context, this);
        }
        this.configApplier.install(Utils.getBundleInfosFromList(bundleInfoList), this.isExclusiveInstallation());
    }

    private boolean isExclusiveInstallation() {
        String value = this.context.getProperty("org.eclipse.equinox.simpleconfigurator.exclusiveInstallation");
        if (value == null || value.trim().length() == 0) {
            value = "true";
        }
        return Boolean.valueOf(value);
    }

    public synchronized void applyConfiguration() throws IOException {
        if (this.url == null) {
            this.url = this.getConfigurationURL();
        }
        this.applyConfiguration(this.url);
    }

    public synchronized URL getUrlInUse() {
        return this.url;
    }
}

