How to add things to the Eclipse doc
====================================


Adding new plug-ins and dependencies
------------------------------------

To add new plug-ins and plug-in dependencies, you need to make changes in several places in the org.eclipse.platform.doc.isv plug-in (which is located in the eclipse.platform.common Git repository):

1.  platformOptions.txt
    *   the plug-in's source folder(s) must be included on the -sourcepath
        *   remember to remove the plug-in from -classpath if it was already there
    *   code of required plug-ins must be added on the -classpath (unless they are already on the -sourcepath)
        *   non-JARed plug-ins: Path(s) to the JAR(s)
        *   JARed plug-ins: <plugin>/@dot
        *   plug-ins not built during the platform build: path to the built JAR  
            **Caveat:** the JAR name typically contains a version:
            *   Either remember to update the version in the reference whenever a new version is used
            *   Or (since 3.8 incl. maintenance branches) replace the `_<major>.<minor>.<service>.<qualifier>` with `_*` if only one version of the JAR is present during the build.
    *   the API package names must be included in the (alphabetical) package list at the end of the file
    *   variables like `${eclipse.platform.resources.bundles}` are resolved from `cbi_basedirs.properties` (and `pde_basedirs.properties` for the old PDE-based build)
2.  buildDoc.xml
    *   If a plug-in contributes extension points, it should be added to the list of plug-ins in the <convertSchemaToHTML> task in the buildDoc.xml of the corresponding documentation plug-in.
3.  plugin.xml
    *   If your plugin has Javadoc API, add a line to plugin.xml under the org.eclipse.pde.core.javadoc extension to associate your plug-in's Javadoc with the reference section for this doc plug-in.

Adding new API packages
-----------------------

1.  package.html
    *   Create a package.html or package-info.java file for your API package, and place it in the package alongside the source code
2.  topics_Reference.xml
    *   add a line for each API package
3.  reference/misc/overview-platform.html
    *   add the API packages to the corresponding section
4.  platformOptions.txt
    *   the API package names must be included in the (alphabetical) package list at the end of the file

Adding new extension points
---------------------------

1.  reference/extension-points/index.html
    *   add a line for each extension point
2.  topics_Reference.xml
    *   add a line for each extension point

JDT and PDE docs
----------------

For org.eclipse.jdt.doc.isv, the process is the same with these file location differences:

*   platformOptions.txt -> jdtOptions.txt
*   overview-platform.html -> /reference/misc/overview-jdt.html

For org.eclipse.pde.doc.user, the process is the same with these file location differences:

*   platformOptions.txt -> pdeOptions.txt
*   overview-platform.html -> /reference/misc/overview-pde.html

Missing API docs
----------------

org.eclipse.ua.tests.doc has an ApiDocTest that can help you detect missing API docs. The output generated by the test can be found in the Console Output Log, e.g.: [http://download.eclipse.org/eclipse/downloads/drops4/R-4.6.2-201611241400/testresults/ep46M-unit-mac64\_macosx.cocoa.x86\_64_8.0/org.eclipse.ua.tests.doc.AllTests.txt](http://download.eclipse.org/eclipse/downloads/drops4/R-4.6.2-201611241400/testresults/ep46M-unit-mac64_macosx.cocoa.x86_64_8.0/org.eclipse.ua.tests.doc.AllTests.txt)


