FAQ Where can I find more information on SWT?
=============================================


Books
-----

Before 2004, comprehensive information on SWT was not available outside the SWT source code and Javadoc itself.
This situation changed in 2004 with the publication of _SWT: The Standard Widget Toolkit_ in the Addison-Wesley Eclipse Series.
This book was written by Steve Northover and Mike Wilson, two of the original architects and developers of SWT.
When the acronym first appeared, it was jokingly referred to as Steve's Widget Toolkit.

Nobody knows SWT better than these authors, and their book is the most authoritative guide to the subject.
If you're doing extensive development using SWT, it's indispensable. Volume 2 of their book is forthcoming.

Several other Eclipse books include a chapter or more on SWT:

*   Eric Clayberg and Dan Rubel, _Eclipse: Building Commercial-Quality Plug-ins_ (Addison-Wesley, 2004), Chapter 4.
*   Erich Gamma and Kent Beck, _Contributing to Eclipse_ (Addison-Wesley, 2004), Chapter 34.
*   Sherry Shavor, et al., _The Java Developer's Guide to Eclipse_ (Addison-Wesley, 2004), Chapter 14.
*   Rob Warner and Robert Harris, _The Definitive Guide to SWT and JFace_, (Apress, 2004), major part of book.

Websites
---------

The information hub for SWT is the [SWT development team home page](https://eclipse.org/swt).
The main page has a basic SWT overview, and the Development Resources page has loads more information, including a comprehensive library of stand-alone SWT programs--called snippets--illustrating many of the important concepts in SWT.
This page also hosts the official SWT FAQ maintained by the SWT development team, as well as development plans, platform porting status, and much more.

The home page for SWT and JFace has links to other resource pages, but some information is here, along with a collection of FAQs.

Articles
--------

The first place to look for articles is the articles page on eclipse.org.
We won't bother listing all the articles here as the list would probably be stale by the time this book goes to print.
Of particular note is the two-part article entitled 'SWT: The Standard Widget Toolkit.'
These articles were written by the SWT development team to describe some of the design rationale behind the project.
The CD included with this book has PDF versions of all the articles, captured in May, 2004.

Discussion forums
-----------------

The main forum for discussion of SWT is the `eclipse.platform.swt` newsgroup.
This is the place to go for all kinds of SWT questions for users of all levels, from novices taking their first steps with SWT to highly experienced SWT developers.
The SWT development team regularly reads this newsgroup, so you can be sure of authoritative answers.
Be sure to do a [quick search](https://www.eclipse.org/search/search.cgi), before posting, to avoid asking a question that's been asked before.

The `platform-swt-dev` mailing list is for discussion among members of the SWT development team and other contributors to SWT.
If you are fixing SWT bugs, porting SWT to another platform, or looking for solutions to advanced questions that have not been answered on the newsgroup, you are welcome to ask here.
SWT users are welcome to subscribe and follow along with the discussion, but to avoid cluttering the developer list, please use the newsgroup for your questions.

Some other Java forums have been known to host discussion threads on SWT. Unfortunately, these forums can sometimes deteriorate into flame wars on Swing versus SWT.

See Also
--------

*   [FAQ What Eclipse newsgroups are available?](./FAQ_What_Eclipse_newsgroups_are_available.md "FAQ What Eclipse newsgroups are available?")
*   [FAQ What Eclipse mailing lists are available?](./FAQ_What_Eclipse_mailing_lists_are_available.md "FAQ What Eclipse mailing lists are available?")
*   [FAQ What articles on Eclipse have been written?](./FAQ_What_articles_on_Eclipse_have_been_written.md "FAQ What articles on Eclipse have been written?")
*   [FAQ What books have been written on Eclipse?](./FAQ_What_books_have_been_written_on_Eclipse.md "FAQ What books have been written on Eclipse?")
