FAQ How do I create an Outline view for my own language editor?
===============================================================

The Outline view is not generated by the editor framework. In fact, this view is offered by the org.eclipse.ui.views plug-in. When the user changes editors, your editor will be asked to provide an IContentOutlinePage adapter for an Outline view. This is how you should implement your outline viewer:

In plugin.xml, define an adapter for your editor to content outline page:

      <extension point="org.eclipse.core.runtime.adapters">
         <factory
         adaptableType="org.acme.editor.CoolLanguageEditor"
         class="org.acme.editor.CoolLanguageEditorToOutlineAdapterFactory">
         <adapter type="org.eclipse.ui.views.contentoutline.IContentOutlinePage"/>
         </factory>
      </extension>

  
and the Java code

      public class CoolLanguageEditorToOutlineAdapterFactory implements IAdapterFactory {
         @Override
         public Object getAdapter(Object adaptableObject, Class<?> required) {
            if (IContentOutlinePage.class.equals(required)) {
                  CoolLanguageEditor editor = (CoolLanguageEditor)adaptableObject;
                  return new CoolLanguageContentOutlinePage(...);
               }
            }
         }
       
         @Override
         public Class<?>[] getAdapterList() {
            return new Class<?>[] { IContentOutlinePage.class };
         }
      }

  
Most programming languages are inherently hierarchical. Therefore, to show the content outline of a certain program file, most editors deploy a tree. If you think that a tree is the most appropriate way to show the outline of your programs, you should consider subclassing from class ContentOutlinePage in the org.eclipse.ui.views.contentoutline package. This class already sets you up with a TreeViewer, and all you need to provide are a content provider, a label provider, and the input:

 

       public void createControl(Composite parent) {
          super.createControl(parent);
          TreeViewer viewer= getTreeViewer();
          viewer.setContentProvider(new MyContentProvider());
          viewer.setLabelProvider(new MyLabelProvider());
          viewer.addSelectionChangedListener(this);
          viewer.setInput(myInput);
       }

You will want to update the selection in your Outline view when the cursor is moved in the editor. Similarly, if the structure of the program changed-code added or removed-the outline has to be updated. This is typically performed with a JFace text model reconciler.

When the user selects a node in the Outline view, the editor should change selection to the selected element and make it visible.

  
When [Bug 507205](https://bugs.eclipse.org/bugs/show_bug.cgi?id=507205) is fixed, a recommended way would be to rely on the Common Navigator Framework in order to implement Tree-based navigation outline pages. For the moment, you can already write your own outline view consuming the CommonViewer class.

 

       public void createControl(Composite parent) {
          CommonViewer viewer = new CommonViewer(ID, parent, SWT.V_SCROLL | SWT.H_SCROLL);
          viewer.setInput(myInput);
       }

With ID being the name of the common navigator defined in org.eclipse.ui.navigator.viewer extension. Then the outline should receive most features as expected by the common navigator framework. This approach allows a better refactoring as multiple viewers can very easily share some common parts.

See Also:
---------

[FAQ How do I use a model reconciler?](./FAQ_How_do_I_use_a_model_reconciler.md "FAQ How do I use a model reconciler?")

[FAQ Language integration phase 4: What are the finishing touches?](./FAQ_Language_integration_phase_4_What_are_the_finishing_touches.md "FAQ Language integration phase 4: What are the finishing touches?")

