/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.launching.debug;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MacroInstance;
import org.eclipse.ant.internal.launching.debug.IDebugBuildLogger;

public class AntDebugState {
    private static final String fgAntTaskName = "ant";
    private static final String fgAntCallTaskName = "antcall";
    private final IDebugBuildLogger fLogger;
    private final Stack<Task> fTasks = new Stack();
    private final Map<Task, Object> fTaskToProxies = new HashMap<Task, Object>();
    private Task fCurrentTask;
    private Task fStepOverTask;
    private Task fStepIntoTask;
    private Task fLastTaskFinished;
    private Map<String, Object> fInitialProperties = null;
    private Map<String, Object> fProperties = null;
    private Map<Project, Vector<?>> fProjectToTargetNames = null;
    private Map<Project, Map<Target, Vector<Target>>> fProjectToMapOfTargetToBuildSequence = null;
    private final Stack<Target> fTargetsToExecute = new Stack();
    private final Stack<Target> fTargetsExecuting = new Stack();
    private boolean fConsiderTargetBreakpoints = false;
    private boolean fShouldSuspend;
    private boolean fClientSuspend = false;
    private boolean fStepIntoSuspend = false;
    private boolean fIsAfterTaskEvent = false;

    public AntDebugState(IDebugBuildLogger logger) {
        this.fLogger = logger;
    }

    public void buildStarted() {
        this.fProjectToTargetNames = new HashMap();
        this.fProjectToMapOfTargetToBuildSequence = new HashMap<Project, Map<Target, Vector<Target>>>();
    }

    public void buildFinished() {
        if (this.fProjectToTargetNames != null) {
            this.fProjectToTargetNames.clear();
        }
        if (this.fProjectToMapOfTargetToBuildSequence != null) {
            this.fProjectToMapOfTargetToBuildSequence.clear();
        }
        this.fTargetsExecuting.clear();
        this.fTargetsToExecute.clear();
        if (this.fInitialProperties != null) {
            this.fInitialProperties.clear();
        }
        if (this.fProperties != null) {
            this.fProperties.clear();
        }
        if (this.fTaskToProxies != null) {
            this.fTaskToProxies.clear();
        }
        if (this.fTasks != null) {
            this.fTasks.clear();
        }
    }

    public void waitIfSuspended() {
        this.fLogger.waitIfSuspended();
    }

    public Task getLastTaskFinished() {
        return this.fLastTaskFinished;
    }

    private void setLastTaskFinished(Task lastTaskFinished) {
        this.fLastTaskFinished = lastTaskFinished;
    }

    public Task getCurrentTask() {
        return this.fCurrentTask;
    }

    public void setCurrentTask(Task currentTask) {
        this.fCurrentTask = currentTask;
    }

    private Map<String, Object> getInitialProperties() {
        return this.fInitialProperties;
    }

    public Task getStepOverTask() {
        return this.fStepOverTask;
    }

    public void setStepOverTask(Task stepOverTask) {
        this.fStepOverTask = stepOverTask;
    }

    private boolean considerTargetBreakpoints() {
        return this.fConsiderTargetBreakpoints;
    }

    private void setConsiderTargetBreakpoints(boolean considerTargetBreakpoints) {
        this.fConsiderTargetBreakpoints = considerTargetBreakpoints;
    }

    private Stack<Task> getTasks() {
        return this.fTasks;
    }

    public void setShouldSuspend(boolean shouldSuspend) {
        this.fShouldSuspend = shouldSuspend;
    }

    public boolean shouldSuspend() {
        return this.fShouldSuspend;
    }

    private Map<Target, Vector<Target>> getTargetToBuildSequence(Project project) {
        return this.fProjectToMapOfTargetToBuildSequence.get(project);
    }

    public void setTargetToExecute(Target target) {
        if (target == null) {
            if (!this.fTargetsToExecute.isEmpty()) {
                this.fTargetsToExecute.pop();
            }
        } else {
            this.fTargetsToExecute.push(target);
        }
    }

    public void setTargetExecuting(Target target) {
        if (target == null) {
            if (!this.fTargetsExecuting.isEmpty()) {
                this.fTargetsExecuting.pop();
            }
        } else {
            this.fTargetsExecuting.push(target);
        }
    }

    private Target getTargetToExecute() {
        if (this.fTargetsToExecute.isEmpty()) {
            return null;
        }
        return this.fTargetsToExecute.peek();
    }

    private Target getTargetExecuting() {
        if (this.fTargetsExecuting.isEmpty()) {
            return null;
        }
        return this.fTargetsExecuting.peek();
    }

    public boolean isStepIntoSuspend() {
        return this.isAfterTaskEvent() && this.fStepIntoSuspend;
    }

    public void setStepIntoSuspend(boolean stepIntoSuspend) {
        this.fStepIntoSuspend = stepIntoSuspend;
    }

    public boolean isClientSuspend() {
        return this.fClientSuspend;
    }

    public void setClientSuspend(boolean clientSuspend) {
        this.fClientSuspend = clientSuspend;
    }

    public Task getStepIntoTask() {
        return this.fStepIntoTask;
    }

    public void setStepIntoTask(Task stepIntoTask) {
        this.fStepIntoTask = stepIntoTask;
    }

    public void resume() {
        this.fLogger.notifyAll();
    }

    public Map<String, Object> getProperties() {
        return this.fProperties;
    }

    public Location getBreakpointLocation() {
        Target targetExecuting;
        if (this.isAfterTaskEvent() && this.getCurrentTask() != null) {
            return this.getCurrentTask().getLocation();
        }
        if (this.considerTargetBreakpoints() && (targetExecuting = this.getTargetExecuting()) != null) {
            return targetExecuting.getLocation();
        }
        return null;
    }

    private boolean isAfterTaskEvent() {
        return this.fIsAfterTaskEvent;
    }

    private void setAfterTaskEvent(boolean isAfterTaskEvent) {
        this.fIsAfterTaskEvent = isAfterTaskEvent;
    }

    public void taskStarted(BuildEvent event) {
        Task parentTask;
        Object proxy;
        this.setAfterTaskEvent(true);
        if (this.getInitialProperties() == null) {
            this.fInitialProperties = event.getProject().getProperties();
        }
        this.setCurrentTask(event.getTask());
        this.setConsiderTargetBreakpoints(false);
        Stack<Task> tasks = this.getTasks();
        if (!tasks.isEmpty() && (proxy = (parentTask = tasks.peek()).getRuntimeConfigurableWrapper().getProxy()) != null) {
            this.fTaskToProxies.put(parentTask, proxy);
        }
        tasks.push(this.getCurrentTask());
        this.waitIfSuspended();
    }

    public void taskFinished() {
        Stack<Task> tasks = this.getTasks();
        if (!tasks.empty()) {
            Task lastTask = tasks.pop();
            this.setLastTaskFinished(lastTask);
            this.setCurrentTask(null);
            String taskName = lastTask.getTaskName();
            if (this.getStepOverTask() != null) {
                if ((fgAntCallTaskName.equals(taskName) || fgAntTaskName.equals(taskName)) && !fgAntCallTaskName.equals(this.getStepOverTask().getTaskName()) && !fgAntTaskName.equals(this.getStepOverTask().getTaskName())) {
                    this.setShouldSuspend(true);
                } else if (this.fTaskToProxies.remove(lastTask) instanceof MacroInstance) {
                    this.setShouldSuspend(true);
                }
            }
        }
        this.waitIfSuspended();
    }

    public void stepOver() {
        this.setStepOverTask(this.getCurrentTask());
        if (this.getCurrentTask() == null) {
            this.setShouldSuspend(true);
        }
        this.resume();
    }

    public void targetStarted(BuildEvent event) {
        Object ref;
        this.setAfterTaskEvent(false);
        Project eventProject = event.getProject();
        if (this.getInitialProperties() == null) {
            this.fInitialProperties = eventProject.getProperties();
        }
        if (this.fProjectToTargetNames.get(eventProject) == null && (ref = eventProject.getReference("eclipse.ant.targetVector")) != null) {
            this.fProjectToTargetNames.put(eventProject, (Vector)ref);
            HashMap<Target, Vector<Target>> targetToBuildSequence = new HashMap<Target, Vector<Target>>();
            this.setTargetToExecute(this.initializeBuildSequenceInformation(event, targetToBuildSequence));
            this.fProjectToMapOfTargetToBuildSequence.put(eventProject, targetToBuildSequence);
        }
        this.setTargetExecuting(event.getTarget());
        if (event.getTarget().equals(this.getTargetToExecute())) {
            Vector<?> targets = this.fProjectToTargetNames.get(eventProject);
            if (!targets.isEmpty()) {
                this.setTargetToExecute((Target)eventProject.getTargets().get(targets.remove(0)));
            } else {
                this.setTargetToExecute(null);
            }
        }
        this.setConsiderTargetBreakpoints(true);
    }

    private void appendToStack(StringBuffer stackRepresentation, String targetName, String taskName, Location location) {
        stackRepresentation.append(targetName);
        stackRepresentation.append(",");
        stackRepresentation.append(taskName);
        stackRepresentation.append(",");
        stackRepresentation.append(location.getFileName());
        stackRepresentation.append(",");
        stackRepresentation.append(location.getLineNumber());
        stackRepresentation.append(",");
    }

    public void marshalStack(StringBuffer stackRepresentation) {
        Stack<Task> tasks = this.getTasks();
        stackRepresentation.append("stack");
        stackRepresentation.append(",");
        Target targetToExecute = this.getTargetToExecute();
        Target targetExecuting = this.getTargetExecuting();
        Project projectExecuting = null;
        if (targetExecuting != null) {
            projectExecuting = targetExecuting.getProject();
        } else if (!tasks.empty()) {
            Task task = tasks.peek();
            projectExecuting = task.getProject();
        }
        if (!this.isAfterTaskEvent()) {
            this.appendToStack(stackRepresentation, targetExecuting.getName(), "", targetExecuting.getLocation());
        }
        int i = tasks.size() - 1;
        while (i >= 0) {
            Task task = (Task)tasks.get(i);
            if (task.getProject() == projectExecuting) {
                this.appendToStack(stackRepresentation, task.getOwningTarget().getName(), task.getTaskName(), task.getLocation());
            } else {
                String targetName = task.getOwningTarget().getName();
                if (targetName != null && targetName.length() != 0) {
                    for (Target target : this.fTargetsToExecute) {
                        if (target.getProject() != projectExecuting) {
                            targetToExecute = target;
                            continue;
                        }
                        this.marshalTargetDependancyStack(stackRepresentation, target, targetExecuting);
                    }
                }
                projectExecuting = task.getProject();
                targetExecuting = task.getOwningTarget();
                this.appendToStack(stackRepresentation, targetExecuting.getName(), task.getTaskName(), task.getLocation());
            }
            --i;
        }
        this.marshalTargetDependancyStack(stackRepresentation, targetToExecute, targetExecuting);
    }

    private void marshalTargetDependancyStack(StringBuffer stackRepresentation, Target targetToExecute, Target targetExecuting) {
        if (targetToExecute != null) {
            Vector<Target> buildSequence = this.getTargetToBuildSequence(targetToExecute.getProject()).get(targetToExecute);
            int startIndex = buildSequence.indexOf(targetExecuting) + 1;
            int dependancyStackDepth = buildSequence.indexOf(targetToExecute);
            int i = startIndex;
            while (i <= dependancyStackDepth) {
                Target stackTarget = buildSequence.get(i);
                if (stackTarget.dependsOn(targetExecuting.getName())) {
                    this.appendToStack(stackRepresentation, stackTarget.getName(), "", stackTarget.getLocation());
                }
                ++i;
            }
        }
    }

    public void marshallProperties(StringBuffer propertiesRepresentation, boolean escapeLineSep) {
        Stack<Task> tasks = this.getTasks();
        if (tasks.isEmpty()) {
            return;
        }
        propertiesRepresentation.append("prop");
        propertiesRepresentation.append(",");
        Project project = tasks.peek().getProject();
        Map<String, Object> lastProperties = this.getProperties();
        Hashtable currentProperties = project.getProperties();
        if (lastProperties != null && currentProperties.size() == lastProperties.size()) {
            return;
        }
        Map<String, Object> initialProperties = this.getInitialProperties();
        Hashtable currentUserProperties = project.getUserProperties();
        Iterator iterator = currentProperties.keySet().iterator();
        while (iterator.hasNext()) {
            String propertyName;
            String originalPropertyName = propertyName = (String)iterator.next();
            if (lastProperties != null && lastProperties.get(propertyName) != null) continue;
            if (escapeLineSep) {
                propertyName = this.escapeLineSeparator(propertyName);
            }
            propertiesRepresentation.append(propertyName.length());
            propertiesRepresentation.append(",");
            propertiesRepresentation.append(propertyName);
            propertiesRepresentation.append(",");
            String propertyValue = (String)currentProperties.get(originalPropertyName);
            if (escapeLineSep) {
                propertyValue = this.escapeLineSeparator(propertyValue);
            }
            propertiesRepresentation.append(propertyValue.length());
            propertiesRepresentation.append(",");
            propertiesRepresentation.append(propertyValue);
            propertiesRepresentation.append(",");
            propertiesRepresentation.append(this.getPropertyType(initialProperties, currentUserProperties, originalPropertyName));
            propertiesRepresentation.append(",");
        }
        propertiesRepresentation.deleteCharAt(propertiesRepresentation.length() - 1);
        this.fProperties = currentProperties;
    }

    private int getPropertyType(Map<String, Object> initialProperties, Map<String, Object> currentUserProperties, String propertyName) {
        if (initialProperties.get(propertyName) != null) {
            if (currentUserProperties.get(propertyName) == null) {
                return 1;
            }
            return 0;
        }
        if (currentUserProperties.get(propertyName) == null) {
            return 2;
        }
        return 0;
    }

    private String escapeLineSeparator(String stringToEscape) {
        if (stringToEscape.indexOf(13) == -1 && stringToEscape.indexOf(10) == -1 && !stringToEscape.contains("\\r") && !stringToEscape.contains("\\n")) {
            return stringToEscape;
        }
        StringBuilder escapedValue = new StringBuilder(stringToEscape);
        int i = 0;
        while (i < escapedValue.length()) {
            switch (escapedValue.charAt(i)) {
                case '\r': {
                    escapedValue.replace(i, i + 1, "\\r");
                    ++i;
                    break;
                }
                case '\n': {
                    escapedValue.replace(i, i + 1, "\\n");
                    ++i;
                    break;
                }
                case '\\': {
                    if (escapedValue.charAt(i + 1) != 'r' && escapedValue.charAt(i + 1) != 'n') break;
                    escapedValue.replace(i, i + 1, "\\\\");
                    ++i;
                    break;
                }
            }
            ++i;
        }
        return escapedValue.toString();
    }

    private Target initializeBuildSequenceInformation(BuildEvent event, Map<Target, Vector<Target>> targetToBuildSequence) {
        Project antProject = event.getProject();
        Vector targets = (Vector)antProject.getReference("eclipse.ant.targetVector");
        if (targets == null || targets.size() < 1) {
            return null;
        }
        Hashtable allTargets = antProject.getTargets();
        for (String targetName : targets) {
            Vector sortedTargets = antProject.topoSort(targetName, allTargets);
            targetToBuildSequence.put((Target)allTargets.get(targetName), sortedTargets);
        }
        return (Target)allTargets.get(targets.remove(0));
    }
}

