/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.launching.remote.logger;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.util.StringUtils;
import org.eclipse.ant.internal.launching.remote.AntSecurityException;
import org.eclipse.ant.internal.launching.remote.RemoteAntMessages;

public class RemoteAntBuildLogger
extends DefaultLogger {
    private final long fStartTime = System.currentTimeMillis();
    private Socket fEventSocket;
    private PrintWriter fWriter;
    protected String fHost = "";
    private int fEventPort = -1;
    private String fProcessId = null;
    protected boolean fDebugMode = false;
    protected boolean fSentProcessId = false;
    private List<BuildEvent> fEventQueue;
    private String fLastFileName = null;
    private String fLastTaskName = null;

    protected void printMessage(String message, PrintStream stream, int priority) {
        this.marshalMessage(priority, message);
    }

    protected void connect() {
        if (this.fDebugMode) {
            System.out.println("RemoteAntBuildLogger: trying to connect" + this.fHost + ":" + this.fEventPort);
        }
        for (int i = 1; i < 5; ++i) {
            try {
                this.fEventSocket = new Socket(this.fHost, this.fEventPort);
                this.fWriter = new PrintWriter(this.fEventSocket.getOutputStream(), true);
                return;
            }
            catch (IOException iOException) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        this.shutDown();
    }

    protected void shutDown() {
        if (this.fEventQueue != null) {
            this.fEventQueue.clear();
        }
        if (this.fWriter != null) {
            this.fWriter.close();
            this.fWriter = null;
        }
        try {
            if (this.fEventSocket != null) {
                this.fEventSocket.close();
                this.fEventSocket = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendMessage(String msg) {
        if (this.fWriter == null) {
            return;
        }
        this.fWriter.println(msg);
    }

    public void buildFinished(BuildEvent event) {
        if (!this.fSentProcessId) {
            this.establishConnection();
        }
        this.handleException(event);
        this.printMessage(this.getTimeString(System.currentTimeMillis() - this.fStartTime), this.out, 2);
        this.shutDown();
    }

    protected void handleException(BuildEvent event) {
        Throwable exception = event.getException();
        if (exception == null || exception instanceof AntSecurityException) {
            return;
        }
        StringBuilder message = new StringBuilder();
        message.append(System.lineSeparator());
        message.append(RemoteAntMessages.getString("RemoteAntBuildLogger.1"));
        message.append(System.lineSeparator());
        if (3 <= this.msgOutputLevel || !(exception instanceof BuildException)) {
            message.append(StringUtils.getStackTrace((Throwable)exception));
        } else if (exception instanceof BuildException) {
            message.append(exception.toString()).append(System.lineSeparator());
        } else {
            message.append(exception.getMessage()).append(System.lineSeparator());
        }
        message.append(System.lineSeparator());
        this.printMessage(message.toString(), this.out, 0);
    }

    private String getTimeString(long milliseconds) {
        long seconds = milliseconds / 1000L;
        long minutes = seconds / 60L;
        seconds %= 60L;
        StringBuilder result = new StringBuilder(RemoteAntMessages.getString("RemoteAntBuildLogger.Total_time"));
        if (minutes > 0L) {
            result.append(minutes);
            if (minutes > 1L) {
                result.append(RemoteAntMessages.getString("RemoteAntBuildLogger._minutes_2"));
            } else {
                result.append(RemoteAntMessages.getString("RemoteAntBuildLogger._minute_3"));
            }
        }
        if (seconds > 0L) {
            if (minutes > 0L) {
                result.append(' ');
            }
            result.append(seconds);
            if (seconds > 1L) {
                result.append(RemoteAntMessages.getString("RemoteAntBuildLogger._seconds_4"));
            } else {
                result.append(RemoteAntMessages.getString("RemoteAntBuildLogger._second_5"));
            }
        }
        if (seconds == 0L && minutes == 0L) {
            result.append(milliseconds);
            result.append(RemoteAntMessages.getString("RemoteAntBuildLogger._milliseconds_6"));
        }
        return result.toString();
    }

    public void targetStarted(BuildEvent event) {
        if (!this.fSentProcessId) {
            this.establishConnection();
        }
        if (2 <= this.msgOutputLevel) {
            this.marshalTargetMessage(event);
        }
    }

    protected void establishConnection() {
        if (this.fEventPort == -1) {
            this.shutDown();
            return;
        }
        this.connect();
        this.fSentProcessId = true;
        StringBuilder message = new StringBuilder("processID");
        message.append(this.fProcessId);
        this.sendMessage(message.toString());
        if (this.fEventQueue != null) {
            for (BuildEvent buildEvent : this.fEventQueue) {
                this.processEvent(buildEvent);
            }
            this.fEventQueue = null;
        }
    }

    public void messageLogged(BuildEvent event) {
        if (event.getPriority() > this.msgOutputLevel && event.getPriority() != 5) {
            return;
        }
        if (!this.fSentProcessId) {
            if (event.getPriority() == 5) {
                if (2 > this.msgOutputLevel) {
                    return;
                }
                this.establishConnection();
                return;
            }
            if (this.fEventQueue == null) {
                this.fEventQueue = new ArrayList<BuildEvent>(10);
            }
            this.fEventQueue.add(event);
            return;
        }
        this.processEvent(event);
    }

    private void processEvent(BuildEvent event) {
        if (event.getTask() != null && !this.emacsMode) {
            try {
                this.marshalTaskMessage(event);
            }
            catch (IOException iOException) {}
        } else {
            this.marshalMessage(event);
        }
    }

    private void marshalMessage(BuildEvent event) {
        String eventMessage = event.getMessage();
        if (eventMessage.length() == 0) {
            return;
        }
        this.marshalMessage(event.getPriority(), eventMessage);
    }

    protected void marshalMessage(int priority, String message) {
        try {
            BufferedReader r = new BufferedReader(new StringReader(message));
            String line = r.readLine();
            while (line != null) {
                StringBuilder messageLine = new StringBuilder();
                if (priority != -1) {
                    messageLine.append(priority);
                    messageLine.append(',');
                }
                messageLine.append(line);
                this.sendMessage(messageLine.toString());
                line = r.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void marshalTaskMessage(BuildEvent event) throws IOException {
        String eventMessage = event.getMessage();
        if (eventMessage.length() == 0) {
            return;
        }
        BufferedReader r = new BufferedReader(new StringReader(eventMessage));
        String line = r.readLine();
        String taskName = event.getTask().getTaskName();
        if (taskName != null && taskName.equals(this.fLastTaskName)) {
            taskName = "";
        } else {
            this.fLastTaskName = taskName;
        }
        Location location = event.getTask().getLocation();
        String fileName = null;
        int lineNumber = -1;
        try {
            fileName = location.getFileName();
            lineNumber = location.getLineNumber();
        }
        catch (NoSuchMethodError e) {
            fileName = location.toString();
        }
        if (location.equals((Object)Location.UNKNOWN_LOCATION)) {
            fileName = location.toString();
            lineNumber = -1;
        }
        int priority = event.getPriority();
        while (line != null) {
            StringBuilder message = new StringBuilder("6");
            message.append(priority);
            message.append(',');
            message.append(taskName);
            message.append(',');
            message.append(line.length());
            message.append(',');
            message.append(line);
            message.append(',');
            if (!fileName.equals(this.fLastFileName)) {
                message.append(fileName.length());
                message.append(',');
                message.append(fileName);
            }
            message.append(',');
            message.append(lineNumber);
            this.sendMessage(message.toString());
            this.fLastFileName = fileName;
            line = r.readLine();
        }
    }

    private void marshalTargetMessage(BuildEvent event) {
        Target target = event.getTarget();
        Location location = target.getLocation();
        StringBuilder message = new StringBuilder();
        message.append("7");
        message.append(',');
        message.append(target.getName());
        message.append(':');
        message.append(',');
        if (location != null && location != Location.UNKNOWN_LOCATION) {
            String fileName = location.getFileName();
            message.append(fileName.length());
            message.append(',');
            message.append(fileName);
            message.append(',');
            message.append(location.getLineNumber());
        }
        this.sendMessage(message.toString());
    }

    public void buildStarted(BuildEvent event) {
        this.establishConnection();
        super.buildStarted(event);
    }

    public void configure(Map<String, String> userProperties) {
        String portProperty = userProperties.remove("eclipse.connect.port");
        if (portProperty != null) {
            this.fEventPort = Integer.parseInt(portProperty);
        }
        this.fProcessId = userProperties.remove("org.eclipse.ant.core.ANT_PROCESS_ID");
    }
}

