/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.launching.remote.logger;

import java.io.File;

public class RemoteAntBreakpoint {
    private final File fFile;
    private final int fLineNumber;
    private final String fFileName;

    public RemoteAntBreakpoint(String breakpointRepresentation) {
        String[] data = breakpointRepresentation.split(",");
        String fileName = data[1];
        String lineNumber = data[2];
        this.fFileName = fileName;
        this.fFile = new File(fileName);
        this.fLineNumber = Integer.parseInt(lineNumber);
    }

    public boolean isAt(String fileName, int lineNumber) {
        return this.fLineNumber == lineNumber && fileName != null && this.fFile.equals(new File(fileName));
    }

    public String toMarshallString() {
        StringBuilder buffer = new StringBuilder("breakpoint");
        buffer.append(",");
        buffer.append(this.fFileName);
        buffer.append(",");
        buffer.append(this.fLineNumber);
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RemoteAntBreakpoint)) {
            return false;
        }
        RemoteAntBreakpoint other = (RemoteAntBreakpoint)obj;
        return other.getLineNumber() == this.fLineNumber && other.getFile().equals(this.fFile);
    }

    public int hashCode() {
        return this.fFileName.hashCode() + this.fLineNumber;
    }

    public int getLineNumber() {
        return this.fLineNumber;
    }

    public String getFileName() {
        return this.fFileName;
    }

    public File getFile() {
        return this.fFile;
    }
}

