Eclipse Project Update Sites
============================

This site contains information about the artifacts created by the Eclipse project.


### Eclipse build repositories

The Eclipse project also publish unreleased versions of its artifacts.
Committers and early adopters, [look below for unversioned repositories.](#Non-versioned-repository-URLs)

#### Versioned repository URLs

Eclipse Project builds are stored in p2 repositories that are produced as part of the [Eclipse project build process](https://www.eclipse.org/eclipse/platform-releng/buildSchedule.html). 
This page provides an overview of the different repositories maintained by the Eclipse project, and their corresponding location and retention policy. 
See also [meaning of kinds of builds](https://download.eclipse.org/eclipse/downloads/build_types.html).

See [Adding a new software site](http://help.eclipse.org/latest/index.jsp?topic=/org.eclipse.platform.doc.user/tasks/tasks-127.htm) for instructions on how to add a new update site to your Eclipse installation.


The following is the list of actual and planned statble update sites for releases.

| Repository | Repository URL | Retention Policys |
| --- | --- | --- |
| 4.34.x releases (2024-12) | [https://download.eclipse.org/eclipse/updates/4.34/](https://download.eclipse.org/eclipse/updates/4.34/) | Retained Indefinitely |
| 4.33.x releases (2024-09) | [https://download.eclipse.org/eclipse/updates/4.33/](https://download.eclipse.org/eclipse/updates/4.33/) | Retained Indefinitely |
| 4.32.x releases (2024-06) | [https://download.eclipse.org/eclipse/updates/4.32/](https://download.eclipse.org/eclipse/updates/4.32/) | Retained Indefinitely |
| 4.31.x releases (2024-03) | [https://download.eclipse.org/eclipse/updates/4.31/](https://download.eclipse.org/eclipse/updates/4.31/) | Retained Indefinitely |
| 4.30.x releases (2023-12) | [https://download.eclipse.org/eclipse/updates/4.30/](https://download.eclipse.org/eclipse/updates/4.30/) | Retained Indefinitely |
| 4.29.x releases (2023-09) | [https://download.eclipse.org/eclipse/updates/4.29/](https://download.eclipse.org/eclipse/updates/4.29/) | Retained Indefinitely |
| 4.28.x releases (2023-06) | [https://download.eclipse.org/eclipse/updates/4.28/](https://download.eclipse.org/eclipse/updates/4.28/) | Retained Indefinitely |
| 4.27.x releases (2023-03) | [https://download.eclipse.org/eclipse/updates/4.27/](https://download.eclipse.org/eclipse/updates/4.27/) | Retained Indefinitely |
| 4.26.x releases (2022-12) | [https://download.eclipse.org/eclipse/updates/4.26/](https://download.eclipse.org/eclipse/updates/4.26/) | Retained Indefinitely |
| 4.25.x releases (2022-09) | [https://download.eclipse.org/eclipse/updates/4.25/](https://download.eclipse.org/eclipse/updates/4.25/) | Retained Indefinitely |
| 4.24.x releases (2022-06) | [https://download.eclipse.org/eclipse/updates/4.24/](https://download.eclipse.org/eclipse/updates/4.24/) | Retained Indefinitely |
| 4.23.x releases (2022-03) | [https://download.eclipse.org/eclipse/updates/4.23/](https://download.eclipse.org/eclipse/updates/4.23/) | Retained Indefinitely |
| 4.22.x releases (2021-12) | [https://download.eclipse.org/eclipse/updates/4.22/](https://download.eclipse.org/eclipse/updates/4.22/) | Retained Indefinitely |
| 4.21.x releases (2021-09) | [https://download.eclipse.org/eclipse/updates/4.21/](https://download.eclipse.org/eclipse/updates/4.21/) | Retained Indefinitely |
| 4.20.x releases (2021-06) | [https://download.eclipse.org/eclipse/updates/4.20/](https://download.eclipse.org/eclipse/updates/4.20/) | Retained Indefinitely |
| 4.19.x releases (2021-03) | [https://download.eclipse.org/eclipse/updates/4.19/](https://download.eclipse.org/eclipse/updates/4.19/) | Retained Indefinitely |
| 4.18.x releases (2020-12) | [https://download.eclipse.org/eclipse/updates/4.18/](https://download.eclipse.org/eclipse/updates/4.18/) | Retained Indefinitely |
| 4.17.x releases (2020-09) | [https://download.eclipse.org/eclipse/updates/4.17/](https://download.eclipse.org/eclipse/updates/4.17/) | Retained Indefinitely |
| 4.16.x releases (2020-06) | [https://download.eclipse.org/eclipse/updates/4.16/](https://download.eclipse.org/eclipse/updates/4.16/) | Retained Indefinitely |
| 4.15.x releases (2020-03) | [https://download.eclipse.org/eclipse/updates/4.15/](https://download.eclipse.org/eclipse/updates/4.15/) | Retained Indefinitely |
| 4.14.x releases (2019-12) | [https://download.eclipse.org/eclipse/updates/4.14/](https://download.eclipse.org/eclipse/updates/4.14/) | Retained Indefinitely |
| 4.13.x releases (2019-09) | [https://download.eclipse.org/eclipse/updates/4.13/](https://download.eclipse.org/eclipse/updates/4.13/) | Retained Indefinitely |
| 4.12.x releases (2019-06) | [https://download.eclipse.org/eclipse/updates/4.12/](https://download.eclipse.org/eclipse/updates/4.12/) | Retained Indefinitely |
| 4.11.x releases (2019-03) | [https://download.eclipse.org/eclipse/updates/4.11/](https://download.eclipse.org/eclipse/updates/4.11/) | Retained Indefinitely |
| 4.10.x releases (2018-12) | [https://download.eclipse.org/eclipse/updates/4.10/](https://download.eclipse.org/eclipse/updates/4.10/) | Retained Indefinitely |
| 4.9.x releases (2018-09) | [https://download.eclipse.org/eclipse/updates/4.9/](https://download.eclipse.org/eclipse/updates/4.9/) | Retained Indefinitely |
| 4.8.x releases (Photon) | [https://download.eclipse.org/eclipse/updates/4.8/](https://download.eclipse.org/eclipse/updates/4.8/) | Retained Indefinitely |
| 4.7.x releases (Oxygen) | [https://download.eclipse.org/eclipse/updates/4.7](https://download.eclipse.org/eclipse/updates/4.7) | Retained Indefinitely |
| 4.6.x releases (Neon) | [https://download.eclipse.org/eclipse/updates/4.6/](https://download.eclipse.org/eclipse/updates/4.6/) | Retained Indefinitely |
| 4.5.x releases (Mars) | [https://download.eclipse.org/eclipse/updates/4.5/](https://download.eclipse.org/eclipse/updates/4.5/) | Retained Indefinitely |
| 4.4.x releases (Luna) | [https://download.eclipse.org/eclipse/updates/4.4/](https://download.eclipse.org/eclipse/updates/4.4/) | Retained Indefinitely |
| 4.3.x releases (Kepler) | [https://download.eclipse.org/eclipse/updates/4.3/](https://download.eclipse.org/eclipse/updates/4.3/) | Retained Indefinitely |
| 4.2.x releases (Juno) | [https://download.eclipse.org/eclipse/updates/4.2/](https://download.eclipse.org/eclipse/updates/4.2/) | Retained Indefinitely |
| 3.8.x releases (Juno) | [https://download.eclipse.org/eclipse/updates/3.8/](https://download.eclipse.org/eclipse/updates/3.8/) | Retained Indefinitely |
| 3.7.x releases (Indigo) | [https://download.eclipse.org/eclipse/updates/3.7/](https://download.eclipse.org/eclipse/updates/3.7/) | Retained Indefinitely |
| 3.6.x releases (Helios) | [https://download.eclipse.org/eclipse/updates/3.6/](https://download.eclipse.org/eclipse/updates/3.6/) | Retained Indefinitely |
| 3.5.x releases (Galileo) | [https://download.eclipse.org/eclipse/updates/3.5/](https://download.eclipse.org/eclipse/updates/3.5/) | Retained Indefinitely |
| 3.4.x releases (Ganymede) | [https://download.eclipse.org/eclipse/updates/3.4/](https://download.eclipse.org/eclipse/updates/3.4/) | Retained Indefinitely |

#### Non-versioned repository URLs

For the current development release you also find integration update sites, the following site points to the current integration update site:

* https://download.eclipse.org/eclipse/updates/I-builds/

Last 7-days I-builds are retained along with every weeks Monday's I-builds until a milestone is available; they will be removed once a milestone is available.   
To be explicit, only about four integration builds are left in the composite I-build repository, even though the simple repositories are retained until the release is avail

Below are special composite repository URLs that are primarily intended for committers and early adopters. 
They are each a composite that simply points to the current version of the repositories listed below. Those using these non-versioned URL do not need to change their software repository lists or scripts. In other words, the contents are identical to their current, versioned counterparts, but the URL stays the same.

These repos go well together with the latest release train repo: [http://download.eclipse.org/releases/latest](http://download.eclipse.org/releases/latest)

| Repository | Repository URL | Retention Policy |
| --- | --- | --- |
| Current Integration builds | [http://download.eclipse.org/eclipse/updates/I-builds](http://download.eclipse.org/eclipse/updates/I-builds) | See above |
| Latest Release | [https://download.eclipse.org/eclipse/updates/latest](https://download.eclipse.org/eclipse/updates/latest) | See above |

#### Eclipse/Repository retention policy

p2's ability to provision complete products from repositories has made the concept of repositories a first-class citizen of the eclipse ecosystem. 
People can now use repositories during the build, at development time to setup their target and find missing bundles or simply to setup their IDE. 
Consequently, repository users expect the content of these repositories to be stable, and it is important to make the retention policy of each repository clearly available.

The following document describes the retention policy used by the Eclipse project:

*   Release repositories: the repository contains all the metadata and artifact of a given release and no content is ever removed from it. When a new SR is made available the metadata and the artifacts are appended to the existing repository.
*   Integration build repositories: content is expected to stay until the milestone is complete, but can be disposed at any time. They may be deleted but usually only if it is known to be a "bad" I-build (that is, will hurt something if installed).
*   Nightly build repositories: content can be disposed at any time.

Though specific to the Eclipse platform team, these rules are general enough that we encourage any other team producing repositories to follow them.
