/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.eclipsebuild;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.tycho.eclipsebuild.MarkerDTO;

public class EclipseBuildResult
implements Serializable {
    private List<IMarker> markers = new ArrayList<IMarker>();
    private Map<IMarker, String> resourceMap = new HashMap<IMarker, String>();

    public void addMarker(IMarker marker) {
        MarkerDTO wrapper = new MarkerDTO(marker);
        this.markers.add(wrapper);
        IResource resource = marker.getResource();
        if (resource != null) {
            this.resourceMap.put(wrapper, resource.getProjectRelativePath().toString());
        }
    }

    public Stream<IMarker> markers() {
        return this.markers.stream();
    }

    public String getMarkerPath(IMarker marker) {
        return this.resourceMap.get(marker);
    }
}

