/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.eclipsebuild;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.tycho.eclipsebuild.EclipseBuildResult;

public abstract class AbstractEclipseBuild<Result extends EclipseBuildResult>
implements Callable<Result>,
Serializable,
IProgressMonitor {
    private boolean debug;
    private String baseDir;

    protected AbstractEclipseBuild(Path projectDir, boolean debug) {
        this.debug = debug;
        this.baseDir = AbstractEclipseBuild.pathAsString(projectDir);
    }

    @Override
    public final Result call() throws Exception {
        Platform.addLogListener((status, plugin) -> this.debug(status.toString()));
        AbstractEclipseBuild.disableAutoBuild();
        this.deleteAllProjects();
        IProject project = this.importProject();
        project.build(15, (IProgressMonitor)this);
        try {
            this.buildProject(project);
            Result result = this.createResult(project);
            for (IMarker marker : project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2)) {
                ((EclipseBuildResult)result).addMarker(marker);
                this.debug(marker.toString());
            }
            Result Result = result;
            return Result;
        }
        catch (CoreException e) {
            this.printStatus(e.getStatus());
            throw e;
        }
        finally {
            ResourcesPlugin.getWorkspace().save(true, (IProgressMonitor)this);
        }
    }

    protected void printStatus(IStatus status) {
        this.printStatus(status, 0);
    }

    private void printStatus(IStatus status, int indent) {
        if (this.debug) {
            String prefix = " ".repeat(indent);
            this.debug(prefix + status.getPlugin() + ": " + status.getMessage());
            Throwable exception = status.getException();
            if (exception != null) {
                StringWriter stringWriter = new StringWriter();
                exception.printStackTrace(new PrintWriter(stringWriter));
                stringWriter.toString().lines().forEach(v -> this.debug(prefix + v));
            }
            for (IStatus child : status.getChildren()) {
                this.printStatus(child, indent + 1);
            }
        }
    }

    protected void buildProject(IProject project) throws CoreException {
        this.debug("Building...");
        AbstractEclipseBuild.executeWithJobs(this, m -> project.build(6, m));
    }

    protected abstract Result createResult(IProject var1) throws Exception;

    static void disableAutoBuild() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription desc = workspace.getDescription();
        desc.setAutoBuilding(false);
        workspace.setDescription(desc);
    }

    public static void executeWithJobs(IProgressMonitor monitor, ICoreRunnable runnable) throws CoreException {
        Set<Job> scheduledJobs = AbstractEclipseBuild.recordJobs(new LinkedHashSet<Job>(), monitor, runnable);
        for (Job job : scheduledJobs) {
            if (monitor != null) {
                monitor.subTask("Wait for job " + job.getName() + " to finish");
            }
            try {
                job.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    public static Set<Job> recordJobs(final Set<Job> scheduledJobs, IProgressMonitor monitor, ICoreRunnable runnable) throws CoreException {
        IJobChangeListener listener = new IJobChangeListener(){

            public void sleeping(IJobChangeEvent event) {
            }

            public void scheduled(IJobChangeEvent event) {
                scheduledJobs.add(event.getJob());
            }

            public void running(IJobChangeEvent event) {
            }

            public void done(IJobChangeEvent event) {
                scheduledJobs.remove(event.getJob());
            }

            public void awake(IJobChangeEvent event) {
            }

            public void aboutToRun(IJobChangeEvent event) {
            }
        };
        Job.getJobManager().addJobChangeListener(listener);
        IProgressMonitor safe = IProgressMonitor.nullSafe((IProgressMonitor)monitor);
        runnable.run(safe);
        Job.getJobManager().removeJobChangeListener(listener);
        return scheduledJobs;
    }

    private void deleteAllProjects() throws CoreException {
        for (IProject project : ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
            project.delete(9, (IProgressMonitor)this);
        }
    }

    private IProject importProject() throws CoreException, IOException {
        IPath projectPath = IPath.fromOSString((String)this.baseDir);
        IPath projectDescriptionFile = projectPath.append(".project");
        IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().loadProjectDescription(projectDescriptionFile);
        projectDescription.setLocation(projectPath);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectDescription.getName());
        project.create(projectDescription, (IProgressMonitor)this);
        project.open((IProgressMonitor)this);
        return project;
    }

    protected void debug(String string) {
        if (this.debug) {
            System.out.println(string);
        }
    }

    protected void debug(String string, Throwable t) {
        if (t == null) {
            this.debug(string);
            return;
        }
        if (this.debug) {
            StringWriter writer = new StringWriter();
            t.printStackTrace(new PrintWriter(writer));
            this.debug(string + System.lineSeparator() + String.valueOf(writer));
        }
    }

    static String pathAsString(Path path) {
        if (path != null) {
            return path.toAbsolutePath().toString();
        }
        return null;
    }

    public boolean isCanceled() {
        return Thread.currentThread().isInterrupted();
    }

    public void beginTask(String name, int totalWork) {
        if (name != null && !name.isBlank()) {
            this.debug("> " + name);
        }
    }

    public void subTask(String name) {
        if (name != null && !name.isBlank()) {
            this.debug(">> " + name);
        }
    }

    public void setTaskName(String name) {
        if (name != null && !name.isBlank()) {
            this.debug("> " + name);
        }
    }

    public void done() {
    }

    public void setCanceled(boolean value) {
    }

    public void internalWorked(double work) {
    }

    public void worked(int work) {
    }
}

