/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2tools;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.commons.io.FileUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepositoryFactory;
import org.eclipse.equinox.internal.p2.metadata.repository.SimpleMetadataRepositoryFactory;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.mirroring.IArtifactMirrorLog;
import org.eclipse.equinox.p2.internal.repository.mirroring.Mirroring;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.internal.repository.tools.SlicingOptions;
import org.eclipse.equinox.p2.internal.repository.tools.XZCompressor;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.tycho.BuildDirectory;
import org.eclipse.tycho.DependencySeed;
import org.eclipse.tycho.ReproducibleUtils;
import org.eclipse.tycho.helper.StatusTool;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.p2.repository.RepositoryLayoutHelper;
import org.eclipse.tycho.p2.tools.BuildContext;
import org.eclipse.tycho.p2.tools.DestinationRepositoryDescriptor;
import org.eclipse.tycho.p2.tools.FacadeException;
import org.eclipse.tycho.p2.tools.RepositoryReferences;
import org.eclipse.tycho.p2.tools.mirroring.facade.IUDescription;
import org.eclipse.tycho.p2.tools.mirroring.facade.MirrorApplicationService;
import org.eclipse.tycho.p2.tools.mirroring.facade.MirrorOptions;
import org.eclipse.tycho.p2tools.TychoMirrorApplication;
import org.eclipse.tycho.p2tools.copiedfromp2.RecreateRepositoryApplication;
import org.eclipse.tycho.p2tools.copiedfromp2.RepositoryDescriptor;

@Component(role=MirrorApplicationService.class)
public class MirrorApplicationServiceImpl
implements MirrorApplicationService {
    private static final String P2_INDEX_FILE = "p2.index";
    private static final String MIRROR_FAILURE_MESSAGE = "Mirroring failed";
    @Requirement
    Logger logger;
    @Requirement
    IProvisioningAgent agent;

    @Override
    public void mirrorStandalone(RepositoryReferences sources, DestinationRepositoryDescriptor destination, Collection<IUDescription> seedIUs, MirrorOptions mirrorOptions, BuildDirectory tempDirectory) throws FacadeException {
        this.agent.getService(IArtifactRepositoryManager.class);
        TychoMirrorApplication mirrorApp = MirrorApplicationServiceImpl.createMirrorApplication(sources, destination, this.agent, this.logger);
        mirrorApp.setSlicingOptions(MirrorApplicationServiceImpl.createSlicingOptions(mirrorOptions));
        mirrorApp.setIgnoreErrors(mirrorOptions.isIgnoreErrors());
        try {
            mirrorApp.setVerbose(true);
            mirrorApp.setLog(new LogListener(this.logger));
            mirrorApp.setSourceIUs(MirrorApplicationServiceImpl.querySourceIus(seedIUs, mirrorApp.getCompositeMetadataRepository(), sources));
            IStatus returnStatus = mirrorApp.run(null);
            this.checkStatus(returnStatus, mirrorOptions.isIgnoreErrors());
        }
        catch (ProvisionException e) {
            throw new FacadeException("Mirroring failed: " + StatusTool.collectProblems((IStatus)e.getStatus()), e);
        }
    }

    public void setAgent(IProvisioningAgent agent) {
        this.agent = agent;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    private static SlicingOptions createSlicingOptions(MirrorOptions mirrorOptions) {
        SlicingOptions slicingOptions = new SlicingOptions();
        slicingOptions.considerStrictDependencyOnly(mirrorOptions.isFollowStrictOnly());
        slicingOptions.everythingGreedy(mirrorOptions.isIncludeNonGreedy());
        slicingOptions.followOnlyFilteredRequirements(mirrorOptions.isFollowOnlyFilteredRequirements());
        slicingOptions.includeOptionalDependencies(mirrorOptions.isIncludeOptional());
        slicingOptions.latestVersionOnly(mirrorOptions.isLatestVersionOnly());
        slicingOptions.setFilter(mirrorOptions.getFilter());
        return slicingOptions;
    }

    private static List<IInstallableUnit> querySourceIus(Collection<IUDescription> sourceIUs, IMetadataRepository repository, RepositoryReferences sources) throws FacadeException {
        if (sourceIUs == null || sourceIUs.isEmpty()) {
            return null;
        }
        ArrayList<IInstallableUnit> result = new ArrayList<IInstallableUnit>();
        for (IUDescription iu : sourceIUs) {
            IQuery<IInstallableUnit> iuQuery = MirrorApplicationServiceImpl.createQuery(iu);
            Iterator queryResult = repository.query(iuQuery, null).iterator();
            if (!queryResult.hasNext()) {
                throw new FacadeException("Could not find IU " + iu.toString() + " in any of the source repositories " + String.valueOf(sources.getMetadataRepositories()), null);
            }
            while (queryResult.hasNext()) {
                result.add((IInstallableUnit)queryResult.next());
            }
        }
        return result;
    }

    private static IQuery<IInstallableUnit> createQuery(IUDescription iu) {
        String id = iu.getId();
        String version = iu.getVersion();
        if (iu.getQueryMatchExpression() != null) {
            return QueryUtil.createMatchQuery((String)iu.getQueryMatchExpression(), (Object[])iu.getQueryParameters());
        }
        if (version == null || version.isEmpty()) {
            return QueryUtil.createLatestQuery((IQuery)QueryUtil.createIUQuery((String)id));
        }
        return QueryUtil.createIUQuery((String)id, (Version)Version.parseVersion((String)version));
    }

    @Override
    public void mirrorReactor(RepositoryReferences sources, DestinationRepositoryDescriptor destination, Collection<DependencySeed> projectSeeds, BuildContext context, boolean includeAllDependencies, boolean includeAllSource, boolean includeRequiredBundles, boolean includeRequiredFeatures, boolean filterProvided, boolean addOnlyProvidingRepoReferences, Map<String, String> filterProperties) throws FacadeException {
        TychoMirrorApplication mirrorApp = MirrorApplicationServiceImpl.createMirrorApplication(sources, destination, this.agent, this.logger);
        try {
            mirrorApp.setSourceIUs(MirrorApplicationServiceImpl.toInstallableUnitList(projectSeeds, mirrorApp.getCompositeMetadataRepository(), sources));
            mirrorApp.setIncludeSources(includeAllSource, sources.getTargetPlatform());
            mirrorApp.setIncludeRequiredBundles(includeRequiredBundles);
            mirrorApp.setIncludeRequiredFeatures(includeRequiredFeatures);
            mirrorApp.setFilterProvided(filterProvided);
            mirrorApp.setAddOnlyProvidingRepoReferences(addOnlyProvidingRepoReferences);
            mirrorApp.setEnvironments(context.getEnvironments());
            SlicingOptions options = new SlicingOptions();
            options.considerStrictDependencyOnly(!includeAllDependencies);
            Map filter = options.getFilter();
            MirrorApplicationServiceImpl.addFilterForFeatureJARs(filter);
            if (filterProperties != null) {
                filter.putAll(filterProperties);
            }
            mirrorApp.setSlicingOptions(options);
            LogListener logListener = new LogListener(this.logger);
            mirrorApp.setLog(logListener);
            IStatus returnStatus = mirrorApp.run(null);
            this.checkStatus(returnStatus, false);
            logListener.showHelpForLoggedMessages();
        }
        catch (ProvisionException e) {
            throw new FacadeException("Mirroring failed: " + StatusTool.collectProblems((IStatus)e.getStatus()), e);
        }
        this.recreateArtifactRepository(destination);
    }

    private void xzCompress(DestinationRepositoryDescriptor destination) throws FacadeException {
        if (!destination.isXZCompress()) {
            return;
        }
        try {
            XZCompressor xzCompressor = new XZCompressor();
            xzCompressor.setPreserveOriginalFile(destination.shouldKeepNonXzIndexFiles());
            xzCompressor.setRepoFolder(destination.getLocation().getAbsolutePath());
            xzCompressor.compressRepo();
        }
        catch (IOException e) {
            throw new FacadeException("XZ compression failed", e);
        }
    }

    @Override
    public void recreateArtifactRepository(DestinationRepositoryDescriptor destination) throws FacadeException {
        if (destination.isMetaDataOnly()) {
            return;
        }
        RepositoryDescriptor descriptor = new RepositoryDescriptor();
        descriptor.setAppend(true);
        descriptor.setFormat(null);
        descriptor.setKind("artifact");
        File location = destination.getLocation();
        File artifactsXz = new File(location, "artifacts.xml.xz");
        if (artifactsXz.exists()) {
            artifactsXz.delete();
        }
        descriptor.setLocation(location.toURI());
        RecreateRepositoryApplication application = new RecreateRepositoryApplication(this.agent);
        application.setArtifactRepository(descriptor.getRepoLocation());
        try {
            application.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (ProvisionException e) {
            throw new FacadeException("Recreate artifact repository failed", e);
        }
        this.xzCompress(destination);
    }

    private static TychoMirrorApplication createMirrorApplication(RepositoryReferences sources, DestinationRepositoryDescriptor destination, IProvisioningAgent agent, Logger logger) {
        TychoMirrorApplication mirrorApp = new TychoMirrorApplication(agent, destination, logger);
        mirrorApp.setRaw(false);
        List<RepositoryDescriptor> sourceDescriptors = MirrorApplicationServiceImpl.createSourceDescriptors(sources);
        for (RepositoryDescriptor sourceDescriptor : sourceDescriptors) {
            mirrorApp.addSource(sourceDescriptor);
        }
        mirrorApp.addDestination(MirrorApplicationServiceImpl.createDestinationDescriptor(destination));
        return mirrorApp;
    }

    private static RepositoryDescriptor createDestinationDescriptor(DestinationRepositoryDescriptor destination) {
        RepositoryDescriptor destinationDescriptor = new RepositoryDescriptor();
        destinationDescriptor.setLocation(destination.getLocation().toURI());
        destinationDescriptor.setAppend(destination.isAppend());
        destinationDescriptor.setName(destination.getName());
        destinationDescriptor.setCompressed(destination.isCompress());
        if (destination.isMetaDataOnly()) {
            destinationDescriptor.setKind("M");
        }
        return destinationDescriptor;
    }

    private static void addFilterForFeatureJARs(Map<String, String> filter) {
        filter.put("org.eclipse.update.install.features", "true");
    }

    private static List<RepositoryDescriptor> createSourceDescriptors(RepositoryReferences sources) {
        ArrayList<RepositoryDescriptor> result = new ArrayList<RepositoryDescriptor>();
        MirrorApplicationServiceImpl.createSourceRepositories(result, sources.getMetadataRepositories(), "M");
        MirrorApplicationServiceImpl.createSourceRepositories(result, sources.getArtifactRepositories(), "A");
        return result;
    }

    private static void createSourceRepositories(List<RepositoryDescriptor> result, Collection<URI> repositoryLocations, String repositoryKind) {
        for (URI repositoryLocation : repositoryLocations) {
            RepositoryDescriptor repository = new RepositoryDescriptor();
            repository.setKind(repositoryKind);
            repository.setLocation(repositoryLocation);
            result.add(repository);
        }
    }

    private static List<IInstallableUnit> toInstallableUnitList(Collection<DependencySeed> seeds, IMetadataRepository sourceRepository, RepositoryReferences sourceRepositoryNames) throws FacadeException {
        ArrayList<IInstallableUnit> result = new ArrayList<IInstallableUnit>(seeds.size());
        for (DependencySeed seed : seeds) {
            if (seed.getInstallableUnit() == null) {
                String unitId = seed.getId() + ("eclipse-feature".equals(seed.getType()) ? ".feature.group" : "");
                result.addAll(MirrorApplicationServiceImpl.querySourceIus(Collections.singletonList(new IUDescription(unitId, null)), sourceRepository, sourceRepositoryNames));
                continue;
            }
            result.add(seed.getInstallableUnit());
        }
        if (result.isEmpty()) {
            throw new IllegalArgumentException("List of seed units for repository aggregation must not be empty");
        }
        return result;
    }

    private void checkStatus(IStatus status, boolean ignoreErrors) throws FacadeException {
        if (status.matches(4)) {
            String message = "Mirroring failed: " + StatusTool.collectProblems((IStatus)status);
            if (!ignoreErrors) {
                throw new FacadeException(message, StatusTool.findException((IStatus)status));
            }
            this.logger.info(message);
        }
    }

    @Override
    public void addMavenMappingRules(File repository, URI[] mavenRepositories) throws FacadeException {
        SimpleArtifactRepositoryFactory repoFactory = new SimpleArtifactRepositoryFactory();
        SimpleArtifactRepository repo = null;
        try {
            repo = (SimpleArtifactRepository)repoFactory.load(repository.toURI(), 1, null);
        }
        catch (ProvisionException ex) {
            throw new FacadeException(ex);
        }
        if (repo == null) {
            throw new IllegalStateException("Repository couldn't be loaded");
        }
        LinkedList<MappingRule> rules = new LinkedList<MappingRule>();
        for (String[] stringArray : repo.getRules()) {
            rules.add(new MappingRule(stringArray[0], stringArray[1]));
        }
        block5: for (IArtifactDescriptor artifact : repo.getDescriptors()) {
            GAV gav = RepositoryLayoutHelper.getGAV(artifact.getProperties());
            String string = RepositoryLayoutHelper.getClassifier(artifact.getProperties());
            String mavenExtension = RepositoryLayoutHelper.getType(artifact.getProperties());
            if (gav == null || gav.getVersion().endsWith("-SNAPSHOT")) continue;
            for (URI mavenRepo : mavenRepositories) {
                IArtifactKey artifactKey = artifact.getArtifactKey();
                URI mavenArtifactURI = URI.create(mavenRepo.toString() + "/" + RepositoryLayoutHelper.getRelativePath(gav, string, mavenExtension));
                try {
                    HttpURLConnection httpConnection;
                    int responseCode;
                    URLConnection connection = mavenArtifactURI.toURL().openConnection();
                    if (connection instanceof HttpURLConnection && (responseCode = (httpConnection = (HttpURLConnection)connection).getResponseCode()) != 200) {
                        this.logger.debug(artifactKey.toString() + "/" + String.valueOf(gav) + " not found in " + String.valueOf(mavenRepo));
                        continue;
                    }
                    rules.addFirst(new MappingRule("(& (classifier=" + artifactKey.getClassifier() + ")(id=" + artifactKey.getId() + ")(version=" + artifactKey.getVersion().toString() + "))", mavenArtifactURI.toString()));
                    File artifactFile = repo.getArtifactFile(artifactKey);
                    if (artifactFile != null) {
                        artifactFile.delete();
                    }
                    this.logger.info(String.valueOf(artifactKey) + " remapped to " + String.valueOf(mavenArtifactURI));
                    continue block5;
                }
                catch (IOException ex) {
                    throw new FacadeException(ex);
                }
            }
        }
        String[][] newRules = new String[rules.size()][2];
        int i = 0;
        for (MappingRule mappingRule : rules) {
            newRules[i][0] = mappingRule.filter;
            newRules[i][1] = mappingRule.urlPattern;
            ++i;
        }
        repo.setRules(newRules);
        repo.save();
        DestinationRepositoryDescriptor desc = new DestinationRepositoryDescriptor(repository, repo.getName(), new File(repository, "artifacts.xml.xz").exists(), new File(repository, "artifacts.xml.xz").exists(), true, false, false);
        this.xzCompress(desc);
    }

    @Override
    public void mirrorDirect(IArtifactRepository sourceArtifactRepository, IQueryable<IInstallableUnit> sourceMetadataRepository, File repositoryDestination, String repositoryName) throws FacadeException {
        if (repositoryDestination.exists()) {
            FileUtils.deleteQuietly((File)repositoryDestination);
        }
        Objects.requireNonNull(sourceArtifactRepository.getProvisioningAgent(), "Source repository needs to have an agent");
        SimpleMetadataRepositoryFactory metadataRepositoryFactory = new SimpleMetadataRepositoryFactory();
        metadataRepositoryFactory.setAgent(this.agent);
        SimpleArtifactRepositoryFactory artifactRepositoryFactory = new SimpleArtifactRepositoryFactory();
        artifactRepositoryFactory.setAgent(this.agent);
        IArtifactRepository destinationArtifactRepository = artifactRepositoryFactory.create(repositoryDestination.toURI(), repositoryName, null, Map.of());
        IMetadataRepository destinationMetadataRepository = metadataRepositoryFactory.create(repositoryDestination.toURI(), repositoryName, null, Map.of());
        MultiStatus multiStatus = new MultiStatus("org.eclipse.equinox.p2.transformer", 0, Messages.message_mirroringStatus, null);
        TreeSet<IArtifactKey> toMirror = new TreeSet<IArtifactKey>(Comparator.comparing(IArtifactKey::getId).thenComparing(Comparator.comparing(IArtifactKey::getVersion).thenComparing(IArtifactKey::getClassifier)));
        multiStatus.add(destinationMetadataRepository.executeBatch(monitor -> {
            IQueryResult result = sourceMetadataRepository.query(QueryUtil.ALL_UNITS, monitor);
            Set units = result.toUnmodifiableSet();
            destinationMetadataRepository.addInstallableUnits((Collection)units);
            for (IInstallableUnit unit : units) {
                toMirror.addAll(unit.getArtifacts());
            }
        }, null));
        multiStatus.add(destinationArtifactRepository.executeBatch(monitor -> {
            Mirroring mirroring = new Mirroring(sourceArtifactRepository, destinationArtifactRepository, true);
            mirroring.setCompare(false);
            mirroring.setValidate(false);
            mirroring.setTransport((Transport)this.agent.getService(Transport.class));
            IArtifactKey[] keys = (IArtifactKey[])toMirror.toArray(IArtifactKey[]::new);
            mirroring.setArtifactKeys(keys);
            multiStatus.addAll((IStatus)mirroring.run(false, false));
        }, null));
        if (!multiStatus.isOK()) {
            String logMessage = StatusTool.toLogMessage((IStatus)multiStatus);
            if (multiStatus.getSeverity() == 1) {
                this.logger.info(logMessage, StatusTool.findException((IStatus)multiStatus));
            } else if (multiStatus.getSeverity() == 2) {
                this.logger.warn(logMessage, StatusTool.findException((IStatus)multiStatus));
            }
            throw new FacadeException(logMessage, new CoreException((IStatus)multiStatus));
        }
        this.writeP2Index(repositoryDestination);
        this.compressXml(repositoryDestination, "artifacts");
        this.compressXml(repositoryDestination, "content");
        try {
            XZCompressor xzCompressor = new XZCompressor();
            xzCompressor.setPreserveOriginalFile(true);
            xzCompressor.setRepoFolder(repositoryDestination.getAbsolutePath());
            xzCompressor.compressRepo();
        }
        catch (IOException e) {
            throw new FacadeException("XZ compression failed", e);
        }
    }

    private void writeP2Index(File repositoryDestination) throws FacadeException {
        Properties properties = new Properties();
        properties.setProperty("version", "1");
        properties.setProperty("artifact.repository.factory.order", "artifacts.xml,!");
        properties.setProperty("metadata.repository.factory.order", "content.xml,!");
        try {
            ReproducibleUtils.storeProperties((Properties)properties, (Path)new File(repositoryDestination, P2_INDEX_FILE).toPath());
        }
        catch (IOException e) {
            throw new FacadeException("writing index file failed", e);
        }
    }

    private void compressXml(File repositoryDestination, String name) throws FacadeException {
        File jarFile = new File(repositoryDestination, name + ".jar");
        File xmlFile = new File(repositoryDestination, name + ".xml");
        try (JarOutputStream jarOutputStream = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(jarFile)));){
            jarOutputStream.putNextEntry(new JarEntry(xmlFile.getName()));
            Files.copy(xmlFile.toPath(), jarOutputStream);
        }
        catch (IOException e) {
            throw new FacadeException("compression failed", e);
        }
    }

    static class LogListener
    implements IArtifactMirrorLog {
        private static final String MIRROR_TOOL_MESSAGE_PREFIX = "Mirror tool: ";
        private static final URI MIRROR_TOOL_MESSAGE_HELP = URI.create("https://wiki.eclipse.org/Tycho_Messages_Explained#Mirror_tool");
        private final Logger logger;
        private boolean hasLogged = false;

        LogListener(Logger logger) {
            this.logger = logger;
        }

        public void log(IArtifactDescriptor descriptor, IStatus status) {
            if (!status.isOK()) {
                this.logger.debug(MIRROR_TOOL_MESSAGE_PREFIX + StatusTool.toLogMessage((IStatus)status));
                this.hasLogged = true;
            }
        }

        public void log(IStatus status) {
            if (!status.isOK()) {
                this.logger.warn(MIRROR_TOOL_MESSAGE_PREFIX + StatusTool.toLogMessage((IStatus)status));
                this.hasLogged = true;
            }
        }

        public void showHelpForLoggedMessages() {
            if (this.hasLogged) {
                this.logger.warn("More information on the preceding warning(s) can be found here:");
                this.logger.warn("- " + String.valueOf(MIRROR_TOOL_MESSAGE_HELP));
            }
        }

        public void close() {
        }
    }

    private static final class MappingRule {
        public final String filter;
        public final String urlPattern;

        public MappingRule(String filter, String urlPattern) {
            this.filter = filter;
            this.urlPattern = urlPattern;
        }
    }
}

