/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2resolver;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.tycho.ExecutionEnvironmentResolutionHints;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.core.resolver.MavenTargetLocationFactory;
import org.eclipse.tycho.core.resolver.shared.IncludeSourceMode;
import org.eclipse.tycho.core.resolver.shared.ReferencedRepositoryMode;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.p2resolver.TargetDefinitionResolver;
import org.eclipse.tycho.p2resolver.TargetDefinitionVariableResolver;
import org.eclipse.tycho.targetplatform.TargetDefinition;
import org.eclipse.tycho.targetplatform.TargetDefinitionContent;

@Component(role=TargetDefinitionResolverService.class)
public class TargetDefinitionResolverService {
    private static final String CACHE_MISS_MESSAGE = "Target definition content cache miss: ";
    private ConcurrentMap<ResolutionArguments, CompletableFuture<TargetDefinitionContent>> resolutionCache = new ConcurrentHashMap<ResolutionArguments, CompletableFuture<TargetDefinitionContent>>();
    @Requirement
    private MavenContext mavenContext;
    @Requirement
    private MavenTargetLocationFactory dependenciesResolver;
    @Requirement
    private TargetDefinitionVariableResolver varResolver;

    public TargetDefinitionContent getTargetDefinitionContent(TargetDefinition definition, List<TargetEnvironment> environments, ExecutionEnvironmentResolutionHints jreIUs, IncludeSourceMode includeSourceMode, ReferencedRepositoryMode referencedRepositoryMode, IProvisioningAgent agent) {
        ResolutionArguments arguments = new ResolutionArguments(definition, environments, jreIUs, includeSourceMode, referencedRepositoryMode, agent);
        CompletableFuture future = this.resolutionCache.computeIfAbsent(arguments, this::resolveFromArguments);
        try {
            return (TargetDefinitionContent)future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException();
        }
        catch (ExecutionException e) {
            RuntimeException runtimeEx;
            Throwable cause = e.getCause();
            throw cause instanceof RuntimeException ? (runtimeEx = (RuntimeException)cause) : new RuntimeException(cause);
        }
    }

    private CompletableFuture<TargetDefinitionContent> resolveFromArguments(ResolutionArguments arguments) {
        this.mavenContext.getLogger().info("Resolving " + String.valueOf(arguments));
        if (this.mavenContext.getLogger().isDebugEnabled()) {
            this.debugCacheMiss(arguments);
        }
        TargetDefinitionResolver resolver = new TargetDefinitionResolver(arguments.environments, arguments.jreIUs, arguments.includeSourceMode, arguments.referencedRepositoryMode, this.mavenContext, this.dependenciesResolver, this.varResolver);
        try {
            return CompletableFuture.completedFuture(resolver.resolveContent(arguments.definition, arguments.agent));
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private void debugCacheMiss(ResolutionArguments arguments) {
        if (this.resolutionCache.isEmpty()) {
            return;
        }
        ArrayList<String> fieldsInWhichDistanceOneEntriesDiffer = new ArrayList<String>();
        for (ResolutionArguments existingKey : this.resolutionCache.keySet()) {
            List<String> differingFields = arguments.getNonEqualFields(existingKey);
            if (differingFields.size() != 1) continue;
            fieldsInWhichDistanceOneEntriesDiffer.add(differingFields.get(0));
        }
        if (fieldsInWhichDistanceOneEntriesDiffer.isEmpty()) {
            this.mavenContext.getLogger().debug("Target definition content cache miss: All entries differ in more than one parameter");
        } else {
            this.mavenContext.getLogger().debug("Target definition content cache miss: All entries differ, but there are entries which only differ in one parameter: " + String.valueOf(fieldsInWhichDistanceOneEntriesDiffer));
        }
    }

    public void setMavenContext(MavenContext mavenContext) {
        this.mavenContext = mavenContext;
    }

    public void setMavenDependenciesResolver(MavenTargetLocationFactory mavenDependenciesResolver) {
        this.dependenciesResolver = mavenDependenciesResolver;
    }

    public void setTargetDefinitionVariableResolver(TargetDefinitionVariableResolver varResolver) {
        this.varResolver = varResolver;
    }

    static <T> void addIfNonEqual(List<String> result, String stringToAdd, T left, T right) {
        if (!Objects.equals(left, right)) {
            result.add(stringToAdd);
        }
    }

    private static final class ResolutionArguments {
        final TargetDefinition definition;
        final List<TargetEnvironment> environments;
        final ExecutionEnvironmentResolutionHints jreIUs;
        final IProvisioningAgent agent;
        private IncludeSourceMode includeSourceMode;
        private ReferencedRepositoryMode referencedRepositoryMode;

        public ResolutionArguments(TargetDefinition definition, List<TargetEnvironment> environments, ExecutionEnvironmentResolutionHints jreIUs, IncludeSourceMode includeSourceMode, ReferencedRepositoryMode repositoryMode, IProvisioningAgent agent) {
            this.definition = definition;
            this.environments = environments;
            this.jreIUs = jreIUs;
            this.includeSourceMode = includeSourceMode;
            this.referencedRepositoryMode = repositoryMode;
            this.agent = agent;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.agent, this.definition, this.environments, this.jreIUs, this.includeSourceMode, this.referencedRepositoryMode});
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof ResolutionArguments)) return false;
            ResolutionArguments other = (ResolutionArguments)obj;
            if (!Objects.equals(this.jreIUs, other.jreIUs)) return false;
            if (!Objects.equals(this.definition, other.definition)) return false;
            if (!Objects.equals(this.agent, other.agent)) return false;
            if (!Objects.equals(this.environments, other.environments)) return false;
            if (!Objects.equals((Object)this.includeSourceMode, (Object)other.includeSourceMode)) return false;
            if (!Objects.equals((Object)this.referencedRepositoryMode, (Object)other.referencedRepositoryMode)) return false;
            return true;
        }

        public List<String> getNonEqualFields(ResolutionArguments other) {
            ArrayList<String> result = new ArrayList<String>();
            TargetDefinitionResolverService.addIfNonEqual(result, "target definition", this.definition, other.definition);
            TargetDefinitionResolverService.addIfNonEqual(result, "execution environment", this.jreIUs, other.jreIUs);
            TargetDefinitionResolverService.addIfNonEqual(result, "target environments", this.environments, other.environments);
            TargetDefinitionResolverService.addIfNonEqual(result, "remote p2 repository options", this.agent, other.agent);
            TargetDefinitionResolverService.addIfNonEqual(result, "include source mode", this.includeSourceMode, other.includeSourceMode);
            TargetDefinitionResolverService.addIfNonEqual(result, "include reference mode", this.referencedRepositoryMode, other.referencedRepositoryMode);
            return result;
        }

        public String toString() {
            return "target definition " + this.definition.getOrigin() + " for environments=" + String.valueOf(this.environments) + ", include source mode=" + String.valueOf((Object)this.includeSourceMode) + ", referenced repository mode =" + String.valueOf((Object)this.referencedRepositoryMode) + ", execution environment=" + String.valueOf(this.jreIUs) + " with " + String.valueOf(this.agent);
        }
    }
}

