/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2resolver;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.tycho.BuildPropertiesParser;
import org.eclipse.tycho.IArtifactFacade;
import org.eclipse.tycho.OptionalResolutionAction;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.core.publisher.TychoMavenPropertiesAdvice;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.p2.metadata.DependencyMetadataGenerator;
import org.eclipse.tycho.p2.metadata.PublisherOptions;
import org.eclipse.tycho.p2.publisher.AbstractMetadataGenerator;
import org.eclipse.tycho.p2.publisher.DependencyMetadata;
import org.eclipse.tycho.p2.publisher.DownloadStatsAdvice;
import org.eclipse.tycho.p2maven.tmp.BundlesAction;
import org.osgi.framework.BundleException;

@Component(role=DependencyMetadataGenerator.class, hint="source-bundle")
public class SourcesBundleDependencyMetadataGenerator
extends AbstractMetadataGenerator
implements DependencyMetadataGenerator {
    @Requirement
    private MavenContext mavenContext;
    @Requirement
    private BuildPropertiesParser buildPropertiesParser;

    @Override
    public DependencyMetadata generateMetadata(IArtifactFacade artifact, List<TargetEnvironment> environments, OptionalResolutionAction optionalAction, PublisherOptions options) {
        return super.generateMetadata(artifact, environments, (IPublisherInfo)new PublisherInfo(), optionalAction, options);
    }

    @Override
    protected List<IPublisherAction> getPublisherActions(IArtifactFacade artifact, List<TargetEnvironment> environments, OptionalResolutionAction optionalAction) {
        ArrayList<IPublisherAction> actions = new ArrayList<IPublisherAction>();
        String id = artifact.getArtifactId();
        String version = SourcesBundleDependencyMetadataGenerator.toCanonicalVersion(artifact.getVersion());
        try {
            Hashtable<String, Object> manifest = new Hashtable<String, Object>();
            ((Dictionary)manifest).put("Manifest-Version", "1.0");
            ((Dictionary)manifest).put("Bundle-ManifestVersion", "2");
            String sourceBundleSymbolicName = id + ".source";
            ((Dictionary)manifest).put("Bundle-SymbolicName", sourceBundleSymbolicName);
            ((Dictionary)manifest).put("Bundle-Version", version);
            ((Dictionary)manifest).put("Eclipse-SourceBundle", id + ";version=" + version + ";roots:=\".\"");
            StateObjectFactory factory = StateObjectFactory.defaultFactory;
            BundleDescription bundleDescription = factory.createBundleDescription(factory.createState(false), manifest, artifact.getLocation().getAbsolutePath(), this.createId(sourceBundleSymbolicName, version));
            bundleDescription.setUserObject(manifest);
            actions.add((IPublisherAction)new BundlesAction(this, new BundleDescription[]{bundleDescription}){

                protected void createAdviceFileAdvice(BundleDescription bundleDescription, IPublisherInfo publisherInfo) {
                }
            });
        }
        catch (BundleException e) {
            throw new RuntimeException(e);
        }
        return actions;
    }

    @Override
    protected List<IPublisherAdvice> getPublisherAdvice(IArtifactFacade artifact, PublisherOptions options) {
        ArrayList<IPublisherAdvice> advice = new ArrayList<IPublisherAdvice>();
        advice.add((IPublisherAdvice)new TychoMavenPropertiesAdvice(artifact, "sources", this.mavenContext));
        if (options.isGenerateDownloadStats()) {
            advice.add((IPublisherAdvice)new DownloadStatsAdvice());
        }
        return advice;
    }

    private static String toCanonicalVersion(String version) {
        if (version == null) {
            return null;
        }
        if (version.endsWith("-SNAPSHOT")) {
            return version.substring(0, version.length() - "-SNAPSHOT".length()) + ".qualifier";
        }
        return version;
    }

    public long createId(String sourceBundleSymbolicName, String version) {
        return (long)sourceBundleSymbolicName.hashCode() | (long)version.hashCode() << 32;
    }

    @Override
    protected BuildPropertiesParser getBuildPropertiesParser() {
        return this.buildPropertiesParser;
    }

    public void setMavenContext(MavenContext mockMavenContext) {
        this.mavenContext = mockMavenContext;
    }
}

