/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2resolver;

import java.io.File;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.ReactorProjectIdentities;
import org.eclipse.tycho.p2.metadata.P2Generator;
import org.eclipse.tycho.p2.repository.PublishingRepository;
import org.eclipse.tycho.p2.repository.module.ModuleArtifactRepository;
import org.eclipse.tycho.p2.repository.module.ModuleMetadataRepository;
import org.eclipse.tycho.p2.repository.module.PublishingRepositoryImpl;
import org.eclipse.tycho.repository.registry.facade.ReactorRepositoryManager;

@Component(role=ReactorRepositoryManager.class)
public class ReactorRepositoryManagerImpl
implements ReactorRepositoryManager {
    @Requirement
    IProvisioningAgent agent;
    @Requirement
    P2Generator p2generator;

    @Override
    public PublishingRepository getPublishingRepository(ReactorProjectIdentities project) {
        return new PublishingRepositoryImpl(this.agent, project);
    }

    @Override
    public PublishingRepository getPublishingRepository(ReactorProject project) {
        File targetDir = project.getBuildDirectory().getLocation();
        if (!ModuleMetadataRepository.canAttemptRead(targetDir) || !ModuleArtifactRepository.canAttemptRead(targetDir)) {
            try {
                this.agent.getService(Object.class);
                this.p2generator.generateMetaData((MavenProject)project.adapt(MavenProject.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getPublishingRepository(project.getIdentities());
    }
}

