/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2resolver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.IArtifactFacade;
import org.eclipse.tycho.IRawArtifactFileProvider;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.resolver.target.ArtifactTypeHelper;
import org.eclipse.tycho.core.resolver.target.FileArtifactRepository;
import org.eclipse.tycho.p2.repository.ArtifactTransferPolicies;
import org.eclipse.tycho.p2.repository.FileRepositoryArtifactProvider;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.p2.repository.MetadataIO;
import org.eclipse.tycho.p2.target.facade.PomDependencyCollector;

public class PomDependencyCollectorImpl
implements PomDependencyCollector {
    private final Logger logger;
    private Map<IInstallableUnit, IArtifactFacade> mavenInstallableUnits = new HashMap<IInstallableUnit, IArtifactFacade>();
    private Map<IArtifactFacade, IArtifactDescriptor> descriptorMap = new HashMap<IArtifactFacade, IArtifactDescriptor>();
    private ReactorProject project;
    private final List<IArtifactDescriptor> fileDescriptors = new ArrayList<IArtifactDescriptor>();
    private FileRepositoryArtifactProvider fileRepositoryArtifactProvider;
    private FileArtifactRepository artifactRepository;

    public PomDependencyCollectorImpl(Logger logger, ReactorProject project, IProvisioningAgent agent) {
        this.logger = logger;
        this.project = project;
        this.artifactRepository = new FileArtifactRepository(agent, this.fileDescriptors::iterator);
        this.fileRepositoryArtifactProvider = new FileRepositoryArtifactProvider((List<? extends IFileArtifactRepository>)Collections.singletonList(this.artifactRepository), ArtifactTransferPolicies.forLocalArtifacts());
    }

    public File getProjectLocation() {
        if (this.project != null) {
            return this.project.getBasedir();
        }
        return null;
    }

    @Override
    public Map.Entry<ArtifactKey, IArtifactDescriptor> addMavenArtifact(IArtifactFacade artifact, Collection<IInstallableUnit> installableUnits) {
        AbstractMap.SimpleEntry<ArtifactKey, IArtifactDescriptor> resultArtifactKey = null;
        for (IInstallableUnit unit : installableUnits) {
            this.mavenInstallableUnits.put(unit, artifact);
            for (IArtifactKey key : unit.getArtifacts()) {
                ArtifactKey artifactKey = ArtifactTypeHelper.toTychoArtifactKey(unit, key);
                if (artifactKey == null) continue;
                IArtifactDescriptor descriptor = FileArtifactRepository.forFile(artifact.getLocation(), key, (IArtifactRepository)this.artifactRepository);
                this.fileDescriptors.add(descriptor);
                this.descriptorMap.put(artifact, descriptor);
                resultArtifactKey = new AbstractMap.SimpleEntry<ArtifactKey, IArtifactDescriptor>(artifactKey, descriptor);
            }
        }
        return resultArtifactKey;
    }

    @Override
    public void addArtifactWithExistingMetadata(IArtifactFacade artifact, IArtifactFacade p2MetadataFile) {
        try {
            this.addMavenArtifact(artifact, this.readUnits(p2MetadataFile));
        }
        catch (IOException e) {
            throw new RuntimeException("failed to read p2 metadata", e);
        }
    }

    private Set<IInstallableUnit> readUnits(IArtifactFacade p2MetadataFile) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(p2MetadataFile.getLocation());){
            MetadataIO io = new MetadataIO();
            Set<IInstallableUnit> set = io.readXML(inputStream);
            return set;
        }
    }

    public void addMavenArtifact(IArtifactFacade artifact, Set<IInstallableUnit> units) {
        for (IInstallableUnit unit : units) {
            String classifier = unit.getProperty("maven-classifier");
            if (Objects.equals(classifier, artifact.getClassifier())) {
                this.mavenInstallableUnits.put(unit, artifact);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("P2Resolver: artifact " + new GAV(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()).toString() + " at location " + String.valueOf(artifact.getLocation()) + " resolves installable unit " + String.valueOf(new VersionedId(unit.getId(), unit.getVersion())));
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("P2Resolver: artifact " + new GAV(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()).toString() + " for installable unit " + String.valueOf(new VersionedId(unit.getId(), unit.getVersion())) + " is ignored because of classifier missmatch");
        }
    }

    LinkedHashSet<IInstallableUnit> gatherMavenInstallableUnits() {
        return new LinkedHashSet<IInstallableUnit>(this.getMavenInstallableUnits().keySet());
    }

    @Override
    public Map<IInstallableUnit, IArtifactFacade> getMavenInstallableUnits() {
        return this.mavenInstallableUnits;
    }

    IRawArtifactFileProvider getArtifactRepoOfPublishedBundles() {
        return this.fileRepositoryArtifactProvider;
    }

    @Override
    public ArtifactKey getArtifactKey(IArtifactFacade facade) {
        IArtifactDescriptor artifactDescriptor = this.descriptorMap.get(facade);
        if (artifactDescriptor == null) {
            String type = "eclipse-feature".equals(facade.getPackagingType()) ? "eclipse-feature" : "eclipse-plugin";
            return new DefaultArtifactKey(type, facade.getArtifactId(), facade.getVersion());
        }
        IArtifactKey artifactKey = artifactDescriptor.getArtifactKey();
        return new DefaultArtifactKey("eclipse-plugin", artifactKey.getId(), artifactKey.getVersion().toString());
    }
}

