/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2resolver;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.felix.resolver.util.CopyOnWriteSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.DependencyResolutionException;
import org.eclipse.tycho.ExecutionEnvironmentConfiguration;
import org.eclipse.tycho.IArtifactFacade;
import org.eclipse.tycho.IDependencyMetadata;
import org.eclipse.tycho.IllegalArtifactReferenceException;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.ReactorProjectIdentities;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironmentConfigurationStub;
import org.eclipse.tycho.core.resolver.DefaultP2ResolutionResult;
import org.eclipse.tycho.core.resolver.MetadataOnlyP2ResolutionResult;
import org.eclipse.tycho.core.resolver.P2ResolutionResult;
import org.eclipse.tycho.core.resolver.P2Resolver;
import org.eclipse.tycho.core.resolver.shared.PomDependencies;
import org.eclipse.tycho.core.resolver.target.ArtifactTypeHelper;
import org.eclipse.tycho.core.shared.LoggingProgressMonitor;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.core.shared.MultiLineLogger;
import org.eclipse.tycho.p2.resolver.ResolverException;
import org.eclipse.tycho.p2.target.facade.TargetPlatformConfigurationStub;
import org.eclipse.tycho.p2.target.facade.TargetPlatformFactory;
import org.eclipse.tycho.p2resolver.AbstractResolutionStrategy;
import org.eclipse.tycho.p2resolver.P2ResolverFactoryImpl;
import org.eclipse.tycho.p2resolver.ProjectorResolutionStrategy;
import org.eclipse.tycho.p2resolver.ResolutionDataImpl;
import org.eclipse.tycho.p2resolver.ShadowedUnitsQueryable;
import org.eclipse.tycho.p2tools.copiedfromp2.QueryableArray;
import org.eclipse.tycho.p2tools.copiedfromp2.Slicer;
import org.eclipse.tycho.targetplatform.P2TargetPlatform;
import org.eclipse.tycho.version.TychoVersion;

public class P2ResolverImpl
implements P2Resolver {
    private final MavenLogger logger;
    private final IProgressMonitor monitor;
    private final List<TargetEnvironment> environments;
    private Map<String, String> additionalFilterProperties = new HashMap<String, String>();
    private final List<IRequirement> additionalRequirements = new ArrayList<IRequirement>();
    private TargetPlatformFactory targetPlatformFactory;
    private PomDependencies pomDependencies = PomDependencies.ignore;
    private P2ResolverFactoryImpl p2ResolverFactoryImpl;

    public P2ResolverImpl(TargetPlatformFactory targetPlatformFactory, P2ResolverFactoryImpl p2ResolverFactoryImpl, MavenLogger logger, Collection<TargetEnvironment> environments) {
        this.targetPlatformFactory = targetPlatformFactory;
        this.p2ResolverFactoryImpl = p2ResolverFactoryImpl;
        this.logger = logger;
        this.monitor = new LoggingProgressMonitor(logger);
        this.environments = List.copyOf(environments);
    }

    @Override
    public Map<TargetEnvironment, P2ResolutionResult> resolveTargetDependencies(TargetPlatform context, ReactorProject project) {
        final P2TargetPlatform targetPlatform = P2ResolverImpl.getTargetFromContext(context);
        if (project != null && "eclipse-test-plugin".equals(project.getPackaging())) {
            P2ResolverImpl.addDependenciesForTests(this.additionalRequirements::add);
        }
        LinkedHashMap<TargetEnvironment, P2ResolutionResult> results = new LinkedHashMap<TargetEnvironment, P2ResolutionResult>();
        LinkedHashSet<IInstallableUnit> usedTargetPlatformUnits = new LinkedHashSet<IInstallableUnit>();
        CopyOnWriteSet usedShadowedUnits = new CopyOnWriteSet();
        for (TargetEnvironment environment : this.environments) {
            results.put(environment, this.resolveDependencies(Collections.emptySet(), project, new ProjectorResolutionStrategy(this, this.logger, (Set)usedShadowedUnits){
                final /* synthetic */ Set val$usedShadowedUnits;
                {
                    this.val$usedShadowedUnits = set;
                    super(logger);
                }

                @Override
                protected Slicer newSlicer(IQueryable<IInstallableUnit> availableUnits, Map<String, String> properties) {
                    return super.newSlicer(new ShadowedUnitsQueryable(targetPlatform, availableUnits, this.val$usedShadowedUnits), properties);
                }
            }, environment, targetPlatform, usedTargetPlatformUnits));
        }
        targetPlatform.reportUsedLocalIUs(usedTargetPlatformUnits);
        for (IInstallableUnit unit : usedShadowedUnits) {
            this.logger.warn("Your build strictly depends on unit " + String.valueOf(unit) + " that is shadowed by a reactor project, this can lead to unexpected build results!");
        }
        return results;
    }

    @Override
    public Map<TargetEnvironment, P2ResolutionResult> resolveArtifactDependencies(TargetPlatform context, Collection<? extends ArtifactKey> artifacts) {
        P2TargetPlatform targetPlatform = P2ResolverImpl.getTargetFromContext(context);
        ArrayList<IInstallableUnit> roots = new ArrayList<IInstallableUnit>();
        QueryableArray queriable = new QueryableArray(targetPlatform.getInstallableUnits());
        for (ArtifactKey artifactKey : artifacts) {
            VersionRange range = new VersionRange(artifactKey.getVersion());
            IQuery<IInstallableUnit> query = ArtifactTypeHelper.createQueryFor(artifactKey.getType(), artifactKey.getId(), range);
            IQueryResult result = queriable.query(QueryUtil.createLatestQuery(query), this.monitor);
            roots.addAll(result.toUnmodifiableSet());
        }
        LinkedHashMap<TargetEnvironment, P2ResolutionResult> results = new LinkedHashMap<TargetEnvironment, P2ResolutionResult>();
        for (TargetEnvironment environment : this.environments) {
            results.put(environment, this.resolveDependencies(roots, null, new ProjectorResolutionStrategy(this.logger), environment, targetPlatform, null));
        }
        return results;
    }

    @Override
    public P2ResolutionResult resolveMetadata(TargetPlatformConfigurationStub tpConfiguration, ExecutionEnvironmentConfiguration eeConfig) {
        P2TargetPlatform contextImpl = (P2TargetPlatform)this.targetPlatformFactory.createTargetPlatform(tpConfiguration, eeConfig, null);
        ResolutionDataImpl data = new ResolutionDataImpl(contextImpl.getEEResolutionHints());
        data.setAvailableIUs(contextImpl.getInstallableUnits());
        data.setRootIUs(new HashSet<IInstallableUnit>());
        data.setAdditionalRequirements(this.additionalRequirements);
        ProjectorResolutionStrategy strategy = new ProjectorResolutionStrategy(this.logger);
        strategy.setData(data);
        MetadataOnlyP2ResolutionResult result = new MetadataOnlyP2ResolutionResult();
        try {
            for (IInstallableUnit iu : strategy.multiPlatformResolve(this.environments, this.monitor)) {
                result.addArtifact("p2-installable-unit", iu.getId(), iu.getVersion().toString(), iu);
            }
        }
        catch (ResolverException e) {
            this.logger.error("Resolution failed:");
            new MultiLineLogger(this.logger).error(e.getDetails(), "  ");
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public P2ResolutionResult getTargetPlatformAsResolutionResult(TargetPlatformConfigurationStub tpConfiguration, String eeName) {
        P2TargetPlatform targetPlatform = (P2TargetPlatform)this.targetPlatformFactory.createTargetPlatform(tpConfiguration, new ExecutionEnvironmentConfigurationStub(eeName), null);
        MetadataOnlyP2ResolutionResult result = new MetadataOnlyP2ResolutionResult();
        for (IInstallableUnit iu : targetPlatform.getInstallableUnits()) {
            result.addArtifact("p2-installable-unit", iu.getId(), iu.getVersion().toString(), iu);
        }
        return result;
    }

    protected P2ResolutionResult resolveDependencies(Collection<IInstallableUnit> rootUIs, ReactorProject project, AbstractResolutionStrategy strategy, TargetEnvironment environment, P2TargetPlatform targetPlatform, Set<IInstallableUnit> usedTargetPlatformUnits) {
        Collection<IInstallableUnit> newState;
        ResolutionDataImpl data = new ResolutionDataImpl(targetPlatform.getEEResolutionHints());
        LinkedHashSet availableUnits = targetPlatform.getInstallableUnits();
        if (project != null) {
            data.setRootIUs(project.getDependencyMetadata(IDependencyMetadata.DependencyMetadataType.SEED));
            Set projectSecondaryIUs = project.getDependencyMetadata(IDependencyMetadata.DependencyMetadataType.RESOLVE);
            if (!projectSecondaryIUs.isEmpty()) {
                availableUnits = new LinkedHashSet(availableUnits);
                availableUnits.addAll(projectSecondaryIUs);
            }
        } else {
            data.setRootIUs(rootUIs);
        }
        data.setAdditionalRequirements(this.additionalRequirements);
        data.setAvailableIUs(availableUnits);
        data.setAdditionalFilterProperties(this.additionalFilterProperties);
        strategy.setData(data);
        try {
            if (project != null && this.p2ResolverFactoryImpl != null && this.pomDependencies != PomDependencies.ignore) {
                data.setAdditionalUnitStore(this.p2ResolverFactoryImpl.getPomUnits().createPomQueryable(project));
            }
            newState = strategy.resolve(environment, this.monitor);
        }
        catch (ResolverException e) {
            this.logger.info(e.getSelectionContext());
            this.logger.error("Cannot resolve project dependencies:");
            new MultiLineLogger(this.logger).error(e.getDetails(), "  ");
            this.logger.error("");
            String version = TychoVersion.getTychoVersion();
            String docVersion = version.contains("-SNAPSHOT") ? "main" : version;
            this.logger.error("See https://tycho.eclipseprojects.io/doc/" + docVersion + "/Troubleshooting.html for help.");
            throw new DependencyResolutionException("Cannot resolve dependencies of " + String.valueOf(project), (Throwable)e);
        }
        if (usedTargetPlatformUnits != null) {
            usedTargetPlatformUnits.addAll(newState);
        }
        Set<IInstallableUnit> dependencyFragments = this.p2ResolverFactoryImpl == null ? Collections.emptySet() : this.p2ResolverFactoryImpl.calculateDependencyFragments(data, newState);
        return this.toResolutionResult(newState, dependencyFragments, project, targetPlatform);
    }

    private P2ResolutionResult toResolutionResult(Collection<IInstallableUnit> resolvedUnits, Collection<IInstallableUnit> dependencyFragments, ReactorProject project, P2TargetPlatform targetPlatform) {
        Set<IInstallableUnit> currentProjectUnits = P2ResolverImpl.getProjectUnits(project);
        DefaultP2ResolutionResult result = new DefaultP2ResolutionResult(dependencyFragments, targetPlatform);
        for (IInstallableUnit iu : resolvedUnits) {
            P2ResolverImpl.addUnit(result, iu, project, targetPlatform, currentProjectUnits);
        }
        result.removeEntriesWithUnknownType();
        targetPlatform.saveLocalMavenRepository();
        P2ResolverImpl.collectNonReactorIUs(result, resolvedUnits, targetPlatform, currentProjectUnits);
        return result;
    }

    private static void addUnit(DefaultP2ResolutionResult result, IInstallableUnit iu, ReactorProject project, P2TargetPlatform targetPlatform, Set<IInstallableUnit> currentProjectUnits) {
        if (currentProjectUnits.contains(iu)) {
            P2ResolverImpl.addReactorProject(result, project.getIdentities(), iu);
            return;
        }
        ReactorProjectIdentities otherProject = (ReactorProjectIdentities)targetPlatform.getOriginalReactorProjectMap().get(iu);
        if (otherProject != null) {
            P2ResolverImpl.addReactorProject(result, otherProject, iu);
            return;
        }
        IArtifactFacade mavenArtifact = (IArtifactFacade)targetPlatform.getOriginalMavenArtifactMap().get(iu);
        if (mavenArtifact != null) {
            P2ResolverImpl.addExternalMavenArtifact(result, mavenArtifact, iu);
            return;
        }
        for (IArtifactKey key : iu.getArtifacts()) {
            P2ResolverImpl.addArtifactFile(result, iu, key, targetPlatform);
        }
    }

    @Override
    public void setAdditionalFilterProperties(Map<String, String> additionalFilterProperties) {
        Objects.requireNonNull(additionalFilterProperties, "additionalFilterProperties can't be null");
        this.additionalFilterProperties = additionalFilterProperties;
    }

    @Override
    public void addDependency(String type, String id, String versionRange) throws IllegalArtifactReferenceException {
        VersionRange parsedVersionRange;
        try {
            parsedVersionRange = new VersionRange(versionRange);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArtifactReferenceException("The string \"" + versionRange + "\" is not a valid OSGi version range");
        }
        this.additionalRequirements.add(ArtifactTypeHelper.createRequirementFor(type, id, parsedVersionRange));
    }

    @Override
    public void addRequirement(IRequirement requirement) {
        this.additionalRequirements.add(requirement);
    }

    @Override
    public void addAdditionalBundleDependency(String bundleId) {
        this.additionalRequirements.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)bundleId, (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)true, (boolean)true));
    }

    public List<IRequirement> getAdditionalRequirements() {
        return this.additionalRequirements;
    }

    @Override
    public P2ResolutionResult resolveInstallableUnit(TargetPlatform context, String id, String versionRange) {
        P2TargetPlatform targetPlatform = P2ResolverImpl.getTargetFromContext(context);
        QueryableArray queriable = new QueryableArray(targetPlatform.getInstallableUnits(), false);
        VersionRange range = new VersionRange(versionRange);
        IRequirement requirement = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)range, null, (int)1, (int)Integer.MAX_VALUE, (boolean)false);
        IQueryResult result = queriable.query(QueryUtil.createLatestQuery((IQuery)QueryUtil.createMatchQuery((IExpression)requirement.getMatches(), (Object[])new Object[0])), this.monitor);
        Set newState = result.toUnmodifiableSet();
        return this.toResolutionResult(newState, Collections.emptyList(), null, targetPlatform);
    }

    private static P2TargetPlatform getTargetFromContext(TargetPlatform context) {
        Objects.requireNonNull(context, "target context can't be null");
        if (context instanceof P2TargetPlatform) {
            P2TargetPlatform p2TP = (P2TargetPlatform)context;
            return p2TP;
        }
        throw new IllegalArgumentException("invalid target context-type " + context.getClass().getName() + ", required is " + String.valueOf(P2TargetPlatform.class));
    }

    private static Set<IInstallableUnit> getProjectUnits(ReactorProject project) {
        if (project == null) {
            return Collections.emptySet();
        }
        return project.getDependencyMetadata();
    }

    private static IRequirement optionalGreedyRequirementTo(String bundleId) {
        return MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)bundleId, (VersionRange)VersionRange.emptyRange, null, (boolean)true, (boolean)true, (boolean)true);
    }

    private static boolean isPureIU(IInstallableUnit iu) {
        return Boolean.parseBoolean(iu.getProperty("org.eclipse.equinox.p2.type.iu"));
    }

    private static boolean isBundleOrFragmentWithId(IInstallableUnit iu, String id) {
        for (IProvidedCapability provided : iu.getProvidedCapabilities()) {
            if (!"osgi.bundle".equals(provided.getNamespace())) continue;
            return id.equals(provided.getName());
        }
        return false;
    }

    private static boolean isProduct(IInstallableUnit iu) {
        return Boolean.parseBoolean(iu.getProperty("org.eclipse.equinox.p2.type.product"));
    }

    private static void addExternalMavenArtifact(DefaultP2ResolutionResult result, IArtifactFacade mavenArtifact, IInstallableUnit iu) {
        String id = iu.getId();
        String version = iu.getVersion().toString();
        String mavenClassifier = iu.getProperty("maven-classifier");
        File location = mavenArtifact.getLocation();
        P2ResolverImpl.addMavenArtifact(result, iu, id, version, mavenClassifier, location);
    }

    protected static void addMavenArtifact(DefaultP2ResolutionResult result, IInstallableUnit iu, String id, String version, String mavenClassifier, File location) {
        String contributingArtifactId;
        String contributingArtifactType;
        if (P2ResolverImpl.isBundleOrFragmentWithId(iu, id)) {
            contributingArtifactType = "eclipse-plugin";
            contributingArtifactId = id;
        } else {
            String featureId = ArtifactTypeHelper.getFeatureId(iu);
            if (featureId != null) {
                contributingArtifactType = "eclipse-feature";
                contributingArtifactId = featureId;
            } else if (P2ResolverImpl.isProduct(iu)) {
                contributingArtifactType = "eclipse-product";
                contributingArtifactId = id;
            } else if (P2ResolverImpl.isPureIU(iu)) {
                contributingArtifactType = "p2-installable-unit";
                contributingArtifactId = id;
            } else {
                contributingArtifactType = null;
                contributingArtifactId = null;
            }
        }
        result.addResolvedArtifact(Optional.ofNullable(contributingArtifactId).map(artifactId -> new DefaultArtifactKey(contributingArtifactType, artifactId, version)), mavenClassifier, iu, location);
    }

    private static void collectNonReactorIUs(DefaultP2ResolutionResult result, Collection<IInstallableUnit> newState, P2TargetPlatform targetPlatform, Set<IInstallableUnit> currentProjectUnits) {
        Map reactorProjectLookup = targetPlatform.getOriginalReactorProjectMap();
        for (IInstallableUnit iu : newState) {
            if (currentProjectUnits.contains(iu) || reactorProjectLookup.get(iu) != null) continue;
            result.addNonReactorUnit(iu);
        }
    }

    private static void addReactorProject(DefaultP2ResolutionResult result, ReactorProjectIdentities project, IInstallableUnit iu) {
        String id = iu.getId();
        String version = iu.getVersion().toString();
        String mavenClassifier = iu.getProperty("maven-classifier");
        File location = project.getBasedir();
        P2ResolverImpl.addMavenArtifact(result, iu, id, version, mavenClassifier, location);
    }

    private static void addArtifactFile(DefaultP2ResolutionResult result, IInstallableUnit iu, IArtifactKey p2ArtifactKey, P2TargetPlatform context) {
        ArtifactKey artifactKey;
        String mavenClassifier = iu.getProperty("maven-classifier");
        if (mavenClassifier != null && mavenClassifier.isBlank()) {
            mavenClassifier = null;
        }
        if (mavenClassifier == null) {
            mavenClassifier = ArtifactTypeHelper.toMavenClassifier(iu);
        }
        if ((artifactKey = ArtifactTypeHelper.toTychoArtifactKey(iu, p2ArtifactKey)) != null) {
            result.addArtifact(artifactKey, mavenClassifier, iu, p2ArtifactKey);
        }
    }

    public static void addDependenciesForTests(Consumer<IRequirement> requirementsConsumer) {
        requirementsConsumer.accept(P2ResolverImpl.optionalGreedyRequirementTo("org.eclipse.equinox.launcher"));
        requirementsConsumer.accept(P2ResolverImpl.optionalGreedyRequirementTo("org.eclipse.core.runtime"));
        requirementsConsumer.accept(P2ResolverImpl.optionalGreedyRequirementTo("org.eclipse.ui.ide.application"));
    }

    @Override
    public void setPomDependencies(PomDependencies pomDependencies) {
        this.pomDependencies = pomDependencies;
    }
}

