/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.tools.director.shared;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import org.eclipse.equinox.p2.engine.IPhaseSet;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.tycho.DependencySeed;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.p2.tools.director.shared.DirectorCommandException;

public interface DirectorRuntime {
    public Command newInstallCommand(String var1);

    public static File getDestination(File baseLocation, TargetEnvironment env) {
        if ("macosx".equals(env.getOs())) {
            if (DirectorRuntime.hasRequiredMacLayout(baseLocation)) {
                return baseLocation;
            }
            if (DirectorRuntime.isMacOsAppBundleRoot(baseLocation)) {
                return new File(baseLocation, "Contents/Eclipse/");
            }
            return new File(baseLocation, "Eclipse.app/Contents/Eclipse/");
        }
        return baseLocation;
    }

    private static boolean hasRequiredMacLayout(File folder) {
        File folder2;
        if ("Eclipse".equals(folder.getName()) && (folder2 = folder.getParentFile()) != null && "Contents".equals(folder2.getName())) {
            File parent = folder2.getParentFile();
            return parent != null && DirectorRuntime.isMacOsAppBundleRoot(parent);
        }
        return false;
    }

    private static boolean isMacOsAppBundleRoot(File folder) {
        return folder.getName().endsWith(".app");
    }

    public static interface Command {
        public void addMetadataSources(Iterable<URI> var1);

        public void addArtifactSources(Iterable<URI> var1);

        public void addUnitToInstall(String var1);

        public void addUnitToInstall(DependencySeed var1);

        public void setProfileName(String var1);

        public void setEnvironment(TargetEnvironment var1);

        public void setInstallFeatures(boolean var1);

        public void setDestination(File var1);

        public void setVerifyOnly(boolean var1);

        public void setBundlePool(File var1);

        public void execute() throws DirectorCommandException;

        public void setProfileProperties(Map<String, String> var1);

        public Map<String, String> getProfileProperties();

        public void setPhaseSet(IPhaseSet var1);

        public void setInstallSources(boolean var1);

        public void setEEUnits(Collection<IInstallableUnit> var1);
    }
}

