/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.resolver;

import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.director.Explanation;
import org.eclipse.tycho.helper.StatusTool;

public class ResolverException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final String details;
    private final String selectionContext;
    private Collection<Explanation> explanation;

    public ResolverException(String msg, Throwable cause) {
        super(msg, cause);
        this.selectionContext = "N/A";
        this.details = "N/A";
    }

    public ResolverException(Collection<Explanation> explanation, String selectionContext, Throwable cause) {
        this(explanation.stream().map(Object::toString).collect(Collectors.joining("\n")), selectionContext, cause);
        this.explanation = explanation;
    }

    public ResolverException(String details, String selectionContext, Throwable cause) {
        super("See log for details", cause);
        this.details = details;
        this.selectionContext = selectionContext;
    }

    public ResolverException(IStatus status) {
        super("See log for details", StatusTool.findException((IStatus)status));
        this.details = StatusTool.toLogMessage((IStatus)status);
        this.selectionContext = "N/A";
    }

    public String getDetails() {
        return this.details;
    }

    public String getSelectionContext() {
        return this.selectionContext;
    }

    public Stream<Explanation> explanations() {
        return this.explanation.stream();
    }

    public static ResolverException findResolverException(Throwable t) {
        if (t != null) {
            if (t instanceof ResolverException) {
                ResolverException re = (ResolverException)t;
                return re;
            }
            for (Throwable sup : t.getSuppressed()) {
                if (!(sup instanceof ResolverException)) continue;
                ResolverException re = (ResolverException)sup;
                return re;
            }
            return ResolverException.findResolverException(t.getCause());
        }
        return null;
    }
}

