/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.resolver;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.publisher.eclipse.FeatureParser;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.tycho.core.resolver.target.FileArtifactRepository;
import org.eclipse.tycho.core.resolver.target.SupplierMetadataRepository;
import org.eclipse.tycho.p2.resolver.FeaturePublisher;
import org.eclipse.tycho.p2.resolver.ResolverException;
import org.eclipse.tycho.p2maven.tmp.BundlesAction;
import org.eclipse.tycho.targetplatform.TargetDefinitionContent;
import org.eclipse.tycho.targetplatform.TargetDefinitionResolutionException;
import org.osgi.framework.BundleException;

public class FileTargetDefinitionContent
implements TargetDefinitionContent {
    private Map<IArtifactDescriptor, IInstallableUnit> repositoryContent = new HashMap<IArtifactDescriptor, IInstallableUnit>();
    private final SupplierMetadataRepository metadataRepository;
    private final FileArtifactRepository artifactRepository;
    private File location;
    private boolean loaded;

    public FileTargetDefinitionContent(IProvisioningAgent agent, File location) {
        this.location = location;
        this.metadataRepository = new SupplierMetadataRepository(agent, () -> this.getRepositoryContent().values().iterator());
        this.metadataRepository.setLocation(location.toURI());
        this.metadataRepository.setName(location.getName());
        this.artifactRepository = new FileArtifactRepository(agent, () -> this.getRepositoryContent().keySet().iterator());
        this.artifactRepository.setName(location.getName());
        this.artifactRepository.setLocation(location.toURI());
    }

    public IMetadataRepository getMetadataRepository() {
        this.preload(null);
        return this.metadataRepository;
    }

    public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
        this.preload((IProgressMonitor)subMonitor.split(100));
        subMonitor.setWorkRemaining(100);
        return this.getMetadataRepository().query(query, (IProgressMonitor)subMonitor.split(100));
    }

    public synchronized void preload(IProgressMonitor monitor) {
        if (this.loaded) {
            return;
        }
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
            File pluginsPath = new File(this.location, "plugins");
            File featurePath = new File(this.location, "features");
            boolean hasPlugins = pluginsPath.isDirectory();
            boolean hasFeatures = featurePath.isDirectory();
            if (hasPlugins) {
                FileTargetDefinitionContent.readBundles(pluginsPath, this.repositoryContent::put, (IProgressMonitor)(hasFeatures ? subMonitor.split(100) : subMonitor), (IArtifactRepository)this.artifactRepository);
            }
            if (hasFeatures) {
                FileTargetDefinitionContent.readFeatures(featurePath, this.repositoryContent::put, (IArtifactRepository)this.artifactRepository, (IProgressMonitor)(hasPlugins ? subMonitor.split(100) : subMonitor));
            }
            if (!hasFeatures && !hasPlugins) {
                FileTargetDefinitionContent.readBundles(this.location, this.repositoryContent::put, (IProgressMonitor)subMonitor.split(100), (IArtifactRepository)this.artifactRepository);
                FileTargetDefinitionContent.readFeatures(this.location, this.repositoryContent::put, (IArtifactRepository)this.artifactRepository, (IProgressMonitor)subMonitor.split(100));
            }
        }
        catch (ResolverException e) {
            throw new TargetDefinitionResolutionException("resolving location " + String.valueOf(this.location) + " failed", (Throwable)e);
        }
        this.loaded = true;
    }

    public IArtifactRepository getArtifactRepository() {
        this.preload(null);
        return this.artifactRepository;
    }

    private Map<IArtifactDescriptor, IInstallableUnit> getRepositoryContent() {
        return this.repositoryContent;
    }

    private static void readFeatures(File path, BiConsumer<IArtifactDescriptor, IInstallableUnit> consumer, IArtifactRepository artifactRepository, IProgressMonitor monitor) {
        File[] files;
        PublisherInfo publisherInfo = new PublisherInfo();
        publisherInfo.setArtifactOptions(1);
        if (path.isDirectory() && (files = path.listFiles()) != null) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)("reading features from path " + String.valueOf(path) + "..."), (int)files.length);
            for (File featureLocation : files) {
                if (monitor.isCanceled()) break;
                String name = featureLocation.getName();
                if (name.startsWith(".") || featureLocation.isFile() && !name.toLowerCase().endsWith(".jar")) continue;
                subMonitor.subTask("Reading " + name);
                Feature feature = new FeatureParser().parse(featureLocation);
                if (feature != null) {
                    feature.setLocation(featureLocation.getAbsolutePath());
                    FeaturePublisher.publishFeatures(List.of(feature), consumer, artifactRepository, null);
                }
                subMonitor.worked(1);
            }
        }
    }

    private static void readBundles(File path, BiConsumer<IArtifactDescriptor, IInstallableUnit> consumer, IProgressMonitor monitor, IArtifactRepository artifactRepository) throws ResolverException {
        File[] files;
        PublisherInfo publisherInfo = new PublisherInfo();
        publisherInfo.setArtifactOptions(1);
        if (path.isDirectory() && (files = path.listFiles()) != null) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)("reading bundles from path " + String.valueOf(path) + "..."), (int)files.length);
            for (File bundleLocation : files) {
                if (monitor.isCanceled()) break;
                String name = bundleLocation.getName();
                if (name.startsWith(".") || bundleLocation.isFile() && !name.toLowerCase().endsWith(".jar")) continue;
                subMonitor.subTask("Reading " + name);
                try {
                    BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)bundleLocation);
                    if (bundleDescription != null) {
                        IArtifactKey key = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
                        consumer.accept(FileArtifactRepository.forFile(bundleLocation, key, artifactRepository), BundlesAction.createBundleIU((BundleDescription)bundleDescription, (IArtifactKey)key, (IPublisherInfo)publisherInfo));
                    }
                }
                catch (IOException | RuntimeException | BundleException e) {
                    throw new ResolverException("Reading " + String.valueOf(bundleLocation) + " bundle failed", e);
                }
                subMonitor.worked(1);
            }
        }
    }
}

