/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.repository.module;

import java.io.File;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.tycho.IRawArtifactFileProvider;
import org.eclipse.tycho.ReactorProjectIdentities;
import org.eclipse.tycho.WriteSessionContext;
import org.eclipse.tycho.p2.repository.PublishingRepository;
import org.eclipse.tycho.p2.repository.module.ModuleArtifactRepository;
import org.eclipse.tycho.p2.repository.module.ModuleArtifactRepositoryDelegate;
import org.eclipse.tycho.p2.repository.module.ModuleMetadataRepository;
import org.eclipse.tycho.p2.repository.module.PublishingRepositoryLoader;

public class PublishingRepositoryImpl
implements PublishingRepository {
    private final ReactorProjectIdentities project;
    private final ModuleMetadataRepository metadataRepository;
    private final ModuleArtifactRepository artifactRepository;

    public PublishingRepositoryImpl(IProvisioningAgent agent, ReactorProjectIdentities project) {
        this.project = project;
        PublishingRepositoryLoader loadHelper = new PublishingRepositoryLoader(agent, project);
        this.metadataRepository = loadHelper.getModuleMetadataRepository();
        this.artifactRepository = loadHelper.getModuleArtifactRepository();
    }

    @Override
    public ReactorProjectIdentities getProjectIdentities() {
        return this.project;
    }

    @Override
    public IMetadataRepository getMetadataRepository() {
        return this.metadataRepository;
    }

    public Set<IInstallableUnit> getInstallableUnits() {
        return this.getMetadataRepository().query(QueryUtil.ALL_UNITS, null).toSet();
    }

    @Override
    public IRawArtifactFileProvider getArtifacts() {
        return this.artifactRepository;
    }

    @Override
    public IFileArtifactRepository getArtifactRepository() {
        return this.artifactRepository;
    }

    @Override
    public IArtifactRepository getArtifactRepositoryForWriting(WriteSessionContext writeSession) {
        return new ModuleArtifactRepositoryDelegate(this.artifactRepository, writeSession);
    }

    @Override
    public void addArtifactLocation(String classifier, File artifactLocation) throws ProvisionException {
        this.artifactRepository.getArtifactsMap().add(classifier, artifactLocation);
    }

    public Map<String, File> getArtifactLocations() {
        Map<String, File> artifactLocations = this.artifactRepository.getArtifactsMap().getLocalArtifactLocations();
        artifactLocations.put("p2metadata", this.metadataRepository.getPersistenceFile());
        return artifactLocations;
    }
}

