/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.repository.module;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.tycho.ReproducibleUtils;
import org.eclipse.tycho.p2.repository.MavenRepositoryCoordinates;

class ModuleArtifactMap {
    private File mapFile;
    private final Map<String, File> artifacts = new LinkedHashMap<String, File>();
    private File automaticArtifactFolder;

    public static ModuleArtifactMap restoreInstance(File location) throws ProvisionException {
        ModuleArtifactMap instance = new ModuleArtifactMap(location);
        instance.load();
        return instance;
    }

    public static ModuleArtifactMap createInstance(File repositoryRoot) throws ProvisionException {
        return new ModuleArtifactMap(repositoryRoot);
    }

    private ModuleArtifactMap(File repositoryRoot) {
        this.mapFile = new File(repositoryRoot, "local-artifacts.properties");
        this.automaticArtifactFolder = new File(repositoryRoot, "extraArtifacts");
    }

    public File getLocalArtifactLocation(MavenRepositoryCoordinates coordinates) {
        File artifactFile = this.artifacts.get(coordinates.getClassifier());
        if (artifactFile == null) {
            throw new IllegalStateException("Classifier " + coordinates.getClassifier() + " is missing in " + this.mapFile.getAbsolutePath());
        }
        return artifactFile;
    }

    public Map<String, File> getLocalArtifactLocations() {
        return new HashMap<String, File>(this.artifacts);
    }

    public boolean contains(String classifier) {
        return this.artifacts.containsKey(classifier);
    }

    public void add(String classifier, File fileLocation) throws ProvisionException {
        if (fileLocation == null) {
            throw new NullPointerException();
        }
        File previousValue = this.artifacts.put(classifier, fileLocation);
        if (previousValue != null) {
            throw new IllegalStateException("Classifier " + classifier + " already exists in " + String.valueOf(this.mapFile));
        }
        this.store();
    }

    public File addToAutomaticLocation(String classifier, String fileExtension) throws ProvisionException {
        this.automaticArtifactFolder.mkdirs();
        File newFileLocation = new File(this.automaticArtifactFolder, classifier + "." + fileExtension);
        this.add(classifier, newFileLocation);
        return newFileLocation;
    }

    private void load() throws ProvisionException {
        this.artifacts.clear();
        try {
            Properties map = ModuleArtifactMap.loadProperties(this.mapFile);
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                String key = (String)entry.getKey();
                if ("artifact.main".equals(key)) {
                    this.artifacts.put(null, ModuleArtifactMap.localArtifactEntryToFile(entry));
                    continue;
                }
                if (!key.startsWith("artifact.attached.")) continue;
                String classifier = key.substring("artifact.attached.".length());
                this.artifacts.put(classifier, ModuleArtifactMap.localArtifactEntryToFile(entry));
            }
        }
        catch (IOException e) {
            String message = "I/O error while reading repository from " + String.valueOf(this.mapFile);
            int code = 1002;
            Status status = new Status(4, "org.eclipse.tycho.p2.maven.repository", code, message, (Throwable)e);
            throw new ProvisionException((IStatus)status);
        }
    }

    private static File localArtifactEntryToFile(Map.Entry<?, ?> entry) {
        return new File((String)entry.getValue());
    }

    private static Properties loadProperties(File propertiesFile) throws IOException {
        Properties properties = new Properties();
        try (FileInputStream propertiesStream = new FileInputStream(propertiesFile);){
            properties.load(propertiesStream);
        }
        return properties;
    }

    private void store() throws ProvisionException {
        Properties outputProperties = new Properties();
        for (Map.Entry<String, File> entry : this.artifacts.entrySet()) {
            if (entry.getKey() == null) {
                outputProperties.put("artifact.main", entry.getValue().getAbsolutePath());
                continue;
            }
            outputProperties.put("artifact.attached." + entry.getKey(), entry.getValue().getAbsolutePath());
        }
        try {
            ReproducibleUtils.storeProperties((Properties)outputProperties, (Path)this.mapFile.toPath());
        }
        catch (IOException e) {
            String message = "I/O error while writing repository to " + String.valueOf(this.mapFile);
            int code = 1003;
            Status status = new Status(4, "org.eclipse.tycho.p2.maven.repository", code, message, (Throwable)e);
            throw new ProvisionException((IStatus)status);
        }
    }
}

